/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Rect;
import android.text.MeasuredParagraph;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PrecomputedText
implements Spannable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static char LINE_FEED = '\n';
    private SpannableString mText;
    private int mStart;
    private int mEnd;
    private Params mParams;
    private ParagraphInfo[] mParagraphInfo;

    private static final PrecomputedText $$robo$$android_text_PrecomputedText$create(CharSequence text, Params params) {
        ParagraphInfo[] paraInfo = PrecomputedText.createMeasuredParagraphs(text, params, 0, text.length(), true);
        return new PrecomputedText(text, 0, text.length(), params, paraInfo);
    }

    private static final ParagraphInfo[] $$robo$$android_text_PrecomputedText$createMeasuredParagraphs(CharSequence text, Params params, int start, int end, boolean computeLayout) {
        ArrayList<ParagraphInfo> result = new ArrayList<ParagraphInfo>();
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(params);
        boolean needHyphenation = params.getBreakStrategy() != 0 && params.getHyphenationFrequency() != 0;
        int paraEnd = 0;
        int paraStart = start;
        while (paraStart < end) {
            paraEnd = TextUtils.indexOf(text, '\n', paraStart, end);
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            result.add(new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(params.getTextPaint(), text, paraStart, paraEnd, params.getTextDirection(), needHyphenation, computeLayout, null)));
            paraStart = paraEnd;
        }
        return result.toArray(new ParagraphInfo[result.size()]);
    }

    private void $$robo$$android_text_PrecomputedText$__constructor__(CharSequence text, int start, int end, Params params, ParagraphInfo[] paraInfo) {
        this.mText = new SpannableString(text, true);
        this.mStart = start;
        this.mEnd = end;
        this.mParams = params;
        this.mParagraphInfo = paraInfo;
    }

    private final CharSequence $$robo$$android_text_PrecomputedText$getText() {
        return this.mText;
    }

    private final int $$robo$$android_text_PrecomputedText$getStart() {
        return this.mStart;
    }

    private final int $$robo$$android_text_PrecomputedText$getEnd() {
        return this.mEnd;
    }

    private final Params $$robo$$android_text_PrecomputedText$getParams() {
        return this.mParams;
    }

    private final int $$robo$$android_text_PrecomputedText$getParagraphCount() {
        return this.mParagraphInfo.length;
    }

    private final int $$robo$$android_text_PrecomputedText$getParagraphStart(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return paraIndex == 0 ? this.mStart : this.getParagraphEnd(paraIndex - 1);
    }

    private final int $$robo$$android_text_PrecomputedText$getParagraphEnd(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return this.mParagraphInfo[paraIndex].paragraphEnd;
    }

    private final MeasuredParagraph $$robo$$android_text_PrecomputedText$getMeasuredParagraph(int paraIndex) {
        return this.mParagraphInfo[paraIndex].measured;
    }

    private final ParagraphInfo[] $$robo$$android_text_PrecomputedText$getParagraphInfo() {
        return this.mParagraphInfo;
    }

    private final boolean $$robo$$android_text_PrecomputedText$canUseMeasuredResult(int start, int end, TextDirectionHeuristic textDir, TextPaint paint, int strategy, int frequency) {
        TextPaint mtPaint = this.mParams.getTextPaint();
        return this.mStart == start && this.mEnd == end && this.mParams.isSameTextMetricsInternal(paint, textDir, strategy, frequency);
    }

    private final int $$robo$$android_text_PrecomputedText$findParaIndex(int pos) {
        for (int i = 0; i < this.mParagraphInfo.length; ++i) {
            if (pos >= this.mParagraphInfo[i].paragraphEnd) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("pos must be less than " + this.mParagraphInfo[this.mParagraphInfo.length - 1].paragraphEnd + ", gave " + pos);
    }

    private final float $$robo$$android_text_PrecomputedText$getWidth(int start, int end) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        if (start == end) {
            return 0.0f;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        return this.getMeasuredParagraph(paraIndex).getWidth(start - paraStart, end - paraStart);
    }

    private final void $$robo$$android_text_PrecomputedText$getBounds(int start, int end, Rect bounds) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        Preconditions.checkNotNull(bounds);
        if (start == end) {
            bounds.set(0, 0, 0, 0);
            return;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        this.getMeasuredParagraph(paraIndex).getBounds(start - paraStart, end - paraStart, bounds);
    }

    private final int $$robo$$android_text_PrecomputedText$getMemoryUsage() {
        int r = 0;
        for (int i = 0; i < this.getParagraphCount(); ++i) {
            r += this.getMeasuredParagraph(i).getMemoryUsage();
        }
        return r;
    }

    private final void $$robo$$android_text_PrecomputedText$setSpan(Object what, int start, int end, int flags) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be set to PrecomputedText.");
        }
        this.mText.setSpan(what, start, end, flags);
    }

    private final void $$robo$$android_text_PrecomputedText$removeSpan(Object what) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be removed from PrecomputedText.");
        }
        this.mText.removeSpan(what);
    }

    private final <T> T[] $$robo$$android_text_PrecomputedText$getSpans(int start, int end, Class<T> type) {
        return this.mText.getSpans(start, end, (Class)type);
    }

    private final int $$robo$$android_text_PrecomputedText$getSpanStart(Object tag) {
        return this.mText.getSpanStart(tag);
    }

    private final int $$robo$$android_text_PrecomputedText$getSpanEnd(Object tag) {
        return this.mText.getSpanEnd(tag);
    }

    private final int $$robo$$android_text_PrecomputedText$getSpanFlags(Object tag) {
        return this.mText.getSpanFlags(tag);
    }

    private final int $$robo$$android_text_PrecomputedText$nextSpanTransition(int start, int limit, Class type) {
        return this.mText.nextSpanTransition(start, limit, type);
    }

    private final int $$robo$$android_text_PrecomputedText$length() {
        return this.mText.length();
    }

    private final char $$robo$$android_text_PrecomputedText$charAt(int index) {
        return this.mText.charAt(index);
    }

    private final CharSequence $$robo$$android_text_PrecomputedText$subSequence(int start, int end) {
        return PrecomputedText.create(this.mText.subSequence(start, end), this.mParams);
    }

    private final String $$robo$$android_text_PrecomputedText$toString() {
        return this.mText.toString();
    }

    public static PrecomputedText create(CharSequence charSequence, Params params) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_text_PrecomputedText$create(java.lang.CharSequence android.text.PrecomputedText$Params ), (CharSequence)charSequence, (Params)params);
    }

    public static ParagraphInfo[] createMeasuredParagraphs(CharSequence charSequence, Params params, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createMeasuredParagraphs", $$robo$$android_text_PrecomputedText$createMeasuredParagraphs(java.lang.CharSequence android.text.PrecomputedText$Params int int boolean ), (CharSequence)charSequence, (Params)params, (int)n, (int)n2, (boolean)bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, Params params, ParagraphInfo[] paragraphInfoArray) {
        this.$$robo$$android_text_PrecomputedText$__constructor__(charSequence, n, n2, params, paragraphInfoArray);
    }

    public PrecomputedText(CharSequence charSequence, int n, int n2, Params params, ParagraphInfo[] paragraphInfoArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_PrecomputedText$__constructor__(java.lang.CharSequence int int android.text.PrecomputedText$Params android.text.PrecomputedText$ParagraphInfo[] ), this, charSequence, n, n2, params, paragraphInfoArray);
    }

    public CharSequence getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_text_PrecomputedText$getText(), this);
    }

    public int getStart() {
        return (int)InvokeDynamicSupport.bootstrap("getStart", $$robo$$android_text_PrecomputedText$getStart(), this);
    }

    public int getEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_text_PrecomputedText$getEnd(), this);
    }

    public Params getParams() {
        return InvokeDynamicSupport.bootstrap("getParams", $$robo$$android_text_PrecomputedText$getParams(), this);
    }

    public int getParagraphCount() {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphCount", $$robo$$android_text_PrecomputedText$getParagraphCount(), this);
    }

    public int getParagraphStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphStart", $$robo$$android_text_PrecomputedText$getParagraphStart(int ), this, n);
    }

    public int getParagraphEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphEnd", $$robo$$android_text_PrecomputedText$getParagraphEnd(int ), this, n);
    }

    public MeasuredParagraph getMeasuredParagraph(int n) {
        return InvokeDynamicSupport.bootstrap("getMeasuredParagraph", $$robo$$android_text_PrecomputedText$getMeasuredParagraph(int ), this, n);
    }

    public ParagraphInfo[] getParagraphInfo() {
        return InvokeDynamicSupport.bootstrap("getParagraphInfo", $$robo$$android_text_PrecomputedText$getParagraphInfo(), this);
    }

    public boolean canUseMeasuredResult(int n, int n2, TextDirectionHeuristic textDirectionHeuristic, TextPaint textPaint, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("canUseMeasuredResult", $$robo$$android_text_PrecomputedText$canUseMeasuredResult(int int android.text.TextDirectionHeuristic android.text.TextPaint int int ), this, n, n2, textDirectionHeuristic, textPaint, n3, n4);
    }

    public int findParaIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findParaIndex", $$robo$$android_text_PrecomputedText$findParaIndex(int ), this, n);
    }

    public float getWidth(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_text_PrecomputedText$getWidth(int int ), this, n, n2);
    }

    public void getBounds(int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_text_PrecomputedText$getBounds(int int android.graphics.Rect ), this, n, n2, rect);
    }

    public int getMemoryUsage() {
        return (int)InvokeDynamicSupport.bootstrap("getMemoryUsage", $$robo$$android_text_PrecomputedText$getMemoryUsage(), this);
    }

    @Override
    public void setSpan(Object object, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setSpan", $$robo$$android_text_PrecomputedText$setSpan(java.lang.Object int int int ), this, object, n, n2, n3);
    }

    @Override
    public void removeSpan(Object object) {
        InvokeDynamicSupport.bootstrap("removeSpan", $$robo$$android_text_PrecomputedText$removeSpan(java.lang.Object ), this, object);
    }

    @Override
    public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrap("getSpans", $$robo$$android_text_PrecomputedText$getSpans(int int java.lang.Class<T> ), this, n, n2, clazz);
    }

    @Override
    public int getSpanStart(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanStart", $$robo$$android_text_PrecomputedText$getSpanStart(java.lang.Object ), this, object);
    }

    @Override
    public int getSpanEnd(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanEnd", $$robo$$android_text_PrecomputedText$getSpanEnd(java.lang.Object ), this, object);
    }

    @Override
    public int getSpanFlags(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanFlags", $$robo$$android_text_PrecomputedText$getSpanFlags(java.lang.Object ), this, object);
    }

    @Override
    public int nextSpanTransition(int n, int n2, Class clazz) {
        return (int)InvokeDynamicSupport.bootstrap("nextSpanTransition", $$robo$$android_text_PrecomputedText$nextSpanTransition(int int java.lang.Class ), this, n, n2, clazz);
    }

    @Override
    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_text_PrecomputedText$length(), this);
    }

    @Override
    public char charAt(int n) {
        return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_text_PrecomputedText$charAt(int ), this, n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_text_PrecomputedText$subSequence(int int ), this, n, n2);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_PrecomputedText$toString(), this);
    }

    public /* synthetic */ PrecomputedText() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrecomputedText)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ParagraphInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int paragraphEnd;
        public MeasuredParagraph measured;

        private void $$robo$$android_text_PrecomputedText_ParagraphInfo$__constructor__(int paraEnd, MeasuredParagraph measured) {
            this.paragraphEnd = paraEnd;
            this.measured = measured;
        }

        private void __constructor__(int n, MeasuredParagraph measuredParagraph) {
            this.$$robo$$android_text_PrecomputedText_ParagraphInfo$__constructor__(n, measuredParagraph);
        }

        public ParagraphInfo(int n, MeasuredParagraph measuredParagraph) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_PrecomputedText_ParagraphInfo$__constructor__(int android.text.MeasuredParagraph ), this, n, measuredParagraph);
        }

        public /* synthetic */ ParagraphInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParagraphInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Params
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TextPaint mPaint;
        private TextDirectionHeuristic mTextDir;
        private int mBreakStrategy;
        private int mHyphenationFrequency;

        private void $$robo$$android_text_PrecomputedText_Params$__constructor__(TextPaint paint, TextDirectionHeuristic textDir, int strategy, int frequency) {
            this.mPaint = paint;
            this.mTextDir = textDir;
            this.mBreakStrategy = strategy;
            this.mHyphenationFrequency = frequency;
        }

        private final TextPaint $$robo$$android_text_PrecomputedText_Params$getTextPaint() {
            return this.mPaint;
        }

        private final TextDirectionHeuristic $$robo$$android_text_PrecomputedText_Params$getTextDirection() {
            return this.mTextDir;
        }

        private final int $$robo$$android_text_PrecomputedText_Params$getBreakStrategy() {
            return this.mBreakStrategy;
        }

        private final int $$robo$$android_text_PrecomputedText_Params$getHyphenationFrequency() {
            return this.mHyphenationFrequency;
        }

        private final boolean $$robo$$android_text_PrecomputedText_Params$isSameTextMetricsInternal(TextPaint paint, TextDirectionHeuristic textDir, int strategy, int frequency) {
            return this.mTextDir == textDir && this.mBreakStrategy == strategy && this.mHyphenationFrequency == frequency && this.mPaint.equalsForTextMeasurement(paint);
        }

        private final boolean $$robo$$android_text_PrecomputedText_Params$equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Params)) {
                return false;
            }
            Params param = (Params)o;
            return this.isSameTextMetricsInternal(param.mPaint, param.mTextDir, param.mBreakStrategy, param.mHyphenationFrequency);
        }

        private final int $$robo$$android_text_PrecomputedText_Params$hashCode() {
            return Objects.hash(Float.valueOf(this.mPaint.getTextSize()), Float.valueOf(this.mPaint.getTextScaleX()), Float.valueOf(this.mPaint.getTextSkewX()), Float.valueOf(this.mPaint.getLetterSpacing()), Float.valueOf(this.mPaint.getWordSpacing()), this.mPaint.getFlags(), this.mPaint.getTextLocales(), this.mPaint.getTypeface(), this.mPaint.getFontVariationSettings(), this.mPaint.isElegantTextHeight(), this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency);
        }

        private final String $$robo$$android_text_PrecomputedText_Params$toString() {
            return "{textSize=" + this.mPaint.getTextSize() + ", textScaleX=" + this.mPaint.getTextScaleX() + ", textSkewX=" + this.mPaint.getTextSkewX() + ", letterSpacing=" + this.mPaint.getLetterSpacing() + ", textLocale=" + this.mPaint.getTextLocales() + ", typeface=" + this.mPaint.getTypeface() + ", variationSettings=" + this.mPaint.getFontVariationSettings() + ", elegantTextHeight=" + this.mPaint.isElegantTextHeight() + ", textDir=" + this.mTextDir + ", breakStrategy=" + this.mBreakStrategy + ", hyphenationFrequency=" + this.mHyphenationFrequency + "}";
        }

        private void __constructor__(TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic, int n, int n2) {
            this.$$robo$$android_text_PrecomputedText_Params$__constructor__(textPaint, textDirectionHeuristic, n, n2);
        }

        public Params(TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_PrecomputedText_Params$__constructor__(android.text.TextPaint android.text.TextDirectionHeuristic int int ), this, textPaint, textDirectionHeuristic, n, n2);
        }

        public TextPaint getTextPaint() {
            return InvokeDynamicSupport.bootstrap("getTextPaint", $$robo$$android_text_PrecomputedText_Params$getTextPaint(), this);
        }

        public TextDirectionHeuristic getTextDirection() {
            return InvokeDynamicSupport.bootstrap("getTextDirection", $$robo$$android_text_PrecomputedText_Params$getTextDirection(), this);
        }

        public int getBreakStrategy() {
            return (int)InvokeDynamicSupport.bootstrap("getBreakStrategy", $$robo$$android_text_PrecomputedText_Params$getBreakStrategy(), this);
        }

        public int getHyphenationFrequency() {
            return (int)InvokeDynamicSupport.bootstrap("getHyphenationFrequency", $$robo$$android_text_PrecomputedText_Params$getHyphenationFrequency(), this);
        }

        public boolean isSameTextMetricsInternal(TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSameTextMetricsInternal", $$robo$$android_text_PrecomputedText_Params$isSameTextMetricsInternal(android.text.TextPaint android.text.TextDirectionHeuristic int int ), this, textPaint, textDirectionHeuristic, n, n2);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_text_PrecomputedText_Params$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_text_PrecomputedText_Params$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_PrecomputedText_Params$toString(), this);
        }

        public /* synthetic */ Params() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Params)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private TextPaint mPaint;
            private TextDirectionHeuristic mTextDir;
            private int mBreakStrategy;
            private int mHyphenationFrequency;

            private void $$robo$$android_text_PrecomputedText_Params_Builder$__constructor__(TextPaint paint) {
                this.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                this.mBreakStrategy = 1;
                this.mHyphenationFrequency = 1;
                this.mPaint = paint;
            }

            private final Builder $$robo$$android_text_PrecomputedText_Params_Builder$setBreakStrategy(int strategy) {
                this.mBreakStrategy = strategy;
                return this;
            }

            private final Builder $$robo$$android_text_PrecomputedText_Params_Builder$setHyphenationFrequency(int frequency) {
                this.mHyphenationFrequency = frequency;
                return this;
            }

            private final Builder $$robo$$android_text_PrecomputedText_Params_Builder$setTextDirection(TextDirectionHeuristic textDir) {
                this.mTextDir = textDir;
                return this;
            }

            private final Params $$robo$$android_text_PrecomputedText_Params_Builder$build() {
                return new Params(this.mPaint, this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency);
            }

            private void __constructor__(TextPaint textPaint) {
                this.$$robo$$android_text_PrecomputedText_Params_Builder$__constructor__(textPaint);
            }

            public Builder(TextPaint textPaint) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_PrecomputedText_Params_Builder$__constructor__(android.text.TextPaint ), this, textPaint);
            }

            public Builder setBreakStrategy(int n) {
                return InvokeDynamicSupport.bootstrap("setBreakStrategy", $$robo$$android_text_PrecomputedText_Params_Builder$setBreakStrategy(int ), this, n);
            }

            public Builder setHyphenationFrequency(int n) {
                return InvokeDynamicSupport.bootstrap("setHyphenationFrequency", $$robo$$android_text_PrecomputedText_Params_Builder$setHyphenationFrequency(int ), this, n);
            }

            public Builder setTextDirection(TextDirectionHeuristic textDirectionHeuristic) {
                return InvokeDynamicSupport.bootstrap("setTextDirection", $$robo$$android_text_PrecomputedText_Params_Builder$setTextDirection(android.text.TextDirectionHeuristic ), this, textDirectionHeuristic);
            }

            public Params build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_text_PrecomputedText_Params_Builder$build(), this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

