/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.AndroidBidi;
import android.text.AutoGrowArray;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import android.util.Pools;
import dalvik.annotation.optimization.CriticalNative;
import java.util.Arrays;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MeasuredParagraph
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static char OBJECT_REPLACEMENT_CHARACTER = '\ufffc';
    private static NativeAllocationRegistry sRegistry;
    private static Pools.SynchronizedPool<MeasuredParagraph> sPool;
    private Spanned mSpanned;
    private int mTextStart;
    private int mTextLength;
    private char[] mCopiedBuffer;
    private int mParaDir;
    private boolean mLtrWithoutBidi;
    private AutoGrowArray.ByteArray mLevels;
    private float mWholeWidth;
    private AutoGrowArray.FloatArray mWidths;
    private AutoGrowArray.IntArray mSpanEndCache;
    private AutoGrowArray.IntArray mFontMetrics;
    private long mNativePtr;
    private Runnable mNativeObjectCleaner;
    private TextPaint mCachedPaint;
    private Paint.FontMetricsInt mCachedFm;

    private void $$robo$$android_text_MeasuredParagraph$__constructor__() {
        this.mLevels = new AutoGrowArray.ByteArray();
        this.mWidths = new AutoGrowArray.FloatArray();
        this.mSpanEndCache = new AutoGrowArray.IntArray(4);
        this.mFontMetrics = new AutoGrowArray.IntArray(16);
        this.mNativePtr = 0L;
        this.mCachedPaint = new TextPaint();
    }

    private static final MeasuredParagraph $$robo$$android_text_MeasuredParagraph$obtain() {
        MeasuredParagraph mt = sPool.acquire();
        return mt != null ? mt : new MeasuredParagraph();
    }

    private final void $$robo$$android_text_MeasuredParagraph$recycle() {
        this.release();
        sPool.release(this);
    }

    private final void $$robo$$android_text_MeasuredParagraph$bindNativeObject(long nativePtr) {
        this.mNativePtr = nativePtr;
        this.mNativeObjectCleaner = sRegistry.registerNativeAllocation((Object)this, nativePtr);
    }

    private final void $$robo$$android_text_MeasuredParagraph$unbindNativeObject() {
        if (this.mNativePtr != 0L) {
            this.mNativeObjectCleaner.run();
            this.mNativePtr = 0L;
        }
    }

    private final void $$robo$$android_text_MeasuredParagraph$release() {
        this.reset();
        this.mLevels.clearWithReleasingLargeArray();
        this.mWidths.clearWithReleasingLargeArray();
        this.mFontMetrics.clearWithReleasingLargeArray();
        this.mSpanEndCache.clearWithReleasingLargeArray();
    }

    private final void $$robo$$android_text_MeasuredParagraph$reset() {
        this.mSpanned = null;
        this.mCopiedBuffer = null;
        this.mWholeWidth = 0.0f;
        this.mLevels.clear();
        this.mWidths.clear();
        this.mFontMetrics.clear();
        this.mSpanEndCache.clear();
        this.unbindNativeObject();
    }

    private final int $$robo$$android_text_MeasuredParagraph$getTextLength() {
        return this.mTextLength;
    }

    private final char[] $$robo$$android_text_MeasuredParagraph$getChars() {
        return this.mCopiedBuffer;
    }

    private final int $$robo$$android_text_MeasuredParagraph$getParagraphDir() {
        return this.mParaDir;
    }

    private final Layout.Directions $$robo$$android_text_MeasuredParagraph$getDirections(int start, int end) {
        if (this.mLtrWithoutBidi) {
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        int length = end - start;
        return AndroidBidi.directions(this.mParaDir, this.mLevels.getRawArray(), start, this.mCopiedBuffer, start, length);
    }

    private final float $$robo$$android_text_MeasuredParagraph$getWholeWidth() {
        return this.mWholeWidth;
    }

    private final AutoGrowArray.FloatArray $$robo$$android_text_MeasuredParagraph$getWidths() {
        return this.mWidths;
    }

    private final AutoGrowArray.IntArray $$robo$$android_text_MeasuredParagraph$getSpanEndCache() {
        return this.mSpanEndCache;
    }

    private final AutoGrowArray.IntArray $$robo$$android_text_MeasuredParagraph$getFontMetrics() {
        return this.mFontMetrics;
    }

    private final long $$robo$$android_text_MeasuredParagraph$getNativePtr() {
        return this.mNativePtr;
    }

    private final float $$robo$$android_text_MeasuredParagraph$getWidth(int start, int end) {
        if (this.mNativePtr == 0L) {
            float[] widths = this.mWidths.getRawArray();
            float r = 0.0f;
            for (int i = start; i < end; ++i) {
                r += widths[i];
            }
            return r;
        }
        return MeasuredParagraph.nGetWidth(this.mNativePtr, start, end);
    }

    private final void $$robo$$android_text_MeasuredParagraph$getBounds(int start, int end, Rect bounds) {
        MeasuredParagraph.nGetBounds(this.mNativePtr, this.mCopiedBuffer, start, end, bounds);
    }

    private static final MeasuredParagraph $$robo$$android_text_MeasuredParagraph$buildForBidi(CharSequence text, int start, int end, TextDirectionHeuristic textDir, MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        return mt;
    }

    private static final MeasuredParagraph $$robo$$android_text_MeasuredParagraph$buildForMeasurement(TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir, MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        mt.mWidths.resize(mt.mTextLength);
        if (mt.mTextLength == 0) {
            return mt;
        }
        if (mt.mSpanned == null) {
            mt.applyMetricsAffectingSpan(paint, null, start, end, 0L);
        } else {
            int spanStart = start;
            while (spanStart < end) {
                int spanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                MetricAffectingSpan[] spans = mt.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                spans = TextUtils.removeEmptySpans(spans, mt.mSpanned, MetricAffectingSpan.class);
                mt.applyMetricsAffectingSpan(paint, spans, spanStart, spanEnd, 0L);
                spanStart = spanEnd;
            }
        }
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MeasuredParagraph $$robo$$android_text_MeasuredParagraph$buildForStaticLayout(TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir, boolean computeHyphenation, boolean computeLayout, MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        if (mt.mTextLength == 0) {
            long nativeBuilderPtr = MeasuredParagraph.nInitBuilder();
            try {
                mt.bindNativeObject(MeasuredParagraph.nBuildNativeMeasuredParagraph(nativeBuilderPtr, mt.mCopiedBuffer, computeHyphenation, computeLayout));
            }
            finally {
                MeasuredParagraph.nFreeBuilder(nativeBuilderPtr);
            }
            return mt;
        }
        long nativeBuilderPtr = MeasuredParagraph.nInitBuilder();
        try {
            if (mt.mSpanned == null) {
                mt.applyMetricsAffectingSpan(paint, null, start, end, nativeBuilderPtr);
                mt.mSpanEndCache.append(end);
            } else {
                int spanStart = start;
                while (spanStart < end) {
                    int spanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                    MetricAffectingSpan[] spans = mt.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, mt.mSpanned, MetricAffectingSpan.class);
                    mt.applyMetricsAffectingSpan(paint, spans, spanStart, spanEnd, nativeBuilderPtr);
                    mt.mSpanEndCache.append(spanEnd);
                    spanStart = spanEnd;
                }
            }
            mt.bindNativeObject(MeasuredParagraph.nBuildNativeMeasuredParagraph(nativeBuilderPtr, mt.mCopiedBuffer, computeHyphenation, computeLayout));
        }
        finally {
            MeasuredParagraph.nFreeBuilder(nativeBuilderPtr);
        }
        return mt;
    }

    private final void $$robo$$android_text_MeasuredParagraph$resetAndAnalyzeBidi(CharSequence text, int start, int end, TextDirectionHeuristic textDir) {
        this.reset();
        this.mSpanned = text instanceof Spanned ? (Spanned)text : null;
        this.mTextStart = start;
        this.mTextLength = end - start;
        if (this.mCopiedBuffer == null || this.mCopiedBuffer.length != this.mTextLength) {
            this.mCopiedBuffer = new char[this.mTextLength];
        }
        TextUtils.getChars(text, start, end, this.mCopiedBuffer, 0);
        if (this.mSpanned != null) {
            ReplacementSpan[] spans = this.mSpanned.getSpans(start, end, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int startInPara = this.mSpanned.getSpanStart(spans[i]) - start;
                int endInPara = this.mSpanned.getSpanEnd(spans[i]) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > this.mTextLength) {
                    endInPara = this.mTextLength;
                }
                Arrays.fill(this.mCopiedBuffer, startInPara, endInPara, '\ufffc');
            }
        }
        if ((textDir == TextDirectionHeuristics.LTR || textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR || textDir == TextDirectionHeuristics.ANYRTL_LTR) && TextUtils.doesNotNeedBidi(this.mCopiedBuffer, 0, this.mTextLength)) {
            this.mLevels.clear();
            this.mParaDir = 1;
            this.mLtrWithoutBidi = true;
        } else {
            boolean isRtl;
            int bidiRequest = textDir == TextDirectionHeuristics.LTR ? 1 : (textDir == TextDirectionHeuristics.RTL ? -1 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? 2 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? -2 : ((isRtl = textDir.isRtl(this.mCopiedBuffer, 0, this.mTextLength)) ? -1 : 1))));
            this.mLevels.resize(this.mTextLength);
            this.mParaDir = AndroidBidi.bidi(bidiRequest, this.mCopiedBuffer, this.mLevels.getRawArray());
            this.mLtrWithoutBidi = false;
        }
    }

    private final void $$robo$$android_text_MeasuredParagraph$applyReplacementRun(ReplacementSpan replacement, int start, int end, long nativeBuilderPtr) {
        float width = replacement.getSize(this.mCachedPaint, this.mSpanned, start + this.mTextStart, end + this.mTextStart, this.mCachedFm);
        if (nativeBuilderPtr == 0L) {
            this.mWidths.set(start, width);
            if (end > start + 1) {
                Arrays.fill(this.mWidths.getRawArray(), start + 1, end, 0.0f);
            }
            this.mWholeWidth += width;
        } else {
            MeasuredParagraph.nAddReplacementRun(nativeBuilderPtr, this.mCachedPaint.getNativeInstance(), start, end, width);
        }
    }

    private final void $$robo$$android_text_MeasuredParagraph$applyStyleRun(int start, int end, long nativeBuilderPtr) {
        if (this.mLtrWithoutBidi) {
            if (nativeBuilderPtr == 0L) {
                this.mWholeWidth += this.mCachedPaint.getTextRunAdvances(this.mCopiedBuffer, start, end - start, start, end - start, false, this.mWidths.getRawArray(), start);
            } else {
                MeasuredParagraph.nAddStyleRun(nativeBuilderPtr, this.mCachedPaint.getNativeInstance(), start, end, false);
            }
        } else {
            byte level = this.mLevels.get(start);
            int levelStart = start;
            int levelEnd = start + 1;
            while (true) {
                if (levelEnd == end || this.mLevels.get(levelEnd) != level) {
                    boolean isRtl;
                    boolean bl = isRtl = (level & 1) != 0;
                    if (nativeBuilderPtr == 0L) {
                        int levelLength = levelEnd - levelStart;
                        this.mWholeWidth += this.mCachedPaint.getTextRunAdvances(this.mCopiedBuffer, levelStart, levelLength, levelStart, levelLength, isRtl, this.mWidths.getRawArray(), levelStart);
                    } else {
                        MeasuredParagraph.nAddStyleRun(nativeBuilderPtr, this.mCachedPaint.getNativeInstance(), levelStart, levelEnd, isRtl);
                    }
                    if (levelEnd == end) break;
                    levelStart = levelEnd;
                    level = this.mLevels.get(levelEnd);
                }
                ++levelEnd;
            }
        }
    }

    private final void $$robo$$android_text_MeasuredParagraph$applyMetricsAffectingSpan(TextPaint paint, MetricAffectingSpan[] spans, int start, int end, long nativeBuilderPtr) {
        boolean needFontMetrics;
        this.mCachedPaint.set(paint);
        this.mCachedPaint.baselineShift = 0;
        boolean bl = needFontMetrics = nativeBuilderPtr != 0L;
        if (needFontMetrics && this.mCachedFm == null) {
            this.mCachedFm = new Paint.FontMetricsInt();
        }
        ReplacementSpan replacement = null;
        if (spans != null) {
            for (int i = 0; i < spans.length; ++i) {
                MetricAffectingSpan span = spans[i];
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateMeasureState(this.mCachedPaint);
            }
        }
        int startInCopiedBuffer = start - this.mTextStart;
        int endInCopiedBuffer = end - this.mTextStart;
        if (nativeBuilderPtr != 0L) {
            this.mCachedPaint.getFontMetricsInt(this.mCachedFm);
        }
        if (replacement != null) {
            this.applyReplacementRun(replacement, startInCopiedBuffer, endInCopiedBuffer, nativeBuilderPtr);
        } else {
            this.applyStyleRun(startInCopiedBuffer, endInCopiedBuffer, nativeBuilderPtr);
        }
        if (needFontMetrics) {
            if (this.mCachedPaint.baselineShift < 0) {
                this.mCachedFm.ascent += this.mCachedPaint.baselineShift;
                this.mCachedFm.top += this.mCachedPaint.baselineShift;
            } else {
                this.mCachedFm.descent += this.mCachedPaint.baselineShift;
                this.mCachedFm.bottom += this.mCachedPaint.baselineShift;
            }
            this.mFontMetrics.append(this.mCachedFm.top);
            this.mFontMetrics.append(this.mCachedFm.bottom);
            this.mFontMetrics.append(this.mCachedFm.ascent);
            this.mFontMetrics.append(this.mCachedFm.descent);
        }
    }

    private final int $$robo$$android_text_MeasuredParagraph$breakText(int limit, boolean forwards, float width) {
        int i;
        float[] w = this.mWidths.getRawArray();
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= w[i2]) < 0.0f); ++i2) {
            }
            while (i2 > 0 && this.mCopiedBuffer[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= w[i]) < 0.0f); --i) {
        }
        while (i < limit - 1 && (this.mCopiedBuffer[i + 1] == ' ' || w[i + 1] == 0.0f)) {
            ++i;
        }
        return limit - i - 1;
    }

    private final float $$robo$$android_text_MeasuredParagraph$measure(int start, int limit) {
        float width = 0.0f;
        float[] w = this.mWidths.getRawArray();
        for (int i = start; i < limit; ++i) {
            width += w[i];
        }
        return width;
    }

    private final int $$robo$$android_text_MeasuredParagraph$getMemoryUsage() {
        return MeasuredParagraph.nGetMemoryUsage(this.mNativePtr);
    }

    private static final long $$robo$$android_text_MeasuredParagraph$nInitBuilder() {
        return 0L;
    }

    private static final void $$robo$$android_text_MeasuredParagraph$nAddStyleRun(long l, long l2, int n, int n2, boolean bl) {
    }

    private static final void $$robo$$android_text_MeasuredParagraph$nAddReplacementRun(long l, long l2, int n, int n2, float f) {
    }

    private static final long $$robo$$android_text_MeasuredParagraph$nBuildNativeMeasuredParagraph(long l, char[] cArray, boolean bl, boolean bl2) {
        return 0L;
    }

    private static final void $$robo$$android_text_MeasuredParagraph$nFreeBuilder(long l) {
    }

    @CriticalNative
    private static final float $$robo$$android_text_MeasuredParagraph$nGetWidth(long l, int n, int n2) {
        return 0.0f;
    }

    @CriticalNative
    private static final long $$robo$$android_text_MeasuredParagraph$nGetReleaseFunc() {
        return 0L;
    }

    @CriticalNative
    private static final int $$robo$$android_text_MeasuredParagraph$nGetMemoryUsage(long l) {
        return 0;
    }

    private static final void $$robo$$android_text_MeasuredParagraph$nGetBounds(long l, char[] cArray, int n, int n2, Rect rect) {
    }

    static void __staticInitializer__() {
        sRegistry = new NativeAllocationRegistry(MeasuredParagraph.class.getClassLoader(), MeasuredParagraph.nGetReleaseFunc(), 1024L);
        sPool = new Pools.SynchronizedPool(1);
    }

    private void __constructor__() {
        this.$$robo$$android_text_MeasuredParagraph$__constructor__();
    }

    public MeasuredParagraph() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_MeasuredParagraph$__constructor__(), this);
    }

    private static MeasuredParagraph obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_text_MeasuredParagraph$obtain());
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_text_MeasuredParagraph$recycle(), this);
    }

    private void bindNativeObject(long l) {
        InvokeDynamicSupport.bootstrap("bindNativeObject", $$robo$$android_text_MeasuredParagraph$bindNativeObject(long ), this, l);
    }

    private void unbindNativeObject() {
        InvokeDynamicSupport.bootstrap("unbindNativeObject", $$robo$$android_text_MeasuredParagraph$unbindNativeObject(), this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_text_MeasuredParagraph$release(), this);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_text_MeasuredParagraph$reset(), this);
    }

    public int getTextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getTextLength", $$robo$$android_text_MeasuredParagraph$getTextLength(), this);
    }

    public char[] getChars() {
        return InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_text_MeasuredParagraph$getChars(), this);
    }

    public int getParagraphDir() {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphDir", $$robo$$android_text_MeasuredParagraph$getParagraphDir(), this);
    }

    public Layout.Directions getDirections(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getDirections", $$robo$$android_text_MeasuredParagraph$getDirections(int int ), this, n, n2);
    }

    public float getWholeWidth() {
        return (float)InvokeDynamicSupport.bootstrap("getWholeWidth", $$robo$$android_text_MeasuredParagraph$getWholeWidth(), this);
    }

    public AutoGrowArray.FloatArray getWidths() {
        return InvokeDynamicSupport.bootstrap("getWidths", $$robo$$android_text_MeasuredParagraph$getWidths(), this);
    }

    public AutoGrowArray.IntArray getSpanEndCache() {
        return InvokeDynamicSupport.bootstrap("getSpanEndCache", $$robo$$android_text_MeasuredParagraph$getSpanEndCache(), this);
    }

    public AutoGrowArray.IntArray getFontMetrics() {
        return InvokeDynamicSupport.bootstrap("getFontMetrics", $$robo$$android_text_MeasuredParagraph$getFontMetrics(), this);
    }

    public long getNativePtr() {
        return (long)InvokeDynamicSupport.bootstrap("getNativePtr", $$robo$$android_text_MeasuredParagraph$getNativePtr(), this);
    }

    public float getWidth(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_text_MeasuredParagraph$getWidth(int int ), this, n, n2);
    }

    public void getBounds(int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_text_MeasuredParagraph$getBounds(int int android.graphics.Rect ), this, n, n2, rect);
    }

    public static MeasuredParagraph buildForBidi(CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic, MeasuredParagraph measuredParagraph) {
        return InvokeDynamicSupport.bootstrapStatic("buildForBidi", $$robo$$android_text_MeasuredParagraph$buildForBidi(java.lang.CharSequence int int android.text.TextDirectionHeuristic android.text.MeasuredParagraph ), (CharSequence)charSequence, (int)n, (int)n2, (TextDirectionHeuristic)textDirectionHeuristic, (MeasuredParagraph)measuredParagraph);
    }

    public static MeasuredParagraph buildForMeasurement(TextPaint textPaint, CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic, MeasuredParagraph measuredParagraph) {
        return InvokeDynamicSupport.bootstrapStatic("buildForMeasurement", $$robo$$android_text_MeasuredParagraph$buildForMeasurement(android.text.TextPaint java.lang.CharSequence int int android.text.TextDirectionHeuristic android.text.MeasuredParagraph ), (TextPaint)textPaint, (CharSequence)charSequence, (int)n, (int)n2, (TextDirectionHeuristic)textDirectionHeuristic, (MeasuredParagraph)measuredParagraph);
    }

    public static MeasuredParagraph buildForStaticLayout(TextPaint textPaint, CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic, boolean bl, boolean bl2, MeasuredParagraph measuredParagraph) {
        return InvokeDynamicSupport.bootstrapStatic("buildForStaticLayout", $$robo$$android_text_MeasuredParagraph$buildForStaticLayout(android.text.TextPaint java.lang.CharSequence int int android.text.TextDirectionHeuristic boolean boolean android.text.MeasuredParagraph ), (TextPaint)textPaint, (CharSequence)charSequence, (int)n, (int)n2, (TextDirectionHeuristic)textDirectionHeuristic, (boolean)bl, (boolean)bl2, (MeasuredParagraph)measuredParagraph);
    }

    private void resetAndAnalyzeBidi(CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic) {
        InvokeDynamicSupport.bootstrap("resetAndAnalyzeBidi", $$robo$$android_text_MeasuredParagraph$resetAndAnalyzeBidi(java.lang.CharSequence int int android.text.TextDirectionHeuristic ), this, charSequence, n, n2, textDirectionHeuristic);
    }

    private void applyReplacementRun(ReplacementSpan replacementSpan, int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("applyReplacementRun", $$robo$$android_text_MeasuredParagraph$applyReplacementRun(android.text.style.ReplacementSpan int int long ), this, replacementSpan, n, n2, l);
    }

    private void applyStyleRun(int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("applyStyleRun", $$robo$$android_text_MeasuredParagraph$applyStyleRun(int int long ), this, n, n2, l);
    }

    private void applyMetricsAffectingSpan(TextPaint textPaint, MetricAffectingSpan[] metricAffectingSpanArray, int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("applyMetricsAffectingSpan", $$robo$$android_text_MeasuredParagraph$applyMetricsAffectingSpan(android.text.TextPaint android.text.style.MetricAffectingSpan[] int int long ), this, textPaint, metricAffectingSpanArray, n, n2, l);
    }

    int breakText(int n, boolean bl, float f) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_text_MeasuredParagraph$breakText(int boolean float ), this, n, bl, f);
    }

    float measure(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measure", $$robo$$android_text_MeasuredParagraph$measure(int int ), this, n, n2);
    }

    public int getMemoryUsage() {
        return (int)InvokeDynamicSupport.bootstrap("getMemoryUsage", $$robo$$android_text_MeasuredParagraph$getMemoryUsage(), this);
    }

    private static long nInitBuilder() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInitBuilder", $$robo$$android_text_MeasuredParagraph$nInitBuilder());
    }

    private static void nAddStyleRun(long l, long l2, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nAddStyleRun", $$robo$$android_text_MeasuredParagraph$nAddStyleRun(long long int int boolean ), (long)l, (long)l2, (int)n, (int)n2, (boolean)bl);
    }

    private static void nAddReplacementRun(long l, long l2, int n, int n2, float f) {
        InvokeDynamicSupport.bootstrapStatic("nAddReplacementRun", $$robo$$android_text_MeasuredParagraph$nAddReplacementRun(long long int int float ), (long)l, (long)l2, (int)n, (int)n2, (float)f);
    }

    private static long nBuildNativeMeasuredParagraph(long l, char[] cArray, boolean bl, boolean bl2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nBuildNativeMeasuredParagraph", $$robo$$android_text_MeasuredParagraph$nBuildNativeMeasuredParagraph(long char[] boolean boolean ), (long)l, (char[])cArray, (boolean)bl, (boolean)bl2);
    }

    private static void nFreeBuilder(long l) {
        InvokeDynamicSupport.bootstrapStatic("nFreeBuilder", $$robo$$android_text_MeasuredParagraph$nFreeBuilder(long ), (long)l);
    }

    private static float nGetWidth(long l, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetWidth", $$robo$$android_text_MeasuredParagraph$nGetWidth(long int int ), (long)l, (int)n, (int)n2);
    }

    private static long nGetReleaseFunc() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetReleaseFunc", $$robo$$android_text_MeasuredParagraph$nGetReleaseFunc());
    }

    private static int nGetMemoryUsage(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetMemoryUsage", $$robo$$android_text_MeasuredParagraph$nGetMemoryUsage(long ), (long)l);
    }

    private static void nGetBounds(long l, char[] cArray, int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nGetBounds", $$robo$$android_text_MeasuredParagraph$nGetBounds(long char[] int int android.graphics.Rect ), (long)l, (char[])cArray, (int)n, (int)n2, (Rect)rect);
    }

    static {
        RobolectricInternals.classInitializing(MeasuredParagraph.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeasuredParagraph)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

