/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.annotation.SystemApi;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.mbms.FileServiceInfo;
import android.util.Base64;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DownloadRequest
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int CURRENT_VERSION = 1;
    private static String LOG_TAG = "MbmsDownloadRequest";
    public static int MAX_APP_INTENT_SIZE = 50000;
    public static int MAX_DESTINATION_URI_SIZE = 50000;
    private String fileServiceId;
    private Uri sourceUri;
    private Uri destinationUri;
    private int subscriptionId;
    private String serializedResultIntentForApp;
    private int version;
    public static Parcelable.Creator<DownloadRequest> CREATOR;

    private void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(String fileServiceId, Uri source, Uri destination, int sub, String appIntent, int version) {
        this.fileServiceId = fileServiceId;
        this.sourceUri = source;
        this.subscriptionId = sub;
        this.destinationUri = destination;
        this.serializedResultIntentForApp = appIntent;
        this.version = version;
    }

    private void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(Parcel in) {
        this.fileServiceId = in.readString();
        this.sourceUri = (Uri)in.readParcelable(this.getClass().getClassLoader());
        this.destinationUri = (Uri)in.readParcelable(this.getClass().getClassLoader());
        this.subscriptionId = in.readInt();
        this.serializedResultIntentForApp = in.readString();
        this.version = in.readInt();
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_mbms_DownloadRequest$writeToParcel(Parcel out, int flags) {
        out.writeString(this.fileServiceId);
        out.writeParcelable(this.sourceUri, flags);
        out.writeParcelable(this.destinationUri, flags);
        out.writeInt(this.subscriptionId);
        out.writeString(this.serializedResultIntentForApp);
        out.writeInt(this.version);
    }

    private final String $$robo$$android_telephony_mbms_DownloadRequest$getFileServiceId() {
        return this.fileServiceId;
    }

    private final Uri $$robo$$android_telephony_mbms_DownloadRequest$getSourceUri() {
        return this.sourceUri;
    }

    private final Uri $$robo$$android_telephony_mbms_DownloadRequest$getDestinationUri() {
        return this.destinationUri;
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$getSubscriptionId() {
        return this.subscriptionId;
    }

    private final Intent $$robo$$android_telephony_mbms_DownloadRequest$getIntentForApp() {
        try {
            return Intent.parseUri(this.serializedResultIntentForApp, 0);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private final byte[] $$robo$$android_telephony_mbms_DownloadRequest$toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteArrayOutputStream);
            SerializationDataContainer container = new SerializationDataContainer(this);
            stream.writeObject(container);
            stream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            Log.e("MbmsDownloadRequest", "Got IOException trying to serialize opaque data");
            return null;
        }
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$getVersion() {
        return this.version;
    }

    private static final int $$robo$$android_telephony_mbms_DownloadRequest$getMaxAppIntentSize() {
        return 50000;
    }

    private static final int $$robo$$android_telephony_mbms_DownloadRequest$getMaxDestinationUriSize() {
        return 50000;
    }

    private final String $$robo$$android_telephony_mbms_DownloadRequest$getHash() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not get sha256 hash object");
        }
        if (this.version >= 1) {
            digest.update(this.sourceUri.toString().getBytes(StandardCharsets.UTF_8));
            digest.update(this.destinationUri.toString().getBytes(StandardCharsets.UTF_8));
            if (this.serializedResultIntentForApp != null) {
                digest.update(this.serializedResultIntentForApp.getBytes(StandardCharsets.UTF_8));
            }
        }
        return Base64.encodeToString(digest.digest(), 10);
    }

    private final boolean $$robo$$android_telephony_mbms_DownloadRequest$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof DownloadRequest)) {
            return false;
        }
        DownloadRequest request = (DownloadRequest)o;
        return this.subscriptionId == request.subscriptionId && this.version == request.version && Objects.equals(this.fileServiceId, request.fileServiceId) && Objects.equals(this.sourceUri, request.sourceUri) && Objects.equals(this.destinationUri, request.destinationUri) && Objects.equals(this.serializedResultIntentForApp, request.serializedResultIntentForApp);
    }

    private final int $$robo$$android_telephony_mbms_DownloadRequest$hashCode() {
        return Objects.hash(this.fileServiceId, this.sourceUri, this.destinationUri, this.subscriptionId, this.serializedResultIntentForApp, this.version);
    }

    private /* synthetic */ void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(String x0, Uri x1, Uri x2, int x3, String x4, int x5, 1 x6) {
    }

    private /* synthetic */ void $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DownloadRequest>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_mbms_DownloadRequest_1$__constructor__() {
            }

            private final DownloadRequest $$robo$$android_telephony_mbms_DownloadRequest_1$createFromParcel(Parcel in) {
                return new DownloadRequest(in, null);
            }

            private final DownloadRequest[] $$robo$$android_telephony_mbms_DownloadRequest_1$newArray(int size) {
                return new DownloadRequest[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_mbms_DownloadRequest_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_1$__constructor__(), this);
            }

            @Override
            public DownloadRequest createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_mbms_DownloadRequest_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public DownloadRequest[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_mbms_DownloadRequest_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, Uri uri, Uri uri2, int n, String string3, int n2) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(string2, uri, uri2, n, string3, n2);
    }

    public DownloadRequest(String string2, Uri uri, Uri uri2, int n, String string3, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(java.lang.String android.net.Uri android.net.Uri int java.lang.String int ), this, string2, uri, uri2, n, string3, n2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(parcel);
    }

    public DownloadRequest(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_mbms_DownloadRequest$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_mbms_DownloadRequest$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public String getFileServiceId() {
        return InvokeDynamicSupport.bootstrap("getFileServiceId", $$robo$$android_telephony_mbms_DownloadRequest$getFileServiceId(), this);
    }

    public Uri getSourceUri() {
        return InvokeDynamicSupport.bootstrap("getSourceUri", $$robo$$android_telephony_mbms_DownloadRequest$getSourceUri(), this);
    }

    public Uri getDestinationUri() {
        return InvokeDynamicSupport.bootstrap("getDestinationUri", $$robo$$android_telephony_mbms_DownloadRequest$getDestinationUri(), this);
    }

    public int getSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubscriptionId", $$robo$$android_telephony_mbms_DownloadRequest$getSubscriptionId(), this);
    }

    public Intent getIntentForApp() {
        return InvokeDynamicSupport.bootstrap("getIntentForApp", $$robo$$android_telephony_mbms_DownloadRequest$getIntentForApp(), this);
    }

    public byte[] toByteArray() {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_telephony_mbms_DownloadRequest$toByteArray(), this);
    }

    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_telephony_mbms_DownloadRequest$getVersion(), this);
    }

    public static int getMaxAppIntentSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxAppIntentSize", $$robo$$android_telephony_mbms_DownloadRequest$getMaxAppIntentSize());
    }

    public static int getMaxDestinationUriSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxDestinationUriSize", $$robo$$android_telephony_mbms_DownloadRequest$getMaxDestinationUriSize());
    }

    public String getHash() {
        return InvokeDynamicSupport.bootstrap("getHash", $$robo$$android_telephony_mbms_DownloadRequest$getHash(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_mbms_DownloadRequest$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_mbms_DownloadRequest$hashCode(), this);
    }

    private /* synthetic */ void __constructor__(String string2, Uri uri, Uri uri2, int n, String string3, int n2, 1 var7_7) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(string2, uri, uri2, n, string3, n2, var7_7);
    }

    public /* synthetic */ DownloadRequest(String string2, Uri uri, Uri uri2, int n, String string3, int n2, 1 var7_7) {
        this(string2, uri, uri2, n, string3, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(java.lang.String android.net.Uri android.net.Uri int java.lang.String int android.telephony.mbms.DownloadRequest$1 ), this, string2, uri, uri2, n, string3, n2, var7_7);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_telephony_mbms_DownloadRequest$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ DownloadRequest(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest$__constructor__(android.os.Parcel android.telephony.mbms.DownloadRequest$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(DownloadRequest.class);
    }

    public /* synthetic */ DownloadRequest() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DownloadRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String fileServiceId;
        private Uri source;
        private Uri destination;
        private int subscriptionId;
        private String appIntent;
        private int version;

        private static final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$fromDownloadRequest(DownloadRequest other) {
            Builder result = new Builder(other.sourceUri, other.destinationUri).setServiceId(other.fileServiceId).setSubscriptionId(other.subscriptionId);
            result.appIntent = other.serializedResultIntentForApp;
            return result;
        }

        private static final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$fromSerializedRequest(byte[] data) {
            Builder builder;
            try {
                ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(data));
                SerializationDataContainer dataContainer = (SerializationDataContainer)stream.readObject();
                builder = new Builder(dataContainer.source, dataContainer.destination);
                builder.version = dataContainer.version;
                builder.appIntent = dataContainer.appIntent;
                builder.fileServiceId = dataContainer.fileServiceId;
                builder.subscriptionId = dataContainer.subscriptionId;
            }
            catch (IOException e) {
                Log.e("MbmsDownloadRequest", "Got IOException trying to parse opaque data");
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                Log.e("MbmsDownloadRequest", "Got ClassNotFoundException trying to parse opaque data");
                throw new IllegalArgumentException(e);
            }
            return builder;
        }

        private void $$robo$$android_telephony_mbms_DownloadRequest_Builder$__constructor__(Uri sourceUri, Uri destinationUri) {
            this.version = 1;
            if (sourceUri == null || destinationUri == null) {
                throw new IllegalArgumentException("Source and destination URIs must be non-null.");
            }
            this.source = sourceUri;
            this.destination = destinationUri;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceInfo(FileServiceInfo serviceInfo) {
            this.fileServiceId = serviceInfo.getServiceId();
            return this;
        }

        @SystemApi
        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceId(String serviceId) {
            this.fileServiceId = serviceId;
            return this;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setSubscriptionId(int subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        private final Builder $$robo$$android_telephony_mbms_DownloadRequest_Builder$setAppIntent(Intent intent) {
            this.appIntent = intent.toUri(0);
            if (this.appIntent.length() > 50000) {
                throw new IllegalArgumentException("App intent must not exceed length 50000");
            }
            return this;
        }

        private final DownloadRequest $$robo$$android_telephony_mbms_DownloadRequest_Builder$build() {
            return new DownloadRequest(this.fileServiceId, this.source, this.destination, this.subscriptionId, this.appIntent, this.version, null);
        }

        public static Builder fromDownloadRequest(DownloadRequest downloadRequest) {
            return InvokeDynamicSupport.bootstrapStatic("fromDownloadRequest", $$robo$$android_telephony_mbms_DownloadRequest_Builder$fromDownloadRequest(android.telephony.mbms.DownloadRequest ), (DownloadRequest)downloadRequest);
        }

        public static Builder fromSerializedRequest(byte[] byArray) {
            return InvokeDynamicSupport.bootstrapStatic("fromSerializedRequest", $$robo$$android_telephony_mbms_DownloadRequest_Builder$fromSerializedRequest(byte[] ), (byte[])byArray);
        }

        private void __constructor__(Uri uri, Uri uri2) {
            this.$$robo$$android_telephony_mbms_DownloadRequest_Builder$__constructor__(uri, uri2);
        }

        public Builder(Uri uri, Uri uri2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_Builder$__constructor__(android.net.Uri android.net.Uri ), this, uri, uri2);
        }

        public Builder setServiceInfo(FileServiceInfo fileServiceInfo) {
            return InvokeDynamicSupport.bootstrap("setServiceInfo", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceInfo(android.telephony.mbms.FileServiceInfo ), this, fileServiceInfo);
        }

        @SystemApi
        public Builder setServiceId(String string2) {
            return InvokeDynamicSupport.bootstrap("setServiceId", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setServiceId(java.lang.String ), this, string2);
        }

        public Builder setSubscriptionId(int n) {
            return InvokeDynamicSupport.bootstrap("setSubscriptionId", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setSubscriptionId(int ), this, n);
        }

        public Builder setAppIntent(Intent intent) {
            return InvokeDynamicSupport.bootstrap("setAppIntent", $$robo$$android_telephony_mbms_DownloadRequest_Builder$setAppIntent(android.content.Intent ), this, intent);
        }

        public DownloadRequest build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_telephony_mbms_DownloadRequest_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SerializationDataContainer
    implements Externalizable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String fileServiceId;
        private Uri source;
        private Uri destination;
        private int subscriptionId;
        private String appIntent;
        private int version;

        private void $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$__constructor__() {
        }

        private void $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$__constructor__(DownloadRequest request) {
            this.fileServiceId = request.fileServiceId;
            this.source = request.sourceUri;
            this.destination = request.destinationUri;
            this.subscriptionId = request.subscriptionId;
            this.appIntent = request.serializedResultIntentForApp;
            this.version = request.version;
        }

        private final void $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.write(this.version);
            objectOutput.writeUTF(this.fileServiceId);
            objectOutput.writeUTF(this.source.toString());
            objectOutput.writeUTF(this.destination.toString());
            objectOutput.write(this.subscriptionId);
            objectOutput.writeUTF(this.appIntent);
        }

        private final void $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$readExternal(ObjectInput objectInput) throws IOException {
            this.version = objectInput.read();
            this.fileServiceId = objectInput.readUTF();
            this.source = Uri.parse(objectInput.readUTF());
            this.destination = Uri.parse(objectInput.readUTF());
            this.subscriptionId = objectInput.read();
            this.appIntent = objectInput.readUTF();
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$__constructor__();
        }

        public SerializationDataContainer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$__constructor__(), this);
        }

        private void __constructor__(DownloadRequest downloadRequest) {
            this.$$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$__constructor__(downloadRequest);
        }

        public SerializationDataContainer(DownloadRequest downloadRequest) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$__constructor__(android.telephony.mbms.DownloadRequest ), this, downloadRequest);
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            InvokeDynamicSupport.bootstrap("writeExternal", $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$writeExternal(java.io.ObjectOutput ), this, objectOutput);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            InvokeDynamicSupport.bootstrap("readExternal", $$robo$$android_telephony_mbms_DownloadRequest_SerializationDataContainer$readExternal(java.io.ObjectInput ), this, objectInput);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SerializationDataContainer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

