/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TelephonyHistogram
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mCategory;
    private int mId;
    private int mMinTimeMs;
    private int mMaxTimeMs;
    private int mAverageTimeMs;
    private int mSampleCount;
    private int[] mInitialTimings;
    private int mBucketCount;
    private int[] mBucketEndPoints;
    private int[] mBucketCounters;
    public static int TELEPHONY_CATEGORY_RIL = 1;
    private static int RANGE_CALCULATION_COUNT = 10;
    private static int ABSENT = 0;
    private static int PRESENT = 1;
    public static Parcelable.Creator<TelephonyHistogram> CREATOR;

    private void $$robo$$android_telephony_TelephonyHistogram$__constructor__(int category, int id2, int bucketCount) {
        if (bucketCount <= 1) {
            throw new IllegalArgumentException("Invalid number of buckets");
        }
        this.mCategory = category;
        this.mId = id2;
        this.mMinTimeMs = Integer.MAX_VALUE;
        this.mMaxTimeMs = 0;
        this.mAverageTimeMs = 0;
        this.mSampleCount = 0;
        this.mInitialTimings = new int[10];
        this.mBucketCount = bucketCount;
        this.mBucketEndPoints = new int[bucketCount - 1];
        this.mBucketCounters = new int[bucketCount];
    }

    private void $$robo$$android_telephony_TelephonyHistogram$__constructor__(TelephonyHistogram th) {
        this.mCategory = th.getCategory();
        this.mId = th.getId();
        this.mMinTimeMs = th.getMinTime();
        this.mMaxTimeMs = th.getMaxTime();
        this.mAverageTimeMs = th.getAverageTime();
        this.mSampleCount = th.getSampleCount();
        this.mInitialTimings = th.getInitialTimings();
        this.mBucketCount = th.getBucketCount();
        this.mBucketEndPoints = th.getBucketEndPoints();
        this.mBucketCounters = th.getBucketCounters();
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getCategory() {
        return this.mCategory;
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getId() {
        return this.mId;
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getMinTime() {
        return this.mMinTimeMs;
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getMaxTime() {
        return this.mMaxTimeMs;
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getAverageTime() {
        return this.mAverageTimeMs;
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getSampleCount() {
        return this.mSampleCount;
    }

    private final int[] $$robo$$android_telephony_TelephonyHistogram$getInitialTimings() {
        return this.mInitialTimings;
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$getBucketCount() {
        return this.mBucketCount;
    }

    private final int[] $$robo$$android_telephony_TelephonyHistogram$getBucketEndPoints() {
        if (this.mSampleCount > 1 && this.mSampleCount < 10) {
            int[] tempEndPoints = new int[this.mBucketCount - 1];
            this.calculateBucketEndPoints(tempEndPoints);
            return tempEndPoints;
        }
        return this.getDeepCopyOfArray(this.mBucketEndPoints);
    }

    private final int[] $$robo$$android_telephony_TelephonyHistogram$getBucketCounters() {
        if (this.mSampleCount > 1 && this.mSampleCount < 10) {
            int[] tempEndPoints = new int[this.mBucketCount - 1];
            int[] tempBucketCounters = new int[this.mBucketCount];
            this.calculateBucketEndPoints(tempEndPoints);
            for (int j = 0; j < this.mSampleCount; ++j) {
                this.addToBucketCounter(tempEndPoints, tempBucketCounters, this.mInitialTimings[j]);
            }
            return tempBucketCounters;
        }
        return this.getDeepCopyOfArray(this.mBucketCounters);
    }

    private final int[] $$robo$$android_telephony_TelephonyHistogram$getDeepCopyOfArray(int[] array2) {
        int[] clone = new int[array2.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)array2, (int)0, (Object)clone, (int)0, (int)array2.length);
        return clone;
    }

    private final void $$robo$$android_telephony_TelephonyHistogram$addToBucketCounter(int[] bucketEndPoints, int[] bucketCounters, int time) {
        int i;
        for (i = 0; i < bucketEndPoints.length; ++i) {
            if (time > bucketEndPoints[i]) continue;
            int n = i;
            bucketCounters[n] = bucketCounters[n] + 1;
            return;
        }
        int n = i;
        bucketCounters[n] = bucketCounters[n] + 1;
    }

    private final void $$robo$$android_telephony_TelephonyHistogram$calculateBucketEndPoints(int[] bucketEndPoints) {
        for (int i = 1; i < this.mBucketCount; ++i) {
            int endPt;
            bucketEndPoints[i - 1] = endPt = this.mMinTimeMs + i * (this.mMaxTimeMs - this.mMinTimeMs) / this.mBucketCount;
        }
    }

    private final void $$robo$$android_telephony_TelephonyHistogram$addTimeTaken(int time) {
        if (this.mSampleCount == 0 || this.mSampleCount == Integer.MAX_VALUE) {
            if (this.mSampleCount == 0) {
                this.mMinTimeMs = time;
                this.mMaxTimeMs = time;
                this.mAverageTimeMs = time;
            } else {
                this.mInitialTimings = new int[10];
            }
            this.mSampleCount = 1;
            Arrays.fill(this.mInitialTimings, 0);
            this.mInitialTimings[0] = time;
            Arrays.fill(this.mBucketEndPoints, 0);
            Arrays.fill(this.mBucketCounters, 0);
        } else {
            if (time < this.mMinTimeMs) {
                this.mMinTimeMs = time;
            }
            if (time > this.mMaxTimeMs) {
                this.mMaxTimeMs = time;
            }
            long totalTime = (long)this.mAverageTimeMs * (long)this.mSampleCount + (long)time;
            this.mAverageTimeMs = (int)(totalTime / (long)(++this.mSampleCount));
            if (this.mSampleCount < 10) {
                this.mInitialTimings[this.mSampleCount - 1] = time;
            } else if (this.mSampleCount == 10) {
                this.mInitialTimings[this.mSampleCount - 1] = time;
                this.calculateBucketEndPoints(this.mBucketEndPoints);
                for (int j = 0; j < 10; ++j) {
                    this.addToBucketCounter(this.mBucketEndPoints, this.mBucketCounters, this.mInitialTimings[j]);
                }
                this.mInitialTimings = null;
            } else {
                this.addToBucketCounter(this.mBucketEndPoints, this.mBucketCounters, time);
            }
        }
    }

    private final String $$robo$$android_telephony_TelephonyHistogram$toString() {
        int i;
        String basic = " Histogram id = " + this.mId + " Time(ms): min = " + this.mMinTimeMs + " max = " + this.mMaxTimeMs + " avg = " + this.mAverageTimeMs + " Count = " + this.mSampleCount;
        if (this.mSampleCount < 10) {
            return basic;
        }
        StringBuffer intervals = new StringBuffer(" Interval Endpoints:");
        for (i = 0; i < this.mBucketEndPoints.length; ++i) {
            intervals.append(" " + this.mBucketEndPoints[i]);
        }
        intervals.append(" Interval counters:");
        for (i = 0; i < this.mBucketCounters.length; ++i) {
            intervals.append(" " + this.mBucketCounters[i]);
        }
        return basic + intervals;
    }

    private void $$robo$$android_telephony_TelephonyHistogram$__constructor__(Parcel in) {
        this.mCategory = in.readInt();
        this.mId = in.readInt();
        this.mMinTimeMs = in.readInt();
        this.mMaxTimeMs = in.readInt();
        this.mAverageTimeMs = in.readInt();
        this.mSampleCount = in.readInt();
        if (in.readInt() == 1) {
            this.mInitialTimings = new int[10];
            in.readIntArray(this.mInitialTimings);
        }
        this.mBucketCount = in.readInt();
        this.mBucketEndPoints = new int[this.mBucketCount - 1];
        in.readIntArray(this.mBucketEndPoints);
        this.mBucketCounters = new int[this.mBucketCount];
        in.readIntArray(this.mBucketCounters);
    }

    private final void $$robo$$android_telephony_TelephonyHistogram$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mCategory);
        out.writeInt(this.mId);
        out.writeInt(this.mMinTimeMs);
        out.writeInt(this.mMaxTimeMs);
        out.writeInt(this.mAverageTimeMs);
        out.writeInt(this.mSampleCount);
        if (this.mInitialTimings == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeIntArray(this.mInitialTimings);
        }
        out.writeInt(this.mBucketCount);
        out.writeIntArray(this.mBucketEndPoints);
        out.writeIntArray(this.mBucketCounters);
    }

    private final int $$robo$$android_telephony_TelephonyHistogram$describeContents() {
        return 0;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<TelephonyHistogram>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_TelephonyHistogram_1$__constructor__() {
            }

            private final TelephonyHistogram $$robo$$android_telephony_TelephonyHistogram_1$createFromParcel(Parcel in) {
                return new TelephonyHistogram(in);
            }

            private final TelephonyHistogram[] $$robo$$android_telephony_TelephonyHistogram_1$newArray(int size) {
                return new TelephonyHistogram[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_TelephonyHistogram_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyHistogram_1$__constructor__(), this);
            }

            @Override
            public TelephonyHistogram createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_TelephonyHistogram_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public TelephonyHistogram[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_TelephonyHistogram_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_telephony_TelephonyHistogram$__constructor__(n, n2, n3);
    }

    public TelephonyHistogram(int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyHistogram$__constructor__(int int int ), this, n, n2, n3);
    }

    private void __constructor__(TelephonyHistogram telephonyHistogram) {
        this.$$robo$$android_telephony_TelephonyHistogram$__constructor__(telephonyHistogram);
    }

    public TelephonyHistogram(TelephonyHistogram telephonyHistogram) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyHistogram$__constructor__(android.telephony.TelephonyHistogram ), this, telephonyHistogram);
    }

    public int getCategory() {
        return (int)InvokeDynamicSupport.bootstrap("getCategory", $$robo$$android_telephony_TelephonyHistogram$getCategory(), this);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_telephony_TelephonyHistogram$getId(), this);
    }

    public int getMinTime() {
        return (int)InvokeDynamicSupport.bootstrap("getMinTime", $$robo$$android_telephony_TelephonyHistogram$getMinTime(), this);
    }

    public int getMaxTime() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxTime", $$robo$$android_telephony_TelephonyHistogram$getMaxTime(), this);
    }

    public int getAverageTime() {
        return (int)InvokeDynamicSupport.bootstrap("getAverageTime", $$robo$$android_telephony_TelephonyHistogram$getAverageTime(), this);
    }

    public int getSampleCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleCount", $$robo$$android_telephony_TelephonyHistogram$getSampleCount(), this);
    }

    private int[] getInitialTimings() {
        return InvokeDynamicSupport.bootstrap("getInitialTimings", $$robo$$android_telephony_TelephonyHistogram$getInitialTimings(), this);
    }

    public int getBucketCount() {
        return (int)InvokeDynamicSupport.bootstrap("getBucketCount", $$robo$$android_telephony_TelephonyHistogram$getBucketCount(), this);
    }

    public int[] getBucketEndPoints() {
        return InvokeDynamicSupport.bootstrap("getBucketEndPoints", $$robo$$android_telephony_TelephonyHistogram$getBucketEndPoints(), this);
    }

    public int[] getBucketCounters() {
        return InvokeDynamicSupport.bootstrap("getBucketCounters", $$robo$$android_telephony_TelephonyHistogram$getBucketCounters(), this);
    }

    private int[] getDeepCopyOfArray(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDeepCopyOfArray", $$robo$$android_telephony_TelephonyHistogram$getDeepCopyOfArray(int[] ), this, nArray);
    }

    private void addToBucketCounter(int[] nArray, int[] nArray2, int n) {
        InvokeDynamicSupport.bootstrap("addToBucketCounter", $$robo$$android_telephony_TelephonyHistogram$addToBucketCounter(int[] int[] int ), this, nArray, nArray2, n);
    }

    private void calculateBucketEndPoints(int[] nArray) {
        InvokeDynamicSupport.bootstrap("calculateBucketEndPoints", $$robo$$android_telephony_TelephonyHistogram$calculateBucketEndPoints(int[] ), this, nArray);
    }

    public void addTimeTaken(int n) {
        InvokeDynamicSupport.bootstrap("addTimeTaken", $$robo$$android_telephony_TelephonyHistogram$addTimeTaken(int ), this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_TelephonyHistogram$toString(), this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_TelephonyHistogram$__constructor__(parcel);
    }

    public TelephonyHistogram(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyHistogram$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_TelephonyHistogram$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_TelephonyHistogram$describeContents(), this);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyHistogram.class);
    }

    public /* synthetic */ TelephonyHistogram() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyHistogram)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

