/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.SubscriptionManager;
import android.telephony.mbms.InternalStreamingServiceCallback;
import android.telephony.mbms.InternalStreamingSessionCallback;
import android.telephony.mbms.MbmsStreamingSessionCallback;
import android.telephony.mbms.MbmsUtils;
import android.telephony.mbms.StreamingService;
import android.telephony.mbms.StreamingServiceCallback;
import android.telephony.mbms.StreamingServiceInfo;
import android.telephony.mbms.vendor.IMbmsStreamingService;
import android.util.ArraySet;
import android.util.Log;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MbmsStreamingSession
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "MbmsStreamingSession";
    @SystemApi
    public static String MBMS_STREAMING_SERVICE_ACTION = "android.telephony.action.EmbmsStreaming";
    public static String MBMS_STREAMING_SERVICE_OVERRIDE_METADATA = "mbms-streaming-service-override";
    private static AtomicBoolean sIsInitialized;
    private AtomicReference<IMbmsStreamingService> mService;
    private IBinder.DeathRecipient mDeathRecipient;
    private InternalStreamingSessionCallback mInternalCallback;
    private Set<StreamingService> mKnownActiveStreamingServices;
    private Context mContext;
    private int mSubscriptionId;

    private void $$robo$$android_telephony_MbmsStreamingSession$__constructor__(Context context, Executor executor, int subscriptionId, MbmsStreamingSessionCallback callback) {
        this.mService = new AtomicReference<Object>(null);
        this.mDeathRecipient = new IBinder.DeathRecipient(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MbmsStreamingSession this$0;

            private void $$robo$$android_telephony_MbmsStreamingSession_1$__constructor__(MbmsStreamingSession this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_telephony_MbmsStreamingSession_1$binderDied() {
                sIsInitialized.set(false);
                this.this$0.sendErrorToApp(3, "Received death notification");
            }

            private void __constructor__(MbmsStreamingSession mbmsStreamingSession) {
                this.$$robo$$android_telephony_MbmsStreamingSession_1$__constructor__(mbmsStreamingSession);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsStreamingSession_1$__constructor__(android.telephony.MbmsStreamingSession ), this, mbmsStreamingSession);
            }

            @Override
            public void binderDied() {
                InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_telephony_MbmsStreamingSession_1$binderDied(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mKnownActiveStreamingServices = new ArraySet<StreamingService>();
        this.mSubscriptionId = -1;
        this.mContext = context;
        this.mSubscriptionId = subscriptionId;
        this.mInternalCallback = new InternalStreamingSessionCallback(callback, executor);
    }

    private static final MbmsStreamingSession $$robo$$android_telephony_MbmsStreamingSession$create(Context context, Executor executor, int subscriptionId, MbmsStreamingSessionCallback callback) {
        if (!sIsInitialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot create two instances of MbmsStreamingSession");
        }
        MbmsStreamingSession session = new MbmsStreamingSession(context, executor, subscriptionId, callback);
        int result = session.bindAndInitialize();
        if (result != 0) {
            sIsInitialized.set(false);
            executor.execute(new Runnable(callback, result){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MbmsStreamingSessionCallback val$callback;
                /* synthetic */ int val$result;

                private void $$robo$$android_telephony_MbmsStreamingSession_2$__constructor__(MbmsStreamingSessionCallback mbmsStreamingSessionCallback, int n) {
                    this.val$callback = mbmsStreamingSessionCallback;
                    this.val$result = n;
                }

                private final void $$robo$$android_telephony_MbmsStreamingSession_2$run() {
                    this.val$callback.onError(this.val$result, null);
                }

                private void __constructor__(MbmsStreamingSessionCallback mbmsStreamingSessionCallback, int n) {
                    this.$$robo$$android_telephony_MbmsStreamingSession_2$__constructor__(mbmsStreamingSessionCallback, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsStreamingSession_2$__constructor__(android.telephony.mbms.MbmsStreamingSessionCallback int ), this, mbmsStreamingSessionCallback, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telephony_MbmsStreamingSession_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return null;
        }
        return session;
    }

    private static final MbmsStreamingSession $$robo$$android_telephony_MbmsStreamingSession$create(Context context, Executor executor, MbmsStreamingSessionCallback callback) {
        return MbmsStreamingSession.create(context, executor, SubscriptionManager.getDefaultSubscriptionId(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_MbmsStreamingSession$close() {
        try {
            IMbmsStreamingService streamingService = this.mService.get();
            if (streamingService == null) {
                return;
            }
            streamingService.dispose(this.mSubscriptionId);
            for (StreamingService s : this.mKnownActiveStreamingServices) {
                s.getCallback().stop();
            }
            this.mKnownActiveStreamingServices.clear();
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.mInternalCallback.stop();
        }
    }

    private final void $$robo$$android_telephony_MbmsStreamingSession$requestUpdateStreamingServices(List<String> serviceClassList) {
        IMbmsStreamingService streamingService = this.mService.get();
        if (streamingService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int returnCode = streamingService.requestUpdateStreamingServices(this.mSubscriptionId, serviceClassList);
            if (returnCode == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (returnCode != 0) {
                this.sendErrorToApp(returnCode, null);
            }
        }
        catch (RemoteException e) {
            Log.w("MbmsStreamingSession", "Remote process died");
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    private final StreamingService $$robo$$android_telephony_MbmsStreamingSession$startStreaming(StreamingServiceInfo serviceInfo, Executor executor, StreamingServiceCallback callback) {
        IMbmsStreamingService streamingService = this.mService.get();
        if (streamingService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        InternalStreamingServiceCallback serviceCallback = new InternalStreamingServiceCallback(callback, executor);
        StreamingService serviceForApp = new StreamingService(this.mSubscriptionId, streamingService, this, serviceInfo, serviceCallback);
        this.mKnownActiveStreamingServices.add(serviceForApp);
        try {
            int returnCode = streamingService.startStreaming(this.mSubscriptionId, serviceInfo.getServiceId(), serviceCallback);
            if (returnCode == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (returnCode != 0) {
                this.sendErrorToApp(returnCode, null);
                return null;
            }
        }
        catch (RemoteException e) {
            Log.w("MbmsStreamingSession", "Remote process died");
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
            return null;
        }
        return serviceForApp;
    }

    private final void $$robo$$android_telephony_MbmsStreamingSession$onStreamingServiceStopped(StreamingService service) {
        this.mKnownActiveStreamingServices.remove(service);
    }

    private final int $$robo$$android_telephony_MbmsStreamingSession$bindAndInitialize() {
        return MbmsUtils.startBinding(this.mContext, "android.telephony.action.EmbmsStreaming", new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MbmsStreamingSession this$0;

            private void $$robo$$android_telephony_MbmsStreamingSession_3$__constructor__(MbmsStreamingSession this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_telephony_MbmsStreamingSession_3$onServiceConnected(ComponentName name, IBinder service) {
                int result;
                IMbmsStreamingService streamingService = IMbmsStreamingService.Stub.asInterface(service);
                try {
                    result = streamingService.initialize(this.this$0.mInternalCallback, this.this$0.mSubscriptionId);
                }
                catch (RemoteException e) {
                    Log.e("MbmsStreamingSession", "Service died before initialization");
                    this.this$0.sendErrorToApp(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e("MbmsStreamingSession", "Runtime exception during initialization");
                    this.this$0.sendErrorToApp(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                if (result == -1) {
                    this.this$0.close();
                    throw new IllegalStateException("Middleware must not return an unknown error code");
                }
                if (result != 0) {
                    this.this$0.sendErrorToApp(result, "Error returned during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                try {
                    streamingService.asBinder().linkToDeath(this.this$0.mDeathRecipient, 0);
                }
                catch (RemoteException e) {
                    this.this$0.sendErrorToApp(3, "Middleware lost during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                this.this$0.mService.set(streamingService);
            }

            private final void $$robo$$android_telephony_MbmsStreamingSession_3$onServiceDisconnected(ComponentName name) {
                sIsInitialized.set(false);
                this.this$0.mService.set(null);
            }

            private void __constructor__(MbmsStreamingSession mbmsStreamingSession) {
                this.$$robo$$android_telephony_MbmsStreamingSession_3$__constructor__(mbmsStreamingSession);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsStreamingSession_3$__constructor__(android.telephony.MbmsStreamingSession ), this, mbmsStreamingSession);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_telephony_MbmsStreamingSession_3$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_telephony_MbmsStreamingSession_3$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_telephony_MbmsStreamingSession$sendErrorToApp(int errorCode, String message) {
        try {
            this.mInternalCallback.onError(errorCode, message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        sIsInitialized = new AtomicBoolean(false);
    }

    private void __constructor__(Context context, Executor executor, int n, MbmsStreamingSessionCallback mbmsStreamingSessionCallback) {
        this.$$robo$$android_telephony_MbmsStreamingSession$__constructor__(context, executor, n, mbmsStreamingSessionCallback);
    }

    public MbmsStreamingSession(Context context, Executor executor, int n, MbmsStreamingSessionCallback mbmsStreamingSessionCallback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_MbmsStreamingSession$__constructor__(android.content.Context java.util.concurrent.Executor int android.telephony.mbms.MbmsStreamingSessionCallback ), this, context, executor, n, mbmsStreamingSessionCallback);
    }

    public static MbmsStreamingSession create(Context context, Executor executor, int n, MbmsStreamingSessionCallback mbmsStreamingSessionCallback) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_telephony_MbmsStreamingSession$create(android.content.Context java.util.concurrent.Executor int android.telephony.mbms.MbmsStreamingSessionCallback ), (Context)context, (Executor)executor, (int)n, (MbmsStreamingSessionCallback)mbmsStreamingSessionCallback);
    }

    public static MbmsStreamingSession create(Context context, Executor executor, MbmsStreamingSessionCallback mbmsStreamingSessionCallback) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_telephony_MbmsStreamingSession$create(android.content.Context java.util.concurrent.Executor android.telephony.mbms.MbmsStreamingSessionCallback ), (Context)context, (Executor)executor, (MbmsStreamingSessionCallback)mbmsStreamingSessionCallback);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_telephony_MbmsStreamingSession$close(), this);
    }

    public void requestUpdateStreamingServices(List<String> list) {
        InvokeDynamicSupport.bootstrap("requestUpdateStreamingServices", $$robo$$android_telephony_MbmsStreamingSession$requestUpdateStreamingServices(java.util.List<java.lang.String> ), this, list);
    }

    public StreamingService startStreaming(StreamingServiceInfo streamingServiceInfo, Executor executor, StreamingServiceCallback streamingServiceCallback) {
        return InvokeDynamicSupport.bootstrap("startStreaming", $$robo$$android_telephony_MbmsStreamingSession$startStreaming(android.telephony.mbms.StreamingServiceInfo java.util.concurrent.Executor android.telephony.mbms.StreamingServiceCallback ), this, streamingServiceInfo, executor, streamingServiceCallback);
    }

    public void onStreamingServiceStopped(StreamingService streamingService) {
        InvokeDynamicSupport.bootstrap("onStreamingServiceStopped", $$robo$$android_telephony_MbmsStreamingSession$onStreamingServiceStopped(android.telephony.mbms.StreamingService ), this, streamingService);
    }

    private int bindAndInitialize() {
        return (int)InvokeDynamicSupport.bootstrap("bindAndInitialize", $$robo$$android_telephony_MbmsStreamingSession$bindAndInitialize(), this);
    }

    private void sendErrorToApp(int n, String string2) {
        InvokeDynamicSupport.bootstrap("sendErrorToApp", $$robo$$android_telephony_MbmsStreamingSession$sendErrorToApp(int java.lang.String ), this, n, string2);
    }

    static {
        RobolectricInternals.classInitializing(MbmsStreamingSession.class);
    }

    public /* synthetic */ MbmsStreamingSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MbmsStreamingSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

