/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Session
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String START_SESSION = "START_SESSION";
    public static String START_EXTERNAL_SESSION = "START_EXTERNAL_SESSION";
    public static String CREATE_SUBSESSION = "CREATE_SUBSESSION";
    public static String CONTINUE_SUBSESSION = "CONTINUE_SUBSESSION";
    public static String END_SUBSESSION = "END_SUBSESSION";
    public static String END_SESSION = "END_SESSION";
    public static String SUBSESSION_SEPARATION_CHAR = "->";
    public static String SESSION_SEPARATION_CHAR_CHILD = "_";
    public static String EXTERNAL_INDICATOR = "E-";
    public static String TRUNCATE_STRING = "...";
    public static int UNDEFINED = -1;
    private String mSessionId;
    private String mShortMethodName;
    private long mExecutionStartTimeMs;
    private long mExecutionEndTimeMs;
    private Session mParentSession;
    private ArrayList<Session> mChildSessions;
    private boolean mIsCompleted;
    private boolean mIsExternal;
    private int mChildCounter;
    private boolean mIsStartedFromActiveSession;
    private String mOwnerInfo;
    private String mFullMethodPathCache;

    private void $$robo$$android_telecom_Logging_Session$__constructor__(String sessionId, String shortMethodName, long startTimeMs, boolean isStartedFromActiveSession, String ownerInfo) {
        this.mExecutionEndTimeMs = -1L;
        this.mIsCompleted = false;
        this.mIsExternal = false;
        this.mChildCounter = 0;
        this.mIsStartedFromActiveSession = false;
        this.setSessionId(sessionId);
        this.setShortMethodName(shortMethodName);
        this.mExecutionStartTimeMs = startTimeMs;
        this.mParentSession = null;
        this.mChildSessions = new ArrayList(5);
        this.mIsStartedFromActiveSession = isStartedFromActiveSession;
        this.mOwnerInfo = ownerInfo;
    }

    private final void $$robo$$android_telecom_Logging_Session$setSessionId(String sessionId) {
        if (sessionId == null) {
            this.mSessionId = "?";
        }
        this.mSessionId = sessionId;
    }

    private final String $$robo$$android_telecom_Logging_Session$getShortMethodName() {
        return this.mShortMethodName;
    }

    private final void $$robo$$android_telecom_Logging_Session$setShortMethodName(String shortMethodName) {
        if (shortMethodName == null) {
            shortMethodName = "";
        }
        this.mShortMethodName = shortMethodName;
    }

    private final void $$robo$$android_telecom_Logging_Session$setIsExternal(boolean isExternal) {
        this.mIsExternal = isExternal;
    }

    private final boolean $$robo$$android_telecom_Logging_Session$isExternal() {
        return this.mIsExternal;
    }

    private final void $$robo$$android_telecom_Logging_Session$setParentSession(Session parentSession) {
        this.mParentSession = parentSession;
    }

    private final void $$robo$$android_telecom_Logging_Session$addChild(Session childSession) {
        if (childSession != null) {
            this.mChildSessions.add(childSession);
        }
    }

    private final void $$robo$$android_telecom_Logging_Session$removeChild(Session child) {
        if (child != null) {
            this.mChildSessions.remove(child);
        }
    }

    private final long $$robo$$android_telecom_Logging_Session$getExecutionStartTimeMilliseconds() {
        return this.mExecutionStartTimeMs;
    }

    private final void $$robo$$android_telecom_Logging_Session$setExecutionStartTimeMs(long startTimeMs) {
        this.mExecutionStartTimeMs = startTimeMs;
    }

    private final Session $$robo$$android_telecom_Logging_Session$getParentSession() {
        return this.mParentSession;
    }

    private final ArrayList<Session> $$robo$$android_telecom_Logging_Session$getChildSessions() {
        return this.mChildSessions;
    }

    private final boolean $$robo$$android_telecom_Logging_Session$isSessionCompleted() {
        return this.mIsCompleted;
    }

    private final boolean $$robo$$android_telecom_Logging_Session$isStartedFromActiveSession() {
        return this.mIsStartedFromActiveSession;
    }

    private final Info $$robo$$android_telecom_Logging_Session$getInfo() {
        return Info.getInfo(this);
    }

    @VisibleForTesting
    private final String $$robo$$android_telecom_Logging_Session$getSessionId() {
        return this.mSessionId;
    }

    private final void $$robo$$android_telecom_Logging_Session$markSessionCompleted(long executionEndTimeMs) {
        this.mExecutionEndTimeMs = executionEndTimeMs;
        this.mIsCompleted = true;
    }

    private final long $$robo$$android_telecom_Logging_Session$getLocalExecutionTime() {
        if (this.mExecutionEndTimeMs == -1L) {
            return -1L;
        }
        return this.mExecutionEndTimeMs - this.mExecutionStartTimeMs;
    }

    private final synchronized String $$robo$$android_telecom_Logging_Session$getNextChildId() {
        return String.valueOf(this.mChildCounter++);
    }

    private final String $$robo$$android_telecom_Logging_Session$getFullSessionId() {
        Session parentSession = this.mParentSession;
        if (parentSession == null) {
            return this.mSessionId;
        }
        if (Log.VERBOSE) {
            return parentSession.getFullSessionId() + "_" + this.mSessionId;
        }
        return parentSession.getFullSessionId();
    }

    private final String $$robo$$android_telecom_Logging_Session$printFullSessionTree() {
        Session topNode = this;
        while (topNode.getParentSession() != null) {
            topNode = topNode.getParentSession();
        }
        return topNode.printSessionTree();
    }

    private final String $$robo$$android_telecom_Logging_Session$printSessionTree() {
        StringBuilder sb = new StringBuilder();
        this.printSessionTree(0, sb);
        return sb.toString();
    }

    private final void $$robo$$android_telecom_Logging_Session$printSessionTree(int tabI, StringBuilder sb) {
        sb.append(this.toString());
        for (Session child : this.mChildSessions) {
            sb.append("\n");
            for (int i = 0; i <= tabI; ++i) {
                sb.append("\t");
            }
            child.printSessionTree(tabI + 1, sb);
        }
    }

    private final String $$robo$$android_telecom_Logging_Session$getFullMethodPath(boolean truncatePath) {
        StringBuilder sb = new StringBuilder();
        this.getFullMethodPath(sb, truncatePath);
        return sb.toString();
    }

    private final synchronized void $$robo$$android_telecom_Logging_Session$getFullMethodPath(StringBuilder sb, boolean truncatePath) {
        if (!TextUtils.isEmpty(this.mFullMethodPathCache) && !truncatePath) {
            sb.append(this.mFullMethodPathCache);
            return;
        }
        Session parentSession = this.getParentSession();
        boolean isSessionStarted = false;
        if (parentSession != null) {
            isSessionStarted = !this.mShortMethodName.equals(parentSession.mShortMethodName);
            parentSession.getFullMethodPath(sb, truncatePath);
            sb.append("->");
        }
        if (this.isExternal()) {
            if (truncatePath) {
                sb.append("...");
            } else {
                sb.append("(");
                sb.append(this.mShortMethodName);
                sb.append(")");
            }
        } else {
            sb.append(this.mShortMethodName);
        }
        if (isSessionStarted && !truncatePath) {
            this.mFullMethodPathCache = sb.toString();
        }
    }

    private final boolean $$robo$$android_telecom_Logging_Session$isSessionExternal() {
        if (this.getParentSession() == null) {
            return this.isExternal();
        }
        return this.getParentSession().isSessionExternal();
    }

    private final int $$robo$$android_telecom_Logging_Session$hashCode() {
        int result = this.mSessionId != null ? this.mSessionId.hashCode() : 0;
        result = 31 * result + (this.mShortMethodName != null ? this.mShortMethodName.hashCode() : 0);
        result = 31 * result + (int)(this.mExecutionStartTimeMs ^ this.mExecutionStartTimeMs >>> 32);
        result = 31 * result + (int)(this.mExecutionEndTimeMs ^ this.mExecutionEndTimeMs >>> 32);
        result = 31 * result + (this.mParentSession != null ? this.mParentSession.hashCode() : 0);
        result = 31 * result + (this.mChildSessions != null ? this.mChildSessions.hashCode() : 0);
        result = 31 * result + (this.mIsCompleted ? 1 : 0);
        result = 31 * result + this.mChildCounter;
        result = 31 * result + (this.mIsStartedFromActiveSession ? 1 : 0);
        result = 31 * result + (this.mOwnerInfo != null ? this.mOwnerInfo.hashCode() : 0);
        return result;
    }

    private final boolean $$robo$$android_telecom_Logging_Session$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (this.mExecutionStartTimeMs != session.mExecutionStartTimeMs) {
            return false;
        }
        if (this.mExecutionEndTimeMs != session.mExecutionEndTimeMs) {
            return false;
        }
        if (this.mIsCompleted != session.mIsCompleted) {
            return false;
        }
        if (this.mChildCounter != session.mChildCounter) {
            return false;
        }
        if (this.mIsStartedFromActiveSession != session.mIsStartedFromActiveSession) {
            return false;
        }
        if (this.mSessionId != null ? !this.mSessionId.equals(session.mSessionId) : session.mSessionId != null) {
            return false;
        }
        if (this.mShortMethodName != null ? !this.mShortMethodName.equals(session.mShortMethodName) : session.mShortMethodName != null) {
            return false;
        }
        if (this.mParentSession != null ? !this.mParentSession.equals(session.mParentSession) : session.mParentSession != null) {
            return false;
        }
        if (this.mChildSessions != null ? !this.mChildSessions.equals(session.mChildSessions) : session.mChildSessions != null) {
            return false;
        }
        return this.mOwnerInfo != null ? this.mOwnerInfo.equals(session.mOwnerInfo) : session.mOwnerInfo == null;
    }

    private final String $$robo$$android_telecom_Logging_Session$toString() {
        if (this.mParentSession != null && this.mIsStartedFromActiveSession) {
            return this.mParentSession.toString();
        }
        StringBuilder methodName = new StringBuilder();
        methodName.append(this.getFullMethodPath(false));
        if (this.mOwnerInfo != null && !this.mOwnerInfo.isEmpty()) {
            methodName.append("(InCall package: ");
            methodName.append(this.mOwnerInfo);
            methodName.append(")");
        }
        return methodName.toString() + "@" + this.getFullSessionId();
    }

    private void __constructor__(String string2, String string3, long l, boolean bl, String string4) {
        this.$$robo$$android_telecom_Logging_Session$__constructor__(string2, string3, l, bl, string4);
    }

    public Session(String string2, String string3, long l, boolean bl, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_Session$__constructor__(java.lang.String java.lang.String long boolean java.lang.String ), this, string2, string3, l, bl, string4);
    }

    public void setSessionId(String string2) {
        InvokeDynamicSupport.bootstrap("setSessionId", $$robo$$android_telecom_Logging_Session$setSessionId(java.lang.String ), this, string2);
    }

    public String getShortMethodName() {
        return InvokeDynamicSupport.bootstrap("getShortMethodName", $$robo$$android_telecom_Logging_Session$getShortMethodName(), this);
    }

    public void setShortMethodName(String string2) {
        InvokeDynamicSupport.bootstrap("setShortMethodName", $$robo$$android_telecom_Logging_Session$setShortMethodName(java.lang.String ), this, string2);
    }

    public void setIsExternal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsExternal", $$robo$$android_telecom_Logging_Session$setIsExternal(boolean ), this, bl);
    }

    public boolean isExternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExternal", $$robo$$android_telecom_Logging_Session$isExternal(), this);
    }

    public void setParentSession(Session session) {
        InvokeDynamicSupport.bootstrap("setParentSession", $$robo$$android_telecom_Logging_Session$setParentSession(android.telecom.Logging.Session ), this, session);
    }

    public void addChild(Session session) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_telecom_Logging_Session$addChild(android.telecom.Logging.Session ), this, session);
    }

    public void removeChild(Session session) {
        InvokeDynamicSupport.bootstrap("removeChild", $$robo$$android_telecom_Logging_Session$removeChild(android.telecom.Logging.Session ), this, session);
    }

    public long getExecutionStartTimeMilliseconds() {
        return (long)InvokeDynamicSupport.bootstrap("getExecutionStartTimeMilliseconds", $$robo$$android_telecom_Logging_Session$getExecutionStartTimeMilliseconds(), this);
    }

    public void setExecutionStartTimeMs(long l) {
        InvokeDynamicSupport.bootstrap("setExecutionStartTimeMs", $$robo$$android_telecom_Logging_Session$setExecutionStartTimeMs(long ), this, l);
    }

    public Session getParentSession() {
        return InvokeDynamicSupport.bootstrap("getParentSession", $$robo$$android_telecom_Logging_Session$getParentSession(), this);
    }

    public ArrayList<Session> getChildSessions() {
        return InvokeDynamicSupport.bootstrap("getChildSessions", $$robo$$android_telecom_Logging_Session$getChildSessions(), this);
    }

    public boolean isSessionCompleted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionCompleted", $$robo$$android_telecom_Logging_Session$isSessionCompleted(), this);
    }

    public boolean isStartedFromActiveSession() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStartedFromActiveSession", $$robo$$android_telecom_Logging_Session$isStartedFromActiveSession(), this);
    }

    public Info getInfo() {
        return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$android_telecom_Logging_Session$getInfo(), this);
    }

    public String getSessionId() {
        return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_telecom_Logging_Session$getSessionId(), this);
    }

    public void markSessionCompleted(long l) {
        InvokeDynamicSupport.bootstrap("markSessionCompleted", $$robo$$android_telecom_Logging_Session$markSessionCompleted(long ), this, l);
    }

    public long getLocalExecutionTime() {
        return (long)InvokeDynamicSupport.bootstrap("getLocalExecutionTime", $$robo$$android_telecom_Logging_Session$getLocalExecutionTime(), this);
    }

    public synchronized String getNextChildId() {
        return InvokeDynamicSupport.bootstrap("getNextChildId", $$robo$$android_telecom_Logging_Session$getNextChildId(), this);
    }

    private String getFullSessionId() {
        return InvokeDynamicSupport.bootstrap("getFullSessionId", $$robo$$android_telecom_Logging_Session$getFullSessionId(), this);
    }

    public String printFullSessionTree() {
        return InvokeDynamicSupport.bootstrap("printFullSessionTree", $$robo$$android_telecom_Logging_Session$printFullSessionTree(), this);
    }

    public String printSessionTree() {
        return InvokeDynamicSupport.bootstrap("printSessionTree", $$robo$$android_telecom_Logging_Session$printSessionTree(), this);
    }

    private void printSessionTree(int n, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("printSessionTree", $$robo$$android_telecom_Logging_Session$printSessionTree(int java.lang.StringBuilder ), this, n, stringBuilder);
    }

    public String getFullMethodPath(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getFullMethodPath", $$robo$$android_telecom_Logging_Session$getFullMethodPath(boolean ), this, bl);
    }

    private synchronized void getFullMethodPath(StringBuilder stringBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("getFullMethodPath", $$robo$$android_telecom_Logging_Session$getFullMethodPath(java.lang.StringBuilder boolean ), this, stringBuilder, bl);
    }

    private boolean isSessionExternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionExternal", $$robo$$android_telecom_Logging_Session$isSessionExternal(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telecom_Logging_Session$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telecom_Logging_Session$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_Logging_Session$toString(), this);
    }

    public /* synthetic */ Session() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Info
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String sessionId;
        public String methodPath;
        public static Parcelable.Creator<Info> CREATOR;

        private void $$robo$$android_telecom_Logging_Session_Info$__constructor__(String id2, String path) {
            this.sessionId = id2;
            this.methodPath = path;
        }

        private static final Info $$robo$$android_telecom_Logging_Session_Info$getInfo(Session s) {
            return new Info(s.getFullSessionId(), s.getFullMethodPath(!Log.DEBUG && s.isSessionExternal()));
        }

        private final int $$robo$$android_telecom_Logging_Session_Info$describeContents() {
            return 0;
        }

        private final void $$robo$$android_telecom_Logging_Session_Info$writeToParcel(Parcel destination, int flags) {
            destination.writeString(this.sessionId);
            destination.writeString(this.methodPath);
        }

        private /* synthetic */ void $$robo$$android_telecom_Logging_Session_Info$__constructor__(String x0, String x1, 1 x2) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Info>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_telecom_Logging_Session_Info_1$__constructor__() {
                }

                private final Info $$robo$$android_telecom_Logging_Session_Info_1$createFromParcel(Parcel source) {
                    String id2 = source.readString();
                    String methodName = source.readString();
                    return new Info(id2, methodName, null);
                }

                private final Info[] $$robo$$android_telecom_Logging_Session_Info_1$newArray(int size) {
                    return new Info[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_telecom_Logging_Session_Info_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_Session_Info_1$__constructor__(), this);
                }

                @Override
                public Info createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telecom_Logging_Session_Info_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Info[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telecom_Logging_Session_Info_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_telecom_Logging_Session_Info$__constructor__(string2, string3);
        }

        public Info(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_Session_Info$__constructor__(java.lang.String java.lang.String ), this, string2, string3);
        }

        public static Info getInfo(Session session) {
            return InvokeDynamicSupport.bootstrapStatic("getInfo", $$robo$$android_telecom_Logging_Session_Info$getInfo(android.telecom.Logging.Session ), (Session)session);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telecom_Logging_Session_Info$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telecom_Logging_Session_Info$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(String string2, String string3, 1 var3_3) {
            this.$$robo$$android_telecom_Logging_Session_Info$__constructor__(string2, string3, var3_3);
        }

        public /* synthetic */ Info(String string2, String string3, 1 var3_3) {
            this(string2, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_Session_Info$__constructor__(java.lang.String java.lang.String android.telecom.Logging.Session$1 ), this, string2, string3, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(Info.class);
        }

        public /* synthetic */ Info() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Info)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

