/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.telecom.Logging.EventManager;
import android.telecom.Logging.Session;
import android.telecom.Logging.SessionManager;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Log
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long EXTENDED_LOGGING_DURATION_MILLIS = 1800000L;
    private static int EVENTS_TO_CACHE = 10;
    private static int EVENTS_TO_CACHE_DEBUG = 20;
    @VisibleForTesting
    public static String TAG;
    public static boolean DEBUG;
    public static boolean INFO;
    public static boolean VERBOSE;
    public static boolean WARN;
    public static boolean ERROR;
    private static boolean FORCE_LOGGING = false;
    private static boolean USER_BUILD;
    private static Object sSingletonSync;
    private static EventManager sEventManager;
    private static SessionManager sSessionManager;
    private static boolean sIsUserExtendedLoggingEnabled;
    private static long sUserExtendedLoggingStopTime;

    private void $$robo$$android_telecom_Log$__constructor__() {
    }

    private static final void $$robo$$android_telecom_Log$d(String prefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(prefix, format, args));
        } else if (DEBUG) {
            Slog.d(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$d(Object objectPrefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        } else if (DEBUG) {
            Slog.d(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$i(String prefix, String format, Object ... args) {
        if (INFO) {
            Slog.i(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$i(Object objectPrefix, String format, Object ... args) {
        if (INFO) {
            Slog.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$v(String prefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(prefix, format, args));
        } else if (VERBOSE) {
            Slog.v(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$v(Object objectPrefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        } else if (VERBOSE) {
            Slog.v(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$w(String prefix, String format, Object ... args) {
        if (WARN) {
            Slog.w(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$w(Object objectPrefix, String format, Object ... args) {
        if (WARN) {
            Slog.w(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    private static final void $$robo$$android_telecom_Log$e(String prefix, Throwable tr, String format, Object ... args) {
        if (ERROR) {
            Slog.e(TAG, Log.buildMessage(prefix, format, args), tr);
        }
    }

    private static final void $$robo$$android_telecom_Log$e(Object objectPrefix, Throwable tr, String format, Object ... args) {
        if (ERROR) {
            Slog.e(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args), tr);
        }
    }

    private static final void $$robo$$android_telecom_Log$wtf(String prefix, Throwable tr, String format, Object ... args) {
        Slog.wtf(TAG, Log.buildMessage(prefix, format, args), tr);
    }

    private static final void $$robo$$android_telecom_Log$wtf(Object objectPrefix, Throwable tr, String format, Object ... args) {
        Slog.wtf(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args), tr);
    }

    private static final void $$robo$$android_telecom_Log$wtf(String prefix, String format, Object ... args) {
        String msg = Log.buildMessage(prefix, format, args);
        Slog.wtf(TAG, msg, new IllegalStateException(msg));
    }

    private static final void $$robo$$android_telecom_Log$wtf(Object objectPrefix, String format, Object ... args) {
        String msg = Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args);
        Slog.wtf(TAG, msg, new IllegalStateException(msg));
    }

    private static final void $$robo$$android_telecom_Log$setSessionContext(Context context) {
        Log.getSessionManager().setContext(context);
    }

    private static final void $$robo$$android_telecom_Log$startSession(String shortMethodName) {
        Log.getSessionManager().startSession(shortMethodName, null);
    }

    private static final void $$robo$$android_telecom_Log$startSession(Session.Info info, String shortMethodName) {
        Log.getSessionManager().startSession(info, shortMethodName, null);
    }

    private static final void $$robo$$android_telecom_Log$startSession(String shortMethodName, String callerIdentification) {
        Log.getSessionManager().startSession(shortMethodName, callerIdentification);
    }

    private static final void $$robo$$android_telecom_Log$startSession(Session.Info info, String shortMethodName, String callerIdentification) {
        Log.getSessionManager().startSession(info, shortMethodName, callerIdentification);
    }

    private static final Session $$robo$$android_telecom_Log$createSubsession() {
        return Log.getSessionManager().createSubsession();
    }

    private static final Session.Info $$robo$$android_telecom_Log$getExternalSession() {
        return Log.getSessionManager().getExternalSession();
    }

    private static final void $$robo$$android_telecom_Log$cancelSubsession(Session subsession) {
        Log.getSessionManager().cancelSubsession(subsession);
    }

    private static final void $$robo$$android_telecom_Log$continueSession(Session subsession, String shortMethodName) {
        Log.getSessionManager().continueSession(subsession, shortMethodName);
    }

    private static final void $$robo$$android_telecom_Log$endSession() {
        Log.getSessionManager().endSession();
    }

    private static final void $$robo$$android_telecom_Log$registerSessionListener(SessionManager.ISessionListener l) {
        Log.getSessionManager().registerSessionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_telecom_Log$getSessionId() {
        Object object = sSingletonSync;
        synchronized (object) {
            if (sSessionManager != null) {
                return Log.getSessionManager().getSessionId();
            }
            return "";
        }
    }

    private static final void $$robo$$android_telecom_Log$addEvent(EventManager.Loggable recordEntry, String event) {
        Log.getEventManager().event(recordEntry, event, null);
    }

    private static final void $$robo$$android_telecom_Log$addEvent(EventManager.Loggable recordEntry, String event, Object data) {
        Log.getEventManager().event(recordEntry, event, data);
    }

    private static final void $$robo$$android_telecom_Log$addEvent(EventManager.Loggable recordEntry, String event, String format, Object ... args) {
        Log.getEventManager().event(recordEntry, event, format, args);
    }

    private static final void $$robo$$android_telecom_Log$registerEventListener(EventManager.EventListener e) {
        Log.getEventManager().registerEventListener(e);
    }

    private static final void $$robo$$android_telecom_Log$addRequestResponsePair(EventManager.TimedEventPair p) {
        Log.getEventManager().addRequestResponsePair(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_telecom_Log$dumpEvents(IndentingPrintWriter pw) {
        Object object = sSingletonSync;
        synchronized (object) {
            if (sEventManager != null) {
                Log.getEventManager().dumpEvents(pw);
            } else {
                pw.println("No Historical Events Logged.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_telecom_Log$dumpEventsTimeline(IndentingPrintWriter pw) {
        Object object = sSingletonSync;
        synchronized (object) {
            if (sEventManager != null) {
                Log.getEventManager().dumpEventsTimeline(pw);
            } else {
                pw.println("No Historical Events Logged.");
            }
        }
    }

    private static final void $$robo$$android_telecom_Log$setIsExtendedLoggingEnabled(boolean isExtendedLoggingEnabled) {
        if (sIsUserExtendedLoggingEnabled == isExtendedLoggingEnabled) {
            return;
        }
        if (sEventManager != null) {
            sEventManager.changeEventCacheSize(isExtendedLoggingEnabled ? 20 : 10);
        }
        sUserExtendedLoggingStopTime = (sIsUserExtendedLoggingEnabled = isExtendedLoggingEnabled) ? (long)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") + 1800000L) : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EventManager $$robo$$android_telecom_Log$getEventManager() {
        if (sEventManager == null) {
            Object object = sSingletonSync;
            synchronized (object) {
                if (sEventManager == null) {
                    sEventManager = new EventManager(Log::getSessionId);
                    return sEventManager;
                }
            }
        }
        return sEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private static final SessionManager $$robo$$android_telecom_Log$getSessionManager() {
        if (sSessionManager == null) {
            Object object = sSingletonSync;
            synchronized (object) {
                if (sSessionManager == null) {
                    sSessionManager = new SessionManager();
                    return sSessionManager;
                }
            }
        }
        return sSessionManager;
    }

    private static final void $$robo$$android_telecom_Log$setTag(String tag) {
        TAG = tag;
        DEBUG = Log.isLoggable(3);
        INFO = Log.isLoggable(4);
        VERBOSE = Log.isLoggable(2);
        WARN = Log.isLoggable(5);
        ERROR = Log.isLoggable(6);
    }

    private static final void $$robo$$android_telecom_Log$maybeDisableLogging() {
        if (!sIsUserExtendedLoggingEnabled) {
            return;
        }
        if (sUserExtendedLoggingStopTime < InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")) {
            sUserExtendedLoggingStopTime = 0L;
            sIsUserExtendedLoggingEnabled = false;
        }
    }

    private static final boolean $$robo$$android_telecom_Log$isLoggable(int level) {
        return android.util.Log.isLoggable(TAG, level);
    }

    private static final String $$robo$$android_telecom_Log$piiHandle(Object pii) {
        if (pii == null || VERBOSE) {
            return String.valueOf(pii);
        }
        StringBuilder sb = new StringBuilder();
        if (pii instanceof Uri) {
            Uri uri = (Uri)pii;
            String scheme = uri.getScheme();
            if (!TextUtils.isEmpty(scheme)) {
                sb.append(scheme).append(":");
            }
            String textToObfuscate = uri.getSchemeSpecificPart();
            if ("tel".equals(scheme)) {
                for (int i = 0; i < textToObfuscate.length(); ++i) {
                    char c = textToObfuscate.charAt(i);
                    sb.append(PhoneNumberUtils.isDialable(c) ? "*" : Character.valueOf(c));
                }
            } else if ("sip".equals(scheme)) {
                for (int i = 0; i < textToObfuscate.length(); ++i) {
                    int c = textToObfuscate.charAt(i);
                    if (c != 64 && c != 46) {
                        c = 42;
                    }
                    sb.append((char)c);
                }
            } else {
                sb.append(Log.pii(pii));
            }
        }
        return sb.toString();
    }

    private static final String $$robo$$android_telecom_Log$pii(Object pii) {
        if (pii == null || VERBOSE) {
            return String.valueOf(pii);
        }
        return "***";
    }

    private static final String $$robo$$android_telecom_Log$getPrefixFromObject(Object obj) {
        return obj == null ? "<null>" : obj.getClass().getSimpleName();
    }

    private static final String $$robo$$android_telecom_Log$buildMessage(String prefix, String format, Object ... args) {
        String msg;
        String sessionName = Log.getSessionId();
        String sessionPostfix = TextUtils.isEmpty(sessionName) ? "" : ": " + sessionName;
        try {
            msg = args == null || args.length == 0 ? format : String.format(Locale.US, format, args);
        }
        catch (IllegalFormatException ife) {
            Log.e(TAG, (Throwable)ife, "Log: IllegalFormatException: formatString='%s' numArgs=%d", format, args.length);
            msg = format + " (An error occurred while formatting the message.)";
        }
        return String.format(Locale.US, "%s: %s%s", prefix, msg, sessionPostfix);
    }

    static void __staticInitializer__() {
        TAG = "TelecomFramework";
        DEBUG = Log.isLoggable(3);
        INFO = Log.isLoggable(4);
        VERBOSE = Log.isLoggable(2);
        WARN = Log.isLoggable(5);
        ERROR = Log.isLoggable(6);
        USER_BUILD = Build.IS_USER;
        sSingletonSync = new Object();
        sIsUserExtendedLoggingEnabled = false;
        sUserExtendedLoggingStopTime = 0L;
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_Log$__constructor__();
    }

    public Log() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Log$__constructor__(), this);
    }

    public static void d(String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("d", $$robo$$android_telecom_Log$d(java.lang.String java.lang.String java.lang.Object[] ), (String)string2, (String)string3, (Object[])objectArray);
    }

    public static void d(Object object, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("d", $$robo$$android_telecom_Log$d(java.lang.Object java.lang.String java.lang.Object[] ), (Object)object, (String)string2, (Object[])objectArray);
    }

    public static void i(String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("i", $$robo$$android_telecom_Log$i(java.lang.String java.lang.String java.lang.Object[] ), (String)string2, (String)string3, (Object[])objectArray);
    }

    public static void i(Object object, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("i", $$robo$$android_telecom_Log$i(java.lang.Object java.lang.String java.lang.Object[] ), (Object)object, (String)string2, (Object[])objectArray);
    }

    public static void v(String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("v", $$robo$$android_telecom_Log$v(java.lang.String java.lang.String java.lang.Object[] ), (String)string2, (String)string3, (Object[])objectArray);
    }

    public static void v(Object object, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("v", $$robo$$android_telecom_Log$v(java.lang.Object java.lang.String java.lang.Object[] ), (Object)object, (String)string2, (Object[])objectArray);
    }

    public static void w(String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("w", $$robo$$android_telecom_Log$w(java.lang.String java.lang.String java.lang.Object[] ), (String)string2, (String)string3, (Object[])objectArray);
    }

    public static void w(Object object, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("w", $$robo$$android_telecom_Log$w(java.lang.Object java.lang.String java.lang.Object[] ), (Object)object, (String)string2, (Object[])objectArray);
    }

    public static void e(String string2, Throwable throwable, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("e", $$robo$$android_telecom_Log$e(java.lang.String java.lang.Throwable java.lang.String java.lang.Object[] ), (String)string2, (Throwable)throwable, (String)string3, (Object[])objectArray);
    }

    public static void e(Object object, Throwable throwable, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("e", $$robo$$android_telecom_Log$e(java.lang.Object java.lang.Throwable java.lang.String java.lang.Object[] ), (Object)object, (Throwable)throwable, (String)string2, (Object[])objectArray);
    }

    public static void wtf(String string2, Throwable throwable, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("wtf", $$robo$$android_telecom_Log$wtf(java.lang.String java.lang.Throwable java.lang.String java.lang.Object[] ), (String)string2, (Throwable)throwable, (String)string3, (Object[])objectArray);
    }

    public static void wtf(Object object, Throwable throwable, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("wtf", $$robo$$android_telecom_Log$wtf(java.lang.Object java.lang.Throwable java.lang.String java.lang.Object[] ), (Object)object, (Throwable)throwable, (String)string2, (Object[])objectArray);
    }

    public static void wtf(String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("wtf", $$robo$$android_telecom_Log$wtf(java.lang.String java.lang.String java.lang.Object[] ), (String)string2, (String)string3, (Object[])objectArray);
    }

    public static void wtf(Object object, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("wtf", $$robo$$android_telecom_Log$wtf(java.lang.Object java.lang.String java.lang.Object[] ), (Object)object, (String)string2, (Object[])objectArray);
    }

    public static void setSessionContext(Context context) {
        InvokeDynamicSupport.bootstrapStatic("setSessionContext", $$robo$$android_telecom_Log$setSessionContext(android.content.Context ), (Context)context);
    }

    public static void startSession(String string2) {
        InvokeDynamicSupport.bootstrapStatic("startSession", $$robo$$android_telecom_Log$startSession(java.lang.String ), (String)string2);
    }

    public static void startSession(Session.Info info, String string2) {
        InvokeDynamicSupport.bootstrapStatic("startSession", $$robo$$android_telecom_Log$startSession(android.telecom.Logging.Session$Info java.lang.String ), (Session.Info)info, (String)string2);
    }

    public static void startSession(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("startSession", $$robo$$android_telecom_Log$startSession(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public static void startSession(Session.Info info, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("startSession", $$robo$$android_telecom_Log$startSession(android.telecom.Logging.Session$Info java.lang.String java.lang.String ), (Session.Info)info, (String)string2, (String)string3);
    }

    public static Session createSubsession() {
        return InvokeDynamicSupport.bootstrapStatic("createSubsession", $$robo$$android_telecom_Log$createSubsession());
    }

    public static Session.Info getExternalSession() {
        return InvokeDynamicSupport.bootstrapStatic("getExternalSession", $$robo$$android_telecom_Log$getExternalSession());
    }

    public static void cancelSubsession(Session session) {
        InvokeDynamicSupport.bootstrapStatic("cancelSubsession", $$robo$$android_telecom_Log$cancelSubsession(android.telecom.Logging.Session ), (Session)session);
    }

    public static void continueSession(Session session, String string2) {
        InvokeDynamicSupport.bootstrapStatic("continueSession", $$robo$$android_telecom_Log$continueSession(android.telecom.Logging.Session java.lang.String ), (Session)session, (String)string2);
    }

    public static void endSession() {
        InvokeDynamicSupport.bootstrapStatic("endSession", $$robo$$android_telecom_Log$endSession());
    }

    public static void registerSessionListener(SessionManager.ISessionListener iSessionListener) {
        InvokeDynamicSupport.bootstrapStatic("registerSessionListener", $$robo$$android_telecom_Log$registerSessionListener(android.telecom.Logging.SessionManager$ISessionListener ), (SessionManager.ISessionListener)iSessionListener);
    }

    public static String getSessionId() {
        return InvokeDynamicSupport.bootstrapStatic("getSessionId", $$robo$$android_telecom_Log$getSessionId());
    }

    public static void addEvent(EventManager.Loggable loggable, String string2) {
        InvokeDynamicSupport.bootstrapStatic("addEvent", $$robo$$android_telecom_Log$addEvent(android.telecom.Logging.EventManager$Loggable java.lang.String ), (EventManager.Loggable)loggable, (String)string2);
    }

    public static void addEvent(EventManager.Loggable loggable, String string2, Object object) {
        InvokeDynamicSupport.bootstrapStatic("addEvent", $$robo$$android_telecom_Log$addEvent(android.telecom.Logging.EventManager$Loggable java.lang.String java.lang.Object ), (EventManager.Loggable)loggable, (String)string2, (Object)object);
    }

    public static void addEvent(EventManager.Loggable loggable, String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("addEvent", $$robo$$android_telecom_Log$addEvent(android.telecom.Logging.EventManager$Loggable java.lang.String java.lang.String java.lang.Object[] ), (EventManager.Loggable)loggable, (String)string2, (String)string3, (Object[])objectArray);
    }

    public static void registerEventListener(EventManager.EventListener eventListener) {
        InvokeDynamicSupport.bootstrapStatic("registerEventListener", $$robo$$android_telecom_Log$registerEventListener(android.telecom.Logging.EventManager$EventListener ), (EventManager.EventListener)eventListener);
    }

    public static void addRequestResponsePair(EventManager.TimedEventPair timedEventPair) {
        InvokeDynamicSupport.bootstrapStatic("addRequestResponsePair", $$robo$$android_telecom_Log$addRequestResponsePair(android.telecom.Logging.EventManager$TimedEventPair ), (EventManager.TimedEventPair)timedEventPair);
    }

    public static void dumpEvents(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrapStatic("dumpEvents", $$robo$$android_telecom_Log$dumpEvents(com.android.internal.util.IndentingPrintWriter ), (IndentingPrintWriter)indentingPrintWriter);
    }

    public static void dumpEventsTimeline(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrapStatic("dumpEventsTimeline", $$robo$$android_telecom_Log$dumpEventsTimeline(com.android.internal.util.IndentingPrintWriter ), (IndentingPrintWriter)indentingPrintWriter);
    }

    public static void setIsExtendedLoggingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setIsExtendedLoggingEnabled", $$robo$$android_telecom_Log$setIsExtendedLoggingEnabled(boolean ), (boolean)bl);
    }

    private static EventManager getEventManager() {
        return InvokeDynamicSupport.bootstrapStatic("getEventManager", $$robo$$android_telecom_Log$getEventManager());
    }

    public static SessionManager getSessionManager() {
        return InvokeDynamicSupport.bootstrapStatic("getSessionManager", $$robo$$android_telecom_Log$getSessionManager());
    }

    public static void setTag(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setTag", $$robo$$android_telecom_Log$setTag(java.lang.String ), (String)string2);
    }

    private static void maybeDisableLogging() {
        InvokeDynamicSupport.bootstrapStatic("maybeDisableLogging", $$robo$$android_telecom_Log$maybeDisableLogging());
    }

    public static boolean isLoggable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLoggable", $$robo$$android_telecom_Log$isLoggable(int ), (int)n);
    }

    public static String piiHandle(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("piiHandle", $$robo$$android_telecom_Log$piiHandle(java.lang.Object ), (Object)object);
    }

    public static String pii(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("pii", $$robo$$android_telecom_Log$pii(java.lang.Object ), (Object)object);
    }

    private static String getPrefixFromObject(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("getPrefixFromObject", $$robo$$android_telecom_Log$getPrefixFromObject(java.lang.Object ), (Object)object);
    }

    private static String buildMessage(String string2, String string3, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildMessage", $$robo$$android_telecom_Log$buildMessage(java.lang.String java.lang.String java.lang.Object[] ), (String)string2, (String)string3, (Object[])objectArray);
    }

    static {
        RobolectricInternals.classInitializing(Log.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Log)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

