/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.CallAudioState;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.RemoteServiceCallback;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ConnectionServiceAdapter
implements IBinder.DeathRecipient,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Set<IConnectionServiceAdapter> mAdapters;

    private void $$robo$$android_telecom_ConnectionServiceAdapter$__constructor__() {
        this.mAdapters = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$addAdapter(IConnectionServiceAdapter adapter) {
        for (IConnectionServiceAdapter it : this.mAdapters) {
            if (it.asBinder() != adapter.asBinder()) continue;
            Log.w(this, "Ignoring duplicate adapter addition.", new Object[0]);
            return;
        }
        if (this.mAdapters.add(adapter)) {
            try {
                adapter.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.mAdapters.remove(adapter);
            }
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$removeAdapter(IConnectionServiceAdapter adapter) {
        if (adapter != null) {
            for (IConnectionServiceAdapter it : this.mAdapters) {
                if (it.asBinder() != adapter.asBinder() || !this.mAdapters.remove(it)) continue;
                adapter.asBinder().unlinkToDeath(this, 0);
                break;
            }
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$binderDied() {
        Iterator<IConnectionServiceAdapter> it = this.mAdapters.iterator();
        while (it.hasNext()) {
            IConnectionServiceAdapter adapter = it.next();
            if (adapter.asBinder().isBinderAlive()) continue;
            it.remove();
            adapter.asBinder().unlinkToDeath(this, 0);
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$handleCreateConnectionComplete(String id2, ConnectionRequest request, ParcelableConnection connection) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.handleCreateConnectionComplete(id2, request, connection, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setActive(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setActive(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setRinging(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setRinging(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setDialing(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setDialing(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setPulling(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setPulling(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setDisconnected(String callId, DisconnectCause disconnectCause) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setDisconnected(callId, disconnectCause, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setOnHold(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setOnHold(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setRingbackRequested(String callId, boolean ringback) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setRingbackRequested(callId, ringback, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setConnectionCapabilities(String callId, int capabilities) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setConnectionCapabilities(callId, capabilities, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setConnectionProperties(String callId, int properties) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setConnectionProperties(callId, properties, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setIsConferenced(String callId, String conferenceCallId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Log.d(this, "sending connection %s with conference %s", callId, conferenceCallId);
                adapter.setIsConferenced(callId, conferenceCallId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onConferenceMergeFailed(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Log.d(this, "merge failed for call %s", callId);
                adapter.setConferenceMergeFailed(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$removeCall(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.removeCall(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onPostDialWait(String callId, String remaining) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onPostDialWait(callId, remaining, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onPostDialChar(String callId, char nextChar) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onPostDialChar(callId, nextChar, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$addConferenceCall(String callId, ParcelableConference parcelableConference) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.addConferenceCall(callId, parcelableConference, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$queryRemoteConnectionServices(RemoteServiceCallback callback) {
        if (this.mAdapters.size() == 1) {
            try {
                this.mAdapters.iterator().next().queryRemoteConnectionServices(callback, Log.getExternalSession());
            }
            catch (RemoteException e) {
                Log.e(this, (Throwable)e, "Exception trying to query for remote CSs", new Object[0]);
            }
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setVideoProvider(String callId, Connection.VideoProvider videoProvider) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setVideoProvider(callId, videoProvider == null ? null : videoProvider.getInterface(), Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setIsVoipAudioMode(String callId, boolean isVoip) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setIsVoipAudioMode(callId, isVoip, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setStatusHints(String callId, StatusHints statusHints) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setStatusHints(callId, statusHints, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setAddress(String callId, Uri address, int presentation) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setAddress(callId, address, presentation, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setCallerDisplayName(String callId, String callerDisplayName, int presentation) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setCallerDisplayName(callId, callerDisplayName, presentation, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setVideoState(String callId, int videoState) {
        Log.v(this, "setVideoState: %d", videoState);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setVideoState(callId, videoState, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setConferenceableConnections(String callId, List<String> conferenceableCallIds) {
        Log.v(this, "setConferenceableConnections: %s, %s", callId, conferenceableCallIds);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setConferenceableConnections(callId, conferenceableCallIds, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$addExistingConnection(String callId, ParcelableConnection connection) {
        Log.v(this, "addExistingConnection: %s", callId);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.addExistingConnection(callId, connection, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$putExtras(String callId, Bundle extras) {
        Log.v(this, "putExtras: %s", callId);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.putExtras(callId, extras, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$putExtra(String callId, String key, boolean value) {
        Log.v(this, "putExtra: %s %s=%b", callId, key, value);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Bundle bundle = new Bundle();
                bundle.putBoolean(key, value);
                adapter.putExtras(callId, bundle, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$putExtra(String callId, String key, int value) {
        Log.v(this, "putExtra: %s %s=%d", callId, key, value);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Bundle bundle = new Bundle();
                bundle.putInt(key, value);
                adapter.putExtras(callId, bundle, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$putExtra(String callId, String key, String value) {
        Log.v(this, "putExtra: %s %s=%s", callId, key, value);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Bundle bundle = new Bundle();
                bundle.putString(key, value);
                adapter.putExtras(callId, bundle, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$removeExtras(String callId, List<String> keys) {
        Log.v(this, "removeExtras: %s %s", callId, keys);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.removeExtras(callId, keys, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setAudioRoute(String callId, int audioRoute, String bluetoothAddress) {
        Log.v(this, "setAudioRoute: %s %s %s", callId, CallAudioState.audioRouteToString(audioRoute), bluetoothAddress);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setAudioRoute(callId, audioRoute, bluetoothAddress, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onConnectionEvent(String callId, String event, Bundle extras) {
        Log.v(this, "onConnectionEvent: %s", event);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onConnectionEvent(callId, event, extras, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onRttInitiationSuccess(String callId) {
        Log.v(this, "onRttInitiationSuccess: %s", callId);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onRttInitiationSuccess(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onRttInitiationFailure(String callId, int reason) {
        Log.v(this, "onRttInitiationFailure: %s", callId);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onRttInitiationFailure(callId, reason, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onRttSessionRemotelyTerminated(String callId) {
        Log.v(this, "onRttSessionRemotelyTerminated: %s", callId);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onRttSessionRemotelyTerminated(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onRemoteRttRequest(String callId) {
        Log.v(this, "onRemoteRttRequest: %s", callId);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onRemoteRttRequest(callId, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onPhoneAccountChanged(String callId, PhoneAccountHandle pHandle) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Log.d(this, "onPhoneAccountChanged %s", callId);
                adapter.onPhoneAccountChanged(callId, pHandle, Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onConnectionServiceFocusReleased() {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Log.d(this, "onConnectionServiceFocusReleased", new Object[0]);
                adapter.onConnectionServiceFocusReleased(Log.getExternalSession());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_ConnectionServiceAdapter$__constructor__();
    }

    public ConnectionServiceAdapter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionServiceAdapter$__constructor__(), this);
    }

    void addAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
        InvokeDynamicSupport.bootstrap("addAdapter", $$robo$$android_telecom_ConnectionServiceAdapter$addAdapter(com.android.internal.telecom.IConnectionServiceAdapter ), this, iConnectionServiceAdapter);
    }

    void removeAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
        InvokeDynamicSupport.bootstrap("removeAdapter", $$robo$$android_telecom_ConnectionServiceAdapter$removeAdapter(com.android.internal.telecom.IConnectionServiceAdapter ), this, iConnectionServiceAdapter);
    }

    @Override
    public void binderDied() {
        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_telecom_ConnectionServiceAdapter$binderDied(), this);
    }

    void handleCreateConnectionComplete(String string2, ConnectionRequest connectionRequest, ParcelableConnection parcelableConnection) {
        InvokeDynamicSupport.bootstrap("handleCreateConnectionComplete", $$robo$$android_telecom_ConnectionServiceAdapter$handleCreateConnectionComplete(java.lang.String android.telecom.ConnectionRequest android.telecom.ParcelableConnection ), this, string2, connectionRequest, parcelableConnection);
    }

    void setActive(String string2) {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_ConnectionServiceAdapter$setActive(java.lang.String ), this, string2);
    }

    void setRinging(String string2) {
        InvokeDynamicSupport.bootstrap("setRinging", $$robo$$android_telecom_ConnectionServiceAdapter$setRinging(java.lang.String ), this, string2);
    }

    void setDialing(String string2) {
        InvokeDynamicSupport.bootstrap("setDialing", $$robo$$android_telecom_ConnectionServiceAdapter$setDialing(java.lang.String ), this, string2);
    }

    void setPulling(String string2) {
        InvokeDynamicSupport.bootstrap("setPulling", $$robo$$android_telecom_ConnectionServiceAdapter$setPulling(java.lang.String ), this, string2);
    }

    void setDisconnected(String string2, DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_ConnectionServiceAdapter$setDisconnected(java.lang.String android.telecom.DisconnectCause ), this, string2, disconnectCause);
    }

    void setOnHold(String string2) {
        InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_ConnectionServiceAdapter$setOnHold(java.lang.String ), this, string2);
    }

    void setRingbackRequested(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_ConnectionServiceAdapter$setRingbackRequested(java.lang.String boolean ), this, string2, bl);
    }

    void setConnectionCapabilities(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setConnectionCapabilities", $$robo$$android_telecom_ConnectionServiceAdapter$setConnectionCapabilities(java.lang.String int ), this, string2, n);
    }

    void setConnectionProperties(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setConnectionProperties", $$robo$$android_telecom_ConnectionServiceAdapter$setConnectionProperties(java.lang.String int ), this, string2, n);
    }

    void setIsConferenced(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setIsConferenced", $$robo$$android_telecom_ConnectionServiceAdapter$setIsConferenced(java.lang.String java.lang.String ), this, string2, string3);
    }

    void onConferenceMergeFailed(String string2) {
        InvokeDynamicSupport.bootstrap("onConferenceMergeFailed", $$robo$$android_telecom_ConnectionServiceAdapter$onConferenceMergeFailed(java.lang.String ), this, string2);
    }

    void removeCall(String string2) {
        InvokeDynamicSupport.bootstrap("removeCall", $$robo$$android_telecom_ConnectionServiceAdapter$removeCall(java.lang.String ), this, string2);
    }

    void onPostDialWait(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_ConnectionServiceAdapter$onPostDialWait(java.lang.String java.lang.String ), this, string2, string3);
    }

    void onPostDialChar(String string2, char c) {
        InvokeDynamicSupport.bootstrap("onPostDialChar", $$robo$$android_telecom_ConnectionServiceAdapter$onPostDialChar(java.lang.String char ), this, string2, c);
    }

    void addConferenceCall(String string2, ParcelableConference parcelableConference) {
        InvokeDynamicSupport.bootstrap("addConferenceCall", $$robo$$android_telecom_ConnectionServiceAdapter$addConferenceCall(java.lang.String android.telecom.ParcelableConference ), this, string2, parcelableConference);
    }

    void queryRemoteConnectionServices(RemoteServiceCallback remoteServiceCallback) {
        InvokeDynamicSupport.bootstrap("queryRemoteConnectionServices", $$robo$$android_telecom_ConnectionServiceAdapter$queryRemoteConnectionServices(com.android.internal.telecom.RemoteServiceCallback ), this, remoteServiceCallback);
    }

    void setVideoProvider(String string2, Connection.VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_ConnectionServiceAdapter$setVideoProvider(java.lang.String android.telecom.Connection$VideoProvider ), this, string2, videoProvider);
    }

    void setIsVoipAudioMode(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsVoipAudioMode", $$robo$$android_telecom_ConnectionServiceAdapter$setIsVoipAudioMode(java.lang.String boolean ), this, string2, bl);
    }

    void setStatusHints(String string2, StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_ConnectionServiceAdapter$setStatusHints(java.lang.String android.telecom.StatusHints ), this, string2, statusHints);
    }

    void setAddress(String string2, Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_ConnectionServiceAdapter$setAddress(java.lang.String android.net.Uri int ), this, string2, uri, n);
    }

    void setCallerDisplayName(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_ConnectionServiceAdapter$setCallerDisplayName(java.lang.String java.lang.String int ), this, string2, string3, n);
    }

    void setVideoState(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_ConnectionServiceAdapter$setVideoState(java.lang.String int ), this, string2, n);
    }

    void setConferenceableConnections(String string2, List<String> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_ConnectionServiceAdapter$setConferenceableConnections(java.lang.String java.util.List<java.lang.String> ), this, string2, list);
    }

    void addExistingConnection(String string2, ParcelableConnection parcelableConnection) {
        InvokeDynamicSupport.bootstrap("addExistingConnection", $$robo$$android_telecom_ConnectionServiceAdapter$addExistingConnection(java.lang.String android.telecom.ParcelableConnection ), this, string2, parcelableConnection);
    }

    void putExtras(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_telecom_ConnectionServiceAdapter$putExtras(java.lang.String android.os.Bundle ), this, string2, bundle);
    }

    void putExtra(String string2, String string3, boolean bl) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_ConnectionServiceAdapter$putExtra(java.lang.String java.lang.String boolean ), this, string2, string3, bl);
    }

    void putExtra(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_ConnectionServiceAdapter$putExtra(java.lang.String java.lang.String int ), this, string2, string3, n);
    }

    void putExtra(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_ConnectionServiceAdapter$putExtra(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    void removeExtras(String string2, List<String> list) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_ConnectionServiceAdapter$removeExtras(java.lang.String java.util.List<java.lang.String> ), this, string2, list);
    }

    void setAudioRoute(String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrap("setAudioRoute", $$robo$$android_telecom_ConnectionServiceAdapter$setAudioRoute(java.lang.String int java.lang.String ), this, string2, n, string3);
    }

    void onConnectionEvent(String string2, String string3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_ConnectionServiceAdapter$onConnectionEvent(java.lang.String java.lang.String android.os.Bundle ), this, string2, string3, bundle);
    }

    void onRttInitiationSuccess(String string2) {
        InvokeDynamicSupport.bootstrap("onRttInitiationSuccess", $$robo$$android_telecom_ConnectionServiceAdapter$onRttInitiationSuccess(java.lang.String ), this, string2);
    }

    void onRttInitiationFailure(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onRttInitiationFailure", $$robo$$android_telecom_ConnectionServiceAdapter$onRttInitiationFailure(java.lang.String int ), this, string2, n);
    }

    void onRttSessionRemotelyTerminated(String string2) {
        InvokeDynamicSupport.bootstrap("onRttSessionRemotelyTerminated", $$robo$$android_telecom_ConnectionServiceAdapter$onRttSessionRemotelyTerminated(java.lang.String ), this, string2);
    }

    void onRemoteRttRequest(String string2) {
        InvokeDynamicSupport.bootstrap("onRemoteRttRequest", $$robo$$android_telecom_ConnectionServiceAdapter$onRemoteRttRequest(java.lang.String ), this, string2);
    }

    void onPhoneAccountChanged(String string2, PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("onPhoneAccountChanged", $$robo$$android_telecom_ConnectionServiceAdapter$onPhoneAccountChanged(java.lang.String android.telecom.PhoneAccountHandle ), this, string2, phoneAccountHandle);
    }

    void onConnectionServiceFocusReleased() {
        InvokeDynamicSupport.bootstrap("onConnectionServiceFocusReleased", $$robo$$android_telecom_ConnectionServiceAdapter$onConnectionServiceFocusReleased(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionServiceAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

