/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScheduleCalendar
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String TAG = "ScheduleCalendar";
    public static boolean DEBUG;
    private ArraySet<Integer> mDays;
    private Calendar mCalendar;
    private ZenModeConfig.ScheduleInfo mSchedule;

    private void $$robo$$android_service_notification_ScheduleCalendar$__constructor__() {
        this.mDays = new ArraySet();
        this.mCalendar = Calendar.getInstance();
    }

    private final String $$robo$$android_service_notification_ScheduleCalendar$toString() {
        return "ScheduleCalendar[mDays=" + this.mDays + ", mSchedule=" + this.mSchedule + "]";
    }

    private final boolean $$robo$$android_service_notification_ScheduleCalendar$exitAtAlarm() {
        return this.mSchedule.exitAtAlarm;
    }

    private final void $$robo$$android_service_notification_ScheduleCalendar$setSchedule(ZenModeConfig.ScheduleInfo schedule) {
        if (Objects.equals(this.mSchedule, schedule)) {
            return;
        }
        this.mSchedule = schedule;
        this.updateDays();
    }

    private final void $$robo$$android_service_notification_ScheduleCalendar$maybeSetNextAlarm(long now, long nextAlarm) {
        if (this.mSchedule != null && this.mSchedule.exitAtAlarm) {
            if (nextAlarm == 0L) {
                this.mSchedule.nextAlarm = 0L;
            }
            if (nextAlarm > now) {
                this.mSchedule.nextAlarm = this.mSchedule.nextAlarm == 0L ? nextAlarm : Math.min(this.mSchedule.nextAlarm, nextAlarm);
            } else if (this.mSchedule.nextAlarm < now) {
                if (DEBUG) {
                    Log.d("ScheduleCalendar", "All alarms are in the past " + this.mSchedule.nextAlarm);
                }
                this.mSchedule.nextAlarm = 0L;
            }
        }
    }

    private final void $$robo$$android_service_notification_ScheduleCalendar$setTimeZone(TimeZone tz) {
        this.mCalendar.setTimeZone(tz);
    }

    private final long $$robo$$android_service_notification_ScheduleCalendar$getNextChangeTime(long now) {
        if (this.mSchedule == null) {
            return 0L;
        }
        long nextStart = this.getNextTime(now, this.mSchedule.startHour, this.mSchedule.startMinute);
        long nextEnd = this.getNextTime(now, this.mSchedule.endHour, this.mSchedule.endMinute);
        long nextScheduleTime = Math.min(nextStart, nextEnd);
        return nextScheduleTime;
    }

    private final long $$robo$$android_service_notification_ScheduleCalendar$getNextTime(long now, int hr, int min) {
        long time = this.getTime(now, hr, min);
        return time <= now ? this.addDays(time, 1) : time;
    }

    private final long $$robo$$android_service_notification_ScheduleCalendar$getTime(long millis, int hour, int min) {
        this.mCalendar.setTimeInMillis(millis);
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, min);
        this.mCalendar.set(13, 0);
        this.mCalendar.set(14, 0);
        return this.mCalendar.getTimeInMillis();
    }

    private final boolean $$robo$$android_service_notification_ScheduleCalendar$isInSchedule(long time) {
        if (this.mSchedule == null || this.mDays.size() == 0) {
            return false;
        }
        long start = this.getTime(time, this.mSchedule.startHour, this.mSchedule.startMinute);
        long end = this.getTime(time, this.mSchedule.endHour, this.mSchedule.endMinute);
        if (end <= start) {
            end = this.addDays(end, 1);
        }
        return this.isInSchedule(-1, time, start, end) || this.isInSchedule(0, time, start, end);
    }

    private final boolean $$robo$$android_service_notification_ScheduleCalendar$isAlarmInSchedule(long alarm, long now) {
        if (this.mSchedule == null || this.mDays.size() == 0) {
            return false;
        }
        long start = this.getTime(alarm, this.mSchedule.startHour, this.mSchedule.startMinute);
        long end = this.getTime(alarm, this.mSchedule.endHour, this.mSchedule.endMinute);
        if (end <= start) {
            end = this.addDays(end, 1);
        }
        return this.isInSchedule(-1, alarm, start, end) && this.isInSchedule(-1, now, start, end) || this.isInSchedule(0, alarm, start, end) && this.isInSchedule(0, now, start, end);
    }

    private final boolean $$robo$$android_service_notification_ScheduleCalendar$shouldExitForAlarm(long time) {
        if (this.mSchedule == null) {
            return false;
        }
        return this.mSchedule.exitAtAlarm && this.mSchedule.nextAlarm != 0L && time >= this.mSchedule.nextAlarm && this.isAlarmInSchedule(this.mSchedule.nextAlarm, time);
    }

    private final boolean $$robo$$android_service_notification_ScheduleCalendar$isInSchedule(int daysOffset, long time, long start, long end) {
        int n = 7;
        int day = (this.getDayOfWeek(time) - 1 + daysOffset % 7 + 7) % 7 + 1;
        start = this.addDays(start, daysOffset);
        end = this.addDays(end, daysOffset);
        return this.mDays.contains(day) && time >= start && time < end;
    }

    private final int $$robo$$android_service_notification_ScheduleCalendar$getDayOfWeek(long time) {
        this.mCalendar.setTimeInMillis(time);
        return this.mCalendar.get(7);
    }

    private final void $$robo$$android_service_notification_ScheduleCalendar$updateDays() {
        this.mDays.clear();
        if (this.mSchedule != null && this.mSchedule.days != null) {
            for (int i = 0; i < this.mSchedule.days.length; ++i) {
                this.mDays.add(this.mSchedule.days[i]);
            }
        }
    }

    private final long $$robo$$android_service_notification_ScheduleCalendar$addDays(long time, int days) {
        this.mCalendar.setTimeInMillis(time);
        this.mCalendar.add(5, days);
        return this.mCalendar.getTimeInMillis();
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("ConditionProviders", 3);
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_ScheduleCalendar$__constructor__();
    }

    public ScheduleCalendar() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ScheduleCalendar$__constructor__(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_notification_ScheduleCalendar$toString(), this);
    }

    public boolean exitAtAlarm() {
        return (boolean)InvokeDynamicSupport.bootstrap("exitAtAlarm", $$robo$$android_service_notification_ScheduleCalendar$exitAtAlarm(), this);
    }

    public void setSchedule(ZenModeConfig.ScheduleInfo scheduleInfo) {
        InvokeDynamicSupport.bootstrap("setSchedule", $$robo$$android_service_notification_ScheduleCalendar$setSchedule(android.service.notification.ZenModeConfig$ScheduleInfo ), this, scheduleInfo);
    }

    public void maybeSetNextAlarm(long l, long l2) {
        InvokeDynamicSupport.bootstrap("maybeSetNextAlarm", $$robo$$android_service_notification_ScheduleCalendar$maybeSetNextAlarm(long long ), this, l, l2);
    }

    public void setTimeZone(TimeZone timeZone) {
        InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_service_notification_ScheduleCalendar$setTimeZone(java.util.TimeZone ), this, timeZone);
    }

    public long getNextChangeTime(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getNextChangeTime", $$robo$$android_service_notification_ScheduleCalendar$getNextChangeTime(long ), this, l);
    }

    private long getNextTime(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getNextTime", $$robo$$android_service_notification_ScheduleCalendar$getNextTime(long int int ), this, l, n, n2);
    }

    private long getTime(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_service_notification_ScheduleCalendar$getTime(long int int ), this, l, n, n2);
    }

    public boolean isInSchedule(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInSchedule", $$robo$$android_service_notification_ScheduleCalendar$isInSchedule(long ), this, l);
    }

    public boolean isAlarmInSchedule(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlarmInSchedule", $$robo$$android_service_notification_ScheduleCalendar$isAlarmInSchedule(long long ), this, l, l2);
    }

    public boolean shouldExitForAlarm(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldExitForAlarm", $$robo$$android_service_notification_ScheduleCalendar$shouldExitForAlarm(long ), this, l);
    }

    private boolean isInSchedule(int n, long l, long l2, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInSchedule", $$robo$$android_service_notification_ScheduleCalendar$isInSchedule(int long long long ), this, n, l, l2, l3);
    }

    private int getDayOfWeek(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfWeek", $$robo$$android_service_notification_ScheduleCalendar$getDayOfWeek(long ), this, l);
    }

    private void updateDays() {
        InvokeDynamicSupport.bootstrap("updateDays", $$robo$$android_service_notification_ScheduleCalendar$updateDays(), this);
    }

    private long addDays(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("addDays", $$robo$$android_service_notification_ScheduleCalendar$addDays(long int ), this, l, n);
    }

    static {
        RobolectricInternals.classInitializing(ScheduleCalendar.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScheduleCalendar)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

