/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.metrics.LogMaker;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AutofillServiceInfo
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AutofillServiceInfo";
    private static String TAG_AUTOFILL_SERVICE = "autofill-service";
    private static String TAG_COMPATIBILITY_PACKAGE = "compatibility-package";
    private ServiceInfo mServiceInfo;
    private String mSettingsActivity;
    private ArrayMap<String, Long> mCompatibilityPackages;

    private static final ServiceInfo $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfoOrThrow(ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = AppGlobals.getPackageManager().getServiceInfo(comp, 128, userHandle);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new PackageManager.NameNotFoundException(comp.toString());
    }

    private void $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(Context context, ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(Context context, ServiceInfo si) {
        ArrayMap<String, Long> compatibilityPackages;
        String settingsActivity;
        block13: {
            if (!"android.permission.BIND_AUTOFILL_SERVICE".equals(si.permission)) {
                if ("android.permission.BIND_AUTOFILL".equals(si.permission)) {
                    Log.w("AutofillServiceInfo", "AutofillService from '" + si.packageName + "' uses unsupported permission " + "android.permission.BIND_AUTOFILL" + ". It works for now, but might not be supported on future releases");
                    new MetricsLogger().write(new LogMaker(1289).setPackageName(si.packageName));
                } else {
                    Log.w("AutofillServiceInfo", "AutofillService from '" + si.packageName + "' does not require permission " + "android.permission.BIND_AUTOFILL_SERVICE");
                    throw new SecurityException("Service does not require permission android.permission.BIND_AUTOFILL_SERVICE");
                }
            }
            this.mServiceInfo = si;
            XmlResourceParser parser = si.loadXmlMetaData(context.getPackageManager(), "android.autofill");
            if (parser == null) {
                this.mSettingsActivity = null;
                this.mCompatibilityPackages = null;
                return;
            }
            settingsActivity = null;
            compatibilityPackages = null;
            try {
                Resources resources = context.getPackageManager().getResourcesForApplication(si.applicationInfo);
                int type = 0;
                while (type != 1 && type != 2) {
                    type = parser.next();
                }
                if ("autofill-service".equals(parser.getName())) {
                    AttributeSet allAttributes = Xml.asAttributeSet(parser);
                    TypedArray afsAttributes = null;
                    try {
                        afsAttributes = resources.obtainAttributes(allAttributes, R.styleable.AutofillService);
                        settingsActivity = afsAttributes.getString(0);
                    }
                    finally {
                        if (afsAttributes != null) {
                            afsAttributes.recycle();
                        }
                    }
                    compatibilityPackages = this.parseCompatibilityPackages(parser, resources);
                    break block13;
                }
                Log.e("AutofillServiceInfo", "Meta-data does not start with autofill-service tag");
            }
            catch (PackageManager.NameNotFoundException | IOException | XmlPullParserException e) {
                Log.e("AutofillServiceInfo", "Error parsing auto fill service meta-data", e);
            }
        }
        this.mSettingsActivity = settingsActivity;
        this.mCompatibilityPackages = compatibilityPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayMap<String, Long> $$robo$$android_service_autofill_AutofillServiceInfo$parseCompatibilityPackages(XmlPullParser parser, Resources resources) throws IOException, XmlPullParserException {
        int type;
        ArrayMap<String, Long> compatibilityPackages = null;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4 || !"compatibility-package".equals(parser.getName())) continue;
            TypedArray cpAttributes = null;
            try {
                Long maxVersionCode;
                AttributeSet allAttributes = Xml.asAttributeSet(parser);
                cpAttributes = resources.obtainAttributes(allAttributes, R.styleable.AutofillService_CompatibilityPackage);
                String name = cpAttributes.getString(0);
                if (TextUtils.isEmpty(name)) {
                    Log.e("AutofillServiceInfo", "Invalid compatibility package:" + name);
                    break;
                }
                String maxVersionCodeStr = cpAttributes.getString(1);
                if (maxVersionCodeStr != null) {
                    try {
                        maxVersionCode = Long.parseLong(maxVersionCodeStr);
                    }
                    catch (NumberFormatException e) {
                        Log.e("AutofillServiceInfo", "Invalid compatibility max version code:" + maxVersionCodeStr);
                        XmlUtils.skipCurrentTag(parser);
                        if (cpAttributes == null) break;
                        cpAttributes.recycle();
                        break;
                    }
                    if (maxVersionCode < 0L) {
                        Log.e("AutofillServiceInfo", "Invalid compatibility max version code:" + maxVersionCode);
                        break;
                    }
                } else {
                    maxVersionCode = Long.MAX_VALUE;
                }
                if (compatibilityPackages == null) {
                    compatibilityPackages = new ArrayMap<String, Long>();
                }
                compatibilityPackages.put(name, maxVersionCode);
            }
            finally {
                XmlUtils.skipCurrentTag(parser);
                if (cpAttributes == null) continue;
                cpAttributes.recycle();
            }
        }
        return compatibilityPackages;
    }

    private final ServiceInfo $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfo() {
        return this.mServiceInfo;
    }

    private final String $$robo$$android_service_autofill_AutofillServiceInfo$getSettingsActivity() {
        return this.mSettingsActivity;
    }

    private final ArrayMap<String, Long> $$robo$$android_service_autofill_AutofillServiceInfo$getCompatibilityPackages() {
        return this.mCompatibilityPackages;
    }

    private final String $$robo$$android_service_autofill_AutofillServiceInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[").append(this.mServiceInfo);
        builder.append(", settings:").append(this.mSettingsActivity);
        builder.append(", hasCompatPckgs:").append(this.mCompatibilityPackages != null && !this.mCompatibilityPackages.isEmpty()).append("]");
        return builder.toString();
    }

    private final void $$robo$$android_service_autofill_AutofillServiceInfo$dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("Component: ");
        pw.println(this.getServiceInfo().getComponentName());
        pw.print(prefix);
        pw.print("Settings: ");
        pw.println(this.mSettingsActivity);
        pw.print(prefix);
        pw.print("Compat packages: ");
        pw.println(this.mCompatibilityPackages);
    }

    private static ServiceInfo getServiceInfoOrThrow(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getServiceInfoOrThrow", $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfoOrThrow(android.content.ComponentName int ), (ComponentName)componentName, (int)n);
    }

    private void __constructor__(Context context, ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        this.$$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(context, componentName, n);
    }

    public AutofillServiceInfo(Context context, ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        this(context, AutofillServiceInfo.getServiceInfoOrThrow(componentName, n));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(android.content.Context android.content.ComponentName int ), this, context, componentName, n);
    }

    private void __constructor__(Context context, ServiceInfo serviceInfo) {
        this.$$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(context, serviceInfo);
    }

    public AutofillServiceInfo(Context context, ServiceInfo serviceInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(android.content.Context android.content.pm.ServiceInfo ), this, context, serviceInfo);
    }

    private ArrayMap<String, Long> parseCompatibilityPackages(XmlPullParser xmlPullParser, Resources resources) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("parseCompatibilityPackages", $$robo$$android_service_autofill_AutofillServiceInfo$parseCompatibilityPackages(org.xmlpull.v1.XmlPullParser android.content.res.Resources ), this, xmlPullParser, resources);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfo(), this);
    }

    public String getSettingsActivity() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivity", $$robo$$android_service_autofill_AutofillServiceInfo$getSettingsActivity(), this);
    }

    public ArrayMap<String, Long> getCompatibilityPackages() {
        return InvokeDynamicSupport.bootstrap("getCompatibilityPackages", $$robo$$android_service_autofill_AutofillServiceInfo$getCompatibilityPackages(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_AutofillServiceInfo$toString(), this);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_autofill_AutofillServiceInfo$dump(java.lang.String java.io.PrintWriter ), this, string2, printWriter);
    }

    public /* synthetic */ AutofillServiceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

