/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.Log;
import java.lang.invoke.CallSite;
import java.util.concurrent.Semaphore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SearchRecentSuggestions
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SearchSuggestions";
    public static String[] QUERIES_PROJECTION_1LINE;
    public static String[] QUERIES_PROJECTION_2LINE;
    public static int QUERIES_PROJECTION_DATE_INDEX = 1;
    public static int QUERIES_PROJECTION_QUERY_INDEX = 2;
    public static int QUERIES_PROJECTION_DISPLAY1_INDEX = 3;
    public static int QUERIES_PROJECTION_DISPLAY2_INDEX = 4;
    private static int MAX_HISTORY_COUNT = 250;
    private Context mContext;
    private String mAuthority;
    private boolean mTwoLineDisplay;
    private Uri mSuggestionsUri;
    private static Semaphore sWritesInProgress;

    private void $$robo$$android_provider_SearchRecentSuggestions$__constructor__(Context context, String authority, int mode) {
        if (TextUtils.isEmpty(authority) || (mode & 1) == 0) {
            throw new IllegalArgumentException();
        }
        this.mTwoLineDisplay = 0 != (mode & 2);
        this.mContext = context;
        this.mAuthority = new String(authority);
        this.mSuggestionsUri = Uri.parse("content://" + this.mAuthority + "/suggestions");
    }

    private final void $$robo$$android_provider_SearchRecentSuggestions$saveRecentQuery(String queryString, String line2) {
        if (TextUtils.isEmpty(queryString)) {
            return;
        }
        if (!this.mTwoLineDisplay && !TextUtils.isEmpty(line2)) {
            throw new IllegalArgumentException();
        }
        new ShadowedObject(this, "saveRecentQuery", queryString, line2){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$queryString;
            /* synthetic */ String val$line2;
            /* synthetic */ SearchRecentSuggestions this$0;

            private void $$robo$$android_provider_SearchRecentSuggestions_1$__constructor__(SearchRecentSuggestions this$0, String x0, String string2, String string3) {
                this.this$0 = this$0;
                this.val$queryString = string2;
                this.val$line2 = string3;
            }

            private final void $$robo$$android_provider_SearchRecentSuggestions_1$run() {
                this.this$0.saveRecentQueryBlocking(this.val$queryString, this.val$line2);
                sWritesInProgress.release();
            }

            private void __constructor__(SearchRecentSuggestions searchRecentSuggestions, String string2, String string3, String string4) {
                this.$$robo$$android_provider_SearchRecentSuggestions_1$__constructor__(searchRecentSuggestions, string2, string3, string4);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_SearchRecentSuggestions_1$__constructor__(android.provider.SearchRecentSuggestions java.lang.String java.lang.String java.lang.String ), this, searchRecentSuggestions, string2, string3, string4);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_provider_SearchRecentSuggestions_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private final void $$robo$$android_provider_SearchRecentSuggestions$waitForSave() {
        do {
            sWritesInProgress.acquireUninterruptibly();
        } while (sWritesInProgress.availablePermits() > 0);
    }

    private final void $$robo$$android_provider_SearchRecentSuggestions$saveRecentQueryBlocking(String queryString, String line2) {
        ContentResolver cr = this.mContext.getContentResolver();
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        try {
            ContentValues values = new ContentValues();
            values.put("display1", queryString);
            if (this.mTwoLineDisplay) {
                values.put("display2", line2);
            }
            values.put("query", queryString);
            values.put("date", (long)now);
            cr.insert(this.mSuggestionsUri, values);
        }
        catch (RuntimeException e) {
            Log.e("SearchSuggestions", "saveRecentQuery", e);
        }
        this.truncateHistory(cr, 250);
    }

    private final void $$robo$$android_provider_SearchRecentSuggestions$clearHistory() {
        ContentResolver cr = this.mContext.getContentResolver();
        this.truncateHistory(cr, 0);
    }

    private final void $$robo$$android_provider_SearchRecentSuggestions$truncateHistory(ContentResolver cr, int maxEntries) {
        if (maxEntries < 0) {
            throw new IllegalArgumentException();
        }
        try {
            String selection = null;
            if (maxEntries > 0) {
                selection = "_id IN (SELECT _id FROM suggestions ORDER BY date DESC LIMIT -1 OFFSET " + String.valueOf(maxEntries) + ")";
            }
            cr.delete(this.mSuggestionsUri, selection, null);
        }
        catch (RuntimeException e) {
            Log.e("SearchSuggestions", "truncateHistory", e);
        }
    }

    static void __staticInitializer__() {
        QUERIES_PROJECTION_1LINE = new String[]{"_id", "date", "query", "display1"};
        QUERIES_PROJECTION_2LINE = new String[]{"_id", "date", "query", "display1", "display2"};
        sWritesInProgress = new Semaphore(0);
    }

    private void __constructor__(Context context, String string2, int n) {
        this.$$robo$$android_provider_SearchRecentSuggestions$__constructor__(context, string2, n);
    }

    public SearchRecentSuggestions(Context context, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_SearchRecentSuggestions$__constructor__(android.content.Context java.lang.String int ), this, context, string2, n);
    }

    public void saveRecentQuery(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("saveRecentQuery", $$robo$$android_provider_SearchRecentSuggestions$saveRecentQuery(java.lang.String java.lang.String ), this, string2, string3);
    }

    void waitForSave() {
        InvokeDynamicSupport.bootstrap("waitForSave", $$robo$$android_provider_SearchRecentSuggestions$waitForSave(), this);
    }

    private void saveRecentQueryBlocking(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("saveRecentQueryBlocking", $$robo$$android_provider_SearchRecentSuggestions$saveRecentQueryBlocking(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void clearHistory() {
        InvokeDynamicSupport.bootstrap("clearHistory", $$robo$$android_provider_SearchRecentSuggestions$clearHistory(), this);
    }

    protected void truncateHistory(ContentResolver contentResolver, int n) {
        InvokeDynamicSupport.bootstrap("truncateHistory", $$robo$$android_provider_SearchRecentSuggestions$truncateHistory(android.content.ContentResolver int ), this, contentResolver, n);
    }

    static {
        RobolectricInternals.classInitializing(SearchRecentSuggestions.class);
    }

    public /* synthetic */ SearchRecentSuggestions() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchRecentSuggestions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SuggestionColumns
    implements BaseColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static String DISPLAY1 = "display1";
        public static String DISPLAY2 = "display2";
        public static String QUERY = "query";
        public static String DATE = "date";

        private void $$robo$$android_provider_SearchRecentSuggestions_SuggestionColumns$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_SearchRecentSuggestions_SuggestionColumns$__constructor__();
        }

        public SuggestionColumns() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_SearchRecentSuggestions_SuggestionColumns$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionColumns)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

