/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.PreferenceDataStore;
import android.preference.PreferenceGroup;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.CharSequences;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Preference
implements Comparable<Preference> {
    public /* synthetic */ Object __robo_data__;
    public static int DEFAULT_ORDER = Integer.MAX_VALUE;
    private Context mContext;
    private PreferenceManager mPreferenceManager;
    private PreferenceDataStore mPreferenceDataStore;
    private long mId;
    private OnPreferenceChangeListener mOnChangeListener;
    private OnPreferenceClickListener mOnClickListener;
    private int mOrder;
    private CharSequence mTitle;
    private int mTitleRes;
    private CharSequence mSummary;
    private int mIconResId;
    private Drawable mIcon;
    private String mKey;
    private Intent mIntent;
    private String mFragment;
    private Bundle mExtras;
    private boolean mEnabled;
    private boolean mSelectable;
    private boolean mRequiresKey;
    private boolean mPersistent;
    private String mDependencyKey;
    private Object mDefaultValue;
    private boolean mDependencyMet;
    private boolean mParentDependencyMet;
    private boolean mRecycleEnabled;
    private boolean mHasSingleLineTitleAttr;
    private boolean mSingleLineTitle;
    private boolean mIconSpaceReserved;
    private boolean mShouldDisableView;
    private int mLayoutResId;
    private int mWidgetLayoutResId;
    private OnPreferenceChangeInternalListener mListener;
    private List<Preference> mDependents;
    private PreferenceGroup mParentGroup;
    private boolean mBaseMethodCalled;

    private void $$robo$$android_preference_Preference$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mOrder = Integer.MAX_VALUE;
        this.mEnabled = true;
        this.mSelectable = true;
        this.mPersistent = true;
        this.mDependencyMet = true;
        this.mParentDependencyMet = true;
        this.mRecycleEnabled = true;
        this.mSingleLineTitle = true;
        this.mShouldDisableView = true;
        this.mLayoutResId = 17367215;
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Preference, defStyleAttr, defStyleRes);
        block19: for (int i = a.getIndexCount() - 1; i >= 0; --i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.mIconResId = a.getResourceId(attr2, 0);
                    continue block19;
                }
                case 6: {
                    this.mKey = a.getString(attr2);
                    continue block19;
                }
                case 4: {
                    this.mTitleRes = a.getResourceId(attr2, 0);
                    this.mTitle = a.getText(attr2);
                    continue block19;
                }
                case 7: {
                    this.mSummary = a.getText(attr2);
                    continue block19;
                }
                case 8: {
                    this.mOrder = a.getInt(attr2, this.mOrder);
                    continue block19;
                }
                case 13: {
                    this.mFragment = a.getString(attr2);
                    continue block19;
                }
                case 3: {
                    this.mLayoutResId = a.getResourceId(attr2, this.mLayoutResId);
                    continue block19;
                }
                case 9: {
                    this.mWidgetLayoutResId = a.getResourceId(attr2, this.mWidgetLayoutResId);
                    continue block19;
                }
                case 2: {
                    this.mEnabled = a.getBoolean(attr2, true);
                    continue block19;
                }
                case 5: {
                    this.mSelectable = a.getBoolean(attr2, true);
                    continue block19;
                }
                case 1: {
                    this.mPersistent = a.getBoolean(attr2, this.mPersistent);
                    continue block19;
                }
                case 10: {
                    this.mDependencyKey = a.getString(attr2);
                    continue block19;
                }
                case 11: {
                    this.mDefaultValue = this.onGetDefaultValue(a, attr2);
                    continue block19;
                }
                case 12: {
                    this.mShouldDisableView = a.getBoolean(attr2, this.mShouldDisableView);
                    continue block19;
                }
                case 14: {
                    this.mRecycleEnabled = a.getBoolean(attr2, this.mRecycleEnabled);
                    continue block19;
                }
                case 15: {
                    this.mSingleLineTitle = a.getBoolean(attr2, this.mSingleLineTitle);
                    this.mHasSingleLineTitleAttr = true;
                    continue block19;
                }
                case 16: {
                    this.mIconSpaceReserved = a.getBoolean(attr2, this.mIconSpaceReserved);
                }
            }
        }
        a.recycle();
    }

    private void $$robo$$android_preference_Preference$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_preference_Preference$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_preference_Preference$__constructor__(Context context) {
    }

    private final Object $$robo$$android_preference_Preference$onGetDefaultValue(TypedArray a, int index) {
        return null;
    }

    private final void $$robo$$android_preference_Preference$setIntent(Intent intent) {
        this.mIntent = intent;
    }

    private final Intent $$robo$$android_preference_Preference$getIntent() {
        return this.mIntent;
    }

    private final void $$robo$$android_preference_Preference$setFragment(String fragment) {
        this.mFragment = fragment;
    }

    private final String $$robo$$android_preference_Preference$getFragment() {
        return this.mFragment;
    }

    private final void $$robo$$android_preference_Preference$setPreferenceDataStore(PreferenceDataStore dataStore) {
        this.mPreferenceDataStore = dataStore;
    }

    private final PreferenceDataStore $$robo$$android_preference_Preference$getPreferenceDataStore() {
        if (this.mPreferenceDataStore != null) {
            return this.mPreferenceDataStore;
        }
        if (this.mPreferenceManager != null) {
            return this.mPreferenceManager.getPreferenceDataStore();
        }
        return null;
    }

    private final Bundle $$robo$$android_preference_Preference$getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    private final Bundle $$robo$$android_preference_Preference$peekExtras() {
        return this.mExtras;
    }

    private final void $$robo$$android_preference_Preference$setLayoutResource(int layoutResId) {
        if (layoutResId != this.mLayoutResId) {
            this.mRecycleEnabled = false;
        }
        this.mLayoutResId = layoutResId;
    }

    private final int $$robo$$android_preference_Preference$getLayoutResource() {
        return this.mLayoutResId;
    }

    private final void $$robo$$android_preference_Preference$setWidgetLayoutResource(int widgetLayoutResId) {
        if (widgetLayoutResId != this.mWidgetLayoutResId) {
            this.mRecycleEnabled = false;
        }
        this.mWidgetLayoutResId = widgetLayoutResId;
    }

    private final int $$robo$$android_preference_Preference$getWidgetLayoutResource() {
        return this.mWidgetLayoutResId;
    }

    private final View $$robo$$android_preference_Preference$getView(View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.onCreateView(parent);
        }
        this.onBindView(convertView);
        return convertView;
    }

    private final View $$robo$$android_preference_Preference$onCreateView(ViewGroup parent) {
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View layout2 = layoutInflater.inflate(this.mLayoutResId, parent, false);
        ViewGroup widgetFrame = (ViewGroup)layout2.findViewById(16908312);
        if (widgetFrame != null) {
            if (this.mWidgetLayoutResId != 0) {
                layoutInflater.inflate(this.mWidgetLayoutResId, widgetFrame);
            } else {
                widgetFrame.setVisibility(8);
            }
        }
        return layout2;
    }

    private final void $$robo$$android_preference_Preference$onBindView(View view) {
        Object imageFrame;
        ImageView imageView;
        TextView summaryView;
        TextView titleView = (TextView)view.findViewById(16908310);
        if (titleView != null) {
            CharSequence title = this.getTitle();
            if (!TextUtils.isEmpty(title)) {
                titleView.setText(title);
                titleView.setVisibility(0);
                if (this.mHasSingleLineTitleAttr) {
                    titleView.setSingleLine(this.mSingleLineTitle);
                }
            } else {
                titleView.setVisibility(8);
            }
        }
        if ((summaryView = (TextView)view.findViewById(0x1020010)) != null) {
            CharSequence summary = this.getSummary();
            if (!TextUtils.isEmpty(summary)) {
                summaryView.setText(summary);
                summaryView.setVisibility(0);
            } else {
                summaryView.setVisibility(8);
            }
        }
        if ((imageView = (ImageView)view.findViewById(16908294)) != null) {
            if (this.mIconResId != 0 || this.mIcon != null) {
                if (this.mIcon == null) {
                    this.mIcon = this.getContext().getDrawable(this.mIconResId);
                }
                if (this.mIcon != null) {
                    imageView.setImageDrawable(this.mIcon);
                }
            }
            if (this.mIcon != null) {
                imageView.setVisibility(0);
            } else {
                imageView.setVisibility(this.mIconSpaceReserved ? 4 : 8);
            }
        }
        if ((imageFrame = view.findViewById(16908350)) != null) {
            if (this.mIcon != null) {
                ((View)imageFrame).setVisibility(0);
            } else {
                ((View)imageFrame).setVisibility(this.mIconSpaceReserved ? 4 : 8);
            }
        }
        if (this.mShouldDisableView) {
            this.setEnabledStateOnViews(view, this.isEnabled());
        }
    }

    private final void $$robo$$android_preference_Preference$setEnabledStateOnViews(View v, boolean enabled) {
        v.setEnabled(enabled);
        if (v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = vg.getChildCount() - 1; i >= 0; --i) {
                this.setEnabledStateOnViews(vg.getChildAt(i), enabled);
            }
        }
    }

    private final void $$robo$$android_preference_Preference$setOrder(int order) {
        if (order != this.mOrder) {
            this.mOrder = order;
            this.notifyHierarchyChanged();
        }
    }

    private final int $$robo$$android_preference_Preference$getOrder() {
        return this.mOrder;
    }

    private final void $$robo$$android_preference_Preference$setTitle(CharSequence title) {
        if (title == null && this.mTitle != null || title != null && !title.equals(this.mTitle)) {
            this.mTitleRes = 0;
            this.mTitle = title;
            this.notifyChanged();
        }
    }

    private final void $$robo$$android_preference_Preference$setTitle(int titleResId) {
        this.setTitle(this.mContext.getString(titleResId));
        this.mTitleRes = titleResId;
    }

    private final int $$robo$$android_preference_Preference$getTitleRes() {
        return this.mTitleRes;
    }

    private final CharSequence $$robo$$android_preference_Preference$getTitle() {
        return this.mTitle;
    }

    private final void $$robo$$android_preference_Preference$setIcon(Drawable icon) {
        if (icon == null && this.mIcon != null || icon != null && this.mIcon != icon) {
            this.mIcon = icon;
            this.notifyChanged();
        }
    }

    private final void $$robo$$android_preference_Preference$setIcon(int iconResId) {
        if (this.mIconResId != iconResId) {
            this.mIconResId = iconResId;
            this.setIcon(this.mContext.getDrawable(iconResId));
        }
    }

    private final Drawable $$robo$$android_preference_Preference$getIcon() {
        if (this.mIcon == null && this.mIconResId != 0) {
            this.mIcon = this.getContext().getDrawable(this.mIconResId);
        }
        return this.mIcon;
    }

    private final CharSequence $$robo$$android_preference_Preference$getSummary() {
        return this.mSummary;
    }

    private final void $$robo$$android_preference_Preference$setSummary(CharSequence summary) {
        if (summary == null && this.mSummary != null || summary != null && !summary.equals(this.mSummary)) {
            this.mSummary = summary;
            this.notifyChanged();
        }
    }

    private final void $$robo$$android_preference_Preference$setSummary(int summaryResId) {
        this.setSummary(this.mContext.getString(summaryResId));
    }

    private final void $$robo$$android_preference_Preference$setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    private final boolean $$robo$$android_preference_Preference$isEnabled() {
        return this.mEnabled && this.mDependencyMet && this.mParentDependencyMet;
    }

    private final void $$robo$$android_preference_Preference$setSelectable(boolean selectable) {
        if (this.mSelectable != selectable) {
            this.mSelectable = selectable;
            this.notifyChanged();
        }
    }

    private final boolean $$robo$$android_preference_Preference$isSelectable() {
        return this.mSelectable;
    }

    private final void $$robo$$android_preference_Preference$setShouldDisableView(boolean shouldDisableView) {
        this.mShouldDisableView = shouldDisableView;
        this.notifyChanged();
    }

    private final boolean $$robo$$android_preference_Preference$getShouldDisableView() {
        return this.mShouldDisableView;
    }

    private final void $$robo$$android_preference_Preference$setRecycleEnabled(boolean enabled) {
        this.mRecycleEnabled = enabled;
        this.notifyChanged();
    }

    private final boolean $$robo$$android_preference_Preference$isRecycleEnabled() {
        return this.mRecycleEnabled;
    }

    private final void $$robo$$android_preference_Preference$setSingleLineTitle(boolean singleLineTitle) {
        this.mHasSingleLineTitleAttr = true;
        this.mSingleLineTitle = singleLineTitle;
        this.notifyChanged();
    }

    private final boolean $$robo$$android_preference_Preference$isSingleLineTitle() {
        return this.mSingleLineTitle;
    }

    private final void $$robo$$android_preference_Preference$setIconSpaceReserved(boolean iconSpaceReserved) {
        this.mIconSpaceReserved = iconSpaceReserved;
        this.notifyChanged();
    }

    private final boolean $$robo$$android_preference_Preference$isIconSpaceReserved() {
        return this.mIconSpaceReserved;
    }

    private final long $$robo$$android_preference_Preference$getId() {
        return this.mId;
    }

    private final void $$robo$$android_preference_Preference$onClick() {
    }

    private final void $$robo$$android_preference_Preference$setKey(String key) {
        this.mKey = key;
        if (this.mRequiresKey && !this.hasKey()) {
            this.requireKey();
        }
    }

    private final String $$robo$$android_preference_Preference$getKey() {
        return this.mKey;
    }

    private final void $$robo$$android_preference_Preference$requireKey() {
        if (this.mKey == null) {
            throw new IllegalStateException("Preference does not have a key assigned.");
        }
        this.mRequiresKey = true;
    }

    private final boolean $$robo$$android_preference_Preference$hasKey() {
        return !TextUtils.isEmpty(this.mKey);
    }

    private final boolean $$robo$$android_preference_Preference$isPersistent() {
        return this.mPersistent;
    }

    private final boolean $$robo$$android_preference_Preference$shouldPersist() {
        return this.mPreferenceManager != null && this.isPersistent() && this.hasKey();
    }

    private final void $$robo$$android_preference_Preference$setPersistent(boolean persistent) {
        this.mPersistent = persistent;
    }

    private final boolean $$robo$$android_preference_Preference$callChangeListener(Object newValue) {
        return this.mOnChangeListener == null || this.mOnChangeListener.onPreferenceChange(this, newValue);
    }

    private final void $$robo$$android_preference_Preference$setOnPreferenceChangeListener(OnPreferenceChangeListener onPreferenceChangeListener) {
        this.mOnChangeListener = onPreferenceChangeListener;
    }

    private final OnPreferenceChangeListener $$robo$$android_preference_Preference$getOnPreferenceChangeListener() {
        return this.mOnChangeListener;
    }

    private final void $$robo$$android_preference_Preference$setOnPreferenceClickListener(OnPreferenceClickListener onPreferenceClickListener) {
        this.mOnClickListener = onPreferenceClickListener;
    }

    private final OnPreferenceClickListener $$robo$$android_preference_Preference$getOnPreferenceClickListener() {
        return this.mOnClickListener;
    }

    private final void $$robo$$android_preference_Preference$performClick(PreferenceScreen preferenceScreen) {
        if (!this.isEnabled()) {
            return;
        }
        this.onClick();
        if (this.mOnClickListener != null && this.mOnClickListener.onPreferenceClick(this)) {
            return;
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        if (preferenceManager != null) {
            PreferenceManager.OnPreferenceTreeClickListener listener = preferenceManager.getOnPreferenceTreeClickListener();
            if (preferenceScreen != null && listener != null && listener.onPreferenceTreeClick(preferenceScreen, this)) {
                return;
            }
        }
        if (this.mIntent != null) {
            Context context = this.getContext();
            context.startActivity(this.mIntent);
        }
    }

    private final boolean $$robo$$android_preference_Preference$onKey(View v, int keyCode, KeyEvent event) {
        return false;
    }

    private final Context $$robo$$android_preference_Preference$getContext() {
        return this.mContext;
    }

    private final SharedPreferences $$robo$$android_preference_Preference$getSharedPreferences() {
        if (this.mPreferenceManager == null || this.getPreferenceDataStore() != null) {
            return null;
        }
        return this.mPreferenceManager.getSharedPreferences();
    }

    private final SharedPreferences.Editor $$robo$$android_preference_Preference$getEditor() {
        if (this.mPreferenceManager == null || this.getPreferenceDataStore() != null) {
            return null;
        }
        return this.mPreferenceManager.getEditor();
    }

    private final boolean $$robo$$android_preference_Preference$shouldCommit() {
        if (this.mPreferenceManager == null) {
            return false;
        }
        return this.mPreferenceManager.shouldCommit();
    }

    private final int $$robo$$android_preference_Preference$compareTo(Preference another) {
        if (this.mOrder != another.mOrder) {
            return this.mOrder - another.mOrder;
        }
        if (this.mTitle == another.mTitle) {
            return 0;
        }
        if (this.mTitle == null) {
            return 1;
        }
        if (another.mTitle == null) {
            return -1;
        }
        return CharSequences.compareToIgnoreCase(this.mTitle, another.mTitle);
    }

    private final void $$robo$$android_preference_Preference$setOnPreferenceChangeInternalListener(OnPreferenceChangeInternalListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_preference_Preference$notifyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceChange(this);
        }
    }

    private final void $$robo$$android_preference_Preference$notifyHierarchyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceHierarchyChange(this);
        }
    }

    private final PreferenceManager $$robo$$android_preference_Preference$getPreferenceManager() {
        return this.mPreferenceManager;
    }

    private final void $$robo$$android_preference_Preference$onAttachedToHierarchy(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.mId = preferenceManager.getNextId();
        this.dispatchSetInitialValue();
    }

    private final void $$robo$$android_preference_Preference$onAttachedToActivity() {
        this.registerDependency();
    }

    private final void $$robo$$android_preference_Preference$assignParent(PreferenceGroup parentGroup) {
        this.mParentGroup = parentGroup;
    }

    private final void $$robo$$android_preference_Preference$registerDependency() {
        if (TextUtils.isEmpty(this.mDependencyKey)) {
            return;
        }
        Preference preference = this.findPreferenceInHierarchy(this.mDependencyKey);
        if (preference == null) {
            throw new IllegalStateException("Dependency \"" + this.mDependencyKey + "\" not found for preference \"" + this.mKey + "\" (title: \"" + this.mTitle + "\"");
        }
        preference.registerDependent(this);
    }

    private final void $$robo$$android_preference_Preference$unregisterDependency() {
        Preference oldDependency;
        if (this.mDependencyKey != null && (oldDependency = this.findPreferenceInHierarchy(this.mDependencyKey)) != null) {
            oldDependency.unregisterDependent(this);
        }
    }

    private final Preference $$robo$$android_preference_Preference$findPreferenceInHierarchy(String key) {
        if (TextUtils.isEmpty(key) || this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    private final void $$robo$$android_preference_Preference$registerDependent(Preference dependent) {
        if (this.mDependents == null) {
            this.mDependents = new ArrayList<Preference>();
        }
        this.mDependents.add(dependent);
        dependent.onDependencyChanged(this, this.shouldDisableDependents());
    }

    private final void $$robo$$android_preference_Preference$unregisterDependent(Preference dependent) {
        if (this.mDependents != null) {
            this.mDependents.remove(dependent);
        }
    }

    private final void $$robo$$android_preference_Preference$notifyDependencyChange(boolean disableDependents) {
        List<Preference> dependents = this.mDependents;
        if (dependents == null) {
            return;
        }
        int dependentsCount = dependents.size();
        for (int i = 0; i < dependentsCount; ++i) {
            dependents.get(i).onDependencyChanged(this, disableDependents);
        }
    }

    private final void $$robo$$android_preference_Preference$onDependencyChanged(Preference dependency, boolean disableDependent) {
        if (this.mDependencyMet == disableDependent) {
            this.mDependencyMet = !disableDependent;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    private final void $$robo$$android_preference_Preference$onParentChanged(Preference parent, boolean disableChild) {
        if (this.mParentDependencyMet == disableChild) {
            this.mParentDependencyMet = !disableChild;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    private final boolean $$robo$$android_preference_Preference$shouldDisableDependents() {
        return !this.isEnabled();
    }

    private final void $$robo$$android_preference_Preference$setDependency(String dependencyKey) {
        this.unregisterDependency();
        this.mDependencyKey = dependencyKey;
        this.registerDependency();
    }

    private final String $$robo$$android_preference_Preference$getDependency() {
        return this.mDependencyKey;
    }

    private final PreferenceGroup $$robo$$android_preference_Preference$getParent() {
        return this.mParentGroup;
    }

    private final void $$robo$$android_preference_Preference$onPrepareForRemoval() {
        this.unregisterDependency();
    }

    private final void $$robo$$android_preference_Preference$setDefaultValue(Object defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    private final void $$robo$$android_preference_Preference$dispatchSetInitialValue() {
        if (this.getPreferenceDataStore() != null) {
            this.onSetInitialValue(true, this.mDefaultValue);
            return;
        }
        boolean shouldPersist = this.shouldPersist();
        if (!shouldPersist || !this.getSharedPreferences().contains(this.mKey)) {
            if (this.mDefaultValue != null) {
                this.onSetInitialValue(false, this.mDefaultValue);
            }
        } else {
            this.onSetInitialValue(true, null);
        }
    }

    private final void $$robo$$android_preference_Preference$onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
    }

    private final void $$robo$$android_preference_Preference$tryCommit(SharedPreferences.Editor editor) {
        if (this.mPreferenceManager.shouldCommit()) {
            try {
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
        }
    }

    private final boolean $$robo$$android_preference_Preference$persistString(String value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (TextUtils.equals(value, this.getPersistedString(null))) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putString(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putString(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    private final String $$robo$$android_preference_Preference$getPersistedString(String defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getString(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getString(this.mKey, defaultReturnValue);
    }

    private final boolean $$robo$$android_preference_Preference$persistStringSet(Set<String> values) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (values.equals(this.getPersistedStringSet(null))) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putStringSet(this.mKey, values);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putStringSet(this.mKey, values);
            this.tryCommit(editor);
        }
        return true;
    }

    private final Set<String> $$robo$$android_preference_Preference$getPersistedStringSet(Set<String> defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getStringSet(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getStringSet(this.mKey, defaultReturnValue);
    }

    private final boolean $$robo$$android_preference_Preference$persistInt(int value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedInt(~value)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putInt(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putInt(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    private final int $$robo$$android_preference_Preference$getPersistedInt(int defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getInt(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getInt(this.mKey, defaultReturnValue);
    }

    private final boolean $$robo$$android_preference_Preference$persistFloat(float value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedFloat(Float.NaN)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putFloat(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putFloat(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    private final float $$robo$$android_preference_Preference$getPersistedFloat(float defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getFloat(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getFloat(this.mKey, defaultReturnValue);
    }

    private final boolean $$robo$$android_preference_Preference$persistLong(long value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedLong(value ^ 0xFFFFFFFFFFFFFFFFL)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putLong(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putLong(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    private final long $$robo$$android_preference_Preference$getPersistedLong(long defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getLong(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getLong(this.mKey, defaultReturnValue);
    }

    private final boolean $$robo$$android_preference_Preference$persistBoolean(boolean value) {
        if (!this.shouldPersist()) {
            return false;
        }
        if (value == this.getPersistedBoolean(!value)) {
            return true;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            dataStore.putBoolean(this.mKey, value);
        } else {
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putBoolean(this.mKey, value);
            this.tryCommit(editor);
        }
        return true;
    }

    private final boolean $$robo$$android_preference_Preference$getPersistedBoolean(boolean defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        PreferenceDataStore dataStore = this.getPreferenceDataStore();
        if (dataStore != null) {
            return dataStore.getBoolean(this.mKey, defaultReturnValue);
        }
        return this.mPreferenceManager.getSharedPreferences().getBoolean(this.mKey, defaultReturnValue);
    }

    private final String $$robo$$android_preference_Preference$toString() {
        return this.getFilterableStringBuilder().toString();
    }

    private final StringBuilder $$robo$$android_preference_Preference$getFilterableStringBuilder() {
        CharSequence summary;
        StringBuilder sb = new StringBuilder();
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty(title)) {
            sb.append(title).append(' ');
        }
        if (!TextUtils.isEmpty(summary = this.getSummary())) {
            sb.append(summary).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private final void $$robo$$android_preference_Preference$saveHierarchyState(Bundle container) {
        this.dispatchSaveInstanceState(container);
    }

    private final void $$robo$$android_preference_Preference$dispatchSaveInstanceState(Bundle container) {
        if (this.hasKey()) {
            this.mBaseMethodCalled = false;
            Parcelable state = this.onSaveInstanceState();
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.putParcelable(this.mKey, state);
            }
        }
    }

    private final Parcelable $$robo$$android_preference_Preference$onSaveInstanceState() {
        this.mBaseMethodCalled = true;
        return BaseSavedState.EMPTY_STATE;
    }

    private final void $$robo$$android_preference_Preference$restoreHierarchyState(Bundle container) {
        this.dispatchRestoreInstanceState(container);
    }

    private final void $$robo$$android_preference_Preference$dispatchRestoreInstanceState(Bundle container) {
        Object state;
        if (this.hasKey() && (state = container.getParcelable(this.mKey)) != null) {
            this.mBaseMethodCalled = false;
            this.onRestoreInstanceState((Parcelable)state);
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    private final void $$robo$$android_preference_Preference$onRestoreInstanceState(Parcelable state) {
        this.mBaseMethodCalled = true;
        if (state != BaseSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class -- expecting Preference State");
        }
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_preference_Preference$__constructor__(context, attributeSet, n, n2);
    }

    public Preference(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_preference_Preference$__constructor__(context, attributeSet, n);
    }

    public Preference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_preference_Preference$__constructor__(context, attributeSet);
    }

    public Preference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842894);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_preference_Preference$__constructor__(context);
    }

    public Preference(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference$__constructor__(android.content.Context ), this, context);
    }

    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return InvokeDynamicSupport.bootstrap("onGetDefaultValue", $$robo$$android_preference_Preference$onGetDefaultValue(android.content.res.TypedArray int ), this, typedArray, n);
    }

    public void setIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_preference_Preference$setIntent(android.content.Intent ), this, intent);
    }

    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_preference_Preference$getIntent(), this);
    }

    public void setFragment(String string2) {
        InvokeDynamicSupport.bootstrap("setFragment", $$robo$$android_preference_Preference$setFragment(java.lang.String ), this, string2);
    }

    public String getFragment() {
        return InvokeDynamicSupport.bootstrap("getFragment", $$robo$$android_preference_Preference$getFragment(), this);
    }

    public void setPreferenceDataStore(PreferenceDataStore preferenceDataStore) {
        InvokeDynamicSupport.bootstrap("setPreferenceDataStore", $$robo$$android_preference_Preference$setPreferenceDataStore(android.preference.PreferenceDataStore ), this, preferenceDataStore);
    }

    public PreferenceDataStore getPreferenceDataStore() {
        return InvokeDynamicSupport.bootstrap("getPreferenceDataStore", $$robo$$android_preference_Preference$getPreferenceDataStore(), this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_preference_Preference$getExtras(), this);
    }

    public Bundle peekExtras() {
        return InvokeDynamicSupport.bootstrap("peekExtras", $$robo$$android_preference_Preference$peekExtras(), this);
    }

    public void setLayoutResource(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutResource", $$robo$$android_preference_Preference$setLayoutResource(int ), this, n);
    }

    public int getLayoutResource() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutResource", $$robo$$android_preference_Preference$getLayoutResource(), this);
    }

    public void setWidgetLayoutResource(int n) {
        InvokeDynamicSupport.bootstrap("setWidgetLayoutResource", $$robo$$android_preference_Preference$setWidgetLayoutResource(int ), this, n);
    }

    public int getWidgetLayoutResource() {
        return (int)InvokeDynamicSupport.bootstrap("getWidgetLayoutResource", $$robo$$android_preference_Preference$getWidgetLayoutResource(), this);
    }

    public View getView(View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_preference_Preference$getView(android.view.View android.view.ViewGroup ), this, view, viewGroup);
    }

    protected View onCreateView(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("onCreateView", $$robo$$android_preference_Preference$onCreateView(android.view.ViewGroup ), this, viewGroup);
    }

    protected void onBindView(View view) {
        InvokeDynamicSupport.bootstrap("onBindView", $$robo$$android_preference_Preference$onBindView(android.view.View ), this, view);
    }

    private void setEnabledStateOnViews(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabledStateOnViews", $$robo$$android_preference_Preference$setEnabledStateOnViews(android.view.View boolean ), this, view, bl);
    }

    public void setOrder(int n) {
        InvokeDynamicSupport.bootstrap("setOrder", $$robo$$android_preference_Preference$setOrder(int ), this, n);
    }

    public int getOrder() {
        return (int)InvokeDynamicSupport.bootstrap("getOrder", $$robo$$android_preference_Preference$getOrder(), this);
    }

    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_preference_Preference$setTitle(java.lang.CharSequence ), this, charSequence);
    }

    public void setTitle(int n) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_preference_Preference$setTitle(int ), this, n);
    }

    public int getTitleRes() {
        return (int)InvokeDynamicSupport.bootstrap("getTitleRes", $$robo$$android_preference_Preference$getTitleRes(), this);
    }

    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_preference_Preference$getTitle(), this);
    }

    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_preference_Preference$setIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_preference_Preference$setIcon(int ), this, n);
    }

    public Drawable getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_preference_Preference$getIcon(), this);
    }

    public CharSequence getSummary() {
        return InvokeDynamicSupport.bootstrap("getSummary", $$robo$$android_preference_Preference$getSummary(), this);
    }

    public void setSummary(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setSummary", $$robo$$android_preference_Preference$setSummary(java.lang.CharSequence ), this, charSequence);
    }

    public void setSummary(int n) {
        InvokeDynamicSupport.bootstrap("setSummary", $$robo$$android_preference_Preference$setSummary(int ), this, n);
    }

    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_preference_Preference$setEnabled(boolean ), this, bl);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_preference_Preference$isEnabled(), this);
    }

    public void setSelectable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelectable", $$robo$$android_preference_Preference$setSelectable(boolean ), this, bl);
    }

    public boolean isSelectable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSelectable", $$robo$$android_preference_Preference$isSelectable(), this);
    }

    public void setShouldDisableView(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShouldDisableView", $$robo$$android_preference_Preference$setShouldDisableView(boolean ), this, bl);
    }

    public boolean getShouldDisableView() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShouldDisableView", $$robo$$android_preference_Preference$getShouldDisableView(), this);
    }

    public void setRecycleEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRecycleEnabled", $$robo$$android_preference_Preference$setRecycleEnabled(boolean ), this, bl);
    }

    public boolean isRecycleEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecycleEnabled", $$robo$$android_preference_Preference$isRecycleEnabled(), this);
    }

    public void setSingleLineTitle(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSingleLineTitle", $$robo$$android_preference_Preference$setSingleLineTitle(boolean ), this, bl);
    }

    public boolean isSingleLineTitle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSingleLineTitle", $$robo$$android_preference_Preference$isSingleLineTitle(), this);
    }

    public void setIconSpaceReserved(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIconSpaceReserved", $$robo$$android_preference_Preference$setIconSpaceReserved(boolean ), this, bl);
    }

    public boolean isIconSpaceReserved() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIconSpaceReserved", $$robo$$android_preference_Preference$isIconSpaceReserved(), this);
    }

    long getId() {
        return (long)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_preference_Preference$getId(), this);
    }

    protected void onClick() {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_preference_Preference$onClick(), this);
    }

    public void setKey(String string2) {
        InvokeDynamicSupport.bootstrap("setKey", $$robo$$android_preference_Preference$setKey(java.lang.String ), this, string2);
    }

    public String getKey() {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_preference_Preference$getKey(), this);
    }

    void requireKey() {
        InvokeDynamicSupport.bootstrap("requireKey", $$robo$$android_preference_Preference$requireKey(), this);
    }

    public boolean hasKey() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasKey", $$robo$$android_preference_Preference$hasKey(), this);
    }

    public boolean isPersistent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPersistent", $$robo$$android_preference_Preference$isPersistent(), this);
    }

    protected boolean shouldPersist() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldPersist", $$robo$$android_preference_Preference$shouldPersist(), this);
    }

    public void setPersistent(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPersistent", $$robo$$android_preference_Preference$setPersistent(boolean ), this, bl);
    }

    protected boolean callChangeListener(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("callChangeListener", $$robo$$android_preference_Preference$callChangeListener(java.lang.Object ), this, object);
    }

    public void setOnPreferenceChangeListener(OnPreferenceChangeListener onPreferenceChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnPreferenceChangeListener", $$robo$$android_preference_Preference$setOnPreferenceChangeListener(android.preference.Preference$OnPreferenceChangeListener ), this, onPreferenceChangeListener);
    }

    public OnPreferenceChangeListener getOnPreferenceChangeListener() {
        return InvokeDynamicSupport.bootstrap("getOnPreferenceChangeListener", $$robo$$android_preference_Preference$getOnPreferenceChangeListener(), this);
    }

    public void setOnPreferenceClickListener(OnPreferenceClickListener onPreferenceClickListener) {
        InvokeDynamicSupport.bootstrap("setOnPreferenceClickListener", $$robo$$android_preference_Preference$setOnPreferenceClickListener(android.preference.Preference$OnPreferenceClickListener ), this, onPreferenceClickListener);
    }

    public OnPreferenceClickListener getOnPreferenceClickListener() {
        return InvokeDynamicSupport.bootstrap("getOnPreferenceClickListener", $$robo$$android_preference_Preference$getOnPreferenceClickListener(), this);
    }

    public void performClick(PreferenceScreen preferenceScreen) {
        InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_preference_Preference$performClick(android.preference.PreferenceScreen ), this, preferenceScreen);
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKey", $$robo$$android_preference_Preference$onKey(android.view.View int android.view.KeyEvent ), this, view, n, keyEvent);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_preference_Preference$getContext(), this);
    }

    public SharedPreferences getSharedPreferences() {
        return InvokeDynamicSupport.bootstrap("getSharedPreferences", $$robo$$android_preference_Preference$getSharedPreferences(), this);
    }

    public SharedPreferences.Editor getEditor() {
        return InvokeDynamicSupport.bootstrap("getEditor", $$robo$$android_preference_Preference$getEditor(), this);
    }

    public boolean shouldCommit() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldCommit", $$robo$$android_preference_Preference$shouldCommit(), this);
    }

    @Override
    public int compareTo(Preference preference) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_preference_Preference$compareTo(android.preference.Preference ), this, preference);
    }

    void setOnPreferenceChangeInternalListener(OnPreferenceChangeInternalListener onPreferenceChangeInternalListener) {
        InvokeDynamicSupport.bootstrap("setOnPreferenceChangeInternalListener", $$robo$$android_preference_Preference$setOnPreferenceChangeInternalListener(android.preference.Preference$OnPreferenceChangeInternalListener ), this, onPreferenceChangeInternalListener);
    }

    protected void notifyChanged() {
        InvokeDynamicSupport.bootstrap("notifyChanged", $$robo$$android_preference_Preference$notifyChanged(), this);
    }

    protected void notifyHierarchyChanged() {
        InvokeDynamicSupport.bootstrap("notifyHierarchyChanged", $$robo$$android_preference_Preference$notifyHierarchyChanged(), this);
    }

    public PreferenceManager getPreferenceManager() {
        return InvokeDynamicSupport.bootstrap("getPreferenceManager", $$robo$$android_preference_Preference$getPreferenceManager(), this);
    }

    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        InvokeDynamicSupport.bootstrap("onAttachedToHierarchy", $$robo$$android_preference_Preference$onAttachedToHierarchy(android.preference.PreferenceManager ), this, preferenceManager);
    }

    protected void onAttachedToActivity() {
        InvokeDynamicSupport.bootstrap("onAttachedToActivity", $$robo$$android_preference_Preference$onAttachedToActivity(), this);
    }

    void assignParent(PreferenceGroup preferenceGroup) {
        InvokeDynamicSupport.bootstrap("assignParent", $$robo$$android_preference_Preference$assignParent(android.preference.PreferenceGroup ), this, preferenceGroup);
    }

    private void registerDependency() {
        InvokeDynamicSupport.bootstrap("registerDependency", $$robo$$android_preference_Preference$registerDependency(), this);
    }

    private void unregisterDependency() {
        InvokeDynamicSupport.bootstrap("unregisterDependency", $$robo$$android_preference_Preference$unregisterDependency(), this);
    }

    protected Preference findPreferenceInHierarchy(String string2) {
        return InvokeDynamicSupport.bootstrap("findPreferenceInHierarchy", $$robo$$android_preference_Preference$findPreferenceInHierarchy(java.lang.String ), this, string2);
    }

    private void registerDependent(Preference preference) {
        InvokeDynamicSupport.bootstrap("registerDependent", $$robo$$android_preference_Preference$registerDependent(android.preference.Preference ), this, preference);
    }

    private void unregisterDependent(Preference preference) {
        InvokeDynamicSupport.bootstrap("unregisterDependent", $$robo$$android_preference_Preference$unregisterDependent(android.preference.Preference ), this, preference);
    }

    public void notifyDependencyChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyDependencyChange", $$robo$$android_preference_Preference$notifyDependencyChange(boolean ), this, bl);
    }

    public void onDependencyChanged(Preference preference, boolean bl) {
        InvokeDynamicSupport.bootstrap("onDependencyChanged", $$robo$$android_preference_Preference$onDependencyChanged(android.preference.Preference boolean ), this, preference, bl);
    }

    public void onParentChanged(Preference preference, boolean bl) {
        InvokeDynamicSupport.bootstrap("onParentChanged", $$robo$$android_preference_Preference$onParentChanged(android.preference.Preference boolean ), this, preference, bl);
    }

    public boolean shouldDisableDependents() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDisableDependents", $$robo$$android_preference_Preference$shouldDisableDependents(), this);
    }

    public void setDependency(String string2) {
        InvokeDynamicSupport.bootstrap("setDependency", $$robo$$android_preference_Preference$setDependency(java.lang.String ), this, string2);
    }

    public String getDependency() {
        return InvokeDynamicSupport.bootstrap("getDependency", $$robo$$android_preference_Preference$getDependency(), this);
    }

    public PreferenceGroup getParent() {
        return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_preference_Preference$getParent(), this);
    }

    protected void onPrepareForRemoval() {
        InvokeDynamicSupport.bootstrap("onPrepareForRemoval", $$robo$$android_preference_Preference$onPrepareForRemoval(), this);
    }

    public void setDefaultValue(Object object) {
        InvokeDynamicSupport.bootstrap("setDefaultValue", $$robo$$android_preference_Preference$setDefaultValue(java.lang.Object ), this, object);
    }

    private void dispatchSetInitialValue() {
        InvokeDynamicSupport.bootstrap("dispatchSetInitialValue", $$robo$$android_preference_Preference$dispatchSetInitialValue(), this);
    }

    protected void onSetInitialValue(boolean bl, Object object) {
        InvokeDynamicSupport.bootstrap("onSetInitialValue", $$robo$$android_preference_Preference$onSetInitialValue(boolean java.lang.Object ), this, bl, object);
    }

    private void tryCommit(SharedPreferences.Editor editor) {
        InvokeDynamicSupport.bootstrap("tryCommit", $$robo$$android_preference_Preference$tryCommit(android.content.SharedPreferences$Editor ), this, editor);
    }

    protected boolean persistString(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("persistString", $$robo$$android_preference_Preference$persistString(java.lang.String ), this, string2);
    }

    protected String getPersistedString(String string2) {
        return InvokeDynamicSupport.bootstrap("getPersistedString", $$robo$$android_preference_Preference$getPersistedString(java.lang.String ), this, string2);
    }

    public boolean persistStringSet(Set<String> set) {
        return (boolean)InvokeDynamicSupport.bootstrap("persistStringSet", $$robo$$android_preference_Preference$persistStringSet(java.util.Set<java.lang.String> ), this, set);
    }

    public Set<String> getPersistedStringSet(Set<String> set) {
        return InvokeDynamicSupport.bootstrap("getPersistedStringSet", $$robo$$android_preference_Preference$getPersistedStringSet(java.util.Set<java.lang.String> ), this, set);
    }

    protected boolean persistInt(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("persistInt", $$robo$$android_preference_Preference$persistInt(int ), this, n);
    }

    protected int getPersistedInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPersistedInt", $$robo$$android_preference_Preference$getPersistedInt(int ), this, n);
    }

    protected boolean persistFloat(float f) {
        return (boolean)InvokeDynamicSupport.bootstrap("persistFloat", $$robo$$android_preference_Preference$persistFloat(float ), this, f);
    }

    protected float getPersistedFloat(float f) {
        return (float)InvokeDynamicSupport.bootstrap("getPersistedFloat", $$robo$$android_preference_Preference$getPersistedFloat(float ), this, f);
    }

    protected boolean persistLong(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("persistLong", $$robo$$android_preference_Preference$persistLong(long ), this, l);
    }

    protected long getPersistedLong(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getPersistedLong", $$robo$$android_preference_Preference$getPersistedLong(long ), this, l);
    }

    protected boolean persistBoolean(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("persistBoolean", $$robo$$android_preference_Preference$persistBoolean(boolean ), this, bl);
    }

    protected boolean getPersistedBoolean(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPersistedBoolean", $$robo$$android_preference_Preference$getPersistedBoolean(boolean ), this, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_preference_Preference$toString(), this);
    }

    StringBuilder getFilterableStringBuilder() {
        return InvokeDynamicSupport.bootstrap("getFilterableStringBuilder", $$robo$$android_preference_Preference$getFilterableStringBuilder(), this);
    }

    public void saveHierarchyState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("saveHierarchyState", $$robo$$android_preference_Preference$saveHierarchyState(android.os.Bundle ), this, bundle);
    }

    void dispatchSaveInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$android_preference_Preference$dispatchSaveInstanceState(android.os.Bundle ), this, bundle);
    }

    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_preference_Preference$onSaveInstanceState(), this);
    }

    public void restoreHierarchyState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("restoreHierarchyState", $$robo$$android_preference_Preference$restoreHierarchyState(android.os.Bundle ), this, bundle);
    }

    void dispatchRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_preference_Preference$dispatchRestoreInstanceState(android.os.Bundle ), this, bundle);
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_preference_Preference$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    public /* synthetic */ Preference() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Preference)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class BaseSavedState
    extends AbsSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Parcelable.Creator<BaseSavedState> CREATOR;

        private void $$robo$$android_preference_Preference_BaseSavedState$__constructor__(Parcel source) {
        }

        private void $$robo$$android_preference_Preference_BaseSavedState$__constructor__(Parcelable superState) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<BaseSavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_preference_Preference_BaseSavedState_1$__constructor__() {
                }

                private final BaseSavedState $$robo$$android_preference_Preference_BaseSavedState_1$createFromParcel(Parcel in) {
                    return new BaseSavedState(in);
                }

                private final BaseSavedState[] $$robo$$android_preference_Preference_BaseSavedState_1$newArray(int size) {
                    return new BaseSavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_preference_Preference_BaseSavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference_BaseSavedState_1$__constructor__(), this);
                }

                @Override
                public BaseSavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_preference_Preference_BaseSavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public BaseSavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_preference_Preference_BaseSavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_preference_Preference_BaseSavedState$__constructor__(parcel);
        }

        public BaseSavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference_BaseSavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_preference_Preference_BaseSavedState$__constructor__(parcelable);
        }

        public BaseSavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_Preference_BaseSavedState$__constructor__(android.os.Parcelable ), this, parcelable);
        }

        static {
            RobolectricInternals.classInitializing(BaseSavedState.class);
        }

        public /* synthetic */ BaseSavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseSavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface OnPreferenceChangeInternalListener {
        public void onPreferenceChange(Preference var1);

        public void onPreferenceHierarchyChange(Preference var1);
    }

    public static interface OnPreferenceClickListener {
        public boolean onPreferenceClick(Preference var1);
    }

    public static interface OnPreferenceChangeListener {
        public boolean onPreferenceChange(Preference var1, Object var2);
    }
}

