/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.CharArrayWriter;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class StorageVolume
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mId;
    private File mPath;
    private File mInternalPath;
    private String mDescription;
    private boolean mPrimary;
    private boolean mRemovable;
    private boolean mEmulated;
    private boolean mAllowMassStorage;
    private long mMaxFileSize;
    private UserHandle mOwner;
    private String mFsUuid;
    private String mState;
    public static String EXTRA_STORAGE_VOLUME = "android.os.storage.extra.STORAGE_VOLUME";
    public static String EXTRA_DIRECTORY_NAME = "android.os.storage.extra.DIRECTORY_NAME";
    private static String ACTION_OPEN_EXTERNAL_DIRECTORY = "android.os.storage.action.OPEN_EXTERNAL_DIRECTORY";
    public static int STORAGE_ID_INVALID = 0;
    public static int STORAGE_ID_PRIMARY = 65537;
    public static Parcelable.Creator<StorageVolume> CREATOR;

    private void $$robo$$android_os_storage_StorageVolume$__constructor__(String id2, File path, File internalPath, String description, boolean primary, boolean removable, boolean emulated, boolean allowMassStorage, long maxFileSize, UserHandle owner, String fsUuid, String state) {
        this.mId = Preconditions.checkNotNull(id2);
        this.mPath = Preconditions.checkNotNull(path);
        this.mInternalPath = Preconditions.checkNotNull(internalPath);
        this.mDescription = Preconditions.checkNotNull(description);
        this.mPrimary = primary;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mAllowMassStorage = allowMassStorage;
        this.mMaxFileSize = maxFileSize;
        this.mOwner = Preconditions.checkNotNull(owner);
        this.mFsUuid = fsUuid;
        this.mState = Preconditions.checkNotNull(state);
    }

    private void $$robo$$android_os_storage_StorageVolume$__constructor__(Parcel in) {
        this.mId = in.readString();
        this.mPath = new File(in.readString());
        this.mInternalPath = new File(in.readString());
        this.mDescription = in.readString();
        this.mPrimary = in.readInt() != 0;
        this.mRemovable = in.readInt() != 0;
        this.mEmulated = in.readInt() != 0;
        this.mAllowMassStorage = in.readInt() != 0;
        this.mMaxFileSize = in.readLong();
        this.mOwner = (UserHandle)in.readParcelable(null);
        this.mFsUuid = in.readString();
        this.mState = in.readString();
    }

    private final String $$robo$$android_os_storage_StorageVolume$getId() {
        return this.mId;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getPath() {
        return this.mPath.toString();
    }

    private final String $$robo$$android_os_storage_StorageVolume$getInternalPath() {
        return this.mInternalPath.toString();
    }

    private final File $$robo$$android_os_storage_StorageVolume$getPathFile() {
        return this.mPath;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getDescription(Context context) {
        return this.mDescription;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isPrimary() {
        return this.mPrimary;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isRemovable() {
        return this.mRemovable;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isEmulated() {
        return this.mEmulated;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$allowMassStorage() {
        return this.mAllowMassStorage;
    }

    private final long $$robo$$android_os_storage_StorageVolume$getMaxFileSize() {
        return this.mMaxFileSize;
    }

    private final UserHandle $$robo$$android_os_storage_StorageVolume$getOwner() {
        return this.mOwner;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getUuid() {
        return this.mFsUuid;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getFatVolumeId() {
        if (this.mFsUuid == null || this.mFsUuid.length() != 9) {
            return -1;
        }
        try {
            return (int)Long.parseLong(this.mFsUuid.replace("-", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private final String $$robo$$android_os_storage_StorageVolume$getUserLabel() {
        return this.mDescription;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getState() {
        return this.mState;
    }

    private final Intent $$robo$$android_os_storage_StorageVolume$createAccessIntent(String directoryName) {
        if (this.isPrimary() && directoryName == null || directoryName != null && !Environment.isStandardDirectory(directoryName)) {
            return null;
        }
        Intent intent = new Intent("android.os.storage.action.OPEN_EXTERNAL_DIRECTORY");
        intent.putExtra("android.os.storage.extra.STORAGE_VOLUME", this);
        intent.putExtra("android.os.storage.extra.DIRECTORY_NAME", directoryName);
        return intent;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$equals(Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return this.mPath.equals(volume.mPath);
        }
        return false;
    }

    private final int $$robo$$android_os_storage_StorageVolume$hashCode() {
        return this.mPath.hashCode();
    }

    private final String $$robo$$android_os_storage_StorageVolume$toString() {
        StringBuilder buffer = new StringBuilder("StorageVolume: ").append(this.mDescription);
        if (this.mFsUuid != null) {
            buffer.append(" (").append(this.mFsUuid).append(")");
        }
        return buffer.toString();
    }

    private final String $$robo$$android_os_storage_StorageVolume$dump() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(writer, "    ", 80));
        return writer.toString();
    }

    private final void $$robo$$android_os_storage_StorageVolume$dump(IndentingPrintWriter pw) {
        pw.println("StorageVolume:");
        pw.increaseIndent();
        pw.printPair("mId", this.mId);
        pw.printPair("mPath", this.mPath);
        pw.printPair("mInternalPath", this.mInternalPath);
        pw.printPair("mDescription", this.mDescription);
        pw.printPair("mPrimary", this.mPrimary);
        pw.printPair("mRemovable", this.mRemovable);
        pw.printPair("mEmulated", this.mEmulated);
        pw.printPair("mAllowMassStorage", this.mAllowMassStorage);
        pw.printPair("mMaxFileSize", this.mMaxFileSize);
        pw.printPair("mOwner", this.mOwner);
        pw.printPair("mFsUuid", this.mFsUuid);
        pw.printPair("mState", this.mState);
        pw.decreaseIndent();
    }

    private final int $$robo$$android_os_storage_StorageVolume$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_storage_StorageVolume$writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mId);
        parcel.writeString(this.mPath.toString());
        parcel.writeString(this.mInternalPath.toString());
        parcel.writeString(this.mDescription);
        parcel.writeInt(this.mPrimary ? 1 : 0);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeInt(this.mAllowMassStorage ? 1 : 0);
        parcel.writeLong(this.mMaxFileSize);
        parcel.writeParcelable(this.mOwner, flags);
        parcel.writeString(this.mFsUuid);
        parcel.writeString(this.mState);
    }

    private /* synthetic */ void $$robo$$android_os_storage_StorageVolume$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<StorageVolume>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_storage_StorageVolume_1$__constructor__() {
            }

            private final StorageVolume $$robo$$android_os_storage_StorageVolume_1$createFromParcel(Parcel in) {
                return new StorageVolume(in, null);
            }

            private final StorageVolume[] $$robo$$android_os_storage_StorageVolume_1$newArray(int size) {
                return new StorageVolume[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_storage_StorageVolume_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume_1$__constructor__(), this);
            }

            @Override
            public StorageVolume createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_storage_StorageVolume_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public StorageVolume[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_storage_StorageVolume_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, File file, File file2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, UserHandle userHandle, String string4, String string5) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(string2, file, file2, string3, bl, bl2, bl3, bl4, l, userHandle, string4, string5);
    }

    public StorageVolume(String string2, File file, File file2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, UserHandle userHandle, String string4, String string5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(java.lang.String java.io.File java.io.File java.lang.String boolean boolean boolean boolean long android.os.UserHandle java.lang.String java.lang.String ), this, string2, file, file2, string3, bl, bl2, bl3, bl4, l, userHandle, string4, string5);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(parcel);
    }

    public StorageVolume(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(android.os.Parcel ), this, parcel);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_os_storage_StorageVolume$getId(), this);
    }

    public String getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_os_storage_StorageVolume$getPath(), this);
    }

    public String getInternalPath() {
        return InvokeDynamicSupport.bootstrap("getInternalPath", $$robo$$android_os_storage_StorageVolume$getInternalPath(), this);
    }

    public File getPathFile() {
        return InvokeDynamicSupport.bootstrap("getPathFile", $$robo$$android_os_storage_StorageVolume$getPathFile(), this);
    }

    public String getDescription(Context context) {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_os_storage_StorageVolume$getDescription(android.content.Context ), this, context);
    }

    public boolean isPrimary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimary", $$robo$$android_os_storage_StorageVolume$isPrimary(), this);
    }

    public boolean isRemovable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRemovable", $$robo$$android_os_storage_StorageVolume$isRemovable(), this);
    }

    public boolean isEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmulated", $$robo$$android_os_storage_StorageVolume$isEmulated(), this);
    }

    public boolean allowMassStorage() {
        return (boolean)InvokeDynamicSupport.bootstrap("allowMassStorage", $$robo$$android_os_storage_StorageVolume$allowMassStorage(), this);
    }

    public long getMaxFileSize() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxFileSize", $$robo$$android_os_storage_StorageVolume$getMaxFileSize(), this);
    }

    public UserHandle getOwner() {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_os_storage_StorageVolume$getOwner(), this);
    }

    public String getUuid() {
        return InvokeDynamicSupport.bootstrap("getUuid", $$robo$$android_os_storage_StorageVolume$getUuid(), this);
    }

    public int getFatVolumeId() {
        return (int)InvokeDynamicSupport.bootstrap("getFatVolumeId", $$robo$$android_os_storage_StorageVolume$getFatVolumeId(), this);
    }

    public String getUserLabel() {
        return InvokeDynamicSupport.bootstrap("getUserLabel", $$robo$$android_os_storage_StorageVolume$getUserLabel(), this);
    }

    public String getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$android_os_storage_StorageVolume$getState(), this);
    }

    public Intent createAccessIntent(String string2) {
        return InvokeDynamicSupport.bootstrap("createAccessIntent", $$robo$$android_os_storage_StorageVolume$createAccessIntent(java.lang.String ), this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_storage_StorageVolume$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_storage_StorageVolume$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_storage_StorageVolume$toString(), this);
    }

    public String dump() {
        return InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_StorageVolume$dump(), this);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_StorageVolume$dump(com.android.internal.util.IndentingPrintWriter ), this, indentingPrintWriter);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_storage_StorageVolume$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_storage_StorageVolume$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ StorageVolume(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(android.os.Parcel android.os.storage.StorageVolume$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(StorageVolume.class);
    }

    public /* synthetic */ StorageVolume() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageVolume)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ScopedAccessProviderContract
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static String AUTHORITY = "com.android.documentsui.scopedAccess";
        public static String TABLE_PACKAGES = "packages";
        public static String TABLE_PERMISSIONS = "permissions";
        public static String COL_PACKAGE = "package_name";
        public static String COL_VOLUME_UUID = "volume_uuid";
        public static String COL_DIRECTORY = "directory";
        public static String COL_GRANTED = "granted";
        public static String[] TABLE_PACKAGES_COLUMNS;
        public static String[] TABLE_PERMISSIONS_COLUMNS;
        public static int TABLE_PACKAGES_COL_PACKAGE = 0;
        public static int TABLE_PERMISSIONS_COL_PACKAGE = 0;
        public static int TABLE_PERMISSIONS_COL_VOLUME_UUID = 1;
        public static int TABLE_PERMISSIONS_COL_DIRECTORY = 2;
        public static int TABLE_PERMISSIONS_COL_GRANTED = 3;

        private void $$robo$$android_os_storage_StorageVolume_ScopedAccessProviderContract$__constructor__() {
            throw new UnsupportedOperationException("contains constants only");
        }

        static void __staticInitializer__() {
            TABLE_PACKAGES_COLUMNS = new String[]{"package_name"};
            TABLE_PERMISSIONS_COLUMNS = new String[]{"package_name", "volume_uuid", "directory", "granted"};
        }

        private void __constructor__() {
            this.$$robo$$android_os_storage_StorageVolume_ScopedAccessProviderContract$__constructor__();
        }

        public ScopedAccessProviderContract() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume_ScopedAccessProviderContract$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(ScopedAccessProviderContract.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScopedAccessProviderContract)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

