/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WorkSource
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "WorkSource";
    static boolean DEBUG = false;
    int mNum;
    int[] mUids;
    String[] mNames;
    private ArrayList<WorkChain> mChains;
    static WorkSource sTmpWorkSource;
    static WorkSource sNewbWork;
    static WorkSource sGoneWork;
    public static Parcelable.Creator<WorkSource> CREATOR;

    private void $$robo$$android_os_WorkSource$__constructor__() {
        this.mNum = 0;
        this.mChains = null;
    }

    private void $$robo$$android_os_WorkSource$__constructor__(WorkSource orig) {
        if (orig == null) {
            this.mNum = 0;
            this.mChains = null;
            return;
        }
        this.mNum = orig.mNum;
        if (orig.mUids != null) {
            this.mUids = (int[])orig.mUids.clone();
            this.mNames = orig.mNames != null ? (String[])orig.mNames.clone() : null;
        } else {
            this.mUids = null;
            this.mNames = null;
        }
        if (orig.mChains != null) {
            this.mChains = new ArrayList(orig.mChains.size());
            for (WorkChain chain : orig.mChains) {
                this.mChains.add(new WorkChain(chain));
            }
        } else {
            this.mChains = null;
        }
    }

    private void $$robo$$android_os_WorkSource$__constructor__(int uid) {
        this.mNum = 1;
        this.mUids = new int[]{uid, 0};
        this.mNames = null;
        this.mChains = null;
    }

    private void $$robo$$android_os_WorkSource$__constructor__(int uid, String name) {
        if (name == null) {
            throw new NullPointerException("Name can't be null");
        }
        this.mNum = 1;
        this.mUids = new int[]{uid, 0};
        this.mNames = new String[]{name, null};
        this.mChains = null;
    }

    private void $$robo$$android_os_WorkSource$__constructor__(Parcel in) {
        this.mNum = in.readInt();
        this.mUids = in.createIntArray();
        this.mNames = in.createStringArray();
        int numChains = in.readInt();
        if (numChains > 0) {
            this.mChains = new ArrayList(numChains);
            in.readParcelableList(this.mChains, WorkChain.class.getClassLoader());
        } else {
            this.mChains = null;
        }
    }

    private static final boolean $$robo$$android_os_WorkSource$isChainedBatteryAttributionEnabled(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "chained_battery_attribution_enabled", 0) == 1;
    }

    private final int $$robo$$android_os_WorkSource$size() {
        return this.mNum;
    }

    private final int $$robo$$android_os_WorkSource$get(int index) {
        return this.mUids[index];
    }

    private final String $$robo$$android_os_WorkSource$getName(int index) {
        return this.mNames != null ? this.mNames[index] : null;
    }

    private final void $$robo$$android_os_WorkSource$clearNames() {
        if (this.mNames != null) {
            this.mNames = null;
            int destIndex = 1;
            int newNum = this.mNum;
            for (int sourceIndex = 1; sourceIndex < this.mNum; ++sourceIndex) {
                if (this.mUids[sourceIndex] == this.mUids[sourceIndex - 1]) {
                    --newNum;
                    continue;
                }
                this.mUids[destIndex] = this.mUids[sourceIndex];
                ++destIndex;
            }
            this.mNum = newNum;
        }
    }

    private final void $$robo$$android_os_WorkSource$clear() {
        this.mNum = 0;
        if (this.mChains != null) {
            this.mChains.clear();
        }
    }

    private final boolean $$robo$$android_os_WorkSource$equals(Object o) {
        if (o instanceof WorkSource) {
            WorkSource other = (WorkSource)o;
            if (this.diff(other)) {
                return false;
            }
            if (this.mChains != null && !this.mChains.isEmpty()) {
                return this.mChains.equals(other.mChains);
            }
            return other.mChains == null || other.mChains.isEmpty();
        }
        return false;
    }

    private final int $$robo$$android_os_WorkSource$hashCode() {
        int i;
        int result = 0;
        for (i = 0; i < this.mNum; ++i) {
            result = (result << 4 | result >>> 28) ^ this.mUids[i];
        }
        if (this.mNames != null) {
            for (i = 0; i < this.mNum; ++i) {
                result = (result << 4 | result >>> 28) ^ this.mNames[i].hashCode();
            }
        }
        if (this.mChains != null) {
            result = (result << 4 | result >>> 28) ^ this.mChains.hashCode();
        }
        return result;
    }

    private final boolean $$robo$$android_os_WorkSource$diff(WorkSource other) {
        int N = this.mNum;
        if (N != other.mNum) {
            return true;
        }
        int[] uids1 = this.mUids;
        int[] uids2 = other.mUids;
        String[] names1 = this.mNames;
        String[] names2 = other.mNames;
        for (int i = 0; i < N; ++i) {
            if (uids1[i] != uids2[i]) {
                return true;
            }
            if (names1 == null || names2 == null || names1[i].equals(names2[i])) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_os_WorkSource$set(WorkSource other) {
        if (other == null) {
            this.mNum = 0;
            if (this.mChains != null) {
                this.mChains.clear();
            }
            return;
        }
        this.mNum = other.mNum;
        if (other.mUids != null) {
            if (this.mUids != null && this.mUids.length >= this.mNum) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)other.mUids, (int)0, (Object)this.mUids, (int)0, (int)this.mNum);
            } else {
                this.mUids = (int[])other.mUids.clone();
            }
            if (other.mNames != null) {
                if (this.mNames != null && this.mNames.length >= this.mNum) {
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)other.mNames, (int)0, (Object)this.mNames, (int)0, (int)this.mNum);
                } else {
                    this.mNames = (String[])other.mNames.clone();
                }
            } else {
                this.mNames = null;
            }
        } else {
            this.mUids = null;
            this.mNames = null;
        }
        if (other.mChains != null) {
            if (this.mChains != null) {
                this.mChains.clear();
            } else {
                this.mChains = new ArrayList(other.mChains.size());
            }
            for (WorkChain chain : other.mChains) {
                this.mChains.add(new WorkChain(chain));
            }
        }
    }

    private final void $$robo$$android_os_WorkSource$set(int uid) {
        this.mNum = 1;
        if (this.mUids == null) {
            this.mUids = new int[2];
        }
        this.mUids[0] = uid;
        this.mNames = null;
        if (this.mChains != null) {
            this.mChains.clear();
        }
    }

    private final void $$robo$$android_os_WorkSource$set(int uid, String name) {
        if (name == null) {
            throw new NullPointerException("Name can't be null");
        }
        this.mNum = 1;
        if (this.mUids == null) {
            this.mUids = new int[2];
            this.mNames = new String[2];
        }
        this.mUids[0] = uid;
        this.mNames[0] = name;
        if (this.mChains != null) {
            this.mChains.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final WorkSource[] $$robo$$android_os_WorkSource$setReturningDiffs(WorkSource other) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            sNewbWork = null;
            sGoneWork = null;
            this.updateLocked(other, true, true);
            if (sNewbWork != null || sGoneWork != null) {
                WorkSource[] diffs = new WorkSource[]{sNewbWork, sGoneWork};
                return diffs;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_WorkSource$add(WorkSource other) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            boolean uidAdded = this.updateLocked(other, false, false);
            boolean chainAdded = false;
            if (other.mChains != null) {
                if (this.mChains == null) {
                    this.mChains = new ArrayList(other.mChains.size());
                }
                for (WorkChain wc : other.mChains) {
                    if (this.mChains.contains(wc)) continue;
                    this.mChains.add(new WorkChain(wc));
                }
            }
            return uidAdded || chainAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final WorkSource $$robo$$android_os_WorkSource$addReturningNewbs(WorkSource other) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            sNewbWork = null;
            this.updateLocked(other, false, true);
            return sNewbWork;
        }
    }

    private final boolean $$robo$$android_os_WorkSource$add(int uid) {
        if (this.mNum <= 0) {
            this.mNames = null;
            this.insert(0, uid);
            return true;
        }
        if (this.mNames != null) {
            throw new IllegalArgumentException("Adding without name to named " + this);
        }
        int i = Arrays.binarySearch(this.mUids, 0, this.mNum, uid);
        if (i >= 0) {
            return false;
        }
        this.insert(-i - 1, uid);
        return true;
    }

    private final boolean $$robo$$android_os_WorkSource$add(int uid, String name) {
        int i;
        if (this.mNum <= 0) {
            this.insert(0, uid, name);
            return true;
        }
        if (this.mNames == null) {
            throw new IllegalArgumentException("Adding name to unnamed " + this);
        }
        for (i = 0; i < this.mNum && this.mUids[i] <= uid; ++i) {
            if (this.mUids[i] != uid) continue;
            int diff = this.mNames[i].compareTo(name);
            if (diff > 0) break;
            if (diff != 0) continue;
            return false;
        }
        this.insert(i, uid, name);
        return true;
    }

    private final boolean $$robo$$android_os_WorkSource$remove(WorkSource other) {
        boolean uidRemoved;
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        if (this.mNames == null && other.mNames == null) {
            uidRemoved = this.removeUids(other);
        } else {
            if (this.mNames == null) {
                throw new IllegalArgumentException("Other " + other + " has names, but target " + this + " does not");
            }
            if (other.mNames == null) {
                throw new IllegalArgumentException("Target " + this + " has names, but other " + other + " does not");
            }
            uidRemoved = this.removeUidsAndNames(other);
        }
        boolean chainRemoved = false;
        if (other.mChains != null && this.mChains != null) {
            chainRemoved = this.mChains.removeAll(other.mChains);
        }
        return uidRemoved || chainRemoved;
    }

    @SystemApi
    private final WorkChain $$robo$$android_os_WorkSource$createWorkChain() {
        if (this.mChains == null) {
            this.mChains = new ArrayList(4);
        }
        WorkChain wc = new WorkChain();
        this.mChains.add(wc);
        return wc;
    }

    private final boolean $$robo$$android_os_WorkSource$isEmpty() {
        return this.mNum == 0 && (this.mChains == null || this.mChains.isEmpty());
    }

    private final ArrayList<WorkChain> $$robo$$android_os_WorkSource$getWorkChains() {
        return this.mChains;
    }

    private final void $$robo$$android_os_WorkSource$transferWorkChains(WorkSource other) {
        if (this.mChains != null) {
            this.mChains.clear();
        }
        if (other.mChains == null || other.mChains.isEmpty()) {
            return;
        }
        if (this.mChains == null) {
            this.mChains = new ArrayList(4);
        }
        this.mChains.addAll(other.mChains);
        other.mChains.clear();
    }

    private final boolean $$robo$$android_os_WorkSource$removeUids(WorkSource other) {
        int N1 = this.mNum;
        int[] uids1 = this.mUids;
        int N2 = other.mNum;
        int[] uids2 = other.mUids;
        boolean changed = false;
        int i1 = 0;
        int i2 = 0;
        while (i1 < N1 && i2 < N2) {
            if (uids2[i2] == uids1[i1]) {
                changed = true;
                if (i1 < --N1) {
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)uids1, (int)(i1 + 1), (Object)uids1, (int)i1, (int)(N1 - i1));
                }
                ++i2;
                continue;
            }
            if (uids2[i2] > uids1[i1]) {
                ++i1;
                continue;
            }
            ++i2;
        }
        this.mNum = N1;
        return changed;
    }

    private final boolean $$robo$$android_os_WorkSource$removeUidsAndNames(WorkSource other) {
        int N1 = this.mNum;
        int[] uids1 = this.mUids;
        String[] names1 = this.mNames;
        int N2 = other.mNum;
        int[] uids2 = other.mUids;
        String[] names2 = other.mNames;
        boolean changed = false;
        int i1 = 0;
        int i2 = 0;
        while (i1 < N1 && i2 < N2) {
            if (uids2[i2] == uids1[i1] && names2[i2].equals(names1[i1])) {
                changed = true;
                if (i1 < --N1) {
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)uids1, (int)(i1 + 1), (Object)uids1, (int)i1, (int)(N1 - i1));
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)names1, (int)(i1 + 1), (Object)names1, (int)i1, (int)(N1 - i1));
                }
                ++i2;
                continue;
            }
            if (uids2[i2] > uids1[i1] || uids2[i2] == uids1[i1] && names2[i2].compareTo(names1[i1]) > 0) {
                ++i1;
                continue;
            }
            ++i2;
        }
        this.mNum = N1;
        return changed;
    }

    private final boolean $$robo$$android_os_WorkSource$updateLocked(WorkSource other, boolean set, boolean returnNewbs) {
        if (this.mNames == null && other.mNames == null) {
            return this.updateUidsLocked(other, set, returnNewbs);
        }
        if (this.mNum > 0 && this.mNames == null) {
            throw new IllegalArgumentException("Other " + other + " has names, but target " + this + " does not");
        }
        if (other.mNum > 0 && other.mNames == null) {
            throw new IllegalArgumentException("Target " + this + " has names, but other " + other + " does not");
        }
        return this.updateUidsAndNamesLocked(other, set, returnNewbs);
    }

    private static final WorkSource $$robo$$android_os_WorkSource$addWork(WorkSource cur, int newUid) {
        if (cur == null) {
            return new WorkSource(newUid);
        }
        cur.insert(cur.mNum, newUid);
        return cur;
    }

    private final boolean $$robo$$android_os_WorkSource$updateUidsLocked(WorkSource other, boolean set, boolean returnNewbs) {
        int N1 = this.mNum;
        int[] uids1 = this.mUids;
        int N2 = other.mNum;
        int[] uids2 = other.mUids;
        boolean changed = false;
        int i1 = 0;
        int i2 = 0;
        while (i1 < N1 || i2 < N2) {
            if (i1 >= N1 || i2 < N2 && uids2[i2] < uids1[i1]) {
                changed = true;
                if (uids1 == null) {
                    uids1 = new int[4];
                    uids1[0] = uids2[i2];
                } else if (N1 >= uids1.length) {
                    int[] newuids = new int[uids1.length * 3 / 2];
                    if (i1 > 0) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)uids1, (int)0, (Object)newuids, (int)0, (int)i1);
                    }
                    if (i1 < N1) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)uids1, (int)i1, (Object)newuids, (int)(i1 + 1), (int)(N1 - i1));
                    }
                    uids1 = newuids;
                    uids1[i1] = uids2[i2];
                } else {
                    if (i1 < N1) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)uids1, (int)i1, (Object)uids1, (int)(i1 + 1), (int)(N1 - i1));
                    }
                    uids1[i1] = uids2[i2];
                }
                if (returnNewbs) {
                    sNewbWork = WorkSource.addWork(sNewbWork, uids2[i2]);
                }
                ++N1;
                ++i1;
                ++i2;
                continue;
            }
            if (!set) {
                if (i2 < N2 && uids2[i2] == uids1[i1]) {
                    ++i2;
                }
                ++i1;
                continue;
            }
            int start = i1;
            while (i1 < N1 && (i2 >= N2 || uids2[i2] > uids1[i1])) {
                sGoneWork = WorkSource.addWork(sGoneWork, uids1[i1]);
                ++i1;
            }
            if (start < i1) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)uids1, (int)i1, (Object)uids1, (int)start, (int)(N1 - i1));
                N1 -= i1 - start;
                i1 = start;
            }
            if (i1 >= N1 || i2 >= N2 || uids2[i2] != uids1[i1]) continue;
            ++i1;
            ++i2;
        }
        this.mNum = N1;
        this.mUids = uids1;
        return changed;
    }

    private final int $$robo$$android_os_WorkSource$compare(WorkSource other, int i1, int i2) {
        int diff = this.mUids[i1] - other.mUids[i2];
        if (diff != 0) {
            return diff;
        }
        return this.mNames[i1].compareTo(other.mNames[i2]);
    }

    private static final WorkSource $$robo$$android_os_WorkSource$addWork(WorkSource cur, int newUid, String newName) {
        if (cur == null) {
            return new WorkSource(newUid, newName);
        }
        cur.insert(cur.mNum, newUid, newName);
        return cur;
    }

    private final boolean $$robo$$android_os_WorkSource$updateUidsAndNamesLocked(WorkSource other, boolean set, boolean returnNewbs) {
        int N2 = other.mNum;
        int[] uids2 = other.mUids;
        String[] names2 = other.mNames;
        boolean changed = false;
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.mNum || i2 < N2) {
            int diff = -1;
            if (i1 >= this.mNum || i2 < N2 && (diff = this.compare(other, i1, i2)) > 0) {
                changed = true;
                this.insert(i1, uids2[i2], names2[i2]);
                if (returnNewbs) {
                    sNewbWork = WorkSource.addWork(sNewbWork, uids2[i2], names2[i2]);
                }
                ++i1;
                ++i2;
                continue;
            }
            if (!set) {
                if (i2 < N2 && diff == 0) {
                    ++i2;
                }
                ++i1;
                continue;
            }
            int start = i1;
            while (diff < 0) {
                sGoneWork = WorkSource.addWork(sGoneWork, this.mUids[i1], this.mNames[i1]);
                if (++i1 >= this.mNum) break;
                diff = i2 < N2 ? this.compare(other, i1, i2) : -1;
            }
            if (start < i1) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)i1, (Object)this.mUids, (int)start, (int)(this.mNum - i1));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mNames, (int)i1, (Object)this.mNames, (int)start, (int)(this.mNum - i1));
                this.mNum -= i1 - start;
                i1 = start;
            }
            if (i1 >= this.mNum || diff != 0) continue;
            ++i1;
            ++i2;
        }
        return changed;
    }

    private final void $$robo$$android_os_WorkSource$insert(int index, int uid) {
        if (this.mUids == null) {
            this.mUids = new int[4];
            this.mUids[0] = uid;
            this.mNum = 1;
        } else if (this.mNum >= this.mUids.length) {
            int[] newuids = new int[this.mNum * 3 / 2];
            if (index > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)0, (Object)newuids, (int)0, (int)index);
            }
            if (index < this.mNum) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)index, (Object)newuids, (int)(index + 1), (int)(this.mNum - index));
            }
            this.mUids = newuids;
            this.mUids[index] = uid;
            ++this.mNum;
        } else {
            if (index < this.mNum) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)index, (Object)this.mUids, (int)(index + 1), (int)(this.mNum - index));
            }
            this.mUids[index] = uid;
            ++this.mNum;
        }
    }

    private final void $$robo$$android_os_WorkSource$insert(int index, int uid, String name) {
        if (this.mUids == null) {
            this.mUids = new int[4];
            this.mUids[0] = uid;
            this.mNames = new String[4];
            this.mNames[0] = name;
            this.mNum = 1;
        } else if (this.mNum >= this.mUids.length) {
            int[] newuids = new int[this.mNum * 3 / 2];
            String[] newnames = new String[this.mNum * 3 / 2];
            if (index > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)0, (Object)newuids, (int)0, (int)index);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mNames, (int)0, (Object)newnames, (int)0, (int)index);
            }
            if (index < this.mNum) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)index, (Object)newuids, (int)(index + 1), (int)(this.mNum - index));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mNames, (int)index, (Object)newnames, (int)(index + 1), (int)(this.mNum - index));
            }
            this.mUids = newuids;
            this.mNames = newnames;
            this.mUids[index] = uid;
            this.mNames[index] = name;
            ++this.mNum;
        } else {
            if (index < this.mNum) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)index, (Object)this.mUids, (int)(index + 1), (int)(this.mNum - index));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mNames, (int)index, (Object)this.mNames, (int)(index + 1), (int)(this.mNum - index));
            }
            this.mUids[index] = uid;
            this.mNames[index] = name;
            ++this.mNum;
        }
    }

    private static final ArrayList<WorkChain>[] $$robo$$android_os_WorkSource$diffChains(WorkSource oldWs, WorkSource newWs) {
        WorkChain wc;
        int i;
        ArrayList<WorkChain> newChains = null;
        ArrayList<WorkChain> goneChains = null;
        if (oldWs.mChains != null) {
            for (i = 0; i < oldWs.mChains.size(); ++i) {
                wc = oldWs.mChains.get(i);
                if (newWs.mChains != null && newWs.mChains.contains(wc)) continue;
                if (goneChains == null) {
                    goneChains = new ArrayList<WorkChain>(oldWs.mChains.size());
                }
                goneChains.add(wc);
            }
        }
        if (newWs.mChains != null) {
            for (i = 0; i < newWs.mChains.size(); ++i) {
                wc = newWs.mChains.get(i);
                if (oldWs.mChains != null && oldWs.mChains.contains(wc)) continue;
                if (newChains == null) {
                    newChains = new ArrayList<WorkChain>(newWs.mChains.size());
                }
                newChains.add(wc);
            }
        }
        if (newChains != null || goneChains != null) {
            return new ArrayList[]{newChains, goneChains};
        }
        return null;
    }

    private final int $$robo$$android_os_WorkSource$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_WorkSource$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNum);
        dest.writeIntArray(this.mUids);
        dest.writeStringArray(this.mNames);
        if (this.mChains == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.mChains.size());
            dest.writeParcelableList(this.mChains, flags);
        }
    }

    private final String $$robo$$android_os_WorkSource$toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("WorkSource{");
        for (i = 0; i < this.mNum; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.mUids[i]);
            if (this.mNames == null) continue;
            result.append(" ");
            result.append(this.mNames[i]);
        }
        if (this.mChains != null) {
            result.append(" chains=");
            for (i = 0; i < this.mChains.size(); ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.mChains.get(i));
            }
        }
        result.append("}");
        return result.toString();
    }

    private final void $$robo$$android_os_WorkSource$writeToProto(ProtoOutputStream proto, long fieldId) {
        int i;
        long workSourceToken = proto.start(fieldId);
        for (i = 0; i < this.mNum; ++i) {
            long contentProto = proto.start(2246267895809L);
            proto.write(0x10500000001L, this.mUids[i]);
            if (this.mNames != null) {
                proto.write(1138166333442L, this.mNames[i]);
            }
            proto.end(contentProto);
        }
        if (this.mChains != null) {
            for (i = 0; i < this.mChains.size(); ++i) {
                WorkChain wc = this.mChains.get(i);
                long workChain = proto.start(0x20B00000002L);
                String[] tags = wc.getTags();
                int[] uids = wc.getUids();
                for (int j = 0; j < tags.length; ++j) {
                    long contentProto = proto.start(2246267895809L);
                    proto.write(0x10500000001L, uids[j]);
                    proto.write(1138166333442L, tags[j]);
                    proto.end(contentProto);
                }
                proto.end(workChain);
            }
        }
        proto.end(workSourceToken);
    }

    static void __staticInitializer__() {
        sTmpWorkSource = new WorkSource(0);
        CREATOR = new Parcelable.Creator<WorkSource>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_WorkSource_1$__constructor__() {
            }

            private final WorkSource $$robo$$android_os_WorkSource_1$createFromParcel(Parcel in) {
                return new WorkSource(in);
            }

            private final WorkSource[] $$robo$$android_os_WorkSource_1$newArray(int size) {
                return new WorkSource[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_WorkSource_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource_1$__constructor__(), this);
            }

            @Override
            public WorkSource createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_WorkSource_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WorkSource[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_WorkSource_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_os_WorkSource$__constructor__();
    }

    public WorkSource() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource$__constructor__(), this);
    }

    private void __constructor__(WorkSource workSource) {
        this.$$robo$$android_os_WorkSource$__constructor__(workSource);
    }

    public WorkSource(WorkSource workSource) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource$__constructor__(android.os.WorkSource ), this, workSource);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_os_WorkSource$__constructor__(n);
    }

    public WorkSource(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource$__constructor__(int ), this, n);
    }

    private void __constructor__(int n, String string2) {
        this.$$robo$$android_os_WorkSource$__constructor__(n, string2);
    }

    public WorkSource(int n, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource$__constructor__(int java.lang.String ), this, n, string2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_WorkSource$__constructor__(parcel);
    }

    public WorkSource(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource$__constructor__(android.os.Parcel ), this, parcel);
    }

    public static boolean isChainedBatteryAttributionEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChainedBatteryAttributionEnabled", $$robo$$android_os_WorkSource$isChainedBatteryAttributionEnabled(android.content.Context ), (Context)context);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_os_WorkSource$size(), this);
    }

    public int get(int n) {
        return (int)InvokeDynamicSupport.bootstrap("get", $$robo$$android_os_WorkSource$get(int ), this, n);
    }

    public String getName(int n) {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_os_WorkSource$getName(int ), this, n);
    }

    public void clearNames() {
        InvokeDynamicSupport.bootstrap("clearNames", $$robo$$android_os_WorkSource$clearNames(), this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_os_WorkSource$clear(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_WorkSource$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_WorkSource$hashCode(), this);
    }

    public boolean diff(WorkSource workSource) {
        return (boolean)InvokeDynamicSupport.bootstrap("diff", $$robo$$android_os_WorkSource$diff(android.os.WorkSource ), this, workSource);
    }

    public void set(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_os_WorkSource$set(android.os.WorkSource ), this, workSource);
    }

    public void set(int n) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_os_WorkSource$set(int ), this, n);
    }

    public void set(int n, String string2) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_os_WorkSource$set(int java.lang.String ), this, n, string2);
    }

    @Deprecated
    public WorkSource[] setReturningDiffs(WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("setReturningDiffs", $$robo$$android_os_WorkSource$setReturningDiffs(android.os.WorkSource ), this, workSource);
    }

    public boolean add(WorkSource workSource) {
        return (boolean)InvokeDynamicSupport.bootstrap("add", $$robo$$android_os_WorkSource$add(android.os.WorkSource ), this, workSource);
    }

    @Deprecated
    public WorkSource addReturningNewbs(WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("addReturningNewbs", $$robo$$android_os_WorkSource$addReturningNewbs(android.os.WorkSource ), this, workSource);
    }

    public boolean add(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("add", $$robo$$android_os_WorkSource$add(int ), this, n);
    }

    public boolean add(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("add", $$robo$$android_os_WorkSource$add(int java.lang.String ), this, n, string2);
    }

    public boolean remove(WorkSource workSource) {
        return (boolean)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_os_WorkSource$remove(android.os.WorkSource ), this, workSource);
    }

    @SystemApi
    public WorkChain createWorkChain() {
        return InvokeDynamicSupport.bootstrap("createWorkChain", $$robo$$android_os_WorkSource$createWorkChain(), this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_os_WorkSource$isEmpty(), this);
    }

    public ArrayList<WorkChain> getWorkChains() {
        return InvokeDynamicSupport.bootstrap("getWorkChains", $$robo$$android_os_WorkSource$getWorkChains(), this);
    }

    public void transferWorkChains(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("transferWorkChains", $$robo$$android_os_WorkSource$transferWorkChains(android.os.WorkSource ), this, workSource);
    }

    private boolean removeUids(WorkSource workSource) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUids", $$robo$$android_os_WorkSource$removeUids(android.os.WorkSource ), this, workSource);
    }

    private boolean removeUidsAndNames(WorkSource workSource) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUidsAndNames", $$robo$$android_os_WorkSource$removeUidsAndNames(android.os.WorkSource ), this, workSource);
    }

    private boolean updateLocked(WorkSource workSource, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateLocked", $$robo$$android_os_WorkSource$updateLocked(android.os.WorkSource boolean boolean ), this, workSource, bl, bl2);
    }

    private static WorkSource addWork(WorkSource workSource, int n) {
        return InvokeDynamicSupport.bootstrapStatic("addWork", $$robo$$android_os_WorkSource$addWork(android.os.WorkSource int ), (WorkSource)workSource, (int)n);
    }

    private boolean updateUidsLocked(WorkSource workSource, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateUidsLocked", $$robo$$android_os_WorkSource$updateUidsLocked(android.os.WorkSource boolean boolean ), this, workSource, bl, bl2);
    }

    private int compare(WorkSource workSource, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_os_WorkSource$compare(android.os.WorkSource int int ), this, workSource, n, n2);
    }

    private static WorkSource addWork(WorkSource workSource, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("addWork", $$robo$$android_os_WorkSource$addWork(android.os.WorkSource int java.lang.String ), (WorkSource)workSource, (int)n, (String)string2);
    }

    private boolean updateUidsAndNamesLocked(WorkSource workSource, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateUidsAndNamesLocked", $$robo$$android_os_WorkSource$updateUidsAndNamesLocked(android.os.WorkSource boolean boolean ), this, workSource, bl, bl2);
    }

    private void insert(int n, int n2) {
        InvokeDynamicSupport.bootstrap("insert", $$robo$$android_os_WorkSource$insert(int int ), this, n, n2);
    }

    private void insert(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("insert", $$robo$$android_os_WorkSource$insert(int int java.lang.String ), this, n, n2, string2);
    }

    public static ArrayList<WorkChain>[] diffChains(WorkSource workSource, WorkSource workSource2) {
        return InvokeDynamicSupport.bootstrapStatic("diffChains", $$robo$$android_os_WorkSource$diffChains(android.os.WorkSource android.os.WorkSource ), (WorkSource)workSource, (WorkSource)workSource2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_WorkSource$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_WorkSource$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_WorkSource$toString(), this);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_os_WorkSource$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
    }

    static {
        RobolectricInternals.classInitializing(WorkSource.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WorkSource)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @SystemApi
    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class WorkChain
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mSize;
        private int[] mUids;
        private String[] mTags;
        public static Parcelable.Creator<WorkChain> CREATOR;

        private void $$robo$$android_os_WorkSource_WorkChain$__constructor__() {
            this.mSize = 0;
            this.mUids = new int[4];
            this.mTags = new String[4];
        }

        @VisibleForTesting
        private void $$robo$$android_os_WorkSource_WorkChain$__constructor__(WorkChain other) {
            this.mSize = other.mSize;
            this.mUids = (int[])other.mUids.clone();
            this.mTags = (String[])other.mTags.clone();
        }

        private void $$robo$$android_os_WorkSource_WorkChain$__constructor__(Parcel in) {
            this.mSize = in.readInt();
            this.mUids = in.createIntArray();
            this.mTags = in.createStringArray();
        }

        private final WorkChain $$robo$$android_os_WorkSource_WorkChain$addNode(int uid, String tag) {
            if (this.mSize == this.mUids.length) {
                this.resizeArrays();
            }
            this.mUids[this.mSize] = uid;
            this.mTags[this.mSize] = tag;
            ++this.mSize;
            return this;
        }

        private final int $$robo$$android_os_WorkSource_WorkChain$getAttributionUid() {
            return this.mUids[0];
        }

        private final String $$robo$$android_os_WorkSource_WorkChain$getAttributionTag() {
            return this.mTags[0];
        }

        @VisibleForTesting
        private final int[] $$robo$$android_os_WorkSource_WorkChain$getUids() {
            int[] uids = new int[this.mSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)0, (Object)uids, (int)0, (int)this.mSize);
            return uids;
        }

        @VisibleForTesting
        private final String[] $$robo$$android_os_WorkSource_WorkChain$getTags() {
            String[] tags = new String[this.mSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mTags, (int)0, (Object)tags, (int)0, (int)this.mSize);
            return tags;
        }

        @VisibleForTesting
        private final int $$robo$$android_os_WorkSource_WorkChain$getSize() {
            return this.mSize;
        }

        private final void $$robo$$android_os_WorkSource_WorkChain$resizeArrays() {
            int newSize = this.mSize * 2;
            int[] uids = new int[newSize];
            String[] tags = new String[newSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mUids, (int)0, (Object)uids, (int)0, (int)this.mSize);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mTags, (int)0, (Object)tags, (int)0, (int)this.mSize);
            this.mUids = uids;
            this.mTags = tags;
        }

        private final String $$robo$$android_os_WorkSource_WorkChain$toString() {
            StringBuilder result = new StringBuilder("WorkChain{");
            for (int i = 0; i < this.mSize; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append("(");
                result.append(this.mUids[i]);
                if (this.mTags[i] != null) {
                    result.append(", ");
                    result.append(this.mTags[i]);
                }
                result.append(")");
            }
            result.append("}");
            return result.toString();
        }

        private final int $$robo$$android_os_WorkSource_WorkChain$hashCode() {
            return (this.mSize + 31 * Arrays.hashCode(this.mUids)) * 31 + Arrays.hashCode(this.mTags);
        }

        private final boolean $$robo$$android_os_WorkSource_WorkChain$equals(Object o) {
            if (o instanceof WorkChain) {
                WorkChain other = (WorkChain)o;
                return this.mSize == other.mSize && Arrays.equals(this.mUids, other.mUids) && Arrays.equals(this.mTags, other.mTags);
            }
            return false;
        }

        private final int $$robo$$android_os_WorkSource_WorkChain$describeContents() {
            return 0;
        }

        private final void $$robo$$android_os_WorkSource_WorkChain$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mSize);
            dest.writeIntArray(this.mUids);
            dest.writeStringArray(this.mTags);
        }

        private /* synthetic */ void $$robo$$android_os_WorkSource_WorkChain$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<WorkChain>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_WorkSource_WorkChain_1$__constructor__() {
                }

                private final WorkChain $$robo$$android_os_WorkSource_WorkChain_1$createFromParcel(Parcel in) {
                    return new WorkChain(in, null);
                }

                private final WorkChain[] $$robo$$android_os_WorkSource_WorkChain_1$newArray(int size) {
                    return new WorkChain[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_WorkSource_WorkChain_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource_WorkChain_1$__constructor__(), this);
                }

                @Override
                public WorkChain createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_WorkSource_WorkChain_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public WorkChain[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_WorkSource_WorkChain_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_os_WorkSource_WorkChain$__constructor__();
        }

        public WorkChain() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource_WorkChain$__constructor__(), this);
        }

        private void __constructor__(WorkChain workChain) {
            this.$$robo$$android_os_WorkSource_WorkChain$__constructor__(workChain);
        }

        public WorkChain(WorkChain workChain) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource_WorkChain$__constructor__(android.os.WorkSource$WorkChain ), this, workChain);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_WorkSource_WorkChain$__constructor__(parcel);
        }

        public WorkChain(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource_WorkChain$__constructor__(android.os.Parcel ), this, parcel);
        }

        public WorkChain addNode(int n, String string2) {
            return InvokeDynamicSupport.bootstrap("addNode", $$robo$$android_os_WorkSource_WorkChain$addNode(int java.lang.String ), this, n, string2);
        }

        public int getAttributionUid() {
            return (int)InvokeDynamicSupport.bootstrap("getAttributionUid", $$robo$$android_os_WorkSource_WorkChain$getAttributionUid(), this);
        }

        public String getAttributionTag() {
            return InvokeDynamicSupport.bootstrap("getAttributionTag", $$robo$$android_os_WorkSource_WorkChain$getAttributionTag(), this);
        }

        public int[] getUids() {
            return InvokeDynamicSupport.bootstrap("getUids", $$robo$$android_os_WorkSource_WorkChain$getUids(), this);
        }

        public String[] getTags() {
            return InvokeDynamicSupport.bootstrap("getTags", $$robo$$android_os_WorkSource_WorkChain$getTags(), this);
        }

        public int getSize() {
            return (int)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_os_WorkSource_WorkChain$getSize(), this);
        }

        private void resizeArrays() {
            InvokeDynamicSupport.bootstrap("resizeArrays", $$robo$$android_os_WorkSource_WorkChain$resizeArrays(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_WorkSource_WorkChain$toString(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_WorkSource_WorkChain$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_WorkSource_WorkChain$equals(java.lang.Object ), this, object);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_WorkSource_WorkChain$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_WorkSource_WorkChain$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_os_WorkSource_WorkChain$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ WorkChain(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_WorkSource_WorkChain$__constructor__(android.os.Parcel android.os.WorkSource$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(WorkChain.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WorkChain)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

