/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.EventLogTags;
import android.os.IBinder;
import android.os.IServiceManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManagerNative;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BinderInternal;
import com.android.internal.util.StatLogger;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ServiceManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ServiceManager";
    private static Object sLock;
    private static IServiceManager sServiceManager;
    private static HashMap<String, IBinder> sCache;
    private static int SLOW_LOG_INTERVAL_MS = 5000;
    private static int STATS_LOG_INTERVAL_MS = 5000;
    private static long GET_SERVICE_SLOW_THRESHOLD_US_CORE;
    private static long GET_SERVICE_SLOW_THRESHOLD_US_NON_CORE;
    private static int GET_SERVICE_LOG_EVERY_CALLS_CORE;
    private static int GET_SERVICE_LOG_EVERY_CALLS_NON_CORE;
    @GuardedBy(value="sLock")
    private static int sGetServiceAccumulatedUs;
    @GuardedBy(value="sLock")
    private static int sGetServiceAccumulatedCallCount;
    @GuardedBy(value="sLock")
    private static long sLastStatsLogUptime;
    @GuardedBy(value="sLock")
    private static long sLastSlowLogUptime;
    @GuardedBy(value="sLock")
    private static long sLastSlowLogActualTime;
    public static StatLogger sStatLogger;

    private void $$robo$$android_os_ServiceManager$__constructor__() {
    }

    private static final IServiceManager $$robo$$android_os_ServiceManager$getIServiceManager() {
        if (sServiceManager != null) {
            return sServiceManager;
        }
        sServiceManager = ServiceManagerNative.asInterface(Binder.allowBlocking(BinderInternal.getContextObject()));
        return sServiceManager;
    }

    private static final IBinder $$robo$$android_os_ServiceManager$getService(String name) {
        try {
            IBinder service = sCache.get(name);
            if (service != null) {
                return service;
            }
            return Binder.allowBlocking(ServiceManager.rawGetService(name));
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in getService", e);
            return null;
        }
    }

    private static final IBinder $$robo$$android_os_ServiceManager$getServiceOrThrow(String name) throws ServiceNotFoundException {
        IBinder binder = ServiceManager.getService(name);
        if (binder != null) {
            return binder;
        }
        throw new ServiceNotFoundException(name);
    }

    private static final void $$robo$$android_os_ServiceManager$addService(String name, IBinder service) {
        ServiceManager.addService(name, service, false, 8);
    }

    private static final void $$robo$$android_os_ServiceManager$addService(String name, IBinder service, boolean allowIsolated) {
        ServiceManager.addService(name, service, allowIsolated, 8);
    }

    private static final void $$robo$$android_os_ServiceManager$addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) {
        try {
            ServiceManager.getIServiceManager().addService(name, service, allowIsolated, dumpPriority);
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in addService", e);
        }
    }

    private static final IBinder $$robo$$android_os_ServiceManager$checkService(String name) {
        try {
            IBinder service = sCache.get(name);
            if (service != null) {
                return service;
            }
            return Binder.allowBlocking(ServiceManager.getIServiceManager().checkService(name));
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in checkService", e);
            return null;
        }
    }

    private static final String[] $$robo$$android_os_ServiceManager$listServices() {
        try {
            return ServiceManager.getIServiceManager().listServices(15);
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in listServices", e);
            return null;
        }
    }

    private static final void $$robo$$android_os_ServiceManager$initServiceCache(Map<String, IBinder> cache) {
        if (sCache.size() != 0) {
            throw new IllegalStateException("setServiceCache may only be called once");
        }
        sCache.putAll(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IBinder $$robo$$android_os_ServiceManager$rawGetService(String name) throws RemoteException {
        long start = sStatLogger.getTime();
        IBinder binder = ServiceManager.getIServiceManager().getService(name);
        int time = (int)sStatLogger.logDurationStat(0, start);
        int myUid = Process.myUid();
        boolean isCore = UserHandle.isCore(myUid);
        long slowThreshold = isCore ? GET_SERVICE_SLOW_THRESHOLD_US_CORE : GET_SERVICE_SLOW_THRESHOLD_US_NON_CORE;
        Object object = sLock;
        synchronized (object) {
            int logInterval;
            sGetServiceAccumulatedUs += time;
            ++sGetServiceAccumulatedCallCount;
            long nowUptime = SystemClock.uptimeMillis();
            if ((long)time >= slowThreshold && (nowUptime > sLastSlowLogUptime + 5000L || sLastSlowLogActualTime < (long)time)) {
                EventLogTags.writeServiceManagerSlow(time / 1000, name);
                sLastSlowLogUptime = nowUptime;
                sLastSlowLogActualTime = time;
            }
            int n = logInterval = isCore ? GET_SERVICE_LOG_EVERY_CALLS_CORE : GET_SERVICE_LOG_EVERY_CALLS_NON_CORE;
            if (sGetServiceAccumulatedCallCount >= logInterval && nowUptime >= sLastStatsLogUptime + 5000L) {
                EventLogTags.writeServiceManagerStats(sGetServiceAccumulatedCallCount, sGetServiceAccumulatedUs / 1000, (int)(nowUptime - sLastStatsLogUptime));
                sGetServiceAccumulatedCallCount = 0;
                sGetServiceAccumulatedUs = 0;
                sLastStatsLogUptime = nowUptime;
            }
        }
        return binder;
    }

    static void __staticInitializer__() {
        sLock = new Object();
        sCache = new HashMap();
        GET_SERVICE_SLOW_THRESHOLD_US_CORE = SystemProperties.getInt("debug.servicemanager.slow_call_core_ms", 10) * 1000;
        GET_SERVICE_SLOW_THRESHOLD_US_NON_CORE = SystemProperties.getInt("debug.servicemanager.slow_call_ms", 50) * 1000;
        GET_SERVICE_LOG_EVERY_CALLS_CORE = SystemProperties.getInt("debug.servicemanager.log_calls_core", 100);
        GET_SERVICE_LOG_EVERY_CALLS_NON_CORE = SystemProperties.getInt("debug.servicemanager.log_calls", 200);
        sStatLogger = new StatLogger(new String[]{"getService()"});
    }

    private void __constructor__() {
        this.$$robo$$android_os_ServiceManager$__constructor__();
    }

    public ServiceManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ServiceManager$__constructor__(), this);
    }

    private static IServiceManager getIServiceManager() {
        return InvokeDynamicSupport.bootstrapStatic("getIServiceManager", $$robo$$android_os_ServiceManager$getIServiceManager());
    }

    public static IBinder getService(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_os_ServiceManager$getService(java.lang.String ), (String)string2);
    }

    public static IBinder getServiceOrThrow(String string2) throws ServiceNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getServiceOrThrow", $$robo$$android_os_ServiceManager$getServiceOrThrow(java.lang.String ), (String)string2);
    }

    public static void addService(String string2, IBinder iBinder) {
        InvokeDynamicSupport.bootstrapStatic("addService", $$robo$$android_os_ServiceManager$addService(java.lang.String android.os.IBinder ), (String)string2, (IBinder)iBinder);
    }

    public static void addService(String string2, IBinder iBinder, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("addService", $$robo$$android_os_ServiceManager$addService(java.lang.String android.os.IBinder boolean ), (String)string2, (IBinder)iBinder, (boolean)bl);
    }

    public static void addService(String string2, IBinder iBinder, boolean bl, int n) {
        InvokeDynamicSupport.bootstrapStatic("addService", $$robo$$android_os_ServiceManager$addService(java.lang.String android.os.IBinder boolean int ), (String)string2, (IBinder)iBinder, (boolean)bl, (int)n);
    }

    public static IBinder checkService(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("checkService", $$robo$$android_os_ServiceManager$checkService(java.lang.String ), (String)string2);
    }

    public static String[] listServices() {
        return InvokeDynamicSupport.bootstrapStatic("listServices", $$robo$$android_os_ServiceManager$listServices());
    }

    public static void initServiceCache(Map<String, IBinder> map) {
        InvokeDynamicSupport.bootstrapStatic("initServiceCache", $$robo$$android_os_ServiceManager$initServiceCache(java.util.Map<java.lang.String, android.os.IBinder> ), map);
    }

    private static IBinder rawGetService(String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("rawGetService", $$robo$$android_os_ServiceManager$rawGetService(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(ServiceManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ServiceNotFoundException
    extends Exception
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_ServiceManager_ServiceNotFoundException$__constructor__(String name) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_os_ServiceManager_ServiceNotFoundException$__constructor__(string2);
        }

        public ServiceNotFoundException(String string2) {
            super("No service published for: " + string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ServiceManager_ServiceNotFoundException$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ ServiceNotFoundException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceNotFoundException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface Stats {
        public static final int GET_SERVICE = 0;
        public static final int COUNT = 1;
    }
}

