/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.opengl.EGL14;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import dalvik.system.VMRuntime;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GraphicsEnvironment
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static GraphicsEnvironment sInstance;
    private static boolean DEBUG = false;
    private static String TAG = "GraphicsEnvironment";
    private static String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";
    private ClassLoader mClassLoader;
    private String mLayerPath;
    private String mDebugLayerPath;

    private void $$robo$$android_os_GraphicsEnvironment$__constructor__() {
    }

    private static final GraphicsEnvironment $$robo$$android_os_GraphicsEnvironment$getInstance() {
        return sInstance;
    }

    private final void $$robo$$android_os_GraphicsEnvironment$setup(Context context) {
        this.setupGpuLayers(context);
        GraphicsEnvironment.chooseDriver(context);
    }

    private static final boolean $$robo$$android_os_GraphicsEnvironment$isDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) > 0;
    }

    private final void $$robo$$android_os_GraphicsEnvironment$setLayerPaths(ClassLoader classLoader, String layerPath, String debugLayerPath) {
        this.mClassLoader = classLoader;
        this.mLayerPath = layerPath;
        this.mDebugLayerPath = debugLayerPath;
    }

    private final void $$robo$$android_os_GraphicsEnvironment$setupGpuLayers(Context context) {
        int enable;
        String layerPaths = "";
        if (GraphicsEnvironment.isDebuggable(context) && (enable = Settings.Global.getInt(context.getContentResolver(), "enable_gpu_debug_layers", 0)) != 0) {
            String gpuDebugApp = Settings.Global.getString(context.getContentResolver(), "gpu_debug_app");
            String packageName = context.getPackageName();
            if (gpuDebugApp != null && packageName != null && !gpuDebugApp.isEmpty() && !packageName.isEmpty() && gpuDebugApp.equals(packageName)) {
                Log.i("GraphicsEnvironment", "GPU debug layers enabled for " + packageName);
                layerPaths = this.mDebugLayerPath + ":";
                String layers = Settings.Global.getString(context.getContentResolver(), "gpu_debug_layers");
                Log.i("GraphicsEnvironment", "Debug layer list: " + layers);
                if (layers != null && !layers.isEmpty()) {
                    GraphicsEnvironment.setDebugLayers(layers);
                }
            }
        }
        layerPaths = layerPaths + this.mLayerPath;
        GraphicsEnvironment.setLayerPaths(this.mClassLoader, layerPaths);
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$chooseDriver(Context context) {
        ApplicationInfo driverInfo;
        String driverPackageName = SystemProperties.get("ro.gfx.driver.0");
        if (driverPackageName == null || driverPackageName.isEmpty()) {
            return;
        }
        ApplicationInfo ai = context.getApplicationInfo();
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return;
        }
        try {
            driverInfo = context.getPackageManager().getApplicationInfo(driverPackageName, 0x100000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("GraphicsEnvironment", "driver package '" + driverPackageName + "' not installed");
            return;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverInfo);
        if (abi == null) {
            return;
        }
        if (driverInfo.targetSdkVersion < 26) {
            Log.w("GraphicsEnvironment", "updated driver package is not known to be compatible with O");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        GraphicsEnvironment.setDriverPath(paths);
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$earlyInitEGL() {
        Thread eglInitThread = new Thread(() -> EGL14.eglGetDisplay(0), "EGL Init");
        eglInitThread.start();
    }

    private static final String $$robo$$android_os_GraphicsEnvironment$chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$setLayerPaths(ClassLoader classLoader, String string2) {
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$setDebugLayers(String string2) {
    }

    private static final void $$robo$$android_os_GraphicsEnvironment$setDriverPath(String string2) {
    }

    static void __staticInitializer__() {
        sInstance = new GraphicsEnvironment();
    }

    private void __constructor__() {
        this.$$robo$$android_os_GraphicsEnvironment$__constructor__();
    }

    public GraphicsEnvironment() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_GraphicsEnvironment$__constructor__(), this);
    }

    public static GraphicsEnvironment getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_os_GraphicsEnvironment$getInstance());
    }

    public void setup(Context context) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_os_GraphicsEnvironment$setup(android.content.Context ), this, context);
    }

    private static boolean isDebuggable(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDebuggable", $$robo$$android_os_GraphicsEnvironment$isDebuggable(android.content.Context ), (Context)context);
    }

    public void setLayerPaths(ClassLoader classLoader, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setLayerPaths", $$robo$$android_os_GraphicsEnvironment$setLayerPaths(java.lang.ClassLoader java.lang.String java.lang.String ), this, classLoader, string2, string3);
    }

    private void setupGpuLayers(Context context) {
        InvokeDynamicSupport.bootstrap("setupGpuLayers", $$robo$$android_os_GraphicsEnvironment$setupGpuLayers(android.content.Context ), this, context);
    }

    private static void chooseDriver(Context context) {
        InvokeDynamicSupport.bootstrapStatic("chooseDriver", $$robo$$android_os_GraphicsEnvironment$chooseDriver(android.content.Context ), (Context)context);
    }

    public static void earlyInitEGL() {
        InvokeDynamicSupport.bootstrapStatic("earlyInitEGL", $$robo$$android_os_GraphicsEnvironment$earlyInitEGL());
    }

    private static String chooseAbi(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrapStatic("chooseAbi", $$robo$$android_os_GraphicsEnvironment$chooseAbi(android.content.pm.ApplicationInfo ), (ApplicationInfo)applicationInfo);
    }

    private static void setLayerPaths(ClassLoader classLoader, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setLayerPaths", $$robo$$android_os_GraphicsEnvironment$setLayerPaths(java.lang.ClassLoader java.lang.String ), (ClassLoader)classLoader, (String)string2);
    }

    private static void setDebugLayers(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDebugLayers", $$robo$$android_os_GraphicsEnvironment$setDebugLayers(java.lang.String ), (String)string2);
    }

    private static void setDriverPath(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDriverPath", $$robo$$android_os_GraphicsEnvironment$setDriverPath(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(GraphicsEnvironment.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GraphicsEnvironment)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

