/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.os.Environment;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.TypedProperties;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMDebug;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Debug
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Debug";
    @Deprecated
    public static int TRACE_COUNT_ALLOCS = 1;
    public static int SHOW_FULL_DETAIL = 1;
    public static int SHOW_CLASSLOADER = 2;
    public static int SHOW_INITIALIZED = 4;
    private static volatile boolean mWaiting;
    private static int MIN_DEBUGGER_IDLE = 1300;
    private static int SPIN_DELAY = 200;
    private static String DEFAULT_TRACE_BODY = "dmtrace";
    private static String DEFAULT_TRACE_EXTENSION = ".trace";
    private static String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";
    public static int MEMINFO_TOTAL = 0;
    public static int MEMINFO_FREE = 1;
    public static int MEMINFO_BUFFERS = 2;
    public static int MEMINFO_CACHED = 3;
    public static int MEMINFO_SHMEM = 4;
    public static int MEMINFO_SLAB = 5;
    public static int MEMINFO_SLAB_RECLAIMABLE = 6;
    public static int MEMINFO_SLAB_UNRECLAIMABLE = 7;
    public static int MEMINFO_SWAP_TOTAL = 8;
    public static int MEMINFO_SWAP_FREE = 9;
    public static int MEMINFO_ZRAM_TOTAL = 10;
    public static int MEMINFO_MAPPED = 11;
    public static int MEMINFO_VM_ALLOC_USED = 12;
    public static int MEMINFO_PAGE_TABLES = 13;
    public static int MEMINFO_KERNEL_STACK = 14;
    public static int MEMINFO_COUNT = 15;
    private static TypedProperties debugProperties;

    private void $$robo$$android_os_Debug$__constructor__() {
    }

    private static final void $$robo$$android_os_Debug$waitForDebugger() {
        block9: {
            long delta;
            if (!VMDebug.isDebuggingEnabled()) {
                return;
            }
            if (Debug.isDebuggerConnected()) {
                return;
            }
            System.out.println("Sending WAIT chunk");
            byte[] data = new byte[]{0};
            Chunk waitChunk = new Chunk(ChunkHandler.type("WAIT"), data, 0, 1);
            DdmServer.sendChunk(waitChunk);
            mWaiting = true;
            while (!Debug.isDebuggerConnected()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            mWaiting = false;
            System.out.println("Debugger has connected");
            while (true) {
                if ((delta = VMDebug.lastDebuggerActivity()) < 0L) {
                    System.out.println("debugger detached?");
                    break block9;
                }
                if (delta >= 1300L) break;
                System.out.println("waiting for debugger to settle...");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("debugger has settled (" + delta + ")");
        }
    }

    private static final boolean $$robo$$android_os_Debug$waitingForDebugger() {
        return mWaiting;
    }

    private static final boolean $$robo$$android_os_Debug$isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    private static final String[] $$robo$$android_os_Debug$getVmFeatureList() {
        return VMDebug.getVmFeatureList();
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$changeDebugPort(int port) {
    }

    private static final void $$robo$$android_os_Debug$startNativeTracing() {
        try (PrintWriter outStream = null;){
            FileOutputStream fos = new FileOutputStream("/sys/qemu_trace/state");
            outStream = new FastPrintWriter(fos);
            outStream.println("1");
        }
        VMDebug.startEmulatorTracing();
    }

    private static final void $$robo$$android_os_Debug$stopNativeTracing() {
        VMDebug.stopEmulatorTracing();
        try (PrintWriter outStream = null;){
            FileOutputStream fos = new FileOutputStream("/sys/qemu_trace/state");
            outStream = new FastPrintWriter(fos);
            outStream.println("0");
        }
    }

    private static final void $$robo$$android_os_Debug$enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing() {
        VMDebug.startMethodTracing(Debug.fixTracePath(null), 0, 0, false, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String tracePath) {
        Debug.startMethodTracing(tracePath, 0, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String tracePath, int bufferSize) {
        Debug.startMethodTracing(tracePath, bufferSize, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String tracePath, int bufferSize, int flags) {
        VMDebug.startMethodTracing(Debug.fixTracePath(tracePath), bufferSize, flags, false, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracingSampling(String tracePath, int bufferSize, int intervalUs) {
        VMDebug.startMethodTracing(Debug.fixTracePath(tracePath), bufferSize, 0, true, intervalUs);
    }

    private static final String $$robo$$android_os_Debug$fixTracePath(String tracePath) {
        if (tracePath == null || tracePath.charAt(0) != '/') {
            Application context = AppGlobals.getInitialApplication();
            File dir = context != null ? ((Context)context).getExternalFilesDir(null) : Environment.getExternalStorageDirectory();
            tracePath = tracePath == null ? new File(dir, "dmtrace").getAbsolutePath() : new File(dir, tracePath).getAbsolutePath();
        }
        if (!tracePath.endsWith(".trace")) {
            tracePath = tracePath + ".trace";
        }
        return tracePath;
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String traceName, FileDescriptor fd, int bufferSize, int flags, boolean streamOutput) {
        VMDebug.startMethodTracing(traceName, fd, bufferSize, flags, false, 0, streamOutput);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracingDdms(int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingDdms(bufferSize, flags, samplingEnabled, intervalUs);
    }

    private static final int $$robo$$android_os_Debug$getMethodTracingMode() {
        return VMDebug.getMethodTracingMode();
    }

    private static final void $$robo$$android_os_Debug$stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    private static final long $$robo$$android_os_Debug$threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalAllocCount() {
        return VMDebug.getAllocCount(1);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalAllocCount() {
        VMDebug.resetAllocCount(1);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalAllocSize() {
        return VMDebug.getAllocCount(2);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalAllocSize() {
        VMDebug.resetAllocCount(2);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalFreedCount() {
        return VMDebug.getAllocCount(4);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalFreedCount() {
        VMDebug.resetAllocCount(4);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalFreedSize() {
        return VMDebug.getAllocCount(8);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalFreedSize() {
        VMDebug.resetAllocCount(8);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount(16);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount(16);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalClassInitCount() {
        return VMDebug.getAllocCount(32);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalClassInitCount() {
        VMDebug.resetAllocCount(32);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalClassInitTime() {
        return VMDebug.getAllocCount(64);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalClassInitTime() {
        VMDebug.resetAllocCount(64);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalAllocCount() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalAllocSize() {
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalAllocCount() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalAllocSize() {
        return 0;
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalFreedCount() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalFreedCount() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalFreedSize() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalFreedSize() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadAllocCount() {
        return VMDebug.getAllocCount(65536);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadAllocCount() {
        VMDebug.resetAllocCount(65536);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadAllocSize() {
        return VMDebug.getAllocCount(131072);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadAllocSize() {
        VMDebug.resetAllocCount(131072);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadExternalAllocCount() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadExternalAllocCount() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadExternalAllocSize() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadExternalAllocSize() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadGcInvocationCount() {
        return VMDebug.getAllocCount(0x100000);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount(0x100000);
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetAllCounts() {
        VMDebug.resetAllocCount(-1);
    }

    private static final String $$robo$$android_os_Debug$getRuntimeStat(String statName) {
        return VMDebug.getRuntimeStat(statName);
    }

    private static final Map<String, String> $$robo$$android_os_Debug$getRuntimeStats() {
        return VMDebug.getRuntimeStats();
    }

    private static final long $$robo$$android_os_Debug$getNativeHeapSize() {
        return 0L;
    }

    private static final long $$robo$$android_os_Debug$getNativeHeapAllocatedSize() {
        return 0L;
    }

    private static final long $$robo$$android_os_Debug$getNativeHeapFreeSize() {
        return 0L;
    }

    private static final void $$robo$$android_os_Debug$getMemoryInfo(MemoryInfo memoryInfo) {
    }

    private static final void $$robo$$android_os_Debug$getMemoryInfo(int n, MemoryInfo memoryInfo) {
    }

    private static final long $$robo$$android_os_Debug$getPss() {
        return 0L;
    }

    private static final long $$robo$$android_os_Debug$getPss(int n, long[] lArray, long[] lArray2) {
        return 0L;
    }

    private static final void $$robo$$android_os_Debug$getMemInfo(long[] lArray) {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$setAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$setGlobalAllocationLimit(int limit) {
        return -1;
    }

    private static final void $$robo$$android_os_Debug$printLoadedClasses(int flags) {
        VMDebug.printLoadedClasses(flags);
    }

    private static final int $$robo$$android_os_Debug$getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    private static final void $$robo$$android_os_Debug$dumpHprofData(String fileName) throws IOException {
        VMDebug.dumpHprofData(fileName);
    }

    private static final void $$robo$$android_os_Debug$dumpHprofData(String fileName, FileDescriptor fd) throws IOException {
        VMDebug.dumpHprofData(fileName, fd);
    }

    private static final void $$robo$$android_os_Debug$dumpHprofDataDdms() {
        VMDebug.dumpHprofDataDdms();
    }

    private static final void $$robo$$android_os_Debug$dumpNativeHeap(FileDescriptor fileDescriptor) {
    }

    private static final void $$robo$$android_os_Debug$dumpNativeMallocInfo(FileDescriptor fileDescriptor) {
    }

    private static final long $$robo$$android_os_Debug$countInstancesOfClass(Class cls) {
        return VMDebug.countInstancesOfClass(cls, true);
    }

    private static final int $$robo$$android_os_Debug$getBinderSentTransactions() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderReceivedTransactions() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderLocalObjectCount() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderProxyObjectCount() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderDeathObjectCount() {
        return 0;
    }

    private static final boolean $$robo$$android_os_Debug$cacheRegisterMap(String classAndMethodDesc) {
        return VMDebug.cacheRegisterMap(classAndMethodDesc);
    }

    private static final void $$robo$$android_os_Debug$dumpReferenceTables() {
        VMDebug.dumpReferenceTables();
    }

    private static final boolean $$robo$$android_os_Debug$fieldTypeMatches(Field field, Class<?> cl) {
        Field primitiveTypeField;
        Class<?> fieldClass = field.getType();
        if (fieldClass == cl) {
            return true;
        }
        try {
            primitiveTypeField = cl.getField("TYPE");
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
        try {
            return fieldClass == (Class)primitiveTypeField.get(null);
        }
        catch (IllegalAccessException ex) {
            return false;
        }
    }

    private static final void $$robo$$android_os_Debug$modifyFieldIfSet(Field field, TypedProperties properties, String propertyName) {
        Object value;
        if (field.getType() == String.class) {
            int stringInfo = properties.getStringInfo(propertyName);
            switch (stringInfo) {
                case 1: {
                    break;
                }
                case 0: {
                    try {
                        field.set(null, null);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
                    }
                    return;
                }
                case -1: {
                    return;
                }
                case -2: {
                    throw new IllegalArgumentException("Type of " + propertyName + "  does not match field type (" + field.getType() + ")");
                }
                default: {
                    throw new IllegalStateException("Unexpected getStringInfo(" + propertyName + ") return value " + stringInfo);
                }
            }
        }
        if ((value = properties.get(propertyName)) != null) {
            if (!Debug.fieldTypeMatches(field, value.getClass())) {
                throw new IllegalArgumentException("Type of " + propertyName + " (" + value.getClass() + ")  does not match field type (" + field.getType() + ")");
            }
            try {
                field.set(null, value);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
            }
        }
    }

    private static final void $$robo$$android_os_Debug$setFieldsOn(Class<?> cl) {
        Debug.setFieldsOn(cl, false);
    }

    private static final void $$robo$$android_os_Debug$setFieldsOn(Class<?> cl, boolean partial) {
        Log.wtf("Debug", "setFieldsOn(" + (cl == null ? "null" : cl.getName()) + ") called in non-DEBUG build");
    }

    private static final boolean $$robo$$android_os_Debug$dumpService(String name, FileDescriptor fd, String[] args) {
        IBinder service = ServiceManager.getService(name);
        if (service == null) {
            Log.e("Debug", "Can't find service to dump: " + name);
            return false;
        }
        try {
            service.dump(fd, args);
            return true;
        }
        catch (RemoteException e) {
            Log.e("Debug", "Can't dump service: " + name, e);
            return false;
        }
    }

    private static final boolean $$robo$$android_os_Debug$dumpJavaBacktraceToFileTimeout(int n, String string2, int n2) {
        return false;
    }

    private static final boolean $$robo$$android_os_Debug$dumpNativeBacktraceToFileTimeout(int n, String string2, int n2) {
        return false;
    }

    private static final String $$robo$$android_os_Debug$getUnreachableMemory(int n, boolean bl) {
        return null;
    }

    private static final String $$robo$$android_os_Debug$getCaller(StackTraceElement[] callStack, int depth) {
        if (4 + depth >= callStack.length) {
            return "<bottom of call stack>";
        }
        StackTraceElement caller = callStack[4 + depth];
        return caller.getClassName() + "." + caller.getMethodName() + ":" + caller.getLineNumber();
    }

    private static final String $$robo$$android_os_Debug$getCallers(int depth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(Debug.getCaller(callStack, i)).append(" ");
        }
        return sb.toString();
    }

    private static final String $$robo$$android_os_Debug$getCallers(int start, int depth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        depth += start;
        for (int i = start; i < depth; ++i) {
            sb.append(Debug.getCaller(callStack, i)).append(" ");
        }
        return sb.toString();
    }

    private static final String $$robo$$android_os_Debug$getCallers(int depth, String linePrefix) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(linePrefix).append(Debug.getCaller(callStack, i)).append("\n");
        }
        return sb.toString();
    }

    private static final String $$robo$$android_os_Debug$getCaller() {
        return Debug.getCaller(Thread.currentThread().getStackTrace(), 0);
    }

    private static final void $$robo$$android_os_Debug$attachJvmtiAgent(String library, String options, ClassLoader classLoader) throws IOException {
        Preconditions.checkNotNull(library);
        Preconditions.checkArgument(!library.contains("="));
        if (options == null) {
            VMDebug.attachAgent(library, classLoader);
        } else {
            VMDebug.attachAgent(library + "=" + options, classLoader);
        }
    }

    static void __staticInitializer__() {
        mWaiting = false;
        debugProperties = null;
    }

    private void __constructor__() {
        this.$$robo$$android_os_Debug$__constructor__();
    }

    public Debug() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug$__constructor__(), this);
    }

    public static void waitForDebugger() {
        InvokeDynamicSupport.bootstrapStatic("waitForDebugger", $$robo$$android_os_Debug$waitForDebugger());
    }

    public static boolean waitingForDebugger() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("waitingForDebugger", $$robo$$android_os_Debug$waitingForDebugger());
    }

    public static boolean isDebuggerConnected() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDebuggerConnected", $$robo$$android_os_Debug$isDebuggerConnected());
    }

    public static String[] getVmFeatureList() {
        return InvokeDynamicSupport.bootstrapStatic("getVmFeatureList", $$robo$$android_os_Debug$getVmFeatureList());
    }

    @Deprecated
    public static void changeDebugPort(int n) {
        InvokeDynamicSupport.bootstrapStatic("changeDebugPort", $$robo$$android_os_Debug$changeDebugPort(int ), (int)n);
    }

    public static void startNativeTracing() {
        InvokeDynamicSupport.bootstrapStatic("startNativeTracing", $$robo$$android_os_Debug$startNativeTracing());
    }

    public static void stopNativeTracing() {
        InvokeDynamicSupport.bootstrapStatic("stopNativeTracing", $$robo$$android_os_Debug$stopNativeTracing());
    }

    public static void enableEmulatorTraceOutput() {
        InvokeDynamicSupport.bootstrapStatic("enableEmulatorTraceOutput", $$robo$$android_os_Debug$enableEmulatorTraceOutput());
    }

    public static void startMethodTracing() {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing());
    }

    public static void startMethodTracing(String string2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String ), (String)string2);
    }

    public static void startMethodTracing(String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String int ), (String)string2, (int)n);
    }

    public static void startMethodTracing(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public static void startMethodTracingSampling(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracingSampling", $$robo$$android_os_Debug$startMethodTracingSampling(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    private static String fixTracePath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fixTracePath", $$robo$$android_os_Debug$fixTracePath(java.lang.String ), (String)string2);
    }

    public static void startMethodTracing(String string2, FileDescriptor fileDescriptor, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String java.io.FileDescriptor int int boolean ), (String)string2, (FileDescriptor)fileDescriptor, (int)n, (int)n2, (boolean)bl);
    }

    public static void startMethodTracingDdms(int n, int n2, boolean bl, int n3) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracingDdms", $$robo$$android_os_Debug$startMethodTracingDdms(int int boolean int ), (int)n, (int)n2, (boolean)bl, (int)n3);
    }

    public static int getMethodTracingMode() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMethodTracingMode", $$robo$$android_os_Debug$getMethodTracingMode());
    }

    public static void stopMethodTracing() {
        InvokeDynamicSupport.bootstrapStatic("stopMethodTracing", $$robo$$android_os_Debug$stopMethodTracing());
    }

    public static long threadCpuTimeNanos() {
        return (long)InvokeDynamicSupport.bootstrapStatic("threadCpuTimeNanos", $$robo$$android_os_Debug$threadCpuTimeNanos());
    }

    @Deprecated
    public static void startAllocCounting() {
        InvokeDynamicSupport.bootstrapStatic("startAllocCounting", $$robo$$android_os_Debug$startAllocCounting());
    }

    @Deprecated
    public static void stopAllocCounting() {
        InvokeDynamicSupport.bootstrapStatic("stopAllocCounting", $$robo$$android_os_Debug$stopAllocCounting());
    }

    @Deprecated
    public static int getGlobalAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAllocCount", $$robo$$android_os_Debug$getGlobalAllocCount());
    }

    @Deprecated
    public static void resetGlobalAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalAllocCount", $$robo$$android_os_Debug$resetGlobalAllocCount());
    }

    @Deprecated
    public static int getGlobalAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAllocSize", $$robo$$android_os_Debug$getGlobalAllocSize());
    }

    @Deprecated
    public static void resetGlobalAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalAllocSize", $$robo$$android_os_Debug$resetGlobalAllocSize());
    }

    @Deprecated
    public static int getGlobalFreedCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalFreedCount", $$robo$$android_os_Debug$getGlobalFreedCount());
    }

    @Deprecated
    public static void resetGlobalFreedCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalFreedCount", $$robo$$android_os_Debug$resetGlobalFreedCount());
    }

    @Deprecated
    public static int getGlobalFreedSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalFreedSize", $$robo$$android_os_Debug$getGlobalFreedSize());
    }

    @Deprecated
    public static void resetGlobalFreedSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalFreedSize", $$robo$$android_os_Debug$resetGlobalFreedSize());
    }

    @Deprecated
    public static int getGlobalGcInvocationCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalGcInvocationCount", $$robo$$android_os_Debug$getGlobalGcInvocationCount());
    }

    @Deprecated
    public static void resetGlobalGcInvocationCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalGcInvocationCount", $$robo$$android_os_Debug$resetGlobalGcInvocationCount());
    }

    @Deprecated
    public static int getGlobalClassInitCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalClassInitCount", $$robo$$android_os_Debug$getGlobalClassInitCount());
    }

    @Deprecated
    public static void resetGlobalClassInitCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalClassInitCount", $$robo$$android_os_Debug$resetGlobalClassInitCount());
    }

    @Deprecated
    public static int getGlobalClassInitTime() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalClassInitTime", $$robo$$android_os_Debug$getGlobalClassInitTime());
    }

    @Deprecated
    public static void resetGlobalClassInitTime() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalClassInitTime", $$robo$$android_os_Debug$resetGlobalClassInitTime());
    }

    @Deprecated
    public static int getGlobalExternalAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalAllocCount", $$robo$$android_os_Debug$getGlobalExternalAllocCount());
    }

    @Deprecated
    public static void resetGlobalExternalAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalAllocSize", $$robo$$android_os_Debug$resetGlobalExternalAllocSize());
    }

    @Deprecated
    public static void resetGlobalExternalAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalAllocCount", $$robo$$android_os_Debug$resetGlobalExternalAllocCount());
    }

    @Deprecated
    public static int getGlobalExternalAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalAllocSize", $$robo$$android_os_Debug$getGlobalExternalAllocSize());
    }

    @Deprecated
    public static int getGlobalExternalFreedCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalFreedCount", $$robo$$android_os_Debug$getGlobalExternalFreedCount());
    }

    @Deprecated
    public static void resetGlobalExternalFreedCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalFreedCount", $$robo$$android_os_Debug$resetGlobalExternalFreedCount());
    }

    @Deprecated
    public static int getGlobalExternalFreedSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalFreedSize", $$robo$$android_os_Debug$getGlobalExternalFreedSize());
    }

    @Deprecated
    public static void resetGlobalExternalFreedSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalFreedSize", $$robo$$android_os_Debug$resetGlobalExternalFreedSize());
    }

    @Deprecated
    public static int getThreadAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadAllocCount", $$robo$$android_os_Debug$getThreadAllocCount());
    }

    @Deprecated
    public static void resetThreadAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadAllocCount", $$robo$$android_os_Debug$resetThreadAllocCount());
    }

    @Deprecated
    public static int getThreadAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadAllocSize", $$robo$$android_os_Debug$getThreadAllocSize());
    }

    @Deprecated
    public static void resetThreadAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadAllocSize", $$robo$$android_os_Debug$resetThreadAllocSize());
    }

    @Deprecated
    public static int getThreadExternalAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadExternalAllocCount", $$robo$$android_os_Debug$getThreadExternalAllocCount());
    }

    @Deprecated
    public static void resetThreadExternalAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadExternalAllocCount", $$robo$$android_os_Debug$resetThreadExternalAllocCount());
    }

    @Deprecated
    public static int getThreadExternalAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadExternalAllocSize", $$robo$$android_os_Debug$getThreadExternalAllocSize());
    }

    @Deprecated
    public static void resetThreadExternalAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadExternalAllocSize", $$robo$$android_os_Debug$resetThreadExternalAllocSize());
    }

    @Deprecated
    public static int getThreadGcInvocationCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadGcInvocationCount", $$robo$$android_os_Debug$getThreadGcInvocationCount());
    }

    @Deprecated
    public static void resetThreadGcInvocationCount() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadGcInvocationCount", $$robo$$android_os_Debug$resetThreadGcInvocationCount());
    }

    @Deprecated
    public static void resetAllCounts() {
        InvokeDynamicSupport.bootstrapStatic("resetAllCounts", $$robo$$android_os_Debug$resetAllCounts());
    }

    public static String getRuntimeStat(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getRuntimeStat", $$robo$$android_os_Debug$getRuntimeStat(java.lang.String ), (String)string2);
    }

    public static Map<String, String> getRuntimeStats() {
        return InvokeDynamicSupport.bootstrapStatic("getRuntimeStats", $$robo$$android_os_Debug$getRuntimeStats());
    }

    public static long getNativeHeapSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeHeapSize", $$robo$$android_os_Debug$getNativeHeapSize());
    }

    public static long getNativeHeapAllocatedSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeHeapAllocatedSize", $$robo$$android_os_Debug$getNativeHeapAllocatedSize());
    }

    public static long getNativeHeapFreeSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeHeapFreeSize", $$robo$$android_os_Debug$getNativeHeapFreeSize());
    }

    public static void getMemoryInfo(MemoryInfo memoryInfo) {
        InvokeDynamicSupport.bootstrapStatic("getMemoryInfo", $$robo$$android_os_Debug$getMemoryInfo(android.os.Debug$MemoryInfo ), (MemoryInfo)memoryInfo);
    }

    public static void getMemoryInfo(int n, MemoryInfo memoryInfo) {
        InvokeDynamicSupport.bootstrapStatic("getMemoryInfo", $$robo$$android_os_Debug$getMemoryInfo(int android.os.Debug$MemoryInfo ), (int)n, (MemoryInfo)memoryInfo);
    }

    public static long getPss() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPss", $$robo$$android_os_Debug$getPss());
    }

    public static long getPss(int n, long[] lArray, long[] lArray2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPss", $$robo$$android_os_Debug$getPss(int long[] long[] ), (int)n, (long[])lArray, (long[])lArray2);
    }

    public static void getMemInfo(long[] lArray) {
        InvokeDynamicSupport.bootstrapStatic("getMemInfo", $$robo$$android_os_Debug$getMemInfo(long[] ), (long[])lArray);
    }

    @Deprecated
    public static int setAllocationLimit(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setAllocationLimit", $$robo$$android_os_Debug$setAllocationLimit(int ), (int)n);
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setGlobalAllocationLimit", $$robo$$android_os_Debug$setGlobalAllocationLimit(int ), (int)n);
    }

    public static void printLoadedClasses(int n) {
        InvokeDynamicSupport.bootstrapStatic("printLoadedClasses", $$robo$$android_os_Debug$printLoadedClasses(int ), (int)n);
    }

    public static int getLoadedClassCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLoadedClassCount", $$robo$$android_os_Debug$getLoadedClassCount());
    }

    public static void dumpHprofData(String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("dumpHprofData", $$robo$$android_os_Debug$dumpHprofData(java.lang.String ), (String)string2);
    }

    public static void dumpHprofData(String string2, FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("dumpHprofData", $$robo$$android_os_Debug$dumpHprofData(java.lang.String java.io.FileDescriptor ), (String)string2, (FileDescriptor)fileDescriptor);
    }

    public static void dumpHprofDataDdms() {
        InvokeDynamicSupport.bootstrapStatic("dumpHprofDataDdms", $$robo$$android_os_Debug$dumpHprofDataDdms());
    }

    public static void dumpNativeHeap(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("dumpNativeHeap", $$robo$$android_os_Debug$dumpNativeHeap(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public static void dumpNativeMallocInfo(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("dumpNativeMallocInfo", $$robo$$android_os_Debug$dumpNativeMallocInfo(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public static long countInstancesOfClass(Class clazz) {
        return (long)InvokeDynamicSupport.bootstrapStatic("countInstancesOfClass", $$robo$$android_os_Debug$countInstancesOfClass(java.lang.Class ), (Class)clazz);
    }

    public static int getBinderSentTransactions() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderSentTransactions", $$robo$$android_os_Debug$getBinderSentTransactions());
    }

    public static int getBinderReceivedTransactions() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderReceivedTransactions", $$robo$$android_os_Debug$getBinderReceivedTransactions());
    }

    public static int getBinderLocalObjectCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderLocalObjectCount", $$robo$$android_os_Debug$getBinderLocalObjectCount());
    }

    public static int getBinderProxyObjectCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderProxyObjectCount", $$robo$$android_os_Debug$getBinderProxyObjectCount());
    }

    public static int getBinderDeathObjectCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderDeathObjectCount", $$robo$$android_os_Debug$getBinderDeathObjectCount());
    }

    public static boolean cacheRegisterMap(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("cacheRegisterMap", $$robo$$android_os_Debug$cacheRegisterMap(java.lang.String ), (String)string2);
    }

    public static void dumpReferenceTables() {
        InvokeDynamicSupport.bootstrapStatic("dumpReferenceTables", $$robo$$android_os_Debug$dumpReferenceTables());
    }

    private static boolean fieldTypeMatches(Field field, Class<?> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fieldTypeMatches", $$robo$$android_os_Debug$fieldTypeMatches(java.lang.reflect.Field java.lang.Class<?> ), (Field)field, clazz);
    }

    private static void modifyFieldIfSet(Field field, TypedProperties typedProperties, String string2) {
        InvokeDynamicSupport.bootstrapStatic("modifyFieldIfSet", $$robo$$android_os_Debug$modifyFieldIfSet(java.lang.reflect.Field com.android.internal.util.TypedProperties java.lang.String ), (Field)field, (TypedProperties)typedProperties, (String)string2);
    }

    public static void setFieldsOn(Class<?> clazz) {
        InvokeDynamicSupport.bootstrapStatic("setFieldsOn", $$robo$$android_os_Debug$setFieldsOn(java.lang.Class<?> ), clazz);
    }

    public static void setFieldsOn(Class<?> clazz, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setFieldsOn", $$robo$$android_os_Debug$setFieldsOn(java.lang.Class<?> boolean ), clazz, (boolean)bl);
    }

    public static boolean dumpService(String string2, FileDescriptor fileDescriptor, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("dumpService", $$robo$$android_os_Debug$dumpService(java.lang.String java.io.FileDescriptor java.lang.String[] ), (String)string2, (FileDescriptor)fileDescriptor, (String[])stringArray);
    }

    public static boolean dumpJavaBacktraceToFileTimeout(int n, String string2, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("dumpJavaBacktraceToFileTimeout", $$robo$$android_os_Debug$dumpJavaBacktraceToFileTimeout(int java.lang.String int ), (int)n, (String)string2, (int)n2);
    }

    public static boolean dumpNativeBacktraceToFileTimeout(int n, String string2, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("dumpNativeBacktraceToFileTimeout", $$robo$$android_os_Debug$dumpNativeBacktraceToFileTimeout(int java.lang.String int ), (int)n, (String)string2, (int)n2);
    }

    public static String getUnreachableMemory(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getUnreachableMemory", $$robo$$android_os_Debug$getUnreachableMemory(int boolean ), (int)n, (boolean)bl);
    }

    private static String getCaller(StackTraceElement[] stackTraceElementArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCaller", $$robo$$android_os_Debug$getCaller(java.lang.StackTraceElement[] int ), (StackTraceElement[])stackTraceElementArray, (int)n);
    }

    public static String getCallers(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCallers", $$robo$$android_os_Debug$getCallers(int ), (int)n);
    }

    public static String getCallers(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getCallers", $$robo$$android_os_Debug$getCallers(int int ), (int)n, (int)n2);
    }

    public static String getCallers(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCallers", $$robo$$android_os_Debug$getCallers(int java.lang.String ), (int)n, (String)string2);
    }

    public static String getCaller() {
        return InvokeDynamicSupport.bootstrapStatic("getCaller", $$robo$$android_os_Debug$getCaller());
    }

    public static void attachJvmtiAgent(String string2, String string3, ClassLoader classLoader) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("attachJvmtiAgent", $$robo$$android_os_Debug$attachJvmtiAgent(java.lang.String java.lang.String java.lang.ClassLoader ), (String)string2, (String)string3, (ClassLoader)classLoader);
    }

    static {
        RobolectricInternals.classInitializing(Debug.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Debug)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DebugProperty {
    }

    @Deprecated
    public static class InstructionCount
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_Debug_InstructionCount$__constructor__() {
        }

        private final boolean $$robo$$android_os_Debug_InstructionCount$resetAndStart() {
            return false;
        }

        private final boolean $$robo$$android_os_Debug_InstructionCount$collect() {
            return false;
        }

        private final int $$robo$$android_os_Debug_InstructionCount$globalTotal() {
            return 0;
        }

        private final int $$robo$$android_os_Debug_InstructionCount$globalMethodInvocations() {
            return 0;
        }

        private void __constructor__() {
            this.$$robo$$android_os_Debug_InstructionCount$__constructor__();
        }

        public InstructionCount() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_InstructionCount$__constructor__(), this);
        }

        public boolean resetAndStart() {
            return (boolean)InvokeDynamicSupport.bootstrap("resetAndStart", $$robo$$android_os_Debug_InstructionCount$resetAndStart(), this);
        }

        public boolean collect() {
            return (boolean)InvokeDynamicSupport.bootstrap("collect", $$robo$$android_os_Debug_InstructionCount$collect(), this);
        }

        public int globalTotal() {
            return (int)InvokeDynamicSupport.bootstrap("globalTotal", $$robo$$android_os_Debug_InstructionCount$globalTotal(), this);
        }

        public int globalMethodInvocations() {
            return (int)InvokeDynamicSupport.bootstrap("globalMethodInvocations", $$robo$$android_os_Debug_InstructionCount$globalMethodInvocations(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstructionCount)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MemoryInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int dalvikPss;
        public int dalvikSwappablePss;
        public int dalvikRss;
        public int dalvikPrivateDirty;
        public int dalvikSharedDirty;
        public int dalvikPrivateClean;
        public int dalvikSharedClean;
        public int dalvikSwappedOut;
        public int dalvikSwappedOutPss;
        public int nativePss;
        public int nativeSwappablePss;
        public int nativeRss;
        public int nativePrivateDirty;
        public int nativeSharedDirty;
        public int nativePrivateClean;
        public int nativeSharedClean;
        public int nativeSwappedOut;
        public int nativeSwappedOutPss;
        public int otherPss;
        public int otherSwappablePss;
        public int otherRss;
        public int otherPrivateDirty;
        public int otherSharedDirty;
        public int otherPrivateClean;
        public int otherSharedClean;
        public int otherSwappedOut;
        public int otherSwappedOutPss;
        public boolean hasSwappedOutPss;
        public static int HEAP_UNKNOWN = 0;
        public static int HEAP_DALVIK = 1;
        public static int HEAP_NATIVE = 2;
        public static int OTHER_DALVIK_OTHER = 0;
        public static int OTHER_STACK = 1;
        public static int OTHER_CURSOR = 2;
        public static int OTHER_ASHMEM = 3;
        public static int OTHER_GL_DEV = 4;
        public static int OTHER_UNKNOWN_DEV = 5;
        public static int OTHER_SO = 6;
        public static int OTHER_JAR = 7;
        public static int OTHER_APK = 8;
        public static int OTHER_TTF = 9;
        public static int OTHER_DEX = 10;
        public static int OTHER_OAT = 11;
        public static int OTHER_ART = 12;
        public static int OTHER_UNKNOWN_MAP = 13;
        public static int OTHER_GRAPHICS = 14;
        public static int OTHER_GL = 15;
        public static int OTHER_OTHER_MEMTRACK = 16;
        public static int NUM_OTHER_STATS = 17;
        public static int OTHER_DALVIK_NORMAL = 17;
        public static int OTHER_DALVIK_LARGE = 18;
        public static int OTHER_DALVIK_ZYGOTE = 19;
        public static int OTHER_DALVIK_NON_MOVING = 20;
        public static int OTHER_DVK_STAT_DALVIK_START = 0;
        public static int OTHER_DVK_STAT_DALVIK_END = 3;
        public static int OTHER_DALVIK_OTHER_LINEARALLOC = 21;
        public static int OTHER_DALVIK_OTHER_ACCOUNTING = 22;
        public static int OTHER_DALVIK_OTHER_CODE_CACHE = 23;
        public static int OTHER_DALVIK_OTHER_COMPILER_METADATA = 24;
        public static int OTHER_DALVIK_OTHER_INDIRECT_REFERENCE_TABLE = 25;
        public static int OTHER_DVK_STAT_DALVIK_OTHER_START = 4;
        public static int OTHER_DVK_STAT_DALVIK_OTHER_END = 8;
        public static int OTHER_DEX_BOOT_VDEX = 26;
        public static int OTHER_DEX_APP_DEX = 27;
        public static int OTHER_DEX_APP_VDEX = 28;
        public static int OTHER_DVK_STAT_DEX_START = 9;
        public static int OTHER_DVK_STAT_DEX_END = 11;
        public static int OTHER_ART_APP = 29;
        public static int OTHER_ART_BOOT = 30;
        public static int OTHER_DVK_STAT_ART_START = 12;
        public static int OTHER_DVK_STAT_ART_END = 13;
        public static int NUM_DVK_STATS = 14;
        public static int NUM_CATEGORIES = 9;
        public static int OFFSET_PSS = 0;
        public static int OFFSET_SWAPPABLE_PSS = 1;
        public static int OFFSET_RSS = 2;
        public static int OFFSET_PRIVATE_DIRTY = 3;
        public static int OFFSET_SHARED_DIRTY = 4;
        public static int OFFSET_PRIVATE_CLEAN = 5;
        public static int OFFSET_SHARED_CLEAN = 6;
        public static int OFFSET_SWAPPED_OUT = 7;
        public static int OFFSET_SWAPPED_OUT_PSS = 8;
        private int[] otherStats;
        public static Parcelable.Creator<MemoryInfo> CREATOR;

        private void $$robo$$android_os_Debug_MemoryInfo$__constructor__() {
            this.otherStats = new int[279];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalPss() {
            return this.dalvikPss + this.nativePss + this.otherPss + this.getTotalSwappedOutPss();
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalUss() {
            return this.dalvikPrivateClean + this.dalvikPrivateDirty + this.nativePrivateClean + this.nativePrivateDirty + this.otherPrivateClean + this.otherPrivateDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSwappablePss() {
            return this.dalvikSwappablePss + this.nativeSwappablePss + this.otherSwappablePss;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalRss() {
            return this.dalvikRss + this.nativeRss + this.otherRss;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateDirty() {
            return this.dalvikPrivateDirty + this.nativePrivateDirty + this.otherPrivateDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSharedDirty() {
            return this.dalvikSharedDirty + this.nativeSharedDirty + this.otherSharedDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateClean() {
            return this.dalvikPrivateClean + this.nativePrivateClean + this.otherPrivateClean;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSharedClean() {
            return this.dalvikSharedClean + this.nativeSharedClean + this.otherSharedClean;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSwappedOut() {
            return this.dalvikSwappedOut + this.nativeSwappedOut + this.otherSwappedOut;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSwappedOutPss() {
            return this.dalvikSwappedOutPss + this.nativeSwappedOutPss + this.otherSwappedOutPss;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPss(int which) {
            return this.otherStats[which * 9 + 0];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSwappablePss(int which) {
            return this.otherStats[which * 9 + 1];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherRss(int which) {
            return this.otherStats[which * 9 + 2];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateDirty(int which) {
            return this.otherStats[which * 9 + 3];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSharedDirty(int which) {
            return this.otherStats[which * 9 + 4];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateClean(int which) {
            return this.otherStats[which * 9 + 5];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPrivate(int which) {
            return this.getOtherPrivateClean(which) + this.getOtherPrivateDirty(which);
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSharedClean(int which) {
            return this.otherStats[which * 9 + 6];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSwappedOut(int which) {
            return this.otherStats[which * 9 + 7];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSwappedOutPss(int which) {
            return this.otherStats[which * 9 + 8];
        }

        private static final String $$robo$$android_os_Debug_MemoryInfo$getOtherLabel(int which) {
            switch (which) {
                case 0: {
                    return "Dalvik Other";
                }
                case 1: {
                    return "Stack";
                }
                case 2: {
                    return "Cursor";
                }
                case 3: {
                    return "Ashmem";
                }
                case 4: {
                    return "Gfx dev";
                }
                case 5: {
                    return "Other dev";
                }
                case 6: {
                    return ".so mmap";
                }
                case 7: {
                    return ".jar mmap";
                }
                case 8: {
                    return ".apk mmap";
                }
                case 9: {
                    return ".ttf mmap";
                }
                case 10: {
                    return ".dex mmap";
                }
                case 11: {
                    return ".oat mmap";
                }
                case 12: {
                    return ".art mmap";
                }
                case 13: {
                    return "Other mmap";
                }
                case 14: {
                    return "EGL mtrack";
                }
                case 15: {
                    return "GL mtrack";
                }
                case 16: {
                    return "Other mtrack";
                }
                case 17: {
                    return ".Heap";
                }
                case 18: {
                    return ".LOS";
                }
                case 19: {
                    return ".Zygote";
                }
                case 20: {
                    return ".NonMoving";
                }
                case 21: {
                    return ".LinearAlloc";
                }
                case 22: {
                    return ".GC";
                }
                case 23: {
                    return ".JITCache";
                }
                case 24: {
                    return ".CompilerMetadata";
                }
                case 25: {
                    return ".IndirectRef";
                }
                case 26: {
                    return ".Boot vdex";
                }
                case 27: {
                    return ".App dex";
                }
                case 28: {
                    return ".App vdex";
                }
                case 29: {
                    return ".App art";
                }
                case 30: {
                    return ".Boot art";
                }
            }
            return "????";
        }

        private final String $$robo$$android_os_Debug_MemoryInfo$getMemoryStat(String statName) {
            switch (statName) {
                case "summary.java-heap": {
                    return Integer.toString(this.getSummaryJavaHeap());
                }
                case "summary.native-heap": {
                    return Integer.toString(this.getSummaryNativeHeap());
                }
                case "summary.code": {
                    return Integer.toString(this.getSummaryCode());
                }
                case "summary.stack": {
                    return Integer.toString(this.getSummaryStack());
                }
                case "summary.graphics": {
                    return Integer.toString(this.getSummaryGraphics());
                }
                case "summary.private-other": {
                    return Integer.toString(this.getSummaryPrivateOther());
                }
                case "summary.system": {
                    return Integer.toString(this.getSummarySystem());
                }
                case "summary.total-pss": {
                    return Integer.toString(this.getSummaryTotalPss());
                }
                case "summary.total-swap": {
                    return Integer.toString(this.getSummaryTotalSwap());
                }
            }
            return null;
        }

        private final Map<String, String> $$robo$$android_os_Debug_MemoryInfo$getMemoryStats() {
            HashMap<String, String> stats = new HashMap<String, String>();
            stats.put("summary.java-heap", Integer.toString(this.getSummaryJavaHeap()));
            stats.put("summary.native-heap", Integer.toString(this.getSummaryNativeHeap()));
            stats.put("summary.code", Integer.toString(this.getSummaryCode()));
            stats.put("summary.stack", Integer.toString(this.getSummaryStack()));
            stats.put("summary.graphics", Integer.toString(this.getSummaryGraphics()));
            stats.put("summary.private-other", Integer.toString(this.getSummaryPrivateOther()));
            stats.put("summary.system", Integer.toString(this.getSummarySystem()));
            stats.put("summary.total-pss", Integer.toString(this.getSummaryTotalPss()));
            stats.put("summary.total-swap", Integer.toString(this.getSummaryTotalSwap()));
            return stats;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryJavaHeap() {
            return this.dalvikPrivateDirty + this.getOtherPrivate(12);
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryNativeHeap() {
            return this.nativePrivateDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryCode() {
            return this.getOtherPrivate(6) + this.getOtherPrivate(7) + this.getOtherPrivate(8) + this.getOtherPrivate(9) + this.getOtherPrivate(10) + this.getOtherPrivate(11);
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryStack() {
            return this.getOtherPrivateDirty(1);
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryGraphics() {
            return this.getOtherPrivate(4) + this.getOtherPrivate(14) + this.getOtherPrivate(15);
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryPrivateOther() {
            return this.getTotalPrivateClean() + this.getTotalPrivateDirty() - this.getSummaryJavaHeap() - this.getSummaryNativeHeap() - this.getSummaryCode() - this.getSummaryStack() - this.getSummaryGraphics();
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummarySystem() {
            return this.getTotalPss() - this.getTotalPrivateClean() - this.getTotalPrivateDirty();
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryTotalPss() {
            return this.getTotalPss();
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryTotalSwap() {
            return this.getTotalSwappedOut();
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getSummaryTotalSwapPss() {
            return this.getTotalSwappedOutPss();
        }

        private final boolean $$robo$$android_os_Debug_MemoryInfo$hasSwappedOutPss() {
            return this.hasSwappedOutPss;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_os_Debug_MemoryInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.dalvikPss);
            dest.writeInt(this.dalvikSwappablePss);
            dest.writeInt(this.dalvikRss);
            dest.writeInt(this.dalvikPrivateDirty);
            dest.writeInt(this.dalvikSharedDirty);
            dest.writeInt(this.dalvikPrivateClean);
            dest.writeInt(this.dalvikSharedClean);
            dest.writeInt(this.dalvikSwappedOut);
            dest.writeInt(this.dalvikSwappedOutPss);
            dest.writeInt(this.nativePss);
            dest.writeInt(this.nativeSwappablePss);
            dest.writeInt(this.nativeRss);
            dest.writeInt(this.nativePrivateDirty);
            dest.writeInt(this.nativeSharedDirty);
            dest.writeInt(this.nativePrivateClean);
            dest.writeInt(this.nativeSharedClean);
            dest.writeInt(this.nativeSwappedOut);
            dest.writeInt(this.nativeSwappedOutPss);
            dest.writeInt(this.otherPss);
            dest.writeInt(this.otherSwappablePss);
            dest.writeInt(this.otherRss);
            dest.writeInt(this.otherPrivateDirty);
            dest.writeInt(this.otherSharedDirty);
            dest.writeInt(this.otherPrivateClean);
            dest.writeInt(this.otherSharedClean);
            dest.writeInt(this.otherSwappedOut);
            dest.writeInt(this.hasSwappedOutPss ? 1 : 0);
            dest.writeInt(this.otherSwappedOutPss);
            dest.writeIntArray(this.otherStats);
        }

        private final void $$robo$$android_os_Debug_MemoryInfo$readFromParcel(Parcel source) {
            this.dalvikPss = source.readInt();
            this.dalvikSwappablePss = source.readInt();
            this.dalvikRss = source.readInt();
            this.dalvikPrivateDirty = source.readInt();
            this.dalvikSharedDirty = source.readInt();
            this.dalvikPrivateClean = source.readInt();
            this.dalvikSharedClean = source.readInt();
            this.dalvikSwappedOut = source.readInt();
            this.dalvikSwappedOutPss = source.readInt();
            this.nativePss = source.readInt();
            this.nativeSwappablePss = source.readInt();
            this.nativeRss = source.readInt();
            this.nativePrivateDirty = source.readInt();
            this.nativeSharedDirty = source.readInt();
            this.nativePrivateClean = source.readInt();
            this.nativeSharedClean = source.readInt();
            this.nativeSwappedOut = source.readInt();
            this.nativeSwappedOutPss = source.readInt();
            this.otherPss = source.readInt();
            this.otherSwappablePss = source.readInt();
            this.otherRss = source.readInt();
            this.otherPrivateDirty = source.readInt();
            this.otherSharedDirty = source.readInt();
            this.otherPrivateClean = source.readInt();
            this.otherSharedClean = source.readInt();
            this.otherSwappedOut = source.readInt();
            this.hasSwappedOutPss = source.readInt() != 0;
            this.otherSwappedOutPss = source.readInt();
            this.otherStats = source.createIntArray();
        }

        private void $$robo$$android_os_Debug_MemoryInfo$__constructor__(Parcel source) {
            this.otherStats = new int[279];
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_os_Debug_MemoryInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<MemoryInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_Debug_MemoryInfo_1$__constructor__() {
                }

                private final MemoryInfo $$robo$$android_os_Debug_MemoryInfo_1$createFromParcel(Parcel source) {
                    return new MemoryInfo(source, null);
                }

                private final MemoryInfo[] $$robo$$android_os_Debug_MemoryInfo_1$newArray(int size) {
                    return new MemoryInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_Debug_MemoryInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo_1$__constructor__(), this);
                }

                @Override
                public MemoryInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_Debug_MemoryInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public MemoryInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_Debug_MemoryInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_os_Debug_MemoryInfo$__constructor__();
        }

        public MemoryInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo$__constructor__(), this);
        }

        public int getTotalPss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalPss", $$robo$$android_os_Debug_MemoryInfo$getTotalPss(), this);
        }

        public int getTotalUss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalUss", $$robo$$android_os_Debug_MemoryInfo$getTotalUss(), this);
        }

        public int getTotalSwappablePss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSwappablePss", $$robo$$android_os_Debug_MemoryInfo$getTotalSwappablePss(), this);
        }

        public int getTotalRss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalRss", $$robo$$android_os_Debug_MemoryInfo$getTotalRss(), this);
        }

        public int getTotalPrivateDirty() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalPrivateDirty", $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateDirty(), this);
        }

        public int getTotalSharedDirty() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSharedDirty", $$robo$$android_os_Debug_MemoryInfo$getTotalSharedDirty(), this);
        }

        public int getTotalPrivateClean() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalPrivateClean", $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateClean(), this);
        }

        public int getTotalSharedClean() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSharedClean", $$robo$$android_os_Debug_MemoryInfo$getTotalSharedClean(), this);
        }

        public int getTotalSwappedOut() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSwappedOut", $$robo$$android_os_Debug_MemoryInfo$getTotalSwappedOut(), this);
        }

        public int getTotalSwappedOutPss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSwappedOutPss", $$robo$$android_os_Debug_MemoryInfo$getTotalSwappedOutPss(), this);
        }

        public int getOtherPss(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPss", $$robo$$android_os_Debug_MemoryInfo$getOtherPss(int ), this, n);
        }

        public int getOtherSwappablePss(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSwappablePss", $$robo$$android_os_Debug_MemoryInfo$getOtherSwappablePss(int ), this, n);
        }

        public int getOtherRss(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherRss", $$robo$$android_os_Debug_MemoryInfo$getOtherRss(int ), this, n);
        }

        public int getOtherPrivateDirty(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPrivateDirty", $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateDirty(int ), this, n);
        }

        public int getOtherSharedDirty(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSharedDirty", $$robo$$android_os_Debug_MemoryInfo$getOtherSharedDirty(int ), this, n);
        }

        public int getOtherPrivateClean(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPrivateClean", $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateClean(int ), this, n);
        }

        public int getOtherPrivate(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPrivate", $$robo$$android_os_Debug_MemoryInfo$getOtherPrivate(int ), this, n);
        }

        public int getOtherSharedClean(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSharedClean", $$robo$$android_os_Debug_MemoryInfo$getOtherSharedClean(int ), this, n);
        }

        public int getOtherSwappedOut(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSwappedOut", $$robo$$android_os_Debug_MemoryInfo$getOtherSwappedOut(int ), this, n);
        }

        public int getOtherSwappedOutPss(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSwappedOutPss", $$robo$$android_os_Debug_MemoryInfo$getOtherSwappedOutPss(int ), this, n);
        }

        public static String getOtherLabel(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getOtherLabel", $$robo$$android_os_Debug_MemoryInfo$getOtherLabel(int ), (int)n);
        }

        public String getMemoryStat(String string2) {
            return InvokeDynamicSupport.bootstrap("getMemoryStat", $$robo$$android_os_Debug_MemoryInfo$getMemoryStat(java.lang.String ), this, string2);
        }

        public Map<String, String> getMemoryStats() {
            return InvokeDynamicSupport.bootstrap("getMemoryStats", $$robo$$android_os_Debug_MemoryInfo$getMemoryStats(), this);
        }

        public int getSummaryJavaHeap() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryJavaHeap", $$robo$$android_os_Debug_MemoryInfo$getSummaryJavaHeap(), this);
        }

        public int getSummaryNativeHeap() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryNativeHeap", $$robo$$android_os_Debug_MemoryInfo$getSummaryNativeHeap(), this);
        }

        public int getSummaryCode() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryCode", $$robo$$android_os_Debug_MemoryInfo$getSummaryCode(), this);
        }

        public int getSummaryStack() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryStack", $$robo$$android_os_Debug_MemoryInfo$getSummaryStack(), this);
        }

        public int getSummaryGraphics() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryGraphics", $$robo$$android_os_Debug_MemoryInfo$getSummaryGraphics(), this);
        }

        public int getSummaryPrivateOther() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryPrivateOther", $$robo$$android_os_Debug_MemoryInfo$getSummaryPrivateOther(), this);
        }

        public int getSummarySystem() {
            return (int)InvokeDynamicSupport.bootstrap("getSummarySystem", $$robo$$android_os_Debug_MemoryInfo$getSummarySystem(), this);
        }

        public int getSummaryTotalPss() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryTotalPss", $$robo$$android_os_Debug_MemoryInfo$getSummaryTotalPss(), this);
        }

        public int getSummaryTotalSwap() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryTotalSwap", $$robo$$android_os_Debug_MemoryInfo$getSummaryTotalSwap(), this);
        }

        public int getSummaryTotalSwapPss() {
            return (int)InvokeDynamicSupport.bootstrap("getSummaryTotalSwapPss", $$robo$$android_os_Debug_MemoryInfo$getSummaryTotalSwapPss(), this);
        }

        public boolean hasSwappedOutPss() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSwappedOutPss", $$robo$$android_os_Debug_MemoryInfo$hasSwappedOutPss(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_Debug_MemoryInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_Debug_MemoryInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_os_Debug_MemoryInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_Debug_MemoryInfo$__constructor__(parcel);
        }

        public MemoryInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_os_Debug_MemoryInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ MemoryInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo$__constructor__(android.os.Parcel android.os.Debug$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(MemoryInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

