/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BinderProxy;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.StrictMode;
import android.os.Trace;
import android.os.TransactionTracker;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import android.util.Log;
import com.android.internal.os.BinderCallsStats;
import com.android.internal.os.BinderInternal;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FunctionalUtils;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import libcore.io.IoUtils;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Binder
implements IBinder,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean FIND_POTENTIAL_LEAKS = false;
    public static boolean CHECK_PARCEL_SIZE = false;
    static String TAG = "Binder";
    public static boolean LOG_RUNTIME_EXCEPTION;
    private static volatile String sDumpDisabled;
    private static volatile TransactionTracker sTransactionTracker;
    private static int NATIVE_ALLOCATION_SIZE = 500;
    private static volatile boolean sTracingEnabled;
    static volatile boolean sWarnOnBlocking;
    private long mObject;
    private IInterface mOwner;
    private String mDescriptor;

    private static final long $$robo$$android_os_Binder$getNativeFinalizer() {
        return 0L;
    }

    private static final void $$robo$$android_os_Binder$enableTracing() {
        sTracingEnabled = true;
    }

    private static final void $$robo$$android_os_Binder$disableTracing() {
        sTracingEnabled = false;
    }

    private static final boolean $$robo$$android_os_Binder$isTracingEnabled() {
        return sTracingEnabled;
    }

    private static final synchronized TransactionTracker $$robo$$android_os_Binder$getTransactionTracker() {
        if (sTransactionTracker == null) {
            sTransactionTracker = new TransactionTracker();
        }
        return sTransactionTracker;
    }

    private static final void $$robo$$android_os_Binder$setWarnOnBlocking(boolean warnOnBlocking) {
        sWarnOnBlocking = warnOnBlocking;
    }

    private static final IBinder $$robo$$android_os_Binder$allowBlocking(IBinder binder) {
        try {
            if (binder instanceof BinderProxy) {
                ((BinderProxy)binder).mWarnOnBlocking = false;
            } else if (binder != null && binder.getInterfaceDescriptor() != null && binder.queryLocalInterface(binder.getInterfaceDescriptor()) == null) {
                Log.w("Binder", "Unable to allow blocking on interface " + binder);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return binder;
    }

    private static final IBinder $$robo$$android_os_Binder$defaultBlocking(IBinder binder) {
        if (binder instanceof BinderProxy) {
            ((BinderProxy)binder).mWarnOnBlocking = sWarnOnBlocking;
        }
        return binder;
    }

    private static final void $$robo$$android_os_Binder$copyAllowBlocking(IBinder fromBinder, IBinder toBinder) {
        if (fromBinder instanceof BinderProxy && toBinder instanceof BinderProxy) {
            ((BinderProxy)toBinder).mWarnOnBlocking = ((BinderProxy)fromBinder).mWarnOnBlocking;
        }
    }

    private static final int $$robo$$android_os_Binder$getCallingPid() {
        return 0;
    }

    private static final int $$robo$$android_os_Binder$getCallingUid() {
        return 0;
    }

    private static final UserHandle $$robo$$android_os_Binder$getCallingUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Binder.getCallingUid()));
    }

    private static final long $$robo$$android_os_Binder$clearCallingIdentity() {
        return 0L;
    }

    private static final void $$robo$$android_os_Binder$restoreCallingIdentity(long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_Binder$withCleanCallingIdentity(FunctionalUtils.ThrowingRunnable action) {
        long callingIdentity = Binder.clearCallingIdentity();
        Throwable throwableToPropagate = null;
        try {
            action.runOrThrow();
        }
        catch (Throwable throwable) {
            throwableToPropagate = throwable;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
            if (throwableToPropagate != null) {
                throw ExceptionUtils.propagate(throwableToPropagate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T $$robo$$android_os_Binder$withCleanCallingIdentity(FunctionalUtils.ThrowingSupplier<T> action) {
        long callingIdentity = Binder.clearCallingIdentity();
        Throwable throwableToPropagate = null;
        try {
            T t = action.getOrThrow();
            return t;
        }
        catch (Throwable throwable) {
            throwableToPropagate = throwable;
            T t = null;
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
            if (throwableToPropagate != null) {
                throw ExceptionUtils.propagate(throwableToPropagate);
            }
        }
    }

    private static final void $$robo$$android_os_Binder$setThreadStrictModePolicy(int n) {
    }

    private static final int $$robo$$android_os_Binder$getThreadStrictModePolicy() {
        return 0;
    }

    private static final void $$robo$$android_os_Binder$flushPendingCommands() {
    }

    private static final void $$robo$$android_os_Binder$joinThreadPool() {
        BinderInternal.joinThreadPool();
    }

    private static final boolean $$robo$$android_os_Binder$isProxy(IInterface iface) {
        return iface.asBinder() != iface;
    }

    private static final void $$robo$$android_os_Binder$blockUntilThreadAvailable() {
    }

    private void $$robo$$android_os_Binder$__constructor__() {
        this.mObject = Binder.getNativeBBinderHolder();
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mObject);
    }

    private final void $$robo$$android_os_Binder$attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    private final String $$robo$$android_os_Binder$getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    private final boolean $$robo$$android_os_Binder$pingBinder() {
        return true;
    }

    private final boolean $$robo$$android_os_Binder$isBinderAlive() {
        return true;
    }

    private final IInterface $$robo$$android_os_Binder$queryLocalInterface(String descriptor) {
        if (this.mDescriptor != null && this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    private static final void $$robo$$android_os_Binder$setDumpDisabled(String msg) {
        sDumpDisabled = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_Binder$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1598968902) {
            reply.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (code == 1598311760) {
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                }
                finally {
                    IoUtils.closeQuietly(fd);
                }
            }
            if (reply != null) {
                reply.writeNoException();
            } else {
                StrictMode.clearGatheredViolations();
            }
            return true;
        }
        if (code == 1598246212) {
            ParcelFileDescriptor in = data.readFileDescriptor();
            ParcelFileDescriptor out = data.readFileDescriptor();
            ParcelFileDescriptor err = data.readFileDescriptor();
            String[] args = data.readStringArray();
            ShellCallback shellCallback = ShellCallback.CREATOR.createFromParcel(data);
            ResultReceiver resultReceiver = ResultReceiver.CREATOR.createFromParcel(data);
            try {
                if (out != null) {
                    this.shellCommand(in != null ? in.getFileDescriptor() : null, out.getFileDescriptor(), err != null ? err.getFileDescriptor() : out.getFileDescriptor(), args, shellCallback, resultReceiver);
                }
            }
            finally {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                IoUtils.closeQuietly(err);
                if (reply != null) {
                    reply.writeNoException();
                } else {
                    StrictMode.clearGatheredViolations();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_Binder$dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            this.doDump(fd, pw, args);
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    private final void $$robo$$android_os_Binder$doDump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String disabled = sDumpDisabled;
        if (disabled == null) {
            try {
                this.dump(fd, pw, args);
            }
            catch (SecurityException e) {
                pw.println("Security exception: " + e.getMessage());
                throw e;
            }
            catch (Throwable e) {
                pw.println();
                pw.println("Exception occurred while dumping:");
                e.printStackTrace(pw);
            }
        } else {
            pw.println(sDumpDisabled);
        }
    }

    private final void $$robo$$android_os_Binder$dumpAsync(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        ShadowedObject thr = new ShadowedObject(this, "Binder.dumpAsync", fd, pw, args){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ FileDescriptor val$fd;
            /* synthetic */ PrintWriter val$pw;
            /* synthetic */ String[] val$args;
            /* synthetic */ Binder this$0;

            private void $$robo$$android_os_Binder_1$__constructor__(Binder this$0, String x0, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
                this.this$0 = this$0;
                this.val$fd = fileDescriptor;
                this.val$pw = printWriter;
                this.val$args = stringArray;
            }

            private final void $$robo$$android_os_Binder_1$run() {
                try {
                    this.this$0.dump(this.val$fd, this.val$pw, this.val$args);
                }
                finally {
                    this.val$pw.flush();
                }
            }

            private void __constructor__(Binder binder, String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
                this.$$robo$$android_os_Binder_1$__constructor__(binder, string2, fileDescriptor, printWriter, stringArray);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Binder_1$__constructor__(android.os.Binder java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, binder, string2, fileDescriptor, printWriter, stringArray);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_Binder_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        thr.start();
    }

    private final void $$robo$$android_os_Binder$dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    private final void $$robo$$android_os_Binder$shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        this.onShellCommand(in, out, err, args, callback, resultReceiver);
    }

    private final void $$robo$$android_os_Binder$onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        FileOutputStream fout = new FileOutputStream(err != null ? err : out);
        FastPrintWriter pw = new FastPrintWriter(fout);
        pw.println("No shell command implementation.");
        ((PrintWriter)pw).flush();
        resultReceiver.send(0, null);
    }

    private final boolean $$robo$$android_os_Binder$transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    private final void $$robo$$android_os_Binder$linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    private final boolean $$robo$$android_os_Binder$unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    private static final void $$robo$$android_os_Binder$checkParcel(IBinder obj, int code, Parcel parcel, String msg) {
    }

    private static final long $$robo$$android_os_Binder$getNativeBBinderHolder() {
        return 0L;
    }

    private static final long $$robo$$android_os_Binder$getFinalizer() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_Binder$execTransact(int code, long dataObj, long replyObj, int flags) {
        boolean res;
        BinderCallsStats binderCallsStats = BinderCallsStats.getInstance();
        BinderCallsStats.CallSession callSession = binderCallsStats.callStarted(this, code);
        Parcel data = Parcel.obtain(dataObj);
        Parcel reply = Parcel.obtain(replyObj);
        boolean tracingEnabled = Binder.isTracingEnabled();
        try {
            if (tracingEnabled) {
                Trace.traceBegin(1L, this.getClass().getName() + ":" + code);
            }
            res = this.onTransact(code, data, reply, flags);
        }
        catch (RemoteException | RuntimeException e) {
            if (LOG_RUNTIME_EXCEPTION) {
                Log.w("Binder", "Caught a RuntimeException from the binder stub implementation.", e);
            }
            if ((flags & 1) != 0) {
                if (e instanceof RemoteException) {
                    Log.w("Binder", "Binder call failed.", e);
                } else {
                    Log.w("Binder", "Caught a RuntimeException from the binder stub implementation.", e);
                }
            } else {
                reply.setDataPosition(0);
                reply.writeException(e);
            }
            res = true;
        }
        finally {
            if (tracingEnabled) {
                Trace.traceEnd(1L);
            }
        }
        Binder.checkParcel(this, code, reply, "Unreasonably large binder reply buffer");
        reply.recycle();
        data.recycle();
        StrictMode.clearGatheredViolations();
        binderCallsStats.callEnded(callSession);
        return res;
    }

    static void __staticInitializer__() {
        LOG_RUNTIME_EXCEPTION = false;
        sDumpDisabled = null;
        sTransactionTracker = null;
        sTracingEnabled = false;
        sWarnOnBlocking = false;
    }

    private static long getNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeFinalizer", $$robo$$android_os_Binder$getNativeFinalizer());
    }

    public static void enableTracing() {
        InvokeDynamicSupport.bootstrapStatic("enableTracing", $$robo$$android_os_Binder$enableTracing());
    }

    public static void disableTracing() {
        InvokeDynamicSupport.bootstrapStatic("disableTracing", $$robo$$android_os_Binder$disableTracing());
    }

    public static boolean isTracingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTracingEnabled", $$robo$$android_os_Binder$isTracingEnabled());
    }

    public static synchronized TransactionTracker getTransactionTracker() {
        return InvokeDynamicSupport.bootstrapStatic("getTransactionTracker", $$robo$$android_os_Binder$getTransactionTracker());
    }

    public static void setWarnOnBlocking(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setWarnOnBlocking", $$robo$$android_os_Binder$setWarnOnBlocking(boolean ), (boolean)bl);
    }

    public static IBinder allowBlocking(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrapStatic("allowBlocking", $$robo$$android_os_Binder$allowBlocking(android.os.IBinder ), (IBinder)iBinder);
    }

    public static IBinder defaultBlocking(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrapStatic("defaultBlocking", $$robo$$android_os_Binder$defaultBlocking(android.os.IBinder ), (IBinder)iBinder);
    }

    public static void copyAllowBlocking(IBinder iBinder, IBinder iBinder2) {
        InvokeDynamicSupport.bootstrapStatic("copyAllowBlocking", $$robo$$android_os_Binder$copyAllowBlocking(android.os.IBinder android.os.IBinder ), (IBinder)iBinder, (IBinder)iBinder2);
    }

    public static int getCallingPid() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCallingPid", $$robo$$android_os_Binder$getCallingPid());
    }

    public static int getCallingUid() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCallingUid", $$robo$$android_os_Binder$getCallingUid());
    }

    public static UserHandle getCallingUserHandle() {
        return InvokeDynamicSupport.bootstrapStatic("getCallingUserHandle", $$robo$$android_os_Binder$getCallingUserHandle());
    }

    public static long clearCallingIdentity() {
        return (long)InvokeDynamicSupport.bootstrapStatic("clearCallingIdentity", $$robo$$android_os_Binder$clearCallingIdentity());
    }

    public static void restoreCallingIdentity(long l) {
        InvokeDynamicSupport.bootstrapStatic("restoreCallingIdentity", $$robo$$android_os_Binder$restoreCallingIdentity(long ), (long)l);
    }

    public static void withCleanCallingIdentity(FunctionalUtils.ThrowingRunnable throwingRunnable) {
        InvokeDynamicSupport.bootstrapStatic("withCleanCallingIdentity", $$robo$$android_os_Binder$withCleanCallingIdentity(com.android.internal.util.FunctionalUtils$ThrowingRunnable ), (FunctionalUtils.ThrowingRunnable)throwingRunnable);
    }

    public static <T> T withCleanCallingIdentity(FunctionalUtils.ThrowingSupplier<T> throwingSupplier) {
        return (T)InvokeDynamicSupport.bootstrapStatic("withCleanCallingIdentity", $$robo$$android_os_Binder$withCleanCallingIdentity(com.android.internal.util.FunctionalUtils$ThrowingSupplier<T> ), throwingSupplier);
    }

    public static void setThreadStrictModePolicy(int n) {
        InvokeDynamicSupport.bootstrapStatic("setThreadStrictModePolicy", $$robo$$android_os_Binder$setThreadStrictModePolicy(int ), (int)n);
    }

    public static int getThreadStrictModePolicy() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadStrictModePolicy", $$robo$$android_os_Binder$getThreadStrictModePolicy());
    }

    public static void flushPendingCommands() {
        InvokeDynamicSupport.bootstrapStatic("flushPendingCommands", $$robo$$android_os_Binder$flushPendingCommands());
    }

    public static void joinThreadPool() {
        InvokeDynamicSupport.bootstrapStatic("joinThreadPool", $$robo$$android_os_Binder$joinThreadPool());
    }

    public static boolean isProxy(IInterface iInterface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProxy", $$robo$$android_os_Binder$isProxy(android.os.IInterface ), (IInterface)iInterface);
    }

    public static void blockUntilThreadAvailable() {
        InvokeDynamicSupport.bootstrapStatic("blockUntilThreadAvailable", $$robo$$android_os_Binder$blockUntilThreadAvailable());
    }

    private void __constructor__() {
        this.$$robo$$android_os_Binder$__constructor__();
    }

    public Binder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Binder$__constructor__(), this);
    }

    public void attachInterface(IInterface iInterface, String string2) {
        InvokeDynamicSupport.bootstrap("attachInterface", $$robo$$android_os_Binder$attachInterface(android.os.IInterface java.lang.String ), this, iInterface, string2);
    }

    @Override
    public String getInterfaceDescriptor() {
        return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_os_Binder$getInterfaceDescriptor(), this);
    }

    @Override
    public boolean pingBinder() {
        return (boolean)InvokeDynamicSupport.bootstrap("pingBinder", $$robo$$android_os_Binder$pingBinder(), this);
    }

    @Override
    public boolean isBinderAlive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBinderAlive", $$robo$$android_os_Binder$isBinderAlive(), this);
    }

    @Override
    public IInterface queryLocalInterface(String string2) {
        return InvokeDynamicSupport.bootstrap("queryLocalInterface", $$robo$$android_os_Binder$queryLocalInterface(java.lang.String ), this, string2);
    }

    public static void setDumpDisabled(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDumpDisabled", $$robo$$android_os_Binder$setDumpDisabled(java.lang.String ), (String)string2);
    }

    protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_os_Binder$onTransact(int android.os.Parcel android.os.Parcel int ), this, n, parcel, parcel2, n2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_Binder$dump(java.io.FileDescriptor java.lang.String[] ), this, fileDescriptor, stringArray);
    }

    void doDump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("doDump", $$robo$$android_os_Binder$doDump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public void dumpAsync(FileDescriptor fileDescriptor, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dumpAsync", $$robo$$android_os_Binder$dumpAsync(java.io.FileDescriptor java.lang.String[] ), this, fileDescriptor, stringArray);
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_Binder$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public void shellCommand(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, FileDescriptor fileDescriptor3, String[] stringArray, ShellCallback shellCallback, ResultReceiver resultReceiver) throws RemoteException {
        InvokeDynamicSupport.bootstrap("shellCommand", $$robo$$android_os_Binder$shellCommand(java.io.FileDescriptor java.io.FileDescriptor java.io.FileDescriptor java.lang.String[] android.os.ShellCallback android.os.ResultReceiver ), this, fileDescriptor, fileDescriptor2, fileDescriptor3, stringArray, shellCallback, resultReceiver);
    }

    public void onShellCommand(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, FileDescriptor fileDescriptor3, String[] stringArray, ShellCallback shellCallback, ResultReceiver resultReceiver) throws RemoteException {
        InvokeDynamicSupport.bootstrap("onShellCommand", $$robo$$android_os_Binder$onShellCommand(java.io.FileDescriptor java.io.FileDescriptor java.io.FileDescriptor java.lang.String[] android.os.ShellCallback android.os.ResultReceiver ), this, fileDescriptor, fileDescriptor2, fileDescriptor3, stringArray, shellCallback, resultReceiver);
    }

    @Override
    public boolean transact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrap("transact", $$robo$$android_os_Binder$transact(int android.os.Parcel android.os.Parcel int ), this, n, parcel, parcel2, n2);
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        InvokeDynamicSupport.bootstrap("linkToDeath", $$robo$$android_os_Binder$linkToDeath(android.os.IBinder$DeathRecipient int ), this, deathRecipient, n);
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("unlinkToDeath", $$robo$$android_os_Binder$unlinkToDeath(android.os.IBinder$DeathRecipient int ), this, deathRecipient, n);
    }

    static void checkParcel(IBinder iBinder, int n, Parcel parcel, String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkParcel", $$robo$$android_os_Binder$checkParcel(android.os.IBinder int android.os.Parcel java.lang.String ), (IBinder)iBinder, (int)n, (Parcel)parcel, (String)string2);
    }

    private static long getNativeBBinderHolder() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeBBinderHolder", $$robo$$android_os_Binder$getNativeBBinderHolder());
    }

    private static long getFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFinalizer", $$robo$$android_os_Binder$getFinalizer());
    }

    private boolean execTransact(int n, long l, long l2, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("execTransact", $$robo$$android_os_Binder$execTransact(int long long int ), this, n, l, l2, n2);
    }

    static {
        RobolectricInternals.classInitializing(Binder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Binder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NoImagePreloadHolder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static NativeAllocationRegistry sRegistry;

        private void $$robo$$android_os_Binder_NoImagePreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            sRegistry = new NativeAllocationRegistry(Binder.class.getClassLoader(), Binder.getNativeFinalizer(), 500L);
        }

        private void __constructor__() {
            this.$$robo$$android_os_Binder_NoImagePreloadHolder$__constructor__();
        }

        public NoImagePreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Binder_NoImagePreloadHolder$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NoImagePreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoImagePreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

