/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pDevice
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiP2pDevice";
    public String deviceName;
    public String deviceAddress;
    public String primaryDeviceType;
    public String secondaryDeviceType;
    private static int WPS_CONFIG_DISPLAY = 8;
    private static int WPS_CONFIG_PUSHBUTTON = 128;
    private static int WPS_CONFIG_KEYPAD = 256;
    private static int DEVICE_CAPAB_SERVICE_DISCOVERY = 1;
    private static int DEVICE_CAPAB_CLIENT_DISCOVERABILITY = 2;
    private static int DEVICE_CAPAB_CONCURRENT_OPER = 4;
    private static int DEVICE_CAPAB_INFRA_MANAGED = 8;
    private static int DEVICE_CAPAB_DEVICE_LIMIT = 16;
    private static int DEVICE_CAPAB_INVITATION_PROCEDURE = 32;
    private static int GROUP_CAPAB_GROUP_OWNER = 1;
    private static int GROUP_CAPAB_PERSISTENT_GROUP = 2;
    private static int GROUP_CAPAB_GROUP_LIMIT = 4;
    private static int GROUP_CAPAB_INTRA_BSS_DIST = 8;
    private static int GROUP_CAPAB_CROSS_CONN = 16;
    private static int GROUP_CAPAB_PERSISTENT_RECONN = 32;
    private static int GROUP_CAPAB_GROUP_FORMATION = 64;
    public int wpsConfigMethodsSupported;
    public int deviceCapability;
    public int groupCapability;
    public static int CONNECTED = 0;
    public static int INVITED = 1;
    public static int FAILED = 2;
    public static int AVAILABLE = 3;
    public static int UNAVAILABLE = 4;
    public int status;
    public WifiP2pWfdInfo wfdInfo;
    private static Pattern detailedDevicePattern;
    private static Pattern twoTokenPattern;
    private static Pattern threeTokenPattern;
    public static Parcelable.Creator<WifiP2pDevice> CREATOR;

    private void $$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__() {
        this.deviceName = "";
        this.deviceAddress = "";
        this.status = 4;
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(String string2) throws IllegalArgumentException {
        this.deviceName = "";
        this.deviceAddress = "";
        this.status = 4;
        String[] tokens = string2.split("[ \n]");
        if (tokens.length < 1) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        switch (tokens.length) {
            case 1: {
                this.deviceAddress = string2;
                return;
            }
            case 2: {
                Matcher match = twoTokenPattern.matcher(string2);
                if (!match.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = match.group(2);
                return;
            }
            case 3: {
                Matcher match = threeTokenPattern.matcher(string2);
                if (!match.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = match.group(1);
                return;
            }
        }
        Matcher match = detailedDevicePattern.matcher(string2);
        if (!match.find()) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        this.deviceAddress = match.group(3);
        this.primaryDeviceType = match.group(4);
        this.deviceName = match.group(5);
        this.wpsConfigMethodsSupported = this.parseHex(match.group(6));
        this.deviceCapability = this.parseHex(match.group(7));
        this.groupCapability = this.parseHex(match.group(8));
        if (match.group(9) != null) {
            String str = match.group(10);
            this.wfdInfo = new WifiP2pWfdInfo(this.parseHex(str.substring(0, 4)), this.parseHex(str.substring(4, 8)), this.parseHex(str.substring(8, 12)));
        }
        if (tokens[0].startsWith("P2P-DEVICE-FOUND")) {
            this.status = 3;
        }
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$wpsPbcSupported() {
        return (this.wpsConfigMethodsSupported & 0x80) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$wpsKeypadSupported() {
        return (this.wpsConfigMethodsSupported & 0x100) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$wpsDisplaySupported() {
        return (this.wpsConfigMethodsSupported & 8) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$isServiceDiscoveryCapable() {
        return (this.deviceCapability & 1) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$isInvitationCapable() {
        return (this.deviceCapability & 0x20) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$isDeviceLimit() {
        return (this.deviceCapability & 0x10) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$isGroupOwner() {
        return (this.groupCapability & 1) != 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$isGroupLimit() {
        return (this.groupCapability & 4) != 0;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDevice$update(WifiP2pDevice device) {
        this.updateSupplicantDetails(device);
        this.status = device.status;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDevice$updateSupplicantDetails(WifiP2pDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("device is null");
        }
        if (device.deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress is null");
        }
        if (!this.deviceAddress.equals(device.deviceAddress)) {
            throw new IllegalArgumentException("deviceAddress does not match");
        }
        this.deviceName = device.deviceName;
        this.primaryDeviceType = device.primaryDeviceType;
        this.secondaryDeviceType = device.secondaryDeviceType;
        this.wpsConfigMethodsSupported = device.wpsConfigMethodsSupported;
        this.deviceCapability = device.deviceCapability;
        this.groupCapability = device.groupCapability;
        this.wfdInfo = device.wfdInfo;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDevice$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiP2pDevice)) {
            return false;
        }
        WifiP2pDevice other = (WifiP2pDevice)obj;
        if (other == null || other.deviceAddress == null) {
            return this.deviceAddress == null;
        }
        return other.deviceAddress.equals(this.deviceAddress);
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pDevice$toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Device: ").append(this.deviceName);
        sbuf.append("\n deviceAddress: ").append(this.deviceAddress);
        sbuf.append("\n primary type: ").append(this.primaryDeviceType);
        sbuf.append("\n secondary type: ").append(this.secondaryDeviceType);
        sbuf.append("\n wps: ").append(this.wpsConfigMethodsSupported);
        sbuf.append("\n grpcapab: ").append(this.groupCapability);
        sbuf.append("\n devcapab: ").append(this.deviceCapability);
        sbuf.append("\n status: ").append(this.status);
        sbuf.append("\n wfdInfo: ").append(this.wfdInfo);
        return sbuf.toString();
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pDevice$describeContents() {
        return 0;
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(WifiP2pDevice source) {
        this.deviceName = "";
        this.deviceAddress = "";
        this.status = 4;
        if (source != null) {
            this.deviceName = source.deviceName;
            this.deviceAddress = source.deviceAddress;
            this.primaryDeviceType = source.primaryDeviceType;
            this.secondaryDeviceType = source.secondaryDeviceType;
            this.wpsConfigMethodsSupported = source.wpsConfigMethodsSupported;
            this.deviceCapability = source.deviceCapability;
            this.groupCapability = source.groupCapability;
            this.status = source.status;
            this.wfdInfo = new WifiP2pWfdInfo(source.wfdInfo);
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDevice$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceName);
        dest.writeString(this.deviceAddress);
        dest.writeString(this.primaryDeviceType);
        dest.writeString(this.secondaryDeviceType);
        dest.writeInt(this.wpsConfigMethodsSupported);
        dest.writeInt(this.deviceCapability);
        dest.writeInt(this.groupCapability);
        dest.writeInt(this.status);
        if (this.wfdInfo != null) {
            dest.writeInt(1);
            this.wfdInfo.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pDevice$parseHex(String hexString) {
        int num = 0;
        if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
            hexString = hexString.substring(2);
        }
        try {
            num = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException e) {
            Log.e("WifiP2pDevice", "Failed to parse hex string " + hexString);
        }
        return num;
    }

    static void __staticInitializer__() {
        detailedDevicePattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) (\\d+ )?p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) pri_dev_type=(\\d+-[0-9a-fA-F]+-\\d+) name='(.*)' config_methods=(0x[0-9a-fA-F]+) dev_capab=(0x[0-9a-fA-F]+) group_capab=(0x[0-9a-fA-F]+)( wfd_dev_info=0x([0-9a-fA-F]{12}))?");
        twoTokenPattern = Pattern.compile("(p2p_dev_addr=)?((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
        threeTokenPattern = Pattern.compile("(?:[0-9a-f]{2}:){5}[0-9a-f]{2} p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
        CREATOR = new Parcelable.Creator<WifiP2pDevice>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_WifiP2pDevice_1$__constructor__() {
            }

            private final WifiP2pDevice $$robo$$android_net_wifi_p2p_WifiP2pDevice_1$createFromParcel(Parcel in) {
                WifiP2pDevice device = new WifiP2pDevice();
                device.deviceName = in.readString();
                device.deviceAddress = in.readString();
                device.primaryDeviceType = in.readString();
                device.secondaryDeviceType = in.readString();
                device.wpsConfigMethodsSupported = in.readInt();
                device.deviceCapability = in.readInt();
                device.groupCapability = in.readInt();
                device.status = in.readInt();
                if (in.readInt() == 1) {
                    device.wfdInfo = WifiP2pWfdInfo.CREATOR.createFromParcel(in);
                }
                return device;
            }

            private final WifiP2pDevice[] $$robo$$android_net_wifi_p2p_WifiP2pDevice_1$newArray(int size) {
                return new WifiP2pDevice[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_WifiP2pDevice_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDevice_1$__constructor__(), this);
            }

            @Override
            public WifiP2pDevice createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_WifiP2pDevice_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WifiP2pDevice[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_WifiP2pDevice_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__();
    }

    public WifiP2pDevice() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(), this);
    }

    private void __constructor__(String string2) throws IllegalArgumentException {
        this.$$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(string2);
    }

    public WifiP2pDevice(String string2) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(java.lang.String ), this, string2);
    }

    public boolean wpsPbcSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("wpsPbcSupported", $$robo$$android_net_wifi_p2p_WifiP2pDevice$wpsPbcSupported(), this);
    }

    public boolean wpsKeypadSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("wpsKeypadSupported", $$robo$$android_net_wifi_p2p_WifiP2pDevice$wpsKeypadSupported(), this);
    }

    public boolean wpsDisplaySupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("wpsDisplaySupported", $$robo$$android_net_wifi_p2p_WifiP2pDevice$wpsDisplaySupported(), this);
    }

    public boolean isServiceDiscoveryCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceDiscoveryCapable", $$robo$$android_net_wifi_p2p_WifiP2pDevice$isServiceDiscoveryCapable(), this);
    }

    public boolean isInvitationCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInvitationCapable", $$robo$$android_net_wifi_p2p_WifiP2pDevice$isInvitationCapable(), this);
    }

    public boolean isDeviceLimit() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceLimit", $$robo$$android_net_wifi_p2p_WifiP2pDevice$isDeviceLimit(), this);
    }

    public boolean isGroupOwner() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupOwner", $$robo$$android_net_wifi_p2p_WifiP2pDevice$isGroupOwner(), this);
    }

    public boolean isGroupLimit() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupLimit", $$robo$$android_net_wifi_p2p_WifiP2pDevice$isGroupLimit(), this);
    }

    public void update(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_net_wifi_p2p_WifiP2pDevice$update(android.net.wifi.p2p.WifiP2pDevice ), this, wifiP2pDevice);
    }

    public void updateSupplicantDetails(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("updateSupplicantDetails", $$robo$$android_net_wifi_p2p_WifiP2pDevice$updateSupplicantDetails(android.net.wifi.p2p.WifiP2pDevice ), this, wifiP2pDevice);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_p2p_WifiP2pDevice$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_WifiP2pDevice$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_WifiP2pDevice$describeContents(), this);
    }

    private void __constructor__(WifiP2pDevice wifiP2pDevice) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(wifiP2pDevice);
    }

    public WifiP2pDevice(WifiP2pDevice wifiP2pDevice) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDevice$__constructor__(android.net.wifi.p2p.WifiP2pDevice ), this, wifiP2pDevice);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_WifiP2pDevice$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private int parseHex(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("parseHex", $$robo$$android_net_wifi_p2p_WifiP2pDevice$parseHex(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pDevice.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

