/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2;

import android.net.wifi.hotspot2.pps.Credential;
import android.net.wifi.hotspot2.pps.HomeSp;
import android.net.wifi.hotspot2.pps.Policy;
import android.net.wifi.hotspot2.pps.UpdateParameter;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PasspointConfiguration
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "PasspointConfiguration";
    private static int CERTIFICATE_SHA256_BYTES = 32;
    private static int MAX_URL_BYTES = 1023;
    private static int NULL_VALUE = -1;
    private HomeSp mHomeSp;
    private Credential mCredential;
    private Policy mPolicy;
    private UpdateParameter mSubscriptionUpdate;
    private Map<String, byte[]> mTrustRootCertList;
    private int mUpdateIdentifier;
    private int mCredentialPriority;
    private long mSubscriptionCreationTimeInMillis;
    private long mSubscriptionExpirationTimeInMillis;
    private String mSubscriptionType;
    private long mUsageLimitUsageTimePeriodInMinutes;
    private long mUsageLimitStartTimeInMillis;
    private long mUsageLimitDataLimit;
    private long mUsageLimitTimeLimitInMinutes;
    public static Parcelable.Creator<PasspointConfiguration> CREATOR;

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setHomeSp(HomeSp homeSp) {
        this.mHomeSp = homeSp;
    }

    private final HomeSp $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getHomeSp() {
        return this.mHomeSp;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setCredential(Credential credential) {
        this.mCredential = credential;
    }

    private final Credential $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getCredential() {
        return this.mCredential;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setPolicy(Policy policy) {
        this.mPolicy = policy;
    }

    private final Policy $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getPolicy() {
        return this.mPolicy;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionUpdate(UpdateParameter subscriptionUpdate) {
        this.mSubscriptionUpdate = subscriptionUpdate;
    }

    private final UpdateParameter $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionUpdate() {
        return this.mSubscriptionUpdate;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setTrustRootCertList(Map<String, byte[]> trustRootCertList) {
        this.mTrustRootCertList = trustRootCertList;
    }

    private final Map<String, byte[]> $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getTrustRootCertList() {
        return this.mTrustRootCertList;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUpdateIdentifier(int updateIdentifier) {
        this.mUpdateIdentifier = updateIdentifier;
    }

    private final int $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUpdateIdentifier() {
        return this.mUpdateIdentifier;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setCredentialPriority(int credentialPriority) {
        this.mCredentialPriority = credentialPriority;
    }

    private final int $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getCredentialPriority() {
        return this.mCredentialPriority;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionCreationTimeInMillis(long subscriptionCreationTimeInMillis) {
        this.mSubscriptionCreationTimeInMillis = subscriptionCreationTimeInMillis;
    }

    private final long $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionCreationTimeInMillis() {
        return this.mSubscriptionCreationTimeInMillis;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionExpirationTimeInMillis(long subscriptionExpirationTimeInMillis) {
        this.mSubscriptionExpirationTimeInMillis = subscriptionExpirationTimeInMillis;
    }

    private final long $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionExpirationTimeInMillis() {
        return this.mSubscriptionExpirationTimeInMillis;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionType(String subscriptionType) {
        this.mSubscriptionType = subscriptionType;
    }

    private final String $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionType() {
        return this.mSubscriptionType;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitUsageTimePeriodInMinutes(long usageLimitUsageTimePeriodInMinutes) {
        this.mUsageLimitUsageTimePeriodInMinutes = usageLimitUsageTimePeriodInMinutes;
    }

    private final long $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitUsageTimePeriodInMinutes() {
        return this.mUsageLimitUsageTimePeriodInMinutes;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitStartTimeInMillis(long usageLimitStartTimeInMillis) {
        this.mUsageLimitStartTimeInMillis = usageLimitStartTimeInMillis;
    }

    private final long $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitStartTimeInMillis() {
        return this.mUsageLimitStartTimeInMillis;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitDataLimit(long usageLimitDataLimit) {
        this.mUsageLimitDataLimit = usageLimitDataLimit;
    }

    private final long $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitDataLimit() {
        return this.mUsageLimitDataLimit;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitTimeLimitInMinutes(long usageLimitTimeLimitInMinutes) {
        this.mUsageLimitTimeLimitInMinutes = usageLimitTimeLimitInMinutes;
    }

    private final long $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitTimeLimitInMinutes() {
        return this.mUsageLimitTimeLimitInMinutes;
    }

    private void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$__constructor__() {
        this.mHomeSp = null;
        this.mCredential = null;
        this.mPolicy = null;
        this.mSubscriptionUpdate = null;
        this.mTrustRootCertList = null;
        this.mUpdateIdentifier = Integer.MIN_VALUE;
        this.mCredentialPriority = Integer.MIN_VALUE;
        this.mSubscriptionCreationTimeInMillis = Long.MIN_VALUE;
        this.mSubscriptionExpirationTimeInMillis = Long.MIN_VALUE;
        this.mSubscriptionType = null;
        this.mUsageLimitUsageTimePeriodInMinutes = Long.MIN_VALUE;
        this.mUsageLimitStartTimeInMillis = Long.MIN_VALUE;
        this.mUsageLimitDataLimit = Long.MIN_VALUE;
        this.mUsageLimitTimeLimitInMinutes = Long.MIN_VALUE;
    }

    private void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$__constructor__(PasspointConfiguration source) {
        this.mHomeSp = null;
        this.mCredential = null;
        this.mPolicy = null;
        this.mSubscriptionUpdate = null;
        this.mTrustRootCertList = null;
        this.mUpdateIdentifier = Integer.MIN_VALUE;
        this.mCredentialPriority = Integer.MIN_VALUE;
        this.mSubscriptionCreationTimeInMillis = Long.MIN_VALUE;
        this.mSubscriptionExpirationTimeInMillis = Long.MIN_VALUE;
        this.mSubscriptionType = null;
        this.mUsageLimitUsageTimePeriodInMinutes = Long.MIN_VALUE;
        this.mUsageLimitStartTimeInMillis = Long.MIN_VALUE;
        this.mUsageLimitDataLimit = Long.MIN_VALUE;
        this.mUsageLimitTimeLimitInMinutes = Long.MIN_VALUE;
        if (source == null) {
            return;
        }
        if (source.mHomeSp != null) {
            this.mHomeSp = new HomeSp(source.mHomeSp);
        }
        if (source.mCredential != null) {
            this.mCredential = new Credential(source.mCredential);
        }
        if (source.mPolicy != null) {
            this.mPolicy = new Policy(source.mPolicy);
        }
        if (source.mTrustRootCertList != null) {
            this.mTrustRootCertList = Collections.unmodifiableMap(source.mTrustRootCertList);
        }
        if (source.mSubscriptionUpdate != null) {
            this.mSubscriptionUpdate = new UpdateParameter(source.mSubscriptionUpdate);
        }
        this.mUpdateIdentifier = source.mUpdateIdentifier;
        this.mCredentialPriority = source.mCredentialPriority;
        this.mSubscriptionCreationTimeInMillis = source.mSubscriptionCreationTimeInMillis;
        this.mSubscriptionExpirationTimeInMillis = source.mSubscriptionExpirationTimeInMillis;
        this.mSubscriptionType = source.mSubscriptionType;
        this.mUsageLimitDataLimit = source.mUsageLimitDataLimit;
        this.mUsageLimitStartTimeInMillis = source.mUsageLimitStartTimeInMillis;
        this.mUsageLimitTimeLimitInMinutes = source.mUsageLimitTimeLimitInMinutes;
        this.mUsageLimitUsageTimePeriodInMinutes = source.mUsageLimitUsageTimePeriodInMinutes;
    }

    private final int $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mHomeSp, flags);
        dest.writeParcelable(this.mCredential, flags);
        dest.writeParcelable(this.mPolicy, flags);
        dest.writeParcelable(this.mSubscriptionUpdate, flags);
        PasspointConfiguration.writeTrustRootCerts(dest, this.mTrustRootCertList);
        dest.writeInt(this.mUpdateIdentifier);
        dest.writeInt(this.mCredentialPriority);
        dest.writeLong(this.mSubscriptionCreationTimeInMillis);
        dest.writeLong(this.mSubscriptionExpirationTimeInMillis);
        dest.writeString(this.mSubscriptionType);
        dest.writeLong(this.mUsageLimitUsageTimePeriodInMinutes);
        dest.writeLong(this.mUsageLimitStartTimeInMillis);
        dest.writeLong(this.mUsageLimitDataLimit);
        dest.writeLong(this.mUsageLimitTimeLimitInMinutes);
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof PasspointConfiguration)) {
            return false;
        }
        PasspointConfiguration that = (PasspointConfiguration)thatObject;
        return (this.mHomeSp == null ? that.mHomeSp == null : this.mHomeSp.equals(that.mHomeSp)) && (this.mCredential == null ? that.mCredential == null : this.mCredential.equals(that.mCredential)) && (this.mPolicy == null ? that.mPolicy == null : this.mPolicy.equals(that.mPolicy)) && (this.mSubscriptionUpdate == null ? that.mSubscriptionUpdate == null : this.mSubscriptionUpdate.equals(that.mSubscriptionUpdate)) && PasspointConfiguration.isTrustRootCertListEquals(this.mTrustRootCertList, that.mTrustRootCertList) && this.mUpdateIdentifier == that.mUpdateIdentifier && this.mCredentialPriority == that.mCredentialPriority && this.mSubscriptionCreationTimeInMillis == that.mSubscriptionCreationTimeInMillis && this.mSubscriptionExpirationTimeInMillis == that.mSubscriptionExpirationTimeInMillis && TextUtils.equals(this.mSubscriptionType, that.mSubscriptionType) && this.mUsageLimitUsageTimePeriodInMinutes == that.mUsageLimitUsageTimePeriodInMinutes && this.mUsageLimitStartTimeInMillis == that.mUsageLimitStartTimeInMillis && this.mUsageLimitDataLimit == that.mUsageLimitDataLimit && this.mUsageLimitTimeLimitInMinutes == that.mUsageLimitTimeLimitInMinutes;
    }

    private final int $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$hashCode() {
        return Objects.hash(this.mHomeSp, this.mCredential, this.mPolicy, this.mSubscriptionUpdate, this.mTrustRootCertList, this.mUpdateIdentifier, this.mCredentialPriority, this.mSubscriptionCreationTimeInMillis, this.mSubscriptionExpirationTimeInMillis, this.mUsageLimitUsageTimePeriodInMinutes, this.mUsageLimitStartTimeInMillis, this.mUsageLimitDataLimit, this.mUsageLimitTimeLimitInMinutes);
    }

    private final String $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateIdentifier: ").append(this.mUpdateIdentifier).append("\n");
        builder.append("CredentialPriority: ").append(this.mCredentialPriority).append("\n");
        builder.append("SubscriptionCreationTime: ").append(this.mSubscriptionCreationTimeInMillis != Long.MIN_VALUE ? new Date(this.mSubscriptionCreationTimeInMillis) : "Not specified").append("\n");
        builder.append("SubscriptionExpirationTime: ").append(this.mSubscriptionExpirationTimeInMillis != Long.MIN_VALUE ? new Date(this.mSubscriptionExpirationTimeInMillis) : "Not specified").append("\n");
        builder.append("UsageLimitStartTime: ").append(this.mUsageLimitStartTimeInMillis != Long.MIN_VALUE ? new Date(this.mUsageLimitStartTimeInMillis) : "Not specified").append("\n");
        builder.append("UsageTimePeriod: ").append(this.mUsageLimitUsageTimePeriodInMinutes).append("\n");
        builder.append("UsageLimitDataLimit: ").append(this.mUsageLimitDataLimit).append("\n");
        builder.append("UsageLimitTimeLimit: ").append(this.mUsageLimitTimeLimitInMinutes).append("\n");
        if (this.mHomeSp != null) {
            builder.append("HomeSP Begin ---\n");
            builder.append(this.mHomeSp);
            builder.append("HomeSP End ---\n");
        }
        if (this.mCredential != null) {
            builder.append("Credential Begin ---\n");
            builder.append(this.mCredential);
            builder.append("Credential End ---\n");
        }
        if (this.mPolicy != null) {
            builder.append("Policy Begin ---\n");
            builder.append(this.mPolicy);
            builder.append("Policy End ---\n");
        }
        if (this.mSubscriptionUpdate != null) {
            builder.append("SubscriptionUpdate Begin ---\n");
            builder.append(this.mSubscriptionUpdate);
            builder.append("SubscriptionUpdate End ---\n");
        }
        if (this.mTrustRootCertList != null) {
            builder.append("TrustRootCertServers: ").append(this.mTrustRootCertList.keySet()).append("\n");
        }
        return builder.toString();
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$validate() {
        if (this.mHomeSp == null || !this.mHomeSp.validate()) {
            return false;
        }
        if (this.mCredential == null || !this.mCredential.validate()) {
            return false;
        }
        if (this.mPolicy != null && !this.mPolicy.validate()) {
            return false;
        }
        if (this.mSubscriptionUpdate != null && !this.mSubscriptionUpdate.validate()) {
            return false;
        }
        if (this.mTrustRootCertList != null) {
            for (Map.Entry<String, byte[]> entry : this.mTrustRootCertList.entrySet()) {
                String url = entry.getKey();
                byte[] certFingerprint = entry.getValue();
                if (TextUtils.isEmpty(url)) {
                    Log.d("PasspointConfiguration", "Empty URL");
                    return false;
                }
                if (url.getBytes(StandardCharsets.UTF_8).length > 1023) {
                    Log.d("PasspointConfiguration", "URL bytes exceeded the max: " + url.getBytes(StandardCharsets.UTF_8).length);
                    return false;
                }
                if (certFingerprint == null) {
                    Log.d("PasspointConfiguration", "Fingerprint not specified");
                    return false;
                }
                if (certFingerprint.length == 32) continue;
                Log.d("PasspointConfiguration", "Incorrect size of trust root certificate SHA-256 fingerprint: " + certFingerprint.length);
                return false;
            }
        }
        return true;
    }

    private static final void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$writeTrustRootCerts(Parcel dest, Map<String, byte[]> trustRootCerts) {
        if (trustRootCerts == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(trustRootCerts.size());
        for (Map.Entry<String, byte[]> entry : trustRootCerts.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeByteArray(entry.getValue());
        }
    }

    private static final boolean $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$isTrustRootCertListEquals(Map<String, byte[]> list1, Map<String, byte[]> list2) {
        if (list1 == null || list2 == null) {
            return list1 == list2;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : list1.entrySet()) {
            if (Arrays.equals(entry.getValue(), list2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PasspointConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$__constructor__() {
            }

            private final PasspointConfiguration $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$createFromParcel(Parcel in) {
                PasspointConfiguration config = new PasspointConfiguration();
                config.setHomeSp((HomeSp)in.readParcelable(null));
                config.setCredential((Credential)in.readParcelable(null));
                config.setPolicy((Policy)in.readParcelable(null));
                config.setSubscriptionUpdate((UpdateParameter)in.readParcelable(null));
                config.setTrustRootCertList(this.readTrustRootCerts(in));
                config.setUpdateIdentifier(in.readInt());
                config.setCredentialPriority(in.readInt());
                config.setSubscriptionCreationTimeInMillis(in.readLong());
                config.setSubscriptionExpirationTimeInMillis(in.readLong());
                config.setSubscriptionType(in.readString());
                config.setUsageLimitUsageTimePeriodInMinutes(in.readLong());
                config.setUsageLimitStartTimeInMillis(in.readLong());
                config.setUsageLimitDataLimit(in.readLong());
                config.setUsageLimitTimeLimitInMinutes(in.readLong());
                return config;
            }

            private final PasspointConfiguration[] $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$newArray(int size) {
                return new PasspointConfiguration[size];
            }

            private final Map<String, byte[]> $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$readTrustRootCerts(Parcel in) {
                int size = in.readInt();
                if (size == -1) {
                    return null;
                }
                HashMap<String, byte[]> trustRootCerts = new HashMap<String, byte[]>(size);
                for (int i = 0; i < size; ++i) {
                    String key = in.readString();
                    byte[] value = in.createByteArray();
                    trustRootCerts.put(key, value);
                }
                return trustRootCerts;
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$__constructor__(), this);
            }

            @Override
            public PasspointConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public PasspointConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$newArray(int ), this, n);
            }

            private Map<String, byte[]> readTrustRootCerts(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readTrustRootCerts", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration_1$readTrustRootCerts(android.os.Parcel ), this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void setHomeSp(HomeSp homeSp) {
        InvokeDynamicSupport.bootstrap("setHomeSp", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setHomeSp(android.net.wifi.hotspot2.pps.HomeSp ), this, homeSp);
    }

    public HomeSp getHomeSp() {
        return InvokeDynamicSupport.bootstrap("getHomeSp", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getHomeSp(), this);
    }

    public void setCredential(Credential credential) {
        InvokeDynamicSupport.bootstrap("setCredential", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setCredential(android.net.wifi.hotspot2.pps.Credential ), this, credential);
    }

    public Credential getCredential() {
        return InvokeDynamicSupport.bootstrap("getCredential", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getCredential(), this);
    }

    public void setPolicy(Policy policy) {
        InvokeDynamicSupport.bootstrap("setPolicy", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setPolicy(android.net.wifi.hotspot2.pps.Policy ), this, policy);
    }

    public Policy getPolicy() {
        return InvokeDynamicSupport.bootstrap("getPolicy", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getPolicy(), this);
    }

    public void setSubscriptionUpdate(UpdateParameter updateParameter) {
        InvokeDynamicSupport.bootstrap("setSubscriptionUpdate", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionUpdate(android.net.wifi.hotspot2.pps.UpdateParameter ), this, updateParameter);
    }

    public UpdateParameter getSubscriptionUpdate() {
        return InvokeDynamicSupport.bootstrap("getSubscriptionUpdate", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionUpdate(), this);
    }

    public void setTrustRootCertList(Map<String, byte[]> map) {
        InvokeDynamicSupport.bootstrap("setTrustRootCertList", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setTrustRootCertList(java.util.Map<java.lang.String, byte[]> ), this, map);
    }

    public Map<String, byte[]> getTrustRootCertList() {
        return InvokeDynamicSupport.bootstrap("getTrustRootCertList", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getTrustRootCertList(), this);
    }

    public void setUpdateIdentifier(int n) {
        InvokeDynamicSupport.bootstrap("setUpdateIdentifier", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUpdateIdentifier(int ), this, n);
    }

    public int getUpdateIdentifier() {
        return (int)InvokeDynamicSupport.bootstrap("getUpdateIdentifier", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUpdateIdentifier(), this);
    }

    public void setCredentialPriority(int n) {
        InvokeDynamicSupport.bootstrap("setCredentialPriority", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setCredentialPriority(int ), this, n);
    }

    public int getCredentialPriority() {
        return (int)InvokeDynamicSupport.bootstrap("getCredentialPriority", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getCredentialPriority(), this);
    }

    public void setSubscriptionCreationTimeInMillis(long l) {
        InvokeDynamicSupport.bootstrap("setSubscriptionCreationTimeInMillis", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionCreationTimeInMillis(long ), this, l);
    }

    public long getSubscriptionCreationTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getSubscriptionCreationTimeInMillis", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionCreationTimeInMillis(), this);
    }

    public void setSubscriptionExpirationTimeInMillis(long l) {
        InvokeDynamicSupport.bootstrap("setSubscriptionExpirationTimeInMillis", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionExpirationTimeInMillis(long ), this, l);
    }

    public long getSubscriptionExpirationTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getSubscriptionExpirationTimeInMillis", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionExpirationTimeInMillis(), this);
    }

    public void setSubscriptionType(String string2) {
        InvokeDynamicSupport.bootstrap("setSubscriptionType", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setSubscriptionType(java.lang.String ), this, string2);
    }

    public String getSubscriptionType() {
        return InvokeDynamicSupport.bootstrap("getSubscriptionType", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getSubscriptionType(), this);
    }

    public void setUsageLimitUsageTimePeriodInMinutes(long l) {
        InvokeDynamicSupport.bootstrap("setUsageLimitUsageTimePeriodInMinutes", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitUsageTimePeriodInMinutes(long ), this, l);
    }

    public long getUsageLimitUsageTimePeriodInMinutes() {
        return (long)InvokeDynamicSupport.bootstrap("getUsageLimitUsageTimePeriodInMinutes", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitUsageTimePeriodInMinutes(), this);
    }

    public void setUsageLimitStartTimeInMillis(long l) {
        InvokeDynamicSupport.bootstrap("setUsageLimitStartTimeInMillis", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitStartTimeInMillis(long ), this, l);
    }

    public long getUsageLimitStartTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getUsageLimitStartTimeInMillis", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitStartTimeInMillis(), this);
    }

    public void setUsageLimitDataLimit(long l) {
        InvokeDynamicSupport.bootstrap("setUsageLimitDataLimit", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitDataLimit(long ), this, l);
    }

    public long getUsageLimitDataLimit() {
        return (long)InvokeDynamicSupport.bootstrap("getUsageLimitDataLimit", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitDataLimit(), this);
    }

    public void setUsageLimitTimeLimitInMinutes(long l) {
        InvokeDynamicSupport.bootstrap("setUsageLimitTimeLimitInMinutes", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$setUsageLimitTimeLimitInMinutes(long ), this, l);
    }

    public long getUsageLimitTimeLimitInMinutes() {
        return (long)InvokeDynamicSupport.bootstrap("getUsageLimitTimeLimitInMinutes", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$getUsageLimitTimeLimitInMinutes(), this);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_hotspot2_PasspointConfiguration$__constructor__();
    }

    public PasspointConfiguration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$__constructor__(), this);
    }

    private void __constructor__(PasspointConfiguration passpointConfiguration) {
        this.$$robo$$android_net_wifi_hotspot2_PasspointConfiguration$__constructor__(passpointConfiguration);
    }

    public PasspointConfiguration(PasspointConfiguration passpointConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$__constructor__(android.net.wifi.hotspot2.PasspointConfiguration ), this, passpointConfiguration);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$toString(), this);
    }

    public boolean validate() {
        return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$validate(), this);
    }

    private static void writeTrustRootCerts(Parcel parcel, Map<String, byte[]> map) {
        InvokeDynamicSupport.bootstrapStatic("writeTrustRootCerts", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$writeTrustRootCerts(android.os.Parcel java.util.Map<java.lang.String, byte[]> ), (Parcel)parcel, map);
    }

    private static boolean isTrustRootCertListEquals(Map<String, byte[]> map, Map<String, byte[]> map2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTrustRootCertListEquals", $$robo$$android_net_wifi_hotspot2_PasspointConfiguration$isTrustRootCertListEquals(java.util.Map<java.lang.String, byte[]> java.util.Map<java.lang.String, byte[]> ), map, map2);
    }

    static {
        RobolectricInternals.classInitializing(PasspointConfiguration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PasspointConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

