/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.SystemApi;
import android.net.NetworkSpecifier;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DiscoverySession
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "DiscoverySession";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private static int MAX_SEND_RETRY_COUNT = 5;
    protected WeakReference<WifiAwareManager> mMgr;
    protected int mClientId;
    protected int mSessionId;
    protected boolean mTerminated;
    private CloseGuard mCloseGuard;

    private static final int $$robo$$android_net_wifi_aware_DiscoverySession$getMaxSendRetryCount() {
        return 5;
    }

    private void $$robo$$android_net_wifi_aware_DiscoverySession$__constructor__(WifiAwareManager manager, int clientId, int sessionId) {
        this.mTerminated = false;
        this.mCloseGuard = CloseGuard.get();
        this.mMgr = new WeakReference<WifiAwareManager>(manager);
        this.mClientId = clientId;
        this.mSessionId = sessionId;
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_net_wifi_aware_DiscoverySession$close() {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w("DiscoverySession", "destroy: called post GC on WifiAwareManager");
            return;
        }
        mgr.terminateSession(this.mClientId, this.mSessionId);
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_net_wifi_aware_DiscoverySession$setTerminated() {
        if (this.mTerminated) {
            Log.w("DiscoverySession", "terminate: already terminated.");
            return;
        }
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_net_wifi_aware_DiscoverySession$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mTerminated) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    private final int $$robo$$android_net_wifi_aware_DiscoverySession$getClientId() {
        return this.mClientId;
    }

    @VisibleForTesting
    private final int $$robo$$android_net_wifi_aware_DiscoverySession$getSessionId() {
        return this.mSessionId;
    }

    private final void $$robo$$android_net_wifi_aware_DiscoverySession$sendMessage(PeerHandle peerHandle, int messageId, byte[] message, int retryCount) {
        if (this.mTerminated) {
            Log.w("DiscoverySession", "sendMessage: called on terminated session");
            return;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w("DiscoverySession", "sendMessage: called post GC on WifiAwareManager");
            return;
        }
        mgr.sendMessage(this.mClientId, this.mSessionId, peerHandle, message, messageId, retryCount);
    }

    private final void $$robo$$android_net_wifi_aware_DiscoverySession$sendMessage(PeerHandle peerHandle, int messageId, byte[] message) {
        this.sendMessage(peerHandle, messageId, message, 0);
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_DiscoverySession$createNetworkSpecifierOpen(PeerHandle peerHandle) {
        if (this.mTerminated) {
            Log.w("DiscoverySession", "createNetworkSpecifierOpen: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w("DiscoverySession", "createNetworkSpecifierOpen: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, null, null);
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_DiscoverySession$createNetworkSpecifierPassphrase(PeerHandle peerHandle, String passphrase) {
        if (!WifiAwareUtils.validatePassphrase(passphrase)) {
            throw new IllegalArgumentException("Passphrase must meet length requirements");
        }
        if (this.mTerminated) {
            Log.w("DiscoverySession", "createNetworkSpecifierPassphrase: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w("DiscoverySession", "createNetworkSpecifierPassphrase: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, null, passphrase);
    }

    @SystemApi
    private final NetworkSpecifier $$robo$$android_net_wifi_aware_DiscoverySession$createNetworkSpecifierPmk(PeerHandle peerHandle, byte[] pmk) {
        if (!WifiAwareUtils.validatePmk(pmk)) {
            throw new IllegalArgumentException("PMK must 32 bytes");
        }
        if (this.mTerminated) {
            Log.w("DiscoverySession", "createNetworkSpecifierPmk: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w("DiscoverySession", "createNetworkSpecifierPmk: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, pmk, null);
    }

    public static int getMaxSendRetryCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSendRetryCount", $$robo$$android_net_wifi_aware_DiscoverySession$getMaxSendRetryCount());
    }

    private void __constructor__(WifiAwareManager wifiAwareManager, int n, int n2) {
        this.$$robo$$android_net_wifi_aware_DiscoverySession$__constructor__(wifiAwareManager, n, n2);
    }

    public DiscoverySession(WifiAwareManager wifiAwareManager, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_DiscoverySession$__constructor__(android.net.wifi.aware.WifiAwareManager int int ), this, wifiAwareManager, n, n2);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_wifi_aware_DiscoverySession$close(), this);
    }

    public void setTerminated() {
        InvokeDynamicSupport.bootstrap("setTerminated", $$robo$$android_net_wifi_aware_DiscoverySession$setTerminated(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_aware_DiscoverySession$finalize(), this);
    }

    public int getClientId() {
        return (int)InvokeDynamicSupport.bootstrap("getClientId", $$robo$$android_net_wifi_aware_DiscoverySession$getClientId(), this);
    }

    public int getSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_net_wifi_aware_DiscoverySession$getSessionId(), this);
    }

    public void sendMessage(PeerHandle peerHandle, int n, byte[] byArray, int n2) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_wifi_aware_DiscoverySession$sendMessage(android.net.wifi.aware.PeerHandle int byte[] int ), this, peerHandle, n, byArray, n2);
    }

    public void sendMessage(PeerHandle peerHandle, int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_wifi_aware_DiscoverySession$sendMessage(android.net.wifi.aware.PeerHandle int byte[] ), this, peerHandle, n, byArray);
    }

    public NetworkSpecifier createNetworkSpecifierOpen(PeerHandle peerHandle) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifierOpen", $$robo$$android_net_wifi_aware_DiscoverySession$createNetworkSpecifierOpen(android.net.wifi.aware.PeerHandle ), this, peerHandle);
    }

    public NetworkSpecifier createNetworkSpecifierPassphrase(PeerHandle peerHandle, String string2) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifierPassphrase", $$robo$$android_net_wifi_aware_DiscoverySession$createNetworkSpecifierPassphrase(android.net.wifi.aware.PeerHandle java.lang.String ), this, peerHandle, string2);
    }

    @SystemApi
    public NetworkSpecifier createNetworkSpecifierPmk(PeerHandle peerHandle, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifierPmk", $$robo$$android_net_wifi_aware_DiscoverySession$createNetworkSpecifierPmk(android.net.wifi.aware.PeerHandle byte[] ), this, peerHandle, byArray);
    }

    public /* synthetic */ DiscoverySession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DiscoverySession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

