/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.rtt.RangingRequest;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.rtt.RangingResultCallback;
import android.net.wifi.rtt.WifiRttManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@Deprecated
public class RttManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "RttManager";
    @Deprecated
    public static int RTT_TYPE_UNSPECIFIED = 0;
    public static int RTT_TYPE_ONE_SIDED = 1;
    public static int RTT_TYPE_TWO_SIDED = 2;
    @Deprecated
    public static int RTT_TYPE_11_V = 2;
    @Deprecated
    public static int RTT_TYPE_11_MC = 4;
    @Deprecated
    public static int RTT_PEER_TYPE_UNSPECIFIED = 0;
    public static int RTT_PEER_TYPE_AP = 1;
    public static int RTT_PEER_TYPE_STA = 2;
    public static int RTT_PEER_P2P_GO = 3;
    public static int RTT_PEER_P2P_CLIENT = 4;
    public static int RTT_PEER_NAN = 5;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_20 = 0;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_40 = 1;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_80 = 2;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_160 = 3;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_80P80 = 4;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_5 = 5;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_10 = 6;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_UNSPECIFIED = -1;
    public static int RTT_STATUS_SUCCESS = 0;
    public static int RTT_STATUS_FAILURE = 1;
    public static int RTT_STATUS_FAIL_NO_RSP = 2;
    public static int RTT_STATUS_FAIL_REJECTED = 3;
    public static int RTT_STATUS_FAIL_NOT_SCHEDULED_YET = 4;
    public static int RTT_STATUS_FAIL_TM_TIMEOUT = 5;
    public static int RTT_STATUS_FAIL_AP_ON_DIFF_CHANNEL = 6;
    public static int RTT_STATUS_FAIL_NO_CAPABILITY = 7;
    public static int RTT_STATUS_ABORTED = 8;
    public static int RTT_STATUS_FAIL_INVALID_TS = 9;
    public static int RTT_STATUS_FAIL_PROTOCOL = 10;
    public static int RTT_STATUS_FAIL_SCHEDULE = 11;
    public static int RTT_STATUS_FAIL_BUSY_TRY_LATER = 12;
    public static int RTT_STATUS_INVALID_REQ = 13;
    public static int RTT_STATUS_NO_WIFI = 14;
    public static int RTT_STATUS_FAIL_FTM_PARAM_OVERRIDE = 15;
    public static int REASON_UNSPECIFIED = -1;
    public static int REASON_NOT_AVAILABLE = -2;
    public static int REASON_INVALID_LISTENER = -3;
    public static int REASON_INVALID_REQUEST = -4;
    public static int REASON_PERMISSION_DENIED = -5;
    public static int REASON_INITIATOR_NOT_ALLOWED_WHEN_RESPONDER_ON = -6;
    public static String DESCRIPTION_KEY = "android.net.wifi.RttManager.Description";
    public static int RTT_BW_5_SUPPORT = 1;
    public static int RTT_BW_10_SUPPORT = 2;
    public static int RTT_BW_20_SUPPORT = 4;
    public static int RTT_BW_40_SUPPORT = 8;
    public static int RTT_BW_80_SUPPORT = 16;
    public static int RTT_BW_160_SUPPORT = 32;
    public static int PREAMBLE_LEGACY = 1;
    public static int PREAMBLE_HT = 2;
    public static int PREAMBLE_VHT = 4;
    public static int BASE = 160256;
    public static int CMD_OP_START_RANGING = 160256;
    public static int CMD_OP_STOP_RANGING = 160257;
    public static int CMD_OP_FAILED = 160258;
    public static int CMD_OP_SUCCEEDED = 160259;
    public static int CMD_OP_ABORTED = 160260;
    public static int CMD_OP_ENABLE_RESPONDER = 160261;
    public static int CMD_OP_DISABLE_RESPONDER = 160262;
    public static int CMD_OP_ENALBE_RESPONDER_SUCCEEDED = 160263;
    public static int CMD_OP_ENALBE_RESPONDER_FAILED = 160264;
    public static int CMD_OP_REG_BINDER = 160265;
    private WifiRttManager mNewService;
    private Context mContext;
    private RttCapabilities mRttCapabilities;

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final Capabilities $$robo$$android_net_wifi_RttManager$getCapabilities() {
        throw new UnsupportedOperationException("getCapabilities is not supported in the adaptation layer");
    }

    private final RttCapabilities $$robo$$android_net_wifi_RttManager$getRttCapabilities() {
        return this.mRttCapabilities;
    }

    private final void $$robo$$android_net_wifi_RttManager$startRanging(RttParams[] params, RttListener listener) {
        Log.i("RttManager", "Send RTT request to RTT Service");
        if (!this.mNewService.isAvailable()) {
            listener.onFailure(-2, "");
            return;
        }
        RangingRequest.Builder builder = new RangingRequest.Builder();
        for (RttParams rttParams : params) {
            if (rttParams.deviceType != 1) {
                listener.onFailure(-4, "Only AP peers are supported");
                return;
            }
            ScanResult reconstructed = new ScanResult();
            reconstructed.BSSID = rttParams.bssid;
            if (rttParams.requestType == 2) {
                reconstructed.setFlag(2L);
            }
            reconstructed.channelWidth = rttParams.channelWidth;
            reconstructed.frequency = rttParams.frequency;
            reconstructed.centerFreq0 = rttParams.centerFreq0;
            reconstructed.centerFreq1 = rttParams.centerFreq1;
            builder.addResponder(android.net.wifi.rtt.ResponderConfig.fromScanResult(reconstructed));
        }
        try {
            this.mNewService.startRanging(builder.build(), this.mContext.getMainExecutor(), (RangingResultCallback)new ShadowedObject(this, listener){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ RttListener val$listener;
                /* synthetic */ RttManager this$0;

                private void $$robo$$android_net_wifi_RttManager_1$__constructor__(RttManager this$0, RttListener rttListener) {
                    this.this$0 = this$0;
                    this.val$listener = rttListener;
                }

                private final void $$robo$$android_net_wifi_RttManager_1$onRangingFailure(int code) {
                    int localCode = -1;
                    if (code == 2) {
                        localCode = -2;
                    }
                    this.val$listener.onFailure(localCode, "");
                }

                private final void $$robo$$android_net_wifi_RttManager_1$onRangingResults(List<RangingResult> results) {
                    RttResult[] legacyResults = new RttResult[results.size()];
                    int i = 0;
                    for (RangingResult result : results) {
                        legacyResults[i] = new RttResult();
                        legacyResults[i].status = result.getStatus();
                        legacyResults[i].bssid = result.getMacAddress().toString();
                        if (result.getStatus() == 0) {
                            legacyResults[i].distance = result.getDistanceMm() / 10;
                            legacyResults[i].distanceStandardDeviation = result.getDistanceStdDevMm() / 10;
                            legacyResults[i].rssi = result.getRssi() * -2;
                            legacyResults[i].ts = result.getRangingTimestampMillis() * 1000L;
                            legacyResults[i].measurementFrameNumber = result.getNumAttemptedMeasurements();
                            legacyResults[i].successMeasurementFrameNumber = result.getNumSuccessfulMeasurements();
                        } else {
                            legacyResults[i].ts = SystemClock.elapsedRealtime() * 1000L;
                        }
                        ++i;
                    }
                    this.val$listener.onSuccess(legacyResults);
                }

                private void __constructor__(RttManager rttManager, RttListener rttListener) {
                    this.$$robo$$android_net_wifi_RttManager_1$__constructor__(rttManager, rttListener);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_1$__constructor__(android.net.wifi.RttManager android.net.wifi.RttManager$RttListener ), this, rttManager, rttListener);
                }

                @Override
                public void onRangingFailure(int n) {
                    InvokeDynamicSupport.bootstrap("onRangingFailure", $$robo$$android_net_wifi_RttManager_1$onRangingFailure(int ), this, n);
                }

                @Override
                public void onRangingResults(List<RangingResult> list) {
                    InvokeDynamicSupport.bootstrap("onRangingResults", $$robo$$android_net_wifi_RttManager_1$onRangingResults(java.util.List<android.net.wifi.rtt.RangingResult> ), this, list);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        catch (IllegalArgumentException e) {
            Log.e("RttManager", "startRanging: invalid arguments - " + e);
            listener.onFailure(-4, e.getMessage());
        }
        catch (SecurityException e) {
            Log.e("RttManager", "startRanging: security exception - " + e);
            listener.onFailure(-5, e.getMessage());
        }
    }

    private final void $$robo$$android_net_wifi_RttManager$stopRanging(RttListener listener) {
        Log.e("RttManager", "stopRanging: unsupported operation - nop");
    }

    private final void $$robo$$android_net_wifi_RttManager$enableResponder(ResponderCallback callback) {
        throw new UnsupportedOperationException("enableResponder is not supported in the adaptation layer");
    }

    private final void $$robo$$android_net_wifi_RttManager$disableResponder(ResponderCallback callback) {
        throw new UnsupportedOperationException("disableResponder is not supported in the adaptation layer");
    }

    private void $$robo$$android_net_wifi_RttManager$__constructor__(Context context, WifiRttManager service) {
        this.mNewService = service;
        this.mContext = context;
        boolean rttSupported = context.getPackageManager().hasSystemFeature("android.hardware.wifi.rtt");
        this.mRttCapabilities = new RttCapabilities();
        this.mRttCapabilities.oneSidedRttSupported = rttSupported;
        this.mRttCapabilities.twoSided11McRttSupported = rttSupported;
        this.mRttCapabilities.lciSupported = false;
        this.mRttCapabilities.lcrSupported = false;
        this.mRttCapabilities.preambleSupported = 6;
        this.mRttCapabilities.bwSupported = 24;
        this.mRttCapabilities.responderSupported = false;
        this.mRttCapabilities.secureRttSupported = false;
    }

    @Deprecated
    public Capabilities getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_net_wifi_RttManager$getCapabilities(), this);
    }

    public RttCapabilities getRttCapabilities() {
        return InvokeDynamicSupport.bootstrap("getRttCapabilities", $$robo$$android_net_wifi_RttManager$getRttCapabilities(), this);
    }

    public void startRanging(RttParams[] rttParamsArray, RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("startRanging", $$robo$$android_net_wifi_RttManager$startRanging(android.net.wifi.RttManager$RttParams[] android.net.wifi.RttManager$RttListener ), this, rttParamsArray, rttListener);
    }

    public void stopRanging(RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("stopRanging", $$robo$$android_net_wifi_RttManager$stopRanging(android.net.wifi.RttManager$RttListener ), this, rttListener);
    }

    public void enableResponder(ResponderCallback responderCallback) {
        InvokeDynamicSupport.bootstrap("enableResponder", $$robo$$android_net_wifi_RttManager$enableResponder(android.net.wifi.RttManager$ResponderCallback ), this, responderCallback);
    }

    public void disableResponder(ResponderCallback responderCallback) {
        InvokeDynamicSupport.bootstrap("disableResponder", $$robo$$android_net_wifi_RttManager$disableResponder(android.net.wifi.RttManager$ResponderCallback ), this, responderCallback);
    }

    private void __constructor__(Context context, WifiRttManager wifiRttManager) {
        this.$$robo$$android_net_wifi_RttManager$__constructor__(context, wifiRttManager);
    }

    public RttManager(Context context, WifiRttManager wifiRttManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager$__constructor__(android.content.Context android.net.wifi.rtt.WifiRttManager ), this, context, wifiRttManager);
    }

    public /* synthetic */ RttManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static class ResponderConfig
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String macAddress;
        public int frequency;
        public int centerFreq0;
        public int centerFreq1;
        public int channelWidth;
        public int preamble;
        public static Parcelable.Creator<ResponderConfig> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ResponderConfig$__constructor__() {
            this.macAddress = "";
        }

        private final String $$robo$$android_net_wifi_RttManager_ResponderConfig$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("macAddress = ").append(this.macAddress).append(" frequency = ").append(this.frequency).append(" centerFreq0 = ").append(this.centerFreq0).append(" centerFreq1 = ").append(this.centerFreq1).append(" channelWidth = ").append(this.channelWidth).append(" preamble = ").append(this.preamble);
            return builder.toString();
        }

        private final int $$robo$$android_net_wifi_RttManager_ResponderConfig$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ResponderConfig$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.macAddress);
            dest.writeInt(this.frequency);
            dest.writeInt(this.centerFreq0);
            dest.writeInt(this.centerFreq1);
            dest.writeInt(this.channelWidth);
            dest.writeInt(this.preamble);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ResponderConfig>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ResponderConfig_1$__constructor__() {
                }

                private final ResponderConfig $$robo$$android_net_wifi_RttManager_ResponderConfig_1$createFromParcel(Parcel in) {
                    ResponderConfig config = new ResponderConfig();
                    config.macAddress = in.readString();
                    config.frequency = in.readInt();
                    config.centerFreq0 = in.readInt();
                    config.centerFreq1 = in.readInt();
                    config.channelWidth = in.readInt();
                    config.preamble = in.readInt();
                    return config;
                }

                private final ResponderConfig[] $$robo$$android_net_wifi_RttManager_ResponderConfig_1$newArray(int size) {
                    return new ResponderConfig[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ResponderConfig_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ResponderConfig_1$__constructor__(), this);
                }

                @Override
                public ResponderConfig createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ResponderConfig_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ResponderConfig[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ResponderConfig_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_ResponderConfig$__constructor__();
        }

        public ResponderConfig() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ResponderConfig$__constructor__(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_ResponderConfig$toString(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ResponderConfig$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ResponderConfig$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ResponderConfig.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResponderConfig)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static abstract class ResponderCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_wifi_RttManager_ResponderCallback$__constructor__() {
        }

        public abstract void onResponderEnabled(ResponderConfig var1);

        public abstract void onResponderEnableFailure(int var1);

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_ResponderCallback$__constructor__();
        }

        public ResponderCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ResponderCallback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResponderCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface RttListener {
        public void onSuccess(RttResult[] var1);

        public void onFailure(int var1, String var2);

        public void onAborted();
    }

    @Deprecated
    public static class ParcelableRttResults
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public RttResult[] mResults;
        public static Parcelable.Creator<ParcelableRttResults> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(RttResult[] results) {
            this.mResults = results;
        }

        private final String $$robo$$android_net_wifi_RttManager_ParcelableRttResults$toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mResults.length; ++i) {
                sb.append("[" + i + "]: ");
                sb.append("bssid=" + this.mResults[i].bssid);
                sb.append(", burstNumber=" + this.mResults[i].burstNumber);
                sb.append(", measurementFrameNumber=" + this.mResults[i].measurementFrameNumber);
                sb.append(", successMeasurementFrameNumber=" + this.mResults[i].successMeasurementFrameNumber);
                sb.append(", frameNumberPerBurstPeer=" + this.mResults[i].frameNumberPerBurstPeer);
                sb.append(", status=" + this.mResults[i].status);
                sb.append(", requestType=" + this.mResults[i].requestType);
                sb.append(", measurementType=" + this.mResults[i].measurementType);
                sb.append(", retryAfterDuration=" + this.mResults[i].retryAfterDuration);
                sb.append(", ts=" + this.mResults[i].ts);
                sb.append(", rssi=" + this.mResults[i].rssi);
                sb.append(", rssi_spread=" + this.mResults[i].rssi_spread);
                sb.append(", rssiSpread=" + this.mResults[i].rssiSpread);
                sb.append(", tx_rate=" + this.mResults[i].tx_rate);
                sb.append(", txRate=" + this.mResults[i].txRate);
                sb.append(", rxRate=" + this.mResults[i].rxRate);
                sb.append(", rtt_ns=" + this.mResults[i].rtt_ns);
                sb.append(", rtt=" + this.mResults[i].rtt);
                sb.append(", rtt_sd_ns=" + this.mResults[i].rtt_sd_ns);
                sb.append(", rttStandardDeviation=" + this.mResults[i].rttStandardDeviation);
                sb.append(", rtt_spread_ns=" + this.mResults[i].rtt_spread_ns);
                sb.append(", rttSpread=" + this.mResults[i].rttSpread);
                sb.append(", distance_cm=" + this.mResults[i].distance_cm);
                sb.append(", distance=" + this.mResults[i].distance);
                sb.append(", distance_sd_cm=" + this.mResults[i].distance_sd_cm);
                sb.append(", distanceStandardDeviation=" + this.mResults[i].distanceStandardDeviation);
                sb.append(", distance_spread_cm=" + this.mResults[i].distance_spread_cm);
                sb.append(", distanceSpread=" + this.mResults[i].distanceSpread);
                sb.append(", burstDuration=" + this.mResults[i].burstDuration);
                sb.append(", negotiatedBurstNum=" + this.mResults[i].negotiatedBurstNum);
                sb.append(", LCI=" + this.mResults[i].LCI);
                sb.append(", LCR=" + this.mResults[i].LCR);
                sb.append(", secure=" + this.mResults[i].secure);
            }
            return sb.toString();
        }

        private final int $$robo$$android_net_wifi_RttManager_ParcelableRttResults$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ParcelableRttResults$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (RttResult result : this.mResults) {
                    dest.writeString(result.bssid);
                    dest.writeInt(result.burstNumber);
                    dest.writeInt(result.measurementFrameNumber);
                    dest.writeInt(result.successMeasurementFrameNumber);
                    dest.writeInt(result.frameNumberPerBurstPeer);
                    dest.writeInt(result.status);
                    dest.writeInt(result.measurementType);
                    dest.writeInt(result.retryAfterDuration);
                    dest.writeLong(result.ts);
                    dest.writeInt(result.rssi);
                    dest.writeInt(result.rssiSpread);
                    dest.writeInt(result.txRate);
                    dest.writeLong(result.rtt);
                    dest.writeLong(result.rttStandardDeviation);
                    dest.writeLong(result.rttSpread);
                    dest.writeInt(result.distance);
                    dest.writeInt(result.distanceStandardDeviation);
                    dest.writeInt(result.distanceSpread);
                    dest.writeInt(result.burstDuration);
                    dest.writeInt(result.negotiatedBurstNum);
                    dest.writeByte(result.LCI.id);
                    if (result.LCI.id != -1) {
                        dest.writeByte((byte)result.LCI.data.length);
                        dest.writeByteArray(result.LCI.data);
                    }
                    dest.writeByte(result.LCR.id);
                    if (result.LCR.id != -1) {
                        dest.writeByte((byte)result.LCR.data.length);
                        dest.writeByteArray(result.LCR.data);
                    }
                    dest.writeByte(result.secure ? (byte)1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableRttResults>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__() {
                }

                private final ParcelableRttResults $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$createFromParcel(Parcel in) {
                    int num = in.readInt();
                    if (num == 0) {
                        return new ParcelableRttResults(null);
                    }
                    RttResult[] results = new RttResult[num];
                    for (int i = 0; i < num; ++i) {
                        byte length;
                        results[i] = new RttResult();
                        results[i].bssid = in.readString();
                        results[i].burstNumber = in.readInt();
                        results[i].measurementFrameNumber = in.readInt();
                        results[i].successMeasurementFrameNumber = in.readInt();
                        results[i].frameNumberPerBurstPeer = in.readInt();
                        results[i].status = in.readInt();
                        results[i].measurementType = in.readInt();
                        results[i].retryAfterDuration = in.readInt();
                        results[i].ts = in.readLong();
                        results[i].rssi = in.readInt();
                        results[i].rssiSpread = in.readInt();
                        results[i].txRate = in.readInt();
                        results[i].rtt = in.readLong();
                        results[i].rttStandardDeviation = in.readLong();
                        results[i].rttSpread = in.readLong();
                        results[i].distance = in.readInt();
                        results[i].distanceStandardDeviation = in.readInt();
                        results[i].distanceSpread = in.readInt();
                        results[i].burstDuration = in.readInt();
                        results[i].negotiatedBurstNum = in.readInt();
                        results[i].LCI = new WifiInformationElement();
                        results[i].LCI.id = in.readByte();
                        if (results[i].LCI.id != -1) {
                            length = in.readByte();
                            results[i].LCI.data = new byte[length];
                            in.readByteArray(results[i].LCI.data);
                        }
                        results[i].LCR = new WifiInformationElement();
                        results[i].LCR.id = in.readByte();
                        if (results[i].LCR.id != -1) {
                            length = in.readByte();
                            results[i].LCR.data = new byte[length];
                            in.readByteArray(results[i].LCR.data);
                        }
                        results[i].secure = in.readByte() != 0;
                    }
                    ParcelableRttResults parcelableResults = new ParcelableRttResults(results);
                    return parcelableResults;
                }

                private final ParcelableRttResults[] $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$newArray(int size) {
                    return new ParcelableRttResults[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__(), this);
                }

                @Override
                public ParcelableRttResults createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ParcelableRttResults[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(RttResult[] rttResultArray) {
            this.$$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(rttResultArray);
        }

        public ParcelableRttResults(RttResult[] rttResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(android.net.wifi.RttManager$RttResult[] ), this, rttResultArray);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$toString(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableRttResults.class);
        }

        public /* synthetic */ ParcelableRttResults() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableRttResults)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class RttResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String bssid;
        public int burstNumber;
        public int measurementFrameNumber;
        public int successMeasurementFrameNumber;
        public int frameNumberPerBurstPeer;
        public int status;
        @Deprecated
        public int requestType;
        public int measurementType;
        public int retryAfterDuration;
        public long ts;
        public int rssi;
        @Deprecated
        public int rssi_spread;
        public int rssiSpread;
        @Deprecated
        public int tx_rate;
        public int txRate;
        public int rxRate;
        @Deprecated
        public long rtt_ns;
        public long rtt;
        @Deprecated
        public long rtt_sd_ns;
        public long rttStandardDeviation;
        @Deprecated
        public long rtt_spread_ns;
        public long rttSpread;
        @Deprecated
        public int distance_cm;
        public int distance;
        @Deprecated
        public int distance_sd_cm;
        public int distanceStandardDeviation;
        @Deprecated
        public int distance_spread_cm;
        public int distanceSpread;
        public int burstDuration;
        public int negotiatedBurstNum;
        public WifiInformationElement LCI;
        public WifiInformationElement LCR;
        public boolean secure;

        private void $$robo$$android_net_wifi_RttManager_RttResult$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttResult$__constructor__();
        }

        public RttResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttResult$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class WifiInformationElement
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public byte id;
        public byte[] data;

        private void $$robo$$android_net_wifi_RttManager_WifiInformationElement$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_WifiInformationElement$__constructor__();
        }

        public WifiInformationElement() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_WifiInformationElement$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiInformationElement)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class ParcelableRttParams
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public RttParams[] mParams;
        public static Parcelable.Creator<ParcelableRttParams> CREATOR;

        @VisibleForTesting
        private void $$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(RttParams[] params) {
            this.mParams = params == null ? new RttParams[]{} : params;
        }

        private final int $$robo$$android_net_wifi_RttManager_ParcelableRttParams$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ParcelableRttParams$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mParams.length);
            for (RttParams params : this.mParams) {
                dest.writeInt(params.deviceType);
                dest.writeInt(params.requestType);
                dest.writeByte(params.secure ? (byte)1 : 0);
                dest.writeString(params.bssid);
                dest.writeInt(params.channelWidth);
                dest.writeInt(params.frequency);
                dest.writeInt(params.centerFreq0);
                dest.writeInt(params.centerFreq1);
                dest.writeInt(params.numberBurst);
                dest.writeInt(params.interval);
                dest.writeInt(params.numSamplesPerBurst);
                dest.writeInt(params.numRetriesPerMeasurementFrame);
                dest.writeInt(params.numRetriesPerFTMR);
                dest.writeInt(params.LCIRequest ? 1 : 0);
                dest.writeInt(params.LCRRequest ? 1 : 0);
                dest.writeInt(params.burstTimeout);
                dest.writeInt(params.preamble);
                dest.writeInt(params.bandwidth);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableRttParams>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__() {
                }

                private final ParcelableRttParams $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$createFromParcel(Parcel in) {
                    int num = in.readInt();
                    RttParams[] params = new RttParams[num];
                    for (int i = 0; i < num; ++i) {
                        params[i] = new RttParams();
                        params[i].deviceType = in.readInt();
                        params[i].requestType = in.readInt();
                        params[i].secure = in.readByte() != 0;
                        params[i].bssid = in.readString();
                        params[i].channelWidth = in.readInt();
                        params[i].frequency = in.readInt();
                        params[i].centerFreq0 = in.readInt();
                        params[i].centerFreq1 = in.readInt();
                        params[i].numberBurst = in.readInt();
                        params[i].interval = in.readInt();
                        params[i].numSamplesPerBurst = in.readInt();
                        params[i].numRetriesPerMeasurementFrame = in.readInt();
                        params[i].numRetriesPerFTMR = in.readInt();
                        params[i].LCIRequest = in.readInt() == 1;
                        params[i].LCRRequest = in.readInt() == 1;
                        params[i].burstTimeout = in.readInt();
                        params[i].preamble = in.readInt();
                        params[i].bandwidth = in.readInt();
                    }
                    ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
                    return parcelableParams;
                }

                private final ParcelableRttParams[] $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$newArray(int size) {
                    return new ParcelableRttParams[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__(), this);
                }

                @Override
                public ParcelableRttParams createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ParcelableRttParams[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(RttParams[] rttParamsArray) {
            this.$$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(rttParamsArray);
        }

        public ParcelableRttParams(RttParams[] rttParamsArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(android.net.wifi.RttManager$RttParams[] ), this, rttParamsArray);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableRttParams.class);
        }

        public /* synthetic */ ParcelableRttParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableRttParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class RttParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int deviceType;
        public int requestType;
        public boolean secure;
        public String bssid;
        public int frequency;
        public int channelWidth;
        public int centerFreq0;
        public int centerFreq1;
        @Deprecated
        public int num_samples;
        @Deprecated
        public int num_retries;
        public int numberBurst;
        public int interval;
        public int numSamplesPerBurst;
        public int numRetriesPerMeasurementFrame;
        public int numRetriesPerFTMR;
        public boolean LCIRequest;
        public boolean LCRRequest;
        public int burstTimeout;
        public int preamble;
        public int bandwidth;

        private void $$robo$$android_net_wifi_RttManager_RttParams$__constructor__() {
            this.deviceType = 1;
            this.requestType = 1;
            this.numberBurst = 0;
            this.numSamplesPerBurst = 8;
            this.numRetriesPerMeasurementFrame = 0;
            this.numRetriesPerFTMR = 0;
            this.burstTimeout = 15;
            this.preamble = 2;
            this.bandwidth = 4;
        }

        private final String $$robo$$android_net_wifi_RttManager_RttParams$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("deviceType=" + this.deviceType);
            sb.append(", requestType=" + this.requestType);
            sb.append(", secure=" + this.secure);
            sb.append(", bssid=" + this.bssid);
            sb.append(", frequency=" + this.frequency);
            sb.append(", channelWidth=" + this.channelWidth);
            sb.append(", centerFreq0=" + this.centerFreq0);
            sb.append(", centerFreq1=" + this.centerFreq1);
            sb.append(", num_samples=" + this.num_samples);
            sb.append(", num_retries=" + this.num_retries);
            sb.append(", numberBurst=" + this.numberBurst);
            sb.append(", interval=" + this.interval);
            sb.append(", numSamplesPerBurst=" + this.numSamplesPerBurst);
            sb.append(", numRetriesPerMeasurementFrame=" + this.numRetriesPerMeasurementFrame);
            sb.append(", numRetriesPerFTMR=" + this.numRetriesPerFTMR);
            sb.append(", LCIRequest=" + this.LCIRequest);
            sb.append(", LCRRequest=" + this.LCRRequest);
            sb.append(", burstTimeout=" + this.burstTimeout);
            sb.append(", preamble=" + this.preamble);
            sb.append(", bandwidth=" + this.bandwidth);
            return sb.toString();
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttParams$__constructor__();
        }

        public RttParams() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttParams$__constructor__(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_RttParams$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class RttCapabilities
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public boolean supportedType;
        @Deprecated
        public boolean supportedPeerType;
        public boolean oneSidedRttSupported;
        public boolean twoSided11McRttSupported;
        public boolean lciSupported;
        public boolean lcrSupported;
        public int preambleSupported;
        public int bwSupported;
        public boolean responderSupported;
        public boolean secureRttSupported;
        public int mcVersion;
        public static Parcelable.Creator<RttCapabilities> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_RttCapabilities$__constructor__() {
        }

        private final String $$robo$$android_net_wifi_RttManager_RttCapabilities$toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("oneSidedRtt ").append(this.oneSidedRttSupported ? "is Supported. " : "is not supported. ").append("twoSided11McRtt ").append(this.twoSided11McRttSupported ? "is Supported. " : "is not supported. ").append("lci ").append(this.lciSupported ? "is Supported. " : "is not supported. ").append("lcr ").append(this.lcrSupported ? "is Supported. " : "is not supported. ");
            if ((this.preambleSupported & 1) != 0) {
                sb.append("Legacy ");
            }
            if ((this.preambleSupported & 2) != 0) {
                sb.append("HT ");
            }
            if ((this.preambleSupported & 4) != 0) {
                sb.append("VHT ");
            }
            sb.append("is supported. ");
            if ((this.bwSupported & 1) != 0) {
                sb.append("5 MHz ");
            }
            if ((this.bwSupported & 2) != 0) {
                sb.append("10 MHz ");
            }
            if ((this.bwSupported & 4) != 0) {
                sb.append("20 MHz ");
            }
            if ((this.bwSupported & 8) != 0) {
                sb.append("40 MHz ");
            }
            if ((this.bwSupported & 0x10) != 0) {
                sb.append("80 MHz ");
            }
            if ((this.bwSupported & 0x20) != 0) {
                sb.append("160 MHz ");
            }
            sb.append("is supported.");
            sb.append(" STA responder role is ").append(this.responderSupported ? "supported" : "not supported");
            sb.append(" Secure RTT protocol is ").append(this.secureRttSupported ? "supported" : "not supported");
            sb.append(" 11mc version is " + this.mcVersion);
            return sb.toString();
        }

        private final int $$robo$$android_net_wifi_RttManager_RttCapabilities$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_RttCapabilities$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.oneSidedRttSupported ? 1 : 0);
            dest.writeInt(this.twoSided11McRttSupported ? 1 : 0);
            dest.writeInt(this.lciSupported ? 1 : 0);
            dest.writeInt(this.lcrSupported ? 1 : 0);
            dest.writeInt(this.preambleSupported);
            dest.writeInt(this.bwSupported);
            dest.writeInt(this.responderSupported ? 1 : 0);
            dest.writeInt(this.secureRttSupported ? 1 : 0);
            dest.writeInt(this.mcVersion);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RttCapabilities>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_RttCapabilities_1$__constructor__() {
                }

                private final RttCapabilities $$robo$$android_net_wifi_RttManager_RttCapabilities_1$createFromParcel(Parcel in) {
                    RttCapabilities capabilities = new RttCapabilities();
                    capabilities.oneSidedRttSupported = in.readInt() == 1;
                    capabilities.twoSided11McRttSupported = in.readInt() == 1;
                    capabilities.lciSupported = in.readInt() == 1;
                    capabilities.lcrSupported = in.readInt() == 1;
                    capabilities.preambleSupported = in.readInt();
                    capabilities.bwSupported = in.readInt();
                    capabilities.responderSupported = in.readInt() == 1;
                    capabilities.secureRttSupported = in.readInt() == 1;
                    capabilities.mcVersion = in.readInt();
                    return capabilities;
                }

                private final RttCapabilities[] $$robo$$android_net_wifi_RttManager_RttCapabilities_1$newArray(int size) {
                    return new RttCapabilities[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_RttCapabilities_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttCapabilities_1$__constructor__(), this);
                }

                @Override
                public RttCapabilities createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_RttCapabilities_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public RttCapabilities[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_RttCapabilities_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttCapabilities$__constructor__();
        }

        public RttCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttCapabilities$__constructor__(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_RttCapabilities$toString(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_RttCapabilities$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_RttCapabilities$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(RttCapabilities.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public class Capabilities
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int supportedType;
        public int supportedPeerType;
        /* synthetic */ RttManager this$0;

        private void $$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(RttManager this$0) {
            this.this$0 = this$0;
        }

        private void __constructor__(RttManager rttManager) {
            this.$$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(rttManager);
        }

        public Capabilities(RttManager rttManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(android.net.wifi.RttManager ), this, rttManager);
        }

        public /* synthetic */ Capabilities() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Capabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

