/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.pm.ParceledListSlice;
import android.net.DhcpInfo;
import android.net.Network;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IWifiManager
extends IInterface {
    public int getSupportedFeatures() throws RemoteException;

    public WifiActivityEnergyInfo reportActivityInfo() throws RemoteException;

    public void requestActivityInfo(ResultReceiver var1) throws RemoteException;

    public ParceledListSlice getConfiguredNetworks() throws RemoteException;

    public ParceledListSlice getPrivilegedConfiguredNetworks() throws RemoteException;

    public WifiConfiguration getMatchingWifiConfig(ScanResult var1) throws RemoteException;

    public List<WifiConfiguration> getAllMatchingWifiConfigs(ScanResult var1) throws RemoteException;

    public List<OsuProvider> getMatchingOsuProviders(ScanResult var1) throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration var1, String var2) throws RemoteException;

    public boolean removePasspointConfiguration(String var1, String var2) throws RemoteException;

    public List<PasspointConfiguration> getPasspointConfigurations() throws RemoteException;

    public void queryPasspointIcon(long var1, String var3) throws RemoteException;

    public int matchProviderWithCurrentNetwork(String var1) throws RemoteException;

    public void deauthenticateNetwork(long var1, boolean var3) throws RemoteException;

    public boolean removeNetwork(int var1, String var2) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2, String var3) throws RemoteException;

    public boolean disableNetwork(int var1, String var2) throws RemoteException;

    public boolean startScan(String var1) throws RemoteException;

    public List<ScanResult> getScanResults(String var1) throws RemoteException;

    public void disconnect(String var1) throws RemoteException;

    public void reconnect(String var1) throws RemoteException;

    public void reassociate(String var1) throws RemoteException;

    public WifiInfo getConnectionInfo(String var1) throws RemoteException;

    public boolean setWifiEnabled(String var1, boolean var2) throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public void setCountryCode(String var1) throws RemoteException;

    public String getCountryCode() throws RemoteException;

    public boolean isDualBandSupported() throws RemoteException;

    public boolean needs5GHzToAnyApBandConversion() throws RemoteException;

    public DhcpInfo getDhcpInfo() throws RemoteException;

    public boolean isScanAlwaysAvailable() throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public void releaseMulticastLock() throws RemoteException;

    public void updateInterfaceIpState(String var1, int var2) throws RemoteException;

    public boolean startSoftAp(WifiConfiguration var1) throws RemoteException;

    public boolean stopSoftAp() throws RemoteException;

    public int startLocalOnlyHotspot(Messenger var1, IBinder var2, String var3) throws RemoteException;

    public void stopLocalOnlyHotspot() throws RemoteException;

    public void startWatchLocalOnlyHotspot(Messenger var1, IBinder var2) throws RemoteException;

    public void stopWatchLocalOnlyHotspot() throws RemoteException;

    public int getWifiApEnabledState() throws RemoteException;

    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public boolean setWifiApConfiguration(WifiConfiguration var1, String var2) throws RemoteException;

    public void notifyUserOfApBandConversion(String var1) throws RemoteException;

    public Messenger getWifiServiceMessenger(String var1) throws RemoteException;

    public void enableTdls(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithMacAddress(String var1, boolean var2) throws RemoteException;

    public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException;

    public void enableVerboseLogging(int var1) throws RemoteException;

    public int getVerboseLoggingLevel() throws RemoteException;

    public void enableWifiConnectivityManager(boolean var1) throws RemoteException;

    public void disableEphemeralNetwork(String var1, String var2) throws RemoteException;

    public void factoryReset(String var1) throws RemoteException;

    public Network getCurrentNetwork() throws RemoteException;

    public byte[] retrieveBackupData() throws RemoteException;

    public void restoreBackupData(byte[] var1) throws RemoteException;

    public void restoreSupplicantBackupData(byte[] var1, byte[] var2) throws RemoteException;

    public void startSubscriptionProvisioning(OsuProvider var1, IProvisioningCallback var2) throws RemoteException;

    public void registerSoftApCallback(IBinder var1, ISoftApCallback var2, int var3) throws RemoteException;

    public void unregisterSoftApCallback(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiManager,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static int TRANSACTION_getSupportedFeatures = 1;
        static int TRANSACTION_reportActivityInfo = 2;
        static int TRANSACTION_requestActivityInfo = 3;
        static int TRANSACTION_getConfiguredNetworks = 4;
        static int TRANSACTION_getPrivilegedConfiguredNetworks = 5;
        static int TRANSACTION_getMatchingWifiConfig = 6;
        static int TRANSACTION_getAllMatchingWifiConfigs = 7;
        static int TRANSACTION_getMatchingOsuProviders = 8;
        static int TRANSACTION_addOrUpdateNetwork = 9;
        static int TRANSACTION_addOrUpdatePasspointConfiguration = 10;
        static int TRANSACTION_removePasspointConfiguration = 11;
        static int TRANSACTION_getPasspointConfigurations = 12;
        static int TRANSACTION_queryPasspointIcon = 13;
        static int TRANSACTION_matchProviderWithCurrentNetwork = 14;
        static int TRANSACTION_deauthenticateNetwork = 15;
        static int TRANSACTION_removeNetwork = 16;
        static int TRANSACTION_enableNetwork = 17;
        static int TRANSACTION_disableNetwork = 18;
        static int TRANSACTION_startScan = 19;
        static int TRANSACTION_getScanResults = 20;
        static int TRANSACTION_disconnect = 21;
        static int TRANSACTION_reconnect = 22;
        static int TRANSACTION_reassociate = 23;
        static int TRANSACTION_getConnectionInfo = 24;
        static int TRANSACTION_setWifiEnabled = 25;
        static int TRANSACTION_getWifiEnabledState = 26;
        static int TRANSACTION_setCountryCode = 27;
        static int TRANSACTION_getCountryCode = 28;
        static int TRANSACTION_isDualBandSupported = 29;
        static int TRANSACTION_needs5GHzToAnyApBandConversion = 30;
        static int TRANSACTION_getDhcpInfo = 31;
        static int TRANSACTION_isScanAlwaysAvailable = 32;
        static int TRANSACTION_acquireWifiLock = 33;
        static int TRANSACTION_updateWifiLockWorkSource = 34;
        static int TRANSACTION_releaseWifiLock = 35;
        static int TRANSACTION_initializeMulticastFiltering = 36;
        static int TRANSACTION_isMulticastEnabled = 37;
        static int TRANSACTION_acquireMulticastLock = 38;
        static int TRANSACTION_releaseMulticastLock = 39;
        static int TRANSACTION_updateInterfaceIpState = 40;
        static int TRANSACTION_startSoftAp = 41;
        static int TRANSACTION_stopSoftAp = 42;
        static int TRANSACTION_startLocalOnlyHotspot = 43;
        static int TRANSACTION_stopLocalOnlyHotspot = 44;
        static int TRANSACTION_startWatchLocalOnlyHotspot = 45;
        static int TRANSACTION_stopWatchLocalOnlyHotspot = 46;
        static int TRANSACTION_getWifiApEnabledState = 47;
        static int TRANSACTION_getWifiApConfiguration = 48;
        static int TRANSACTION_setWifiApConfiguration = 49;
        static int TRANSACTION_notifyUserOfApBandConversion = 50;
        static int TRANSACTION_getWifiServiceMessenger = 51;
        static int TRANSACTION_enableTdls = 52;
        static int TRANSACTION_enableTdlsWithMacAddress = 53;
        static int TRANSACTION_getCurrentNetworkWpsNfcConfigurationToken = 54;
        static int TRANSACTION_enableVerboseLogging = 55;
        static int TRANSACTION_getVerboseLoggingLevel = 56;
        static int TRANSACTION_enableWifiConnectivityManager = 57;
        static int TRANSACTION_disableEphemeralNetwork = 58;
        static int TRANSACTION_factoryReset = 59;
        static int TRANSACTION_getCurrentNetwork = 60;
        static int TRANSACTION_retrieveBackupData = 61;
        static int TRANSACTION_restoreBackupData = 62;
        static int TRANSACTION_restoreSupplicantBackupData = 63;
        static int TRANSACTION_startSubscriptionProvisioning = 64;
        static int TRANSACTION_registerSoftApCallback = 65;
        static int TRANSACTION_unregisterSoftApCallback = 66;

        private void $$robo$$android_net_wifi_IWifiManager_Stub$__constructor__() {
            this.attachInterface(this, "android.net.wifi.IWifiManager");
        }

        private static final IWifiManager $$robo$$android_net_wifi_IWifiManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.net.wifi.IWifiManager");
            if (iin != null && iin instanceof IWifiManager) {
                return (IWifiManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_net_wifi_IWifiManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_net_wifi_IWifiManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = "android.net.wifi.IWifiManager";
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _result = this.getSupportedFeatures();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    WifiActivityEnergyInfo _result = this.reportActivityInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ResultReceiver _arg0 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    this.requestActivityInfo(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ParceledListSlice _result = this.getConfiguredNetworks();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ParceledListSlice _result = this.getPrivilegedConfiguredNetworks();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ScanResult _arg0 = 0 != data.readInt() ? ScanResult.CREATOR.createFromParcel(data) : null;
                    WifiConfiguration _result = this.getMatchingWifiConfig(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ScanResult _arg0 = 0 != data.readInt() ? ScanResult.CREATOR.createFromParcel(data) : null;
                    List _result = this.getAllMatchingWifiConfigs(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    ScanResult _arg0 = 0 != data.readInt() ? ScanResult.CREATOR.createFromParcel(data) : null;
                    List _result = this.getMatchingOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _result = this.addOrUpdateNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    PasspointConfiguration _arg0 = 0 != data.readInt() ? PasspointConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.addOrUpdatePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.removePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    List _result = this.getPasspointConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.queryPasspointIcon(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.matchProviderWithCurrentNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    boolean _arg1 = 0 != data.readInt();
                    this.deauthenticateNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.removeNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    boolean _result = this.enableNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.disableNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.startScan(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List _result = this.getScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.disconnect(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.reconnect(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.reassociate(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    WifiInfo _result = this.getConnectionInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setWifiEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    int _result = this.getWifiEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.setCountryCode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCountryCode();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isDualBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.needs5GHzToAnyApBandConversion();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    DhcpInfo _result = this.getDhcpInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isScanAlwaysAvailable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    WorkSource _arg3 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.acquireWifiLock(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.updateWifiLockWorkSource(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseWifiLock(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    this.initializeMulticastFiltering();
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMulticastEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.acquireMulticastLock(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    this.releaseMulticastLock();
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.updateInterfaceIpState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.startSoftAp(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.stopSoftAp();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    Messenger _arg0 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    int _result = this.startLocalOnlyHotspot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    this.stopLocalOnlyHotspot();
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    Messenger _arg0 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    IBinder _arg1 = data.readStrongBinder();
                    this.startWatchLocalOnlyHotspot(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    this.stopWatchLocalOnlyHotspot();
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    int _result = this.getWifiApEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _result = this.getWifiApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.setWifiApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.notifyUserOfApBandConversion(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Messenger _result = this.getWifiServiceMessenger(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdls(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdlsWithMacAddress(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCurrentNetworkWpsNfcConfigurationToken();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.enableVerboseLogging(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    int _result = this.getVerboseLoggingLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.enableWifiConnectivityManager(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.disableEphemeralNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.factoryReset(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    Network _result = this.getCurrentNetwork();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.retrieveBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    this.restoreBackupData(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    this.restoreSupplicantBackupData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    OsuProvider _arg0 = 0 != data.readInt() ? OsuProvider.CREATOR.createFromParcel(data) : null;
                    IProvisioningCallback _arg1 = IProvisioningCallback.Stub.asInterface(data.readStrongBinder());
                    this.startSubscriptionProvisioning(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    ISoftApCallback _arg1 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.registerSoftApCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterSoftApCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_IWifiManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_IWifiManager_Stub$__constructor__(), this);
        }

        public static IWifiManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_net_wifi_IWifiManager_Stub$asInterface(android.os.IBinder ), (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_net_wifi_IWifiManager_Stub$asBinder(), this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_net_wifi_IWifiManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IWifiManager,
        ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.net.wifi.IWifiManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getSupportedFeatures() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiActivityEnergyInfo $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reportActivityInfo() throws RemoteException {
                WifiActivityEnergyInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiActivityEnergyInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$requestActivityInfo(ResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParceledListSlice $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConfiguredNetworks() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParceledListSlice $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getPrivilegedConfiguredNetworks() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiConfiguration $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getMatchingWifiConfig(ScanResult scanResult) throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (scanResult != null) {
                        _data.writeInt(1);
                        scanResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<WifiConfiguration> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getAllMatchingWifiConfigs(ScanResult scanResult) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (scanResult != null) {
                        _data.writeInt(1);
                        scanResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<OsuProvider> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getMatchingOsuProviders(ScanResult scanResult) throws RemoteException {
                ArrayList<OsuProvider> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (scanResult != null) {
                        _data.writeInt(1);
                        scanResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(OsuProvider.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addOrUpdateNetwork(WifiConfiguration config, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(fqdn);
                    _data.writeString(packageName);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<PasspointConfiguration> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getPasspointConfigurations() throws RemoteException {
                ArrayList<PasspointConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PasspointConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$queryPasspointIcon(long bssid, String fileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeLong(bssid);
                    _data.writeString(fileName);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(fqdn);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$deauthenticateNetwork(long holdoff, boolean ess) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeLong(holdoff);
                    _data.writeInt(ess ? 1 : 0);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$removeNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    _data.writeInt(disableOthers ? 1 : 0);
                    _data.writeString(packageName);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disableNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startScan(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<ScanResult> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getScanResults(String callingPackage) throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(callingPackage);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disconnect(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reconnect(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reassociate(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiInfo $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConnectionInfo(String callingPackage) throws RemoteException {
                WifiInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(callingPackage);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiEnabled(String packageName, boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setCountryCode(String country) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(country);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getCountryCode() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isDualBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$needs5GHzToAnyApBandConversion() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final DhcpInfo $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getDhcpInfo() throws RemoteException {
                DhcpInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DhcpInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isScanAlwaysAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(lock);
                    _data.writeInt(lockType);
                    _data.writeString(tag);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(lock);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseWifiLock(IBinder lock) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(lock);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$initializeMulticastFiltering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isMulticastEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(binder);
                    _data.writeString(tag);
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseMulticastLock() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(ifaceName);
                    _data.writeInt(mode);
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startSoftAp(WifiConfiguration wifiConfig) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopSoftAp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startLocalOnlyHotspot(Messenger messenger, IBinder binder, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(binder);
                    _data.writeString(packageName);
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startWatchLocalOnlyHotspot(Messenger messenger, IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(binder);
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopWatchLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiConfiguration $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApConfiguration() throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$notifyUserOfApBandConversion(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Messenger $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiServiceMessenger(String packageName) throws RemoteException {
                Messenger _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Messenger.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(remoteIPAddress);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(remoteMacAddress);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableVerboseLogging(int verbose) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(verbose);
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getVerboseLoggingLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableWifiConnectivityManager(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(enabled ? 1 : 0);
                    this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(SSID);
                    _data.writeString(packageName);
                    this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$factoryReset(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Network $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getCurrentNetwork() throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final byte[] $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$retrieveBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$restoreBackupData(byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeByteArray(data);
                    this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeByteArray(supplicantData);
                    _data.writeByteArray(ipConfigData);
                    this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (provider != null) {
                        _data.writeInt(1);
                        provider.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$registerSoftApCallback(IBinder binder, ISoftApCallback callback, int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(callbackIdentifier);
                    this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$unregisterSoftApCallback(int callbackIdentifier) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(callbackIdentifier);
                    this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_net_wifi_IWifiManager_Stub_Proxy$__constructor__(iBinder);
            }

            public Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$__constructor__(android.os.IBinder ), this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$asBinder(), this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getInterfaceDescriptor(), this);
            }

            @Override
            public int getSupportedFeatures() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getSupportedFeatures", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getSupportedFeatures(), this);
            }

            @Override
            public WifiActivityEnergyInfo reportActivityInfo() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("reportActivityInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reportActivityInfo(), this);
            }

            @Override
            public void requestActivityInfo(ResultReceiver resultReceiver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("requestActivityInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$requestActivityInfo(android.os.ResultReceiver ), this, resultReceiver);
            }

            @Override
            public ParceledListSlice getConfiguredNetworks() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConfiguredNetworks", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConfiguredNetworks(), this);
            }

            @Override
            public ParceledListSlice getPrivilegedConfiguredNetworks() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPrivilegedConfiguredNetworks", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getPrivilegedConfiguredNetworks(), this);
            }

            @Override
            public WifiConfiguration getMatchingWifiConfig(ScanResult scanResult) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getMatchingWifiConfig", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getMatchingWifiConfig(android.net.wifi.ScanResult ), this, scanResult);
            }

            @Override
            public List<WifiConfiguration> getAllMatchingWifiConfigs(ScanResult scanResult) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getAllMatchingWifiConfigs", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getAllMatchingWifiConfigs(android.net.wifi.ScanResult ), this, scanResult);
            }

            @Override
            public List<OsuProvider> getMatchingOsuProviders(ScanResult scanResult) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getMatchingOsuProviders", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getMatchingOsuProviders(android.net.wifi.ScanResult ), this, scanResult);
            }

            @Override
            public int addOrUpdateNetwork(WifiConfiguration wifiConfiguration, String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("addOrUpdateNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addOrUpdateNetwork(android.net.wifi.WifiConfiguration java.lang.String ), this, wifiConfiguration, string2);
            }

            @Override
            public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration passpointConfiguration, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("addOrUpdatePasspointConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addOrUpdatePasspointConfiguration(android.net.wifi.hotspot2.PasspointConfiguration java.lang.String ), this, passpointConfiguration, string2);
            }

            @Override
            public boolean removePasspointConfiguration(String string2, String string3) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("removePasspointConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$removePasspointConfiguration(java.lang.String java.lang.String ), this, string2, string3);
            }

            @Override
            public List<PasspointConfiguration> getPasspointConfigurations() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPasspointConfigurations", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getPasspointConfigurations(), this);
            }

            @Override
            public void queryPasspointIcon(long l, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("queryPasspointIcon", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$queryPasspointIcon(long java.lang.String ), this, l, string2);
            }

            @Override
            public int matchProviderWithCurrentNetwork(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("matchProviderWithCurrentNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$matchProviderWithCurrentNetwork(java.lang.String ), this, string2);
            }

            @Override
            public void deauthenticateNetwork(long l, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("deauthenticateNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$deauthenticateNetwork(long boolean ), this, l, bl);
            }

            @Override
            public boolean removeNetwork(int n, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("removeNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$removeNetwork(int java.lang.String ), this, n, string2);
            }

            @Override
            public boolean enableNetwork(int n, boolean bl, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("enableNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableNetwork(int boolean java.lang.String ), this, n, bl, string2);
            }

            @Override
            public boolean disableNetwork(int n, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("disableNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disableNetwork(int java.lang.String ), this, n, string2);
            }

            @Override
            public boolean startScan(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startScan(java.lang.String ), this, string2);
            }

            @Override
            public List<ScanResult> getScanResults(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getScanResults", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getScanResults(java.lang.String ), this, string2);
            }

            @Override
            public void disconnect(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disconnect(java.lang.String ), this, string2);
            }

            @Override
            public void reconnect(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reconnect(java.lang.String ), this, string2);
            }

            @Override
            public void reassociate(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("reassociate", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reassociate(java.lang.String ), this, string2);
            }

            @Override
            public WifiInfo getConnectionInfo(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConnectionInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConnectionInfo(java.lang.String ), this, string2);
            }

            @Override
            public boolean setWifiEnabled(String string2, boolean bl) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setWifiEnabled", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiEnabled(java.lang.String boolean ), this, string2, bl);
            }

            @Override
            public int getWifiEnabledState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getWifiEnabledState", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiEnabledState(), this);
            }

            @Override
            public void setCountryCode(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setCountryCode", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setCountryCode(java.lang.String ), this, string2);
            }

            @Override
            public String getCountryCode() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getCountryCode", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getCountryCode(), this);
            }

            @Override
            public boolean isDualBandSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isDualBandSupported", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isDualBandSupported(), this);
            }

            @Override
            public boolean needs5GHzToAnyApBandConversion() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("needs5GHzToAnyApBandConversion", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$needs5GHzToAnyApBandConversion(), this);
            }

            @Override
            public DhcpInfo getDhcpInfo() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDhcpInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getDhcpInfo(), this);
            }

            @Override
            public boolean isScanAlwaysAvailable() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isScanAlwaysAvailable", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isScanAlwaysAvailable(), this);
            }

            @Override
            public boolean acquireWifiLock(IBinder iBinder, int n, String string2, WorkSource workSource) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("acquireWifiLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireWifiLock(android.os.IBinder int java.lang.String android.os.WorkSource ), this, iBinder, n, string2, workSource);
            }

            @Override
            public void updateWifiLockWorkSource(IBinder iBinder, WorkSource workSource) throws RemoteException {
                InvokeDynamicSupport.bootstrap("updateWifiLockWorkSource", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$updateWifiLockWorkSource(android.os.IBinder android.os.WorkSource ), this, iBinder, workSource);
            }

            @Override
            public boolean releaseWifiLock(IBinder iBinder) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("releaseWifiLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseWifiLock(android.os.IBinder ), this, iBinder);
            }

            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                InvokeDynamicSupport.bootstrap("initializeMulticastFiltering", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$initializeMulticastFiltering(), this);
            }

            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isMulticastEnabled", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isMulticastEnabled(), this);
            }

            @Override
            public void acquireMulticastLock(IBinder iBinder, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("acquireMulticastLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireMulticastLock(android.os.IBinder java.lang.String ), this, iBinder, string2);
            }

            @Override
            public void releaseMulticastLock() throws RemoteException {
                InvokeDynamicSupport.bootstrap("releaseMulticastLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseMulticastLock(), this);
            }

            @Override
            public void updateInterfaceIpState(String string2, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("updateInterfaceIpState", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$updateInterfaceIpState(java.lang.String int ), this, string2, n);
            }

            @Override
            public boolean startSoftAp(WifiConfiguration wifiConfiguration) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("startSoftAp", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startSoftAp(android.net.wifi.WifiConfiguration ), this, wifiConfiguration);
            }

            @Override
            public boolean stopSoftAp() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("stopSoftAp", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopSoftAp(), this);
            }

            @Override
            public int startLocalOnlyHotspot(Messenger messenger, IBinder iBinder, String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("startLocalOnlyHotspot", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startLocalOnlyHotspot(android.os.Messenger android.os.IBinder java.lang.String ), this, messenger, iBinder, string2);
            }

            @Override
            public void stopLocalOnlyHotspot() throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopLocalOnlyHotspot", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopLocalOnlyHotspot(), this);
            }

            @Override
            public void startWatchLocalOnlyHotspot(Messenger messenger, IBinder iBinder) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startWatchLocalOnlyHotspot", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startWatchLocalOnlyHotspot(android.os.Messenger android.os.IBinder ), this, messenger, iBinder);
            }

            @Override
            public void stopWatchLocalOnlyHotspot() throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopWatchLocalOnlyHotspot", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopWatchLocalOnlyHotspot(), this);
            }

            @Override
            public int getWifiApEnabledState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getWifiApEnabledState", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApEnabledState(), this);
            }

            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getWifiApConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApConfiguration(), this);
            }

            @Override
            public boolean setWifiApConfiguration(WifiConfiguration wifiConfiguration, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setWifiApConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiApConfiguration(android.net.wifi.WifiConfiguration java.lang.String ), this, wifiConfiguration, string2);
            }

            @Override
            public void notifyUserOfApBandConversion(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("notifyUserOfApBandConversion", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$notifyUserOfApBandConversion(java.lang.String ), this, string2);
            }

            @Override
            public Messenger getWifiServiceMessenger(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getWifiServiceMessenger", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiServiceMessenger(java.lang.String ), this, string2);
            }

            @Override
            public void enableTdls(String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableTdls", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdls(java.lang.String boolean ), this, string2, bl);
            }

            @Override
            public void enableTdlsWithMacAddress(String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableTdlsWithMacAddress", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdlsWithMacAddress(java.lang.String boolean ), this, string2, bl);
            }

            @Override
            public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getCurrentNetworkWpsNfcConfigurationToken", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getCurrentNetworkWpsNfcConfigurationToken(), this);
            }

            @Override
            public void enableVerboseLogging(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableVerboseLogging", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableVerboseLogging(int ), this, n);
            }

            @Override
            public int getVerboseLoggingLevel() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getVerboseLoggingLevel", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getVerboseLoggingLevel(), this);
            }

            @Override
            public void enableWifiConnectivityManager(boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableWifiConnectivityManager", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableWifiConnectivityManager(boolean ), this, bl);
            }

            @Override
            public void disableEphemeralNetwork(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("disableEphemeralNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disableEphemeralNetwork(java.lang.String java.lang.String ), this, string2, string3);
            }

            @Override
            public void factoryReset(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$factoryReset(java.lang.String ), this, string2);
            }

            @Override
            public Network getCurrentNetwork() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getCurrentNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getCurrentNetwork(), this);
            }

            @Override
            public byte[] retrieveBackupData() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("retrieveBackupData", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$retrieveBackupData(), this);
            }

            @Override
            public void restoreBackupData(byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("restoreBackupData", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$restoreBackupData(byte[] ), this, byArray);
            }

            @Override
            public void restoreSupplicantBackupData(byte[] byArray, byte[] byArray2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("restoreSupplicantBackupData", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$restoreSupplicantBackupData(byte[] byte[] ), this, byArray, byArray2);
            }

            @Override
            public void startSubscriptionProvisioning(OsuProvider osuProvider, IProvisioningCallback iProvisioningCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startSubscriptionProvisioning", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startSubscriptionProvisioning(android.net.wifi.hotspot2.OsuProvider android.net.wifi.hotspot2.IProvisioningCallback ), this, osuProvider, iProvisioningCallback);
            }

            @Override
            public void registerSoftApCallback(IBinder iBinder, ISoftApCallback iSoftApCallback, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerSoftApCallback", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$registerSoftApCallback(android.os.IBinder android.net.wifi.ISoftApCallback int ), this, iBinder, iSoftApCallback, n);
            }

            @Override
            public void unregisterSoftApCallback(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterSoftApCallback", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$unregisterSoftApCallback(int ), this, n);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

