/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.MacAddress;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InterfaceParams
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public String name;
    public int index;
    public MacAddress macAddr;
    public int defaultMtu;

    private static final InterfaceParams $$robo$$android_net_util_InterfaceParams$getByName(String name) {
        NetworkInterface netif = InterfaceParams.getNetworkInterfaceByName(name);
        if (netif == null) {
            return null;
        }
        MacAddress macAddr = InterfaceParams.getMacAddress(netif);
        try {
            return new InterfaceParams(name, netif.getIndex(), macAddr, netif.getMTU());
        }
        catch (IllegalArgumentException | SocketException e) {
            return null;
        }
    }

    private void $$robo$$android_net_util_InterfaceParams$__constructor__(String name, int index, MacAddress macAddr) {
    }

    private void $$robo$$android_net_util_InterfaceParams$__constructor__(String name, int index, MacAddress macAddr, int defaultMtu) {
        Preconditions.checkArgument(!TextUtils.isEmpty(name), "impossible interface name");
        Preconditions.checkArgument(index > 0, "invalid interface index");
        this.name = name;
        this.index = index;
        this.macAddr = macAddr != null ? macAddr : MacAddress.ALL_ZEROS_ADDRESS;
        this.defaultMtu = defaultMtu > 1280 ? defaultMtu : 1280;
    }

    private final String $$robo$$android_net_util_InterfaceParams$toString() {
        return String.format("%s/%d/%s/%d", this.name, this.index, this.macAddr, this.defaultMtu);
    }

    private static final NetworkInterface $$robo$$android_net_util_InterfaceParams$getNetworkInterfaceByName(String name) {
        try {
            return NetworkInterface.getByName(name);
        }
        catch (NullPointerException | SocketException e) {
            return null;
        }
    }

    private static final MacAddress $$robo$$android_net_util_InterfaceParams$getMacAddress(NetworkInterface netif) {
        try {
            return MacAddress.fromBytes(netif.getHardwareAddress());
        }
        catch (IllegalArgumentException | NullPointerException | SocketException e) {
            return null;
        }
    }

    public static InterfaceParams getByName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getByName", $$robo$$android_net_util_InterfaceParams$getByName(java.lang.String ), (String)string2);
    }

    private void __constructor__(String string2, int n, MacAddress macAddress) {
        this.$$robo$$android_net_util_InterfaceParams$__constructor__(string2, n, macAddress);
    }

    public InterfaceParams(String string2, int n, MacAddress macAddress) {
        this(string2, n, macAddress, 1500);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_InterfaceParams$__constructor__(java.lang.String int android.net.MacAddress ), this, string2, n, macAddress);
    }

    private void __constructor__(String string2, int n, MacAddress macAddress, int n2) {
        this.$$robo$$android_net_util_InterfaceParams$__constructor__(string2, n, macAddress, n2);
    }

    public InterfaceParams(String string2, int n, MacAddress macAddress, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_InterfaceParams$__constructor__(java.lang.String int android.net.MacAddress int ), this, string2, n, macAddress, n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_util_InterfaceParams$toString(), this);
    }

    private static NetworkInterface getNetworkInterfaceByName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkInterfaceByName", $$robo$$android_net_util_InterfaceParams$getNetworkInterfaceByName(java.lang.String ), (String)string2);
    }

    private static MacAddress getMacAddress(NetworkInterface networkInterface) {
        return InvokeDynamicSupport.bootstrapStatic("getMacAddress", $$robo$$android_net_util_InterfaceParams$getMacAddress(java.net.NetworkInterface ), (NetworkInterface)networkInterface);
    }

    public /* synthetic */ InterfaceParams() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InterfaceParams)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

