/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RouteInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private IpPrefix mDestination;
    private InetAddress mGateway;
    private String mInterface;
    public static int RTN_UNICAST = 1;
    public static int RTN_UNREACHABLE = 7;
    public static int RTN_THROW = 9;
    private int mType;
    private boolean mIsHost;
    private boolean mHasGateway;
    public static Parcelable.Creator<RouteInfo> CREATOR;

    private void $$robo$$android_net_RouteInfo$__constructor__(IpPrefix destination, InetAddress gateway, String iface, int type) {
        switch (type) {
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown route type " + type);
            }
        }
        if (destination == null) {
            if (gateway != null) {
                destination = gateway instanceof Inet4Address ? new IpPrefix(Inet4Address.ANY, 0) : new IpPrefix(Inet6Address.ANY, 0);
            } else {
                throw new IllegalArgumentException("Invalid arguments passed in: " + gateway + "," + destination);
            }
        }
        if (gateway == null) {
            gateway = destination.getAddress() instanceof Inet4Address ? Inet4Address.ANY : Inet6Address.ANY;
        }
        boolean bl = this.mHasGateway = !gateway.isAnyLocalAddress();
        if (destination.getAddress() instanceof Inet4Address && !(gateway instanceof Inet4Address) || destination.getAddress() instanceof Inet6Address && !(gateway instanceof Inet6Address)) {
            throw new IllegalArgumentException("address family mismatch in RouteInfo constructor");
        }
        this.mDestination = destination;
        this.mGateway = gateway;
        this.mInterface = iface;
        this.mType = type;
        this.mIsHost = this.isHost();
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(IpPrefix destination, InetAddress gateway, String iface) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(LinkAddress destination, InetAddress gateway, String iface) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(IpPrefix destination, InetAddress gateway) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(LinkAddress destination, InetAddress gateway) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(InetAddress gateway) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(IpPrefix destination) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(LinkAddress destination) {
    }

    private void $$robo$$android_net_RouteInfo$__constructor__(IpPrefix destination, int type) {
    }

    private static final RouteInfo $$robo$$android_net_RouteInfo$makeHostRoute(InetAddress host, String iface) {
        return RouteInfo.makeHostRoute(host, null, iface);
    }

    private static final RouteInfo $$robo$$android_net_RouteInfo$makeHostRoute(InetAddress host, InetAddress gateway, String iface) {
        if (host == null) {
            return null;
        }
        if (host instanceof Inet4Address) {
            return new RouteInfo(new IpPrefix(host, 32), gateway, iface);
        }
        return new RouteInfo(new IpPrefix(host, 128), gateway, iface);
    }

    private final boolean $$robo$$android_net_RouteInfo$isHost() {
        return this.mDestination.getAddress() instanceof Inet4Address && this.mDestination.getPrefixLength() == 32 || this.mDestination.getAddress() instanceof Inet6Address && this.mDestination.getPrefixLength() == 128;
    }

    private final IpPrefix $$robo$$android_net_RouteInfo$getDestination() {
        return this.mDestination;
    }

    private final LinkAddress $$robo$$android_net_RouteInfo$getDestinationLinkAddress() {
        return new LinkAddress(this.mDestination.getAddress(), this.mDestination.getPrefixLength());
    }

    private final InetAddress $$robo$$android_net_RouteInfo$getGateway() {
        return this.mGateway;
    }

    private final String $$robo$$android_net_RouteInfo$getInterface() {
        return this.mInterface;
    }

    private final int $$robo$$android_net_RouteInfo$getType() {
        return this.mType;
    }

    private final boolean $$robo$$android_net_RouteInfo$isDefaultRoute() {
        return this.mType == 1 && this.mDestination.getPrefixLength() == 0;
    }

    private final boolean $$robo$$android_net_RouteInfo$isIPv4Default() {
        return this.isDefaultRoute() && this.mDestination.getAddress() instanceof Inet4Address;
    }

    private final boolean $$robo$$android_net_RouteInfo$isIPv6Default() {
        return this.isDefaultRoute() && this.mDestination.getAddress() instanceof Inet6Address;
    }

    private final boolean $$robo$$android_net_RouteInfo$isHostRoute() {
        return this.mIsHost;
    }

    private final boolean $$robo$$android_net_RouteInfo$hasGateway() {
        return this.mHasGateway;
    }

    private final boolean $$robo$$android_net_RouteInfo$matches(InetAddress destination) {
        return this.mDestination.contains(destination);
    }

    private static final RouteInfo $$robo$$android_net_RouteInfo$selectBestRoute(Collection<RouteInfo> routes, InetAddress dest) {
        if (routes == null || dest == null) {
            return null;
        }
        RouteInfo bestRoute = null;
        for (RouteInfo route : routes) {
            if (!NetworkUtils.addressTypeMatches(route.mDestination.getAddress(), dest) || bestRoute != null && bestRoute.mDestination.getPrefixLength() >= route.mDestination.getPrefixLength() || !route.matches(dest)) continue;
            bestRoute = route;
        }
        return bestRoute;
    }

    private final String $$robo$$android_net_RouteInfo$toString() {
        String val = "";
        if (this.mDestination != null) {
            val = this.mDestination.toString();
        }
        if (this.mType == 7) {
            val = val + " unreachable";
        } else if (this.mType == 9) {
            val = val + " throw";
        } else {
            val = val + " ->";
            if (this.mGateway != null) {
                val = val + " " + this.mGateway.getHostAddress();
            }
            if (this.mInterface != null) {
                val = val + " " + this.mInterface;
            }
            if (this.mType != 1) {
                val = val + " unknown type " + this.mType;
            }
        }
        return val;
    }

    private final boolean $$robo$$android_net_RouteInfo$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouteInfo)) {
            return false;
        }
        RouteInfo target = (RouteInfo)obj;
        return Objects.equals(this.mDestination, target.getDestination()) && Objects.equals(this.mGateway, target.getGateway()) && Objects.equals(this.mInterface, target.getInterface()) && this.mType == target.getType();
    }

    private final int $$robo$$android_net_RouteInfo$hashCode() {
        return this.mDestination.hashCode() * 41 + (this.mGateway == null ? 0 : this.mGateway.hashCode() * 47) + (this.mInterface == null ? 0 : this.mInterface.hashCode() * 67) + this.mType * 71;
    }

    private final int $$robo$$android_net_RouteInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_RouteInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mDestination, flags);
        byte[] gatewayBytes = this.mGateway == null ? null : this.mGateway.getAddress();
        dest.writeByteArray(gatewayBytes);
        dest.writeString(this.mInterface);
        dest.writeInt(this.mType);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<RouteInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_RouteInfo_1$__constructor__() {
            }

            private final RouteInfo $$robo$$android_net_RouteInfo_1$createFromParcel(Parcel in) {
                IpPrefix dest = (IpPrefix)in.readParcelable(null);
                InetAddress gateway = null;
                byte[] addr = in.createByteArray();
                try {
                    gateway = InetAddress.getByAddress(addr);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                String iface = in.readString();
                int type = in.readInt();
                return new RouteInfo(dest, gateway, iface, type);
            }

            private final RouteInfo[] $$robo$$android_net_RouteInfo_1$newArray(int size) {
                return new RouteInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_RouteInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo_1$__constructor__(), this);
            }

            @Override
            public RouteInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_RouteInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public RouteInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_RouteInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(IpPrefix ipPrefix, InetAddress inetAddress, String string2, int n) {
        this.$$robo$$android_net_RouteInfo$__constructor__(ipPrefix, inetAddress, string2, n);
    }

    public RouteInfo(IpPrefix ipPrefix, InetAddress inetAddress, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.IpPrefix java.net.InetAddress java.lang.String int ), this, ipPrefix, inetAddress, string2, n);
    }

    private void __constructor__(IpPrefix ipPrefix, InetAddress inetAddress, String string2) {
        this.$$robo$$android_net_RouteInfo$__constructor__(ipPrefix, inetAddress, string2);
    }

    public RouteInfo(IpPrefix ipPrefix, InetAddress inetAddress, String string2) {
        this(ipPrefix, inetAddress, string2, 1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.IpPrefix java.net.InetAddress java.lang.String ), this, ipPrefix, inetAddress, string2);
    }

    private void __constructor__(LinkAddress linkAddress, InetAddress inetAddress, String string2) {
        this.$$robo$$android_net_RouteInfo$__constructor__(linkAddress, inetAddress, string2);
    }

    public RouteInfo(LinkAddress linkAddress, InetAddress inetAddress, String string2) {
        this(linkAddress == null ? null : new IpPrefix(linkAddress.getAddress(), linkAddress.getPrefixLength()), inetAddress, string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.LinkAddress java.net.InetAddress java.lang.String ), this, linkAddress, inetAddress, string2);
    }

    private void __constructor__(IpPrefix ipPrefix, InetAddress inetAddress) {
        this.$$robo$$android_net_RouteInfo$__constructor__(ipPrefix, inetAddress);
    }

    public RouteInfo(IpPrefix ipPrefix, InetAddress inetAddress) {
        this(ipPrefix, inetAddress, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.IpPrefix java.net.InetAddress ), this, ipPrefix, inetAddress);
    }

    private void __constructor__(LinkAddress linkAddress, InetAddress inetAddress) {
        this.$$robo$$android_net_RouteInfo$__constructor__(linkAddress, inetAddress);
    }

    public RouteInfo(LinkAddress linkAddress, InetAddress inetAddress) {
        this(linkAddress, inetAddress, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.LinkAddress java.net.InetAddress ), this, linkAddress, inetAddress);
    }

    private void __constructor__(InetAddress inetAddress) {
        this.$$robo$$android_net_RouteInfo$__constructor__(inetAddress);
    }

    public RouteInfo(InetAddress inetAddress) {
        this((IpPrefix)null, inetAddress, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(java.net.InetAddress ), this, inetAddress);
    }

    private void __constructor__(IpPrefix ipPrefix) {
        this.$$robo$$android_net_RouteInfo$__constructor__(ipPrefix);
    }

    public RouteInfo(IpPrefix ipPrefix) {
        this(ipPrefix, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.IpPrefix ), this, ipPrefix);
    }

    private void __constructor__(LinkAddress linkAddress) {
        this.$$robo$$android_net_RouteInfo$__constructor__(linkAddress);
    }

    public RouteInfo(LinkAddress linkAddress) {
        this(linkAddress, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.LinkAddress ), this, linkAddress);
    }

    private void __constructor__(IpPrefix ipPrefix, int n) {
        this.$$robo$$android_net_RouteInfo$__constructor__(ipPrefix, n);
    }

    public RouteInfo(IpPrefix ipPrefix, int n) {
        this(ipPrefix, null, null, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_RouteInfo$__constructor__(android.net.IpPrefix int ), this, ipPrefix, n);
    }

    public static RouteInfo makeHostRoute(InetAddress inetAddress, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeHostRoute", $$robo$$android_net_RouteInfo$makeHostRoute(java.net.InetAddress java.lang.String ), (InetAddress)inetAddress, (String)string2);
    }

    public static RouteInfo makeHostRoute(InetAddress inetAddress, InetAddress inetAddress2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeHostRoute", $$robo$$android_net_RouteInfo$makeHostRoute(java.net.InetAddress java.net.InetAddress java.lang.String ), (InetAddress)inetAddress, (InetAddress)inetAddress2, (String)string2);
    }

    private boolean isHost() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHost", $$robo$$android_net_RouteInfo$isHost(), this);
    }

    public IpPrefix getDestination() {
        return InvokeDynamicSupport.bootstrap("getDestination", $$robo$$android_net_RouteInfo$getDestination(), this);
    }

    public LinkAddress getDestinationLinkAddress() {
        return InvokeDynamicSupport.bootstrap("getDestinationLinkAddress", $$robo$$android_net_RouteInfo$getDestinationLinkAddress(), this);
    }

    public InetAddress getGateway() {
        return InvokeDynamicSupport.bootstrap("getGateway", $$robo$$android_net_RouteInfo$getGateway(), this);
    }

    public String getInterface() {
        return InvokeDynamicSupport.bootstrap("getInterface", $$robo$$android_net_RouteInfo$getInterface(), this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_net_RouteInfo$getType(), this);
    }

    public boolean isDefaultRoute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultRoute", $$robo$$android_net_RouteInfo$isDefaultRoute(), this);
    }

    public boolean isIPv4Default() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv4Default", $$robo$$android_net_RouteInfo$isIPv4Default(), this);
    }

    public boolean isIPv6Default() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv6Default", $$robo$$android_net_RouteInfo$isIPv6Default(), this);
    }

    public boolean isHostRoute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHostRoute", $$robo$$android_net_RouteInfo$isHostRoute(), this);
    }

    public boolean hasGateway() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasGateway", $$robo$$android_net_RouteInfo$hasGateway(), this);
    }

    public boolean matches(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_net_RouteInfo$matches(java.net.InetAddress ), this, inetAddress);
    }

    public static RouteInfo selectBestRoute(Collection<RouteInfo> collection, InetAddress inetAddress) {
        return InvokeDynamicSupport.bootstrapStatic("selectBestRoute", $$robo$$android_net_RouteInfo$selectBestRoute(java.util.Collection<android.net.RouteInfo> java.net.InetAddress ), collection, (InetAddress)inetAddress);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_RouteInfo$toString(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_RouteInfo$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_RouteInfo$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_RouteInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_RouteInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(RouteInfo.class);
    }

    public /* synthetic */ RouteInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

