/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpPrefix;
import android.os.Parcel;
import android.util.Log;
import android.util.Pair;
import java.io.FileDescriptor;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkUtils";

    private void $$robo$$android_net_NetworkUtils$__constructor__() {
    }

    private static final void $$robo$$android_net_NetworkUtils$attachDhcpFilter(FileDescriptor fileDescriptor) throws SocketException {
    }

    private static final void $$robo$$android_net_NetworkUtils$attachRaFilter(FileDescriptor fileDescriptor, int n) throws SocketException {
    }

    private static final void $$robo$$android_net_NetworkUtils$attachControlPacketFilter(FileDescriptor fileDescriptor, int n) throws SocketException {
    }

    private static final void $$robo$$android_net_NetworkUtils$setupRaSocket(FileDescriptor fileDescriptor, int n) throws SocketException {
    }

    private static final boolean $$robo$$android_net_NetworkUtils$bindProcessToNetwork(int n) {
        return false;
    }

    private static final int $$robo$$android_net_NetworkUtils$getBoundNetworkForProcess() {
        return 0;
    }

    @Deprecated
    private static final boolean $$robo$$android_net_NetworkUtils$bindProcessToNetworkForHostResolution(int n) {
        return false;
    }

    private static final int $$robo$$android_net_NetworkUtils$bindSocketToNetwork(int n, int n2) {
        return 0;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$protectFromVpn(FileDescriptor fd) {
        return NetworkUtils.protectFromVpn(fd.getInt$());
    }

    private static final boolean $$robo$$android_net_NetworkUtils$protectFromVpn(int n) {
        return false;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$queryUserAccess(int n, int n2) {
        return false;
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    private static final int $$robo$$android_net_NetworkUtils$inetAddressToInt(Inet4Address inetAddr) throws IllegalArgumentException {
        byte[] addr = inetAddr.getAddress();
        return (addr[3] & 0xFF) << 24 | (addr[2] & 0xFF) << 16 | (addr[1] & 0xFF) << 8 | addr[0] & 0xFF;
    }

    private static final int $$robo$$android_net_NetworkUtils$prefixLengthToNetmaskInt(int prefixLength) throws IllegalArgumentException {
        if (prefixLength < 0 || prefixLength > 32) {
            throw new IllegalArgumentException("Invalid prefix length (0 <= prefix <= 32)");
        }
        int value = -1 << 32 - prefixLength;
        return Integer.reverseBytes(value);
    }

    private static final int $$robo$$android_net_NetworkUtils$netmaskIntToPrefixLength(int netmask) {
        return Integer.bitCount(netmask);
    }

    private static final int $$robo$$android_net_NetworkUtils$netmaskToPrefixLength(Inet4Address netmask) {
        int i = Integer.reverseBytes(NetworkUtils.inetAddressToInt(netmask));
        int prefixLength = Integer.bitCount(i);
        int trailingZeros = Integer.numberOfTrailingZeros(i);
        if (trailingZeros != 32 - prefixLength) {
            throw new IllegalArgumentException("Non-contiguous netmask: " + Integer.toHexString(i));
        }
        return prefixLength;
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$numericToInetAddress(String addrString) throws IllegalArgumentException {
        return InetAddress.parseNumericAddress((String)addrString);
    }

    private static final void $$robo$$android_net_NetworkUtils$parcelInetAddress(Parcel parcel, InetAddress address, int flags) {
        byte[] addressArray = address != null ? address.getAddress() : null;
        parcel.writeByteArray(addressArray);
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$unparcelInetAddress(Parcel in) {
        byte[] addressArray = in.createByteArray();
        if (addressArray == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(addressArray);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static final void $$robo$$android_net_NetworkUtils$maskRawAddress(byte[] array2, int prefixLength) {
        if (prefixLength < 0 || prefixLength > array2.length * 8) {
            throw new RuntimeException("IP address with " + array2.length + " bytes has invalid prefix length " + prefixLength);
        }
        int offset = prefixLength / 8;
        int remainder = prefixLength % 8;
        byte mask = (byte)(255 << 8 - remainder);
        if (offset < array2.length) {
            array2[offset] = (byte)(array2[offset] & mask);
        }
        ++offset;
        while (offset < array2.length) {
            array2[offset] = 0;
            ++offset;
        }
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$getNetworkPart(InetAddress address, int prefixLength) {
        byte[] array2 = address.getAddress();
        NetworkUtils.maskRawAddress(array2, prefixLength);
        InetAddress netPart = null;
        try {
            netPart = InetAddress.getByAddress(array2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("getNetworkPart error - " + e.toString());
        }
        return netPart;
    }

    private static final int $$robo$$android_net_NetworkUtils$getImplicitNetmask(Inet4Address address) {
        int firstByte = address.getAddress()[0] & 0xFF;
        if (firstByte < 128) {
            return 8;
        }
        if (firstByte < 192) {
            return 16;
        }
        if (firstByte < 224) {
            return 24;
        }
        return 32;
    }

    private static final Pair<InetAddress, Integer> $$robo$$android_net_NetworkUtils$parseIpAndMask(String ipAndMaskString) {
        InetAddress address = null;
        int prefixLength = -1;
        try {
            String[] pieces = ipAndMaskString.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            address = InetAddress.parseNumericAddress((String)pieces[0]);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (address == null || prefixLength == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + ipAndMaskString);
        }
        return new Pair<Object, Integer>(address, prefixLength);
    }

    private static final boolean $$robo$$android_net_NetworkUtils$addressTypeMatches(InetAddress left, InetAddress right) {
        return left instanceof Inet4Address && right instanceof Inet4Address || left instanceof Inet6Address && right instanceof Inet6Address;
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$hexToInet6Address(String addrHexString) throws IllegalArgumentException {
        try {
            return NetworkUtils.numericToInetAddress(String.format(Locale.US, "%s:%s:%s:%s:%s:%s:%s:%s", addrHexString.substring(0, 4), addrHexString.substring(4, 8), addrHexString.substring(8, 12), addrHexString.substring(12, 16), addrHexString.substring(16, 20), addrHexString.substring(20, 24), addrHexString.substring(24, 28), addrHexString.substring(28, 32)));
        }
        catch (Exception e) {
            Log.e("NetworkUtils", "error in hexToInet6Address(" + addrHexString + "): " + e);
            throw new IllegalArgumentException(e);
        }
    }

    private static final String[] $$robo$$android_net_NetworkUtils$makeStrings(Collection<InetAddress> addrs) {
        String[] result = new String[addrs.size()];
        int i = 0;
        for (InetAddress addr : addrs) {
            result[i++] = addr.getHostAddress();
        }
        return result;
    }

    private static final String $$robo$$android_net_NetworkUtils$trimV4AddrZeros(String addr) {
        if (addr == null) {
            return null;
        }
        String[] octets = addr.split("\\.");
        if (octets.length != 4) {
            return addr;
        }
        StringBuilder builder = new StringBuilder(16);
        String result = null;
        for (int i = 0; i < 4; ++i) {
            try {
                if (octets[i].length() > 3) {
                    return addr;
                }
                builder.append(Integer.parseInt(octets[i]));
            }
            catch (NumberFormatException e) {
                return addr;
            }
            if (i >= 3) continue;
            builder.append('.');
        }
        result = builder.toString();
        return result;
    }

    private static final TreeSet<IpPrefix> $$robo$$android_net_NetworkUtils$deduplicatePrefixSet(TreeSet<IpPrefix> src) {
        TreeSet<IpPrefix> dst = new TreeSet<IpPrefix>(src.comparator());
        block0: for (IpPrefix newPrefix : src) {
            for (IpPrefix existingPrefix : dst) {
                if (!existingPrefix.containsPrefix(newPrefix)) continue;
                continue block0;
            }
            dst.add(newPrefix);
        }
        return dst;
    }

    private static final long $$robo$$android_net_NetworkUtils$routedIPv4AddressCount(TreeSet<IpPrefix> prefixes) {
        long routedIPCount = 0L;
        for (IpPrefix prefix : NetworkUtils.deduplicatePrefixSet(prefixes)) {
            if (!prefix.isIPv4()) {
                Log.wtf("NetworkUtils", "Non-IPv4 prefix in routedIPv4AddressCount");
            }
            int rank = 32 - prefix.getPrefixLength();
            routedIPCount += 1L << rank;
        }
        return routedIPCount;
    }

    private static final BigInteger $$robo$$android_net_NetworkUtils$routedIPv6AddressCount(TreeSet<IpPrefix> prefixes) {
        BigInteger routedIPCount = BigInteger.ZERO;
        for (IpPrefix prefix : NetworkUtils.deduplicatePrefixSet(prefixes)) {
            if (!prefix.isIPv6()) {
                Log.wtf("NetworkUtils", "Non-IPv6 prefix in routedIPv6AddressCount");
            }
            int rank = 128 - prefix.getPrefixLength();
            routedIPCount = routedIPCount.add(BigInteger.ONE.shiftLeft(rank));
        }
        return routedIPCount;
    }

    private void __constructor__() {
        this.$$robo$$android_net_NetworkUtils$__constructor__();
    }

    public NetworkUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkUtils$__constructor__(), this);
    }

    public static void attachDhcpFilter(FileDescriptor fileDescriptor) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("attachDhcpFilter", $$robo$$android_net_NetworkUtils$attachDhcpFilter(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public static void attachRaFilter(FileDescriptor fileDescriptor, int n) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("attachRaFilter", $$robo$$android_net_NetworkUtils$attachRaFilter(java.io.FileDescriptor int ), (FileDescriptor)fileDescriptor, (int)n);
    }

    public static void attachControlPacketFilter(FileDescriptor fileDescriptor, int n) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("attachControlPacketFilter", $$robo$$android_net_NetworkUtils$attachControlPacketFilter(java.io.FileDescriptor int ), (FileDescriptor)fileDescriptor, (int)n);
    }

    public static void setupRaSocket(FileDescriptor fileDescriptor, int n) throws SocketException {
        InvokeDynamicSupport.bootstrapStatic("setupRaSocket", $$robo$$android_net_NetworkUtils$setupRaSocket(java.io.FileDescriptor int ), (FileDescriptor)fileDescriptor, (int)n);
    }

    public static boolean bindProcessToNetwork(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("bindProcessToNetwork", $$robo$$android_net_NetworkUtils$bindProcessToNetwork(int ), (int)n);
    }

    public static int getBoundNetworkForProcess() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBoundNetworkForProcess", $$robo$$android_net_NetworkUtils$getBoundNetworkForProcess());
    }

    @Deprecated
    public static boolean bindProcessToNetworkForHostResolution(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("bindProcessToNetworkForHostResolution", $$robo$$android_net_NetworkUtils$bindProcessToNetworkForHostResolution(int ), (int)n);
    }

    public static int bindSocketToNetwork(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bindSocketToNetwork", $$robo$$android_net_NetworkUtils$bindSocketToNetwork(int int ), (int)n, (int)n2);
    }

    public static boolean protectFromVpn(FileDescriptor fileDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("protectFromVpn", $$robo$$android_net_NetworkUtils$protectFromVpn(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public static boolean protectFromVpn(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("protectFromVpn", $$robo$$android_net_NetworkUtils$protectFromVpn(int ), (int)n);
    }

    public static boolean queryUserAccess(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("queryUserAccess", $$robo$$android_net_NetworkUtils$queryUserAccess(int int ), (int)n, (int)n2);
    }

    public static InetAddress intToInetAddress(int n) {
        return InvokeDynamicSupport.bootstrapStatic("intToInetAddress", $$robo$$android_net_NetworkUtils$intToInetAddress(int ), (int)n);
    }

    public static int inetAddressToInt(Inet4Address inet4Address) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("inetAddressToInt", $$robo$$android_net_NetworkUtils$inetAddressToInt(java.net.Inet4Address ), (Inet4Address)inet4Address);
    }

    public static int prefixLengthToNetmaskInt(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("prefixLengthToNetmaskInt", $$robo$$android_net_NetworkUtils$prefixLengthToNetmaskInt(int ), (int)n);
    }

    public static int netmaskIntToPrefixLength(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("netmaskIntToPrefixLength", $$robo$$android_net_NetworkUtils$netmaskIntToPrefixLength(int ), (int)n);
    }

    public static int netmaskToPrefixLength(Inet4Address inet4Address) {
        return (int)InvokeDynamicSupport.bootstrapStatic("netmaskToPrefixLength", $$robo$$android_net_NetworkUtils$netmaskToPrefixLength(java.net.Inet4Address ), (Inet4Address)inet4Address);
    }

    public static InetAddress numericToInetAddress(String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("numericToInetAddress", $$robo$$android_net_NetworkUtils$numericToInetAddress(java.lang.String ), (String)string2);
    }

    protected static void parcelInetAddress(Parcel parcel, InetAddress inetAddress, int n) {
        InvokeDynamicSupport.bootstrapStatic("parcelInetAddress", $$robo$$android_net_NetworkUtils$parcelInetAddress(android.os.Parcel java.net.InetAddress int ), (Parcel)parcel, (InetAddress)inetAddress, (int)n);
    }

    protected static InetAddress unparcelInetAddress(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("unparcelInetAddress", $$robo$$android_net_NetworkUtils$unparcelInetAddress(android.os.Parcel ), (Parcel)parcel);
    }

    public static void maskRawAddress(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("maskRawAddress", $$robo$$android_net_NetworkUtils$maskRawAddress(byte[] int ), (byte[])byArray, (int)n);
    }

    public static InetAddress getNetworkPart(InetAddress inetAddress, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkPart", $$robo$$android_net_NetworkUtils$getNetworkPart(java.net.InetAddress int ), (InetAddress)inetAddress, (int)n);
    }

    public static int getImplicitNetmask(Inet4Address inet4Address) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getImplicitNetmask", $$robo$$android_net_NetworkUtils$getImplicitNetmask(java.net.Inet4Address ), (Inet4Address)inet4Address);
    }

    public static Pair<InetAddress, Integer> parseIpAndMask(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseIpAndMask", $$robo$$android_net_NetworkUtils$parseIpAndMask(java.lang.String ), (String)string2);
    }

    public static boolean addressTypeMatches(InetAddress inetAddress, InetAddress inetAddress2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("addressTypeMatches", $$robo$$android_net_NetworkUtils$addressTypeMatches(java.net.InetAddress java.net.InetAddress ), (InetAddress)inetAddress, (InetAddress)inetAddress2);
    }

    public static InetAddress hexToInet6Address(String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("hexToInet6Address", $$robo$$android_net_NetworkUtils$hexToInet6Address(java.lang.String ), (String)string2);
    }

    public static String[] makeStrings(Collection<InetAddress> collection) {
        return InvokeDynamicSupport.bootstrapStatic("makeStrings", $$robo$$android_net_NetworkUtils$makeStrings(java.util.Collection<java.net.InetAddress> ), collection);
    }

    public static String trimV4AddrZeros(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("trimV4AddrZeros", $$robo$$android_net_NetworkUtils$trimV4AddrZeros(java.lang.String ), (String)string2);
    }

    private static TreeSet<IpPrefix> deduplicatePrefixSet(TreeSet<IpPrefix> treeSet) {
        return InvokeDynamicSupport.bootstrapStatic("deduplicatePrefixSet", $$robo$$android_net_NetworkUtils$deduplicatePrefixSet(java.util.TreeSet<android.net.IpPrefix> ), treeSet);
    }

    public static long routedIPv4AddressCount(TreeSet<IpPrefix> treeSet) {
        return (long)InvokeDynamicSupport.bootstrapStatic("routedIPv4AddressCount", $$robo$$android_net_NetworkUtils$routedIPv4AddressCount(java.util.TreeSet<android.net.IpPrefix> ), treeSet);
    }

    public static BigInteger routedIPv6AddressCount(TreeSet<IpPrefix> treeSet) {
        return InvokeDynamicSupport.bootstrapStatic("routedIPv6AddressCount", $$robo$$android_net_NetworkUtils$routedIPv6AddressCount(java.util.TreeSet<android.net.IpPrefix> ), treeSet);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

