/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.NetworkPolicy;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.DebugUtils;
import android.util.Pair;
import android.util.Range;
import java.time.ZonedDateTime;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkPolicyManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int POLICY_NONE = 0;
    public static int POLICY_REJECT_METERED_BACKGROUND = 1;
    public static int POLICY_ALLOW_METERED_BACKGROUND = 4;
    public static int RULE_NONE = 0;
    public static int RULE_ALLOW_METERED = 1;
    public static int RULE_TEMPORARY_ALLOW_METERED = 2;
    public static int RULE_REJECT_METERED = 4;
    public static int RULE_ALLOW_ALL = 32;
    public static int RULE_REJECT_ALL = 64;
    public static int MASK_METERED_NETWORKS = 15;
    public static int MASK_ALL_NETWORKS = 240;
    public static int FIREWALL_RULE_DEFAULT = 0;
    public static int FIREWALL_RULE_ALLOW = 1;
    public static int FIREWALL_RULE_DENY = 2;
    public static int FIREWALL_TYPE_WHITELIST = 0;
    public static int FIREWALL_TYPE_BLACKLIST = 1;
    public static int FIREWALL_CHAIN_NONE = 0;
    public static int FIREWALL_CHAIN_DOZABLE = 1;
    public static int FIREWALL_CHAIN_STANDBY = 2;
    public static int FIREWALL_CHAIN_POWERSAVE = 3;
    public static String FIREWALL_CHAIN_NAME_NONE = "none";
    public static String FIREWALL_CHAIN_NAME_DOZABLE = "dozable";
    public static String FIREWALL_CHAIN_NAME_STANDBY = "standby";
    public static String FIREWALL_CHAIN_NAME_POWERSAVE = "powersave";
    private static boolean ALLOW_PLATFORM_APP_POLICY = true;
    public static int FOREGROUND_THRESHOLD_STATE = 4;
    public static String EXTRA_NETWORK_TEMPLATE = "android.net.NETWORK_TEMPLATE";
    public static int OVERRIDE_UNMETERED = 1;
    public static int OVERRIDE_CONGESTED = 2;
    private Context mContext;
    private INetworkPolicyManager mService;

    private void $$robo$$android_net_NetworkPolicyManager$__constructor__(Context context, INetworkPolicyManager service) {
        if (service == null) {
            throw new IllegalArgumentException("missing INetworkPolicyManager");
        }
        this.mContext = context;
        this.mService = service;
    }

    private static final NetworkPolicyManager $$robo$$android_net_NetworkPolicyManager$from(Context context) {
        return (NetworkPolicyManager)context.getSystemService("netpolicy");
    }

    private final void $$robo$$android_net_NetworkPolicyManager$setUidPolicy(int uid, int policy) {
        try {
            this.mService.setUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$addUidPolicy(int uid, int policy) {
        try {
            this.mService.addUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$removeUidPolicy(int uid, int policy) {
        try {
            this.mService.removeUidPolicy(uid, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_NetworkPolicyManager$getUidPolicy(int uid) {
        try {
            return this.mService.getUidPolicy(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int[] $$robo$$android_net_NetworkPolicyManager$getUidsWithPolicy(int policy) {
        try {
            return this.mService.getUidsWithPolicy(policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$registerListener(INetworkPolicyListener listener) {
        try {
            this.mService.registerListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$unregisterListener(INetworkPolicyListener listener) {
        try {
            this.mService.unregisterListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$setNetworkPolicies(NetworkPolicy[] policies) {
        try {
            this.mService.setNetworkPolicies(policies);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NetworkPolicy[] $$robo$$android_net_NetworkPolicyManager$getNetworkPolicies() {
        try {
            return this.mService.getNetworkPolicies(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$setRestrictBackground(boolean restrictBackground) {
        try {
            this.mService.setRestrictBackground(restrictBackground);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_NetworkPolicyManager$getRestrictBackground() {
        try {
            return this.mService.getRestrictBackground();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_NetworkPolicyManager$factoryReset(String subscriber) {
        try {
            this.mService.factoryReset(subscriber);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private static final Iterator<Pair<ZonedDateTime, ZonedDateTime>> $$robo$$android_net_NetworkPolicyManager$cycleIterator(NetworkPolicy policy) {
        Iterator<Range<ZonedDateTime>> it = policy.cycleIterator();
        return new Iterator<Pair<ZonedDateTime, ZonedDateTime>>(it){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Iterator val$it;

            private void $$robo$$android_net_NetworkPolicyManager_1$__constructor__(Iterator iterator) {
                this.val$it = iterator;
            }

            private final boolean $$robo$$android_net_NetworkPolicyManager_1$hasNext() {
                return this.val$it.hasNext();
            }

            private final Pair<ZonedDateTime, ZonedDateTime> $$robo$$android_net_NetworkPolicyManager_1$next() {
                if (this.hasNext()) {
                    Range r = (Range)this.val$it.next();
                    return Pair.create((ZonedDateTime)r.getLower(), (ZonedDateTime)r.getUpper());
                }
                return Pair.create(null, null);
            }

            private void __constructor__(Iterator iterator) {
                this.$$robo$$android_net_NetworkPolicyManager_1$__constructor__(iterator);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicyManager_1$__constructor__(java.util.Iterator ), this, iterator);
            }

            @Override
            public boolean hasNext() {
                return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_net_NetworkPolicyManager_1$hasNext(), this);
            }

            @Override
            public Pair<ZonedDateTime, ZonedDateTime> next() {
                return InvokeDynamicSupport.bootstrap("next", $$robo$$android_net_NetworkPolicyManager_1$next(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    @Deprecated
    private static final boolean $$robo$$android_net_NetworkPolicyManager$isUidValidForPolicy(Context context, int uid) {
        return UserHandle.isApp(uid);
    }

    private static final String $$robo$$android_net_NetworkPolicyManager$uidRulesToString(int uidRules) {
        StringBuilder string2 = new StringBuilder().append(uidRules).append(" (");
        if (uidRules == 0) {
            string2.append("NONE");
        } else {
            string2.append(DebugUtils.flagsToString(NetworkPolicyManager.class, "RULE_", uidRules));
        }
        string2.append(")");
        return string2.toString();
    }

    private static final String $$robo$$android_net_NetworkPolicyManager$uidPoliciesToString(int uidPolicies) {
        StringBuilder string2 = new StringBuilder().append(uidPolicies).append(" (");
        if (uidPolicies == 0) {
            string2.append("NONE");
        } else {
            string2.append(DebugUtils.flagsToString(NetworkPolicyManager.class, "POLICY_", uidPolicies));
        }
        string2.append(")");
        return string2.toString();
    }

    private static final boolean $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileIdleOrPowerSaveMode(int procState) {
        return procState <= 4;
    }

    private static final boolean $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileOnRestrictBackground(int procState) {
        return procState <= 4;
    }

    private static final String $$robo$$android_net_NetworkPolicyManager$resolveNetworkId(WifiConfiguration config) {
        return WifiInfo.removeDoubleQuotes(config.isPasspoint() ? config.providerFriendlyName : config.SSID);
    }

    private static final String $$robo$$android_net_NetworkPolicyManager$resolveNetworkId(String ssid) {
        return WifiInfo.removeDoubleQuotes(ssid);
    }

    private void __constructor__(Context context, INetworkPolicyManager iNetworkPolicyManager) {
        this.$$robo$$android_net_NetworkPolicyManager$__constructor__(context, iNetworkPolicyManager);
    }

    public NetworkPolicyManager(Context context, INetworkPolicyManager iNetworkPolicyManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicyManager$__constructor__(android.content.Context android.net.INetworkPolicyManager ), this, context, iNetworkPolicyManager);
    }

    public static NetworkPolicyManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_net_NetworkPolicyManager$from(android.content.Context ), (Context)context);
    }

    public void setUidPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setUidPolicy", $$robo$$android_net_NetworkPolicyManager$setUidPolicy(int int ), this, n, n2);
    }

    public void addUidPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("addUidPolicy", $$robo$$android_net_NetworkPolicyManager$addUidPolicy(int int ), this, n, n2);
    }

    public void removeUidPolicy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidPolicy", $$robo$$android_net_NetworkPolicyManager$removeUidPolicy(int int ), this, n, n2);
    }

    public int getUidPolicy(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUidPolicy", $$robo$$android_net_NetworkPolicyManager$getUidPolicy(int ), this, n);
    }

    public int[] getUidsWithPolicy(int n) {
        return InvokeDynamicSupport.bootstrap("getUidsWithPolicy", $$robo$$android_net_NetworkPolicyManager$getUidsWithPolicy(int ), this, n);
    }

    public void registerListener(INetworkPolicyListener iNetworkPolicyListener) {
        InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_net_NetworkPolicyManager$registerListener(android.net.INetworkPolicyListener ), this, iNetworkPolicyListener);
    }

    public void unregisterListener(INetworkPolicyListener iNetworkPolicyListener) {
        InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_net_NetworkPolicyManager$unregisterListener(android.net.INetworkPolicyListener ), this, iNetworkPolicyListener);
    }

    public void setNetworkPolicies(NetworkPolicy[] networkPolicyArray) {
        InvokeDynamicSupport.bootstrap("setNetworkPolicies", $$robo$$android_net_NetworkPolicyManager$setNetworkPolicies(android.net.NetworkPolicy[] ), this, networkPolicyArray);
    }

    public NetworkPolicy[] getNetworkPolicies() {
        return InvokeDynamicSupport.bootstrap("getNetworkPolicies", $$robo$$android_net_NetworkPolicyManager$getNetworkPolicies(), this);
    }

    public void setRestrictBackground(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRestrictBackground", $$robo$$android_net_NetworkPolicyManager$setRestrictBackground(boolean ), this, bl);
    }

    public boolean getRestrictBackground() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRestrictBackground", $$robo$$android_net_NetworkPolicyManager$getRestrictBackground(), this);
    }

    public void factoryReset(String string2) {
        InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_net_NetworkPolicyManager$factoryReset(java.lang.String ), this, string2);
    }

    @Deprecated
    public static Iterator<Pair<ZonedDateTime, ZonedDateTime>> cycleIterator(NetworkPolicy networkPolicy) {
        return InvokeDynamicSupport.bootstrapStatic("cycleIterator", $$robo$$android_net_NetworkPolicyManager$cycleIterator(android.net.NetworkPolicy ), (NetworkPolicy)networkPolicy);
    }

    @Deprecated
    public static boolean isUidValidForPolicy(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUidValidForPolicy", $$robo$$android_net_NetworkPolicyManager$isUidValidForPolicy(android.content.Context int ), (Context)context, (int)n);
    }

    public static String uidRulesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("uidRulesToString", $$robo$$android_net_NetworkPolicyManager$uidRulesToString(int ), (int)n);
    }

    public static String uidPoliciesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("uidPoliciesToString", $$robo$$android_net_NetworkPolicyManager$uidPoliciesToString(int ), (int)n);
    }

    public static boolean isProcStateAllowedWhileIdleOrPowerSaveMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProcStateAllowedWhileIdleOrPowerSaveMode", $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileIdleOrPowerSaveMode(int ), (int)n);
    }

    public static boolean isProcStateAllowedWhileOnRestrictBackground(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProcStateAllowedWhileOnRestrictBackground", $$robo$$android_net_NetworkPolicyManager$isProcStateAllowedWhileOnRestrictBackground(int ), (int)n);
    }

    public static String resolveNetworkId(WifiConfiguration wifiConfiguration) {
        return InvokeDynamicSupport.bootstrapStatic("resolveNetworkId", $$robo$$android_net_NetworkPolicyManager$resolveNetworkId(android.net.wifi.WifiConfiguration ), (WifiConfiguration)wifiConfiguration);
    }

    public static String resolveNetworkId(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("resolveNetworkId", $$robo$$android_net_NetworkPolicyManager$resolveNetworkId(java.lang.String ), (String)string2);
    }

    public /* synthetic */ NetworkPolicyManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkPolicyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Listener
    extends INetworkPolicyListener.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_NetworkPolicyManager_Listener$__constructor__() {
        }

        private final void $$robo$$android_net_NetworkPolicyManager_Listener$onUidRulesChanged(int uid, int uidRules) {
        }

        private final void $$robo$$android_net_NetworkPolicyManager_Listener$onMeteredIfacesChanged(String[] meteredIfaces) {
        }

        private final void $$robo$$android_net_NetworkPolicyManager_Listener$onRestrictBackgroundChanged(boolean restrictBackground) {
        }

        private final void $$robo$$android_net_NetworkPolicyManager_Listener$onUidPoliciesChanged(int uid, int uidPolicies) {
        }

        private final void $$robo$$android_net_NetworkPolicyManager_Listener$onSubscriptionOverride(int subId, int overrideMask, int overrideValue) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_NetworkPolicyManager_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicyManager_Listener$__constructor__(), this);
        }

        @Override
        public void onUidRulesChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onUidRulesChanged", $$robo$$android_net_NetworkPolicyManager_Listener$onUidRulesChanged(int int ), this, n, n2);
        }

        @Override
        public void onMeteredIfacesChanged(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("onMeteredIfacesChanged", $$robo$$android_net_NetworkPolicyManager_Listener$onMeteredIfacesChanged(java.lang.String[] ), this, stringArray);
        }

        @Override
        public void onRestrictBackgroundChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onRestrictBackgroundChanged", $$robo$$android_net_NetworkPolicyManager_Listener$onRestrictBackgroundChanged(boolean ), this, bl);
        }

        @Override
        public void onUidPoliciesChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onUidPoliciesChanged", $$robo$$android_net_NetworkPolicyManager_Listener$onUidPoliciesChanged(int int ), this, n, n2);
        }

        @Override
        public void onSubscriptionOverride(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onSubscriptionOverride", $$robo$$android_net_NetworkPolicyManager_Listener$onSubscriptionOverride(int int int ), this, n, n2, n3);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

