/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkTemplate;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.BackupUtils;
import android.util.Range;
import android.util.RecurrenceRule;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class NetworkPolicy
implements Parcelable,
Comparable<NetworkPolicy> {
    public /* synthetic */ Object __robo_data__;
    private static int VERSION_INIT = 1;
    private static int VERSION_RULE = 2;
    private static int VERSION_RAPID = 3;
    public static int CYCLE_NONE = -1;
    public static long WARNING_DISABLED = -1L;
    public static long LIMIT_DISABLED = -1L;
    public static long SNOOZE_NEVER = -1L;
    public NetworkTemplate template;
    public RecurrenceRule cycleRule;
    public long warningBytes;
    public long limitBytes;
    public long lastWarningSnooze;
    public long lastLimitSnooze;
    public long lastRapidSnooze;
    @Deprecated
    public boolean metered;
    public boolean inferred;
    private static long DEFAULT_MTU = 1500L;
    public static Parcelable.Creator<NetworkPolicy> CREATOR;

    private static final RecurrenceRule $$robo$$android_net_NetworkPolicy$buildRule(int cycleDay, ZoneId cycleTimezone) {
        if (cycleDay != -1) {
            return RecurrenceRule.buildRecurringMonthly(cycleDay, cycleTimezone);
        }
        return RecurrenceRule.buildNever();
    }

    @Deprecated
    private void $$robo$$android_net_NetworkPolicy$__constructor__(NetworkTemplate template, int cycleDay, String cycleTimezone, long warningBytes, long limitBytes, boolean metered) {
    }

    @Deprecated
    private void $$robo$$android_net_NetworkPolicy$__constructor__(NetworkTemplate template, int cycleDay, String cycleTimezone, long warningBytes, long limitBytes, long lastWarningSnooze, long lastLimitSnooze, boolean metered, boolean inferred) {
    }

    @Deprecated
    private void $$robo$$android_net_NetworkPolicy$__constructor__(NetworkTemplate template, RecurrenceRule cycleRule, long warningBytes, long limitBytes, long lastWarningSnooze, long lastLimitSnooze, boolean metered, boolean inferred) {
    }

    private void $$robo$$android_net_NetworkPolicy$__constructor__(NetworkTemplate template, RecurrenceRule cycleRule, long warningBytes, long limitBytes, long lastWarningSnooze, long lastLimitSnooze, long lastRapidSnooze, boolean metered, boolean inferred) {
        this.warningBytes = -1L;
        this.limitBytes = -1L;
        this.lastWarningSnooze = -1L;
        this.lastLimitSnooze = -1L;
        this.lastRapidSnooze = -1L;
        this.metered = true;
        this.inferred = false;
        this.template = Preconditions.checkNotNull(template, "missing NetworkTemplate");
        this.cycleRule = Preconditions.checkNotNull(cycleRule, "missing RecurrenceRule");
        this.warningBytes = warningBytes;
        this.limitBytes = limitBytes;
        this.lastWarningSnooze = lastWarningSnooze;
        this.lastLimitSnooze = lastLimitSnooze;
        this.lastRapidSnooze = lastRapidSnooze;
        this.metered = metered;
        this.inferred = inferred;
    }

    private void $$robo$$android_net_NetworkPolicy$__constructor__(Parcel source) {
        this.warningBytes = -1L;
        this.limitBytes = -1L;
        this.lastWarningSnooze = -1L;
        this.lastLimitSnooze = -1L;
        this.lastRapidSnooze = -1L;
        this.metered = true;
        this.inferred = false;
        this.template = (NetworkTemplate)source.readParcelable(null);
        this.cycleRule = (RecurrenceRule)source.readParcelable(null);
        this.warningBytes = source.readLong();
        this.limitBytes = source.readLong();
        this.lastWarningSnooze = source.readLong();
        this.lastLimitSnooze = source.readLong();
        this.lastRapidSnooze = source.readLong();
        this.metered = source.readInt() != 0;
        this.inferred = source.readInt() != 0;
    }

    private final void $$robo$$android_net_NetworkPolicy$writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.template, flags);
        dest.writeParcelable(this.cycleRule, flags);
        dest.writeLong(this.warningBytes);
        dest.writeLong(this.limitBytes);
        dest.writeLong(this.lastWarningSnooze);
        dest.writeLong(this.lastLimitSnooze);
        dest.writeLong(this.lastRapidSnooze);
        dest.writeInt(this.metered ? 1 : 0);
        dest.writeInt(this.inferred ? 1 : 0);
    }

    private final int $$robo$$android_net_NetworkPolicy$describeContents() {
        return 0;
    }

    private final Iterator<Range<ZonedDateTime>> $$robo$$android_net_NetworkPolicy$cycleIterator() {
        return this.cycleRule.cycleIterator();
    }

    private final boolean $$robo$$android_net_NetworkPolicy$isOverWarning(long totalBytes) {
        return this.warningBytes != -1L && totalBytes >= this.warningBytes;
    }

    private final boolean $$robo$$android_net_NetworkPolicy$isOverLimit(long totalBytes) {
        return this.limitBytes != -1L && (totalBytes += 3000L) >= this.limitBytes;
    }

    private final void $$robo$$android_net_NetworkPolicy$clearSnooze() {
        this.lastWarningSnooze = -1L;
        this.lastLimitSnooze = -1L;
        this.lastRapidSnooze = -1L;
    }

    private final boolean $$robo$$android_net_NetworkPolicy$hasCycle() {
        return this.cycleRule.cycleIterator().hasNext();
    }

    private final int $$robo$$android_net_NetworkPolicy$compareTo(NetworkPolicy another) {
        if (another == null || another.limitBytes == -1L) {
            return -1;
        }
        if (this.limitBytes == -1L || another.limitBytes < this.limitBytes) {
            return 1;
        }
        return 0;
    }

    private final int $$robo$$android_net_NetworkPolicy$hashCode() {
        return Objects.hash(this.template, this.cycleRule, this.warningBytes, this.limitBytes, this.lastWarningSnooze, this.lastLimitSnooze, this.lastRapidSnooze, this.metered, this.inferred);
    }

    private final boolean $$robo$$android_net_NetworkPolicy$equals(Object obj) {
        if (obj instanceof NetworkPolicy) {
            NetworkPolicy other = (NetworkPolicy)obj;
            return this.warningBytes == other.warningBytes && this.limitBytes == other.limitBytes && this.lastWarningSnooze == other.lastWarningSnooze && this.lastLimitSnooze == other.lastLimitSnooze && this.lastRapidSnooze == other.lastRapidSnooze && this.metered == other.metered && this.inferred == other.inferred && Objects.equals(this.template, other.template) && Objects.equals(this.cycleRule, other.cycleRule);
        }
        return false;
    }

    private final String $$robo$$android_net_NetworkPolicy$toString() {
        return "NetworkPolicy{" + "template=" + this.template + " cycleRule=" + this.cycleRule + " warningBytes=" + this.warningBytes + " limitBytes=" + this.limitBytes + " lastWarningSnooze=" + this.lastWarningSnooze + " lastLimitSnooze=" + this.lastLimitSnooze + " lastRapidSnooze=" + this.lastRapidSnooze + " metered=" + this.metered + " inferred=" + this.inferred + "}";
    }

    private final byte[] $$robo$$android_net_NetworkPolicy$getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(3);
        out.write(this.template.getBytesForBackup());
        this.cycleRule.writeToStream(out);
        out.writeLong(this.warningBytes);
        out.writeLong(this.limitBytes);
        out.writeLong(this.lastWarningSnooze);
        out.writeLong(this.lastLimitSnooze);
        out.writeLong(this.lastRapidSnooze);
        out.writeInt(this.metered ? 1 : 0);
        out.writeInt(this.inferred ? 1 : 0);
        return baos.toByteArray();
    }

    private static final NetworkPolicy $$robo$$android_net_NetworkPolicy$getNetworkPolicyFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        RecurrenceRule cycleRule;
        int version = in.readInt();
        if (version < 1 || version > 3) {
            throw new BackupUtils.BadVersionException("Unknown backup version: " + version);
        }
        NetworkTemplate template = NetworkTemplate.getNetworkTemplateFromBackup(in);
        if (version >= 2) {
            cycleRule = new RecurrenceRule(in);
        } else {
            int cycleDay = in.readInt();
            String cycleTimezone = BackupUtils.readString(in);
            cycleRule = NetworkPolicy.buildRule(cycleDay, ZoneId.of(cycleTimezone));
        }
        long warningBytes = in.readLong();
        long limitBytes = in.readLong();
        long lastWarningSnooze = in.readLong();
        long lastLimitSnooze = in.readLong();
        long lastRapidSnooze = version >= 3 ? in.readLong() : -1L;
        boolean metered = in.readInt() == 1;
        boolean inferred = in.readInt() == 1;
        return new NetworkPolicy(template, cycleRule, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, lastRapidSnooze, metered, inferred);
    }

    private /* synthetic */ void $$robo$$android_net_NetworkPolicy$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<NetworkPolicy>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkPolicy_1$__constructor__() {
            }

            private final NetworkPolicy $$robo$$android_net_NetworkPolicy_1$createFromParcel(Parcel in) {
                return new NetworkPolicy(in, null);
            }

            private final NetworkPolicy[] $$robo$$android_net_NetworkPolicy_1$newArray(int size) {
                return new NetworkPolicy[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkPolicy_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy_1$__constructor__(), this);
            }

            @Override
            public NetworkPolicy createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkPolicy_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NetworkPolicy[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkPolicy_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static RecurrenceRule buildRule(int n, ZoneId zoneId) {
        return InvokeDynamicSupport.bootstrapStatic("buildRule", $$robo$$android_net_NetworkPolicy$buildRule(int java.time.ZoneId ), (int)n, (ZoneId)zoneId);
    }

    private void __constructor__(NetworkTemplate networkTemplate, int n, String string2, long l, long l2, boolean bl) {
        this.$$robo$$android_net_NetworkPolicy$__constructor__(networkTemplate, n, string2, l, l2, bl);
    }

    public NetworkPolicy(NetworkTemplate networkTemplate, int n, String string2, long l, long l2, boolean bl) {
        this(networkTemplate, n, string2, l, l2, -1L, -1L, bl, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy$__constructor__(android.net.NetworkTemplate int java.lang.String long long boolean ), this, networkTemplate, n, string2, l, l2, bl);
    }

    private void __constructor__(NetworkTemplate networkTemplate, int n, String string2, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this.$$robo$$android_net_NetworkPolicy$__constructor__(networkTemplate, n, string2, l, l2, l3, l4, bl, bl2);
    }

    public NetworkPolicy(NetworkTemplate networkTemplate, int n, String string2, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this(networkTemplate, NetworkPolicy.buildRule(n, ZoneId.of(string2)), l, l2, l3, l4, bl, bl2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy$__constructor__(android.net.NetworkTemplate int java.lang.String long long long long boolean boolean ), this, networkTemplate, n, string2, l, l2, l3, l4, bl, bl2);
    }

    private void __constructor__(NetworkTemplate networkTemplate, RecurrenceRule recurrenceRule, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this.$$robo$$android_net_NetworkPolicy$__constructor__(networkTemplate, recurrenceRule, l, l2, l3, l4, bl, bl2);
    }

    public NetworkPolicy(NetworkTemplate networkTemplate, RecurrenceRule recurrenceRule, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this(networkTemplate, recurrenceRule, l, l2, l3, l4, -1L, bl, bl2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy$__constructor__(android.net.NetworkTemplate android.util.RecurrenceRule long long long long boolean boolean ), this, networkTemplate, recurrenceRule, l, l2, l3, l4, bl, bl2);
    }

    private void __constructor__(NetworkTemplate networkTemplate, RecurrenceRule recurrenceRule, long l, long l2, long l3, long l4, long l5, boolean bl, boolean bl2) {
        this.$$robo$$android_net_NetworkPolicy$__constructor__(networkTemplate, recurrenceRule, l, l2, l3, l4, l5, bl, bl2);
    }

    public NetworkPolicy(NetworkTemplate networkTemplate, RecurrenceRule recurrenceRule, long l, long l2, long l3, long l4, long l5, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy$__constructor__(android.net.NetworkTemplate android.util.RecurrenceRule long long long long long boolean boolean ), this, networkTemplate, recurrenceRule, l, l2, l3, l4, l5, bl, bl2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_NetworkPolicy$__constructor__(parcel);
    }

    public NetworkPolicy(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkPolicy$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkPolicy$describeContents(), this);
    }

    public Iterator<Range<ZonedDateTime>> cycleIterator() {
        return InvokeDynamicSupport.bootstrap("cycleIterator", $$robo$$android_net_NetworkPolicy$cycleIterator(), this);
    }

    public boolean isOverWarning(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverWarning", $$robo$$android_net_NetworkPolicy$isOverWarning(long ), this, l);
    }

    public boolean isOverLimit(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverLimit", $$robo$$android_net_NetworkPolicy$isOverLimit(long ), this, l);
    }

    public void clearSnooze() {
        InvokeDynamicSupport.bootstrap("clearSnooze", $$robo$$android_net_NetworkPolicy$clearSnooze(), this);
    }

    public boolean hasCycle() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCycle", $$robo$$android_net_NetworkPolicy$hasCycle(), this);
    }

    @Override
    public int compareTo(NetworkPolicy networkPolicy) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_net_NetworkPolicy$compareTo(android.net.NetworkPolicy ), this, networkPolicy);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkPolicy$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkPolicy$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkPolicy$toString(), this);
    }

    public byte[] getBytesForBackup() throws IOException {
        return InvokeDynamicSupport.bootstrap("getBytesForBackup", $$robo$$android_net_NetworkPolicy$getBytesForBackup(), this);
    }

    public static NetworkPolicy getNetworkPolicyFromBackup(DataInputStream dataInputStream) throws IOException, BackupUtils.BadVersionException {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkPolicyFromBackup", $$robo$$android_net_NetworkPolicy$getNetworkPolicyFromBackup(java.io.DataInputStream ), (DataInputStream)dataInputStream);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_net_NetworkPolicy$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ NetworkPolicy(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkPolicy$__constructor__(android.os.Parcel android.net.NetworkPolicy$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkPolicy.class);
    }

    public /* synthetic */ NetworkPolicy() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkPolicy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

