/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NetworkAgent
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public int netId;
    private volatile AsyncChannel mAsyncChannel;
    private String LOG_TAG;
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private Context mContext;
    private ArrayList<Message> mPreConnectedQueue;
    private volatile long mLastBwRefreshTime;
    private static long BW_REFRESH_MIN_WIN_MS = 500L;
    private boolean mPollLceScheduled;
    private AtomicBoolean mPollLcePending;
    private static int BASE = 528384;
    public static int CMD_SUSPECT_BAD = 528384;
    public static int EVENT_NETWORK_INFO_CHANGED = 528385;
    public static int EVENT_NETWORK_CAPABILITIES_CHANGED = 528386;
    public static int EVENT_NETWORK_PROPERTIES_CHANGED = 528387;
    public static int WIFI_BASE_SCORE = 60;
    public static int EVENT_NETWORK_SCORE_CHANGED = 528388;
    public static int CMD_REPORT_NETWORK_STATUS = 528391;
    public static int VALID_NETWORK = 1;
    public static int INVALID_NETWORK = 2;
    public static String REDIRECT_URL_KEY;
    public static int EVENT_SET_EXPLICITLY_SELECTED = 528392;
    public static int CMD_SAVE_ACCEPT_UNVALIDATED = 528393;
    public static int CMD_REQUEST_BANDWIDTH_UPDATE = 528394;
    public static int CMD_START_PACKET_KEEPALIVE = 528395;
    public static int CMD_STOP_PACKET_KEEPALIVE = 528396;
    public static int EVENT_PACKET_KEEPALIVE = 528397;
    public static int CMD_SET_SIGNAL_STRENGTH_THRESHOLDS = 528398;
    public static int CMD_PREVENT_AUTOMATIC_RECONNECT = 528399;

    private void $$robo$$android_net_NetworkAgent$__constructor__(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score) {
    }

    private void $$robo$$android_net_NetworkAgent$__constructor__(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, NetworkMisc misc) {
        this.mPreConnectedQueue = new ArrayList();
        this.mLastBwRefreshTime = 0L;
        this.mPollLceScheduled = false;
        this.mPollLcePending = new AtomicBoolean(false);
        this.LOG_TAG = logTag;
        this.mContext = context;
        if (ni == null || nc == null || lp == null) {
            throw new IllegalArgumentException();
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.netId = cm.registerNetworkAgent(new Messenger(this), new NetworkInfo(ni), new LinkProperties(lp), new NetworkCapabilities(nc), score, misc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkAgent$handleMessage(Message msg) {
        switch (msg.what) {
            case 69633: {
                if (this.mAsyncChannel != null) {
                    this.log("Received new connection while already connected!");
                    break;
                }
                AsyncChannel ac = new AsyncChannel();
                ac.connected(null, this, msg.replyTo);
                ac.replyToMessage(msg, 69634, 0);
                ArrayList<Message> arrayList = this.mPreConnectedQueue;
                synchronized (arrayList) {
                    this.mAsyncChannel = ac;
                    for (Message m : this.mPreConnectedQueue) {
                        ac.sendMessage(m);
                    }
                    this.mPreConnectedQueue.clear();
                    break;
                }
            }
            case 69635: {
                if (this.mAsyncChannel == null) break;
                this.mAsyncChannel.disconnect();
                break;
            }
            case 69636: {
                this.log("NetworkAgent channel lost");
                this.unwanted();
                ArrayList<Message> ac = this.mPreConnectedQueue;
                synchronized (ac) {
                    this.mAsyncChannel = null;
                    break;
                }
            }
            case 528384: {
                this.log("Unhandled Message " + msg);
                break;
            }
            case 528394: {
                CallSite currentTimeMs = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
                if (currentTimeMs >= this.mLastBwRefreshTime + 500L) {
                    this.mPollLceScheduled = false;
                    if (this.mPollLcePending.getAndSet(true)) break;
                    this.pollLceData();
                    break;
                }
                if (this.mPollLceScheduled) break;
                long waitTime = this.mLastBwRefreshTime + 500L - currentTimeMs + 1L;
                this.mPollLceScheduled = this.sendEmptyMessageDelayed(528394, waitTime);
                break;
            }
            case 528391: {
                String redirectUrl = ((Bundle)msg.obj).getString(REDIRECT_URL_KEY);
                this.networkStatus(msg.arg1, redirectUrl);
                break;
            }
            case 528393: {
                this.saveAcceptUnvalidated(msg.arg1 != 0);
                break;
            }
            case 528395: {
                this.startPacketKeepalive(msg);
                break;
            }
            case 528396: {
                this.stopPacketKeepalive(msg);
                break;
            }
            case 528398: {
                ArrayList<Integer> thresholds = ((Bundle)msg.obj).getIntegerArrayList("thresholds");
                int[] intThresholds = new int[thresholds != null ? thresholds.size() : 0];
                for (int i = 0; i < intThresholds.length; ++i) {
                    intThresholds[i] = thresholds.get(i);
                }
                this.setSignalStrengthThresholds(intThresholds);
                break;
            }
            case 528399: {
                this.preventAutomaticReconnect();
            }
        }
    }

    private final void $$robo$$android_net_NetworkAgent$queueOrSendMessage(int what, Object obj) {
        this.queueOrSendMessage(what, 0, 0, obj);
    }

    private final void $$robo$$android_net_NetworkAgent$queueOrSendMessage(int what, int arg1, int arg2) {
        this.queueOrSendMessage(what, arg1, arg2, null);
    }

    private final void $$robo$$android_net_NetworkAgent$queueOrSendMessage(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.queueOrSendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkAgent$queueOrSendMessage(Message msg) {
        ArrayList<Message> arrayList = this.mPreConnectedQueue;
        synchronized (arrayList) {
            if (this.mAsyncChannel != null) {
                this.mAsyncChannel.sendMessage(msg);
            } else {
                this.mPreConnectedQueue.add(msg);
            }
        }
    }

    private final void $$robo$$android_net_NetworkAgent$sendLinkProperties(LinkProperties linkProperties) {
        this.queueOrSendMessage(528387, new LinkProperties(linkProperties));
    }

    private final void $$robo$$android_net_NetworkAgent$sendNetworkInfo(NetworkInfo networkInfo) {
        this.queueOrSendMessage(528385, new NetworkInfo(networkInfo));
    }

    private final void $$robo$$android_net_NetworkAgent$sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.mPollLcePending.set(false);
        this.mLastBwRefreshTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.queueOrSendMessage(528386, new NetworkCapabilities(networkCapabilities));
    }

    private final void $$robo$$android_net_NetworkAgent$sendNetworkScore(int score) {
        if (score < 0) {
            throw new IllegalArgumentException("Score must be >= 0");
        }
        this.queueOrSendMessage(528388, new Integer(score));
    }

    private final void $$robo$$android_net_NetworkAgent$explicitlySelected(boolean acceptUnvalidated) {
        this.queueOrSendMessage(528392, acceptUnvalidated);
    }

    protected abstract void unwanted();

    private final void $$robo$$android_net_NetworkAgent$pollLceData() {
    }

    private final void $$robo$$android_net_NetworkAgent$networkStatus(int status, String redirectUrl) {
    }

    private final void $$robo$$android_net_NetworkAgent$saveAcceptUnvalidated(boolean accept) {
    }

    private final void $$robo$$android_net_NetworkAgent$startPacketKeepalive(Message msg) {
        this.onPacketKeepaliveEvent(msg.arg1, -30);
    }

    private final void $$robo$$android_net_NetworkAgent$stopPacketKeepalive(Message msg) {
        this.onPacketKeepaliveEvent(msg.arg1, -30);
    }

    private final void $$robo$$android_net_NetworkAgent$onPacketKeepaliveEvent(int slot, int reason) {
        this.queueOrSendMessage(528397, slot, reason);
    }

    private final void $$robo$$android_net_NetworkAgent$setSignalStrengthThresholds(int[] thresholds) {
    }

    private final void $$robo$$android_net_NetworkAgent$preventAutomaticReconnect() {
    }

    private final void $$robo$$android_net_NetworkAgent$log(String s) {
        Log.d(this.LOG_TAG, "NetworkAgent: " + s);
    }

    static void __staticInitializer__() {
        REDIRECT_URL_KEY = "redirect URL";
    }

    private void __constructor__(Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n) {
        this.$$robo$$android_net_NetworkAgent$__constructor__(looper, context, string2, networkInfo, networkCapabilities, linkProperties, n);
    }

    public NetworkAgent(Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n) {
        this(looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkAgent$__constructor__(android.os.Looper android.content.Context java.lang.String android.net.NetworkInfo android.net.NetworkCapabilities android.net.LinkProperties int ), this, looper, context, string2, networkInfo, networkCapabilities, linkProperties, n);
    }

    private void __constructor__(Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n, NetworkMisc networkMisc) {
        this.$$robo$$android_net_NetworkAgent$__constructor__(looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, networkMisc);
    }

    public NetworkAgent(Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n, NetworkMisc networkMisc) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkAgent$__constructor__(android.os.Looper android.content.Context java.lang.String android.net.NetworkInfo android.net.NetworkCapabilities android.net.LinkProperties int android.net.NetworkMisc ), this, looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, networkMisc);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_NetworkAgent$handleMessage(android.os.Message ), this, message);
    }

    private void queueOrSendMessage(int n, Object object) {
        InvokeDynamicSupport.bootstrap("queueOrSendMessage", $$robo$$android_net_NetworkAgent$queueOrSendMessage(int java.lang.Object ), this, n, object);
    }

    private void queueOrSendMessage(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("queueOrSendMessage", $$robo$$android_net_NetworkAgent$queueOrSendMessage(int int int ), this, n, n2, n3);
    }

    private void queueOrSendMessage(int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("queueOrSendMessage", $$robo$$android_net_NetworkAgent$queueOrSendMessage(int int int java.lang.Object ), this, n, n2, n3, object);
    }

    private void queueOrSendMessage(Message message) {
        InvokeDynamicSupport.bootstrap("queueOrSendMessage", $$robo$$android_net_NetworkAgent$queueOrSendMessage(android.os.Message ), this, message);
    }

    public void sendLinkProperties(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("sendLinkProperties", $$robo$$android_net_NetworkAgent$sendLinkProperties(android.net.LinkProperties ), this, linkProperties);
    }

    public void sendNetworkInfo(NetworkInfo networkInfo) {
        InvokeDynamicSupport.bootstrap("sendNetworkInfo", $$robo$$android_net_NetworkAgent$sendNetworkInfo(android.net.NetworkInfo ), this, networkInfo);
    }

    public void sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("sendNetworkCapabilities", $$robo$$android_net_NetworkAgent$sendNetworkCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public void sendNetworkScore(int n) {
        InvokeDynamicSupport.bootstrap("sendNetworkScore", $$robo$$android_net_NetworkAgent$sendNetworkScore(int ), this, n);
    }

    public void explicitlySelected(boolean bl) {
        InvokeDynamicSupport.bootstrap("explicitlySelected", $$robo$$android_net_NetworkAgent$explicitlySelected(boolean ), this, bl);
    }

    protected void pollLceData() {
        InvokeDynamicSupport.bootstrap("pollLceData", $$robo$$android_net_NetworkAgent$pollLceData(), this);
    }

    protected void networkStatus(int n, String string2) {
        InvokeDynamicSupport.bootstrap("networkStatus", $$robo$$android_net_NetworkAgent$networkStatus(int java.lang.String ), this, n, string2);
    }

    protected void saveAcceptUnvalidated(boolean bl) {
        InvokeDynamicSupport.bootstrap("saveAcceptUnvalidated", $$robo$$android_net_NetworkAgent$saveAcceptUnvalidated(boolean ), this, bl);
    }

    protected void startPacketKeepalive(Message message) {
        InvokeDynamicSupport.bootstrap("startPacketKeepalive", $$robo$$android_net_NetworkAgent$startPacketKeepalive(android.os.Message ), this, message);
    }

    protected void stopPacketKeepalive(Message message) {
        InvokeDynamicSupport.bootstrap("stopPacketKeepalive", $$robo$$android_net_NetworkAgent$stopPacketKeepalive(android.os.Message ), this, message);
    }

    public void onPacketKeepaliveEvent(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onPacketKeepaliveEvent", $$robo$$android_net_NetworkAgent$onPacketKeepaliveEvent(int int ), this, n, n2);
    }

    protected void setSignalStrengthThresholds(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setSignalStrengthThresholds", $$robo$$android_net_NetworkAgent$setSignalStrengthThresholds(int[] ), this, nArray);
    }

    protected void preventAutomaticReconnect() {
        InvokeDynamicSupport.bootstrap("preventAutomaticReconnect", $$robo$$android_net_NetworkAgent$preventAutomaticReconnect(), this);
    }

    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_NetworkAgent$log(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkAgent.class);
    }

    public /* synthetic */ NetworkAgent() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkAgent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

