/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LinkProperties
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mIfaceName;
    private ArrayList<LinkAddress> mLinkAddresses;
    private ArrayList<InetAddress> mDnses;
    private ArrayList<InetAddress> mValidatedPrivateDnses;
    private boolean mUsePrivateDns;
    private String mPrivateDnsServerName;
    private String mDomains;
    private ArrayList<RouteInfo> mRoutes;
    private ProxyInfo mHttpProxy;
    private int mMtu;
    private String mTcpBufferSizes;
    private static int MIN_MTU = 68;
    private static int MIN_MTU_V6 = 1280;
    private static int MAX_MTU = 10000;
    private Hashtable<String, LinkProperties> mStackedLinks;
    public static Parcelable.Creator<LinkProperties> CREATOR;

    private static final ProvisioningChange $$robo$$android_net_LinkProperties$compareProvisioning(LinkProperties before, LinkProperties after) {
        if (before.isProvisioned() && after.isProvisioned()) {
            if (before.isIPv4Provisioned() && !after.isIPv4Provisioned() || before.isIPv6Provisioned() && !after.isIPv6Provisioned()) {
                return ProvisioningChange.LOST_PROVISIONING;
            }
            return ProvisioningChange.STILL_PROVISIONED;
        }
        if (before.isProvisioned() && !after.isProvisioned()) {
            return ProvisioningChange.LOST_PROVISIONING;
        }
        if (!before.isProvisioned() && after.isProvisioned()) {
            return ProvisioningChange.GAINED_PROVISIONING;
        }
        return ProvisioningChange.STILL_NOT_PROVISIONED;
    }

    private void $$robo$$android_net_LinkProperties$__constructor__() {
        this.mLinkAddresses = new ArrayList();
        this.mDnses = new ArrayList();
        this.mValidatedPrivateDnses = new ArrayList();
        this.mRoutes = new ArrayList();
        this.mStackedLinks = new Hashtable();
    }

    private void $$robo$$android_net_LinkProperties$__constructor__(LinkProperties source) {
        this.mLinkAddresses = new ArrayList();
        this.mDnses = new ArrayList();
        this.mValidatedPrivateDnses = new ArrayList();
        this.mRoutes = new ArrayList();
        this.mStackedLinks = new Hashtable();
        if (source != null) {
            this.mIfaceName = source.getInterfaceName();
            for (LinkAddress linkAddress : source.getLinkAddresses()) {
                this.mLinkAddresses.add(linkAddress);
            }
            for (InetAddress inetAddress : source.getDnsServers()) {
                this.mDnses.add(inetAddress);
            }
            for (InetAddress inetAddress : source.getValidatedPrivateDnsServers()) {
                this.mValidatedPrivateDnses.add(inetAddress);
            }
            this.mUsePrivateDns = source.mUsePrivateDns;
            this.mPrivateDnsServerName = source.mPrivateDnsServerName;
            this.mDomains = source.getDomains();
            for (RouteInfo routeInfo : source.getRoutes()) {
                this.mRoutes.add(routeInfo);
            }
            this.mHttpProxy = source.getHttpProxy() == null ? null : new ProxyInfo(source.getHttpProxy());
            for (LinkProperties linkProperties : source.mStackedLinks.values()) {
                this.addStackedLink(linkProperties);
            }
            this.setMtu(source.getMtu());
            this.mTcpBufferSizes = source.mTcpBufferSizes;
        }
    }

    private final void $$robo$$android_net_LinkProperties$setInterfaceName(String iface) {
        this.mIfaceName = iface;
        ArrayList<RouteInfo> newRoutes = new ArrayList<RouteInfo>(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            newRoutes.add(this.routeWithInterface(route));
        }
        this.mRoutes = newRoutes;
    }

    private final String $$robo$$android_net_LinkProperties$getInterfaceName() {
        return this.mIfaceName;
    }

    private final List<String> $$robo$$android_net_LinkProperties$getAllInterfaceNames() {
        ArrayList<String> interfaceNames = new ArrayList<String>(this.mStackedLinks.size() + 1);
        if (this.mIfaceName != null) {
            interfaceNames.add(new String(this.mIfaceName));
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            interfaceNames.addAll(stacked.getAllInterfaceNames());
        }
        return interfaceNames;
    }

    private final List<InetAddress> $$robo$$android_net_LinkProperties$getAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        return Collections.unmodifiableList(addresses);
    }

    private final List<InetAddress> $$robo$$android_net_LinkProperties$getAllAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllAddresses());
        }
        return addresses;
    }

    private final int $$robo$$android_net_LinkProperties$findLinkAddressIndex(LinkAddress address) {
        for (int i = 0; i < this.mLinkAddresses.size(); ++i) {
            if (!this.mLinkAddresses.get(i).isSameAddressAs(address)) continue;
            return i;
        }
        return -1;
    }

    private final boolean $$robo$$android_net_LinkProperties$addLinkAddress(LinkAddress address) {
        if (address == null) {
            return false;
        }
        int i = this.findLinkAddressIndex(address);
        if (i < 0) {
            this.mLinkAddresses.add(address);
            return true;
        }
        if (this.mLinkAddresses.get(i).equals(address)) {
            return false;
        }
        this.mLinkAddresses.set(i, address);
        return true;
    }

    private final boolean $$robo$$android_net_LinkProperties$removeLinkAddress(LinkAddress toRemove) {
        int i = this.findLinkAddressIndex(toRemove);
        if (i >= 0) {
            this.mLinkAddresses.remove(i);
            return true;
        }
        return false;
    }

    private final List<LinkAddress> $$robo$$android_net_LinkProperties$getLinkAddresses() {
        return Collections.unmodifiableList(this.mLinkAddresses);
    }

    private final List<LinkAddress> $$robo$$android_net_LinkProperties$getAllLinkAddresses() {
        ArrayList<LinkAddress> addresses = new ArrayList<LinkAddress>();
        addresses.addAll(this.mLinkAddresses);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllLinkAddresses());
        }
        return addresses;
    }

    private final void $$robo$$android_net_LinkProperties$setLinkAddresses(Collection<LinkAddress> addresses) {
        this.mLinkAddresses.clear();
        for (LinkAddress address : addresses) {
            this.addLinkAddress(address);
        }
    }

    private final boolean $$robo$$android_net_LinkProperties$addDnsServer(InetAddress dnsServer) {
        if (dnsServer != null && !this.mDnses.contains(dnsServer)) {
            this.mDnses.add(dnsServer);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$removeDnsServer(InetAddress dnsServer) {
        if (dnsServer != null) {
            return this.mDnses.remove(dnsServer);
        }
        return false;
    }

    private final void $$robo$$android_net_LinkProperties$setDnsServers(Collection<InetAddress> dnsServers) {
        this.mDnses.clear();
        for (InetAddress dnsServer : dnsServers) {
            this.addDnsServer(dnsServer);
        }
    }

    private final List<InetAddress> $$robo$$android_net_LinkProperties$getDnsServers() {
        return Collections.unmodifiableList(this.mDnses);
    }

    private final void $$robo$$android_net_LinkProperties$setUsePrivateDns(boolean usePrivateDns) {
        this.mUsePrivateDns = usePrivateDns;
    }

    private final boolean $$robo$$android_net_LinkProperties$isPrivateDnsActive() {
        return this.mUsePrivateDns;
    }

    private final void $$robo$$android_net_LinkProperties$setPrivateDnsServerName(String privateDnsServerName) {
        this.mPrivateDnsServerName = privateDnsServerName;
    }

    private final String $$robo$$android_net_LinkProperties$getPrivateDnsServerName() {
        return this.mPrivateDnsServerName;
    }

    private final boolean $$robo$$android_net_LinkProperties$addValidatedPrivateDnsServer(InetAddress dnsServer) {
        if (dnsServer != null && !this.mValidatedPrivateDnses.contains(dnsServer)) {
            this.mValidatedPrivateDnses.add(dnsServer);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$removeValidatedPrivateDnsServer(InetAddress dnsServer) {
        if (dnsServer != null) {
            return this.mValidatedPrivateDnses.remove(dnsServer);
        }
        return false;
    }

    private final void $$robo$$android_net_LinkProperties$setValidatedPrivateDnsServers(Collection<InetAddress> dnsServers) {
        this.mValidatedPrivateDnses.clear();
        for (InetAddress dnsServer : dnsServers) {
            this.addValidatedPrivateDnsServer(dnsServer);
        }
    }

    private final List<InetAddress> $$robo$$android_net_LinkProperties$getValidatedPrivateDnsServers() {
        return Collections.unmodifiableList(this.mValidatedPrivateDnses);
    }

    private final void $$robo$$android_net_LinkProperties$setDomains(String domains) {
        this.mDomains = domains;
    }

    private final String $$robo$$android_net_LinkProperties$getDomains() {
        return this.mDomains;
    }

    private final void $$robo$$android_net_LinkProperties$setMtu(int mtu) {
        this.mMtu = mtu;
    }

    private final int $$robo$$android_net_LinkProperties$getMtu() {
        return this.mMtu;
    }

    private final void $$robo$$android_net_LinkProperties$setTcpBufferSizes(String tcpBufferSizes) {
        this.mTcpBufferSizes = tcpBufferSizes;
    }

    private final String $$robo$$android_net_LinkProperties$getTcpBufferSizes() {
        return this.mTcpBufferSizes;
    }

    private final RouteInfo $$robo$$android_net_LinkProperties$routeWithInterface(RouteInfo route) {
        return new RouteInfo(route.getDestination(), route.getGateway(), this.mIfaceName, route.getType());
    }

    private final boolean $$robo$$android_net_LinkProperties$addRoute(RouteInfo route) {
        if (route != null) {
            String routeIface = route.getInterface();
            if (routeIface != null && !routeIface.equals(this.mIfaceName)) {
                throw new IllegalArgumentException("Route added with non-matching interface: " + routeIface + " vs. " + this.mIfaceName);
            }
            if (!this.mRoutes.contains(route = this.routeWithInterface(route))) {
                this.mRoutes.add(route);
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$removeRoute(RouteInfo route) {
        return route != null && Objects.equals(this.mIfaceName, route.getInterface()) && this.mRoutes.remove(route);
    }

    private final List<RouteInfo> $$robo$$android_net_LinkProperties$getRoutes() {
        return Collections.unmodifiableList(this.mRoutes);
    }

    private final void $$robo$$android_net_LinkProperties$ensureDirectlyConnectedRoutes() {
        for (LinkAddress addr : this.mLinkAddresses) {
            this.addRoute(new RouteInfo(addr, null, this.mIfaceName));
        }
    }

    private final List<RouteInfo> $$robo$$android_net_LinkProperties$getAllRoutes() {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        routes.addAll(this.mRoutes);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            routes.addAll(stacked.getAllRoutes());
        }
        return routes;
    }

    private final void $$robo$$android_net_LinkProperties$setHttpProxy(ProxyInfo proxy) {
        this.mHttpProxy = proxy;
    }

    private final ProxyInfo $$robo$$android_net_LinkProperties$getHttpProxy() {
        return this.mHttpProxy;
    }

    private final boolean $$robo$$android_net_LinkProperties$addStackedLink(LinkProperties link) {
        if (link != null && link.getInterfaceName() != null) {
            this.mStackedLinks.put(link.getInterfaceName(), link);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$removeStackedLink(String iface) {
        if (iface != null) {
            LinkProperties removed = this.mStackedLinks.remove(iface);
            return removed != null;
        }
        return false;
    }

    private final List<LinkProperties> $$robo$$android_net_LinkProperties$getStackedLinks() {
        if (this.mStackedLinks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LinkProperties> stacked = new ArrayList<LinkProperties>();
        for (LinkProperties link : this.mStackedLinks.values()) {
            stacked.add(new LinkProperties(link));
        }
        return Collections.unmodifiableList(stacked);
    }

    private final void $$robo$$android_net_LinkProperties$clear() {
        this.mIfaceName = null;
        this.mLinkAddresses.clear();
        this.mDnses.clear();
        this.mUsePrivateDns = false;
        this.mPrivateDnsServerName = null;
        this.mDomains = null;
        this.mRoutes.clear();
        this.mHttpProxy = null;
        this.mStackedLinks.clear();
        this.mMtu = 0;
        this.mTcpBufferSizes = null;
    }

    private final int $$robo$$android_net_LinkProperties$describeContents() {
        return 0;
    }

    private final String $$robo$$android_net_LinkProperties$toString() {
        String ifaceName = this.mIfaceName == null ? "" : "InterfaceName: " + this.mIfaceName + " ";
        String linkAddresses = "LinkAddresses: [";
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            linkAddresses = linkAddresses + linkAddress.toString() + ",";
        }
        linkAddresses = linkAddresses + "] ";
        String dns = "DnsAddresses: [";
        for (InetAddress addr : this.mDnses) {
            dns = dns + addr.getHostAddress() + ",";
        }
        dns = dns + "] ";
        String string2 = "UsePrivateDns: " + this.mUsePrivateDns + " ";
        String privateDnsServerName = "";
        if (privateDnsServerName != null) {
            privateDnsServerName = "PrivateDnsServerName: " + this.mPrivateDnsServerName + " ";
        }
        String validatedPrivateDns = "";
        if (!this.mValidatedPrivateDnses.isEmpty()) {
            validatedPrivateDns = "ValidatedPrivateDnsAddresses: [";
            for (InetAddress addr : this.mValidatedPrivateDnses) {
                validatedPrivateDns = validatedPrivateDns + addr.getHostAddress() + ",";
            }
            validatedPrivateDns = validatedPrivateDns + "] ";
        }
        String domainName = "Domains: " + this.mDomains;
        String mtu = " MTU: " + this.mMtu;
        String tcpBuffSizes = "";
        if (this.mTcpBufferSizes != null) {
            tcpBuffSizes = " TcpBufferSizes: " + this.mTcpBufferSizes;
        }
        String routes = " Routes: [";
        for (RouteInfo route : this.mRoutes) {
            routes = routes + route.toString() + ",";
        }
        routes = routes + "] ";
        String proxy = this.mHttpProxy == null ? "" : " HttpProxy: " + this.mHttpProxy.toString() + " ";
        String stacked = "";
        if (this.mStackedLinks.values().size() > 0) {
            stacked = stacked + " Stacked: [";
            for (LinkProperties link : this.mStackedLinks.values()) {
                stacked = stacked + " [" + link.toString() + " ],";
            }
            stacked = stacked + "] ";
        }
        return "{" + ifaceName + linkAddresses + routes + dns + string2 + privateDnsServerName + domainName + mtu + tcpBuffSizes + proxy + stacked + "}";
    }

    private final boolean $$robo$$android_net_LinkProperties$hasIPv4Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$hasIPv4AddressOnInterface(String iface) {
        return Objects.equals(iface, this.mIfaceName) && this.hasIPv4Address() || iface != null && this.mStackedLinks.containsKey(iface) && this.mStackedLinks.get(iface).hasIPv4Address();
    }

    private final boolean $$robo$$android_net_LinkProperties$hasGlobalIPv6Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet6Address) || !address.isGlobalPreferred()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$hasIPv4DefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv4Default()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$hasIPv6DefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv6Default()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$hasIPv4DnsServer() {
        for (InetAddress ia : this.mDnses) {
            if (!(ia instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$hasIPv6DnsServer() {
        for (InetAddress ia : this.mDnses) {
            if (!(ia instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIPv4Provisioned() {
        return this.hasIPv4Address() && this.hasIPv4DefaultRoute() && this.hasIPv4DnsServer();
    }

    private final boolean $$robo$$android_net_LinkProperties$isIPv6Provisioned() {
        return this.hasGlobalIPv6Address() && this.hasIPv6DefaultRoute() && this.hasIPv6DnsServer();
    }

    private final boolean $$robo$$android_net_LinkProperties$isProvisioned() {
        return this.isIPv4Provisioned() || this.isIPv6Provisioned();
    }

    private final boolean $$robo$$android_net_LinkProperties$isReachable(InetAddress ip) {
        List<RouteInfo> allRoutes = this.getAllRoutes();
        RouteInfo bestRoute = RouteInfo.selectBestRoute(allRoutes, ip);
        if (bestRoute == null) {
            return false;
        }
        if (ip instanceof Inet4Address) {
            return this.hasIPv4AddressOnInterface(bestRoute.getInterface());
        }
        if (ip instanceof Inet6Address) {
            if (ip.isLinkLocalAddress()) {
                return ((Inet6Address)ip).getScopeId() != 0;
            }
            return !bestRoute.hasGateway() || this.hasGlobalIPv6Address();
        }
        return false;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalInterfaceName(LinkProperties target) {
        return TextUtils.equals(this.getInterfaceName(), target.getInterfaceName());
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalAddresses(LinkProperties target) {
        List<InetAddress> targetAddresses = target.getAddresses();
        List<InetAddress> sourceAddresses = this.getAddresses();
        return sourceAddresses.size() == targetAddresses.size() ? sourceAddresses.containsAll(targetAddresses) : false;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalDnses(LinkProperties target) {
        List<InetAddress> targetDnses = target.getDnsServers();
        String targetDomains = target.getDomains();
        if (this.mDomains == null ? targetDomains != null : !this.mDomains.equals(targetDomains)) {
            return false;
        }
        return this.mDnses.size() == targetDnses.size() ? this.mDnses.containsAll(targetDnses) : false;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalPrivateDns(LinkProperties target) {
        return this.isPrivateDnsActive() == target.isPrivateDnsActive() && TextUtils.equals(this.getPrivateDnsServerName(), target.getPrivateDnsServerName());
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalValidatedPrivateDnses(LinkProperties target) {
        List<InetAddress> targetDnses = target.getValidatedPrivateDnsServers();
        return this.mValidatedPrivateDnses.size() == targetDnses.size() ? this.mValidatedPrivateDnses.containsAll(targetDnses) : false;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalRoutes(LinkProperties target) {
        List<RouteInfo> targetRoutes = target.getRoutes();
        return this.mRoutes.size() == targetRoutes.size() ? this.mRoutes.containsAll(targetRoutes) : false;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalHttpProxy(LinkProperties target) {
        return this.getHttpProxy() == null ? target.getHttpProxy() == null : this.getHttpProxy().equals(target.getHttpProxy());
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalStackedLinks(LinkProperties target) {
        if (!this.mStackedLinks.keySet().equals(target.mStackedLinks.keySet())) {
            return false;
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            String iface;
            if (stacked.equals(target.mStackedLinks.get(iface = stacked.getInterfaceName()))) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalMtu(LinkProperties target) {
        return this.getMtu() == target.getMtu();
    }

    private final boolean $$robo$$android_net_LinkProperties$isIdenticalTcpBufferSizes(LinkProperties target) {
        return Objects.equals(this.mTcpBufferSizes, target.mTcpBufferSizes);
    }

    private final boolean $$robo$$android_net_LinkProperties$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkProperties)) {
            return false;
        }
        LinkProperties target = (LinkProperties)obj;
        return this.isIdenticalInterfaceName(target) && this.isIdenticalAddresses(target) && this.isIdenticalDnses(target) && this.isIdenticalPrivateDns(target) && this.isIdenticalValidatedPrivateDnses(target) && this.isIdenticalRoutes(target) && this.isIdenticalHttpProxy(target) && this.isIdenticalStackedLinks(target) && this.isIdenticalMtu(target) && this.isIdenticalTcpBufferSizes(target);
    }

    private final CompareResult<LinkAddress> $$robo$$android_net_LinkProperties$compareAddresses(LinkProperties target) {
        return new CompareResult<LinkAddress>(this.mLinkAddresses, target != null ? target.getLinkAddresses() : null);
    }

    private final CompareResult<InetAddress> $$robo$$android_net_LinkProperties$compareDnses(LinkProperties target) {
        return new CompareResult<InetAddress>(this.mDnses, target != null ? target.getDnsServers() : null);
    }

    private final CompareResult<InetAddress> $$robo$$android_net_LinkProperties$compareValidatedPrivateDnses(LinkProperties target) {
        return new CompareResult<InetAddress>(this.mValidatedPrivateDnses, target != null ? target.getValidatedPrivateDnsServers() : null);
    }

    private final CompareResult<RouteInfo> $$robo$$android_net_LinkProperties$compareAllRoutes(LinkProperties target) {
        return new CompareResult<RouteInfo>(this.getAllRoutes(), target != null ? target.getAllRoutes() : null);
    }

    private final CompareResult<String> $$robo$$android_net_LinkProperties$compareAllInterfaceNames(LinkProperties target) {
        return new CompareResult<String>(this.getAllInterfaceNames(), target != null ? target.getAllInterfaceNames() : null);
    }

    private final int $$robo$$android_net_LinkProperties$hashCode() {
        return (null == this.mIfaceName ? 0 : this.mIfaceName.hashCode() + this.mLinkAddresses.size() * 31 + this.mDnses.size() * 37 + this.mValidatedPrivateDnses.size() * 61 + (null == this.mDomains ? 0 : this.mDomains.hashCode()) + this.mRoutes.size() * 41 + (null == this.mHttpProxy ? 0 : this.mHttpProxy.hashCode()) + this.mStackedLinks.hashCode() * 47) + this.mMtu * 51 + (null == this.mTcpBufferSizes ? 0 : this.mTcpBufferSizes.hashCode()) + (this.mUsePrivateDns ? 57 : 0) + (null == this.mPrivateDnsServerName ? 0 : this.mPrivateDnsServerName.hashCode());
    }

    private final void $$robo$$android_net_LinkProperties$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getInterfaceName());
        dest.writeInt(this.mLinkAddresses.size());
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            dest.writeParcelable(linkAddress, flags);
        }
        dest.writeInt(this.mDnses.size());
        for (InetAddress d : this.mDnses) {
            dest.writeByteArray(d.getAddress());
        }
        dest.writeInt(this.mValidatedPrivateDnses.size());
        for (InetAddress d : this.mValidatedPrivateDnses) {
            dest.writeByteArray(d.getAddress());
        }
        dest.writeBoolean(this.mUsePrivateDns);
        dest.writeString(this.mPrivateDnsServerName);
        dest.writeString(this.mDomains);
        dest.writeInt(this.mMtu);
        dest.writeString(this.mTcpBufferSizes);
        dest.writeInt(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            dest.writeParcelable(route, flags);
        }
        if (this.mHttpProxy != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.mHttpProxy, flags);
        } else {
            dest.writeByte((byte)0);
        }
        ArrayList<LinkProperties> stackedLinks = new ArrayList<LinkProperties>(this.mStackedLinks.values());
        dest.writeList(stackedLinks);
    }

    private static final boolean $$robo$$android_net_LinkProperties$isValidMtu(int mtu, boolean ipv6) {
        return ipv6 ? mtu >= 1280 && mtu <= 10000 : mtu >= 68 && mtu <= 10000;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<LinkProperties>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_LinkProperties_1$__constructor__() {
            }

            private final LinkProperties $$robo$$android_net_LinkProperties_1$createFromParcel(Parcel in) {
                int i;
                LinkProperties netProp = new LinkProperties();
                String iface = in.readString();
                if (iface != null) {
                    netProp.setInterfaceName(iface);
                }
                int addressCount = in.readInt();
                for (i = 0; i < addressCount; ++i) {
                    netProp.addLinkAddress((LinkAddress)in.readParcelable(null));
                }
                addressCount = in.readInt();
                for (i = 0; i < addressCount; ++i) {
                    try {
                        netProp.addDnsServer(InetAddress.getByAddress(in.createByteArray()));
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                addressCount = in.readInt();
                for (i = 0; i < addressCount; ++i) {
                    try {
                        netProp.addValidatedPrivateDnsServer(InetAddress.getByAddress(in.createByteArray()));
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                netProp.setUsePrivateDns(in.readBoolean());
                netProp.setPrivateDnsServerName(in.readString());
                netProp.setDomains(in.readString());
                netProp.setMtu(in.readInt());
                netProp.setTcpBufferSizes(in.readString());
                addressCount = in.readInt();
                for (i = 0; i < addressCount; ++i) {
                    netProp.addRoute((RouteInfo)in.readParcelable(null));
                }
                if (in.readByte() == 1) {
                    netProp.setHttpProxy((ProxyInfo)in.readParcelable(null));
                }
                ArrayList stackedLinks = new ArrayList();
                in.readList(stackedLinks, LinkProperties.class.getClassLoader());
                for (LinkProperties stackedLink : stackedLinks) {
                    netProp.addStackedLink(stackedLink);
                }
                return netProp;
            }

            private final LinkProperties[] $$robo$$android_net_LinkProperties_1$newArray(int size) {
                return new LinkProperties[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_LinkProperties_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkProperties_1$__constructor__(), this);
            }

            @Override
            public LinkProperties createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_LinkProperties_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public LinkProperties[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_LinkProperties_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static ProvisioningChange compareProvisioning(LinkProperties linkProperties, LinkProperties linkProperties2) {
        return InvokeDynamicSupport.bootstrapStatic("compareProvisioning", $$robo$$android_net_LinkProperties$compareProvisioning(android.net.LinkProperties android.net.LinkProperties ), (LinkProperties)linkProperties, (LinkProperties)linkProperties2);
    }

    private void __constructor__() {
        this.$$robo$$android_net_LinkProperties$__constructor__();
    }

    public LinkProperties() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkProperties$__constructor__(), this);
    }

    private void __constructor__(LinkProperties linkProperties) {
        this.$$robo$$android_net_LinkProperties$__constructor__(linkProperties);
    }

    public LinkProperties(LinkProperties linkProperties) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkProperties$__constructor__(android.net.LinkProperties ), this, linkProperties);
    }

    public void setInterfaceName(String string2) {
        InvokeDynamicSupport.bootstrap("setInterfaceName", $$robo$$android_net_LinkProperties$setInterfaceName(java.lang.String ), this, string2);
    }

    public String getInterfaceName() {
        return InvokeDynamicSupport.bootstrap("getInterfaceName", $$robo$$android_net_LinkProperties$getInterfaceName(), this);
    }

    public List<String> getAllInterfaceNames() {
        return InvokeDynamicSupport.bootstrap("getAllInterfaceNames", $$robo$$android_net_LinkProperties$getAllInterfaceNames(), this);
    }

    public List<InetAddress> getAddresses() {
        return InvokeDynamicSupport.bootstrap("getAddresses", $$robo$$android_net_LinkProperties$getAddresses(), this);
    }

    public List<InetAddress> getAllAddresses() {
        return InvokeDynamicSupport.bootstrap("getAllAddresses", $$robo$$android_net_LinkProperties$getAllAddresses(), this);
    }

    private int findLinkAddressIndex(LinkAddress linkAddress) {
        return (int)InvokeDynamicSupport.bootstrap("findLinkAddressIndex", $$robo$$android_net_LinkProperties$findLinkAddressIndex(android.net.LinkAddress ), this, linkAddress);
    }

    public boolean addLinkAddress(LinkAddress linkAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("addLinkAddress", $$robo$$android_net_LinkProperties$addLinkAddress(android.net.LinkAddress ), this, linkAddress);
    }

    public boolean removeLinkAddress(LinkAddress linkAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeLinkAddress", $$robo$$android_net_LinkProperties$removeLinkAddress(android.net.LinkAddress ), this, linkAddress);
    }

    public List<LinkAddress> getLinkAddresses() {
        return InvokeDynamicSupport.bootstrap("getLinkAddresses", $$robo$$android_net_LinkProperties$getLinkAddresses(), this);
    }

    public List<LinkAddress> getAllLinkAddresses() {
        return InvokeDynamicSupport.bootstrap("getAllLinkAddresses", $$robo$$android_net_LinkProperties$getAllLinkAddresses(), this);
    }

    public void setLinkAddresses(Collection<LinkAddress> collection) {
        InvokeDynamicSupport.bootstrap("setLinkAddresses", $$robo$$android_net_LinkProperties$setLinkAddresses(java.util.Collection<android.net.LinkAddress> ), this, collection);
    }

    public boolean addDnsServer(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("addDnsServer", $$robo$$android_net_LinkProperties$addDnsServer(java.net.InetAddress ), this, inetAddress);
    }

    public boolean removeDnsServer(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeDnsServer", $$robo$$android_net_LinkProperties$removeDnsServer(java.net.InetAddress ), this, inetAddress);
    }

    public void setDnsServers(Collection<InetAddress> collection) {
        InvokeDynamicSupport.bootstrap("setDnsServers", $$robo$$android_net_LinkProperties$setDnsServers(java.util.Collection<java.net.InetAddress> ), this, collection);
    }

    public List<InetAddress> getDnsServers() {
        return InvokeDynamicSupport.bootstrap("getDnsServers", $$robo$$android_net_LinkProperties$getDnsServers(), this);
    }

    public void setUsePrivateDns(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUsePrivateDns", $$robo$$android_net_LinkProperties$setUsePrivateDns(boolean ), this, bl);
    }

    public boolean isPrivateDnsActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrivateDnsActive", $$robo$$android_net_LinkProperties$isPrivateDnsActive(), this);
    }

    public void setPrivateDnsServerName(String string2) {
        InvokeDynamicSupport.bootstrap("setPrivateDnsServerName", $$robo$$android_net_LinkProperties$setPrivateDnsServerName(java.lang.String ), this, string2);
    }

    public String getPrivateDnsServerName() {
        return InvokeDynamicSupport.bootstrap("getPrivateDnsServerName", $$robo$$android_net_LinkProperties$getPrivateDnsServerName(), this);
    }

    public boolean addValidatedPrivateDnsServer(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("addValidatedPrivateDnsServer", $$robo$$android_net_LinkProperties$addValidatedPrivateDnsServer(java.net.InetAddress ), this, inetAddress);
    }

    public boolean removeValidatedPrivateDnsServer(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeValidatedPrivateDnsServer", $$robo$$android_net_LinkProperties$removeValidatedPrivateDnsServer(java.net.InetAddress ), this, inetAddress);
    }

    public void setValidatedPrivateDnsServers(Collection<InetAddress> collection) {
        InvokeDynamicSupport.bootstrap("setValidatedPrivateDnsServers", $$robo$$android_net_LinkProperties$setValidatedPrivateDnsServers(java.util.Collection<java.net.InetAddress> ), this, collection);
    }

    public List<InetAddress> getValidatedPrivateDnsServers() {
        return InvokeDynamicSupport.bootstrap("getValidatedPrivateDnsServers", $$robo$$android_net_LinkProperties$getValidatedPrivateDnsServers(), this);
    }

    public void setDomains(String string2) {
        InvokeDynamicSupport.bootstrap("setDomains", $$robo$$android_net_LinkProperties$setDomains(java.lang.String ), this, string2);
    }

    public String getDomains() {
        return InvokeDynamicSupport.bootstrap("getDomains", $$robo$$android_net_LinkProperties$getDomains(), this);
    }

    public void setMtu(int n) {
        InvokeDynamicSupport.bootstrap("setMtu", $$robo$$android_net_LinkProperties$setMtu(int ), this, n);
    }

    public int getMtu() {
        return (int)InvokeDynamicSupport.bootstrap("getMtu", $$robo$$android_net_LinkProperties$getMtu(), this);
    }

    public void setTcpBufferSizes(String string2) {
        InvokeDynamicSupport.bootstrap("setTcpBufferSizes", $$robo$$android_net_LinkProperties$setTcpBufferSizes(java.lang.String ), this, string2);
    }

    public String getTcpBufferSizes() {
        return InvokeDynamicSupport.bootstrap("getTcpBufferSizes", $$robo$$android_net_LinkProperties$getTcpBufferSizes(), this);
    }

    private RouteInfo routeWithInterface(RouteInfo routeInfo) {
        return InvokeDynamicSupport.bootstrap("routeWithInterface", $$robo$$android_net_LinkProperties$routeWithInterface(android.net.RouteInfo ), this, routeInfo);
    }

    public boolean addRoute(RouteInfo routeInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("addRoute", $$robo$$android_net_LinkProperties$addRoute(android.net.RouteInfo ), this, routeInfo);
    }

    public boolean removeRoute(RouteInfo routeInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeRoute", $$robo$$android_net_LinkProperties$removeRoute(android.net.RouteInfo ), this, routeInfo);
    }

    public List<RouteInfo> getRoutes() {
        return InvokeDynamicSupport.bootstrap("getRoutes", $$robo$$android_net_LinkProperties$getRoutes(), this);
    }

    public void ensureDirectlyConnectedRoutes() {
        InvokeDynamicSupport.bootstrap("ensureDirectlyConnectedRoutes", $$robo$$android_net_LinkProperties$ensureDirectlyConnectedRoutes(), this);
    }

    public List<RouteInfo> getAllRoutes() {
        return InvokeDynamicSupport.bootstrap("getAllRoutes", $$robo$$android_net_LinkProperties$getAllRoutes(), this);
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setHttpProxy", $$robo$$android_net_LinkProperties$setHttpProxy(android.net.ProxyInfo ), this, proxyInfo);
    }

    public ProxyInfo getHttpProxy() {
        return InvokeDynamicSupport.bootstrap("getHttpProxy", $$robo$$android_net_LinkProperties$getHttpProxy(), this);
    }

    public boolean addStackedLink(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("addStackedLink", $$robo$$android_net_LinkProperties$addStackedLink(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean removeStackedLink(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeStackedLink", $$robo$$android_net_LinkProperties$removeStackedLink(java.lang.String ), this, string2);
    }

    public List<LinkProperties> getStackedLinks() {
        return InvokeDynamicSupport.bootstrap("getStackedLinks", $$robo$$android_net_LinkProperties$getStackedLinks(), this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_LinkProperties$clear(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_LinkProperties$describeContents(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_LinkProperties$toString(), this);
    }

    public boolean hasIPv4Address() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIPv4Address", $$robo$$android_net_LinkProperties$hasIPv4Address(), this);
    }

    private boolean hasIPv4AddressOnInterface(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIPv4AddressOnInterface", $$robo$$android_net_LinkProperties$hasIPv4AddressOnInterface(java.lang.String ), this, string2);
    }

    public boolean hasGlobalIPv6Address() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasGlobalIPv6Address", $$robo$$android_net_LinkProperties$hasGlobalIPv6Address(), this);
    }

    public boolean hasIPv4DefaultRoute() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIPv4DefaultRoute", $$robo$$android_net_LinkProperties$hasIPv4DefaultRoute(), this);
    }

    public boolean hasIPv6DefaultRoute() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIPv6DefaultRoute", $$robo$$android_net_LinkProperties$hasIPv6DefaultRoute(), this);
    }

    public boolean hasIPv4DnsServer() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIPv4DnsServer", $$robo$$android_net_LinkProperties$hasIPv4DnsServer(), this);
    }

    public boolean hasIPv6DnsServer() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIPv6DnsServer", $$robo$$android_net_LinkProperties$hasIPv6DnsServer(), this);
    }

    public boolean isIPv4Provisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv4Provisioned", $$robo$$android_net_LinkProperties$isIPv4Provisioned(), this);
    }

    public boolean isIPv6Provisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv6Provisioned", $$robo$$android_net_LinkProperties$isIPv6Provisioned(), this);
    }

    public boolean isProvisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioned", $$robo$$android_net_LinkProperties$isProvisioned(), this);
    }

    public boolean isReachable(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("isReachable", $$robo$$android_net_LinkProperties$isReachable(java.net.InetAddress ), this, inetAddress);
    }

    public boolean isIdenticalInterfaceName(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalInterfaceName", $$robo$$android_net_LinkProperties$isIdenticalInterfaceName(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalAddresses(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalAddresses", $$robo$$android_net_LinkProperties$isIdenticalAddresses(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalDnses(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalDnses", $$robo$$android_net_LinkProperties$isIdenticalDnses(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalPrivateDns(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalPrivateDns", $$robo$$android_net_LinkProperties$isIdenticalPrivateDns(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalValidatedPrivateDnses(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalValidatedPrivateDnses", $$robo$$android_net_LinkProperties$isIdenticalValidatedPrivateDnses(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalRoutes(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalRoutes", $$robo$$android_net_LinkProperties$isIdenticalRoutes(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalHttpProxy(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalHttpProxy", $$robo$$android_net_LinkProperties$isIdenticalHttpProxy(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalStackedLinks(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalStackedLinks", $$robo$$android_net_LinkProperties$isIdenticalStackedLinks(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalMtu(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalMtu", $$robo$$android_net_LinkProperties$isIdenticalMtu(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean isIdenticalTcpBufferSizes(LinkProperties linkProperties) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdenticalTcpBufferSizes", $$robo$$android_net_LinkProperties$isIdenticalTcpBufferSizes(android.net.LinkProperties ), this, linkProperties);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_LinkProperties$equals(java.lang.Object ), this, object);
    }

    public CompareResult<LinkAddress> compareAddresses(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("compareAddresses", $$robo$$android_net_LinkProperties$compareAddresses(android.net.LinkProperties ), this, linkProperties);
    }

    public CompareResult<InetAddress> compareDnses(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("compareDnses", $$robo$$android_net_LinkProperties$compareDnses(android.net.LinkProperties ), this, linkProperties);
    }

    public CompareResult<InetAddress> compareValidatedPrivateDnses(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("compareValidatedPrivateDnses", $$robo$$android_net_LinkProperties$compareValidatedPrivateDnses(android.net.LinkProperties ), this, linkProperties);
    }

    public CompareResult<RouteInfo> compareAllRoutes(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("compareAllRoutes", $$robo$$android_net_LinkProperties$compareAllRoutes(android.net.LinkProperties ), this, linkProperties);
    }

    public CompareResult<String> compareAllInterfaceNames(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("compareAllInterfaceNames", $$robo$$android_net_LinkProperties$compareAllInterfaceNames(android.net.LinkProperties ), this, linkProperties);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_LinkProperties$hashCode(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_LinkProperties$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public static boolean isValidMtu(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMtu", $$robo$$android_net_LinkProperties$isValidMtu(int boolean ), (int)n, (boolean)bl);
    }

    static {
        RobolectricInternals.classInitializing(LinkProperties.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinkProperties)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProvisioningChange
    extends Enum<ProvisioningChange> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ ProvisioningChange STILL_NOT_PROVISIONED;
        public static /* enum */ ProvisioningChange LOST_PROVISIONING;
        public static /* enum */ ProvisioningChange GAINED_PROVISIONING;
        public static /* enum */ ProvisioningChange STILL_PROVISIONED;
        private static /* synthetic */ ProvisioningChange[] $VALUES;

        private static final ProvisioningChange[] $$robo$$android_net_LinkProperties_ProvisioningChange$values() {
            return (ProvisioningChange[])$VALUES.clone();
        }

        private static final ProvisioningChange $$robo$$android_net_LinkProperties_ProvisioningChange$valueOf(String name) {
            return Enum.valueOf(ProvisioningChange.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_LinkProperties_ProvisioningChange$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            STILL_NOT_PROVISIONED = new ProvisioningChange();
            LOST_PROVISIONING = new ProvisioningChange();
            GAINED_PROVISIONING = new ProvisioningChange();
            STILL_PROVISIONED = new ProvisioningChange();
            $VALUES = new ProvisioningChange[]{STILL_NOT_PROVISIONED, LOST_PROVISIONING, GAINED_PROVISIONING, STILL_PROVISIONED};
        }

        public static ProvisioningChange[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_LinkProperties_ProvisioningChange$values());
        }

        public static ProvisioningChange valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_LinkProperties_ProvisioningChange$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_LinkProperties_ProvisioningChange$__constructor__(string2, n);
        }

        public ProvisioningChange() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkProperties_ProvisioningChange$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ProvisioningChange.class);
        }

        public /* synthetic */ ProvisioningChange() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisioningChange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CompareResult<T> {
        public /* synthetic */ Object __robo_data__;
        public List<T> removed;
        public List<T> added;

        private void $$robo$$android_net_LinkProperties_CompareResult$__constructor__() {
            this.removed = new ArrayList<T>();
            this.added = new ArrayList<T>();
        }

        private void $$robo$$android_net_LinkProperties_CompareResult$__constructor__(Collection<T> oldItems, Collection<T> newItems) {
            this.removed = new ArrayList<T>();
            this.added = new ArrayList<T>();
            if (oldItems != null) {
                this.removed.addAll(oldItems);
            }
            if (newItems != null) {
                for (T newItem : newItems) {
                    if (this.removed.remove(newItem)) continue;
                    this.added.add(newItem);
                }
            }
        }

        private final String $$robo$$android_net_LinkProperties_CompareResult$toString() {
            String retVal = "removed=[";
            for (T addr : this.removed) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "] added=[";
            for (T addr : this.added) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "]";
            return retVal;
        }

        private void __constructor__() {
            this.$$robo$$android_net_LinkProperties_CompareResult$__constructor__();
        }

        public CompareResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkProperties_CompareResult$__constructor__(), this);
        }

        private void __constructor__(Collection<T> collection, Collection<T> collection2) {
            this.$$robo$$android_net_LinkProperties_CompareResult$__constructor__(collection, collection2);
        }

        public CompareResult(Collection<T> collection, Collection<T> collection2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkProperties_CompareResult$__constructor__(java.util.Collection<T> java.util.Collection<T> ), this, collection, collection2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_LinkProperties_CompareResult$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompareResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

