/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.IIpSecService;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransform;
import android.net.IpSecTunnelInterfaceResponse;
import android.net.IpSecUdpEncapResponse;
import android.net.LinkAddress;
import android.net.Network;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IpSecManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "IpSecManager";
    public static int DIRECTION_IN = 0;
    public static int DIRECTION_OUT = 1;
    public static int INVALID_SECURITY_PARAMETER_INDEX = 0;
    public static int INVALID_RESOURCE_ID = -1;
    private Context mContext;
    private IIpSecService mService;

    private final SecurityParameterIndex $$robo$$android_net_IpSecManager$allocateSecurityParameterIndex(InetAddress destinationAddress) throws ResourceUnavailableException {
        try {
            return new SecurityParameterIndex(this.mService, destinationAddress, 0, null);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
        }
        catch (SpiUnavailableException unlikely) {
            throw new ResourceUnavailableException("No SPIs available");
        }
    }

    private final SecurityParameterIndex $$robo$$android_net_IpSecManager$allocateSecurityParameterIndex(InetAddress destinationAddress, int requestedSpi) throws SpiUnavailableException, ResourceUnavailableException {
        if (requestedSpi == 0) {
            throw new IllegalArgumentException("Requested SPI must be a valid (non-zero) SPI");
        }
        try {
            return new SecurityParameterIndex(this.mService, destinationAddress, requestedSpi, null);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
        }
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(Socket socket, int direction, IpSecTransform transform) throws IOException {
        socket.getSoLinger();
        this.applyTransportModeTransform(socket.getFileDescriptor$(), direction, transform);
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(DatagramSocket socket, int direction, IpSecTransform transform) throws IOException {
        this.applyTransportModeTransform(socket.getFileDescriptor$(), direction, transform);
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(FileDescriptor socket, int direction, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.mService.applyTransportModeTransform(pfd, direction, transform.getResourceId());
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransforms(Socket socket) throws IOException {
        socket.getSoLinger();
        this.removeTransportModeTransforms(socket.getFileDescriptor$());
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransforms(DatagramSocket socket) throws IOException {
        this.removeTransportModeTransforms(socket.getFileDescriptor$());
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransforms(FileDescriptor socket) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.mService.removeTransportModeTransforms(pfd);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_IpSecManager$removeTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    private final UdpEncapsulationSocket $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket(int port) throws IOException, ResourceUnavailableException {
        if (port == 0) {
            throw new IllegalArgumentException("Specified port must be a valid port number!");
        }
        try {
            return new UdpEncapsulationSocket(this.mService, port, null);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
    }

    private final UdpEncapsulationSocket $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        try {
            return new UdpEncapsulationSocket(this.mService, 0, null);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
    }

    private final IpSecTunnelInterface $$robo$$android_net_IpSecManager$createIpSecTunnelInterface(InetAddress localAddress, InetAddress remoteAddress, Network underlyingNetwork) throws ResourceUnavailableException, IOException {
        try {
            return new IpSecTunnelInterface(this.mContext, this.mService, localAddress, remoteAddress, underlyingNetwork, null);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
    }

    private final void $$robo$$android_net_IpSecManager$applyTunnelModeTransform(IpSecTunnelInterface tunnel, int direction, IpSecTransform transform) throws IOException {
        try {
            this.mService.applyTunnelModeTransform(tunnel.getResourceId(), direction, transform.getResourceId(), this.mContext.getOpPackageName());
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void $$robo$$android_net_IpSecManager$__constructor__(Context ctx, IIpSecService service) {
        this.mContext = ctx;
        this.mService = Preconditions.checkNotNull(service, "missing service");
    }

    private static final void $$robo$$android_net_IpSecManager$maybeHandleServiceSpecificException(ServiceSpecificException sse) {
        if (sse.errorCode == OsConstants.EINVAL) {
            throw new IllegalArgumentException(sse);
        }
        if (sse.errorCode == OsConstants.EAGAIN) {
            throw new IllegalStateException(sse);
        }
        if (sse.errorCode == OsConstants.EOPNOTSUPP) {
            throw new UnsupportedOperationException(sse);
        }
    }

    private static final RuntimeException $$robo$$android_net_IpSecManager$rethrowUncheckedExceptionFromServiceSpecificException(ServiceSpecificException sse) {
        IpSecManager.maybeHandleServiceSpecificException(sse);
        throw new RuntimeException(sse);
    }

    private static final IOException $$robo$$android_net_IpSecManager$rethrowCheckedExceptionFromServiceSpecificException(ServiceSpecificException sse) throws IOException {
        IpSecManager.maybeHandleServiceSpecificException(sse);
        throw new ErrnoException("IpSec encountered errno=" + sse.errorCode, sse.errorCode).rethrowAsIOException();
    }

    public SecurityParameterIndex allocateSecurityParameterIndex(InetAddress inetAddress) throws ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("allocateSecurityParameterIndex", $$robo$$android_net_IpSecManager$allocateSecurityParameterIndex(java.net.InetAddress ), this, inetAddress);
    }

    public SecurityParameterIndex allocateSecurityParameterIndex(InetAddress inetAddress, int n) throws SpiUnavailableException, ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("allocateSecurityParameterIndex", $$robo$$android_net_IpSecManager$allocateSecurityParameterIndex(java.net.InetAddress int ), this, inetAddress, n);
    }

    public void applyTransportModeTransform(Socket socket, int n, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(java.net.Socket int android.net.IpSecTransform ), this, socket, n, ipSecTransform);
    }

    public void applyTransportModeTransform(DatagramSocket datagramSocket, int n, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(java.net.DatagramSocket int android.net.IpSecTransform ), this, datagramSocket, n, ipSecTransform);
    }

    public void applyTransportModeTransform(FileDescriptor fileDescriptor, int n, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(java.io.FileDescriptor int android.net.IpSecTransform ), this, fileDescriptor, n, ipSecTransform);
    }

    public void removeTransportModeTransforms(Socket socket) throws IOException {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransforms", $$robo$$android_net_IpSecManager$removeTransportModeTransforms(java.net.Socket ), this, socket);
    }

    public void removeTransportModeTransforms(DatagramSocket datagramSocket) throws IOException {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransforms", $$robo$$android_net_IpSecManager$removeTransportModeTransforms(java.net.DatagramSocket ), this, datagramSocket);
    }

    public void removeTransportModeTransforms(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransforms", $$robo$$android_net_IpSecManager$removeTransportModeTransforms(java.io.FileDescriptor ), this, fileDescriptor);
    }

    public void removeTunnelModeTransform(Network network, IpSecTransform ipSecTransform) {
        InvokeDynamicSupport.bootstrap("removeTunnelModeTransform", $$robo$$android_net_IpSecManager$removeTunnelModeTransform(android.net.Network android.net.IpSecTransform ), this, network, ipSecTransform);
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket(int n) throws IOException, ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("openUdpEncapsulationSocket", $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket(int ), this, n);
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("openUdpEncapsulationSocket", $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket(), this);
    }

    public IpSecTunnelInterface createIpSecTunnelInterface(InetAddress inetAddress, InetAddress inetAddress2, Network network) throws ResourceUnavailableException, IOException {
        return InvokeDynamicSupport.bootstrap("createIpSecTunnelInterface", $$robo$$android_net_IpSecManager$createIpSecTunnelInterface(java.net.InetAddress java.net.InetAddress android.net.Network ), this, inetAddress, inetAddress2, network);
    }

    public void applyTunnelModeTransform(IpSecTunnelInterface ipSecTunnelInterface, int n, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTunnelModeTransform", $$robo$$android_net_IpSecManager$applyTunnelModeTransform(android.net.IpSecManager$IpSecTunnelInterface int android.net.IpSecTransform ), this, ipSecTunnelInterface, n, ipSecTransform);
    }

    private void __constructor__(Context context, IIpSecService iIpSecService) {
        this.$$robo$$android_net_IpSecManager$__constructor__(context, iIpSecService);
    }

    public IpSecManager(Context context, IIpSecService iIpSecService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager$__constructor__(android.content.Context android.net.IIpSecService ), this, context, iIpSecService);
    }

    private static void maybeHandleServiceSpecificException(ServiceSpecificException serviceSpecificException) {
        InvokeDynamicSupport.bootstrapStatic("maybeHandleServiceSpecificException", $$robo$$android_net_IpSecManager$maybeHandleServiceSpecificException(android.os.ServiceSpecificException ), (ServiceSpecificException)serviceSpecificException);
    }

    static RuntimeException rethrowUncheckedExceptionFromServiceSpecificException(ServiceSpecificException serviceSpecificException) {
        return InvokeDynamicSupport.bootstrapStatic("rethrowUncheckedExceptionFromServiceSpecificException", $$robo$$android_net_IpSecManager$rethrowUncheckedExceptionFromServiceSpecificException(android.os.ServiceSpecificException ), (ServiceSpecificException)serviceSpecificException);
    }

    static IOException rethrowCheckedExceptionFromServiceSpecificException(ServiceSpecificException serviceSpecificException) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("rethrowCheckedExceptionFromServiceSpecificException", $$robo$$android_net_IpSecManager$rethrowCheckedExceptionFromServiceSpecificException(android.os.ServiceSpecificException ), (ServiceSpecificException)serviceSpecificException);
    }

    public /* synthetic */ IpSecManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class IpSecTunnelInterface
    implements AutoCloseable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mOpPackageName;
        private IIpSecService mService;
        private InetAddress mRemoteAddress;
        private InetAddress mLocalAddress;
        private Network mUnderlyingNetwork;
        private CloseGuard mCloseGuard;
        private String mInterfaceName;
        private int mResourceId;

        private final String $$robo$$android_net_IpSecManager_IpSecTunnelInterface$getInterfaceName() {
            return this.mInterfaceName;
        }

        private final void $$robo$$android_net_IpSecManager_IpSecTunnelInterface$addAddress(InetAddress address, int prefixLen) throws IOException {
            try {
                this.mService.addAddressToTunnelInterface(this.mResourceId, new LinkAddress(address, prefixLen), this.mOpPackageName);
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_net_IpSecManager_IpSecTunnelInterface$removeAddress(InetAddress address, int prefixLen) throws IOException {
            try {
                this.mService.removeAddressFromTunnelInterface(this.mResourceId, new LinkAddress(address, prefixLen), this.mOpPackageName);
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private void $$robo$$android_net_IpSecManager_IpSecTunnelInterface$__constructor__(Context ctx, IIpSecService service, InetAddress localAddress, InetAddress remoteAddress, Network underlyingNetwork) throws ResourceUnavailableException, IOException {
            this.mCloseGuard = CloseGuard.get();
            this.mResourceId = -1;
            this.mOpPackageName = ctx.getOpPackageName();
            this.mService = service;
            this.mLocalAddress = localAddress;
            this.mRemoteAddress = remoteAddress;
            this.mUnderlyingNetwork = underlyingNetwork;
            try {
                IpSecTunnelInterfaceResponse result = this.mService.createTunnelInterface(localAddress.getHostAddress(), remoteAddress.getHostAddress(), underlyingNetwork, new Binder(), this.mOpPackageName);
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more tunnel interfaces may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mInterfaceName = result.interfaceName;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("constructor");
        }

        private final void $$robo$$android_net_IpSecManager_IpSecTunnelInterface$close() {
            try {
                this.mService.deleteTunnelInterface(this.mResourceId, this.mOpPackageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (Exception e) {
                Log.e("IpSecManager", "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
        }

        private final void $$robo$$android_net_IpSecManager_IpSecTunnelInterface$finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        @VisibleForTesting
        private final int $$robo$$android_net_IpSecManager_IpSecTunnelInterface$getResourceId() {
            return this.mResourceId;
        }

        private final String $$robo$$android_net_IpSecManager_IpSecTunnelInterface$toString() {
            return "IpSecTunnelInterface{ifname=" + this.mInterfaceName + ",resourceId=" + this.mResourceId + "}";
        }

        private /* synthetic */ void $$robo$$android_net_IpSecManager_IpSecTunnelInterface$__constructor__(Context x0, IIpSecService x1, InetAddress x2, InetAddress x3, Network x4, 1 x5) throws ResourceUnavailableException, IOException {
        }

        public String getInterfaceName() {
            return InvokeDynamicSupport.bootstrap("getInterfaceName", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$getInterfaceName(), this);
        }

        public void addAddress(InetAddress inetAddress, int n) throws IOException {
            InvokeDynamicSupport.bootstrap("addAddress", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$addAddress(java.net.InetAddress int ), this, inetAddress, n);
        }

        public void removeAddress(InetAddress inetAddress, int n) throws IOException {
            InvokeDynamicSupport.bootstrap("removeAddress", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$removeAddress(java.net.InetAddress int ), this, inetAddress, n);
        }

        private void __constructor__(Context context, IIpSecService iIpSecService, InetAddress inetAddress, InetAddress inetAddress2, Network network) throws ResourceUnavailableException, IOException {
            this.$$robo$$android_net_IpSecManager_IpSecTunnelInterface$__constructor__(context, iIpSecService, inetAddress, inetAddress2, network);
        }

        public IpSecTunnelInterface(Context context, IIpSecService iIpSecService, InetAddress inetAddress, InetAddress inetAddress2, Network network) throws ResourceUnavailableException, IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$__constructor__(android.content.Context android.net.IIpSecService java.net.InetAddress java.net.InetAddress android.net.Network ), this, context, iIpSecService, inetAddress, inetAddress2, network);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$finalize(), this);
        }

        public int getResourceId() {
            return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$getResourceId(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$toString(), this);
        }

        private /* synthetic */ void __constructor__(Context context, IIpSecService iIpSecService, InetAddress inetAddress, InetAddress inetAddress2, Network network, 1 var6_6) throws ResourceUnavailableException, IOException {
            this.$$robo$$android_net_IpSecManager_IpSecTunnelInterface$__constructor__(context, iIpSecService, inetAddress, inetAddress2, network, var6_6);
        }

        public /* synthetic */ IpSecTunnelInterface(Context context, IIpSecService iIpSecService, InetAddress inetAddress, InetAddress inetAddress2, Network network, 1 var6_6) throws ResourceUnavailableException, IOException {
            this(context, iIpSecService, inetAddress, inetAddress2, network);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_IpSecTunnelInterface$__constructor__(android.content.Context android.net.IIpSecService java.net.InetAddress java.net.InetAddress android.net.Network android.net.IpSecManager$1 ), this, context, iIpSecService, inetAddress, inetAddress2, network, var6_6);
        }

        public /* synthetic */ IpSecTunnelInterface() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecTunnelInterface)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class UdpEncapsulationSocket
    implements AutoCloseable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ParcelFileDescriptor mPfd;
        private IIpSecService mService;
        private int mResourceId;
        private int mPort;
        private CloseGuard mCloseGuard;

        private void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(IIpSecService service, int port) throws ResourceUnavailableException, IOException {
            this.mResourceId = -1;
            this.mCloseGuard = CloseGuard.get();
            this.mService = service;
            try {
                IpSecUdpEncapResponse result = this.mService.openUdpEncapsulationSocket(port, new Binder());
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more Sockets may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mPort = result.port;
                this.mPfd = result.fileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("constructor");
        }

        private final FileDescriptor $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getFileDescriptor() {
            if (this.mPfd == null) {
                return null;
            }
            return this.mPfd.getFileDescriptor();
        }

        private final int $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getPort() {
            return this.mPort;
        }

        private final void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$close() throws IOException {
            try {
                this.mService.closeUdpEncapsulationSocket(this.mResourceId);
                this.mResourceId = -1;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (Exception e) {
                Log.e("IpSecManager", "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
            try {
                this.mPfd.close();
            }
            catch (IOException e) {
                Log.e("IpSecManager", "Failed to close UDP Encapsulation Socket with Port= " + this.mPort);
                throw e;
            }
        }

        private final void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        @VisibleForTesting
        private final int $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getResourceId() {
            return this.mResourceId;
        }

        private final String $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$toString() {
            return "UdpEncapsulationSocket{port=" + this.mPort + ",resourceId=" + this.mResourceId + "}";
        }

        private /* synthetic */ void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(IIpSecService x0, int x1, 1 x2) throws ResourceUnavailableException, IOException {
        }

        private void __constructor__(IIpSecService iIpSecService, int n) throws ResourceUnavailableException, IOException {
            this.$$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(iIpSecService, n);
        }

        public UdpEncapsulationSocket(IIpSecService iIpSecService, int n) throws ResourceUnavailableException, IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(android.net.IIpSecService int ), this, iIpSecService, n);
        }

        public FileDescriptor getFileDescriptor() {
            return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getFileDescriptor(), this);
        }

        public int getPort() {
            return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getPort(), this);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$finalize(), this);
        }

        public int getResourceId() {
            return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getResourceId(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$toString(), this);
        }

        private /* synthetic */ void __constructor__(IIpSecService iIpSecService, int n, 1 var3_3) throws ResourceUnavailableException, IOException {
            this.$$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(iIpSecService, n, var3_3);
        }

        public /* synthetic */ UdpEncapsulationSocket(IIpSecService iIpSecService, int n, 1 var3_3) throws ResourceUnavailableException, IOException {
            this(iIpSecService, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(android.net.IIpSecService int android.net.IpSecManager$1 ), this, iIpSecService, n, var3_3);
        }

        public /* synthetic */ UdpEncapsulationSocket() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UdpEncapsulationSocket)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SecurityParameterIndex
    implements AutoCloseable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private IIpSecService mService;
        private InetAddress mDestinationAddress;
        private CloseGuard mCloseGuard;
        private int mSpi;
        private int mResourceId;

        private final int $$robo$$android_net_IpSecManager_SecurityParameterIndex$getSpi() {
            return this.mSpi;
        }

        private final void $$robo$$android_net_IpSecManager_SecurityParameterIndex$close() {
            try {
                this.mService.releaseSecurityParameterIndex(this.mResourceId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (Exception e) {
                Log.e("IpSecManager", "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
        }

        private final void $$robo$$android_net_IpSecManager_SecurityParameterIndex$finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        private void $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(IIpSecService service, InetAddress destinationAddress, int spi) throws ResourceUnavailableException, SpiUnavailableException {
            this.mCloseGuard = CloseGuard.get();
            this.mSpi = 0;
            this.mResourceId = -1;
            this.mService = service;
            this.mDestinationAddress = destinationAddress;
            try {
                IpSecSpiResponse result = this.mService.allocateSecurityParameterIndex(destinationAddress.getHostAddress(), spi, new Binder());
                if (result == null) {
                    throw new NullPointerException("Received null response from IpSecService");
                }
                int status = result.status;
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more SPIs may be allocated by this requester.");
                    }
                    case 2: {
                        throw new SpiUnavailableException("Requested SPI is unavailable", spi);
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + status);
                    }
                }
                this.mSpi = result.spi;
                this.mResourceId = result.resourceId;
                if (this.mSpi == 0) {
                    throw new RuntimeException("Invalid SPI returned by IpSecService: " + status);
                }
                if (this.mResourceId == -1) {
                    throw new RuntimeException("Invalid Resource ID returned by IpSecService: " + status);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("open");
        }

        @VisibleForTesting
        private final int $$robo$$android_net_IpSecManager_SecurityParameterIndex$getResourceId() {
            return this.mResourceId;
        }

        private final String $$robo$$android_net_IpSecManager_SecurityParameterIndex$toString() {
            return "SecurityParameterIndex{spi=" + this.mSpi + ",resourceId=" + this.mResourceId + "}";
        }

        private /* synthetic */ void $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(IIpSecService x0, InetAddress x1, int x2, 1 x3) throws ResourceUnavailableException, SpiUnavailableException {
        }

        public int getSpi() {
            return (int)InvokeDynamicSupport.bootstrap("getSpi", $$robo$$android_net_IpSecManager_SecurityParameterIndex$getSpi(), this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecManager_SecurityParameterIndex$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecManager_SecurityParameterIndex$finalize(), this);
        }

        private void __constructor__(IIpSecService iIpSecService, InetAddress inetAddress, int n) throws ResourceUnavailableException, SpiUnavailableException {
            this.$$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(iIpSecService, inetAddress, n);
        }

        public SecurityParameterIndex(IIpSecService iIpSecService, InetAddress inetAddress, int n) throws ResourceUnavailableException, SpiUnavailableException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(android.net.IIpSecService java.net.InetAddress int ), this, iIpSecService, inetAddress, n);
        }

        public int getResourceId() {
            return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecManager_SecurityParameterIndex$getResourceId(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_IpSecManager_SecurityParameterIndex$toString(), this);
        }

        private /* synthetic */ void __constructor__(IIpSecService iIpSecService, InetAddress inetAddress, int n, 1 var4_4) throws ResourceUnavailableException, SpiUnavailableException {
            this.$$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(iIpSecService, inetAddress, n, var4_4);
        }

        public /* synthetic */ SecurityParameterIndex(IIpSecService iIpSecService, InetAddress inetAddress, int n, 1 var4_4) throws ResourceUnavailableException, SpiUnavailableException {
            this(iIpSecService, inetAddress, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(android.net.IIpSecService java.net.InetAddress int android.net.IpSecManager$1 ), this, iIpSecService, inetAddress, n, var4_4);
        }

        public /* synthetic */ SecurityParameterIndex() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SecurityParameterIndex)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ResourceUnavailableException
    extends AndroidException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_IpSecManager_ResourceUnavailableException$__constructor__(String msg) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_IpSecManager_ResourceUnavailableException$__constructor__(string2);
        }

        public ResourceUnavailableException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_ResourceUnavailableException$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ ResourceUnavailableException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceUnavailableException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SpiUnavailableException
    extends AndroidException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mSpi;

        private void $$robo$$android_net_IpSecManager_SpiUnavailableException$__constructor__(String msg, int spi) {
            this.mSpi = spi;
        }

        private final int $$robo$$android_net_IpSecManager_SpiUnavailableException$getSpi() {
            return this.mSpi;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_IpSecManager_SpiUnavailableException$__constructor__(string2, n);
        }

        public SpiUnavailableException(String string2, int n) {
            super(string2 + " (spi: " + n + ")");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_SpiUnavailableException$__constructor__(java.lang.String int ), this, string2, n);
        }

        public int getSpi() {
            return (int)InvokeDynamicSupport.bootstrap("getSpi", $$robo$$android_net_IpSecManager_SpiUnavailableException$getSpi(), this);
        }

        public /* synthetic */ SpiUnavailableException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpiUnavailableException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Status {
        public static final int OK = 0;
        public static final int RESOURCE_UNAVAILABLE = 1;
        public static final int SPI_UNAVAILABLE = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyDirection {
    }
}

