/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.PlaybackParams;
import android.media.tv.ITvInputServiceCallback;
import android.media.tv.ITvInputSession;
import android.media.tv.ITvInputSessionCallback;
import android.media.tv.ITvInputSessionWrapper;
import android.media.tv.TvContentRating;
import android.media.tv.TvContract;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class TvInputService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "TvInputService";
    private static int DETACH_OVERLAY_VIEW_TIMEOUT_MS = 5000;
    public static String SERVICE_INTERFACE = "android.media.tv.TvInputService";
    public static String SERVICE_META_DATA = "android.media.tv.input";
    private Handler mServiceHandler;
    private RemoteCallbackList<ITvInputServiceCallback> mCallbacks;
    private TvInputManager mTvInputManager;

    private void $$robo$$android_media_tv_TvInputService$__constructor__() {
        this.mServiceHandler = new ServiceHandler(this, null);
        this.mCallbacks = new RemoteCallbackList();
    }

    private final IBinder $$robo$$android_media_tv_TvInputService$onBind(Intent intent) {
        return new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TvInputService this$0;

            private void $$robo$$android_media_tv_TvInputService_1$__constructor__(TvInputService this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_tv_TvInputService_1$registerCallback(ITvInputServiceCallback cb) {
                if (cb != null) {
                    this.this$0.mCallbacks.register(cb);
                }
            }

            private final void $$robo$$android_media_tv_TvInputService_1$unregisterCallback(ITvInputServiceCallback cb) {
                if (cb != null) {
                    this.this$0.mCallbacks.unregister(cb);
                }
            }

            private final void $$robo$$android_media_tv_TvInputService_1$createSession(InputChannel channel, ITvInputSessionCallback cb, String inputId) {
                if (channel == null) {
                    Log.w("TvInputService", "Creating session without input channel");
                }
                if (cb == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = channel;
                args.arg2 = cb;
                args.arg3 = inputId;
                this.this$0.mServiceHandler.obtainMessage(1, args).sendToTarget();
            }

            private final void $$robo$$android_media_tv_TvInputService_1$createRecordingSession(ITvInputSessionCallback cb, String inputId) {
                if (cb == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = cb;
                args.arg2 = inputId;
                this.this$0.mServiceHandler.obtainMessage(3, args).sendToTarget();
            }

            private final void $$robo$$android_media_tv_TvInputService_1$notifyHardwareAdded(TvInputHardwareInfo hardwareInfo) {
                this.this$0.mServiceHandler.obtainMessage(4, hardwareInfo).sendToTarget();
            }

            private final void $$robo$$android_media_tv_TvInputService_1$notifyHardwareRemoved(TvInputHardwareInfo hardwareInfo) {
                this.this$0.mServiceHandler.obtainMessage(5, hardwareInfo).sendToTarget();
            }

            private final void $$robo$$android_media_tv_TvInputService_1$notifyHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
                this.this$0.mServiceHandler.obtainMessage(6, deviceInfo).sendToTarget();
            }

            private final void $$robo$$android_media_tv_TvInputService_1$notifyHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
                this.this$0.mServiceHandler.obtainMessage(7, deviceInfo).sendToTarget();
            }

            private void __constructor__(TvInputService tvInputService) {
                this.$$robo$$android_media_tv_TvInputService_1$__constructor__(tvInputService);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_1$__constructor__(android.media.tv.TvInputService ), this, tvInputService);
            }

            @Override
            public void registerCallback(ITvInputServiceCallback iTvInputServiceCallback) {
                InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_media_tv_TvInputService_1$registerCallback(android.media.tv.ITvInputServiceCallback ), this, iTvInputServiceCallback);
            }

            @Override
            public void unregisterCallback(ITvInputServiceCallback iTvInputServiceCallback) {
                InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_media_tv_TvInputService_1$unregisterCallback(android.media.tv.ITvInputServiceCallback ), this, iTvInputServiceCallback);
            }

            @Override
            public void createSession(InputChannel inputChannel, ITvInputSessionCallback iTvInputSessionCallback, String string2) {
                InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_media_tv_TvInputService_1$createSession(android.view.InputChannel android.media.tv.ITvInputSessionCallback java.lang.String ), this, inputChannel, iTvInputSessionCallback, string2);
            }

            @Override
            public void createRecordingSession(ITvInputSessionCallback iTvInputSessionCallback, String string2) {
                InvokeDynamicSupport.bootstrap("createRecordingSession", $$robo$$android_media_tv_TvInputService_1$createRecordingSession(android.media.tv.ITvInputSessionCallback java.lang.String ), this, iTvInputSessionCallback, string2);
            }

            @Override
            public void notifyHardwareAdded(TvInputHardwareInfo tvInputHardwareInfo) {
                InvokeDynamicSupport.bootstrap("notifyHardwareAdded", $$robo$$android_media_tv_TvInputService_1$notifyHardwareAdded(android.media.tv.TvInputHardwareInfo ), this, tvInputHardwareInfo);
            }

            @Override
            public void notifyHardwareRemoved(TvInputHardwareInfo tvInputHardwareInfo) {
                InvokeDynamicSupport.bootstrap("notifyHardwareRemoved", $$robo$$android_media_tv_TvInputService_1$notifyHardwareRemoved(android.media.tv.TvInputHardwareInfo ), this, tvInputHardwareInfo);
            }

            @Override
            public void notifyHdmiDeviceAdded(HdmiDeviceInfo hdmiDeviceInfo) {
                InvokeDynamicSupport.bootstrap("notifyHdmiDeviceAdded", $$robo$$android_media_tv_TvInputService_1$notifyHdmiDeviceAdded(android.hardware.hdmi.HdmiDeviceInfo ), this, hdmiDeviceInfo);
            }

            @Override
            public void notifyHdmiDeviceRemoved(HdmiDeviceInfo hdmiDeviceInfo) {
                InvokeDynamicSupport.bootstrap("notifyHdmiDeviceRemoved", $$robo$$android_media_tv_TvInputService_1$notifyHdmiDeviceRemoved(android.hardware.hdmi.HdmiDeviceInfo ), this, hdmiDeviceInfo);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public abstract Session onCreateSession(String var1);

    private final RecordingSession $$robo$$android_media_tv_TvInputService$onCreateRecordingSession(String inputId) {
        return null;
    }

    @SystemApi
    private final TvInputInfo $$robo$$android_media_tv_TvInputService$onHardwareAdded(TvInputHardwareInfo hardwareInfo) {
        return null;
    }

    @SystemApi
    private final String $$robo$$android_media_tv_TvInputService$onHardwareRemoved(TvInputHardwareInfo hardwareInfo) {
        return null;
    }

    @SystemApi
    private final TvInputInfo $$robo$$android_media_tv_TvInputService$onHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
        return null;
    }

    @SystemApi
    private final String $$robo$$android_media_tv_TvInputService$onHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
        return null;
    }

    private final boolean $$robo$$android_media_tv_TvInputService$isPassthroughInput(String inputId) {
        TvInputInfo info;
        if (this.mTvInputManager == null) {
            this.mTvInputManager = (TvInputManager)this.getSystemService("tv_input");
        }
        return (info = this.mTvInputManager.getTvInputInfo(inputId)) != null && info.isPassthroughInput();
    }

    private static final boolean $$robo$$android_media_tv_TvInputService$isNavigationKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_media_tv_TvInputService$__constructor__();
    }

    public TvInputService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService$__constructor__(), this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_media_tv_TvInputService$onBind(android.content.Intent ), this, intent);
    }

    public RecordingSession onCreateRecordingSession(String string2) {
        return InvokeDynamicSupport.bootstrap("onCreateRecordingSession", $$robo$$android_media_tv_TvInputService$onCreateRecordingSession(java.lang.String ), this, string2);
    }

    @SystemApi
    public TvInputInfo onHardwareAdded(TvInputHardwareInfo tvInputHardwareInfo) {
        return InvokeDynamicSupport.bootstrap("onHardwareAdded", $$robo$$android_media_tv_TvInputService$onHardwareAdded(android.media.tv.TvInputHardwareInfo ), this, tvInputHardwareInfo);
    }

    @SystemApi
    public String onHardwareRemoved(TvInputHardwareInfo tvInputHardwareInfo) {
        return InvokeDynamicSupport.bootstrap("onHardwareRemoved", $$robo$$android_media_tv_TvInputService$onHardwareRemoved(android.media.tv.TvInputHardwareInfo ), this, tvInputHardwareInfo);
    }

    @SystemApi
    public TvInputInfo onHdmiDeviceAdded(HdmiDeviceInfo hdmiDeviceInfo) {
        return InvokeDynamicSupport.bootstrap("onHdmiDeviceAdded", $$robo$$android_media_tv_TvInputService$onHdmiDeviceAdded(android.hardware.hdmi.HdmiDeviceInfo ), this, hdmiDeviceInfo);
    }

    @SystemApi
    public String onHdmiDeviceRemoved(HdmiDeviceInfo hdmiDeviceInfo) {
        return InvokeDynamicSupport.bootstrap("onHdmiDeviceRemoved", $$robo$$android_media_tv_TvInputService$onHdmiDeviceRemoved(android.hardware.hdmi.HdmiDeviceInfo ), this, hdmiDeviceInfo);
    }

    private boolean isPassthroughInput(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPassthroughInput", $$robo$$android_media_tv_TvInputService$isPassthroughInput(java.lang.String ), this, string2);
    }

    public static boolean isNavigationKey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNavigationKey", $$robo$$android_media_tv_TvInputService$isNavigationKey(int ), (int)n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    @SuppressLint(value={"HandlerLeak"})
    private final class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int DO_CREATE_SESSION = 1;
        private static int DO_NOTIFY_SESSION_CREATED = 2;
        private static int DO_CREATE_RECORDING_SESSION = 3;
        private static int DO_ADD_HARDWARE_INPUT = 4;
        private static int DO_REMOVE_HARDWARE_INPUT = 5;
        private static int DO_ADD_HDMI_INPUT = 6;
        private static int DO_REMOVE_HDMI_INPUT = 7;
        /* synthetic */ TvInputService this$0;

        private void $$robo$$android_media_tv_TvInputService_ServiceHandler$__constructor__(TvInputService tvInputService) {
            this.this$0 = tvInputService;
        }

        private final void $$robo$$android_media_tv_TvInputService_ServiceHandler$broadcastAddHardwareInput(int deviceId, TvInputInfo inputInfo) {
            int n = this.this$0.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)this.this$0.mCallbacks.getBroadcastItem(i)).addHardwareInput(deviceId, inputInfo);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e("TvInputService", "error in broadcastAddHardwareInput", e);
                }
            }
            this.this$0.mCallbacks.finishBroadcast();
        }

        private final void $$robo$$android_media_tv_TvInputService_ServiceHandler$broadcastAddHdmiInput(int id2, TvInputInfo inputInfo) {
            int n = this.this$0.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)this.this$0.mCallbacks.getBroadcastItem(i)).addHdmiInput(id2, inputInfo);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e("TvInputService", "error in broadcastAddHdmiInput", e);
                }
            }
            this.this$0.mCallbacks.finishBroadcast();
        }

        private final void $$robo$$android_media_tv_TvInputService_ServiceHandler$broadcastRemoveHardwareInput(String inputId) {
            int n = this.this$0.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((ITvInputServiceCallback)this.this$0.mCallbacks.getBroadcastItem(i)).removeHardwareInput(inputId);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e("TvInputService", "error in broadcastRemoveHardwareInput", e);
                }
            }
            this.this$0.mCallbacks.finishBroadcast();
        }

        private final void $$robo$$android_media_tv_TvInputService_ServiceHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    InputChannel channel = (InputChannel)args.arg1;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg2;
                    String inputId = (String)args.arg3;
                    args.recycle();
                    Session sessionImpl = this.this$0.onCreateSession(inputId);
                    if (sessionImpl == null) {
                        try {
                            cb.onSessionCreated(null, null);
                        }
                        catch (RemoteException e) {
                            Log.e("TvInputService", "error in onSessionCreated", e);
                        }
                        return;
                    }
                    ITvInputSessionWrapper stub = new ITvInputSessionWrapper(this.this$0, sessionImpl, channel);
                    if (sessionImpl instanceof HardwareSession) {
                        HardwareSession proxySession = (HardwareSession)sessionImpl;
                        String hardwareInputId = proxySession.getHardwareInputId();
                        if (TextUtils.isEmpty(hardwareInputId) || !this.this$0.isPassthroughInput(hardwareInputId)) {
                            if (TextUtils.isEmpty(hardwareInputId)) {
                                Log.w("TvInputService", "Hardware input id is not setup yet.");
                            } else {
                                Log.w("TvInputService", "Invalid hardware input id : " + hardwareInputId);
                            }
                            sessionImpl.onRelease();
                            try {
                                cb.onSessionCreated(null, null);
                            }
                            catch (RemoteException e) {
                                Log.e("TvInputService", "error in onSessionCreated", e);
                            }
                            return;
                        }
                        proxySession.mProxySession = stub;
                        proxySession.mProxySessionCallback = cb;
                        proxySession.mServiceHandler = this.this$0.mServiceHandler;
                        TvInputManager manager = (TvInputManager)this.this$0.getSystemService("tv_input");
                        manager.createSession(hardwareInputId, proxySession.mHardwareSessionCallback, this.this$0.mServiceHandler);
                    } else {
                        SomeArgs someArgs = SomeArgs.obtain();
                        someArgs.arg1 = sessionImpl;
                        someArgs.arg2 = stub;
                        someArgs.arg3 = cb;
                        someArgs.arg4 = null;
                        this.this$0.mServiceHandler.obtainMessage(2, someArgs).sendToTarget();
                    }
                    return;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Session sessionImpl = (Session)args.arg1;
                    ITvInputSession stub = (ITvInputSession)args.arg2;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg3;
                    IBinder hardwareSessionToken = (IBinder)args.arg4;
                    try {
                        cb.onSessionCreated(stub, hardwareSessionToken);
                    }
                    catch (RemoteException e) {
                        Log.e("TvInputService", "error in onSessionCreated", e);
                    }
                    if (sessionImpl != null) {
                        sessionImpl.initialize(cb);
                    }
                    args.recycle();
                    return;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ITvInputSessionCallback cb = (ITvInputSessionCallback)args.arg1;
                    String inputId = (String)args.arg2;
                    args.recycle();
                    RecordingSession recordingSessionImpl = this.this$0.onCreateRecordingSession(inputId);
                    if (recordingSessionImpl == null) {
                        try {
                            cb.onSessionCreated(null, null);
                        }
                        catch (RemoteException e) {
                            Log.e("TvInputService", "error in onSessionCreated", e);
                        }
                        return;
                    }
                    ITvInputSessionWrapper stub = new ITvInputSessionWrapper(this.this$0, recordingSessionImpl);
                    try {
                        cb.onSessionCreated(stub, null);
                    }
                    catch (RemoteException e) {
                        Log.e("TvInputService", "error in onSessionCreated", e);
                    }
                    recordingSessionImpl.initialize(cb);
                    return;
                }
                case 4: {
                    TvInputHardwareInfo hardwareInfo = (TvInputHardwareInfo)msg.obj;
                    TvInputInfo inputInfo = this.this$0.onHardwareAdded(hardwareInfo);
                    if (inputInfo != null) {
                        this.broadcastAddHardwareInput(hardwareInfo.getDeviceId(), inputInfo);
                    }
                    return;
                }
                case 5: {
                    TvInputHardwareInfo hardwareInfo = (TvInputHardwareInfo)msg.obj;
                    String inputId = this.this$0.onHardwareRemoved(hardwareInfo);
                    if (inputId != null) {
                        this.broadcastRemoveHardwareInput(inputId);
                    }
                    return;
                }
                case 6: {
                    HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
                    TvInputInfo inputInfo = this.this$0.onHdmiDeviceAdded(deviceInfo);
                    if (inputInfo != null) {
                        this.broadcastAddHdmiInput(deviceInfo.getId(), inputInfo);
                    }
                    return;
                }
                case 7: {
                    HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
                    String inputId = this.this$0.onHdmiDeviceRemoved(deviceInfo);
                    if (inputId != null) {
                        this.broadcastRemoveHardwareInput(inputId);
                    }
                    return;
                }
            }
            Log.w("TvInputService", "Unhandled message code: " + msg.what);
        }

        private /* synthetic */ void $$robo$$android_media_tv_TvInputService_ServiceHandler$__constructor__(TvInputService x0, 1 x1) {
        }

        private void __constructor__(TvInputService tvInputService) {
            this.$$robo$$android_media_tv_TvInputService_ServiceHandler$__constructor__(tvInputService);
        }

        public ServiceHandler(TvInputService tvInputService) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_ServiceHandler$__constructor__(android.media.tv.TvInputService ), this, tvInputService);
        }

        private void broadcastAddHardwareInput(int n, TvInputInfo tvInputInfo) {
            InvokeDynamicSupport.bootstrap("broadcastAddHardwareInput", $$robo$$android_media_tv_TvInputService_ServiceHandler$broadcastAddHardwareInput(int android.media.tv.TvInputInfo ), this, n, tvInputInfo);
        }

        private void broadcastAddHdmiInput(int n, TvInputInfo tvInputInfo) {
            InvokeDynamicSupport.bootstrap("broadcastAddHdmiInput", $$robo$$android_media_tv_TvInputService_ServiceHandler$broadcastAddHdmiInput(int android.media.tv.TvInputInfo ), this, n, tvInputInfo);
        }

        private void broadcastRemoveHardwareInput(String string2) {
            InvokeDynamicSupport.bootstrap("broadcastRemoveHardwareInput", $$robo$$android_media_tv_TvInputService_ServiceHandler$broadcastRemoveHardwareInput(java.lang.String ), this, string2);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_tv_TvInputService_ServiceHandler$handleMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(TvInputService tvInputService, 1 var2_2) {
            this.$$robo$$android_media_tv_TvInputService_ServiceHandler$__constructor__(tvInputService, var2_2);
        }

        public /* synthetic */ ServiceHandler(TvInputService tvInputService, 1 var2_2) {
            this(tvInputService);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_ServiceHandler$__constructor__(android.media.tv.TvInputService android.media.tv.TvInputService$1 ), this, tvInputService, var2_2);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class HardwareSession
    extends Session
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TvInputManager.Session mHardwareSession;
        private ITvInputSession mProxySession;
        private ITvInputSessionCallback mProxySessionCallback;
        private Handler mServiceHandler;
        private TvInputManager.SessionCallback mHardwareSessionCallback;

        private void $$robo$$android_media_tv_TvInputService_HardwareSession$__constructor__(Context context) {
            this.mHardwareSessionCallback = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ HardwareSession this$0;

                private void $$robo$$android_media_tv_TvInputService_HardwareSession_1$__constructor__(HardwareSession this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_tv_TvInputService_HardwareSession_1$onSessionCreated(TvInputManager.Session session) {
                    this.this$0.mHardwareSession = session;
                    SomeArgs args = SomeArgs.obtain();
                    if (session != null) {
                        args.arg1 = this.this$0;
                        args.arg2 = this.this$0.mProxySession;
                        args.arg3 = this.this$0.mProxySessionCallback;
                        args.arg4 = session.getToken();
                        session.tune(TvContract.buildChannelUriForPassthroughInput(this.this$0.getHardwareInputId()));
                    } else {
                        args.arg1 = null;
                        args.arg2 = null;
                        args.arg3 = this.this$0.mProxySessionCallback;
                        args.arg4 = null;
                        this.this$0.onRelease();
                    }
                    this.this$0.mServiceHandler.obtainMessage(2, args).sendToTarget();
                }

                private final void $$robo$$android_media_tv_TvInputService_HardwareSession_1$onVideoAvailable(TvInputManager.Session session) {
                    if (this.this$0.mHardwareSession == session) {
                        this.this$0.onHardwareVideoAvailable();
                    }
                }

                private final void $$robo$$android_media_tv_TvInputService_HardwareSession_1$onVideoUnavailable(TvInputManager.Session session, int reason) {
                    if (this.this$0.mHardwareSession == session) {
                        this.this$0.onHardwareVideoUnavailable(reason);
                    }
                }

                private void __constructor__(HardwareSession hardwareSession) {
                    this.$$robo$$android_media_tv_TvInputService_HardwareSession_1$__constructor__(hardwareSession);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_HardwareSession_1$__constructor__(android.media.tv.TvInputService$HardwareSession ), this, hardwareSession);
                }

                @Override
                public void onSessionCreated(TvInputManager.Session session) {
                    InvokeDynamicSupport.bootstrap("onSessionCreated", $$robo$$android_media_tv_TvInputService_HardwareSession_1$onSessionCreated(android.media.tv.TvInputManager$Session ), this, session);
                }

                @Override
                public void onVideoAvailable(TvInputManager.Session session) {
                    InvokeDynamicSupport.bootstrap("onVideoAvailable", $$robo$$android_media_tv_TvInputService_HardwareSession_1$onVideoAvailable(android.media.tv.TvInputManager$Session ), this, session);
                }

                @Override
                public void onVideoUnavailable(TvInputManager.Session session, int n) {
                    InvokeDynamicSupport.bootstrap("onVideoUnavailable", $$robo$$android_media_tv_TvInputService_HardwareSession_1$onVideoUnavailable(android.media.tv.TvInputManager$Session int ), this, session, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public abstract String getHardwareInputId();

        private final boolean $$robo$$android_media_tv_TvInputService_HardwareSession$onSetSurface(Surface surface) {
            Log.e("TvInputService", "onSetSurface() should not be called in HardwareProxySession.");
            return false;
        }

        private final void $$robo$$android_media_tv_TvInputService_HardwareSession$onHardwareVideoAvailable() {
        }

        private final void $$robo$$android_media_tv_TvInputService_HardwareSession$onHardwareVideoUnavailable(int reason) {
        }

        private final void $$robo$$android_media_tv_TvInputService_HardwareSession$release() {
            if (this.mHardwareSession != null) {
                this.mHardwareSession.release();
                this.mHardwareSession = null;
            }
            super.release();
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_media_tv_TvInputService_HardwareSession$__constructor__(context);
        }

        public HardwareSession(Context context) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_HardwareSession$__constructor__(android.content.Context ), this, context);
        }

        @Override
        public boolean onSetSurface(Surface surface) {
            return (boolean)InvokeDynamicSupport.bootstrap("onSetSurface", $$robo$$android_media_tv_TvInputService_HardwareSession$onSetSurface(android.view.Surface ), this, surface);
        }

        public void onHardwareVideoAvailable() {
            InvokeDynamicSupport.bootstrap("onHardwareVideoAvailable", $$robo$$android_media_tv_TvInputService_HardwareSession$onHardwareVideoAvailable(), this);
        }

        public void onHardwareVideoUnavailable(int n) {
            InvokeDynamicSupport.bootstrap("onHardwareVideoUnavailable", $$robo$$android_media_tv_TvInputService_HardwareSession$onHardwareVideoUnavailable(int ), this, n);
        }

        @Override
        void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_TvInputService_HardwareSession$release(), this);
        }

        public /* synthetic */ HardwareSession() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HardwareSession)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class RecordingSession
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Handler mHandler;
        private Object mLock;
        private ITvInputSessionCallback mSessionCallback;
        private List<Runnable> mPendingActions;

        private void $$robo$$android_media_tv_TvInputService_RecordingSession$__constructor__(Context context) {
            this.mLock = new Object();
            this.mPendingActions = new ArrayList<Runnable>();
            this.mHandler = new Handler(context.getMainLooper());
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$notifyTuned(Uri channelUri) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, channelUri){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Uri val$channelUri;
                /* synthetic */ RecordingSession this$0;

                private void $$robo$$android_media_tv_TvInputService_RecordingSession_1$__constructor__(RecordingSession this$0, Uri uri) {
                    this.this$0 = this$0;
                    this.val$channelUri = uri;
                }

                private final void $$robo$$android_media_tv_TvInputService_RecordingSession_1$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onTuned(this.val$channelUri);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyTuned", e);
                    }
                }

                private void __constructor__(RecordingSession recordingSession, Uri uri) {
                    this.$$robo$$android_media_tv_TvInputService_RecordingSession_1$__constructor__(recordingSession, uri);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_RecordingSession_1$__constructor__(android.media.tv.TvInputService$RecordingSession android.net.Uri ), this, recordingSession, uri);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_RecordingSession_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$notifyRecordingStopped(Uri recordedProgramUri) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, recordedProgramUri){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Uri val$recordedProgramUri;
                /* synthetic */ RecordingSession this$0;

                private void $$robo$$android_media_tv_TvInputService_RecordingSession_2$__constructor__(RecordingSession this$0, Uri uri) {
                    this.this$0 = this$0;
                    this.val$recordedProgramUri = uri;
                }

                private final void $$robo$$android_media_tv_TvInputService_RecordingSession_2$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onRecordingStopped(this.val$recordedProgramUri);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyRecordingStopped", e);
                    }
                }

                private void __constructor__(RecordingSession recordingSession, Uri uri) {
                    this.$$robo$$android_media_tv_TvInputService_RecordingSession_2$__constructor__(recordingSession, uri);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_RecordingSession_2$__constructor__(android.media.tv.TvInputService$RecordingSession android.net.Uri ), this, recordingSession, uri);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_RecordingSession_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$notifyError(int error) {
            if (error < 0 || error > 2) {
                Log.w("TvInputService", "notifyError - invalid error code (" + error + ") is changed to RECORDING_ERROR_UNKNOWN.");
                error = 0;
            }
            int validError = error;
            this.executeOrPostRunnableOnMainThread(new Runnable(this, validError){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$validError;
                /* synthetic */ RecordingSession this$0;

                private void $$robo$$android_media_tv_TvInputService_RecordingSession_3$__constructor__(RecordingSession this$0, int n) {
                    this.this$0 = this$0;
                    this.val$validError = n;
                }

                private final void $$robo$$android_media_tv_TvInputService_RecordingSession_3$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onError(this.val$validError);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyError", e);
                    }
                }

                private void __constructor__(RecordingSession recordingSession, int n) {
                    this.$$robo$$android_media_tv_TvInputService_RecordingSession_3$__constructor__(recordingSession, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_RecordingSession_3$__constructor__(android.media.tv.TvInputService$RecordingSession int ), this, recordingSession, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_RecordingSession_3$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        @SystemApi
        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$notifySessionEvent(String eventType, Bundle eventArgs) {
            Preconditions.checkNotNull(eventType);
            this.executeOrPostRunnableOnMainThread(new Runnable(this, eventType, eventArgs){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$eventType;
                /* synthetic */ Bundle val$eventArgs;
                /* synthetic */ RecordingSession this$0;

                private void $$robo$$android_media_tv_TvInputService_RecordingSession_4$__constructor__(RecordingSession this$0, String string2, Bundle bundle) {
                    this.this$0 = this$0;
                    this.val$eventType = string2;
                    this.val$eventArgs = bundle;
                }

                private final void $$robo$$android_media_tv_TvInputService_RecordingSession_4$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onSessionEvent(this.val$eventType, this.val$eventArgs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in sending event (event=" + this.val$eventType + ")", e);
                    }
                }

                private void __constructor__(RecordingSession recordingSession, String string2, Bundle bundle) {
                    this.$$robo$$android_media_tv_TvInputService_RecordingSession_4$__constructor__(recordingSession, string2, bundle);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_RecordingSession_4$__constructor__(android.media.tv.TvInputService$RecordingSession java.lang.String android.os.Bundle ), this, recordingSession, string2, bundle);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_RecordingSession_4$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        public abstract void onTune(Uri var1);

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$onTune(Uri channelUri, Bundle params) {
            this.onTune(channelUri);
        }

        public abstract void onStartRecording(Uri var1);

        public abstract void onStopRecording();

        public abstract void onRelease();

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$onAppPrivateCommand(String action, Bundle data) {
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$tune(Uri channelUri, Bundle params) {
            this.onTune(channelUri, params);
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$release() {
            this.onRelease();
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$startRecording(Uri programUri) {
            this.onStartRecording(programUri);
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$stopRecording() {
            this.onStopRecording();
        }

        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$appPrivateCommand(String action, Bundle data) {
            this.onAppPrivateCommand(action, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$initialize(ITvInputSessionCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionCallback = callback;
                for (Runnable runnable : this.mPendingActions) {
                    runnable.run();
                }
                this.mPendingActions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputService_RecordingSession$executeOrPostRunnableOnMainThread(Runnable action) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSessionCallback == null) {
                    this.mPendingActions.add(action);
                } else if (this.mHandler.getLooper().isCurrentThread()) {
                    action.run();
                } else {
                    this.mHandler.post(action);
                }
            }
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_media_tv_TvInputService_RecordingSession$__constructor__(context);
        }

        public RecordingSession(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_RecordingSession$__constructor__(android.content.Context ), this, context);
        }

        public void notifyTuned(Uri uri) {
            InvokeDynamicSupport.bootstrap("notifyTuned", $$robo$$android_media_tv_TvInputService_RecordingSession$notifyTuned(android.net.Uri ), this, uri);
        }

        public void notifyRecordingStopped(Uri uri) {
            InvokeDynamicSupport.bootstrap("notifyRecordingStopped", $$robo$$android_media_tv_TvInputService_RecordingSession$notifyRecordingStopped(android.net.Uri ), this, uri);
        }

        public void notifyError(int n) {
            InvokeDynamicSupport.bootstrap("notifyError", $$robo$$android_media_tv_TvInputService_RecordingSession$notifyError(int ), this, n);
        }

        @SystemApi
        public void notifySessionEvent(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("notifySessionEvent", $$robo$$android_media_tv_TvInputService_RecordingSession$notifySessionEvent(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void onTune(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onTune", $$robo$$android_media_tv_TvInputService_RecordingSession$onTune(android.net.Uri android.os.Bundle ), this, uri, bundle);
        }

        public void onAppPrivateCommand(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onAppPrivateCommand", $$robo$$android_media_tv_TvInputService_RecordingSession$onAppPrivateCommand(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        void tune(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvInputService_RecordingSession$tune(android.net.Uri android.os.Bundle ), this, uri, bundle);
        }

        void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_TvInputService_RecordingSession$release(), this);
        }

        void startRecording(Uri uri) {
            InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_tv_TvInputService_RecordingSession$startRecording(android.net.Uri ), this, uri);
        }

        void stopRecording() {
            InvokeDynamicSupport.bootstrap("stopRecording", $$robo$$android_media_tv_TvInputService_RecordingSession$stopRecording(), this);
        }

        void appPrivateCommand(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("appPrivateCommand", $$robo$$android_media_tv_TvInputService_RecordingSession$appPrivateCommand(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        private void initialize(ITvInputSessionCallback iTvInputSessionCallback) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_media_tv_TvInputService_RecordingSession$initialize(android.media.tv.ITvInputSessionCallback ), this, iTvInputSessionCallback);
        }

        private void executeOrPostRunnableOnMainThread(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("executeOrPostRunnableOnMainThread", $$robo$$android_media_tv_TvInputService_RecordingSession$executeOrPostRunnableOnMainThread(java.lang.Runnable ), this, runnable);
        }

        public /* synthetic */ RecordingSession() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecordingSession)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class OverlayViewCleanUpTask
    extends AsyncTask<View, Void, Void> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$__constructor__() {
        }

        private final Void $$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$doInBackground(View ... views) {
            View overlayViewParent = views[0];
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (this.isCancelled()) {
                return null;
            }
            if (overlayViewParent.isAttachedToWindow()) {
                Log.e("TvInputService", "Time out on releasing overlay view. Killing " + overlayViewParent.getContext().getPackageName());
                Process.killProcess(Process.myPid());
            }
            return null;
        }

        private /* synthetic */ void $$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$__constructor__();
        }

        public OverlayViewCleanUpTask() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$__constructor__(), this);
        }

        protected Void doInBackground(View ... viewArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$doInBackground(android.view.View[] ), this, viewArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$__constructor__(var1_1);
        }

        public /* synthetic */ OverlayViewCleanUpTask(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_OverlayViewCleanUpTask$__constructor__(android.media.tv.TvInputService$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverlayViewCleanUpTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Session
    implements KeyEvent.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int POSITION_UPDATE_INTERVAL_MS = 1000;
        private KeyEvent.DispatcherState mDispatcherState;
        private WindowManager mWindowManager;
        Handler mHandler;
        private WindowManager.LayoutParams mWindowParams;
        private Surface mSurface;
        private Context mContext;
        private FrameLayout mOverlayViewContainer;
        private View mOverlayView;
        private OverlayViewCleanUpTask mOverlayViewCleanUpTask;
        private boolean mOverlayViewEnabled;
        private IBinder mWindowToken;
        private Rect mOverlayFrame;
        private long mStartPositionMs;
        private long mCurrentPositionMs;
        private TimeShiftPositionTrackingRunnable mTimeShiftPositionTrackingRunnable;
        private Object mLock;
        private ITvInputSessionCallback mSessionCallback;
        private List<Runnable> mPendingActions;

        private void $$robo$$android_media_tv_TvInputService_Session$__constructor__(Context context) {
            this.mDispatcherState = new KeyEvent.DispatcherState();
            this.mStartPositionMs = Long.MIN_VALUE;
            this.mCurrentPositionMs = Long.MIN_VALUE;
            this.mTimeShiftPositionTrackingRunnable = new TimeShiftPositionTrackingRunnable(this, null);
            this.mLock = new Object();
            this.mPendingActions = new ArrayList<Runnable>();
            this.mContext = context;
            this.mWindowManager = (WindowManager)context.getSystemService("window");
            this.mHandler = new Handler(context.getMainLooper());
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$setOverlayViewEnabled(boolean enable) {
            this.mHandler.post(new Runnable(this, enable){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ boolean val$enable;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_1$__constructor__(Session this$0, boolean bl) {
                    this.this$0 = this$0;
                    this.val$enable = bl;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_1$run() {
                    if (this.val$enable == this.this$0.mOverlayViewEnabled) {
                        return;
                    }
                    this.this$0.mOverlayViewEnabled = this.val$enable;
                    if (this.val$enable) {
                        if (this.this$0.mWindowToken != null) {
                            this.this$0.createOverlayView(this.this$0.mWindowToken, this.this$0.mOverlayFrame);
                        }
                    } else {
                        this.this$0.removeOverlayView(false);
                    }
                }

                private void __constructor__(Session session, boolean bl) {
                    this.$$robo$$android_media_tv_TvInputService_Session_1$__constructor__(session, bl);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_1$__constructor__(android.media.tv.TvInputService$Session boolean ), this, session, bl);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        @SystemApi
        private final void $$robo$$android_media_tv_TvInputService_Session$notifySessionEvent(String eventType, Bundle eventArgs) {
            Preconditions.checkNotNull(eventType);
            this.executeOrPostRunnableOnMainThread(new Runnable(this, eventType, eventArgs){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$eventType;
                /* synthetic */ Bundle val$eventArgs;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_2$__constructor__(Session this$0, String string2, Bundle bundle) {
                    this.this$0 = this$0;
                    this.val$eventType = string2;
                    this.val$eventArgs = bundle;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_2$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onSessionEvent(this.val$eventType, this.val$eventArgs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in sending event (event=" + this.val$eventType + ")", e);
                    }
                }

                private void __constructor__(Session session, String string2, Bundle bundle) {
                    this.$$robo$$android_media_tv_TvInputService_Session_2$__constructor__(session, string2, bundle);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_2$__constructor__(android.media.tv.TvInputService$Session java.lang.String android.os.Bundle ), this, session, string2, bundle);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyChannelRetuned(Uri channelUri) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, channelUri){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Uri val$channelUri;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_3$__constructor__(Session this$0, Uri uri) {
                    this.this$0 = this$0;
                    this.val$channelUri = uri;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_3$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onChannelRetuned(this.val$channelUri);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyChannelRetuned", e);
                    }
                }

                private void __constructor__(Session session, Uri uri) {
                    this.$$robo$$android_media_tv_TvInputService_Session_3$__constructor__(session, uri);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_3$__constructor__(android.media.tv.TvInputService$Session android.net.Uri ), this, session, uri);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_3$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyTracksChanged(List<TvTrackInfo> tracks) {
            ArrayList<TvTrackInfo> tracksCopy = new ArrayList<TvTrackInfo>(tracks);
            this.executeOrPostRunnableOnMainThread(new Runnable(this, tracksCopy){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ List val$tracksCopy;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_4$__constructor__(Session this$0, List list) {
                    this.this$0 = this$0;
                    this.val$tracksCopy = list;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_4$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onTracksChanged(this.val$tracksCopy);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyTracksChanged", e);
                    }
                }

                private void __constructor__(Session session, List list) {
                    this.$$robo$$android_media_tv_TvInputService_Session_4$__constructor__(session, list);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_4$__constructor__(android.media.tv.TvInputService$Session java.util.List ), this, session, list);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_4$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyTrackSelected(int type, String trackId) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, type, trackId){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$type;
                /* synthetic */ String val$trackId;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_5$__constructor__(Session this$0, int n, String string2) {
                    this.this$0 = this$0;
                    this.val$type = n;
                    this.val$trackId = string2;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_5$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onTrackSelected(this.val$type, this.val$trackId);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyTrackSelected", e);
                    }
                }

                private void __constructor__(Session session, int n, String string2) {
                    this.$$robo$$android_media_tv_TvInputService_Session_5$__constructor__(session, n, string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_5$__constructor__(android.media.tv.TvInputService$Session int java.lang.String ), this, session, n, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_5$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyVideoAvailable() {
            this.executeOrPostRunnableOnMainThread(new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_6$__constructor__(Session this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_6$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onVideoAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyVideoAvailable", e);
                    }
                }

                private void __constructor__(Session session) {
                    this.$$robo$$android_media_tv_TvInputService_Session_6$__constructor__(session);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_6$__constructor__(android.media.tv.TvInputService$Session ), this, session);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_6$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyVideoUnavailable(int reason) {
            if (reason < 0 || reason > 4) {
                Log.e("TvInputService", "notifyVideoUnavailable - unknown reason: " + reason);
            }
            this.executeOrPostRunnableOnMainThread(new Runnable(this, reason){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$reason;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_7$__constructor__(Session this$0, int n) {
                    this.this$0 = this$0;
                    this.val$reason = n;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_7$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onVideoUnavailable(this.val$reason);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyVideoUnavailable", e);
                    }
                }

                private void __constructor__(Session session, int n) {
                    this.$$robo$$android_media_tv_TvInputService_Session_7$__constructor__(session, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_7$__constructor__(android.media.tv.TvInputService$Session int ), this, session, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_7$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyContentAllowed() {
            this.executeOrPostRunnableOnMainThread(new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_8$__constructor__(Session this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_8$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onContentAllowed();
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyContentAllowed", e);
                    }
                }

                private void __constructor__(Session session) {
                    this.$$robo$$android_media_tv_TvInputService_Session_8$__constructor__(session);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_8$__constructor__(android.media.tv.TvInputService$Session ), this, session);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_8$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyContentBlocked(TvContentRating rating) {
            Preconditions.checkNotNull(rating);
            this.executeOrPostRunnableOnMainThread(new Runnable(this, rating){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ TvContentRating val$rating;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_9$__constructor__(Session this$0, TvContentRating tvContentRating) {
                    this.this$0 = this$0;
                    this.val$rating = tvContentRating;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_9$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onContentBlocked(this.val$rating.flattenToString());
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyContentBlocked", e);
                    }
                }

                private void __constructor__(Session session, TvContentRating tvContentRating) {
                    this.$$robo$$android_media_tv_TvInputService_Session_9$__constructor__(session, tvContentRating);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_9$__constructor__(android.media.tv.TvInputService$Session android.media.tv.TvContentRating ), this, session, tvContentRating);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_9$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyTimeShiftStatusChanged(int status) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, status){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$status;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_10$__constructor__(Session this$0, int n) {
                    this.this$0 = this$0;
                    this.val$status = n;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_10$run() {
                    this.this$0.timeShiftEnablePositionTracking(this.val$status == 3);
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onTimeShiftStatusChanged(this.val$status);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyTimeShiftStatusChanged", e);
                    }
                }

                private void __constructor__(Session session, int n) {
                    this.$$robo$$android_media_tv_TvInputService_Session_10$__constructor__(session, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_10$__constructor__(android.media.tv.TvInputService$Session int ), this, session, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_10$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyTimeShiftStartPositionChanged(long timeMs) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, timeMs){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ long val$timeMs;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_11$__constructor__(Session this$0, long l) {
                    this.this$0 = this$0;
                    this.val$timeMs = l;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_11$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onTimeShiftStartPositionChanged(this.val$timeMs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyTimeShiftStartPositionChanged", e);
                    }
                }

                private void __constructor__(Session session, long l) {
                    this.$$robo$$android_media_tv_TvInputService_Session_11$__constructor__(session, l);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_11$__constructor__(android.media.tv.TvInputService$Session long ), this, session, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_11$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$notifyTimeShiftCurrentPositionChanged(long timeMs) {
            this.executeOrPostRunnableOnMainThread(new Runnable(this, timeMs){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ long val$timeMs;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_12$__constructor__(Session this$0, long l) {
                    this.this$0 = this$0;
                    this.val$timeMs = l;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_12$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onTimeShiftCurrentPositionChanged(this.val$timeMs);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in notifyTimeShiftCurrentPositionChanged", e);
                    }
                }

                private void __constructor__(Session session, long l) {
                    this.$$robo$$android_media_tv_TvInputService_Session_12$__constructor__(session, l);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_12$__constructor__(android.media.tv.TvInputService$Session long ), this, session, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_12$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$layoutSurface(int left, int top, int right, int bottom) {
            if (left > right || top > bottom) {
                throw new IllegalArgumentException("Invalid parameter");
            }
            this.executeOrPostRunnableOnMainThread(new Runnable(this, left, top, right, bottom){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$left;
                /* synthetic */ int val$top;
                /* synthetic */ int val$right;
                /* synthetic */ int val$bottom;
                /* synthetic */ Session this$0;

                private void $$robo$$android_media_tv_TvInputService_Session_13$__constructor__(Session this$0, int n, int n2, int n3, int n4) {
                    this.this$0 = this$0;
                    this.val$left = n;
                    this.val$top = n2;
                    this.val$right = n3;
                    this.val$bottom = n4;
                }

                private final void $$robo$$android_media_tv_TvInputService_Session_13$run() {
                    try {
                        if (this.this$0.mSessionCallback != null) {
                            this.this$0.mSessionCallback.onLayoutSurface(this.val$left, this.val$top, this.val$right, this.val$bottom);
                        }
                    }
                    catch (RemoteException e) {
                        Log.w("TvInputService", "error in layoutSurface", e);
                    }
                }

                private void __constructor__(Session session, int n, int n2, int n3, int n4) {
                    this.$$robo$$android_media_tv_TvInputService_Session_13$__constructor__(session, n, n2, n3, n4);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_13$__constructor__(android.media.tv.TvInputService$Session int int int int ), this, session, n, n2, n3, n4);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_13$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        public abstract void onRelease();

        @SystemApi
        private final void $$robo$$android_media_tv_TvInputService_Session$onSetMain(boolean isMain) {
        }

        public abstract boolean onSetSurface(Surface var1);

        private final void $$robo$$android_media_tv_TvInputService_Session$onSurfaceChanged(int format, int width, int height) {
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onOverlayViewSizeChanged(int width, int height) {
        }

        public abstract void onSetStreamVolume(float var1);

        public abstract boolean onTune(Uri var1);

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onTune(Uri channelUri, Bundle params) {
            return this.onTune(channelUri);
        }

        public abstract void onSetCaptionEnabled(boolean var1);

        private final void $$robo$$android_media_tv_TvInputService_Session$onUnblockContent(TvContentRating unblockedRating) {
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onSelectTrack(int type, String trackId) {
            return false;
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onAppPrivateCommand(String action, Bundle data) {
        }

        private final View $$robo$$android_media_tv_TvInputService_Session$onCreateOverlayView() {
            return null;
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onTimeShiftPlay(Uri recordedProgramUri) {
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onTimeShiftPause() {
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onTimeShiftResume() {
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onTimeShiftSeekTo(long timeMs) {
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$onTimeShiftSetPlaybackParams(PlaybackParams params) {
        }

        private final long $$robo$$android_media_tv_TvInputService_Session$onTimeShiftGetStartPosition() {
            return Long.MIN_VALUE;
        }

        private final long $$robo$$android_media_tv_TvInputService_Session$onTimeShiftGetCurrentPosition() {
            return Long.MIN_VALUE;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onKeyDown(int keyCode, KeyEvent event) {
            return false;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onKeyLongPress(int keyCode, KeyEvent event) {
            return false;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onKeyMultiple(int keyCode, int count, KeyEvent event) {
            return false;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onKeyUp(int keyCode, KeyEvent event) {
            return false;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onTouchEvent(MotionEvent event) {
            return false;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onTrackballEvent(MotionEvent event) {
            return false;
        }

        private final boolean $$robo$$android_media_tv_TvInputService_Session$onGenericMotionEvent(MotionEvent event) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputService_Session$release() {
            this.onRelease();
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionCallback = null;
                this.mPendingActions.clear();
            }
            this.removeOverlayView(true);
            this.mHandler.removeCallbacks(this.mTimeShiftPositionTrackingRunnable);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$setMain(boolean isMain) {
            this.onSetMain(isMain);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$setSurface(Surface surface) {
            this.onSetSurface(surface);
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$dispatchSurfaceChanged(int format, int width, int height) {
            this.onSurfaceChanged(format, width, height);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$setStreamVolume(float volume) {
            this.onSetStreamVolume(volume);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$tune(Uri channelUri, Bundle params) {
            this.mCurrentPositionMs = Long.MIN_VALUE;
            this.onTune(channelUri, params);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$setCaptionEnabled(boolean enabled) {
            this.onSetCaptionEnabled(enabled);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$selectTrack(int type, String trackId) {
            this.onSelectTrack(type, trackId);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$unblockContent(String unblockedRating) {
            this.onUnblockContent(TvContentRating.unflattenFromString(unblockedRating));
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$appPrivateCommand(String action, Bundle data) {
            this.onAppPrivateCommand(action, data);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$createOverlayView(IBinder windowToken, Rect frame) {
            if (this.mOverlayViewContainer != null) {
                this.removeOverlayView(false);
            }
            this.mWindowToken = windowToken;
            this.mOverlayFrame = frame;
            this.onOverlayViewSizeChanged(frame.right - frame.left, frame.bottom - frame.top);
            if (!this.mOverlayViewEnabled) {
                return;
            }
            this.mOverlayView = this.onCreateOverlayView();
            if (this.mOverlayView == null) {
                return;
            }
            if (this.mOverlayViewCleanUpTask != null) {
                this.mOverlayViewCleanUpTask.cancel(true);
                this.mOverlayViewCleanUpTask = null;
            }
            this.mOverlayViewContainer = new FrameLayout(this.mContext.getApplicationContext());
            this.mOverlayViewContainer.addView(this.mOverlayView);
            int type = 1004;
            int flags = 536;
            if (ActivityManager.isHighEndGfx()) {
                flags |= 0x1000000;
            }
            this.mWindowParams = new WindowManager.LayoutParams(frame.right - frame.left, frame.bottom - frame.top, frame.left, frame.top, type, flags, -2);
            this.mWindowParams.privateFlags |= 0x40;
            this.mWindowParams.gravity = 0x800033;
            this.mWindowParams.token = windowToken;
            this.mWindowManager.addView(this.mOverlayViewContainer, this.mWindowParams);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$relayoutOverlayView(Rect frame) {
            if (this.mOverlayFrame == null || this.mOverlayFrame.width() != frame.width() || this.mOverlayFrame.height() != frame.height()) {
                this.onOverlayViewSizeChanged(frame.right - frame.left, frame.bottom - frame.top);
            }
            this.mOverlayFrame = frame;
            if (!this.mOverlayViewEnabled || this.mOverlayViewContainer == null) {
                return;
            }
            this.mWindowParams.x = frame.left;
            this.mWindowParams.y = frame.top;
            this.mWindowParams.width = frame.right - frame.left;
            this.mWindowParams.height = frame.bottom - frame.top;
            this.mWindowManager.updateViewLayout(this.mOverlayViewContainer, this.mWindowParams);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$removeOverlayView(boolean clearWindowToken) {
            if (clearWindowToken) {
                this.mWindowToken = null;
                this.mOverlayFrame = null;
            }
            if (this.mOverlayViewContainer != null) {
                this.mOverlayViewContainer.removeView(this.mOverlayView);
                this.mOverlayView = null;
                this.mWindowManager.removeView(this.mOverlayViewContainer);
                this.mOverlayViewContainer = null;
                this.mWindowParams = null;
            }
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$timeShiftPlay(Uri recordedProgramUri) {
            this.mCurrentPositionMs = 0L;
            this.onTimeShiftPlay(recordedProgramUri);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$timeShiftPause() {
            this.onTimeShiftPause();
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$timeShiftResume() {
            this.onTimeShiftResume();
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$timeShiftSeekTo(long timeMs) {
            this.onTimeShiftSeekTo(timeMs);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$timeShiftSetPlaybackParams(PlaybackParams params) {
            this.onTimeShiftSetPlaybackParams(params);
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$timeShiftEnablePositionTracking(boolean enable) {
            if (enable) {
                this.mHandler.post(this.mTimeShiftPositionTrackingRunnable);
            } else {
                this.mHandler.removeCallbacks(this.mTimeShiftPositionTrackingRunnable);
                this.mStartPositionMs = Long.MIN_VALUE;
                this.mCurrentPositionMs = Long.MIN_VALUE;
            }
        }

        private final void $$robo$$android_media_tv_TvInputService_Session$scheduleOverlayViewCleanup() {
            FrameLayout overlayViewParent = this.mOverlayViewContainer;
            if (overlayViewParent != null) {
                this.mOverlayViewCleanUpTask = new OverlayViewCleanUpTask(null);
                this.mOverlayViewCleanUpTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, overlayViewParent);
            }
        }

        private final int $$robo$$android_media_tv_TvInputService_Session$dispatchInputEvent(InputEvent event, InputEventReceiver receiver) {
            boolean isNavigationKey = false;
            boolean skipDispatchToOverlayView = false;
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (keyEvent.dispatch(this, this.mDispatcherState, this)) {
                    return 1;
                }
                isNavigationKey = TvInputService.isNavigationKey(keyEvent.getKeyCode());
                skipDispatchToOverlayView = KeyEvent.isMediaKey(keyEvent.getKeyCode()) || keyEvent.getKeyCode() == 222;
            } else if (event instanceof MotionEvent) {
                MotionEvent motionEvent = (MotionEvent)event;
                int source = motionEvent.getSource();
                if (motionEvent.isTouchEvent() ? this.onTouchEvent(motionEvent) : ((source & 4) != 0 ? this.onTrackballEvent(motionEvent) : this.onGenericMotionEvent(motionEvent))) {
                    return 1;
                }
            }
            if (this.mOverlayViewContainer == null || !this.mOverlayViewContainer.isAttachedToWindow() || skipDispatchToOverlayView) {
                return 0;
            }
            if (!this.mOverlayViewContainer.hasWindowFocus()) {
                this.mOverlayViewContainer.getViewRootImpl().windowFocusChanged(true, true);
            }
            if (isNavigationKey && this.mOverlayViewContainer.hasFocusable()) {
                this.mOverlayViewContainer.getViewRootImpl().dispatchInputEvent(event);
                return 1;
            }
            this.mOverlayViewContainer.getViewRootImpl().dispatchInputEvent(event, receiver);
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputService_Session$initialize(ITvInputSessionCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionCallback = callback;
                for (Runnable runnable : this.mPendingActions) {
                    runnable.run();
                }
                this.mPendingActions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputService_Session$executeOrPostRunnableOnMainThread(Runnable action) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSessionCallback == null) {
                    this.mPendingActions.add(action);
                } else if (this.mHandler.getLooper().isCurrentThread()) {
                    action.run();
                } else {
                    this.mHandler.post(action);
                }
            }
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_media_tv_TvInputService_Session$__constructor__(context);
        }

        public Session(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session$__constructor__(android.content.Context ), this, context);
        }

        public void setOverlayViewEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setOverlayViewEnabled", $$robo$$android_media_tv_TvInputService_Session$setOverlayViewEnabled(boolean ), this, bl);
        }

        @SystemApi
        public void notifySessionEvent(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("notifySessionEvent", $$robo$$android_media_tv_TvInputService_Session$notifySessionEvent(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void notifyChannelRetuned(Uri uri) {
            InvokeDynamicSupport.bootstrap("notifyChannelRetuned", $$robo$$android_media_tv_TvInputService_Session$notifyChannelRetuned(android.net.Uri ), this, uri);
        }

        public void notifyTracksChanged(List<TvTrackInfo> list) {
            InvokeDynamicSupport.bootstrap("notifyTracksChanged", $$robo$$android_media_tv_TvInputService_Session$notifyTracksChanged(java.util.List<android.media.tv.TvTrackInfo> ), this, list);
        }

        public void notifyTrackSelected(int n, String string2) {
            InvokeDynamicSupport.bootstrap("notifyTrackSelected", $$robo$$android_media_tv_TvInputService_Session$notifyTrackSelected(int java.lang.String ), this, n, string2);
        }

        public void notifyVideoAvailable() {
            InvokeDynamicSupport.bootstrap("notifyVideoAvailable", $$robo$$android_media_tv_TvInputService_Session$notifyVideoAvailable(), this);
        }

        public void notifyVideoUnavailable(int n) {
            InvokeDynamicSupport.bootstrap("notifyVideoUnavailable", $$robo$$android_media_tv_TvInputService_Session$notifyVideoUnavailable(int ), this, n);
        }

        public void notifyContentAllowed() {
            InvokeDynamicSupport.bootstrap("notifyContentAllowed", $$robo$$android_media_tv_TvInputService_Session$notifyContentAllowed(), this);
        }

        public void notifyContentBlocked(TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("notifyContentBlocked", $$robo$$android_media_tv_TvInputService_Session$notifyContentBlocked(android.media.tv.TvContentRating ), this, tvContentRating);
        }

        public void notifyTimeShiftStatusChanged(int n) {
            InvokeDynamicSupport.bootstrap("notifyTimeShiftStatusChanged", $$robo$$android_media_tv_TvInputService_Session$notifyTimeShiftStatusChanged(int ), this, n);
        }

        private void notifyTimeShiftStartPositionChanged(long l) {
            InvokeDynamicSupport.bootstrap("notifyTimeShiftStartPositionChanged", $$robo$$android_media_tv_TvInputService_Session$notifyTimeShiftStartPositionChanged(long ), this, l);
        }

        private void notifyTimeShiftCurrentPositionChanged(long l) {
            InvokeDynamicSupport.bootstrap("notifyTimeShiftCurrentPositionChanged", $$robo$$android_media_tv_TvInputService_Session$notifyTimeShiftCurrentPositionChanged(long ), this, l);
        }

        public void layoutSurface(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("layoutSurface", $$robo$$android_media_tv_TvInputService_Session$layoutSurface(int int int int ), this, n, n2, n3, n4);
        }

        @SystemApi
        public void onSetMain(boolean bl) {
            InvokeDynamicSupport.bootstrap("onSetMain", $$robo$$android_media_tv_TvInputService_Session$onSetMain(boolean ), this, bl);
        }

        public void onSurfaceChanged(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onSurfaceChanged", $$robo$$android_media_tv_TvInputService_Session$onSurfaceChanged(int int int ), this, n, n2, n3);
        }

        public void onOverlayViewSizeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onOverlayViewSizeChanged", $$robo$$android_media_tv_TvInputService_Session$onOverlayViewSizeChanged(int int ), this, n, n2);
        }

        public boolean onTune(Uri uri, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTune", $$robo$$android_media_tv_TvInputService_Session$onTune(android.net.Uri android.os.Bundle ), this, uri, bundle);
        }

        public void onUnblockContent(TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("onUnblockContent", $$robo$$android_media_tv_TvInputService_Session$onUnblockContent(android.media.tv.TvContentRating ), this, tvContentRating);
        }

        public boolean onSelectTrack(int n, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onSelectTrack", $$robo$$android_media_tv_TvInputService_Session$onSelectTrack(int java.lang.String ), this, n, string2);
        }

        public void onAppPrivateCommand(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onAppPrivateCommand", $$robo$$android_media_tv_TvInputService_Session$onAppPrivateCommand(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public View onCreateOverlayView() {
            return InvokeDynamicSupport.bootstrap("onCreateOverlayView", $$robo$$android_media_tv_TvInputService_Session$onCreateOverlayView(), this);
        }

        public void onTimeShiftPlay(Uri uri) {
            InvokeDynamicSupport.bootstrap("onTimeShiftPlay", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftPlay(android.net.Uri ), this, uri);
        }

        public void onTimeShiftPause() {
            InvokeDynamicSupport.bootstrap("onTimeShiftPause", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftPause(), this);
        }

        public void onTimeShiftResume() {
            InvokeDynamicSupport.bootstrap("onTimeShiftResume", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftResume(), this);
        }

        public void onTimeShiftSeekTo(long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftSeekTo", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftSeekTo(long ), this, l);
        }

        public void onTimeShiftSetPlaybackParams(PlaybackParams playbackParams) {
            InvokeDynamicSupport.bootstrap("onTimeShiftSetPlaybackParams", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftSetPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
        }

        public long onTimeShiftGetStartPosition() {
            return (long)InvokeDynamicSupport.bootstrap("onTimeShiftGetStartPosition", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftGetStartPosition(), this);
        }

        public long onTimeShiftGetCurrentPosition() {
            return (long)InvokeDynamicSupport.bootstrap("onTimeShiftGetCurrentPosition", $$robo$$android_media_tv_TvInputService_Session$onTimeShiftGetCurrentPosition(), this);
        }

        @Override
        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_media_tv_TvInputService_Session$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
        }

        @Override
        public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyLongPress", $$robo$$android_media_tv_TvInputService_Session$onKeyLongPress(int android.view.KeyEvent ), this, n, keyEvent);
        }

        @Override
        public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_media_tv_TvInputService_Session$onKeyMultiple(int int android.view.KeyEvent ), this, n, n2, keyEvent);
        }

        @Override
        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_media_tv_TvInputService_Session$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_media_tv_TvInputService_Session$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
        }

        public boolean onTrackballEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_media_tv_TvInputService_Session$onTrackballEvent(android.view.MotionEvent ), this, motionEvent);
        }

        public boolean onGenericMotionEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_media_tv_TvInputService_Session$onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
        }

        void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_TvInputService_Session$release(), this);
        }

        void setMain(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMain", $$robo$$android_media_tv_TvInputService_Session$setMain(boolean ), this, bl);
        }

        void setSurface(Surface surface) {
            InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_tv_TvInputService_Session$setSurface(android.view.Surface ), this, surface);
        }

        void dispatchSurfaceChanged(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("dispatchSurfaceChanged", $$robo$$android_media_tv_TvInputService_Session$dispatchSurfaceChanged(int int int ), this, n, n2, n3);
        }

        void setStreamVolume(float f) {
            InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_tv_TvInputService_Session$setStreamVolume(float ), this, f);
        }

        void tune(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvInputService_Session$tune(android.net.Uri android.os.Bundle ), this, uri, bundle);
        }

        void setCaptionEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setCaptionEnabled", $$robo$$android_media_tv_TvInputService_Session$setCaptionEnabled(boolean ), this, bl);
        }

        void selectTrack(int n, String string2) {
            InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_tv_TvInputService_Session$selectTrack(int java.lang.String ), this, n, string2);
        }

        void unblockContent(String string2) {
            InvokeDynamicSupport.bootstrap("unblockContent", $$robo$$android_media_tv_TvInputService_Session$unblockContent(java.lang.String ), this, string2);
        }

        void appPrivateCommand(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("appPrivateCommand", $$robo$$android_media_tv_TvInputService_Session$appPrivateCommand(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        void createOverlayView(IBinder iBinder, Rect rect) {
            InvokeDynamicSupport.bootstrap("createOverlayView", $$robo$$android_media_tv_TvInputService_Session$createOverlayView(android.os.IBinder android.graphics.Rect ), this, iBinder, rect);
        }

        void relayoutOverlayView(Rect rect) {
            InvokeDynamicSupport.bootstrap("relayoutOverlayView", $$robo$$android_media_tv_TvInputService_Session$relayoutOverlayView(android.graphics.Rect ), this, rect);
        }

        void removeOverlayView(boolean bl) {
            InvokeDynamicSupport.bootstrap("removeOverlayView", $$robo$$android_media_tv_TvInputService_Session$removeOverlayView(boolean ), this, bl);
        }

        void timeShiftPlay(Uri uri) {
            InvokeDynamicSupport.bootstrap("timeShiftPlay", $$robo$$android_media_tv_TvInputService_Session$timeShiftPlay(android.net.Uri ), this, uri);
        }

        void timeShiftPause() {
            InvokeDynamicSupport.bootstrap("timeShiftPause", $$robo$$android_media_tv_TvInputService_Session$timeShiftPause(), this);
        }

        void timeShiftResume() {
            InvokeDynamicSupport.bootstrap("timeShiftResume", $$robo$$android_media_tv_TvInputService_Session$timeShiftResume(), this);
        }

        void timeShiftSeekTo(long l) {
            InvokeDynamicSupport.bootstrap("timeShiftSeekTo", $$robo$$android_media_tv_TvInputService_Session$timeShiftSeekTo(long ), this, l);
        }

        void timeShiftSetPlaybackParams(PlaybackParams playbackParams) {
            InvokeDynamicSupport.bootstrap("timeShiftSetPlaybackParams", $$robo$$android_media_tv_TvInputService_Session$timeShiftSetPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
        }

        void timeShiftEnablePositionTracking(boolean bl) {
            InvokeDynamicSupport.bootstrap("timeShiftEnablePositionTracking", $$robo$$android_media_tv_TvInputService_Session$timeShiftEnablePositionTracking(boolean ), this, bl);
        }

        void scheduleOverlayViewCleanup() {
            InvokeDynamicSupport.bootstrap("scheduleOverlayViewCleanup", $$robo$$android_media_tv_TvInputService_Session$scheduleOverlayViewCleanup(), this);
        }

        int dispatchInputEvent(InputEvent inputEvent, InputEventReceiver inputEventReceiver) {
            return (int)InvokeDynamicSupport.bootstrap("dispatchInputEvent", $$robo$$android_media_tv_TvInputService_Session$dispatchInputEvent(android.view.InputEvent android.view.InputEventReceiver ), this, inputEvent, inputEventReceiver);
        }

        private void initialize(ITvInputSessionCallback iTvInputSessionCallback) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_media_tv_TvInputService_Session$initialize(android.media.tv.ITvInputSessionCallback ), this, iTvInputSessionCallback);
        }

        private void executeOrPostRunnableOnMainThread(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("executeOrPostRunnableOnMainThread", $$robo$$android_media_tv_TvInputService_Session$executeOrPostRunnableOnMainThread(java.lang.Runnable ), this, runnable);
        }

        public /* synthetic */ Session() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private final class TimeShiftPositionTrackingRunnable
        implements Runnable,
        ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Session this$0;

            private void $$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$__constructor__(Session session) {
                this.this$0 = session;
            }

            private final void $$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$run() {
                long currentPositionMs;
                long startPositionMs = this.this$0.onTimeShiftGetStartPosition();
                if (this.this$0.mStartPositionMs == Long.MIN_VALUE || this.this$0.mStartPositionMs != startPositionMs) {
                    this.this$0.mStartPositionMs = startPositionMs;
                    this.this$0.notifyTimeShiftStartPositionChanged(startPositionMs);
                }
                if ((currentPositionMs = this.this$0.onTimeShiftGetCurrentPosition()) < this.this$0.mStartPositionMs) {
                    Log.w("TvInputService", "Current position (" + currentPositionMs + ") cannot be earlier than start position (" + this.this$0.mStartPositionMs + "). Reset to the start position.");
                    currentPositionMs = this.this$0.mStartPositionMs;
                }
                if (this.this$0.mCurrentPositionMs == Long.MIN_VALUE || this.this$0.mCurrentPositionMs != currentPositionMs) {
                    this.this$0.mCurrentPositionMs = currentPositionMs;
                    this.this$0.notifyTimeShiftCurrentPositionChanged(currentPositionMs);
                }
                this.this$0.mHandler.removeCallbacks(this.this$0.mTimeShiftPositionTrackingRunnable);
                this.this$0.mHandler.postDelayed(this.this$0.mTimeShiftPositionTrackingRunnable, 1000L);
            }

            private /* synthetic */ void $$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$__constructor__(Session x0, 1 x1) {
            }

            private void __constructor__(Session session) {
                this.$$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$__constructor__(session);
            }

            public TimeShiftPositionTrackingRunnable(Session session) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$__constructor__(android.media.tv.TvInputService$Session ), this, session);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$run(), this);
            }

            private /* synthetic */ void __constructor__(Session session, 1 var2_2) {
                this.$$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$__constructor__(session, var2_2);
            }

            public /* synthetic */ TimeShiftPositionTrackingRunnable(Session session, 1 var2_2) {
                this(session);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputService_Session_TimeShiftPositionTrackingRunnable$__constructor__(android.media.tv.TvInputService$Session android.media.tv.TvInputService$1 ), this, session, var2_2);
            }

            public /* synthetic */ TimeShiftPositionTrackingRunnable() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeShiftPositionTrackingRunnable)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

