/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.media.IRemoteVolumeController;
import android.media.ISessionTokensListener;
import android.media.SessionToken2;
import android.media.session.IActiveSessionsListener;
import android.media.session.ICallback;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISessionController;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaSessionManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "SessionManager";
    public static int RESULT_MEDIA_KEY_NOT_HANDLED = 0;
    public static int RESULT_MEDIA_KEY_HANDLED = 1;
    private ArrayMap<OnActiveSessionsChangedListener, SessionsChangedWrapper> mListeners;
    private ArrayMap<OnSessionTokensChangedListener, SessionTokensChangedWrapper> mSessionTokensListener;
    private Object mLock;
    private ISessionManager mService;
    private Context mContext;
    private CallbackImpl mCallback;
    private OnVolumeKeyLongPressListenerImpl mOnVolumeKeyLongPressListener;
    private OnMediaKeyListenerImpl mOnMediaKeyListener;

    private void $$robo$$android_media_session_MediaSessionManager$__constructor__(Context context) {
        this.mListeners = new ArrayMap();
        this.mSessionTokensListener = new ArrayMap();
        this.mLock = new Object();
        this.mContext = context;
        IBinder b = ServiceManager.getService("media_session");
        this.mService = ISessionManager.Stub.asInterface(b);
    }

    private final ISession $$robo$$android_media_session_MediaSessionManager$createSession(MediaSession.CallbackStub cbStub, String tag, int userId) throws RemoteException {
        return this.mService.createSession(this.mContext.getPackageName(), cbStub, tag, userId);
    }

    private final List<MediaController> $$robo$$android_media_session_MediaSessionManager$getActiveSessions(ComponentName notificationListener) {
        return this.getActiveSessionsForUser(notificationListener, UserHandle.myUserId());
    }

    private final List<MediaController> $$robo$$android_media_session_MediaSessionManager$getActiveSessionsForUser(ComponentName notificationListener, int userId) {
        ArrayList<MediaController> controllers = new ArrayList<MediaController>();
        try {
            List<IBinder> binders = this.mService.getSessions(notificationListener, userId);
            int size = binders.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = new MediaController(this.mContext, ISessionController.Stub.asInterface(binders.get(i)));
                controllers.add(controller);
            }
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to get active sessions: ", e);
        }
        return controllers;
    }

    private final void $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, null);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, Handler handler) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, UserHandle.myUserId(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, int userId, Handler handler) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.get(sessionListener) != null) {
                Log.w("SessionManager", "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionsChangedWrapper wrapper = new SessionsChangedWrapper(this.mContext, sessionListener, handler);
            try {
                this.mService.addSessionsListener(wrapper.mStub, notificationListener, userId);
                this.mListeners.put(sessionListener, wrapper);
            }
            catch (RemoteException e) {
                Log.e("SessionManager", "Error in addOnActiveSessionsChangedListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionsChangedWrapper wrapper = this.mListeners.remove(listener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionsListener(wrapper.mStub);
                }
                catch (RemoteException e) {
                    Log.e("SessionManager", "Error in removeOnActiveSessionsChangedListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$setRemoteVolumeController(IRemoteVolumeController rvc) {
        try {
            this.mService.setRemoteVolumeController(rvc);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Error in setRemoteVolumeController.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.dispatchMediaKeyEvent(keyEvent, false);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        this.dispatchMediaKeyEventInternal(false, keyEvent, needWakeLock);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEventAsSystemService(KeyEvent keyEvent) {
        this.dispatchMediaKeyEventInternal(true, keyEvent, false);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEventInternal(boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
        try {
            this.mService.dispatchMediaKeyEvent(this.mContext.getPackageName(), asSystemService, keyEvent, needWakeLock);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to send key event.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchVolumeKeyEvent(KeyEvent keyEvent, int stream, boolean musicOnly) {
        this.dispatchVolumeKeyEventInternal(false, keyEvent, stream, musicOnly);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchVolumeKeyEventAsSystemService(KeyEvent keyEvent, int streamType) {
        this.dispatchVolumeKeyEventInternal(true, keyEvent, streamType, false);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchVolumeKeyEventInternal(boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) {
        try {
            this.mService.dispatchVolumeKeyEvent(this.mContext.getPackageName(), asSystemService, keyEvent, stream, musicOnly);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to send volume key event.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchAdjustVolume(int suggestedStream, int direction, int flags) {
        try {
            this.mService.dispatchAdjustVolume(this.mContext.getPackageName(), suggestedStream, direction, flags);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to send adjust volume.", e);
        }
    }

    private final boolean $$robo$$android_media_session_MediaSessionManager$isTrustedForMediaControl(RemoteUserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException("userInfo may not be null");
        }
        if (userInfo.getPackageName() == null) {
            return false;
        }
        try {
            return this.mService.isTrusted(userInfo.getPackageName(), userInfo.getPid(), userInfo.getUid());
        }
        catch (RemoteException e) {
            Log.wtf("SessionManager", "Cannot communicate with the service.", e);
            return false;
        }
    }

    private final boolean $$robo$$android_media_session_MediaSessionManager$createSession2(SessionToken2 token) {
        if (token == null) {
            return false;
        }
        try {
            return this.mService.createSession2(token.toBundle());
        }
        catch (RemoteException e) {
            Log.wtf("SessionManager", "Cannot communicate with the service.", e);
            return false;
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$destroySession2(SessionToken2 token) {
        if (token == null) {
            return;
        }
        try {
            this.mService.destroySession2(token.toBundle());
        }
        catch (RemoteException e) {
            Log.wtf("SessionManager", "Cannot communicate with the service.", e);
        }
    }

    private final List<SessionToken2> $$robo$$android_media_session_MediaSessionManager$getActiveSessionTokens() {
        try {
            List<Bundle> bundles = this.mService.getSessionTokens(true, false, this.mContext.getPackageName());
            return MediaSessionManager.toTokenList(bundles);
        }
        catch (RemoteException e) {
            Log.wtf("SessionManager", "Cannot communicate with the service.", e);
            return Collections.emptyList();
        }
    }

    private final List<SessionToken2> $$robo$$android_media_session_MediaSessionManager$getSessionServiceTokens() {
        try {
            List<Bundle> bundles = this.mService.getSessionTokens(false, true, this.mContext.getPackageName());
            return MediaSessionManager.toTokenList(bundles);
        }
        catch (RemoteException e) {
            Log.wtf("SessionManager", "Cannot communicate with the service.", e);
            return Collections.emptyList();
        }
    }

    private final List<SessionToken2> $$robo$$android_media_session_MediaSessionManager$getAllSessionTokens() {
        try {
            List<Bundle> bundles = this.mService.getSessionTokens(false, false, this.mContext.getPackageName());
            return MediaSessionManager.toTokenList(bundles);
        }
        catch (RemoteException e) {
            Log.wtf("SessionManager", "Cannot communicate with the service.", e);
            return Collections.emptyList();
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$addOnSessionTokensChangedListener(Executor executor, OnSessionTokensChangedListener listener) {
        this.addOnSessionTokensChangedListener(UserHandle.myUserId(), executor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$addOnSessionTokensChangedListener(int userId, Executor executor, OnSessionTokensChangedListener listener) {
        if (executor == null) {
            throw new IllegalArgumentException("executor may not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionTokensListener.get(listener) != null) {
                Log.w("SessionManager", "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionTokensChangedWrapper wrapper = new SessionTokensChangedWrapper(this.mContext, executor, listener);
            try {
                this.mService.addSessionTokensListener(wrapper.mStub, userId, this.mContext.getPackageName());
                this.mSessionTokensListener.put(listener, wrapper);
            }
            catch (RemoteException e) {
                Log.e("SessionManager", "Error in addSessionTokensListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$removeOnSessionTokensChangedListener(OnSessionTokensChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionTokensChangedWrapper wrapper = this.mSessionTokensListener.remove(listener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionTokensListener(wrapper.mStub, this.mContext.getPackageName());
                }
                catch (RemoteException e) {
                    Log.e("SessionManager", "Error in removeSessionTokensListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    private static final List<SessionToken2> $$robo$$android_media_session_MediaSessionManager$toTokenList(List<Bundle> bundles) {
        ArrayList<SessionToken2> tokens = new ArrayList<SessionToken2>();
        if (bundles != null) {
            for (int i = 0; i < bundles.size(); ++i) {
                SessionToken2 token = SessionToken2.fromBundle(bundles.get(i));
                if (token == null) continue;
                tokens.add(token);
            }
        }
        return tokens;
    }

    private final boolean $$robo$$android_media_session_MediaSessionManager$isGlobalPriorityActive() {
        try {
            return this.mService.isGlobalPriorityActive();
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to check if the global priority is active.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final void $$robo$$android_media_session_MediaSessionManager$setOnVolumeKeyLongPressListener(OnVolumeKeyLongPressListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnVolumeKeyLongPressListener = null;
                    this.mService.setOnVolumeKeyLongPressListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnVolumeKeyLongPressListener = new OnVolumeKeyLongPressListenerImpl(listener, handler);
                    this.mService.setOnVolumeKeyLongPressListener(this.mOnVolumeKeyLongPressListener);
                }
            }
            catch (RemoteException e) {
                Log.e("SessionManager", "Failed to set volume key long press listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final void $$robo$$android_media_session_MediaSessionManager$setOnMediaKeyListener(OnMediaKeyListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnMediaKeyListener = null;
                    this.mService.setOnMediaKeyListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnMediaKeyListener = new OnMediaKeyListenerImpl(listener, handler);
                    this.mService.setOnMediaKeyListener(this.mOnMediaKeyListener);
                }
            }
            catch (RemoteException e) {
                Log.e("SessionManager", "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (callback == null) {
                    this.mCallback = null;
                    this.mService.setCallback(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mCallback = new CallbackImpl(callback, handler);
                    this.mService.setCallback(this.mCallback);
                }
            }
            catch (RemoteException e) {
                Log.e("SessionManager", "Failed to set media key callback", e);
            }
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_session_MediaSessionManager$__constructor__(context);
    }

    public MediaSessionManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager$__constructor__(android.content.Context ), this, context);
    }

    public ISession createSession(MediaSession.CallbackStub callbackStub, String string2, int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_media_session_MediaSessionManager$createSession(android.media.session.MediaSession$CallbackStub java.lang.String int ), this, callbackStub, string2, n);
    }

    public List<MediaController> getActiveSessions(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getActiveSessions", $$robo$$android_media_session_MediaSessionManager$getActiveSessions(android.content.ComponentName ), this, componentName);
    }

    public List<MediaController> getActiveSessionsForUser(ComponentName componentName, int n) {
        return InvokeDynamicSupport.bootstrap("getActiveSessionsForUser", $$robo$$android_media_session_MediaSessionManager$getActiveSessionsForUser(android.content.ComponentName int ), this, componentName, n);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("addOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.content.ComponentName ), this, onActiveSessionsChangedListener, componentName);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.content.ComponentName android.os.Handler ), this, onActiveSessionsChangedListener, componentName, handler);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName, int n, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.content.ComponentName int android.os.Handler ), this, onActiveSessionsChangedListener, componentName, n, handler);
    }

    public void removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$removeOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener ), this, onActiveSessionsChangedListener);
    }

    public void setRemoteVolumeController(IRemoteVolumeController iRemoteVolumeController) {
        InvokeDynamicSupport.bootstrap("setRemoteVolumeController", $$robo$$android_media_session_MediaSessionManager$setRemoteVolumeController(android.media.IRemoteVolumeController ), this, iRemoteVolumeController);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(android.view.KeyEvent boolean ), this, keyEvent, bl);
    }

    public void dispatchMediaKeyEventAsSystemService(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEventAsSystemService", $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEventAsSystemService(android.view.KeyEvent ), this, keyEvent);
    }

    private void dispatchMediaKeyEventInternal(boolean bl, KeyEvent keyEvent, boolean bl2) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEventInternal", $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEventInternal(boolean android.view.KeyEvent boolean ), this, bl, keyEvent, bl2);
    }

    public void dispatchVolumeKeyEvent(KeyEvent keyEvent, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchVolumeKeyEvent", $$robo$$android_media_session_MediaSessionManager$dispatchVolumeKeyEvent(android.view.KeyEvent int boolean ), this, keyEvent, n, bl);
    }

    public void dispatchVolumeKeyEventAsSystemService(KeyEvent keyEvent, int n) {
        InvokeDynamicSupport.bootstrap("dispatchVolumeKeyEventAsSystemService", $$robo$$android_media_session_MediaSessionManager$dispatchVolumeKeyEventAsSystemService(android.view.KeyEvent int ), this, keyEvent, n);
    }

    private void dispatchVolumeKeyEventInternal(boolean bl, KeyEvent keyEvent, int n, boolean bl2) {
        InvokeDynamicSupport.bootstrap("dispatchVolumeKeyEventInternal", $$robo$$android_media_session_MediaSessionManager$dispatchVolumeKeyEventInternal(boolean android.view.KeyEvent int boolean ), this, bl, keyEvent, n, bl2);
    }

    public void dispatchAdjustVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("dispatchAdjustVolume", $$robo$$android_media_session_MediaSessionManager$dispatchAdjustVolume(int int int ), this, n, n2, n3);
    }

    public boolean isTrustedForMediaControl(RemoteUserInfo remoteUserInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTrustedForMediaControl", $$robo$$android_media_session_MediaSessionManager$isTrustedForMediaControl(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    public boolean createSession2(SessionToken2 sessionToken2) {
        return (boolean)InvokeDynamicSupport.bootstrap("createSession2", $$robo$$android_media_session_MediaSessionManager$createSession2(android.media.SessionToken2 ), this, sessionToken2);
    }

    public void destroySession2(SessionToken2 sessionToken2) {
        InvokeDynamicSupport.bootstrap("destroySession2", $$robo$$android_media_session_MediaSessionManager$destroySession2(android.media.SessionToken2 ), this, sessionToken2);
    }

    public List<SessionToken2> getActiveSessionTokens() {
        return InvokeDynamicSupport.bootstrap("getActiveSessionTokens", $$robo$$android_media_session_MediaSessionManager$getActiveSessionTokens(), this);
    }

    public List<SessionToken2> getSessionServiceTokens() {
        return InvokeDynamicSupport.bootstrap("getSessionServiceTokens", $$robo$$android_media_session_MediaSessionManager$getSessionServiceTokens(), this);
    }

    public List<SessionToken2> getAllSessionTokens() {
        return InvokeDynamicSupport.bootstrap("getAllSessionTokens", $$robo$$android_media_session_MediaSessionManager$getAllSessionTokens(), this);
    }

    public void addOnSessionTokensChangedListener(Executor executor, OnSessionTokensChangedListener onSessionTokensChangedListener) {
        InvokeDynamicSupport.bootstrap("addOnSessionTokensChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnSessionTokensChangedListener(java.util.concurrent.Executor android.media.session.MediaSessionManager$OnSessionTokensChangedListener ), this, executor, onSessionTokensChangedListener);
    }

    public void addOnSessionTokensChangedListener(int n, Executor executor, OnSessionTokensChangedListener onSessionTokensChangedListener) {
        InvokeDynamicSupport.bootstrap("addOnSessionTokensChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnSessionTokensChangedListener(int java.util.concurrent.Executor android.media.session.MediaSessionManager$OnSessionTokensChangedListener ), this, n, executor, onSessionTokensChangedListener);
    }

    public void removeOnSessionTokensChangedListener(OnSessionTokensChangedListener onSessionTokensChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnSessionTokensChangedListener", $$robo$$android_media_session_MediaSessionManager$removeOnSessionTokensChangedListener(android.media.session.MediaSessionManager$OnSessionTokensChangedListener ), this, onSessionTokensChangedListener);
    }

    private static List<SessionToken2> toTokenList(List<Bundle> list) {
        return InvokeDynamicSupport.bootstrapStatic("toTokenList", $$robo$$android_media_session_MediaSessionManager$toTokenList(java.util.List<android.os.Bundle> ), list);
    }

    public boolean isGlobalPriorityActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGlobalPriorityActive", $$robo$$android_media_session_MediaSessionManager$isGlobalPriorityActive(), this);
    }

    @SystemApi
    public void setOnVolumeKeyLongPressListener(OnVolumeKeyLongPressListener onVolumeKeyLongPressListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnVolumeKeyLongPressListener", $$robo$$android_media_session_MediaSessionManager$setOnVolumeKeyLongPressListener(android.media.session.MediaSessionManager$OnVolumeKeyLongPressListener android.os.Handler ), this, onVolumeKeyLongPressListener, handler);
    }

    @SystemApi
    public void setOnMediaKeyListener(OnMediaKeyListener onMediaKeyListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnMediaKeyListener", $$robo$$android_media_session_MediaSessionManager$setOnMediaKeyListener(android.media.session.MediaSessionManager$OnMediaKeyListener android.os.Handler ), this, onMediaKeyListener, handler);
    }

    public void setCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_session_MediaSessionManager$setCallback(android.media.session.MediaSessionManager$Callback android.os.Handler ), this, callback, handler);
    }

    public /* synthetic */ MediaSessionManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSessionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CallbackImpl
    extends ICallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Callback mCallback;
        private Handler mHandler;

        private void $$robo$$android_media_session_MediaSessionManager_CallbackImpl$__constructor__(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onMediaKeyEventDispatchedToMediaSession(KeyEvent event, MediaSession.Token sessionToken) {
            this.mHandler.post(new Runnable(this, event, sessionToken){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyEvent val$event;
                /* synthetic */ MediaSession.Token val$sessionToken;
                /* synthetic */ CallbackImpl this$0;

                private void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_1$__constructor__(CallbackImpl this$0, KeyEvent keyEvent, MediaSession.Token token) {
                    this.this$0 = this$0;
                    this.val$event = keyEvent;
                    this.val$sessionToken = token;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_1$run() {
                    this.this$0.mCallback.onMediaKeyEventDispatched(this.val$event, this.val$sessionToken);
                }

                private void __constructor__(CallbackImpl callbackImpl, KeyEvent keyEvent, MediaSession.Token token) {
                    this.$$robo$$android_media_session_MediaSessionManager_CallbackImpl_1$__constructor__(callbackImpl, keyEvent, token);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_1$__constructor__(android.media.session.MediaSessionManager$CallbackImpl android.view.KeyEvent android.media.session.MediaSession$Token ), this, callbackImpl, keyEvent, token);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onMediaKeyEventDispatchedToMediaButtonReceiver(KeyEvent event, ComponentName mediaButtonReceiver) {
            this.mHandler.post(new Runnable(this, event, mediaButtonReceiver){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyEvent val$event;
                /* synthetic */ ComponentName val$mediaButtonReceiver;
                /* synthetic */ CallbackImpl this$0;

                private void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_2$__constructor__(CallbackImpl this$0, KeyEvent keyEvent, ComponentName componentName) {
                    this.this$0 = this$0;
                    this.val$event = keyEvent;
                    this.val$mediaButtonReceiver = componentName;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_2$run() {
                    this.this$0.mCallback.onMediaKeyEventDispatched(this.val$event, this.val$mediaButtonReceiver);
                }

                private void __constructor__(CallbackImpl callbackImpl, KeyEvent keyEvent, ComponentName componentName) {
                    this.$$robo$$android_media_session_MediaSessionManager_CallbackImpl_2$__constructor__(callbackImpl, keyEvent, componentName);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_2$__constructor__(android.media.session.MediaSessionManager$CallbackImpl android.view.KeyEvent android.content.ComponentName ), this, callbackImpl, keyEvent, componentName);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onAddressedPlayerChangedToMediaSession(MediaSession.Token sessionToken) {
            this.mHandler.post(new Runnable(this, sessionToken){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MediaSession.Token val$sessionToken;
                /* synthetic */ CallbackImpl this$0;

                private void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_3$__constructor__(CallbackImpl this$0, MediaSession.Token token) {
                    this.this$0 = this$0;
                    this.val$sessionToken = token;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_3$run() {
                    this.this$0.mCallback.onAddressedPlayerChanged(this.val$sessionToken);
                }

                private void __constructor__(CallbackImpl callbackImpl, MediaSession.Token token) {
                    this.$$robo$$android_media_session_MediaSessionManager_CallbackImpl_3$__constructor__(callbackImpl, token);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_3$__constructor__(android.media.session.MediaSessionManager$CallbackImpl android.media.session.MediaSession$Token ), this, callbackImpl, token);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_3$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onAddressedPlayerChangedToMediaButtonReceiver(ComponentName mediaButtonReceiver) {
            this.mHandler.post(new Runnable(this, mediaButtonReceiver){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ComponentName val$mediaButtonReceiver;
                /* synthetic */ CallbackImpl this$0;

                private void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_4$__constructor__(CallbackImpl this$0, ComponentName componentName) {
                    this.this$0 = this$0;
                    this.val$mediaButtonReceiver = componentName;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_CallbackImpl_4$run() {
                    this.this$0.mCallback.onAddressedPlayerChanged(this.val$mediaButtonReceiver);
                }

                private void __constructor__(CallbackImpl callbackImpl, ComponentName componentName) {
                    this.$$robo$$android_media_session_MediaSessionManager_CallbackImpl_4$__constructor__(callbackImpl, componentName);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_4$__constructor__(android.media.session.MediaSessionManager$CallbackImpl android.content.ComponentName ), this, callbackImpl, componentName);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_CallbackImpl_4$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(Callback callback, Handler handler) {
            this.$$robo$$android_media_session_MediaSessionManager_CallbackImpl$__constructor__(callback, handler);
        }

        public CallbackImpl(Callback callback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_CallbackImpl$__constructor__(android.media.session.MediaSessionManager$Callback android.os.Handler ), this, callback, handler);
        }

        @Override
        public void onMediaKeyEventDispatchedToMediaSession(KeyEvent keyEvent, MediaSession.Token token) {
            InvokeDynamicSupport.bootstrap("onMediaKeyEventDispatchedToMediaSession", $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onMediaKeyEventDispatchedToMediaSession(android.view.KeyEvent android.media.session.MediaSession$Token ), this, keyEvent, token);
        }

        @Override
        public void onMediaKeyEventDispatchedToMediaButtonReceiver(KeyEvent keyEvent, ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onMediaKeyEventDispatchedToMediaButtonReceiver", $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onMediaKeyEventDispatchedToMediaButtonReceiver(android.view.KeyEvent android.content.ComponentName ), this, keyEvent, componentName);
        }

        @Override
        public void onAddressedPlayerChangedToMediaSession(MediaSession.Token token) {
            InvokeDynamicSupport.bootstrap("onAddressedPlayerChangedToMediaSession", $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onAddressedPlayerChangedToMediaSession(android.media.session.MediaSession$Token ), this, token);
        }

        @Override
        public void onAddressedPlayerChangedToMediaButtonReceiver(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onAddressedPlayerChangedToMediaButtonReceiver", $$robo$$android_media_session_MediaSessionManager_CallbackImpl$onAddressedPlayerChangedToMediaButtonReceiver(android.content.ComponentName ), this, componentName);
        }

        public /* synthetic */ CallbackImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class OnMediaKeyListenerImpl
    extends IOnMediaKeyListener.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private OnMediaKeyListener mListener;
        private Handler mHandler;

        private void $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl$__constructor__(OnMediaKeyListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl$onMediaKey(KeyEvent event, ResultReceiver result) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w("SessionManager", "Failed to call media key listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(this, event, result){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyEvent val$event;
                /* synthetic */ ResultReceiver val$result;
                /* synthetic */ OnMediaKeyListenerImpl this$0;

                private void $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl_1$__constructor__(OnMediaKeyListenerImpl this$0, KeyEvent keyEvent, ResultReceiver resultReceiver) {
                    this.this$0 = this$0;
                    this.val$event = keyEvent;
                    this.val$result = resultReceiver;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl_1$run() {
                    boolean handled = this.this$0.mListener.onMediaKey(this.val$event);
                    Log.d("SessionManager", "The media key listener is returned " + handled);
                    if (this.val$result != null) {
                        this.val$result.send(handled ? 1 : 0, null);
                    }
                }

                private void __constructor__(OnMediaKeyListenerImpl onMediaKeyListenerImpl, KeyEvent keyEvent, ResultReceiver resultReceiver) {
                    this.$$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl_1$__constructor__(onMediaKeyListenerImpl, keyEvent, resultReceiver);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl_1$__constructor__(android.media.session.MediaSessionManager$OnMediaKeyListenerImpl android.view.KeyEvent android.os.ResultReceiver ), this, onMediaKeyListenerImpl, keyEvent, resultReceiver);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(OnMediaKeyListener onMediaKeyListener, Handler handler) {
            this.$$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl$__constructor__(onMediaKeyListener, handler);
        }

        public OnMediaKeyListenerImpl(OnMediaKeyListener onMediaKeyListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl$__constructor__(android.media.session.MediaSessionManager$OnMediaKeyListener android.os.Handler ), this, onMediaKeyListener, handler);
        }

        @Override
        public void onMediaKey(KeyEvent keyEvent, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onMediaKey", $$robo$$android_media_session_MediaSessionManager_OnMediaKeyListenerImpl$onMediaKey(android.view.KeyEvent android.os.ResultReceiver ), this, keyEvent, resultReceiver);
        }

        public /* synthetic */ OnMediaKeyListenerImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnMediaKeyListenerImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class OnVolumeKeyLongPressListenerImpl
    extends IOnVolumeKeyLongPressListener.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private OnVolumeKeyLongPressListener mListener;
        private Handler mHandler;

        private void $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl$__constructor__(OnVolumeKeyLongPressListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl$onVolumeKeyLongPress(KeyEvent event) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w("SessionManager", "Failed to call volume key long-press listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(this, event){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyEvent val$event;
                /* synthetic */ OnVolumeKeyLongPressListenerImpl this$0;

                private void $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl_1$__constructor__(OnVolumeKeyLongPressListenerImpl this$0, KeyEvent keyEvent) {
                    this.this$0 = this$0;
                    this.val$event = keyEvent;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl_1$run() {
                    this.this$0.mListener.onVolumeKeyLongPress(this.val$event);
                }

                private void __constructor__(OnVolumeKeyLongPressListenerImpl onVolumeKeyLongPressListenerImpl, KeyEvent keyEvent) {
                    this.$$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl_1$__constructor__(onVolumeKeyLongPressListenerImpl, keyEvent);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl_1$__constructor__(android.media.session.MediaSessionManager$OnVolumeKeyLongPressListenerImpl android.view.KeyEvent ), this, onVolumeKeyLongPressListenerImpl, keyEvent);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(OnVolumeKeyLongPressListener onVolumeKeyLongPressListener, Handler handler) {
            this.$$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl$__constructor__(onVolumeKeyLongPressListener, handler);
        }

        public OnVolumeKeyLongPressListenerImpl(OnVolumeKeyLongPressListener onVolumeKeyLongPressListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl$__constructor__(android.media.session.MediaSessionManager$OnVolumeKeyLongPressListener android.os.Handler ), this, onVolumeKeyLongPressListener, handler);
        }

        @Override
        public void onVolumeKeyLongPress(KeyEvent keyEvent) {
            InvokeDynamicSupport.bootstrap("onVolumeKeyLongPress", $$robo$$android_media_session_MediaSessionManager_OnVolumeKeyLongPressListenerImpl$onVolumeKeyLongPress(android.view.KeyEvent ), this, keyEvent);
        }

        public /* synthetic */ OnVolumeKeyLongPressListenerImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnVolumeKeyLongPressListenerImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SessionTokensChangedWrapper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Context mContext;
        private Executor mExecutor;
        private OnSessionTokensChangedListener mListener;
        private ISessionTokensListener.Stub mStub;

        private void $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper$__constructor__(Context context, Executor executor, OnSessionTokensChangedListener listener) {
            this.mStub = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ SessionTokensChangedWrapper this$0;

                private void $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper_1$__constructor__(SessionTokensChangedWrapper this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper_1$onSessionTokensChanged(List<Bundle> bundles) {
                    Executor executor = this.this$0.mExecutor;
                    if (executor != null) {
                        executor.execute(() -> {
                            Context context = this.this$0.mContext;
                            OnSessionTokensChangedListener listener = this.this$0.mListener;
                            if (context != null && listener != null) {
                                listener.onSessionTokensChanged(MediaSessionManager.toTokenList(bundles));
                            }
                        });
                    }
                }

                private void __constructor__(SessionTokensChangedWrapper sessionTokensChangedWrapper) {
                    this.$$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper_1$__constructor__(sessionTokensChangedWrapper);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper_1$__constructor__(android.media.session.MediaSessionManager$SessionTokensChangedWrapper ), this, sessionTokensChangedWrapper);
                }

                @Override
                public void onSessionTokensChanged(List<Bundle> list) {
                    InvokeDynamicSupport.bootstrap("onSessionTokensChanged", $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper_1$onSessionTokensChanged(java.util.List<android.os.Bundle> ), this, list);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mContext = context;
            this.mExecutor = executor;
            this.mListener = listener;
        }

        private final void $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper$release() {
            this.mListener = null;
            this.mContext = null;
            this.mExecutor = null;
        }

        private void __constructor__(Context context, Executor executor, OnSessionTokensChangedListener onSessionTokensChangedListener) {
            this.$$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper$__constructor__(context, executor, onSessionTokensChangedListener);
        }

        public SessionTokensChangedWrapper(Context context, Executor executor, OnSessionTokensChangedListener onSessionTokensChangedListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper$__constructor__(android.content.Context java.util.concurrent.Executor android.media.session.MediaSessionManager$OnSessionTokensChangedListener ), this, context, executor, onSessionTokensChangedListener);
        }

        private void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_session_MediaSessionManager_SessionTokensChangedWrapper$release(), this);
        }

        public /* synthetic */ SessionTokensChangedWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionTokensChangedWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SessionsChangedWrapper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Context mContext;
        private OnActiveSessionsChangedListener mListener;
        private Handler mHandler;
        private IActiveSessionsListener.Stub mStub;

        private void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$__constructor__(Context context, OnActiveSessionsChangedListener listener, Handler handler) {
            this.mStub = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ SessionsChangedWrapper this$0;

                private void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$__constructor__(SessionsChangedWrapper this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$onActiveSessionsChanged(List<MediaSession.Token> tokens) {
                    Handler handler = this.this$0.mHandler;
                    if (handler != null) {
                        handler.post(new Runnable(this, tokens){
                            public /* synthetic */ Object __robo_data__;
                            /* synthetic */ List val$tokens;
                            /* synthetic */ 1 this$1;

                            private void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$__constructor__(1 this$1, List list) {
                                this.this$1 = this$1;
                                this.val$tokens = list;
                            }

                            private final void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$run() {
                                Context context = this.this$1.this$0.mContext;
                                if (context != null) {
                                    ArrayList<MediaController> controllers = new ArrayList<MediaController>();
                                    int size = this.val$tokens.size();
                                    for (int i = 0; i < size; ++i) {
                                        controllers.add(new MediaController(context, (MediaSession.Token)this.val$tokens.get(i)));
                                    }
                                    OnActiveSessionsChangedListener listener = this.this$1.this$0.mListener;
                                    if (listener != null) {
                                        listener.onActiveSessionsChanged(controllers);
                                    }
                                }
                            }

                            private void __constructor__(1 var1_1, List list) {
                                this.$$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$__constructor__(var1_1, list);
                            }
                            {
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$__constructor__(android.media.session.MediaSessionManager$SessionsChangedWrapper$1 java.util.List ), this, var1_1, list);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$run(), this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                }

                private void __constructor__(SessionsChangedWrapper sessionsChangedWrapper) {
                    this.$$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$__constructor__(sessionsChangedWrapper);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$__constructor__(android.media.session.MediaSessionManager$SessionsChangedWrapper ), this, sessionsChangedWrapper);
                }

                @Override
                public void onActiveSessionsChanged(List<MediaSession.Token> list) {
                    InvokeDynamicSupport.bootstrap("onActiveSessionsChanged", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$onActiveSessionsChanged(java.util.List<android.media.session.MediaSession$Token> ), this, list);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mContext = context;
            this.mListener = listener;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$release() {
            this.mListener = null;
            this.mContext = null;
            this.mHandler = null;
        }

        private void __constructor__(Context context, OnActiveSessionsChangedListener onActiveSessionsChangedListener, Handler handler) {
            this.$$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$__constructor__(context, onActiveSessionsChangedListener, handler);
        }

        public SessionsChangedWrapper(Context context, OnActiveSessionsChangedListener onActiveSessionsChangedListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$__constructor__(android.content.Context android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.os.Handler ), this, context, onActiveSessionsChangedListener, handler);
        }

        private void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$release(), this);
        }

        public /* synthetic */ SessionsChangedWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionsChangedWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RemoteUserInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mPackageName;
        private int mPid;
        private int mUid;
        private IBinder mCallerBinder;

        private void $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$__constructor__(String packageName, int pid, int uid) {
        }

        private void $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$__constructor__(String packageName, int pid, int uid, IBinder callerBinder) {
            this.mPackageName = packageName;
            this.mPid = pid;
            this.mUid = uid;
            this.mCallerBinder = callerBinder;
        }

        private final String $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$getPackageName() {
            return this.mPackageName;
        }

        private final int $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$getPid() {
            return this.mPid;
        }

        private final int $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$getUid() {
            return this.mUid;
        }

        private final boolean $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$equals(Object obj) {
            if (!(obj instanceof RemoteUserInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            RemoteUserInfo otherUserInfo = (RemoteUserInfo)obj;
            return this.mCallerBinder == null || otherUserInfo.mCallerBinder == null ? false : this.mCallerBinder.equals(otherUserInfo.mCallerBinder);
        }

        private final int $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$hashCode() {
            return Objects.hash(this.mPackageName, this.mPid, this.mUid);
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$__constructor__(string2, n, n2);
        }

        public RemoteUserInfo(String string2, int n, int n2) {
            this(string2, n, n2, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        private void __constructor__(String string2, int n, int n2, IBinder iBinder) {
            this.$$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$__constructor__(string2, n, n2, iBinder);
        }

        public RemoteUserInfo(String string2, int n, int n2, IBinder iBinder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$__constructor__(java.lang.String int int android.os.IBinder ), this, string2, n, n2, iBinder);
        }

        public String getPackageName() {
            return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$getPackageName(), this);
        }

        public int getPid() {
            return (int)InvokeDynamicSupport.bootstrap("getPid", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$getPid(), this);
        }

        public int getUid() {
            return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$getUid(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_session_MediaSessionManager_RemoteUserInfo$hashCode(), this);
        }

        public /* synthetic */ RemoteUserInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteUserInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_session_MediaSessionManager_Callback$__constructor__() {
        }

        public abstract void onMediaKeyEventDispatched(KeyEvent var1, MediaSession.Token var2);

        public abstract void onMediaKeyEventDispatched(KeyEvent var1, ComponentName var2);

        public abstract void onAddressedPlayerChanged(MediaSession.Token var1);

        public abstract void onAddressedPlayerChanged(ComponentName var1);

        private void __constructor__() {
            this.$$robo$$android_media_session_MediaSessionManager_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_Callback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static interface OnMediaKeyListener {
        public boolean onMediaKey(KeyEvent var1);
    }

    @SystemApi
    public static interface OnVolumeKeyLongPressListener {
        public void onVolumeKeyLongPress(KeyEvent var1);
    }

    public static interface OnSessionTokensChangedListener {
        public void onSessionTokensChanged(List<SessionToken2> var1);
    }

    public static interface OnActiveSessionsChangedListener {
        public void onActiveSessionsChanged(List<MediaController> var1);
    }
}

