/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.VolumeProvider;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionController;
import android.media.session.ISessionControllerCallback;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaSession
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaSession";
    @Deprecated
    public static int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    @Deprecated
    public static int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static int FLAG_EXCLUSIVE_GLOBAL_PRIORITY = 65536;
    public static int INVALID_UID = -1;
    public static int INVALID_PID = -1;
    private Object mLock;
    private int mMaxBitmapSize;
    private Token mSessionToken;
    private MediaController mController;
    private ISession mBinder;
    private CallbackStub mCbStub;
    private CallbackMessageHandler mCallback;
    private VolumeProvider mVolumeProvider;
    private PlaybackState mPlaybackState;
    private boolean mActive;

    private void $$robo$$android_media_session_MediaSession$__constructor__(Context context, String tag) {
    }

    private void $$robo$$android_media_session_MediaSession$__constructor__(Context context, String tag, int userId) {
        this.mLock = new Object();
        this.mActive = false;
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (TextUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("tag cannot be null or empty");
        }
        this.mMaxBitmapSize = context.getResources().getDimensionPixelSize(17104963);
        this.mCbStub = new CallbackStub(this);
        MediaSessionManager manager = (MediaSessionManager)context.getSystemService("media_session");
        try {
            this.mBinder = manager.createSession(this.mCbStub, tag, userId);
            this.mSessionToken = new Token(this.mBinder.getController());
            this.mController = new MediaController(context, this.mSessionToken);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Remote error creating session.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            CallbackMessageHandler msgHandler;
            if (this.mCallback != null) {
                this.mCallback.mCallback.mSession = null;
                this.mCallback.removeCallbacksAndMessages(null);
            }
            if (callback == null) {
                this.mCallback = null;
                return;
            }
            if (handler == null) {
                handler = new Handler();
            }
            callback.mSession = this;
            this.mCallback = msgHandler = new CallbackMessageHandler(this, handler.getLooper(), callback);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setSessionActivity(PendingIntent pi) {
        try {
            this.mBinder.setLaunchPendingIntent(pi);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setLaunchPendingIntent.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setMediaButtonReceiver(PendingIntent mbr) {
        try {
            this.mBinder.setMediaButtonReceiver(mbr);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setMediaButtonReceiver.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setFlags(int flags) {
        try {
            this.mBinder.setFlags(flags);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setFlags.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setPlaybackToLocal(AudioAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null for local playback.");
        }
        try {
            this.mBinder.setPlaybackToLocal(attributes);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setPlaybackToLocal.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$setPlaybackToRemote(VolumeProvider volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mVolumeProvider = volumeProvider;
        }
        volumeProvider.setCallback((VolumeProvider.Callback)new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSession this$0;

            private void $$robo$$android_media_session_MediaSession_1$__constructor__(MediaSession this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_session_MediaSession_1$onVolumeChanged(VolumeProvider volumeProvider) {
                this.this$0.notifyRemoteVolumeChanged(volumeProvider);
            }

            private void __constructor__(MediaSession mediaSession) {
                this.$$robo$$android_media_session_MediaSession_1$__constructor__(mediaSession);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_1$__constructor__(android.media.session.MediaSession ), this, mediaSession);
            }

            @Override
            public void onVolumeChanged(VolumeProvider volumeProvider) {
                InvokeDynamicSupport.bootstrap("onVolumeChanged", $$robo$$android_media_session_MediaSession_1$onVolumeChanged(android.media.VolumeProvider ), this, volumeProvider);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        try {
            this.mBinder.setPlaybackToRemote(volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume());
            this.mBinder.setCurrentVolume(volumeProvider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setPlaybackToRemote.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setActive(boolean active) {
        if (this.mActive == active) {
            return;
        }
        try {
            this.mBinder.setActive(active);
            this.mActive = active;
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setActive.", e);
        }
    }

    private final boolean $$robo$$android_media_session_MediaSession$isActive() {
        return this.mActive;
    }

    private final void $$robo$$android_media_session_MediaSession$sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty(event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        try {
            this.mBinder.sendEvent(event, extras);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Error sending event", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$release() {
        try {
            this.mBinder.destroy();
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Error releasing session: ", e);
        }
    }

    private final Token $$robo$$android_media_session_MediaSession$getSessionToken() {
        return this.mSessionToken;
    }

    private final MediaController $$robo$$android_media_session_MediaSession$getController() {
        return this.mController;
    }

    private final void $$robo$$android_media_session_MediaSession$setPlaybackState(PlaybackState state) {
        this.mPlaybackState = state;
        try {
            this.mBinder.setPlaybackState(state);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Dead object in setPlaybackState.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setMetadata(MediaMetadata metadata) {
        if (metadata != null) {
            metadata = new MediaMetadata.Builder(metadata, this.mMaxBitmapSize).build();
        }
        try {
            this.mBinder.setMetadata(metadata);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Dead object in setPlaybackState.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setQueue(List<QueueItem> queue) {
        try {
            this.mBinder.setQueue(queue == null ? null : new ParceledListSlice<QueueItem>(queue));
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueue.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setQueueTitle(CharSequence title) {
        try {
            this.mBinder.setQueueTitle(title);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueueTitle.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setRatingType(int type) {
        try {
            this.mBinder.setRatingType(type);
        }
        catch (RemoteException e) {
            Log.e("MediaSession", "Error in setRatingType.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setExtras(Bundle extras) {
        try {
            this.mBinder.setExtras(extras);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setExtras.", e);
        }
    }

    private final MediaSessionManager.RemoteUserInfo $$robo$$android_media_session_MediaSession$getCurrentControllerInfo() {
        if (this.mCallback == null || this.mCallback.mCurrentControllerInfo == null) {
            throw new IllegalStateException("This should be called inside of MediaSession.Callback methods");
        }
        return this.mCallback.mCurrentControllerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$notifyRemoteVolumeChanged(VolumeProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            if (provider == null || provider != this.mVolumeProvider) {
                Log.w("MediaSession", "Received update from stale volume provider");
                return;
            }
        }
        try {
            this.mBinder.setCurrentVolume(provider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.e("MediaSession", "Error in notifyVolumeChanged", e);
        }
    }

    private final String $$robo$$android_media_session_MediaSession$getCallingPackage() {
        if (this.mCallback != null && this.mCallback.mCurrentControllerInfo != null) {
            return this.mCallback.mCurrentControllerInfo.getPackageName();
        }
        return null;
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepare(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 3, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepareFromMediaId(MediaSessionManager.RemoteUserInfo caller, String mediaId, Bundle extras) {
        this.postToCallback(caller, 4, mediaId, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepareFromSearch(MediaSessionManager.RemoteUserInfo caller, String query, Bundle extras) {
        this.postToCallback(caller, 5, query, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepareFromUri(MediaSessionManager.RemoteUserInfo caller, Uri uri, Bundle extras) {
        this.postToCallback(caller, 6, uri, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlay(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 7, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlayFromMediaId(MediaSessionManager.RemoteUserInfo caller, String mediaId, Bundle extras) {
        this.postToCallback(caller, 8, mediaId, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlayFromSearch(MediaSessionManager.RemoteUserInfo caller, String query, Bundle extras) {
        this.postToCallback(caller, 9, query, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlayFromUri(MediaSessionManager.RemoteUserInfo caller, Uri uri, Bundle extras) {
        this.postToCallback(caller, 10, uri, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchSkipToItem(MediaSessionManager.RemoteUserInfo caller, long id2) {
        this.postToCallback(caller, 11, id2, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPause(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 12, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchStop(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 13, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchNext(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 14, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrevious(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 15, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchFastForward(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 16, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchRewind(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 17, null, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchSeekTo(MediaSessionManager.RemoteUserInfo caller, long pos) {
        this.postToCallback(caller, 18, pos, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchRate(MediaSessionManager.RemoteUserInfo caller, Rating rating) {
        this.postToCallback(caller, 19, rating, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchCustomAction(MediaSessionManager.RemoteUserInfo caller, String action, Bundle args) {
        this.postToCallback(caller, 20, action, args);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchMediaButton(MediaSessionManager.RemoteUserInfo caller, Intent mediaButtonIntent) {
        this.postToCallback(caller, 2, mediaButtonIntent, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchMediaButtonDelayed(MediaSessionManager.RemoteUserInfo info, Intent mediaButtonIntent, long delay) {
        this.postToCallbackDelayed(info, 23, mediaButtonIntent, null, delay);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchAdjustVolume(MediaSessionManager.RemoteUserInfo caller, int direction) {
        this.postToCallback(caller, 21, direction, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchSetVolumeTo(MediaSessionManager.RemoteUserInfo caller, int volume) {
        this.postToCallback(caller, 22, volume, null);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchCommand(MediaSessionManager.RemoteUserInfo caller, String command, Bundle args, ResultReceiver resultCb) {
        Command cmd = new Command(command, args, resultCb);
        this.postToCallback(caller, 1, cmd, null);
    }

    private final void $$robo$$android_media_session_MediaSession$postToCallback(MediaSessionManager.RemoteUserInfo caller, int what, Object obj, Bundle data) {
        this.postToCallbackDelayed(caller, what, obj, data, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$postToCallbackDelayed(MediaSessionManager.RemoteUserInfo caller, int what, Object obj, Bundle data, long delay) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback != null) {
                this.mCallback.post(caller, what, obj, data, delay);
            }
        }
    }

    private static final boolean $$robo$$android_media_session_MediaSession$isActiveState(int state) {
        switch (state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private void __constructor__(Context context, String string2) {
        this.$$robo$$android_media_session_MediaSession$__constructor__(context, string2);
    }

    public MediaSession(Context context, String string2) {
        this(context, string2, UserHandle.myUserId());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession$__constructor__(android.content.Context java.lang.String ), this, context, string2);
    }

    private void __constructor__(Context context, String string2, int n) {
        this.$$robo$$android_media_session_MediaSession$__constructor__(context, string2, n);
    }

    public MediaSession(Context context, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession$__constructor__(android.content.Context java.lang.String int ), this, context, string2, n);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_session_MediaSession$setCallback(android.media.session.MediaSession$Callback ), this, callback);
    }

    public void setCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_session_MediaSession$setCallback(android.media.session.MediaSession$Callback android.os.Handler ), this, callback, handler);
    }

    public void setSessionActivity(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setSessionActivity", $$robo$$android_media_session_MediaSession$setSessionActivity(android.app.PendingIntent ), this, pendingIntent);
    }

    public void setMediaButtonReceiver(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setMediaButtonReceiver", $$robo$$android_media_session_MediaSession$setMediaButtonReceiver(android.app.PendingIntent ), this, pendingIntent);
    }

    public void setFlags(int n) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_media_session_MediaSession$setFlags(int ), this, n);
    }

    public void setPlaybackToLocal(AudioAttributes audioAttributes) {
        InvokeDynamicSupport.bootstrap("setPlaybackToLocal", $$robo$$android_media_session_MediaSession$setPlaybackToLocal(android.media.AudioAttributes ), this, audioAttributes);
    }

    public void setPlaybackToRemote(VolumeProvider volumeProvider) {
        InvokeDynamicSupport.bootstrap("setPlaybackToRemote", $$robo$$android_media_session_MediaSession$setPlaybackToRemote(android.media.VolumeProvider ), this, volumeProvider);
    }

    public void setActive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_media_session_MediaSession$setActive(boolean ), this, bl);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_media_session_MediaSession$isActive(), this);
    }

    public void sendSessionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendSessionEvent", $$robo$$android_media_session_MediaSession$sendSessionEvent(java.lang.String android.os.Bundle ), this, string2, bundle);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_session_MediaSession$release(), this);
    }

    public Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_media_session_MediaSession$getSessionToken(), this);
    }

    public MediaController getController() {
        return InvokeDynamicSupport.bootstrap("getController", $$robo$$android_media_session_MediaSession$getController(), this);
    }

    public void setPlaybackState(PlaybackState playbackState) {
        InvokeDynamicSupport.bootstrap("setPlaybackState", $$robo$$android_media_session_MediaSession$setPlaybackState(android.media.session.PlaybackState ), this, playbackState);
    }

    public void setMetadata(MediaMetadata mediaMetadata) {
        InvokeDynamicSupport.bootstrap("setMetadata", $$robo$$android_media_session_MediaSession$setMetadata(android.media.MediaMetadata ), this, mediaMetadata);
    }

    public void setQueue(List<QueueItem> list) {
        InvokeDynamicSupport.bootstrap("setQueue", $$robo$$android_media_session_MediaSession$setQueue(java.util.List<android.media.session.MediaSession$QueueItem> ), this, list);
    }

    public void setQueueTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setQueueTitle", $$robo$$android_media_session_MediaSession$setQueueTitle(java.lang.CharSequence ), this, charSequence);
    }

    public void setRatingType(int n) {
        InvokeDynamicSupport.bootstrap("setRatingType", $$robo$$android_media_session_MediaSession$setRatingType(int ), this, n);
    }

    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_media_session_MediaSession$setExtras(android.os.Bundle ), this, bundle);
    }

    public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
        return InvokeDynamicSupport.bootstrap("getCurrentControllerInfo", $$robo$$android_media_session_MediaSession$getCurrentControllerInfo(), this);
    }

    public void notifyRemoteVolumeChanged(VolumeProvider volumeProvider) {
        InvokeDynamicSupport.bootstrap("notifyRemoteVolumeChanged", $$robo$$android_media_session_MediaSession$notifyRemoteVolumeChanged(android.media.VolumeProvider ), this, volumeProvider);
    }

    public String getCallingPackage() {
        return InvokeDynamicSupport.bootstrap("getCallingPackage", $$robo$$android_media_session_MediaSession$getCallingPackage(), this);
    }

    private void dispatchPrepare(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchPrepare", $$robo$$android_media_session_MediaSession$dispatchPrepare(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchPrepareFromMediaId(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPrepareFromMediaId", $$robo$$android_media_session_MediaSession$dispatchPrepareFromMediaId(android.media.session.MediaSessionManager$RemoteUserInfo java.lang.String android.os.Bundle ), this, remoteUserInfo, string2, bundle);
    }

    private void dispatchPrepareFromSearch(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPrepareFromSearch", $$robo$$android_media_session_MediaSession$dispatchPrepareFromSearch(android.media.session.MediaSessionManager$RemoteUserInfo java.lang.String android.os.Bundle ), this, remoteUserInfo, string2, bundle);
    }

    private void dispatchPrepareFromUri(MediaSessionManager.RemoteUserInfo remoteUserInfo, Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPrepareFromUri", $$robo$$android_media_session_MediaSession$dispatchPrepareFromUri(android.media.session.MediaSessionManager$RemoteUserInfo android.net.Uri android.os.Bundle ), this, remoteUserInfo, uri, bundle);
    }

    private void dispatchPlay(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchPlay", $$robo$$android_media_session_MediaSession$dispatchPlay(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchPlayFromMediaId(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPlayFromMediaId", $$robo$$android_media_session_MediaSession$dispatchPlayFromMediaId(android.media.session.MediaSessionManager$RemoteUserInfo java.lang.String android.os.Bundle ), this, remoteUserInfo, string2, bundle);
    }

    private void dispatchPlayFromSearch(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPlayFromSearch", $$robo$$android_media_session_MediaSession$dispatchPlayFromSearch(android.media.session.MediaSessionManager$RemoteUserInfo java.lang.String android.os.Bundle ), this, remoteUserInfo, string2, bundle);
    }

    private void dispatchPlayFromUri(MediaSessionManager.RemoteUserInfo remoteUserInfo, Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPlayFromUri", $$robo$$android_media_session_MediaSession$dispatchPlayFromUri(android.media.session.MediaSessionManager$RemoteUserInfo android.net.Uri android.os.Bundle ), this, remoteUserInfo, uri, bundle);
    }

    private void dispatchSkipToItem(MediaSessionManager.RemoteUserInfo remoteUserInfo, long l) {
        InvokeDynamicSupport.bootstrap("dispatchSkipToItem", $$robo$$android_media_session_MediaSession$dispatchSkipToItem(android.media.session.MediaSessionManager$RemoteUserInfo long ), this, remoteUserInfo, l);
    }

    private void dispatchPause(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchPause", $$robo$$android_media_session_MediaSession$dispatchPause(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchStop(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchStop", $$robo$$android_media_session_MediaSession$dispatchStop(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchNext(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchNext", $$robo$$android_media_session_MediaSession$dispatchNext(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchPrevious(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchPrevious", $$robo$$android_media_session_MediaSession$dispatchPrevious(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchFastForward(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchFastForward", $$robo$$android_media_session_MediaSession$dispatchFastForward(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchRewind(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        InvokeDynamicSupport.bootstrap("dispatchRewind", $$robo$$android_media_session_MediaSession$dispatchRewind(android.media.session.MediaSessionManager$RemoteUserInfo ), this, remoteUserInfo);
    }

    private void dispatchSeekTo(MediaSessionManager.RemoteUserInfo remoteUserInfo, long l) {
        InvokeDynamicSupport.bootstrap("dispatchSeekTo", $$robo$$android_media_session_MediaSession$dispatchSeekTo(android.media.session.MediaSessionManager$RemoteUserInfo long ), this, remoteUserInfo, l);
    }

    private void dispatchRate(MediaSessionManager.RemoteUserInfo remoteUserInfo, Rating rating) {
        InvokeDynamicSupport.bootstrap("dispatchRate", $$robo$$android_media_session_MediaSession$dispatchRate(android.media.session.MediaSessionManager$RemoteUserInfo android.media.Rating ), this, remoteUserInfo, rating);
    }

    private void dispatchCustomAction(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchCustomAction", $$robo$$android_media_session_MediaSession$dispatchCustomAction(android.media.session.MediaSessionManager$RemoteUserInfo java.lang.String android.os.Bundle ), this, remoteUserInfo, string2, bundle);
    }

    private void dispatchMediaButton(MediaSessionManager.RemoteUserInfo remoteUserInfo, Intent intent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaButton", $$robo$$android_media_session_MediaSession$dispatchMediaButton(android.media.session.MediaSessionManager$RemoteUserInfo android.content.Intent ), this, remoteUserInfo, intent);
    }

    private void dispatchMediaButtonDelayed(MediaSessionManager.RemoteUserInfo remoteUserInfo, Intent intent, long l) {
        InvokeDynamicSupport.bootstrap("dispatchMediaButtonDelayed", $$robo$$android_media_session_MediaSession$dispatchMediaButtonDelayed(android.media.session.MediaSessionManager$RemoteUserInfo android.content.Intent long ), this, remoteUserInfo, intent, l);
    }

    private void dispatchAdjustVolume(MediaSessionManager.RemoteUserInfo remoteUserInfo, int n) {
        InvokeDynamicSupport.bootstrap("dispatchAdjustVolume", $$robo$$android_media_session_MediaSession$dispatchAdjustVolume(android.media.session.MediaSessionManager$RemoteUserInfo int ), this, remoteUserInfo, n);
    }

    private void dispatchSetVolumeTo(MediaSessionManager.RemoteUserInfo remoteUserInfo, int n) {
        InvokeDynamicSupport.bootstrap("dispatchSetVolumeTo", $$robo$$android_media_session_MediaSession$dispatchSetVolumeTo(android.media.session.MediaSessionManager$RemoteUserInfo int ), this, remoteUserInfo, n);
    }

    private void dispatchCommand(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("dispatchCommand", $$robo$$android_media_session_MediaSession$dispatchCommand(android.media.session.MediaSessionManager$RemoteUserInfo java.lang.String android.os.Bundle android.os.ResultReceiver ), this, remoteUserInfo, string2, bundle, resultReceiver);
    }

    private void postToCallback(MediaSessionManager.RemoteUserInfo remoteUserInfo, int n, Object object, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("postToCallback", $$robo$$android_media_session_MediaSession$postToCallback(android.media.session.MediaSessionManager$RemoteUserInfo int java.lang.Object android.os.Bundle ), this, remoteUserInfo, n, object, bundle);
    }

    private void postToCallbackDelayed(MediaSessionManager.RemoteUserInfo remoteUserInfo, int n, Object object, Bundle bundle, long l) {
        InvokeDynamicSupport.bootstrap("postToCallbackDelayed", $$robo$$android_media_session_MediaSession$postToCallbackDelayed(android.media.session.MediaSessionManager$RemoteUserInfo int java.lang.Object android.os.Bundle long ), this, remoteUserInfo, n, object, bundle, l);
    }

    public static boolean isActiveState(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isActiveState", $$robo$$android_media_session_MediaSession$isActiveState(int ), (int)n);
    }

    public /* synthetic */ MediaSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallbackMessageHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_COMMAND = 1;
        private static int MSG_MEDIA_BUTTON = 2;
        private static int MSG_PREPARE = 3;
        private static int MSG_PREPARE_MEDIA_ID = 4;
        private static int MSG_PREPARE_SEARCH = 5;
        private static int MSG_PREPARE_URI = 6;
        private static int MSG_PLAY = 7;
        private static int MSG_PLAY_MEDIA_ID = 8;
        private static int MSG_PLAY_SEARCH = 9;
        private static int MSG_PLAY_URI = 10;
        private static int MSG_SKIP_TO_ITEM = 11;
        private static int MSG_PAUSE = 12;
        private static int MSG_STOP = 13;
        private static int MSG_NEXT = 14;
        private static int MSG_PREVIOUS = 15;
        private static int MSG_FAST_FORWARD = 16;
        private static int MSG_REWIND = 17;
        private static int MSG_SEEK_TO = 18;
        private static int MSG_RATE = 19;
        private static int MSG_CUSTOM_ACTION = 20;
        private static int MSG_ADJUST_VOLUME = 21;
        private static int MSG_SET_VOLUME = 22;
        private static int MSG_PLAY_PAUSE_KEY_DOUBLE_TAP_TIMEOUT = 23;
        private Callback mCallback;
        private MediaSessionManager.RemoteUserInfo mCurrentControllerInfo;
        /* synthetic */ MediaSession this$0;

        private void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$__constructor__(MediaSession mediaSession, Looper looper, Callback callback) {
            this.this$0 = mediaSession;
            this.mCallback = callback;
            this.mCallback.mHandler = this;
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(MediaSessionManager.RemoteUserInfo caller, int what, Object obj, Bundle data, long delayMs) {
            Pair<MediaSessionManager.RemoteUserInfo, Object> objWithCaller = Pair.create(caller, obj);
            Message msg = this.obtainMessage(what, objWithCaller);
            msg.setData(data);
            if (delayMs > 0L) {
                this.sendMessageDelayed(msg, delayMs);
            } else {
                this.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$handleMessage(Message msg) {
            this.mCurrentControllerInfo = (MediaSessionManager.RemoteUserInfo)((Pair)msg.obj).first;
            Object obj = ((Pair)msg.obj).second;
            switch (msg.what) {
                case 1: {
                    Command cmd = (Command)obj;
                    this.mCallback.onCommand(cmd.command, cmd.extras, cmd.stub);
                    break;
                }
                case 2: {
                    this.mCallback.onMediaButtonEvent((Intent)obj);
                    break;
                }
                case 3: {
                    this.mCallback.onPrepare();
                    break;
                }
                case 4: {
                    this.mCallback.onPrepareFromMediaId((String)obj, msg.getData());
                    break;
                }
                case 5: {
                    this.mCallback.onPrepareFromSearch((String)obj, msg.getData());
                    break;
                }
                case 6: {
                    this.mCallback.onPrepareFromUri((Uri)obj, msg.getData());
                    break;
                }
                case 7: {
                    this.mCallback.onPlay();
                    break;
                }
                case 8: {
                    this.mCallback.onPlayFromMediaId((String)obj, msg.getData());
                    break;
                }
                case 9: {
                    this.mCallback.onPlayFromSearch((String)obj, msg.getData());
                    break;
                }
                case 10: {
                    this.mCallback.onPlayFromUri((Uri)obj, msg.getData());
                    break;
                }
                case 11: {
                    this.mCallback.onSkipToQueueItem((Long)obj);
                    break;
                }
                case 12: {
                    this.mCallback.onPause();
                    break;
                }
                case 13: {
                    this.mCallback.onStop();
                    break;
                }
                case 14: {
                    this.mCallback.onSkipToNext();
                    break;
                }
                case 15: {
                    this.mCallback.onSkipToPrevious();
                    break;
                }
                case 16: {
                    this.mCallback.onFastForward();
                    break;
                }
                case 17: {
                    this.mCallback.onRewind();
                    break;
                }
                case 18: {
                    this.mCallback.onSeekTo((Long)obj);
                    break;
                }
                case 19: {
                    this.mCallback.onSetRating((Rating)obj);
                    break;
                }
                case 20: {
                    this.mCallback.onCustomAction((String)obj, msg.getData());
                    break;
                }
                case 21: {
                    VolumeProvider vp;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        vp = this.this$0.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onAdjustVolume((Integer)obj);
                    break;
                }
                case 22: {
                    VolumeProvider vp;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        vp = this.this$0.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onSetVolumeTo((Integer)obj);
                    break;
                }
                case 23: {
                    this.mCallback.handleMediaPlayPauseKeySingleTapIfPending();
                }
            }
            this.mCurrentControllerInfo = null;
        }

        private void __constructor__(MediaSession mediaSession, Looper looper, Callback callback) {
            this.$$robo$$android_media_session_MediaSession_CallbackMessageHandler$__constructor__(mediaSession, looper, callback);
        }

        public CallbackMessageHandler(MediaSession mediaSession, Looper looper, Callback callback) {
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$__constructor__(android.media.session.MediaSession android.os.Looper android.media.session.MediaSession$Callback ), this, mediaSession, looper, callback);
        }

        public void post(MediaSessionManager.RemoteUserInfo remoteUserInfo, int n, Object object, Bundle bundle, long l) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(android.media.session.MediaSessionManager$RemoteUserInfo int java.lang.Object android.os.Bundle long ), this, remoteUserInfo, n, object, bundle, l);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ CallbackMessageHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackMessageHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class Command
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String command;
        public Bundle extras;
        public ResultReceiver stub;

        private void $$robo$$android_media_session_MediaSession_Command$__constructor__(String command, Bundle extras, ResultReceiver stub) {
            this.command = command;
            this.extras = extras;
            this.stub = stub;
        }

        private void __constructor__(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            this.$$robo$$android_media_session_MediaSession_Command$__constructor__(string2, bundle, resultReceiver);
        }

        public Command(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Command$__constructor__(java.lang.String android.os.Bundle android.os.ResultReceiver ), this, string2, bundle, resultReceiver);
        }

        public /* synthetic */ Command() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Command)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class QueueItem
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int UNKNOWN_ID = -1;
        private MediaDescription mDescription;
        private long mId;
        public static Parcelable.Creator<QueueItem> CREATOR;

        private void $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(MediaDescription description, long id2) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null.");
            }
            if (id2 == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = description;
            this.mId = id2;
        }

        private void $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(Parcel in) {
            this.mDescription = MediaDescription.CREATOR.createFromParcel(in);
            this.mId = in.readLong();
        }

        private final MediaDescription $$robo$$android_media_session_MediaSession_QueueItem$getDescription() {
            return this.mDescription;
        }

        private final long $$robo$$android_media_session_MediaSession_QueueItem$getQueueId() {
            return this.mId;
        }

        private final void $$robo$$android_media_session_MediaSession_QueueItem$writeToParcel(Parcel dest, int flags) {
            this.mDescription.writeToParcel(dest, flags);
            dest.writeLong(this.mId);
        }

        private final int $$robo$$android_media_session_MediaSession_QueueItem$describeContents() {
            return 0;
        }

        private final String $$robo$$android_media_session_MediaSession_QueueItem$toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }

        private final boolean $$robo$$android_media_session_MediaSession_QueueItem$equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof QueueItem)) {
                return false;
            }
            QueueItem item = (QueueItem)o;
            if (this.mId != item.mId) {
                return false;
            }
            return Objects.equals(this.mDescription, item.mDescription);
        }

        private /* synthetic */ void $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<QueueItem>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_session_MediaSession_QueueItem_1$__constructor__() {
                }

                private final QueueItem $$robo$$android_media_session_MediaSession_QueueItem_1$createFromParcel(Parcel p) {
                    return new QueueItem(p, null);
                }

                private final QueueItem[] $$robo$$android_media_session_MediaSession_QueueItem_1$newArray(int size) {
                    return new QueueItem[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_session_MediaSession_QueueItem_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem_1$__constructor__(), this);
                }

                @Override
                public QueueItem createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_session_MediaSession_QueueItem_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public QueueItem[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_session_MediaSession_QueueItem_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(MediaDescription mediaDescription, long l) {
            this.$$robo$$android_media_session_MediaSession_QueueItem$__constructor__(mediaDescription, l);
        }

        public QueueItem(MediaDescription mediaDescription, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(android.media.MediaDescription long ), this, mediaDescription, l);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_session_MediaSession_QueueItem$__constructor__(parcel);
        }

        public QueueItem(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(android.os.Parcel ), this, parcel);
        }

        public MediaDescription getDescription() {
            return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_media_session_MediaSession_QueueItem$getDescription(), this);
        }

        public long getQueueId() {
            return (long)InvokeDynamicSupport.bootstrap("getQueueId", $$robo$$android_media_session_MediaSession_QueueItem$getQueueId(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_session_MediaSession_QueueItem$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_session_MediaSession_QueueItem$describeContents(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_session_MediaSession_QueueItem$toString(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_session_MediaSession_QueueItem$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_session_MediaSession_QueueItem$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ QueueItem(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(android.os.Parcel android.media.session.MediaSession$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(QueueItem.class);
        }

        public /* synthetic */ QueueItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QueueItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CallbackStub
    extends ISessionCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<MediaSession> mMediaSession;

        private void $$robo$$android_media_session_MediaSession_CallbackStub$__constructor__(MediaSession session) {
            this.mMediaSession = new WeakReference<MediaSession>(session);
        }

        private static final MediaSessionManager.RemoteUserInfo $$robo$$android_media_session_MediaSession_CallbackStub$createRemoteUserInfo(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            return new MediaSessionManager.RemoteUserInfo(packageName, pid, uid, caller != null ? caller.asBinder() : null);
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onCommand(String packageName, int pid, int uid, ISessionControllerCallback caller, String command, Bundle args, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchCommand(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), command, args, cb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onMediaButton(String packageName, int pid, int uid, Intent mediaButtonIntent, int sequenceNumber, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            try {
                if (session != null) {
                    session.dispatchMediaButton(CallbackStub.createRemoteUserInfo(packageName, pid, uid, null), mediaButtonIntent);
                }
            }
            finally {
                if (cb != null) {
                    cb.send(sequenceNumber, null);
                }
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onMediaButtonFromController(String packageName, int pid, int uid, ISessionControllerCallback caller, Intent mediaButtonIntent) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchMediaButton(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), mediaButtonIntent);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepare(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepare(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromMediaId(String packageName, int pid, int uid, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromMediaId(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), mediaId, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromSearch(String packageName, int pid, int uid, ISessionControllerCallback caller, String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromSearch(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), query, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromUri(String packageName, int pid, int uid, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromUri(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), uri, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlay(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlay(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromMediaId(String packageName, int pid, int uid, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromMediaId(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), mediaId, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromSearch(String packageName, int pid, int uid, ISessionControllerCallback caller, String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromSearch(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), query, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromUri(String packageName, int pid, int uid, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromUri(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), uri, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onSkipToTrack(String packageName, int pid, int uid, ISessionControllerCallback caller, long id2) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSkipToItem(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), id2);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPause(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPause(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onStop(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchStop(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onNext(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchNext(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrevious(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrevious(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onFastForward(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchFastForward(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onRewind(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRewind(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller));
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onSeekTo(String packageName, int pid, int uid, ISessionControllerCallback caller, long pos) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSeekTo(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), pos);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onRate(String packageName, int pid, int uid, ISessionControllerCallback caller, Rating rating) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRate(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), rating);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onCustomAction(String packageName, int pid, int uid, ISessionControllerCallback caller, String action, Bundle args) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchCustomAction(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), action, args);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onAdjustVolume(String packageName, int pid, int uid, ISessionControllerCallback caller, int direction) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchAdjustVolume(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), direction);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onSetVolumeTo(String packageName, int pid, int uid, ISessionControllerCallback caller, int value) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSetVolumeTo(CallbackStub.createRemoteUserInfo(packageName, pid, uid, caller), value);
            }
        }

        private void __constructor__(MediaSession mediaSession) {
            this.$$robo$$android_media_session_MediaSession_CallbackStub$__constructor__(mediaSession);
        }

        public CallbackStub(MediaSession mediaSession) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_CallbackStub$__constructor__(android.media.session.MediaSession ), this, mediaSession);
        }

        private static MediaSessionManager.RemoteUserInfo createRemoteUserInfo(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            return InvokeDynamicSupport.bootstrapStatic("createRemoteUserInfo", $$robo$$android_media_session_MediaSession_CallbackStub$createRemoteUserInfo(java.lang.String int int android.media.session.ISessionControllerCallback ), (String)string2, (int)n, (int)n2, (ISessionControllerCallback)iSessionControllerCallback);
        }

        @Override
        public void onCommand(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, String string3, Bundle bundle, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onCommand", $$robo$$android_media_session_MediaSession_CallbackStub$onCommand(java.lang.String int int android.media.session.ISessionControllerCallback java.lang.String android.os.Bundle android.os.ResultReceiver ), this, string2, n, n2, iSessionControllerCallback, string3, bundle, resultReceiver);
        }

        @Override
        public void onMediaButton(String string2, int n, int n2, Intent intent, int n3, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onMediaButton", $$robo$$android_media_session_MediaSession_CallbackStub$onMediaButton(java.lang.String int int android.content.Intent int android.os.ResultReceiver ), this, string2, n, n2, intent, n3, resultReceiver);
        }

        @Override
        public void onMediaButtonFromController(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, Intent intent) {
            InvokeDynamicSupport.bootstrap("onMediaButtonFromController", $$robo$$android_media_session_MediaSession_CallbackStub$onMediaButtonFromController(java.lang.String int int android.media.session.ISessionControllerCallback android.content.Intent ), this, string2, n, n2, iSessionControllerCallback, intent);
        }

        @Override
        public void onPrepare(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onPrepare", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepare(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onPrepareFromMediaId(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromMediaId", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromMediaId(java.lang.String int int android.media.session.ISessionControllerCallback java.lang.String android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, string3, bundle);
        }

        @Override
        public void onPrepareFromSearch(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromSearch", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromSearch(java.lang.String int int android.media.session.ISessionControllerCallback java.lang.String android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, string3, bundle);
        }

        @Override
        public void onPrepareFromUri(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromUri", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromUri(java.lang.String int int android.media.session.ISessionControllerCallback android.net.Uri android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, uri, bundle);
        }

        @Override
        public void onPlay(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onPlay", $$robo$$android_media_session_MediaSession_CallbackStub$onPlay(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onPlayFromMediaId(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromMediaId", $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromMediaId(java.lang.String int int android.media.session.ISessionControllerCallback java.lang.String android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, string3, bundle);
        }

        @Override
        public void onPlayFromSearch(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromSearch", $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromSearch(java.lang.String int int android.media.session.ISessionControllerCallback java.lang.String android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, string3, bundle);
        }

        @Override
        public void onPlayFromUri(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromUri", $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromUri(java.lang.String int int android.media.session.ISessionControllerCallback android.net.Uri android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, uri, bundle);
        }

        @Override
        public void onSkipToTrack(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, long l) {
            InvokeDynamicSupport.bootstrap("onSkipToTrack", $$robo$$android_media_session_MediaSession_CallbackStub$onSkipToTrack(java.lang.String int int android.media.session.ISessionControllerCallback long ), this, string2, n, n2, iSessionControllerCallback, l);
        }

        @Override
        public void onPause(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_media_session_MediaSession_CallbackStub$onPause(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onStop(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_session_MediaSession_CallbackStub$onStop(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onNext(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onNext", $$robo$$android_media_session_MediaSession_CallbackStub$onNext(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onPrevious(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onPrevious", $$robo$$android_media_session_MediaSession_CallbackStub$onPrevious(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onFastForward(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onFastForward", $$robo$$android_media_session_MediaSession_CallbackStub$onFastForward(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onRewind(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback) {
            InvokeDynamicSupport.bootstrap("onRewind", $$robo$$android_media_session_MediaSession_CallbackStub$onRewind(java.lang.String int int android.media.session.ISessionControllerCallback ), this, string2, n, n2, iSessionControllerCallback);
        }

        @Override
        public void onSeekTo(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, long l) {
            InvokeDynamicSupport.bootstrap("onSeekTo", $$robo$$android_media_session_MediaSession_CallbackStub$onSeekTo(java.lang.String int int android.media.session.ISessionControllerCallback long ), this, string2, n, n2, iSessionControllerCallback, l);
        }

        @Override
        public void onRate(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, Rating rating) {
            InvokeDynamicSupport.bootstrap("onRate", $$robo$$android_media_session_MediaSession_CallbackStub$onRate(java.lang.String int int android.media.session.ISessionControllerCallback android.media.Rating ), this, string2, n, n2, iSessionControllerCallback, rating);
        }

        @Override
        public void onCustomAction(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCustomAction", $$robo$$android_media_session_MediaSession_CallbackStub$onCustomAction(java.lang.String int int android.media.session.ISessionControllerCallback java.lang.String android.os.Bundle ), this, string2, n, n2, iSessionControllerCallback, string3, bundle);
        }

        @Override
        public void onAdjustVolume(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, int n3) {
            InvokeDynamicSupport.bootstrap("onAdjustVolume", $$robo$$android_media_session_MediaSession_CallbackStub$onAdjustVolume(java.lang.String int int android.media.session.ISessionControllerCallback int ), this, string2, n, n2, iSessionControllerCallback, n3);
        }

        @Override
        public void onSetVolumeTo(String string2, int n, int n2, ISessionControllerCallback iSessionControllerCallback, int n3) {
            InvokeDynamicSupport.bootstrap("onSetVolumeTo", $$robo$$android_media_session_MediaSession_CallbackStub$onSetVolumeTo(java.lang.String int int android.media.session.ISessionControllerCallback int ), this, string2, n, n2, iSessionControllerCallback, n3);
        }

        public /* synthetic */ CallbackStub() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackStub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private MediaSession mSession;
        private CallbackMessageHandler mHandler;
        private boolean mMediaPlayPauseKeyPending;

        private void $$robo$$android_media_session_MediaSession_Callback$__constructor__() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onCommand(String command, Bundle args, ResultReceiver cb) {
        }

        private final boolean $$robo$$android_media_session_MediaSession_Callback$onMediaButtonEvent(Intent mediaButtonIntent) {
            KeyEvent ke;
            if (this.mSession != null && this.mHandler != null && "android.intent.action.MEDIA_BUTTON".equals(mediaButtonIntent.getAction()) && (ke = (KeyEvent)mediaButtonIntent.getParcelableExtra("android.intent.extra.KEY_EVENT")) != null && ke.getAction() == 0) {
                PlaybackState state = this.mSession.mPlaybackState;
                long validActions = state == null ? 0L : state.getActions();
                switch (ke.getKeyCode()) {
                    case 79: 
                    case 85: {
                        if (ke.getRepeatCount() > 0) {
                            this.handleMediaPlayPauseKeySingleTapIfPending();
                        } else if (this.mMediaPlayPauseKeyPending) {
                            this.mHandler.removeMessages(23);
                            this.mMediaPlayPauseKeyPending = false;
                            if ((validActions & 0x20L) != 0L) {
                                this.onSkipToNext();
                            }
                        } else {
                            this.mMediaPlayPauseKeyPending = true;
                            this.mSession.dispatchMediaButtonDelayed(this.mSession.getCurrentControllerInfo(), mediaButtonIntent, ViewConfiguration.getDoubleTapTimeout());
                        }
                        return true;
                    }
                }
                this.handleMediaPlayPauseKeySingleTapIfPending();
                switch (ke.getKeyCode()) {
                    case 126: {
                        if ((validActions & 4L) == 0L) break;
                        this.onPlay();
                        return true;
                    }
                    case 127: {
                        if ((validActions & 2L) == 0L) break;
                        this.onPause();
                        return true;
                    }
                    case 87: {
                        if ((validActions & 0x20L) == 0L) break;
                        this.onSkipToNext();
                        return true;
                    }
                    case 88: {
                        if ((validActions & 0x10L) == 0L) break;
                        this.onSkipToPrevious();
                        return true;
                    }
                    case 86: {
                        if ((validActions & 1L) == 0L) break;
                        this.onStop();
                        return true;
                    }
                    case 90: {
                        if ((validActions & 0x40L) == 0L) break;
                        this.onFastForward();
                        return true;
                    }
                    case 89: {
                        if ((validActions & 8L) == 0L) break;
                        this.onRewind();
                        return true;
                    }
                }
            }
            return false;
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$handleMediaPlayPauseKeySingleTapIfPending() {
            boolean canPause;
            if (!this.mMediaPlayPauseKeyPending) {
                return;
            }
            this.mMediaPlayPauseKeyPending = false;
            this.mHandler.removeMessages(23);
            PlaybackState state = this.mSession.mPlaybackState;
            long validActions = state == null ? 0L : state.getActions();
            boolean isPlaying = state != null && state.getState() == 3;
            boolean canPlay = (validActions & 0x204L) != 0L;
            boolean bl = canPause = (validActions & 0x202L) != 0L;
            if (isPlaying && canPause) {
                this.onPause();
            } else if (!isPlaying && canPlay) {
                this.onPlay();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepare() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepareFromMediaId(String mediaId, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepareFromSearch(String query, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepareFromUri(Uri uri, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlay() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlayFromSearch(String query, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlayFromMediaId(String mediaId, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlayFromUri(Uri uri, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSkipToQueueItem(long id2) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPause() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSkipToNext() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSkipToPrevious() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onFastForward() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onRewind() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onStop() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSeekTo(long pos) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSetRating(Rating rating) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onCustomAction(String action, Bundle extras) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_session_MediaSession_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Callback$__constructor__(), this);
        }

        public void onCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onCommand", $$robo$$android_media_session_MediaSession_Callback$onCommand(java.lang.String android.os.Bundle android.os.ResultReceiver ), this, string2, bundle, resultReceiver);
        }

        public boolean onMediaButtonEvent(Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onMediaButtonEvent", $$robo$$android_media_session_MediaSession_Callback$onMediaButtonEvent(android.content.Intent ), this, intent);
        }

        private void handleMediaPlayPauseKeySingleTapIfPending() {
            InvokeDynamicSupport.bootstrap("handleMediaPlayPauseKeySingleTapIfPending", $$robo$$android_media_session_MediaSession_Callback$handleMediaPlayPauseKeySingleTapIfPending(), this);
        }

        public void onPrepare() {
            InvokeDynamicSupport.bootstrap("onPrepare", $$robo$$android_media_session_MediaSession_Callback$onPrepare(), this);
        }

        public void onPrepareFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromMediaId", $$robo$$android_media_session_MediaSession_Callback$onPrepareFromMediaId(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void onPrepareFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromSearch", $$robo$$android_media_session_MediaSession_Callback$onPrepareFromSearch(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void onPrepareFromUri(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromUri", $$robo$$android_media_session_MediaSession_Callback$onPrepareFromUri(android.net.Uri android.os.Bundle ), this, uri, bundle);
        }

        public void onPlay() {
            InvokeDynamicSupport.bootstrap("onPlay", $$robo$$android_media_session_MediaSession_Callback$onPlay(), this);
        }

        public void onPlayFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromSearch", $$robo$$android_media_session_MediaSession_Callback$onPlayFromSearch(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void onPlayFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromMediaId", $$robo$$android_media_session_MediaSession_Callback$onPlayFromMediaId(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        public void onPlayFromUri(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromUri", $$robo$$android_media_session_MediaSession_Callback$onPlayFromUri(android.net.Uri android.os.Bundle ), this, uri, bundle);
        }

        public void onSkipToQueueItem(long l) {
            InvokeDynamicSupport.bootstrap("onSkipToQueueItem", $$robo$$android_media_session_MediaSession_Callback$onSkipToQueueItem(long ), this, l);
        }

        public void onPause() {
            InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_media_session_MediaSession_Callback$onPause(), this);
        }

        public void onSkipToNext() {
            InvokeDynamicSupport.bootstrap("onSkipToNext", $$robo$$android_media_session_MediaSession_Callback$onSkipToNext(), this);
        }

        public void onSkipToPrevious() {
            InvokeDynamicSupport.bootstrap("onSkipToPrevious", $$robo$$android_media_session_MediaSession_Callback$onSkipToPrevious(), this);
        }

        public void onFastForward() {
            InvokeDynamicSupport.bootstrap("onFastForward", $$robo$$android_media_session_MediaSession_Callback$onFastForward(), this);
        }

        public void onRewind() {
            InvokeDynamicSupport.bootstrap("onRewind", $$robo$$android_media_session_MediaSession_Callback$onRewind(), this);
        }

        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_session_MediaSession_Callback$onStop(), this);
        }

        public void onSeekTo(long l) {
            InvokeDynamicSupport.bootstrap("onSeekTo", $$robo$$android_media_session_MediaSession_Callback$onSeekTo(long ), this, l);
        }

        public void onSetRating(Rating rating) {
            InvokeDynamicSupport.bootstrap("onSetRating", $$robo$$android_media_session_MediaSession_Callback$onSetRating(android.media.Rating ), this, rating);
        }

        public void onCustomAction(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCustomAction", $$robo$$android_media_session_MediaSession_Callback$onCustomAction(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Token
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ISessionController mBinder;
        public static Parcelable.Creator<Token> CREATOR;

        private void $$robo$$android_media_session_MediaSession_Token$__constructor__(ISessionController binder) {
            this.mBinder = binder;
        }

        private final int $$robo$$android_media_session_MediaSession_Token$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_session_MediaSession_Token$writeToParcel(Parcel dest, int flags) {
            dest.writeStrongBinder(this.mBinder.asBinder());
        }

        private final int $$robo$$android_media_session_MediaSession_Token$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mBinder == null ? 0 : this.mBinder.asBinder().hashCode());
            return result;
        }

        private final boolean $$robo$$android_media_session_MediaSession_Token$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            return !(this.mBinder == null ? other.mBinder != null : !this.mBinder.asBinder().equals(other.mBinder.asBinder()));
        }

        private final ISessionController $$robo$$android_media_session_MediaSession_Token$getBinder() {
            return this.mBinder;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Token>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_session_MediaSession_Token_1$__constructor__() {
                }

                private final Token $$robo$$android_media_session_MediaSession_Token_1$createFromParcel(Parcel in) {
                    return new Token(ISessionController.Stub.asInterface(in.readStrongBinder()));
                }

                private final Token[] $$robo$$android_media_session_MediaSession_Token_1$newArray(int size) {
                    return new Token[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_session_MediaSession_Token_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Token_1$__constructor__(), this);
                }

                @Override
                public Token createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_session_MediaSession_Token_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Token[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_session_MediaSession_Token_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ISessionController iSessionController) {
            this.$$robo$$android_media_session_MediaSession_Token$__constructor__(iSessionController);
        }

        public Token(ISessionController iSessionController) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Token$__constructor__(android.media.session.ISessionController ), this, iSessionController);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_session_MediaSession_Token$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_session_MediaSession_Token$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_session_MediaSession_Token$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_session_MediaSession_Token$equals(java.lang.Object ), this, object);
        }

        ISessionController getBinder() {
            return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_session_MediaSession_Token$getBinder(), this);
        }

        static {
            RobolectricInternals.classInitializing(Token.class);
        }

        public /* synthetic */ Token() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Token)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionFlags {
    }
}

