/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DynamicsProcessing
extends AudioEffect
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "DynamicsProcessing";
    private static int PARAM_GET_CHANNEL_COUNT = 16;
    private static int PARAM_INPUT_GAIN = 32;
    private static int PARAM_ENGINE_ARCHITECTURE = 48;
    private static int PARAM_PRE_EQ = 64;
    private static int PARAM_PRE_EQ_BAND = 69;
    private static int PARAM_MBC = 80;
    private static int PARAM_MBC_BAND = 85;
    private static int PARAM_POST_EQ = 96;
    private static int PARAM_POST_EQ_BAND = 101;
    private static int PARAM_LIMITER = 112;
    public static int VARIANT_FAVOR_FREQUENCY_RESOLUTION = 0;
    public static int VARIANT_FAVOR_TIME_RESOLUTION = 1;
    private static int CHANNEL_COUNT_MAX = 32;
    private int mChannelCount;
    private OnParameterChangeListener mParamListener;
    private BaseParameterListener mBaseParamListener;
    private Object mParamListenerLock;
    private static int CONFIG_DEFAULT_VARIANT = 0;
    private static boolean CONFIG_DEFAULT_USE_PREEQ = true;
    private static int CONFIG_DEFAULT_PREEQ_BANDS = 6;
    private static boolean CONFIG_DEFAULT_USE_MBC = true;
    private static int CONFIG_DEFAULT_MBC_BANDS = 6;
    private static boolean CONFIG_DEFAULT_USE_POSTEQ = true;
    private static int CONFIG_DEFAULT_POSTEQ_BANDS = 6;
    private static boolean CONFIG_DEFAULT_USE_LIMITER = true;
    private static float CHANNEL_DEFAULT_INPUT_GAIN = 0.0f;
    private static float CONFIG_PREFERRED_FRAME_DURATION_MS = 10.0f;
    private static float EQ_DEFAULT_GAIN = 0.0f;
    private static boolean PREEQ_DEFAULT_ENABLED = true;
    private static boolean POSTEQ_DEFAULT_ENABLED = true;
    private static boolean MBC_DEFAULT_ENABLED = true;
    private static float MBC_DEFAULT_ATTACK_TIME = 3.0f;
    private static float MBC_DEFAULT_RELEASE_TIME = 80.0f;
    private static float MBC_DEFAULT_RATIO = 1.0f;
    private static float MBC_DEFAULT_THRESHOLD = -45.0f;
    private static float MBC_DEFAULT_KNEE_WIDTH = 0.0f;
    private static float MBC_DEFAULT_NOISE_GATE_THRESHOLD = -90.0f;
    private static float MBC_DEFAULT_EXPANDER_RATIO = 1.0f;
    private static float MBC_DEFAULT_PRE_GAIN = 0.0f;
    private static float MBC_DEFAULT_POST_GAIN = 0.0f;
    private static boolean LIMITER_DEFAULT_ENABLED = true;
    private static int LIMITER_DEFAULT_LINK_GROUP = 0;
    private static float LIMITER_DEFAULT_ATTACK_TIME = 1.0f;
    private static float LIMITER_DEFAULT_RELEASE_TIME = 60.0f;
    private static float LIMITER_DEFAULT_RATIO = 10.0f;
    private static float LIMITER_DEFAULT_THRESHOLD = -2.0f;
    private static float LIMITER_DEFAULT_POST_GAIN = 0.0f;
    private static float DEFAULT_MIN_FREQUENCY = 220.0f;
    private static float DEFAULT_MAX_FREQUENCY = 20000.0f;
    private static float mMinFreqLog;
    private static float mMaxFreqLog;

    private void $$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(int audioSession) {
    }

    private void $$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(int priority, int audioSession) {
    }

    private void $$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(int priority, int audioSession, Config cfg) {
        Config config;
        this.mChannelCount = 0;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = new Object();
        if (audioSession == 0) {
            Log.w("DynamicsProcessing", "WARNING: attaching a DynamicsProcessing to global output mix isdeprecated!");
        }
        this.mChannelCount = this.getChannelCount();
        if (cfg == null) {
            Config.Builder builder = new Config.Builder(0, this.mChannelCount, true, 6, true, 6, true, 6, true);
            config = builder.build();
        } else {
            config = new Config(this.mChannelCount, cfg);
        }
        this.setEngineArchitecture(config.getVariant(), config.getPreferredFrameDuration(), config.isPreEqInUse(), config.getPreEqBandCount(), config.isMbcInUse(), config.getMbcBandCount(), config.isPostEqInUse(), config.getPostEqBandCount(), config.isLimiterInUse());
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.updateEngineChannelByChannelIndex(ch, config.getChannelByChannelIndex(ch));
        }
    }

    private final Config $$robo$$android_media_audiofx_DynamicsProcessing$getConfig() {
        Number[] params = new Number[]{48};
        Number[] values = new Number[]{0, Float.valueOf(0.0f), 0, 0, 0, 0, 0, 0, 0};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        Config.Builder builder = new Config.Builder(values[0].intValue(), this.mChannelCount, values[2].intValue() > 0, values[3].intValue(), values[4].intValue() > 0, values[5].intValue(), values[6].intValue() > 0, values[7].intValue(), values[8].intValue() > 0).setPreferredFrameDuration(values[1].floatValue());
        Config config = builder.build();
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            Channel channel = this.queryEngineByChannelIndex(ch);
            config.setChannelTo(ch, channel);
        }
        return config;
    }

    private final Channel $$robo$$android_media_audiofx_DynamicsProcessing$getChannelByChannelIndex(int channelIndex) {
        return this.queryEngineByChannelIndex(channelIndex);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setChannelTo(int channelIndex, Channel channel) {
        this.updateEngineChannelByChannelIndex(channelIndex, channel);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setAllChannelsTo(Channel channel) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setChannelTo(ch, channel);
        }
    }

    private final float $$robo$$android_media_audiofx_DynamicsProcessing$getInputGainByChannelIndex(int channelIndex) {
        return this.getTwoFloat(32, channelIndex);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setInputGainbyChannel(int channelIndex, float inputGain) {
        this.setTwoFloat(32, channelIndex, inputGain);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setInputGainAllChannelsTo(float inputGain) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setInputGainbyChannel(ch, inputGain);
        }
    }

    private final Eq $$robo$$android_media_audiofx_DynamicsProcessing$getPreEqByChannelIndex(int channelIndex) {
        return this.queryEngineEqByChannelIndex(64, channelIndex);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqByChannelIndex(int channelIndex, Eq preEq) {
        this.updateEngineEqByChannelIndex(64, channelIndex, preEq);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqAllChannelsTo(Eq preEq) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPreEqByChannelIndex(ch, preEq);
        }
    }

    private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing$getPreEqBandByChannelIndex(int channelIndex, int band) {
        return this.queryEngineEqBandByChannelIndex(69, channelIndex, band);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqBandByChannelIndex(int channelIndex, int band, EqBand preEqBand) {
        this.updateEngineEqBandByChannelIndex(69, channelIndex, band, preEqBand);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqBandAllChannelsTo(int band, EqBand preEqBand) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPreEqBandByChannelIndex(ch, band, preEqBand);
        }
    }

    private final Mbc $$robo$$android_media_audiofx_DynamicsProcessing$getMbcByChannelIndex(int channelIndex) {
        return this.queryEngineMbcByChannelIndex(channelIndex);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setMbcByChannelIndex(int channelIndex, Mbc mbc) {
        this.updateEngineMbcByChannelIndex(channelIndex, mbc);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setMbcAllChannelsTo(Mbc mbc) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setMbcByChannelIndex(ch, mbc);
        }
    }

    private final MbcBand $$robo$$android_media_audiofx_DynamicsProcessing$getMbcBandByChannelIndex(int channelIndex, int band) {
        return this.queryEngineMbcBandByChannelIndex(channelIndex, band);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setMbcBandByChannelIndex(int channelIndex, int band, MbcBand mbcBand) {
        this.updateEngineMbcBandByChannelIndex(channelIndex, band, mbcBand);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setMbcBandAllChannelsTo(int band, MbcBand mbcBand) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setMbcBandByChannelIndex(ch, band, mbcBand);
        }
    }

    private final Eq $$robo$$android_media_audiofx_DynamicsProcessing$getPostEqByChannelIndex(int channelIndex) {
        return this.queryEngineEqByChannelIndex(96, channelIndex);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqByChannelIndex(int channelIndex, Eq postEq) {
        this.updateEngineEqByChannelIndex(96, channelIndex, postEq);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqAllChannelsTo(Eq postEq) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPostEqByChannelIndex(ch, postEq);
        }
    }

    private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing$getPostEqBandByChannelIndex(int channelIndex, int band) {
        return this.queryEngineEqBandByChannelIndex(101, channelIndex, band);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqBandByChannelIndex(int channelIndex, int band, EqBand postEqBand) {
        this.updateEngineEqBandByChannelIndex(101, channelIndex, band, postEqBand);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqBandAllChannelsTo(int band, EqBand postEqBand) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPostEqBandByChannelIndex(ch, band, postEqBand);
        }
    }

    private final Limiter $$robo$$android_media_audiofx_DynamicsProcessing$getLimiterByChannelIndex(int channelIndex) {
        return this.queryEngineLimiterByChannelIndex(channelIndex);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setLimiterByChannelIndex(int channelIndex, Limiter limiter) {
        this.updateEngineLimiterByChannelIndex(channelIndex, limiter);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setLimiterAllChannelsTo(Limiter limiter) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setLimiterByChannelIndex(ch, limiter);
        }
    }

    private final int $$robo$$android_media_audiofx_DynamicsProcessing$getChannelCount() {
        return this.getOneInt(16);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setEngineArchitecture(int variant, float preferredFrameDuration, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse) {
        Number[] params = new Number[]{48};
        Number[] values = new Number[]{variant, Float.valueOf(preferredFrameDuration), preEqInUse ? 1 : 0, preEqBandCount, mbcInUse ? 1 : 0, mbcBandCount, postEqInUse ? 1 : 0, postEqBandCount, limiterInUse ? 1 : 0};
        this.setNumberArray(params, values);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineEqBandByChannelIndex(int param, int channelIndex, int bandIndex, EqBand eqBand) {
        Number[] params = new Number[]{param, channelIndex, bandIndex};
        Number[] values = new Number[]{eqBand.isEnabled() ? 1 : 0, Float.valueOf(eqBand.getCutoffFrequency()), Float.valueOf(eqBand.getGain())};
        this.setNumberArray(params, values);
    }

    private final Eq $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineEqByChannelIndex(int param, int channelIndex) {
        Number[] params = new Number[]{param == 64 ? 64 : 96, channelIndex};
        Number[] values = new Number[]{0, 0, 0};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        int bandCount = values[2].intValue();
        Eq eq = new Eq(values[0].intValue() > 0, values[1].intValue() > 0, bandCount);
        for (int b = 0; b < bandCount; ++b) {
            EqBand eqBand = this.queryEngineEqBandByChannelIndex(param == 64 ? 69 : 101, channelIndex, b);
            eq.setBand(b, eqBand);
        }
        return eq;
    }

    private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineEqBandByChannelIndex(int param, int channelIndex, int bandIndex) {
        Number[] params = new Number[]{param, channelIndex, bandIndex};
        Number[] values = new Number[]{0, Float.valueOf(0.0f), Float.valueOf(0.0f)};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        return new EqBand(values[0].intValue() > 0, values[1].floatValue(), values[2].floatValue());
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineEqByChannelIndex(int param, int channelIndex, Eq eq) {
        int bandCount = eq.getBandCount();
        Number[] params = new Number[]{param, channelIndex};
        Number[] values = new Number[]{eq.isInUse() ? 1 : 0, eq.isEnabled() ? 1 : 0, bandCount};
        this.setNumberArray(params, values);
        for (int b = 0; b < bandCount; ++b) {
            EqBand eqBand = eq.getBand(b);
            this.updateEngineEqBandByChannelIndex(param == 64 ? 69 : 101, channelIndex, b, eqBand);
        }
    }

    private final Mbc $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineMbcByChannelIndex(int channelIndex) {
        Number[] params = new Number[]{80, channelIndex};
        Number[] values = new Number[]{0, 0, 0};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        int bandCount = values[2].intValue();
        Mbc mbc = new Mbc(values[0].intValue() > 0, values[1].intValue() > 0, bandCount);
        for (int b = 0; b < bandCount; ++b) {
            MbcBand mbcBand = this.queryEngineMbcBandByChannelIndex(channelIndex, b);
            mbc.setBand(b, mbcBand);
        }
        return mbc;
    }

    private final MbcBand $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineMbcBandByChannelIndex(int channelIndex, int bandIndex) {
        Number[] params = new Number[]{85, channelIndex, bandIndex};
        Number[] values = new Number[]{0, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        return new MbcBand(values[0].intValue() > 0, values[1].floatValue(), values[2].floatValue(), values[3].floatValue(), values[4].floatValue(), values[5].floatValue(), values[6].floatValue(), values[7].floatValue(), values[8].floatValue(), values[9].floatValue(), values[10].floatValue());
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineMbcBandByChannelIndex(int channelIndex, int bandIndex, MbcBand mbcBand) {
        Number[] params = new Number[]{85, channelIndex, bandIndex};
        Number[] values = new Number[]{mbcBand.isEnabled() ? 1 : 0, Float.valueOf(mbcBand.getCutoffFrequency()), Float.valueOf(mbcBand.getAttackTime()), Float.valueOf(mbcBand.getReleaseTime()), Float.valueOf(mbcBand.getRatio()), Float.valueOf(mbcBand.getThreshold()), Float.valueOf(mbcBand.getKneeWidth()), Float.valueOf(mbcBand.getNoiseGateThreshold()), Float.valueOf(mbcBand.getExpanderRatio()), Float.valueOf(mbcBand.getPreGain()), Float.valueOf(mbcBand.getPostGain())};
        this.setNumberArray(params, values);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineMbcByChannelIndex(int channelIndex, Mbc mbc) {
        int bandCount = mbc.getBandCount();
        Number[] params = new Number[]{80, channelIndex};
        Number[] values = new Number[]{mbc.isInUse() ? 1 : 0, mbc.isEnabled() ? 1 : 0, bandCount};
        this.setNumberArray(params, values);
        for (int b = 0; b < bandCount; ++b) {
            MbcBand mbcBand = mbc.getBand(b);
            this.updateEngineMbcBandByChannelIndex(channelIndex, b, mbcBand);
        }
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineLimiterByChannelIndex(int channelIndex, Limiter limiter) {
        Number[] params = new Number[]{112, channelIndex};
        Number[] values = new Number[]{limiter.isInUse() ? 1 : 0, limiter.isEnabled() ? 1 : 0, limiter.getLinkGroup(), Float.valueOf(limiter.getAttackTime()), Float.valueOf(limiter.getReleaseTime()), Float.valueOf(limiter.getRatio()), Float.valueOf(limiter.getThreshold()), Float.valueOf(limiter.getPostGain())};
        this.setNumberArray(params, values);
    }

    private final Limiter $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineLimiterByChannelIndex(int channelIndex) {
        Number[] params = new Number[]{112, channelIndex};
        Number[] values = new Number[]{0, 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        return new Limiter(values[0].intValue() > 0, values[1].intValue() > 0, values[2].intValue(), values[3].floatValue(), values[4].floatValue(), values[5].floatValue(), values[6].floatValue(), values[7].floatValue());
    }

    private final Channel $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineByChannelIndex(int channelIndex) {
        float inputGain = this.getTwoFloat(32, channelIndex);
        Eq preEq = this.queryEngineEqByChannelIndex(64, channelIndex);
        Mbc mbc = this.queryEngineMbcByChannelIndex(channelIndex);
        Eq postEq = this.queryEngineEqByChannelIndex(96, channelIndex);
        Limiter limiter = this.queryEngineLimiterByChannelIndex(channelIndex);
        Channel channel = new Channel(inputGain, preEq.isInUse(), preEq.getBandCount(), mbc.isInUse(), mbc.getBandCount(), postEq.isInUse(), postEq.getBandCount(), limiter.isInUse());
        channel.setInputGain(inputGain);
        channel.setPreEq(preEq);
        channel.setMbc(mbc);
        channel.setPostEq(postEq);
        channel.setLimiter(limiter);
        return channel;
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineChannelByChannelIndex(int channelIndex, Channel channel) {
        this.setTwoFloat(32, channelIndex, channel.getInputGain());
        Eq preEq = channel.getPreEq();
        this.updateEngineEqByChannelIndex(64, channelIndex, preEq);
        Mbc mbc = channel.getMbc();
        this.updateEngineMbcByChannelIndex(channelIndex, mbc);
        Eq postEq = channel.getPostEq();
        this.updateEngineEqByChannelIndex(96, channelIndex, postEq);
        Limiter limiter = channel.getLimiter();
        this.updateEngineLimiterByChannelIndex(channelIndex, limiter);
    }

    private final int $$robo$$android_media_audiofx_DynamicsProcessing$getOneInt(int param) {
        int[] params = new int[]{param};
        int[] result = new int[1];
        this.checkStatus(this.getParameter(params, result));
        return result[0];
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setTwoFloat(int param, int paramA, float valueSet) {
        int[] params = new int[]{param, paramA};
        byte[] value = DynamicsProcessing.floatToByteArray(valueSet);
        this.checkStatus(this.setParameter(params, value));
    }

    private final byte[] $$robo$$android_media_audiofx_DynamicsProcessing$numberArrayToByteArray(Number[] values) {
        int expectedBytes = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Integer) {
                expectedBytes += 4;
                continue;
            }
            if (values[i] instanceof Float) {
                expectedBytes += 4;
                continue;
            }
            throw new IllegalArgumentException("unknown value type " + values[i].getClass());
        }
        ByteBuffer converter = ByteBuffer.allocate(expectedBytes);
        converter.order(ByteOrder.nativeOrder());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Integer) {
                converter.putInt(values[i].intValue());
                continue;
            }
            if (!(values[i] instanceof Float)) continue;
            converter.putFloat(values[i].floatValue());
        }
        return converter.array();
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$byteArrayToNumberArray(byte[] valuesIn, Number[] valuesOut) {
        int inIndex = 0;
        int outIndex = 0;
        while (inIndex < valuesIn.length && outIndex < valuesOut.length) {
            if (valuesOut[outIndex] instanceof Integer) {
                valuesOut[outIndex++] = DynamicsProcessing.byteArrayToInt(valuesIn, inIndex);
                inIndex += 4;
                continue;
            }
            if (valuesOut[outIndex] instanceof Float) {
                valuesOut[outIndex++] = Float.valueOf(DynamicsProcessing.byteArrayToFloat(valuesIn, inIndex));
                inIndex += 4;
                continue;
            }
            throw new IllegalArgumentException("can't convert " + valuesOut[outIndex].getClass());
        }
        if (outIndex != valuesOut.length) {
            throw new IllegalArgumentException("only converted " + outIndex + " values out of " + valuesOut.length + " expected");
        }
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setNumberArray(Number[] params, Number[] values) {
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.checkStatus(this.setParameter(paramBytes, valueBytes));
    }

    private final float $$robo$$android_media_audiofx_DynamicsProcessing$getTwoFloat(int param, int paramA) {
        int[] params = new int[]{param, paramA};
        byte[] result = new byte[4];
        this.checkStatus(this.getParameter(params, result));
        return DynamicsProcessing.byteArrayToFloat(result);
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$updateEffectArchitecture() {
        this.mChannelCount = this.getChannelCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mBaseParamListener = new BaseParameterListener(this, null);
                super.setParameterListener(this.mBaseParamListener);
            }
            this.mParamListener = listener;
        }
    }

    private final Settings $$robo$$android_media_audiofx_DynamicsProcessing$getProperties() {
        Settings settings = new Settings();
        settings.channelCount = this.getChannelCount();
        if (settings.channelCount > 32) {
            throw new IllegalArgumentException("too many channels Settings:" + settings);
        }
        settings.inputGain = new float[settings.channelCount];
        for (int ch = 0; ch < settings.channelCount; ++ch) {
        }
        return settings;
    }

    private final void $$robo$$android_media_audiofx_DynamicsProcessing$setProperties(Settings settings) {
        if (settings.channelCount != settings.inputGain.length || settings.channelCount != this.mChannelCount) {
            throw new IllegalArgumentException("settings invalid channel count: " + settings.channelCount);
        }
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
        }
    }

    static void __staticInitializer__() {
        mMinFreqLog = (float)Math.log10(220.0);
        mMaxFreqLog = (float)Math.log10(20000.0);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(n);
    }

    public DynamicsProcessing(int n) {
        this(0, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(int ), this, n);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(n, n2);
    }

    public DynamicsProcessing(int n, int n2) {
        this(n, n2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(int int ), this, n, n2);
    }

    private void __constructor__(int n, int n2, Config config) {
        this.$$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(n, n2, config);
    }

    public DynamicsProcessing(int n, int n2, Config config) {
        super(EFFECT_TYPE_DYNAMICS_PROCESSING, EFFECT_TYPE_NULL, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing$__constructor__(int int android.media.audiofx.DynamicsProcessing$Config ), this, n, n2, config);
    }

    public Config getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_media_audiofx_DynamicsProcessing$getConfig(), this);
    }

    public Channel getChannelByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getChannelByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getChannelByChannelIndex(int ), this, n);
    }

    public void setChannelTo(int n, Channel channel) {
        InvokeDynamicSupport.bootstrap("setChannelTo", $$robo$$android_media_audiofx_DynamicsProcessing$setChannelTo(int android.media.audiofx.DynamicsProcessing$Channel ), this, n, channel);
    }

    public void setAllChannelsTo(Channel channel) {
        InvokeDynamicSupport.bootstrap("setAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setAllChannelsTo(android.media.audiofx.DynamicsProcessing$Channel ), this, channel);
    }

    public float getInputGainByChannelIndex(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getInputGainByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getInputGainByChannelIndex(int ), this, n);
    }

    public void setInputGainbyChannel(int n, float f) {
        InvokeDynamicSupport.bootstrap("setInputGainbyChannel", $$robo$$android_media_audiofx_DynamicsProcessing$setInputGainbyChannel(int float ), this, n, f);
    }

    public void setInputGainAllChannelsTo(float f) {
        InvokeDynamicSupport.bootstrap("setInputGainAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setInputGainAllChannelsTo(float ), this, f);
    }

    public Eq getPreEqByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getPreEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getPreEqByChannelIndex(int ), this, n);
    }

    public void setPreEqByChannelIndex(int n, Eq eq) {
        InvokeDynamicSupport.bootstrap("setPreEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqByChannelIndex(int android.media.audiofx.DynamicsProcessing$Eq ), this, n, eq);
    }

    public void setPreEqAllChannelsTo(Eq eq) {
        InvokeDynamicSupport.bootstrap("setPreEqAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqAllChannelsTo(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
    }

    public EqBand getPreEqBandByChannelIndex(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPreEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getPreEqBandByChannelIndex(int int ), this, n, n2);
    }

    public void setPreEqBandByChannelIndex(int n, int n2, EqBand eqBand) {
        InvokeDynamicSupport.bootstrap("setPreEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, n2, eqBand);
    }

    public void setPreEqBandAllChannelsTo(int n, EqBand eqBand) {
        InvokeDynamicSupport.bootstrap("setPreEqBandAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setPreEqBandAllChannelsTo(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
    }

    public Mbc getMbcByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getMbcByChannelIndex(int ), this, n);
    }

    public void setMbcByChannelIndex(int n, Mbc mbc) {
        InvokeDynamicSupport.bootstrap("setMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setMbcByChannelIndex(int android.media.audiofx.DynamicsProcessing$Mbc ), this, n, mbc);
    }

    public void setMbcAllChannelsTo(Mbc mbc) {
        InvokeDynamicSupport.bootstrap("setMbcAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setMbcAllChannelsTo(android.media.audiofx.DynamicsProcessing$Mbc ), this, mbc);
    }

    public MbcBand getMbcBandByChannelIndex(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getMbcBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getMbcBandByChannelIndex(int int ), this, n, n2);
    }

    public void setMbcBandByChannelIndex(int n, int n2, MbcBand mbcBand) {
        InvokeDynamicSupport.bootstrap("setMbcBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setMbcBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, n2, mbcBand);
    }

    public void setMbcBandAllChannelsTo(int n, MbcBand mbcBand) {
        InvokeDynamicSupport.bootstrap("setMbcBandAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setMbcBandAllChannelsTo(int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, mbcBand);
    }

    public Eq getPostEqByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getPostEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getPostEqByChannelIndex(int ), this, n);
    }

    public void setPostEqByChannelIndex(int n, Eq eq) {
        InvokeDynamicSupport.bootstrap("setPostEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqByChannelIndex(int android.media.audiofx.DynamicsProcessing$Eq ), this, n, eq);
    }

    public void setPostEqAllChannelsTo(Eq eq) {
        InvokeDynamicSupport.bootstrap("setPostEqAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqAllChannelsTo(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
    }

    public EqBand getPostEqBandByChannelIndex(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPostEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getPostEqBandByChannelIndex(int int ), this, n, n2);
    }

    public void setPostEqBandByChannelIndex(int n, int n2, EqBand eqBand) {
        InvokeDynamicSupport.bootstrap("setPostEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, n2, eqBand);
    }

    public void setPostEqBandAllChannelsTo(int n, EqBand eqBand) {
        InvokeDynamicSupport.bootstrap("setPostEqBandAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setPostEqBandAllChannelsTo(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
    }

    public Limiter getLimiterByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$getLimiterByChannelIndex(int ), this, n);
    }

    public void setLimiterByChannelIndex(int n, Limiter limiter) {
        InvokeDynamicSupport.bootstrap("setLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$setLimiterByChannelIndex(int android.media.audiofx.DynamicsProcessing$Limiter ), this, n, limiter);
    }

    public void setLimiterAllChannelsTo(Limiter limiter) {
        InvokeDynamicSupport.bootstrap("setLimiterAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing$setLimiterAllChannelsTo(android.media.audiofx.DynamicsProcessing$Limiter ), this, limiter);
    }

    public int getChannelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelCount", $$robo$$android_media_audiofx_DynamicsProcessing$getChannelCount(), this);
    }

    private void setEngineArchitecture(int n, float f, boolean bl, int n2, boolean bl2, int n3, boolean bl3, int n4, boolean bl4) {
        InvokeDynamicSupport.bootstrap("setEngineArchitecture", $$robo$$android_media_audiofx_DynamicsProcessing$setEngineArchitecture(int float boolean int boolean int boolean int boolean ), this, n, f, bl, n2, bl2, n3, bl3, n4, bl4);
    }

    private void updateEngineEqBandByChannelIndex(int n, int n2, int n3, EqBand eqBand) {
        InvokeDynamicSupport.bootstrap("updateEngineEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineEqBandByChannelIndex(int int int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, n2, n3, eqBand);
    }

    private Eq queryEngineEqByChannelIndex(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryEngineEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineEqByChannelIndex(int int ), this, n, n2);
    }

    private EqBand queryEngineEqBandByChannelIndex(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("queryEngineEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineEqBandByChannelIndex(int int int ), this, n, n2, n3);
    }

    private void updateEngineEqByChannelIndex(int n, int n2, Eq eq) {
        InvokeDynamicSupport.bootstrap("updateEngineEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineEqByChannelIndex(int int android.media.audiofx.DynamicsProcessing$Eq ), this, n, n2, eq);
    }

    private Mbc queryEngineMbcByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("queryEngineMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineMbcByChannelIndex(int ), this, n);
    }

    private MbcBand queryEngineMbcBandByChannelIndex(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("queryEngineMbcBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineMbcBandByChannelIndex(int int ), this, n, n2);
    }

    private void updateEngineMbcBandByChannelIndex(int n, int n2, MbcBand mbcBand) {
        InvokeDynamicSupport.bootstrap("updateEngineMbcBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineMbcBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, n2, mbcBand);
    }

    private void updateEngineMbcByChannelIndex(int n, Mbc mbc) {
        InvokeDynamicSupport.bootstrap("updateEngineMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineMbcByChannelIndex(int android.media.audiofx.DynamicsProcessing$Mbc ), this, n, mbc);
    }

    private void updateEngineLimiterByChannelIndex(int n, Limiter limiter) {
        InvokeDynamicSupport.bootstrap("updateEngineLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineLimiterByChannelIndex(int android.media.audiofx.DynamicsProcessing$Limiter ), this, n, limiter);
    }

    private Limiter queryEngineLimiterByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("queryEngineLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineLimiterByChannelIndex(int ), this, n);
    }

    private Channel queryEngineByChannelIndex(int n) {
        return InvokeDynamicSupport.bootstrap("queryEngineByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$queryEngineByChannelIndex(int ), this, n);
    }

    private void updateEngineChannelByChannelIndex(int n, Channel channel) {
        InvokeDynamicSupport.bootstrap("updateEngineChannelByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing$updateEngineChannelByChannelIndex(int android.media.audiofx.DynamicsProcessing$Channel ), this, n, channel);
    }

    private int getOneInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOneInt", $$robo$$android_media_audiofx_DynamicsProcessing$getOneInt(int ), this, n);
    }

    private void setTwoFloat(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("setTwoFloat", $$robo$$android_media_audiofx_DynamicsProcessing$setTwoFloat(int int float ), this, n, n2, f);
    }

    private byte[] numberArrayToByteArray(Number[] numberArray) {
        return InvokeDynamicSupport.bootstrap("numberArrayToByteArray", $$robo$$android_media_audiofx_DynamicsProcessing$numberArrayToByteArray(java.lang.Number[] ), this, numberArray);
    }

    private void byteArrayToNumberArray(byte[] byArray, Number[] numberArray) {
        InvokeDynamicSupport.bootstrap("byteArrayToNumberArray", $$robo$$android_media_audiofx_DynamicsProcessing$byteArrayToNumberArray(byte[] java.lang.Number[] ), this, byArray, numberArray);
    }

    private void setNumberArray(Number[] numberArray, Number[] numberArray2) {
        InvokeDynamicSupport.bootstrap("setNumberArray", $$robo$$android_media_audiofx_DynamicsProcessing$setNumberArray(java.lang.Number[] java.lang.Number[] ), this, numberArray, numberArray2);
    }

    private float getTwoFloat(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getTwoFloat", $$robo$$android_media_audiofx_DynamicsProcessing$getTwoFloat(int int ), this, n, n2);
    }

    private void updateEffectArchitecture() {
        InvokeDynamicSupport.bootstrap("updateEffectArchitecture", $$robo$$android_media_audiofx_DynamicsProcessing$updateEffectArchitecture(), this);
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        InvokeDynamicSupport.bootstrap("setParameterListener", $$robo$$android_media_audiofx_DynamicsProcessing$setParameterListener(android.media.audiofx.DynamicsProcessing$OnParameterChangeListener ), this, onParameterChangeListener);
    }

    public Settings getProperties() {
        return InvokeDynamicSupport.bootstrap("getProperties", $$robo$$android_media_audiofx_DynamicsProcessing$getProperties(), this);
    }

    public void setProperties(Settings settings) {
        InvokeDynamicSupport.bootstrap("setProperties", $$robo$$android_media_audiofx_DynamicsProcessing$setProperties(android.media.audiofx.DynamicsProcessing$Settings ), this, settings);
    }

    static {
        RobolectricInternals.classInitializing(DynamicsProcessing.class);
    }

    public /* synthetic */ DynamicsProcessing() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DynamicsProcessing)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Settings
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int channelCount;
        public float[] inputGain;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Settings$__constructor__() {
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Settings$__constructor__(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals("DynamicsProcessing")) {
                throw new IllegalArgumentException("invalid settings for DynamicsProcessing: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("channelCount")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.channelCount = Short.parseShort(st.nextToken());
                if (this.channelCount > 32) {
                    throw new IllegalArgumentException("too many channels Settings:" + settings);
                }
                if (st.countTokens() != this.channelCount * 1) {
                    throw new IllegalArgumentException("settings: " + settings);
                }
                this.inputGain = new float[this.channelCount];
                for (int ch = 0; ch < this.channelCount; ++ch) {
                    key = st.nextToken();
                    if (!key.equals(ch + "_inputGain")) {
                        throw new IllegalArgumentException("invalid key name: " + key);
                    }
                    this.inputGain[ch] = Float.parseFloat(st.nextToken());
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Settings$toString() {
            String str = new String("DynamicsProcessing;channelCount=" + Integer.toString(this.channelCount));
            for (int ch = 0; ch < this.channelCount; ++ch) {
                str = str.concat(";" + ch + "_inputGain=" + Float.toString(this.inputGain[ch]));
            }
            return str;
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Settings$__constructor__();
        }

        public Settings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Settings$__constructor__(), this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Settings$__constructor__(string2);
        }

        public Settings(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Settings$__constructor__(java.lang.String ), this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Settings$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Settings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DynamicsProcessing this$0;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$__constructor__(DynamicsProcessing dynamicsProcessing) {
            this.this$0 = dynamicsProcessing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            if (status != 0) {
                return;
            }
            OnParameterChangeListener l = null;
            Object object = this.this$0.mParamListenerLock;
            synchronized (object) {
                if (this.this$0.mParamListener != null) {
                    l = this.this$0.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                int v = Integer.MIN_VALUE;
                if (param.length == 4) {
                    p = AudioEffect.byteArrayToInt(param, 0);
                }
                if (value.length == 4) {
                    v = AudioEffect.byteArrayToInt(value, 0);
                }
                if (p != -1 && v != Integer.MIN_VALUE) {
                    l.onParameterChange(this.this$0, p, v);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$__constructor__(DynamicsProcessing x0, 1 x1) {
        }

        private void __constructor__(DynamicsProcessing dynamicsProcessing) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$__constructor__(dynamicsProcessing);
        }

        public BaseParameterListener(DynamicsProcessing dynamicsProcessing) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$__constructor__(android.media.audiofx.DynamicsProcessing ), this, dynamicsProcessing);
        }

        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            InvokeDynamicSupport.bootstrap("onParameterChange", $$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$onParameterChange(android.media.audiofx.AudioEffect int byte[] byte[] ), this, audioEffect, n, byArray, byArray2);
        }

        private /* synthetic */ void __constructor__(DynamicsProcessing dynamicsProcessing, 1 var2_2) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$__constructor__(dynamicsProcessing, var2_2);
        }

        public /* synthetic */ BaseParameterListener(DynamicsProcessing dynamicsProcessing, 1 var2_2) {
            this(dynamicsProcessing);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_BaseParameterListener$__constructor__(android.media.audiofx.DynamicsProcessing android.media.audiofx.DynamicsProcessing$1 ), this, dynamicsProcessing, var2_2);
        }

        public /* synthetic */ BaseParameterListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseParameterListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(DynamicsProcessing var1, int var2, int var3);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Config
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mVariant;
        private int mChannelCount;
        private boolean mPreEqInUse;
        private int mPreEqBandCount;
        private boolean mMbcInUse;
        private int mMbcBandCount;
        private boolean mPostEqInUse;
        private int mPostEqBandCount;
        private boolean mLimiterInUse;
        private float mPreferredFrameDuration;
        private Channel[] mChannel;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(int variant, float frameDurationMs, int channelCount, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse, Channel[] channel) {
            this.mVariant = variant;
            this.mPreferredFrameDuration = frameDurationMs;
            this.mChannelCount = channelCount;
            this.mPreEqInUse = preEqInUse;
            this.mPreEqBandCount = preEqBandCount;
            this.mMbcInUse = mbcInUse;
            this.mMbcBandCount = mbcBandCount;
            this.mPostEqInUse = postEqInUse;
            this.mPostEqBandCount = postEqBandCount;
            this.mLimiterInUse = limiterInUse;
            this.mChannel = new Channel[this.mChannelCount];
            for (int ch = 0; ch < this.mChannelCount; ++ch) {
                if (ch >= channel.length) continue;
                this.mChannel[ch] = new Channel(channel[ch]);
            }
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(int channelCount, Config cfg) {
            this.mVariant = cfg.mVariant;
            this.mPreferredFrameDuration = cfg.mPreferredFrameDuration;
            this.mChannelCount = cfg.mChannelCount;
            this.mPreEqInUse = cfg.mPreEqInUse;
            this.mPreEqBandCount = cfg.mPreEqBandCount;
            this.mMbcInUse = cfg.mMbcInUse;
            this.mMbcBandCount = cfg.mMbcBandCount;
            this.mPostEqInUse = cfg.mPostEqInUse;
            this.mPostEqBandCount = cfg.mPostEqBandCount;
            this.mLimiterInUse = cfg.mLimiterInUse;
            if (this.mChannelCount != cfg.mChannel.length) {
                throw new IllegalArgumentException("configuration channel counts differ " + this.mChannelCount + " !=" + cfg.mChannel.length);
            }
            if (channelCount < 1) {
                throw new IllegalArgumentException("channel resizing less than 1 not allowed");
            }
            this.mChannel = new Channel[channelCount];
            for (int ch = 0; ch < channelCount; ++ch) {
                this.mChannel[ch] = ch < this.mChannelCount ? new Channel(cfg.mChannel[ch]) : new Channel(cfg.mChannel[this.mChannelCount - 1]);
            }
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(Config cfg) {
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Config$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Variant: %d\n", this.mVariant));
            sb.append(String.format("PreferredFrameDuration: %f\n", Float.valueOf(this.mPreferredFrameDuration)));
            sb.append(String.format("ChannelCount: %d\n", this.mChannelCount));
            sb.append(String.format("PreEq inUse: %b, bandCount:%d\n", this.mPreEqInUse, this.mPreEqBandCount));
            sb.append(String.format("Mbc inUse: %b, bandCount: %d\n", this.mMbcInUse, this.mMbcBandCount));
            sb.append(String.format("PostEq inUse: %b, bandCount: %d\n", this.mPostEqInUse, this.mPostEqBandCount));
            sb.append(String.format("Limiter inUse: %b\n", this.mLimiterInUse));
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                sb.append(String.format("==Channel %d\n", ch));
                sb.append(this.mChannel[ch].toString());
            }
            return sb.toString();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$checkChannel(int channelIndex) {
            if (channelIndex < 0 || channelIndex >= this.mChannel.length) {
                throw new IllegalArgumentException("ChannelIndex out of bounds");
            }
        }

        private final int $$robo$$android_media_audiofx_DynamicsProcessing_Config$getVariant() {
            return this.mVariant;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreferredFrameDuration() {
            return this.mPreferredFrameDuration;
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_Config$isPreEqInUse() {
            return this.mPreEqInUse;
        }

        private final int $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreEqBandCount() {
            return this.mPreEqBandCount;
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_Config$isMbcInUse() {
            return this.mMbcInUse;
        }

        private final int $$robo$$android_media_audiofx_DynamicsProcessing_Config$getMbcBandCount() {
            return this.mMbcBandCount;
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_Config$isPostEqInUse() {
            return this.mPostEqInUse;
        }

        private final int $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPostEqBandCount() {
            return this.mPostEqBandCount;
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_Config$isLimiterInUse() {
            return this.mLimiterInUse;
        }

        private final Channel $$robo$$android_media_audiofx_DynamicsProcessing_Config$getChannelByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex];
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setChannelTo(int channelIndex, Channel channel) {
            this.checkChannel(channelIndex);
            if (this.mMbcBandCount != channel.getMbc().getBandCount()) {
                throw new IllegalArgumentException("MbcBandCount changed from " + this.mMbcBandCount + " to " + channel.getPreEq().getBandCount());
            }
            if (this.mPreEqBandCount != channel.getPreEq().getBandCount()) {
                throw new IllegalArgumentException("PreEqBandCount changed from " + this.mPreEqBandCount + " to " + channel.getPreEq().getBandCount());
            }
            if (this.mPostEqBandCount != channel.getPostEq().getBandCount()) {
                throw new IllegalArgumentException("PostEqBandCount changed from " + this.mPostEqBandCount + " to " + channel.getPostEq().getBandCount());
            }
            this.mChannel[channelIndex] = new Channel(channel);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setAllChannelsTo(Channel channel) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.setChannelTo(ch, channel);
            }
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Config$getInputGainByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getInputGain();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setInputGainByChannelIndex(int channelIndex, float inputGain) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setInputGain(inputGain);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setInputGainAllChannelsTo(float inputGain) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setInputGain(inputGain);
            }
        }

        private final Eq $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreEqByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPreEq();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqByChannelIndex(int channelIndex, Eq preEq) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPreEq(preEq);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqAllChannelsTo(Eq preEq) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPreEq(preEq);
            }
        }

        private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreEqBandByChannelIndex(int channelIndex, int band) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPreEqBand(band);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqBandByChannelIndex(int channelIndex, int band, EqBand preEqBand) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPreEqBand(band, preEqBand);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqBandAllChannelsTo(int band, EqBand preEqBand) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPreEqBand(band, preEqBand);
            }
        }

        private final Mbc $$robo$$android_media_audiofx_DynamicsProcessing_Config$getMbcByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getMbc();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcByChannelIndex(int channelIndex, Mbc mbc) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setMbc(mbc);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcAllChannelsTo(Mbc mbc) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setMbc(mbc);
            }
        }

        private final MbcBand $$robo$$android_media_audiofx_DynamicsProcessing_Config$getMbcBandByChannelIndex(int channelIndex, int band) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getMbcBand(band);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcBandByChannelIndex(int channelIndex, int band, MbcBand mbcBand) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setMbcBand(band, mbcBand);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcBandAllChannelsTo(int band, MbcBand mbcBand) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setMbcBand(band, mbcBand);
            }
        }

        private final Eq $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPostEqByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPostEq();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqByChannelIndex(int channelIndex, Eq postEq) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPostEq(postEq);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqAllChannelsTo(Eq postEq) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPostEq(postEq);
            }
        }

        private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPostEqBandByChannelIndex(int channelIndex, int band) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPostEqBand(band);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqBandByChannelIndex(int channelIndex, int band, EqBand postEqBand) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPostEqBand(band, postEqBand);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqBandAllChannelsTo(int band, EqBand postEqBand) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPostEqBand(band, postEqBand);
            }
        }

        private final Limiter $$robo$$android_media_audiofx_DynamicsProcessing_Config$getLimiterByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getLimiter();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setLimiterByChannelIndex(int channelIndex, Limiter limiter) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setLimiter(limiter);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config$setLimiterAllChannelsTo(Limiter limiter) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setLimiter(limiter);
            }
        }

        private void __constructor__(int n, float f, int n2, boolean bl, int n3, boolean bl2, int n4, boolean bl3, int n5, boolean bl4, Channel[] channelArray) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(n, f, n2, bl, n3, bl2, n4, bl3, n5, bl4, channelArray);
        }

        public Config(int n, float f, int n2, boolean bl, int n3, boolean bl2, int n4, boolean bl3, int n5, boolean bl4, Channel[] channelArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(int float int boolean int boolean int boolean int boolean android.media.audiofx.DynamicsProcessing$Channel[] ), this, n, f, n2, bl, n3, bl2, n4, bl3, n5, bl4, channelArray);
        }

        private void __constructor__(int n, Config config) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(n, config);
        }

        public Config(int n, Config config) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(int android.media.audiofx.DynamicsProcessing$Config ), this, n, config);
        }

        private void __constructor__(Config config) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(config);
        }

        public Config(Config config) {
            this(config.mChannelCount, config);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Config$__constructor__(android.media.audiofx.DynamicsProcessing$Config ), this, config);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Config$toString(), this);
        }

        private void checkChannel(int n) {
            InvokeDynamicSupport.bootstrap("checkChannel", $$robo$$android_media_audiofx_DynamicsProcessing_Config$checkChannel(int ), this, n);
        }

        public int getVariant() {
            return (int)InvokeDynamicSupport.bootstrap("getVariant", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getVariant(), this);
        }

        public float getPreferredFrameDuration() {
            return (float)InvokeDynamicSupport.bootstrap("getPreferredFrameDuration", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreferredFrameDuration(), this);
        }

        public boolean isPreEqInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPreEqInUse", $$robo$$android_media_audiofx_DynamicsProcessing_Config$isPreEqInUse(), this);
        }

        public int getPreEqBandCount() {
            return (int)InvokeDynamicSupport.bootstrap("getPreEqBandCount", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreEqBandCount(), this);
        }

        public boolean isMbcInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMbcInUse", $$robo$$android_media_audiofx_DynamicsProcessing_Config$isMbcInUse(), this);
        }

        public int getMbcBandCount() {
            return (int)InvokeDynamicSupport.bootstrap("getMbcBandCount", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getMbcBandCount(), this);
        }

        public boolean isPostEqInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPostEqInUse", $$robo$$android_media_audiofx_DynamicsProcessing_Config$isPostEqInUse(), this);
        }

        public int getPostEqBandCount() {
            return (int)InvokeDynamicSupport.bootstrap("getPostEqBandCount", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPostEqBandCount(), this);
        }

        public boolean isLimiterInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLimiterInUse", $$robo$$android_media_audiofx_DynamicsProcessing_Config$isLimiterInUse(), this);
        }

        public Channel getChannelByChannelIndex(int n) {
            return InvokeDynamicSupport.bootstrap("getChannelByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getChannelByChannelIndex(int ), this, n);
        }

        public void setChannelTo(int n, Channel channel) {
            InvokeDynamicSupport.bootstrap("setChannelTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setChannelTo(int android.media.audiofx.DynamicsProcessing$Channel ), this, n, channel);
        }

        public void setAllChannelsTo(Channel channel) {
            InvokeDynamicSupport.bootstrap("setAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setAllChannelsTo(android.media.audiofx.DynamicsProcessing$Channel ), this, channel);
        }

        public float getInputGainByChannelIndex(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getInputGainByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getInputGainByChannelIndex(int ), this, n);
        }

        public void setInputGainByChannelIndex(int n, float f) {
            InvokeDynamicSupport.bootstrap("setInputGainByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setInputGainByChannelIndex(int float ), this, n, f);
        }

        public void setInputGainAllChannelsTo(float f) {
            InvokeDynamicSupport.bootstrap("setInputGainAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setInputGainAllChannelsTo(float ), this, f);
        }

        public Eq getPreEqByChannelIndex(int n) {
            return InvokeDynamicSupport.bootstrap("getPreEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreEqByChannelIndex(int ), this, n);
        }

        public void setPreEqByChannelIndex(int n, Eq eq) {
            InvokeDynamicSupport.bootstrap("setPreEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqByChannelIndex(int android.media.audiofx.DynamicsProcessing$Eq ), this, n, eq);
        }

        public void setPreEqAllChannelsTo(Eq eq) {
            InvokeDynamicSupport.bootstrap("setPreEqAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqAllChannelsTo(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
        }

        public EqBand getPreEqBandByChannelIndex(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getPreEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPreEqBandByChannelIndex(int int ), this, n, n2);
        }

        public void setPreEqBandByChannelIndex(int n, int n2, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setPreEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, n2, eqBand);
        }

        public void setPreEqBandAllChannelsTo(int n, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setPreEqBandAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPreEqBandAllChannelsTo(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
        }

        public Mbc getMbcByChannelIndex(int n) {
            return InvokeDynamicSupport.bootstrap("getMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getMbcByChannelIndex(int ), this, n);
        }

        public void setMbcByChannelIndex(int n, Mbc mbc) {
            InvokeDynamicSupport.bootstrap("setMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcByChannelIndex(int android.media.audiofx.DynamicsProcessing$Mbc ), this, n, mbc);
        }

        public void setMbcAllChannelsTo(Mbc mbc) {
            InvokeDynamicSupport.bootstrap("setMbcAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcAllChannelsTo(android.media.audiofx.DynamicsProcessing$Mbc ), this, mbc);
        }

        public MbcBand getMbcBandByChannelIndex(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getMbcBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getMbcBandByChannelIndex(int int ), this, n, n2);
        }

        public void setMbcBandByChannelIndex(int n, int n2, MbcBand mbcBand) {
            InvokeDynamicSupport.bootstrap("setMbcBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, n2, mbcBand);
        }

        public void setMbcBandAllChannelsTo(int n, MbcBand mbcBand) {
            InvokeDynamicSupport.bootstrap("setMbcBandAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setMbcBandAllChannelsTo(int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, mbcBand);
        }

        public Eq getPostEqByChannelIndex(int n) {
            return InvokeDynamicSupport.bootstrap("getPostEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPostEqByChannelIndex(int ), this, n);
        }

        public void setPostEqByChannelIndex(int n, Eq eq) {
            InvokeDynamicSupport.bootstrap("setPostEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqByChannelIndex(int android.media.audiofx.DynamicsProcessing$Eq ), this, n, eq);
        }

        public void setPostEqAllChannelsTo(Eq eq) {
            InvokeDynamicSupport.bootstrap("setPostEqAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqAllChannelsTo(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
        }

        public EqBand getPostEqBandByChannelIndex(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getPostEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getPostEqBandByChannelIndex(int int ), this, n, n2);
        }

        public void setPostEqBandByChannelIndex(int n, int n2, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setPostEqBandByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqBandByChannelIndex(int int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, n2, eqBand);
        }

        public void setPostEqBandAllChannelsTo(int n, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setPostEqBandAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setPostEqBandAllChannelsTo(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
        }

        public Limiter getLimiterByChannelIndex(int n) {
            return InvokeDynamicSupport.bootstrap("getLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$getLimiterByChannelIndex(int ), this, n);
        }

        public void setLimiterByChannelIndex(int n, Limiter limiter) {
            InvokeDynamicSupport.bootstrap("setLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setLimiterByChannelIndex(int android.media.audiofx.DynamicsProcessing$Limiter ), this, n, limiter);
        }

        public void setLimiterAllChannelsTo(Limiter limiter) {
            InvokeDynamicSupport.bootstrap("setLimiterAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config$setLimiterAllChannelsTo(android.media.audiofx.DynamicsProcessing$Limiter ), this, limiter);
        }

        public /* synthetic */ Config() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Config)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mVariant;
            private int mChannelCount;
            private boolean mPreEqInUse;
            private int mPreEqBandCount;
            private boolean mMbcInUse;
            private int mMbcBandCount;
            private boolean mPostEqInUse;
            private int mPostEqBandCount;
            private boolean mLimiterInUse;
            private float mPreferredFrameDuration;
            private Channel[] mChannel;

            private void $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$__constructor__(int variant, int channelCount, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse) {
                this.mPreferredFrameDuration = 10.0f;
                this.mVariant = variant;
                this.mChannelCount = channelCount;
                this.mPreEqInUse = preEqInUse;
                this.mPreEqBandCount = preEqBandCount;
                this.mMbcInUse = mbcInUse;
                this.mMbcBandCount = mbcBandCount;
                this.mPostEqInUse = postEqInUse;
                this.mPostEqBandCount = postEqBandCount;
                this.mLimiterInUse = limiterInUse;
                this.mChannel = new Channel[this.mChannelCount];
                for (int ch = 0; ch < this.mChannelCount; ++ch) {
                    this.mChannel[ch] = new Channel(0.0f, this.mPreEqInUse, this.mPreEqBandCount, this.mMbcInUse, this.mMbcBandCount, this.mPostEqInUse, this.mPostEqBandCount, this.mLimiterInUse);
                }
            }

            private final void $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$checkChannel(int channelIndex) {
                if (channelIndex < 0 || channelIndex >= this.mChannel.length) {
                    throw new IllegalArgumentException("ChannelIndex out of bounds");
                }
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPreferredFrameDuration(float frameDuration) {
                if (frameDuration < 0.0f) {
                    throw new IllegalArgumentException("Expected positive frameDuration");
                }
                this.mPreferredFrameDuration = frameDuration;
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setInputGainByChannelIndex(int channelIndex, float inputGain) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setInputGain(inputGain);
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setInputGainAllChannelsTo(float inputGain) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.mChannel[ch].setInputGain(inputGain);
                }
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setChannelTo(int channelIndex, Channel channel) {
                this.checkChannel(channelIndex);
                if (this.mMbcBandCount != channel.getMbc().getBandCount()) {
                    throw new IllegalArgumentException("MbcBandCount changed from " + this.mMbcBandCount + " to " + channel.getPreEq().getBandCount());
                }
                if (this.mPreEqBandCount != channel.getPreEq().getBandCount()) {
                    throw new IllegalArgumentException("PreEqBandCount changed from " + this.mPreEqBandCount + " to " + channel.getPreEq().getBandCount());
                }
                if (this.mPostEqBandCount != channel.getPostEq().getBandCount()) {
                    throw new IllegalArgumentException("PostEqBandCount changed from " + this.mPostEqBandCount + " to " + channel.getPostEq().getBandCount());
                }
                this.mChannel[channelIndex] = new Channel(channel);
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setAllChannelsTo(Channel channel) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setChannelTo(ch, channel);
                }
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPreEqByChannelIndex(int channelIndex, Eq preEq) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setPreEq(preEq);
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPreEqAllChannelsTo(Eq preEq) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setPreEqByChannelIndex(ch, preEq);
                }
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setMbcByChannelIndex(int channelIndex, Mbc mbc) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setMbc(mbc);
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setMbcAllChannelsTo(Mbc mbc) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setMbcByChannelIndex(ch, mbc);
                }
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPostEqByChannelIndex(int channelIndex, Eq postEq) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setPostEq(postEq);
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPostEqAllChannelsTo(Eq postEq) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setPostEqByChannelIndex(ch, postEq);
                }
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setLimiterByChannelIndex(int channelIndex, Limiter limiter) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setLimiter(limiter);
                return this;
            }

            private final Builder $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setLimiterAllChannelsTo(Limiter limiter) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setLimiterByChannelIndex(ch, limiter);
                }
                return this;
            }

            private final Config $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$build() {
                return new Config(this.mVariant, this.mPreferredFrameDuration, this.mChannelCount, this.mPreEqInUse, this.mPreEqBandCount, this.mMbcInUse, this.mMbcBandCount, this.mPostEqInUse, this.mPostEqBandCount, this.mLimiterInUse, this.mChannel);
            }

            private void __constructor__(int n, int n2, boolean bl, int n3, boolean bl2, int n4, boolean bl3, int n5, boolean bl4) {
                this.$$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$__constructor__(n, n2, bl, n3, bl2, n4, bl3, n5, bl4);
            }

            public Builder(int n, int n2, boolean bl, int n3, boolean bl2, int n4, boolean bl3, int n5, boolean bl4) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$__constructor__(int int boolean int boolean int boolean int boolean ), this, n, n2, bl, n3, bl2, n4, bl3, n5, bl4);
            }

            private void checkChannel(int n) {
                InvokeDynamicSupport.bootstrap("checkChannel", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$checkChannel(int ), this, n);
            }

            public Builder setPreferredFrameDuration(float f) {
                return InvokeDynamicSupport.bootstrap("setPreferredFrameDuration", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPreferredFrameDuration(float ), this, f);
            }

            public Builder setInputGainByChannelIndex(int n, float f) {
                return InvokeDynamicSupport.bootstrap("setInputGainByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setInputGainByChannelIndex(int float ), this, n, f);
            }

            public Builder setInputGainAllChannelsTo(float f) {
                return InvokeDynamicSupport.bootstrap("setInputGainAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setInputGainAllChannelsTo(float ), this, f);
            }

            public Builder setChannelTo(int n, Channel channel) {
                return InvokeDynamicSupport.bootstrap("setChannelTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setChannelTo(int android.media.audiofx.DynamicsProcessing$Channel ), this, n, channel);
            }

            public Builder setAllChannelsTo(Channel channel) {
                return InvokeDynamicSupport.bootstrap("setAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setAllChannelsTo(android.media.audiofx.DynamicsProcessing$Channel ), this, channel);
            }

            public Builder setPreEqByChannelIndex(int n, Eq eq) {
                return InvokeDynamicSupport.bootstrap("setPreEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPreEqByChannelIndex(int android.media.audiofx.DynamicsProcessing$Eq ), this, n, eq);
            }

            public Builder setPreEqAllChannelsTo(Eq eq) {
                return InvokeDynamicSupport.bootstrap("setPreEqAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPreEqAllChannelsTo(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
            }

            public Builder setMbcByChannelIndex(int n, Mbc mbc) {
                return InvokeDynamicSupport.bootstrap("setMbcByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setMbcByChannelIndex(int android.media.audiofx.DynamicsProcessing$Mbc ), this, n, mbc);
            }

            public Builder setMbcAllChannelsTo(Mbc mbc) {
                return InvokeDynamicSupport.bootstrap("setMbcAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setMbcAllChannelsTo(android.media.audiofx.DynamicsProcessing$Mbc ), this, mbc);
            }

            public Builder setPostEqByChannelIndex(int n, Eq eq) {
                return InvokeDynamicSupport.bootstrap("setPostEqByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPostEqByChannelIndex(int android.media.audiofx.DynamicsProcessing$Eq ), this, n, eq);
            }

            public Builder setPostEqAllChannelsTo(Eq eq) {
                return InvokeDynamicSupport.bootstrap("setPostEqAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setPostEqAllChannelsTo(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
            }

            public Builder setLimiterByChannelIndex(int n, Limiter limiter) {
                return InvokeDynamicSupport.bootstrap("setLimiterByChannelIndex", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setLimiterByChannelIndex(int android.media.audiofx.DynamicsProcessing$Limiter ), this, n, limiter);
            }

            public Builder setLimiterAllChannelsTo(Limiter limiter) {
                return InvokeDynamicSupport.bootstrap("setLimiterAllChannelsTo", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$setLimiterAllChannelsTo(android.media.audiofx.DynamicsProcessing$Limiter ), this, limiter);
            }

            public Config build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_audiofx_DynamicsProcessing_Config_Builder$build(), this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Channel
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private float mInputGain;
        private Eq mPreEq;
        private Mbc mMbc;
        private Eq mPostEq;
        private Limiter mLimiter;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$__constructor__(float inputGain, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse) {
            this.mInputGain = inputGain;
            this.mPreEq = new Eq(preEqInUse, true, preEqBandCount);
            this.mMbc = new Mbc(mbcInUse, true, mbcBandCount);
            this.mPostEq = new Eq(postEqInUse, true, postEqBandCount);
            this.mLimiter = new Limiter(limiterInUse, true, 0, 1.0f, 60.0f, 10.0f, -2.0f, 0.0f);
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$__constructor__(Channel cfg) {
            this.mInputGain = cfg.mInputGain;
            this.mPreEq = new Eq(cfg.mPreEq);
            this.mMbc = new Mbc(cfg.mMbc);
            this.mPostEq = new Eq(cfg.mPostEq);
            this.mLimiter = new Limiter(cfg.mLimiter);
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Channel$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" InputGain: %f\n", Float.valueOf(this.mInputGain)));
            sb.append("-->PreEq\n");
            sb.append(this.mPreEq.toString());
            sb.append("-->MBC\n");
            sb.append(this.mMbc.toString());
            sb.append("-->PostEq\n");
            sb.append(this.mPostEq.toString());
            sb.append("-->Limiter\n");
            sb.append(this.mLimiter.toString());
            return sb.toString();
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getInputGain() {
            return this.mInputGain;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setInputGain(float inputGain) {
            this.mInputGain = inputGain;
        }

        private final Eq $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPreEq() {
            return this.mPreEq;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPreEq(Eq preEq) {
            if (preEq.getBandCount() != this.mPreEq.getBandCount()) {
                throw new IllegalArgumentException("PreEqBandCount changed from " + this.mPreEq.getBandCount() + " to " + preEq.getBandCount());
            }
            this.mPreEq = new Eq(preEq);
        }

        private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPreEqBand(int band) {
            return this.mPreEq.getBand(band);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPreEqBand(int band, EqBand preEqBand) {
            this.mPreEq.setBand(band, preEqBand);
        }

        private final Mbc $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getMbc() {
            return this.mMbc;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setMbc(Mbc mbc) {
            if (mbc.getBandCount() != this.mMbc.getBandCount()) {
                throw new IllegalArgumentException("MbcBandCount changed from " + this.mMbc.getBandCount() + " to " + mbc.getBandCount());
            }
            this.mMbc = new Mbc(mbc);
        }

        private final MbcBand $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getMbcBand(int band) {
            return this.mMbc.getBand(band);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setMbcBand(int band, MbcBand mbcBand) {
            this.mMbc.setBand(band, mbcBand);
        }

        private final Eq $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPostEq() {
            return this.mPostEq;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPostEq(Eq postEq) {
            if (postEq.getBandCount() != this.mPostEq.getBandCount()) {
                throw new IllegalArgumentException("PostEqBandCount changed from " + this.mPostEq.getBandCount() + " to " + postEq.getBandCount());
            }
            this.mPostEq = new Eq(postEq);
        }

        private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPostEqBand(int band) {
            return this.mPostEq.getBand(band);
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPostEqBand(int band, EqBand postEqBand) {
            this.mPostEq.setBand(band, postEqBand);
        }

        private final Limiter $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getLimiter() {
            return this.mLimiter;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setLimiter(Limiter limiter) {
            this.mLimiter = new Limiter(limiter);
        }

        private void __constructor__(float f, boolean bl, int n, boolean bl2, int n2, boolean bl3, int n3, boolean bl4) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Channel$__constructor__(f, bl, n, bl2, n2, bl3, n3, bl4);
        }

        public Channel(float f, boolean bl, int n, boolean bl2, int n2, boolean bl3, int n3, boolean bl4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$__constructor__(float boolean int boolean int boolean int boolean ), this, f, bl, n, bl2, n2, bl3, n3, bl4);
        }

        private void __constructor__(Channel channel) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Channel$__constructor__(channel);
        }

        public Channel(Channel channel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$__constructor__(android.media.audiofx.DynamicsProcessing$Channel ), this, channel);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$toString(), this);
        }

        public float getInputGain() {
            return (float)InvokeDynamicSupport.bootstrap("getInputGain", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getInputGain(), this);
        }

        public void setInputGain(float f) {
            InvokeDynamicSupport.bootstrap("setInputGain", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setInputGain(float ), this, f);
        }

        public Eq getPreEq() {
            return InvokeDynamicSupport.bootstrap("getPreEq", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPreEq(), this);
        }

        public void setPreEq(Eq eq) {
            InvokeDynamicSupport.bootstrap("setPreEq", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPreEq(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
        }

        public EqBand getPreEqBand(int n) {
            return InvokeDynamicSupport.bootstrap("getPreEqBand", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPreEqBand(int ), this, n);
        }

        public void setPreEqBand(int n, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setPreEqBand", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPreEqBand(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
        }

        public Mbc getMbc() {
            return InvokeDynamicSupport.bootstrap("getMbc", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getMbc(), this);
        }

        public void setMbc(Mbc mbc) {
            InvokeDynamicSupport.bootstrap("setMbc", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setMbc(android.media.audiofx.DynamicsProcessing$Mbc ), this, mbc);
        }

        public MbcBand getMbcBand(int n) {
            return InvokeDynamicSupport.bootstrap("getMbcBand", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getMbcBand(int ), this, n);
        }

        public void setMbcBand(int n, MbcBand mbcBand) {
            InvokeDynamicSupport.bootstrap("setMbcBand", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setMbcBand(int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, mbcBand);
        }

        public Eq getPostEq() {
            return InvokeDynamicSupport.bootstrap("getPostEq", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPostEq(), this);
        }

        public void setPostEq(Eq eq) {
            InvokeDynamicSupport.bootstrap("setPostEq", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPostEq(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
        }

        public EqBand getPostEqBand(int n) {
            return InvokeDynamicSupport.bootstrap("getPostEqBand", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getPostEqBand(int ), this, n);
        }

        public void setPostEqBand(int n, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setPostEqBand", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setPostEqBand(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
        }

        public Limiter getLimiter() {
            return InvokeDynamicSupport.bootstrap("getLimiter", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$getLimiter(), this);
        }

        public void setLimiter(Limiter limiter) {
            InvokeDynamicSupport.bootstrap("setLimiter", $$robo$$android_media_audiofx_DynamicsProcessing_Channel$setLimiter(android.media.audiofx.DynamicsProcessing$Limiter ), this, limiter);
        }

        public /* synthetic */ Channel() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Channel)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Limiter
    extends Stage
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mLinkGroup;
        private float mAttackTime;
        private float mReleaseTime;
        private float mRatio;
        private float mThreshold;
        private float mPostGain;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$__constructor__(boolean inUse, boolean enabled, int linkGroup, float attackTime, float releaseTime, float ratio, float threshold, float postGain) {
            this.mLinkGroup = linkGroup;
            this.mAttackTime = attackTime;
            this.mReleaseTime = releaseTime;
            this.mRatio = ratio;
            this.mThreshold = threshold;
            this.mPostGain = postGain;
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$__constructor__(Limiter cfg) {
            this.mLinkGroup = cfg.mLinkGroup;
            this.mAttackTime = cfg.mAttackTime;
            this.mReleaseTime = cfg.mReleaseTime;
            this.mRatio = cfg.mRatio;
            this.mThreshold = cfg.mThreshold;
            this.mPostGain = cfg.mPostGain;
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append(String.format(" LinkGroup: %d (group)\n", this.mLinkGroup));
                sb.append(String.format(" AttackTime: %f (ms)\n", Float.valueOf(this.mAttackTime)));
                sb.append(String.format(" ReleaseTime: %f (ms)\n", Float.valueOf(this.mReleaseTime)));
                sb.append(String.format(" Ratio: 1:%f\n", Float.valueOf(this.mRatio)));
                sb.append(String.format(" Threshold: %f (dB)\n", Float.valueOf(this.mThreshold)));
                sb.append(String.format(" PostGain: %f (dB)\n", Float.valueOf(this.mPostGain)));
            }
            return sb.toString();
        }

        private final int $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getLinkGroup() {
            return this.mLinkGroup;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setLinkGroup(int linkGroup) {
            this.mLinkGroup = linkGroup;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getAttackTime() {
            return this.mAttackTime;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setAttackTime(float attackTime) {
            this.mAttackTime = attackTime;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getReleaseTime() {
            return this.mReleaseTime;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setReleaseTime(float releaseTime) {
            this.mReleaseTime = releaseTime;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getRatio() {
            return this.mRatio;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setRatio(float ratio) {
            this.mRatio = ratio;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getThreshold() {
            return this.mThreshold;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setThreshold(float threshold) {
            this.mThreshold = threshold;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getPostGain() {
            return this.mPostGain;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setPostGain(float postGain) {
            this.mPostGain = postGain;
        }

        private void __constructor__(boolean bl, boolean bl2, int n, float f, float f2, float f3, float f4, float f5) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Limiter$__constructor__(bl, bl2, n, f, f2, f3, f4, f5);
        }

        public Limiter(boolean bl, boolean bl2, int n, float f, float f2, float f3, float f4, float f5) {
            super(bl, bl2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$__constructor__(boolean boolean int float float float float float ), this, bl, bl2, n, f, f2, f3, f4, f5);
        }

        private void __constructor__(Limiter limiter) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Limiter$__constructor__(limiter);
        }

        public Limiter(Limiter limiter) {
            super(limiter.isInUse(), limiter.isEnabled());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$__constructor__(android.media.audiofx.DynamicsProcessing$Limiter ), this, limiter);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$toString(), this);
        }

        public int getLinkGroup() {
            return (int)InvokeDynamicSupport.bootstrap("getLinkGroup", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getLinkGroup(), this);
        }

        public void setLinkGroup(int n) {
            InvokeDynamicSupport.bootstrap("setLinkGroup", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setLinkGroup(int ), this, n);
        }

        public float getAttackTime() {
            return (float)InvokeDynamicSupport.bootstrap("getAttackTime", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getAttackTime(), this);
        }

        public void setAttackTime(float f) {
            InvokeDynamicSupport.bootstrap("setAttackTime", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setAttackTime(float ), this, f);
        }

        public float getReleaseTime() {
            return (float)InvokeDynamicSupport.bootstrap("getReleaseTime", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getReleaseTime(), this);
        }

        public void setReleaseTime(float f) {
            InvokeDynamicSupport.bootstrap("setReleaseTime", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setReleaseTime(float ), this, f);
        }

        public float getRatio() {
            return (float)InvokeDynamicSupport.bootstrap("getRatio", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getRatio(), this);
        }

        public void setRatio(float f) {
            InvokeDynamicSupport.bootstrap("setRatio", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setRatio(float ), this, f);
        }

        public float getThreshold() {
            return (float)InvokeDynamicSupport.bootstrap("getThreshold", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getThreshold(), this);
        }

        public void setThreshold(float f) {
            InvokeDynamicSupport.bootstrap("setThreshold", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setThreshold(float ), this, f);
        }

        public float getPostGain() {
            return (float)InvokeDynamicSupport.bootstrap("getPostGain", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$getPostGain(), this);
        }

        public void setPostGain(float f) {
            InvokeDynamicSupport.bootstrap("setPostGain", $$robo$$android_media_audiofx_DynamicsProcessing_Limiter$setPostGain(float ), this, f);
        }

        public /* synthetic */ Limiter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Limiter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Mbc
    extends BandStage
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private MbcBand[] mBands;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$__constructor__(boolean inUse, boolean enabled, int bandCount) {
            if (this.isInUse()) {
                this.mBands = new MbcBand[bandCount];
                for (int b = 0; b < bandCount; ++b) {
                    float freq = 20000.0f;
                    if (bandCount > 1) {
                        freq = (float)Math.pow(10.0, mMinFreqLog + (float)b * (mMaxFreqLog - mMinFreqLog) / (float)(bandCount - 1));
                    }
                    this.mBands[b] = new MbcBand(true, freq, 3.0f, 80.0f, 1.0f, -45.0f, 0.0f, -90.0f, 1.0f, 0.0f, 0.0f);
                }
            } else {
                this.mBands = null;
            }
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$__constructor__(Mbc cfg) {
            if (this.isInUse()) {
                this.mBands = new MbcBand[cfg.mBands.length];
                for (int b = 0; b < this.mBands.length; ++b) {
                    this.mBands[b] = new MbcBand(cfg.mBands[b]);
                }
            } else {
                this.mBands = null;
            }
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append("--->MbcBands: " + this.mBands.length + "\n");
                for (int b = 0; b < this.mBands.length; ++b) {
                    sb.append(String.format("  Band %d\n", b));
                    sb.append(this.mBands[b].toString());
                }
            }
            return sb.toString();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$checkBand(int band) {
            if (this.mBands == null || band < 0 || band >= this.mBands.length) {
                throw new IllegalArgumentException("band index " + band + " out of bounds");
            }
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$setBand(int band, MbcBand bandCfg) {
            this.checkBand(band);
            this.mBands[band] = new MbcBand(bandCfg);
        }

        private final MbcBand $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$getBand(int band) {
            this.checkBand(band);
            return this.mBands[band];
        }

        private void __constructor__(boolean bl, boolean bl2, int n) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Mbc$__constructor__(bl, bl2, n);
        }

        public Mbc(boolean bl, boolean bl2, int n) {
            super(bl, bl2, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$__constructor__(boolean boolean int ), this, bl, bl2, n);
        }

        private void __constructor__(Mbc mbc) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Mbc$__constructor__(mbc);
        }

        public Mbc(Mbc mbc) {
            super(mbc.isInUse(), mbc.isEnabled(), mbc.getBandCount());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$__constructor__(android.media.audiofx.DynamicsProcessing$Mbc ), this, mbc);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$toString(), this);
        }

        private void checkBand(int n) {
            InvokeDynamicSupport.bootstrap("checkBand", $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$checkBand(int ), this, n);
        }

        public void setBand(int n, MbcBand mbcBand) {
            InvokeDynamicSupport.bootstrap("setBand", $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$setBand(int android.media.audiofx.DynamicsProcessing$MbcBand ), this, n, mbcBand);
        }

        public MbcBand getBand(int n) {
            return InvokeDynamicSupport.bootstrap("getBand", $$robo$$android_media_audiofx_DynamicsProcessing_Mbc$getBand(int ), this, n);
        }

        public /* synthetic */ Mbc() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Mbc)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Eq
    extends BandStage
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private EqBand[] mBands;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Eq$__constructor__(boolean inUse, boolean enabled, int bandCount) {
            if (this.isInUse()) {
                this.mBands = new EqBand[bandCount];
                for (int b = 0; b < bandCount; ++b) {
                    float freq = 20000.0f;
                    if (bandCount > 1) {
                        freq = (float)Math.pow(10.0, mMinFreqLog + (float)b * (mMaxFreqLog - mMinFreqLog) / (float)(bandCount - 1));
                    }
                    this.mBands[b] = new EqBand(true, freq, 0.0f);
                }
            } else {
                this.mBands = null;
            }
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Eq$__constructor__(Eq cfg) {
            if (this.isInUse()) {
                this.mBands = new EqBand[cfg.mBands.length];
                for (int b = 0; b < this.mBands.length; ++b) {
                    this.mBands[b] = new EqBand(cfg.mBands[b]);
                }
            } else {
                this.mBands = null;
            }
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Eq$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append("--->EqBands: " + this.mBands.length + "\n");
                for (int b = 0; b < this.mBands.length; ++b) {
                    sb.append(String.format("  Band %d\n", b));
                    sb.append(this.mBands[b].toString());
                }
            }
            return sb.toString();
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Eq$checkBand(int band) {
            if (this.mBands == null || band < 0 || band >= this.mBands.length) {
                throw new IllegalArgumentException("band index " + band + " out of bounds");
            }
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Eq$setBand(int band, EqBand bandCfg) {
            this.checkBand(band);
            this.mBands[band] = new EqBand(bandCfg);
        }

        private final EqBand $$robo$$android_media_audiofx_DynamicsProcessing_Eq$getBand(int band) {
            this.checkBand(band);
            return this.mBands[band];
        }

        private void __constructor__(boolean bl, boolean bl2, int n) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Eq$__constructor__(bl, bl2, n);
        }

        public Eq(boolean bl, boolean bl2, int n) {
            super(bl, bl2, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Eq$__constructor__(boolean boolean int ), this, bl, bl2, n);
        }

        private void __constructor__(Eq eq) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Eq$__constructor__(eq);
        }

        public Eq(Eq eq) {
            super(eq.isInUse(), eq.isEnabled(), eq.getBandCount());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Eq$__constructor__(android.media.audiofx.DynamicsProcessing$Eq ), this, eq);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Eq$toString(), this);
        }

        private void checkBand(int n) {
            InvokeDynamicSupport.bootstrap("checkBand", $$robo$$android_media_audiofx_DynamicsProcessing_Eq$checkBand(int ), this, n);
        }

        public void setBand(int n, EqBand eqBand) {
            InvokeDynamicSupport.bootstrap("setBand", $$robo$$android_media_audiofx_DynamicsProcessing_Eq$setBand(int android.media.audiofx.DynamicsProcessing$EqBand ), this, n, eqBand);
        }

        public EqBand getBand(int n) {
            return InvokeDynamicSupport.bootstrap("getBand", $$robo$$android_media_audiofx_DynamicsProcessing_Eq$getBand(int ), this, n);
        }

        public /* synthetic */ Eq() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Eq)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MbcBand
    extends BandBase
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private float mAttackTime;
        private float mReleaseTime;
        private float mRatio;
        private float mThreshold;
        private float mKneeWidth;
        private float mNoiseGateThreshold;
        private float mExpanderRatio;
        private float mPreGain;
        private float mPostGain;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$__constructor__(boolean enabled, float cutoffFrequency, float attackTime, float releaseTime, float ratio, float threshold, float kneeWidth, float noiseGateThreshold, float expanderRatio, float preGain, float postGain) {
            this.mAttackTime = attackTime;
            this.mReleaseTime = releaseTime;
            this.mRatio = ratio;
            this.mThreshold = threshold;
            this.mKneeWidth = kneeWidth;
            this.mNoiseGateThreshold = noiseGateThreshold;
            this.mExpanderRatio = expanderRatio;
            this.mPreGain = preGain;
            this.mPostGain = postGain;
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$__constructor__(MbcBand cfg) {
            this.mAttackTime = cfg.mAttackTime;
            this.mReleaseTime = cfg.mReleaseTime;
            this.mRatio = cfg.mRatio;
            this.mThreshold = cfg.mThreshold;
            this.mKneeWidth = cfg.mKneeWidth;
            this.mNoiseGateThreshold = cfg.mNoiseGateThreshold;
            this.mExpanderRatio = cfg.mExpanderRatio;
            this.mPreGain = cfg.mPreGain;
            this.mPostGain = cfg.mPostGain;
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(String.format(" AttackTime: %f (ms)\n", Float.valueOf(this.mAttackTime)));
            sb.append(String.format(" ReleaseTime: %f (ms)\n", Float.valueOf(this.mReleaseTime)));
            sb.append(String.format(" Ratio: 1:%f\n", Float.valueOf(this.mRatio)));
            sb.append(String.format(" Threshold: %f (dB)\n", Float.valueOf(this.mThreshold)));
            sb.append(String.format(" NoiseGateThreshold: %f(dB)\n", Float.valueOf(this.mNoiseGateThreshold)));
            sb.append(String.format(" ExpanderRatio: %f:1\n", Float.valueOf(this.mExpanderRatio)));
            sb.append(String.format(" PreGain: %f (dB)\n", Float.valueOf(this.mPreGain)));
            sb.append(String.format(" PostGain: %f (dB)\n", Float.valueOf(this.mPostGain)));
            return sb.toString();
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getAttackTime() {
            return this.mAttackTime;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setAttackTime(float attackTime) {
            this.mAttackTime = attackTime;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getReleaseTime() {
            return this.mReleaseTime;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setReleaseTime(float releaseTime) {
            this.mReleaseTime = releaseTime;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getRatio() {
            return this.mRatio;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setRatio(float ratio) {
            this.mRatio = ratio;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getThreshold() {
            return this.mThreshold;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setThreshold(float threshold) {
            this.mThreshold = threshold;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getKneeWidth() {
            return this.mKneeWidth;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setKneeWidth(float kneeWidth) {
            this.mKneeWidth = kneeWidth;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getNoiseGateThreshold() {
            return this.mNoiseGateThreshold;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setNoiseGateThreshold(float noiseGateThreshold) {
            this.mNoiseGateThreshold = noiseGateThreshold;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getExpanderRatio() {
            return this.mExpanderRatio;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setExpanderRatio(float expanderRatio) {
            this.mExpanderRatio = expanderRatio;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getPreGain() {
            return this.mPreGain;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setPreGain(float preGain) {
            this.mPreGain = preGain;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getPostGain() {
            return this.mPostGain;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setPostGain(float postGain) {
            this.mPostGain = postGain;
        }

        private void __constructor__(boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$__constructor__(bl, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        }

        public MbcBand(boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
            super(bl, f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$__constructor__(boolean float float float float float float float float float float ), this, bl, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        }

        private void __constructor__(MbcBand mbcBand) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$__constructor__(mbcBand);
        }

        public MbcBand(MbcBand mbcBand) {
            super(mbcBand.isEnabled(), mbcBand.getCutoffFrequency());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$__constructor__(android.media.audiofx.DynamicsProcessing$MbcBand ), this, mbcBand);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$toString(), this);
        }

        public float getAttackTime() {
            return (float)InvokeDynamicSupport.bootstrap("getAttackTime", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getAttackTime(), this);
        }

        public void setAttackTime(float f) {
            InvokeDynamicSupport.bootstrap("setAttackTime", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setAttackTime(float ), this, f);
        }

        public float getReleaseTime() {
            return (float)InvokeDynamicSupport.bootstrap("getReleaseTime", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getReleaseTime(), this);
        }

        public void setReleaseTime(float f) {
            InvokeDynamicSupport.bootstrap("setReleaseTime", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setReleaseTime(float ), this, f);
        }

        public float getRatio() {
            return (float)InvokeDynamicSupport.bootstrap("getRatio", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getRatio(), this);
        }

        public void setRatio(float f) {
            InvokeDynamicSupport.bootstrap("setRatio", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setRatio(float ), this, f);
        }

        public float getThreshold() {
            return (float)InvokeDynamicSupport.bootstrap("getThreshold", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getThreshold(), this);
        }

        public void setThreshold(float f) {
            InvokeDynamicSupport.bootstrap("setThreshold", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setThreshold(float ), this, f);
        }

        public float getKneeWidth() {
            return (float)InvokeDynamicSupport.bootstrap("getKneeWidth", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getKneeWidth(), this);
        }

        public void setKneeWidth(float f) {
            InvokeDynamicSupport.bootstrap("setKneeWidth", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setKneeWidth(float ), this, f);
        }

        public float getNoiseGateThreshold() {
            return (float)InvokeDynamicSupport.bootstrap("getNoiseGateThreshold", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getNoiseGateThreshold(), this);
        }

        public void setNoiseGateThreshold(float f) {
            InvokeDynamicSupport.bootstrap("setNoiseGateThreshold", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setNoiseGateThreshold(float ), this, f);
        }

        public float getExpanderRatio() {
            return (float)InvokeDynamicSupport.bootstrap("getExpanderRatio", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getExpanderRatio(), this);
        }

        public void setExpanderRatio(float f) {
            InvokeDynamicSupport.bootstrap("setExpanderRatio", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setExpanderRatio(float ), this, f);
        }

        public float getPreGain() {
            return (float)InvokeDynamicSupport.bootstrap("getPreGain", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getPreGain(), this);
        }

        public void setPreGain(float f) {
            InvokeDynamicSupport.bootstrap("setPreGain", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setPreGain(float ), this, f);
        }

        public float getPostGain() {
            return (float)InvokeDynamicSupport.bootstrap("getPostGain", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$getPostGain(), this);
        }

        public void setPostGain(float f) {
            InvokeDynamicSupport.bootstrap("setPostGain", $$robo$$android_media_audiofx_DynamicsProcessing_MbcBand$setPostGain(float ), this, f);
        }

        public /* synthetic */ MbcBand() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MbcBand)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class EqBand
    extends BandBase
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private float mGain;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$__constructor__(boolean enabled, float cutoffFrequency, float gain) {
            this.mGain = gain;
        }

        private void $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$__constructor__(EqBand cfg) {
            this.mGain = cfg.mGain;
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(String.format(" Gain: %f\n", Float.valueOf(this.mGain)));
            return sb.toString();
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$getGain() {
            return this.mGain;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$setGain(float gain) {
            this.mGain = gain;
        }

        private void __constructor__(boolean bl, float f, float f2) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_EqBand$__constructor__(bl, f, f2);
        }

        public EqBand(boolean bl, float f, float f2) {
            super(bl, f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$__constructor__(boolean float float ), this, bl, f, f2);
        }

        private void __constructor__(EqBand eqBand) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_EqBand$__constructor__(eqBand);
        }

        public EqBand(EqBand eqBand) {
            super(eqBand.isEnabled(), eqBand.getCutoffFrequency());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$__constructor__(android.media.audiofx.DynamicsProcessing$EqBand ), this, eqBand);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$toString(), this);
        }

        public float getGain() {
            return (float)InvokeDynamicSupport.bootstrap("getGain", $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$getGain(), this);
        }

        public void setGain(float f) {
            InvokeDynamicSupport.bootstrap("setGain", $$robo$$android_media_audiofx_DynamicsProcessing_EqBand$setGain(float ), this, f);
        }

        public /* synthetic */ EqBand() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EqBand)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BandBase
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mEnabled;
        private float mCutoffFrequency;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$__constructor__(boolean enabled, float cutoffFrequency) {
            this.mEnabled = enabled;
            this.mCutoffFrequency = cutoffFrequency;
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Enabled: %b\n", this.mEnabled));
            sb.append(String.format(" CutoffFrequency: %f\n", Float.valueOf(this.mCutoffFrequency)));
            return sb.toString();
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$isEnabled() {
            return this.mEnabled;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        private final float $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$getCutoffFrequency() {
            return this.mCutoffFrequency;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$setCutoffFrequency(float frequency) {
            this.mCutoffFrequency = frequency;
        }

        private void __constructor__(boolean bl, float f) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_BandBase$__constructor__(bl, f);
        }

        public BandBase(boolean bl, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$__constructor__(boolean float ), this, bl, f);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$toString(), this);
        }

        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$isEnabled(), this);
        }

        public void setEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$setEnabled(boolean ), this, bl);
        }

        public float getCutoffFrequency() {
            return (float)InvokeDynamicSupport.bootstrap("getCutoffFrequency", $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$getCutoffFrequency(), this);
        }

        public void setCutoffFrequency(float f) {
            InvokeDynamicSupport.bootstrap("setCutoffFrequency", $$robo$$android_media_audiofx_DynamicsProcessing_BandBase$setCutoffFrequency(float ), this, f);
        }

        public /* synthetic */ BandBase() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BandBase)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BandStage
    extends Stage
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mBandCount;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_BandStage$__constructor__(boolean inUse, boolean enabled, int bandCount) {
            this.mBandCount = this.isInUse() ? bandCount : 0;
        }

        private final int $$robo$$android_media_audiofx_DynamicsProcessing_BandStage$getBandCount() {
            return this.mBandCount;
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_BandStage$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append(String.format(" Band Count: %d\n", this.mBandCount));
            }
            return sb.toString();
        }

        private void __constructor__(boolean bl, boolean bl2, int n) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_BandStage$__constructor__(bl, bl2, n);
        }

        public BandStage(boolean bl, boolean bl2, int n) {
            super(bl, bl2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_BandStage$__constructor__(boolean boolean int ), this, bl, bl2, n);
        }

        public int getBandCount() {
            return (int)InvokeDynamicSupport.bootstrap("getBandCount", $$robo$$android_media_audiofx_DynamicsProcessing_BandStage$getBandCount(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_BandStage$toString(), this);
        }

        public /* synthetic */ BandStage() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BandStage)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Stage
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mInUse;
        private boolean mEnabled;

        private void $$robo$$android_media_audiofx_DynamicsProcessing_Stage$__constructor__(boolean inUse, boolean enabled) {
            this.mInUse = inUse;
            this.mEnabled = enabled;
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_Stage$isEnabled() {
            return this.mEnabled;
        }

        private final void $$robo$$android_media_audiofx_DynamicsProcessing_Stage$setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        private final boolean $$robo$$android_media_audiofx_DynamicsProcessing_Stage$isInUse() {
            return this.mInUse;
        }

        private final String $$robo$$android_media_audiofx_DynamicsProcessing_Stage$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Stage InUse: %b\n", this.isInUse()));
            if (this.isInUse()) {
                sb.append(String.format(" Stage Enabled: %b\n", this.mEnabled));
            }
            return sb.toString();
        }

        private void __constructor__(boolean bl, boolean bl2) {
            this.$$robo$$android_media_audiofx_DynamicsProcessing_Stage$__constructor__(bl, bl2);
        }

        public Stage(boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_DynamicsProcessing_Stage$__constructor__(boolean boolean ), this, bl, bl2);
        }

        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_media_audiofx_DynamicsProcessing_Stage$isEnabled(), this);
        }

        public void setEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_media_audiofx_DynamicsProcessing_Stage$setEnabled(boolean ), this, bl);
        }

        public boolean isInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInUse", $$robo$$android_media_audiofx_DynamicsProcessing_Stage$isInUse(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_DynamicsProcessing_Stage$toString(), this);
        }

        public /* synthetic */ Stage() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

