/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import com.android.internal.widget.SubtitleView;
import java.util.ArrayList;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WebVttRenderingWidget
extends ViewGroup
implements SubtitleTrack.RenderingWidget,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static CaptioningManager.CaptionStyle DEFAULT_CAPTION_STYLE;
    private static int DEBUG_REGION_BACKGROUND = -2147483393;
    private static int DEBUG_CUE_BACKGROUND = -2130771968;
    private static float LINE_HEIGHT_RATIO = 0.0533f;
    private ArrayMap<TextTrackRegion, RegionLayout> mRegionBoxes;
    private ArrayMap<TextTrackCue, CueLayout> mCueBoxes;
    private CaptioningManager mManager;
    private SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    private CaptioningManager.CaptionStyle mCaptionStyle;
    private float mFontSize;
    private boolean mHasChangeListener;
    private CaptioningManager.CaptioningChangeListener mCaptioningListener;

    private void $$robo$$android_media_WebVttRenderingWidget$__constructor__(Context context) {
    }

    private void $$robo$$android_media_WebVttRenderingWidget$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_media_WebVttRenderingWidget$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_media_WebVttRenderingWidget$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mRegionBoxes = new ArrayMap();
        this.mCueBoxes = new ArrayMap();
        this.mCaptioningListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ WebVttRenderingWidget this$0;

            private void $$robo$$android_media_WebVttRenderingWidget_1$__constructor__(WebVttRenderingWidget this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_WebVttRenderingWidget_1$onFontScaleChanged(float fontScale) {
                float fontSize = fontScale * (float)this.this$0.getHeight() * 0.0533f;
                this.this$0.setCaptionStyle(this.this$0.mCaptionStyle, fontSize);
            }

            private final void $$robo$$android_media_WebVttRenderingWidget_1$onUserStyleChanged(CaptioningManager.CaptionStyle userStyle) {
                this.this$0.setCaptionStyle(userStyle, this.this$0.mFontSize);
            }

            private void __constructor__(WebVttRenderingWidget webVttRenderingWidget) {
                this.$$robo$$android_media_WebVttRenderingWidget_1$__constructor__(webVttRenderingWidget);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget_1$__constructor__(android.media.WebVttRenderingWidget ), this, webVttRenderingWidget);
            }

            @Override
            public void onFontScaleChanged(float f) {
                InvokeDynamicSupport.bootstrap("onFontScaleChanged", $$robo$$android_media_WebVttRenderingWidget_1$onFontScaleChanged(float ), this, f);
            }

            @Override
            public void onUserStyleChanged(CaptioningManager.CaptionStyle captionStyle) {
                InvokeDynamicSupport.bootstrap("onUserStyleChanged", $$robo$$android_media_WebVttRenderingWidget_1$onUserStyleChanged(android.view.accessibility.CaptioningManager$CaptionStyle ), this, captionStyle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.setLayerType(1, null);
        this.mManager = (CaptioningManager)context.getSystemService("captioning");
        this.mCaptionStyle = this.mManager.getUserStyle();
        this.mFontSize = this.mManager.getFontScale() * (float)this.getHeight() * 0.0533f;
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$setSize(int width, int height) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        this.measure(widthSpec, heightSpec);
        this.layout(0, 0, width, height);
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.manageChangeListener();
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.manageChangeListener();
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$setVisible(boolean visible) {
        if (visible) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
        this.manageChangeListener();
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$manageChangeListener() {
        boolean needsListener;
        boolean bl = needsListener = this.isAttachedToWindow() && this.getVisibility() == 0;
        if (this.mHasChangeListener != needsListener) {
            this.mHasChangeListener = needsListener;
            if (needsListener) {
                this.mManager.addCaptioningChangeListener(this.mCaptioningListener);
                CaptioningManager.CaptionStyle captionStyle = this.mManager.getUserStyle();
                float fontSize = this.mManager.getFontScale() * (float)this.getHeight() * 0.0533f;
                this.setCaptionStyle(captionStyle, fontSize);
            } else {
                this.mManager.removeCaptioningChangeListener(this.mCaptioningListener);
            }
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$setActiveCues(Vector<SubtitleTrack.Cue> activeCues) {
        Context context = this.getContext();
        CaptioningManager.CaptionStyle captionStyle = this.mCaptionStyle;
        float fontSize = this.mFontSize;
        this.prepForPrune();
        int count = activeCues.size();
        for (int i = 0; i < count; ++i) {
            TextTrackCue cue = (TextTrackCue)activeCues.get(i);
            TextTrackRegion region = cue.mRegion;
            if (region != null) {
                RegionLayout regionBox = this.mRegionBoxes.get(region);
                if (regionBox == null) {
                    regionBox = new RegionLayout(context, region, captionStyle, fontSize);
                    this.mRegionBoxes.put(region, regionBox);
                    this.addView((View)regionBox, -2, -2);
                }
                regionBox.put(cue);
                continue;
            }
            CueLayout cueBox = this.mCueBoxes.get(cue);
            if (cueBox == null) {
                cueBox = new CueLayout(context, cue, captionStyle, fontSize);
                this.mCueBoxes.put(cue, cueBox);
                this.addView((View)cueBox, -2, -2);
            }
            cueBox.update();
            cueBox.setOrder(i);
        }
        this.prune();
        int width = this.getWidth();
        int height = this.getHeight();
        this.setSize(width, height);
        if (this.mListener != null) {
            this.mListener.onChanged(this);
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float fontSize) {
        this.mCaptionStyle = captionStyle = DEFAULT_CAPTION_STYLE.applyStyle(captionStyle);
        this.mFontSize = fontSize;
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            cueBox.setCaptionStyle(captionStyle, fontSize);
        }
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            regionBox.setCaptionStyle(captionStyle, fontSize);
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$prune() {
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            if (!regionBox.prune()) continue;
            this.removeView(regionBox);
            this.mRegionBoxes.removeAt(i);
            --regionCount;
            --i;
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            if (cueBox.isActive()) continue;
            this.removeView(cueBox);
            this.mCueBoxes.removeAt(i);
            --cueCount;
            --i;
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$prepForPrune() {
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            regionBox.prepForPrune();
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            cueBox.prepForPrune();
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            regionBox.measureForParent(widthMeasureSpec, heightMeasureSpec);
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            cueBox.measureForParent(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$onLayout(boolean changed, int l, int t, int r, int b) {
        int viewportWidth = r - l;
        int viewportHeight = b - t;
        this.setCaptionStyle(this.mCaptionStyle, this.mManager.getFontScale() * 0.0533f * (float)viewportHeight);
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            this.layoutRegion(viewportWidth, viewportHeight, regionBox);
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            this.layoutCue(viewportWidth, viewportHeight, cueBox);
        }
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$layoutRegion(int viewportWidth, int viewportHeight, RegionLayout regionBox) {
        TextTrackRegion region = regionBox.getRegion();
        int regionHeight = regionBox.getMeasuredHeight();
        int regionWidth = regionBox.getMeasuredWidth();
        float x = region.mViewportAnchorPointX;
        float y = region.mViewportAnchorPointY;
        int left = (int)(x * (float)(viewportWidth - regionWidth) / 100.0f);
        int top = (int)(y * (float)(viewportHeight - regionHeight) / 100.0f);
        regionBox.layout(left, top, left + regionWidth, top + regionHeight);
    }

    private final void $$robo$$android_media_WebVttRenderingWidget$layoutCue(int viewportWidth, int viewportHeight, CueLayout cueBox) {
        int xPosition;
        TextTrackCue cue = cueBox.getCue();
        int direction = this.getLayoutDirection();
        int absAlignment = WebVttRenderingWidget.resolveCueAlignment(direction, cue.mAlignment);
        boolean cueSnapToLines = cue.mSnapToLines;
        int size = 100 * cueBox.getMeasuredWidth() / viewportWidth;
        switch (absAlignment) {
            case 203: {
                xPosition = cue.mTextPosition;
                break;
            }
            case 204: {
                xPosition = cue.mTextPosition - size;
                break;
            }
            default: {
                xPosition = cue.mTextPosition - size / 2;
            }
        }
        if (direction == 1) {
            xPosition = 100 - xPosition;
        }
        if (cueSnapToLines) {
            float rightEdge;
            int paddingLeft = 100 * this.getPaddingLeft() / viewportWidth;
            int paddingRight = 100 * this.getPaddingRight() / viewportWidth;
            if (xPosition < paddingLeft && xPosition + size > paddingLeft) {
                xPosition += paddingLeft;
                size -= paddingLeft;
            }
            if ((float)xPosition < (rightEdge = (float)(100 - paddingRight)) && (float)(xPosition + size) > rightEdge) {
                size -= paddingRight;
            }
        }
        int left = xPosition * viewportWidth / 100;
        int width = size * viewportWidth / 100;
        int yPosition = this.calculateLinePosition(cueBox);
        int height = cueBox.getMeasuredHeight();
        int top = yPosition < 0 ? viewportHeight + yPosition * height : yPosition * (viewportHeight - height) / 100;
        cueBox.layout(left, top, left + width, top + height);
    }

    private final int $$robo$$android_media_WebVttRenderingWidget$calculateLinePosition(CueLayout cueBox) {
        boolean autoPosition;
        TextTrackCue cue = cueBox.getCue();
        Integer linePosition = cue.mLinePosition;
        boolean snapToLines = cue.mSnapToLines;
        boolean bl = autoPosition = linePosition == null;
        if (!(snapToLines || autoPosition || linePosition >= 0 && linePosition <= 100)) {
            return 100;
        }
        if (!autoPosition) {
            return linePosition;
        }
        if (!snapToLines) {
            return 100;
        }
        return -(cueBox.mOrder + 1);
    }

    private static final int $$robo$$android_media_WebVttRenderingWidget$resolveCueAlignment(int layoutDirection, int alignment) {
        switch (alignment) {
            case 201: {
                return layoutDirection == 0 ? 203 : 204;
            }
            case 202: {
                return layoutDirection == 0 ? 204 : 203;
            }
        }
        return alignment;
    }

    static void __staticInitializer__() {
        DEFAULT_CAPTION_STYLE = CaptioningManager.CaptionStyle.DEFAULT;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_WebVttRenderingWidget$__constructor__(context);
    }

    public WebVttRenderingWidget(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_media_WebVttRenderingWidget$__constructor__(context, attributeSet);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_media_WebVttRenderingWidget$__constructor__(context, attributeSet, n);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_media_WebVttRenderingWidget$__constructor__(context, attributeSet, n, n2);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    public void setSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_media_WebVttRenderingWidget$setSize(int int ), this, n, n2);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_media_WebVttRenderingWidget$onAttachedToWindow(), this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_media_WebVttRenderingWidget$onDetachedFromWindow(), this);
    }

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener onChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnChangedListener", $$robo$$android_media_WebVttRenderingWidget$setOnChangedListener(android.media.SubtitleTrack$RenderingWidget$OnChangedListener ), this, onChangedListener);
    }

    @Override
    public void setVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_media_WebVttRenderingWidget$setVisible(boolean ), this, bl);
    }

    private void manageChangeListener() {
        InvokeDynamicSupport.bootstrap("manageChangeListener", $$robo$$android_media_WebVttRenderingWidget$manageChangeListener(), this);
    }

    public void setActiveCues(Vector<SubtitleTrack.Cue> vector) {
        InvokeDynamicSupport.bootstrap("setActiveCues", $$robo$$android_media_WebVttRenderingWidget$setActiveCues(java.util.Vector<android.media.SubtitleTrack$Cue> ), this, vector);
    }

    private void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
        InvokeDynamicSupport.bootstrap("setCaptionStyle", $$robo$$android_media_WebVttRenderingWidget$setCaptionStyle(android.view.accessibility.CaptioningManager$CaptionStyle float ), this, captionStyle, f);
    }

    private void prune() {
        InvokeDynamicSupport.bootstrap("prune", $$robo$$android_media_WebVttRenderingWidget$prune(), this);
    }

    private void prepForPrune() {
        InvokeDynamicSupport.bootstrap("prepForPrune", $$robo$$android_media_WebVttRenderingWidget$prepForPrune(), this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_media_WebVttRenderingWidget$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_media_WebVttRenderingWidget$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    private void layoutRegion(int n, int n2, RegionLayout regionLayout) {
        InvokeDynamicSupport.bootstrap("layoutRegion", $$robo$$android_media_WebVttRenderingWidget$layoutRegion(int int android.media.WebVttRenderingWidget$RegionLayout ), this, n, n2, regionLayout);
    }

    private void layoutCue(int n, int n2, CueLayout cueLayout) {
        InvokeDynamicSupport.bootstrap("layoutCue", $$robo$$android_media_WebVttRenderingWidget$layoutCue(int int android.media.WebVttRenderingWidget$CueLayout ), this, n, n2, cueLayout);
    }

    private int calculateLinePosition(CueLayout cueLayout) {
        return (int)InvokeDynamicSupport.bootstrap("calculateLinePosition", $$robo$$android_media_WebVttRenderingWidget$calculateLinePosition(android.media.WebVttRenderingWidget$CueLayout ), this, cueLayout);
    }

    private static int resolveCueAlignment(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveCueAlignment", $$robo$$android_media_WebVttRenderingWidget$resolveCueAlignment(int int ), (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(WebVttRenderingWidget.class);
    }

    public /* synthetic */ WebVttRenderingWidget() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebVttRenderingWidget)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SpanLayout
    extends SubtitleView
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private SpannableStringBuilder mBuilder;
        private TextTrackCueSpan[] mSpans;

        private void $$robo$$android_media_WebVttRenderingWidget_SpanLayout$__constructor__(Context context, TextTrackCueSpan[] spans) {
            this.mBuilder = new SpannableStringBuilder();
            this.mSpans = spans;
            this.update();
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_SpanLayout$update() {
            SpannableStringBuilder builder = this.mBuilder;
            TextTrackCueSpan[] spans = this.mSpans;
            builder.clear();
            builder.clearSpans();
            for (TextTrackCueSpan span : spans) {
                int i;
                if (!span.mEnabled) continue;
                builder.append(spans[i].mText);
            }
            this.setText(builder);
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_SpanLayout$setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            this.setBackgroundColor(captionStyle.backgroundColor);
            this.setForegroundColor(captionStyle.foregroundColor);
            this.setEdgeColor(captionStyle.edgeColor);
            this.setEdgeType(captionStyle.edgeType);
            this.setTypeface(captionStyle.getTypeface());
            this.setTextSize(fontSize);
        }

        private void __constructor__(Context context, TextTrackCueSpan[] textTrackCueSpanArray) {
            this.$$robo$$android_media_WebVttRenderingWidget_SpanLayout$__constructor__(context, textTrackCueSpanArray);
        }

        public SpanLayout(Context context, TextTrackCueSpan[] textTrackCueSpanArray) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget_SpanLayout$__constructor__(android.content.Context android.media.TextTrackCueSpan[] ), this, context, textTrackCueSpanArray);
        }

        public void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$android_media_WebVttRenderingWidget_SpanLayout$update(), this);
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
            InvokeDynamicSupport.bootstrap("setCaptionStyle", $$robo$$android_media_WebVttRenderingWidget_SpanLayout$setCaptionStyle(android.view.accessibility.CaptioningManager$CaptionStyle float ), this, captionStyle, f);
        }

        public /* synthetic */ SpanLayout() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpanLayout)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CueLayout
    extends LinearLayout
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public TextTrackCue mCue;
        private CaptioningManager.CaptionStyle mCaptionStyle;
        private float mFontSize;
        private boolean mActive;
        private int mOrder;

        private void $$robo$$android_media_WebVttRenderingWidget_CueLayout$__constructor__(Context context, TextTrackCue cue, CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            this.mCue = cue;
            this.mCaptionStyle = captionStyle;
            this.mFontSize = fontSize;
            boolean horizontal = cue.mWritingDirection == 100;
            this.setOrientation(horizontal ? 1 : 0);
            switch (cue.mAlignment) {
                case 202: {
                    this.setGravity(0x800005);
                    break;
                }
                case 203: {
                    this.setGravity(3);
                    break;
                }
                case 200: {
                    this.setGravity(horizontal ? 1 : 16);
                    break;
                }
                case 204: {
                    this.setGravity(5);
                    break;
                }
                case 201: {
                    this.setGravity(0x800003);
                }
            }
            this.update();
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_CueLayout$setCaptionStyle(CaptioningManager.CaptionStyle style2, float fontSize) {
            this.mCaptionStyle = style2;
            this.mFontSize = fontSize;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof SpanLayout)) continue;
                ((SpanLayout)child).setCaptionStyle(style2, fontSize);
            }
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_CueLayout$prepForPrune() {
            this.mActive = false;
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_CueLayout$update() {
            Layout.Alignment alignment;
            this.mActive = true;
            this.removeAllViews();
            int cueAlignment = WebVttRenderingWidget.resolveCueAlignment(this.getLayoutDirection(), this.mCue.mAlignment);
            switch (cueAlignment) {
                case 203: {
                    alignment = Layout.Alignment.ALIGN_LEFT;
                    break;
                }
                case 204: {
                    alignment = Layout.Alignment.ALIGN_RIGHT;
                    break;
                }
                default: {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                }
            }
            CaptioningManager.CaptionStyle captionStyle = this.mCaptionStyle;
            float fontSize = this.mFontSize;
            TextTrackCueSpan[][] lines = this.mCue.mLines;
            int lineCount = lines.length;
            for (int i = 0; i < lineCount; ++i) {
                SpanLayout lineBox = new SpanLayout(this.getContext(), lines[i]);
                lineBox.setAlignment(alignment);
                lineBox.setCaptionStyle(captionStyle, fontSize);
                this.addView((View)lineBox, -2, -2);
            }
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_CueLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_CueLayout$measureForParent(int widthMeasureSpec, int heightMeasureSpec) {
            int maximumSize;
            TextTrackCue cue = this.mCue;
            int specWidth = View.MeasureSpec.getSize(widthMeasureSpec);
            int specHeight = View.MeasureSpec.getSize(heightMeasureSpec);
            int direction = this.getLayoutDirection();
            int absAlignment = WebVttRenderingWidget.resolveCueAlignment(direction, cue.mAlignment);
            switch (absAlignment) {
                case 203: {
                    maximumSize = 100 - cue.mTextPosition;
                    break;
                }
                case 204: {
                    maximumSize = cue.mTextPosition;
                    break;
                }
                case 200: {
                    if (cue.mTextPosition <= 50) {
                        maximumSize = cue.mTextPosition * 2;
                        break;
                    }
                    maximumSize = (100 - cue.mTextPosition) * 2;
                    break;
                }
                default: {
                    maximumSize = 0;
                }
            }
            int size = Math.min(cue.mSize, maximumSize) * specWidth / 100;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(size, Integer.MIN_VALUE);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(specHeight, Integer.MIN_VALUE);
            this.measure(widthMeasureSpec, heightMeasureSpec);
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_CueLayout$setOrder(int order) {
            this.mOrder = order;
        }

        private final boolean $$robo$$android_media_WebVttRenderingWidget_CueLayout$isActive() {
            return this.mActive;
        }

        private final TextTrackCue $$robo$$android_media_WebVttRenderingWidget_CueLayout$getCue() {
            return this.mCue;
        }

        private void __constructor__(Context context, TextTrackCue textTrackCue, CaptioningManager.CaptionStyle captionStyle, float f) {
            this.$$robo$$android_media_WebVttRenderingWidget_CueLayout$__constructor__(context, textTrackCue, captionStyle, f);
        }

        public CueLayout(Context context, TextTrackCue textTrackCue, CaptioningManager.CaptionStyle captionStyle, float f) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget_CueLayout$__constructor__(android.content.Context android.media.TextTrackCue android.view.accessibility.CaptioningManager$CaptionStyle float ), this, context, textTrackCue, captionStyle, f);
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
            InvokeDynamicSupport.bootstrap("setCaptionStyle", $$robo$$android_media_WebVttRenderingWidget_CueLayout$setCaptionStyle(android.view.accessibility.CaptioningManager$CaptionStyle float ), this, captionStyle, f);
        }

        public void prepForPrune() {
            InvokeDynamicSupport.bootstrap("prepForPrune", $$robo$$android_media_WebVttRenderingWidget_CueLayout$prepForPrune(), this);
        }

        public void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$android_media_WebVttRenderingWidget_CueLayout$update(), this);
        }

        @Override
        protected void onMeasure(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_media_WebVttRenderingWidget_CueLayout$onMeasure(int int ), this, n, n2);
        }

        public void measureForParent(int n, int n2) {
            InvokeDynamicSupport.bootstrap("measureForParent", $$robo$$android_media_WebVttRenderingWidget_CueLayout$measureForParent(int int ), this, n, n2);
        }

        public void setOrder(int n) {
            InvokeDynamicSupport.bootstrap("setOrder", $$robo$$android_media_WebVttRenderingWidget_CueLayout$setOrder(int ), this, n);
        }

        public boolean isActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_media_WebVttRenderingWidget_CueLayout$isActive(), this);
        }

        public TextTrackCue getCue() {
            return InvokeDynamicSupport.bootstrap("getCue", $$robo$$android_media_WebVttRenderingWidget_CueLayout$getCue(), this);
        }

        public /* synthetic */ CueLayout() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CueLayout)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RegionLayout
    extends LinearLayout
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ArrayList<CueLayout> mRegionCueBoxes;
        private TextTrackRegion mRegion;
        private CaptioningManager.CaptionStyle mCaptionStyle;
        private float mFontSize;

        private void $$robo$$android_media_WebVttRenderingWidget_RegionLayout$__constructor__(Context context, TextTrackRegion region, CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            this.mRegionCueBoxes = new ArrayList();
            this.mRegion = region;
            this.mCaptionStyle = captionStyle;
            this.mFontSize = fontSize;
            this.setOrientation(1);
            this.setBackgroundColor(captionStyle.windowColor);
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_RegionLayout$setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            this.mCaptionStyle = captionStyle;
            this.mFontSize = fontSize;
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                cueBox.setCaptionStyle(captionStyle, fontSize);
            }
            this.setBackgroundColor(captionStyle.windowColor);
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_RegionLayout$measureForParent(int widthMeasureSpec, int heightMeasureSpec) {
            TextTrackRegion region = this.mRegion;
            int specWidth = View.MeasureSpec.getSize(widthMeasureSpec);
            int specHeight = View.MeasureSpec.getSize(heightMeasureSpec);
            int width = (int)region.mWidth;
            int size = width * specWidth / 100;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(size, Integer.MIN_VALUE);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(specHeight, Integer.MIN_VALUE);
            this.measure(widthMeasureSpec, heightMeasureSpec);
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_RegionLayout$prepForPrune() {
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                cueBox.prepForPrune();
            }
        }

        private final void $$robo$$android_media_WebVttRenderingWidget_RegionLayout$put(TextTrackCue cue) {
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                if (cueBox.getCue() != cue) continue;
                cueBox.update();
                return;
            }
            CueLayout cueBox = new CueLayout(this.getContext(), cue, this.mCaptionStyle, this.mFontSize);
            this.mRegionCueBoxes.add(cueBox);
            this.addView((View)cueBox, -2, -2);
            if (this.getChildCount() > this.mRegion.mLines) {
                this.removeViewAt(0);
            }
        }

        private final boolean $$robo$$android_media_WebVttRenderingWidget_RegionLayout$prune() {
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                if (cueBox.isActive()) continue;
                this.mRegionCueBoxes.remove(i);
                this.removeView(cueBox);
                --cueCount;
                --i;
            }
            return this.mRegionCueBoxes.isEmpty();
        }

        private final TextTrackRegion $$robo$$android_media_WebVttRenderingWidget_RegionLayout$getRegion() {
            return this.mRegion;
        }

        private void __constructor__(Context context, TextTrackRegion textTrackRegion, CaptioningManager.CaptionStyle captionStyle, float f) {
            this.$$robo$$android_media_WebVttRenderingWidget_RegionLayout$__constructor__(context, textTrackRegion, captionStyle, f);
        }

        public RegionLayout(Context context, TextTrackRegion textTrackRegion, CaptioningManager.CaptionStyle captionStyle, float f) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$__constructor__(android.content.Context android.media.TextTrackRegion android.view.accessibility.CaptioningManager$CaptionStyle float ), this, context, textTrackRegion, captionStyle, f);
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float f) {
            InvokeDynamicSupport.bootstrap("setCaptionStyle", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$setCaptionStyle(android.view.accessibility.CaptioningManager$CaptionStyle float ), this, captionStyle, f);
        }

        public void measureForParent(int n, int n2) {
            InvokeDynamicSupport.bootstrap("measureForParent", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$measureForParent(int int ), this, n, n2);
        }

        public void prepForPrune() {
            InvokeDynamicSupport.bootstrap("prepForPrune", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$prepForPrune(), this);
        }

        public void put(TextTrackCue textTrackCue) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$put(android.media.TextTrackCue ), this, textTrackCue);
        }

        public boolean prune() {
            return (boolean)InvokeDynamicSupport.bootstrap("prune", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$prune(), this);
        }

        public TextTrackRegion getRegion() {
            return InvokeDynamicSupport.bootstrap("getRegion", $$robo$$android_media_WebVttRenderingWidget_RegionLayout$getRegion(), this);
        }

        public /* synthetic */ RegionLayout() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegionLayout)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

