/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TextTrackCue;
import android.media.TextTrackRegion;
import android.media.WebVttCueListener;
import android.util.Log;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WebVttParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WebVttParser";
    private Phase mPhase;
    private TextTrackCue mCue;
    private Vector<String> mCueTexts;
    private WebVttCueListener mListener;
    private String mBuffer;
    private Phase mSkipRest;
    private Phase mParseStart;
    private Phase mParseHeader;
    private Phase mParseCueId;
    private Phase mParseCueTime;
    private Phase mParseCueText;

    private void $$robo$$android_media_WebVttParser$__constructor__(WebVttCueListener listener) {
        this.mSkipRest = new Phase(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ WebVttParser this$0;

            private void $$robo$$android_media_WebVttParser_1$__constructor__(WebVttParser this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_WebVttParser_1$parse(String line) {
            }

            private void __constructor__(WebVttParser webVttParser) {
                this.$$robo$$android_media_WebVttParser_1$__constructor__(webVttParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser_1$__constructor__(android.media.WebVttParser ), this, webVttParser);
            }

            @Override
            public void parse(String string2) {
                InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser_1$parse(java.lang.String ), this, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mParseStart = new Phase(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ WebVttParser this$0;

            private void $$robo$$android_media_WebVttParser_2$__constructor__(WebVttParser this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_WebVttParser_2$parse(String line) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if (!(line.equals("WEBVTT") || line.startsWith("WEBVTT ") || line.startsWith("WEBVTT\t"))) {
                    this.this$0.log_warning("Not a WEBVTT header", line);
                    this.this$0.mPhase = this.this$0.mSkipRest;
                } else {
                    this.this$0.mPhase = this.this$0.mParseHeader;
                }
            }

            private void __constructor__(WebVttParser webVttParser) {
                this.$$robo$$android_media_WebVttParser_2$__constructor__(webVttParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser_2$__constructor__(android.media.WebVttParser ), this, webVttParser);
            }

            @Override
            public void parse(String string2) {
                InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser_2$parse(java.lang.String ), this, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mParseHeader = new Phase(this){
            public /* synthetic */ Object __robo_data__;
            static /* synthetic */ boolean $assertionsDisabled;
            /* synthetic */ WebVttParser this$0;

            private void $$robo$$android_media_WebVttParser_3$__constructor__(WebVttParser this$0) {
                this.this$0 = this$0;
            }

            private final TextTrackRegion $$robo$$android_media_WebVttParser_3$parseRegion(String s) {
                TextTrackRegion region = new TextTrackRegion();
                for (String setting : s.split(" +")) {
                    int equalAt = setting.indexOf(61);
                    if (equalAt <= 0 || equalAt == setting.length() - 1) continue;
                    String name = setting.substring(0, equalAt);
                    String value = setting.substring(equalAt + 1);
                    if (name.equals("id")) {
                        region.mId = value;
                        continue;
                    }
                    if (name.equals("width")) {
                        try {
                            region.mWidth = WebVttParser.parseFloatPercentage(value);
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("region setting", name, "has invalid value", e.getMessage(), value);
                        }
                        continue;
                    }
                    if (name.equals("lines")) {
                        if (value.matches(".*[^0-9].*")) {
                            this.this$0.log_warning("lines", name, "contains an invalid character", value);
                            continue;
                        }
                        try {
                            region.mLines = Integer.parseInt(value);
                            if (!$assertionsDisabled && region.mLines < 0) {
                                throw new AssertionError();
                            }
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("region setting", name, "is not numeric", value);
                        }
                        continue;
                    }
                    if (name.equals("regionanchor") || name.equals("viewportanchor")) {
                        float y;
                        float x;
                        int commaAt = value.indexOf(",");
                        if (commaAt < 0) {
                            this.this$0.log_warning("region setting", name, "contains no comma", value);
                            continue;
                        }
                        String anchorX = value.substring(0, commaAt);
                        String anchorY = value.substring(commaAt + 1);
                        try {
                            x = WebVttParser.parseFloatPercentage(anchorX);
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("region setting", name, "has invalid x component", e.getMessage(), anchorX);
                            continue;
                        }
                        try {
                            y = WebVttParser.parseFloatPercentage(anchorY);
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("region setting", name, "has invalid y component", e.getMessage(), anchorY);
                            continue;
                        }
                        if (name.charAt(0) == 'r') {
                            region.mAnchorPointX = x;
                            region.mAnchorPointY = y;
                            continue;
                        }
                        region.mViewportAnchorPointX = x;
                        region.mViewportAnchorPointY = y;
                        continue;
                    }
                    if (!name.equals("scroll")) continue;
                    if (value.equals("up")) {
                        region.mScrollValue = 301;
                        continue;
                    }
                    this.this$0.log_warning("region setting", name, "has invalid value", value);
                }
                return region;
            }

            private final void $$robo$$android_media_WebVttParser_3$parse(String line) {
                if (line.length() == 0) {
                    this.this$0.mPhase = this.this$0.mParseCueId;
                } else if (line.contains("-->")) {
                    this.this$0.mPhase = this.this$0.mParseCueTime;
                    this.this$0.mPhase.parse(line);
                } else {
                    int colonAt = line.indexOf(58);
                    if (colonAt <= 0 || colonAt >= line.length() - 1) {
                        this.this$0.log_warning("meta data header has invalid format", line);
                    }
                    String name = line.substring(0, colonAt);
                    String value = line.substring(colonAt + 1);
                    if (name.equals("Region")) {
                        TextTrackRegion region = this.parseRegion(value);
                        this.this$0.mListener.onRegionParsed(region);
                    }
                }
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !WebVttParser.class.desiredAssertionStatus();
            }

            private void __constructor__(WebVttParser webVttParser) {
                this.$$robo$$android_media_WebVttParser_3$__constructor__(webVttParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser_3$__constructor__(android.media.WebVttParser ), this, webVttParser);
            }

            TextTrackRegion parseRegion(String string2) {
                return InvokeDynamicSupport.bootstrap("parseRegion", $$robo$$android_media_WebVttParser_3$parseRegion(java.lang.String ), this, string2);
            }

            @Override
            public void parse(String string2) {
                InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser_3$parse(java.lang.String ), this, string2);
            }

            static {
                RobolectricInternals.classInitializing(3.class);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mParseCueId = new Phase(this){
            public /* synthetic */ Object __robo_data__;
            static /* synthetic */ boolean $assertionsDisabled;
            /* synthetic */ WebVttParser this$0;

            private void $$robo$$android_media_WebVttParser_4$__constructor__(WebVttParser this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_WebVttParser_4$parse(String line) {
                if (line.length() == 0) {
                    return;
                }
                if (!$assertionsDisabled && this.this$0.mCue != null) {
                    throw new AssertionError();
                }
                if (line.equals("NOTE") || line.startsWith("NOTE ")) {
                    this.this$0.mPhase = this.this$0.mParseCueText;
                }
                this.this$0.mCue = new TextTrackCue();
                this.this$0.mCueTexts.clear();
                this.this$0.mPhase = this.this$0.mParseCueTime;
                if (line.contains("-->")) {
                    this.this$0.mPhase.parse(line);
                } else {
                    ((WebVttParser)this.this$0).mCue.mId = line;
                }
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !WebVttParser.class.desiredAssertionStatus();
            }

            private void __constructor__(WebVttParser webVttParser) {
                this.$$robo$$android_media_WebVttParser_4$__constructor__(webVttParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser_4$__constructor__(android.media.WebVttParser ), this, webVttParser);
            }

            @Override
            public void parse(String string2) {
                InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser_4$parse(java.lang.String ), this, string2);
            }

            static {
                RobolectricInternals.classInitializing(4.class);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mParseCueTime = new Phase(this){
            public /* synthetic */ Object __robo_data__;
            static /* synthetic */ boolean $assertionsDisabled;
            /* synthetic */ WebVttParser this$0;

            private void $$robo$$android_media_WebVttParser_5$__constructor__(WebVttParser this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_WebVttParser_5$parse(String line) {
                int arrowAt = line.indexOf("-->");
                if (arrowAt < 0) {
                    this.this$0.mCue = null;
                    this.this$0.mPhase = this.this$0.mParseCueId;
                    return;
                }
                String start = line.substring(0, arrowAt).trim();
                String rest = line.substring(arrowAt + 3).replaceFirst("^\\s+", "").replaceFirst("\\s+", " ");
                int spaceAt = rest.indexOf(32);
                String end = spaceAt > 0 ? rest.substring(0, spaceAt) : rest;
                rest = spaceAt > 0 ? rest.substring(spaceAt + 1) : "";
                ((WebVttParser)this.this$0).mCue.mStartTimeMs = WebVttParser.parseTimestampMs(start);
                ((WebVttParser)this.this$0).mCue.mEndTimeMs = WebVttParser.parseTimestampMs(end);
                for (String setting : rest.split(" +")) {
                    int colonAt = setting.indexOf(58);
                    if (colonAt <= 0 || colonAt == setting.length() - 1) continue;
                    String name = setting.substring(0, colonAt);
                    String value = setting.substring(colonAt + 1);
                    if (name.equals("region")) {
                        ((WebVttParser)this.this$0).mCue.mRegionId = value;
                        continue;
                    }
                    if (name.equals("vertical")) {
                        if (value.equals("rl")) {
                            ((WebVttParser)this.this$0).mCue.mWritingDirection = 101;
                            continue;
                        }
                        if (value.equals("lr")) {
                            ((WebVttParser)this.this$0).mCue.mWritingDirection = 102;
                            continue;
                        }
                        this.this$0.log_warning("cue setting", name, "has invalid value", value);
                        continue;
                    }
                    if (name.equals("line")) {
                        try {
                            if (!$assertionsDisabled && value.indexOf(32) >= 0) {
                                throw new AssertionError();
                            }
                            if (value.endsWith("%")) {
                                ((WebVttParser)this.this$0).mCue.mSnapToLines = false;
                                ((WebVttParser)this.this$0).mCue.mLinePosition = WebVttParser.parseIntPercentage(value);
                                continue;
                            }
                            if (value.matches(".*[^0-9].*")) {
                                this.this$0.log_warning("cue setting", name, "contains an invalid character", value);
                                continue;
                            }
                            ((WebVttParser)this.this$0).mCue.mSnapToLines = true;
                            ((WebVttParser)this.this$0).mCue.mLinePosition = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("cue setting", name, "is not numeric or percentage", value);
                        }
                        continue;
                    }
                    if (name.equals("position")) {
                        try {
                            ((WebVttParser)this.this$0).mCue.mTextPosition = WebVttParser.parseIntPercentage(value);
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("cue setting", name, "is not numeric or percentage", value);
                        }
                        continue;
                    }
                    if (name.equals("size")) {
                        try {
                            ((WebVttParser)this.this$0).mCue.mSize = WebVttParser.parseIntPercentage(value);
                        }
                        catch (NumberFormatException e) {
                            this.this$0.log_warning("cue setting", name, "is not numeric or percentage", value);
                        }
                        continue;
                    }
                    if (!name.equals("align")) continue;
                    if (value.equals("start")) {
                        ((WebVttParser)this.this$0).mCue.mAlignment = 201;
                        continue;
                    }
                    if (value.equals("middle")) {
                        ((WebVttParser)this.this$0).mCue.mAlignment = 200;
                        continue;
                    }
                    if (value.equals("end")) {
                        ((WebVttParser)this.this$0).mCue.mAlignment = 202;
                        continue;
                    }
                    if (value.equals("left")) {
                        ((WebVttParser)this.this$0).mCue.mAlignment = 203;
                        continue;
                    }
                    if (value.equals("right")) {
                        ((WebVttParser)this.this$0).mCue.mAlignment = 204;
                        continue;
                    }
                    this.this$0.log_warning("cue setting", name, "has invalid value", value);
                }
                if (((WebVttParser)this.this$0).mCue.mLinePosition != null || ((WebVttParser)this.this$0).mCue.mSize != 100 || ((WebVttParser)this.this$0).mCue.mWritingDirection != 100) {
                    ((WebVttParser)this.this$0).mCue.mRegionId = "";
                }
                this.this$0.mPhase = this.this$0.mParseCueText;
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !WebVttParser.class.desiredAssertionStatus();
            }

            private void __constructor__(WebVttParser webVttParser) {
                this.$$robo$$android_media_WebVttParser_5$__constructor__(webVttParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser_5$__constructor__(android.media.WebVttParser ), this, webVttParser);
            }

            @Override
            public void parse(String string2) {
                InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser_5$parse(java.lang.String ), this, string2);
            }

            static {
                RobolectricInternals.classInitializing(5.class);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mParseCueText = new Phase(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ WebVttParser this$0;

            private void $$robo$$android_media_WebVttParser_6$__constructor__(WebVttParser this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_WebVttParser_6$parse(String line) {
                if (line.length() == 0) {
                    this.this$0.yieldCue();
                    this.this$0.mPhase = this.this$0.mParseCueId;
                    return;
                }
                if (this.this$0.mCue != null) {
                    this.this$0.mCueTexts.add(line);
                }
            }

            private void __constructor__(WebVttParser webVttParser) {
                this.$$robo$$android_media_WebVttParser_6$__constructor__(webVttParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser_6$__constructor__(android.media.WebVttParser ), this, webVttParser);
            }

            @Override
            public void parse(String string2) {
                InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser_6$parse(java.lang.String ), this, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhase = this.mParseStart;
        this.mBuffer = "";
        this.mListener = listener;
        this.mCueTexts = new Vector();
    }

    private static final float $$robo$$android_media_WebVttParser$parseFloatPercentage(String s) throws NumberFormatException {
        if (!s.endsWith("%")) {
            throw new NumberFormatException("does not end in %");
        }
        if ((s = s.substring(0, s.length() - 1)).matches(".*[^0-9.].*")) {
            throw new NumberFormatException("contains an invalid character");
        }
        try {
            float value = Float.parseFloat(s);
            if (value < 0.0f || value > 100.0f) {
                throw new NumberFormatException("is out of range");
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("is not a number");
        }
    }

    private static final int $$robo$$android_media_WebVttParser$parseIntPercentage(String s) throws NumberFormatException {
        if (!s.endsWith("%")) {
            throw new NumberFormatException("does not end in %");
        }
        if ((s = s.substring(0, s.length() - 1)).matches(".*[^0-9].*")) {
            throw new NumberFormatException("contains an invalid character");
        }
        try {
            int value = Integer.parseInt(s);
            if (value < 0 || value > 100) {
                throw new NumberFormatException("is out of range");
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("is not a number");
        }
    }

    private static final long $$robo$$android_media_WebVttParser$parseTimestampMs(String s) throws NumberFormatException {
        if (!s.matches("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}")) {
            throw new NumberFormatException("has invalid format");
        }
        String[] parts = s.split("\\.", 2);
        long value = 0L;
        for (String group : parts[0].split(":")) {
            value = value * 60L + Long.parseLong(group);
        }
        return value * 1000L + Long.parseLong(parts[1]);
    }

    private static final String $$robo$$android_media_WebVttParser$timeToString(long timeMs) {
        return String.format("%d:%02d:%02d.%03d", timeMs / 3600000L, timeMs / 60000L % 60L, timeMs / 1000L % 60L, timeMs % 1000L);
    }

    private final void $$robo$$android_media_WebVttParser$parse(String s) {
        boolean trailingCR = false;
        this.mBuffer = (this.mBuffer + s.replace("\u0000", "\ufffd")).replace("\r\n", "\n");
        if (this.mBuffer.endsWith("\r")) {
            trailingCR = true;
            this.mBuffer = this.mBuffer.substring(0, this.mBuffer.length() - 1);
        }
        String[] lines = this.mBuffer.split("[\r\n]");
        for (int i = 0; i < lines.length - 1; ++i) {
            this.mPhase.parse(lines[i]);
        }
        this.mBuffer = lines[lines.length - 1];
        if (trailingCR) {
            this.mBuffer = this.mBuffer + "\r";
        }
    }

    private final void $$robo$$android_media_WebVttParser$eos() {
        if (this.mBuffer.endsWith("\r")) {
            this.mBuffer = this.mBuffer.substring(0, this.mBuffer.length() - 1);
        }
        this.mPhase.parse(this.mBuffer);
        this.mBuffer = "";
        this.yieldCue();
        this.mPhase = this.mParseStart;
    }

    private final void $$robo$$android_media_WebVttParser$yieldCue() {
        if (this.mCue != null && this.mCueTexts.size() > 0) {
            this.mCue.mStrings = new String[this.mCueTexts.size()];
            this.mCueTexts.toArray(this.mCue.mStrings);
            this.mCueTexts.clear();
            this.mListener.onCueParsed(this.mCue);
        }
        this.mCue = null;
    }

    private final void $$robo$$android_media_WebVttParser$log_warning(String nameType, String name, String message, String subMessage, String value) {
        Log.w(this.getClass().getName(), nameType + " '" + name + "' " + message + " ('" + value + "' " + subMessage + ")");
    }

    private final void $$robo$$android_media_WebVttParser$log_warning(String nameType, String name, String message, String value) {
        Log.w(this.getClass().getName(), nameType + " '" + name + "' " + message + " ('" + value + "')");
    }

    private final void $$robo$$android_media_WebVttParser$log_warning(String message, String value) {
        Log.w(this.getClass().getName(), message + " ('" + value + "')");
    }

    private void __constructor__(WebVttCueListener webVttCueListener) {
        this.$$robo$$android_media_WebVttParser$__constructor__(webVttCueListener);
    }

    public WebVttParser(WebVttCueListener webVttCueListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_WebVttParser$__constructor__(android.media.WebVttCueListener ), this, webVttCueListener);
    }

    public static float parseFloatPercentage(String string2) throws NumberFormatException {
        return (float)InvokeDynamicSupport.bootstrapStatic("parseFloatPercentage", $$robo$$android_media_WebVttParser$parseFloatPercentage(java.lang.String ), (String)string2);
    }

    public static int parseIntPercentage(String string2) throws NumberFormatException {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseIntPercentage", $$robo$$android_media_WebVttParser$parseIntPercentage(java.lang.String ), (String)string2);
    }

    public static long parseTimestampMs(String string2) throws NumberFormatException {
        return (long)InvokeDynamicSupport.bootstrapStatic("parseTimestampMs", $$robo$$android_media_WebVttParser$parseTimestampMs(java.lang.String ), (String)string2);
    }

    public static String timeToString(long l) {
        return InvokeDynamicSupport.bootstrapStatic("timeToString", $$robo$$android_media_WebVttParser$timeToString(long ), (long)l);
    }

    public void parse(String string2) {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_WebVttParser$parse(java.lang.String ), this, string2);
    }

    public void eos() {
        InvokeDynamicSupport.bootstrap("eos", $$robo$$android_media_WebVttParser$eos(), this);
    }

    public void yieldCue() {
        InvokeDynamicSupport.bootstrap("yieldCue", $$robo$$android_media_WebVttParser$yieldCue(), this);
    }

    private void log_warning(String string2, String string3, String string4, String string5, String string6) {
        InvokeDynamicSupport.bootstrap("log_warning", $$robo$$android_media_WebVttParser$log_warning(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5, string6);
    }

    private void log_warning(String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("log_warning", $$robo$$android_media_WebVttParser$log_warning(java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5);
    }

    private void log_warning(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("log_warning", $$robo$$android_media_WebVttParser$log_warning(java.lang.String java.lang.String ), this, string2, string3);
    }

    public /* synthetic */ WebVttParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebVttParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Phase {
        public void parse(String var1);
    }
}

