/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleTrack;
import android.media.TtmlCue;
import android.media.TtmlNode;
import android.media.TtmlNodeListener;
import android.media.TtmlParser;
import android.media.TtmlRenderingWidget;
import android.media.TtmlUtils;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class TtmlTrack
extends SubtitleTrack
implements TtmlNodeListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "TtmlTrack";
    private TtmlParser mParser;
    private TtmlRenderingWidget mRenderingWidget;
    private String mParsingData;
    private Long mCurrentRunID;
    private LinkedList<TtmlNode> mTtmlNodes;
    private TreeSet<Long> mTimeEvents;
    private TtmlNode mRootNode;

    private void $$robo$$android_media_TtmlTrack$__constructor__(TtmlRenderingWidget renderingWidget, MediaFormat format) {
        this.mParser = new TtmlParser(this);
        this.mTtmlNodes = new LinkedList();
        this.mTimeEvents = new TreeSet();
        this.mRenderingWidget = renderingWidget;
        this.mParsingData = "";
    }

    private final TtmlRenderingWidget $$robo$$android_media_TtmlTrack$getRenderingWidget() {
        return this.mRenderingWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_TtmlTrack$onData(byte[] data, boolean eos, long runID) {
        try {
            String str = new String(data, "UTF-8");
            TtmlParser ttmlParser = this.mParser;
            synchronized (ttmlParser) {
                if (this.mCurrentRunID != null && runID != this.mCurrentRunID) {
                    throw new IllegalStateException("Run #" + this.mCurrentRunID + " in progress.  Cannot process run #" + runID);
                }
                this.mCurrentRunID = runID;
                this.mParsingData = this.mParsingData + str;
                if (eos) {
                    try {
                        this.mParser.parse(this.mParsingData, this.mCurrentRunID);
                    }
                    catch (XmlPullParserException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.finishedRun(runID);
                    this.mParsingData = "";
                    this.mCurrentRunID = null;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.w("TtmlTrack", "subtitle data is not UTF-8 encoded: " + e);
        }
    }

    private final void $$robo$$android_media_TtmlTrack$onTtmlNodeParsed(TtmlNode node) {
        this.mTtmlNodes.addLast(node);
        this.addTimeEvents(node);
    }

    private final void $$robo$$android_media_TtmlTrack$onRootNodeParsed(TtmlNode node) {
        this.mRootNode = node;
        TtmlCue cue = null;
        while ((cue = this.getNextResult()) != null) {
            this.addCue(cue);
        }
        this.mRootNode = null;
        this.mTtmlNodes.clear();
        this.mTimeEvents.clear();
    }

    private final void $$robo$$android_media_TtmlTrack$updateView(Vector<SubtitleTrack.Cue> activeCues) {
        if (!this.mVisible) {
            return;
        }
        if (this.DEBUG && this.mTimeProvider != null) {
            try {
                Log.d("TtmlTrack", "at " + this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L + " ms the active cues are:");
            }
            catch (IllegalStateException e) {
                Log.d("TtmlTrack", "at (illegal state) the active cues are:");
            }
        }
        this.mRenderingWidget.setActiveCues(activeCues);
    }

    private final TtmlCue $$robo$$android_media_TtmlTrack$getNextResult() {
        while (this.mTimeEvents.size() >= 2) {
            long end;
            long start = this.mTimeEvents.pollFirst();
            List<TtmlNode> activeCues = this.getActiveNodes(start, end = this.mTimeEvents.first().longValue());
            if (activeCues.isEmpty()) continue;
            return new TtmlCue(start, end, TtmlUtils.applySpacePolicy(TtmlUtils.extractText(this.mRootNode, start, end), false), TtmlUtils.extractTtmlFragment(this.mRootNode, start, end));
        }
        return null;
    }

    private final void $$robo$$android_media_TtmlTrack$addTimeEvents(TtmlNode node) {
        this.mTimeEvents.add(node.mStartTimeMs);
        this.mTimeEvents.add(node.mEndTimeMs);
        for (int i = 0; i < node.mChildren.size(); ++i) {
            this.addTimeEvents(node.mChildren.get(i));
        }
    }

    private final List<TtmlNode> $$robo$$android_media_TtmlTrack$getActiveNodes(long startTimeUs, long endTimeUs) {
        ArrayList<TtmlNode> activeNodes = new ArrayList<TtmlNode>();
        for (int i = 0; i < this.mTtmlNodes.size(); ++i) {
            TtmlNode node = this.mTtmlNodes.get(i);
            if (!node.isActive(startTimeUs, endTimeUs)) continue;
            activeNodes.add(node);
        }
        return activeNodes;
    }

    private void __constructor__(TtmlRenderingWidget ttmlRenderingWidget, MediaFormat mediaFormat) {
        this.$$robo$$android_media_TtmlTrack$__constructor__(ttmlRenderingWidget, mediaFormat);
    }

    public TtmlTrack(TtmlRenderingWidget ttmlRenderingWidget, MediaFormat mediaFormat) {
        super(mediaFormat);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TtmlTrack$__constructor__(android.media.TtmlRenderingWidget android.media.MediaFormat ), this, ttmlRenderingWidget, mediaFormat);
    }

    @Override
    public TtmlRenderingWidget getRenderingWidget() {
        return InvokeDynamicSupport.bootstrap("getRenderingWidget", $$robo$$android_media_TtmlTrack$getRenderingWidget(), this);
    }

    @Override
    public void onData(byte[] byArray, boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("onData", $$robo$$android_media_TtmlTrack$onData(byte[] boolean long ), this, byArray, bl, l);
    }

    @Override
    public void onTtmlNodeParsed(TtmlNode ttmlNode) {
        InvokeDynamicSupport.bootstrap("onTtmlNodeParsed", $$robo$$android_media_TtmlTrack$onTtmlNodeParsed(android.media.TtmlNode ), this, ttmlNode);
    }

    @Override
    public void onRootNodeParsed(TtmlNode ttmlNode) {
        InvokeDynamicSupport.bootstrap("onRootNodeParsed", $$robo$$android_media_TtmlTrack$onRootNodeParsed(android.media.TtmlNode ), this, ttmlNode);
    }

    @Override
    public void updateView(Vector<SubtitleTrack.Cue> vector) {
        InvokeDynamicSupport.bootstrap("updateView", $$robo$$android_media_TtmlTrack$updateView(java.util.Vector<android.media.SubtitleTrack$Cue> ), this, vector);
    }

    public TtmlCue getNextResult() {
        return InvokeDynamicSupport.bootstrap("getNextResult", $$robo$$android_media_TtmlTrack$getNextResult(), this);
    }

    private void addTimeEvents(TtmlNode ttmlNode) {
        InvokeDynamicSupport.bootstrap("addTimeEvents", $$robo$$android_media_TtmlTrack$addTimeEvents(android.media.TtmlNode ), this, ttmlNode);
    }

    private List<TtmlNode> getActiveNodes(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("getActiveNodes", $$robo$$android_media_TtmlTrack$getActiveNodes(long long ), this, l, l2);
    }

    public /* synthetic */ TtmlTrack() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TtmlTrack)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

