/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.PlayerBase;
import android.media.VolumeShaper;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SoundPool
extends PlayerBase
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int SAMPLE_LOADED = 1;
    private static String TAG = "SoundPool";
    private static boolean DEBUG;
    private long mNativeContext;
    private EventHandler mEventHandler;
    private OnLoadCompleteListener mOnLoadCompleteListener;
    private boolean mHasAppOpsPlayAudio;
    private Object mLock;
    private AudioAttributes mAttributes;

    private void $$robo$$android_media_SoundPool$__constructor__(int maxStreams, int streamType, int srcQuality) {
        PlayerBase.deprecateStreamTypeForPlayback(streamType, "SoundPool", "SoundPool()");
    }

    private void $$robo$$android_media_SoundPool$__constructor__(int maxStreams, AudioAttributes attributes) {
        if (this.native_setup(new WeakReference<SoundPool>(this), maxStreams, attributes) != 0) {
            throw new RuntimeException("Native setup failed");
        }
        this.mLock = new Object();
        this.mAttributes = attributes;
        this.baseRegisterPlayer();
    }

    private final void $$robo$$android_media_SoundPool$release() {
        this.baseRelease();
        this.native_release();
    }

    private final void $$robo$$android_media_SoundPool$native_release() {
    }

    private final void $$robo$$android_media_SoundPool$finalize() {
        this.release();
    }

    private final int $$robo$$android_media_SoundPool$load(String path, int priority) {
        int id2 = 0;
        try {
            File f = new File(path);
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
            if (fd != null) {
                id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                fd.close();
            }
        }
        catch (IOException e) {
            Log.e("SoundPool", "error loading " + path);
        }
        return id2;
    }

    private final int $$robo$$android_media_SoundPool$load(Context context, int resId, int priority) {
        AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
        int id2 = 0;
        if (afd != null) {
            id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
            try {
                afd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return id2;
    }

    private final int $$robo$$android_media_SoundPool$load(AssetFileDescriptor afd, int priority) {
        if (afd != null) {
            long len = afd.getLength();
            if (len < 0L) {
                throw new AndroidRuntimeException("no length for fd");
            }
            return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
        }
        return 0;
    }

    private final int $$robo$$android_media_SoundPool$load(FileDescriptor fd, long offset, long length, int priority) {
        return this._load(fd, offset, length, priority);
    }

    private final boolean $$robo$$android_media_SoundPool$unload(int n) {
        return false;
    }

    private final int $$robo$$android_media_SoundPool$play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        this.baseStart();
        return this._play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    private final void $$robo$$android_media_SoundPool$pause(int n) {
    }

    private final void $$robo$$android_media_SoundPool$resume(int n) {
    }

    private final void $$robo$$android_media_SoundPool$autoPause() {
    }

    private final void $$robo$$android_media_SoundPool$autoResume() {
    }

    private final void $$robo$$android_media_SoundPool$stop(int n) {
    }

    private final void $$robo$$android_media_SoundPool$setVolume(int streamID, float leftVolume, float rightVolume) {
        this._setVolume(streamID, leftVolume, rightVolume);
    }

    private final int $$robo$$android_media_SoundPool$playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return -1;
    }

    private final VolumeShaper.State $$robo$$android_media_SoundPool$playerGetVolumeShaperState(int id2) {
        return null;
    }

    private final void $$robo$$android_media_SoundPool$playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        this._mute(muting);
    }

    private final int $$robo$$android_media_SoundPool$playerSetAuxEffectSendLevel(boolean muting, float level) {
        return 0;
    }

    private final void $$robo$$android_media_SoundPool$playerStart() {
    }

    private final void $$robo$$android_media_SoundPool$playerPause() {
    }

    private final void $$robo$$android_media_SoundPool$playerStop() {
    }

    private final void $$robo$$android_media_SoundPool$setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    private final void $$robo$$android_media_SoundPool$setPriority(int n, int n2) {
    }

    private final void $$robo$$android_media_SoundPool$setLoop(int n, int n2) {
    }

    private final void $$robo$$android_media_SoundPool$setRate(int n, float f) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_SoundPool$setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper;
            this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null)) : null;
            this.mOnLoadCompleteListener = listener;
        }
    }

    private final int $$robo$$android_media_SoundPool$_load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return 0;
    }

    private final int $$robo$$android_media_SoundPool$native_setup(Object object, int n, Object object2) {
        return 0;
    }

    private final int $$robo$$android_media_SoundPool$_play(int n, float f, float f2, int n2, int n3, float f3) {
        return 0;
    }

    private final void $$robo$$android_media_SoundPool$_setVolume(int n, float f, float f2) {
    }

    private final void $$robo$$android_media_SoundPool$_mute(boolean bl) {
    }

    private static final void $$robo$$android_media_SoundPool$postEventFromNative(Object ref, int msg, int arg1, int arg2, Object obj) {
        SoundPool soundPool = (SoundPool)((WeakReference)ref).get();
        if (soundPool == null) {
            return;
        }
        if (soundPool.mEventHandler != null) {
            Message m = soundPool.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
            soundPool.mEventHandler.sendMessage(m);
        }
    }

    private /* synthetic */ void $$robo$$android_media_SoundPool$__constructor__(int x0, AudioAttributes x1, 1 x2) {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"soundpool");
        DEBUG = Log.isLoggable("SoundPool", 3);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, n2, n3);
    }

    public SoundPool(int n, int n2, int n3) {
        this(n, new AudioAttributes.Builder().setInternalLegacyStreamType(n2).build());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int int int ), this, n, n2, n3);
    }

    private void __constructor__(int n, AudioAttributes audioAttributes) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, audioAttributes);
    }

    public SoundPool(int n, AudioAttributes audioAttributes) {
        super(audioAttributes, 3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int android.media.AudioAttributes ), this, n, audioAttributes);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_SoundPool$release(), this);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_SoundPool$native_release(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_SoundPool$finalize(), this);
    }

    public int load(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(java.lang.String int ), this, string2, n);
    }

    public int load(Context context, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(android.content.Context int int ), this, context, n, n2);
    }

    public int load(AssetFileDescriptor assetFileDescriptor, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(android.content.res.AssetFileDescriptor int ), this, assetFileDescriptor, n);
    }

    public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(java.io.FileDescriptor long long int ), this, fileDescriptor, l, l2, n);
    }

    public boolean unload(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("unload", $$robo$$android_media_SoundPool$unload(int ), this, n);
    }

    public int play(int n, float f, float f2, int n2, int n3, float f3) {
        return (int)InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_SoundPool$play(int float float int int float ), this, n, f, f2, n2, n3, f3);
    }

    public void pause(int n) {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_SoundPool$pause(int ), this, n);
    }

    public void resume(int n) {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_media_SoundPool$resume(int ), this, n);
    }

    public void autoPause() {
        InvokeDynamicSupport.bootstrap("autoPause", $$robo$$android_media_SoundPool$autoPause(), this);
    }

    public void autoResume() {
        InvokeDynamicSupport.bootstrap("autoResume", $$robo$$android_media_SoundPool$autoResume(), this);
    }

    public void stop(int n) {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_SoundPool$stop(int ), this, n);
    }

    public void setVolume(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool$setVolume(int float float ), this, n, f, f2);
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return (int)InvokeDynamicSupport.bootstrap("playerApplyVolumeShaper", $$robo$$android_media_SoundPool$playerApplyVolumeShaper(android.media.VolumeShaper$Configuration android.media.VolumeShaper$Operation ), this, configuration, operation);
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int n) {
        return InvokeDynamicSupport.bootstrap("playerGetVolumeShaperState", $$robo$$android_media_SoundPool$playerGetVolumeShaperState(int ), this, n);
    }

    @Override
    void playerSetVolume(boolean bl, float f, float f2) {
        InvokeDynamicSupport.bootstrap("playerSetVolume", $$robo$$android_media_SoundPool$playerSetVolume(boolean float float ), this, bl, f, f2);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean bl, float f) {
        return (int)InvokeDynamicSupport.bootstrap("playerSetAuxEffectSendLevel", $$robo$$android_media_SoundPool$playerSetAuxEffectSendLevel(boolean float ), this, bl, f);
    }

    @Override
    void playerStart() {
        InvokeDynamicSupport.bootstrap("playerStart", $$robo$$android_media_SoundPool$playerStart(), this);
    }

    @Override
    void playerPause() {
        InvokeDynamicSupport.bootstrap("playerPause", $$robo$$android_media_SoundPool$playerPause(), this);
    }

    @Override
    void playerStop() {
        InvokeDynamicSupport.bootstrap("playerStop", $$robo$$android_media_SoundPool$playerStop(), this);
    }

    public void setVolume(int n, float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool$setVolume(int float ), this, n, f);
    }

    public void setPriority(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_media_SoundPool$setPriority(int int ), this, n, n2);
    }

    public void setLoop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLoop", $$robo$$android_media_SoundPool$setLoop(int int ), this, n, n2);
    }

    public void setRate(int n, float f) {
        InvokeDynamicSupport.bootstrap("setRate", $$robo$$android_media_SoundPool$setRate(int float ), this, n, f);
    }

    public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
        InvokeDynamicSupport.bootstrap("setOnLoadCompleteListener", $$robo$$android_media_SoundPool$setOnLoadCompleteListener(android.media.SoundPool$OnLoadCompleteListener ), this, onLoadCompleteListener);
    }

    private int _load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("_load", $$robo$$android_media_SoundPool$_load(java.io.FileDescriptor long long int ), this, fileDescriptor, l, l2, n);
    }

    private int native_setup(Object object, int n, Object object2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_SoundPool$native_setup(java.lang.Object int java.lang.Object ), this, object, n, object2);
    }

    private int _play(int n, float f, float f2, int n2, int n3, float f3) {
        return (int)InvokeDynamicSupport.bootstrap("_play", $$robo$$android_media_SoundPool$_play(int float float int int float ), this, n, f, f2, n2, n3, f3);
    }

    private void _setVolume(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("_setVolume", $$robo$$android_media_SoundPool$_setVolume(int float float ), this, n, f, f2);
    }

    private void _mute(boolean bl) {
        InvokeDynamicSupport.bootstrap("_mute", $$robo$$android_media_SoundPool$_mute(boolean ), this, bl);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_SoundPool$postEventFromNative(java.lang.Object int int int java.lang.Object ), (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private /* synthetic */ void __constructor__(int n, AudioAttributes audioAttributes, 1 var3_3) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, audioAttributes, var3_3);
    }

    public /* synthetic */ SoundPool(int n, AudioAttributes audioAttributes, 1 var3_3) {
        this(n, audioAttributes);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int android.media.AudioAttributes android.media.SoundPool$1 ), this, n, audioAttributes, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(SoundPool.class);
    }

    public /* synthetic */ SoundPool() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPool)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mMaxStreams;
        private AudioAttributes mAudioAttributes;

        private void $$robo$$android_media_SoundPool_Builder$__constructor__() {
            this.mMaxStreams = 1;
        }

        private final Builder $$robo$$android_media_SoundPool_Builder$setMaxStreams(int maxStreams) throws IllegalArgumentException {
            if (maxStreams <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = maxStreams;
            return this;
        }

        private final Builder $$robo$$android_media_SoundPool_Builder$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = attributes;
            return this;
        }

        private final SoundPool $$robo$$android_media_SoundPool_Builder$build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes, null);
        }

        private void __constructor__() {
            this.$$robo$$android_media_SoundPool_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_Builder$__constructor__(), this);
        }

        public Builder setMaxStreams(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setMaxStreams", $$robo$$android_media_SoundPool_Builder$setMaxStreams(int ), this, n);
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_SoundPool_Builder$setAudioAttributes(android.media.AudioAttributes ), this, audioAttributes);
        }

        public SoundPool build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_SoundPool_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class EventHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ SoundPool this$0;

        private void $$robo$$android_media_SoundPool_EventHandler$__constructor__(SoundPool soundPool, Looper looper) {
            this.this$0 = soundPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_SoundPool_EventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (DEBUG) {
                        Log.d("SoundPool", "Sample " + msg.arg1 + " loaded");
                    }
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (this.this$0.mOnLoadCompleteListener != null) {
                            this.this$0.mOnLoadCompleteListener.onLoadComplete(this.this$0, msg.arg1, msg.arg2);
                        }
                        break;
                    }
                }
                default: {
                    Log.e("SoundPool", "Unknown message type " + msg.what);
                    return;
                }
            }
        }

        private void __constructor__(SoundPool soundPool, Looper looper) {
            this.$$robo$$android_media_SoundPool_EventHandler$__constructor__(soundPool, looper);
        }

        public EventHandler(SoundPool soundPool, Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_EventHandler$__constructor__(android.media.SoundPool android.os.Looper ), this, soundPool, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_SoundPool_EventHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

