/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.hardware.display.WifiDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioRoutesInfo;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IMediaRouterClient;
import android.media.IMediaRouterService;
import android.media.IRemoteVolumeObserver;
import android.media.MediaRouterClientState;
import android.media.RemoteControlClient;
import android.media.VolumeProvider;
import android.media.session.MediaSession;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaRouter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaRouter";
    private static boolean DEBUG;
    static Static sStatic;
    public static int ROUTE_TYPE_LIVE_AUDIO = 1;
    public static int ROUTE_TYPE_LIVE_VIDEO = 2;
    public static int ROUTE_TYPE_REMOTE_DISPLAY = 4;
    public static int ROUTE_TYPE_USER = 0x800000;
    static int ROUTE_TYPE_ANY = 0x800007;
    public static int CALLBACK_FLAG_PERFORM_ACTIVE_SCAN = 1;
    public static int CALLBACK_FLAG_UNFILTERED_EVENTS = 2;
    public static int CALLBACK_FLAG_REQUEST_DISCOVERY = 4;
    public static int CALLBACK_FLAG_PASSIVE_DISCOVERY = 8;
    public static int AVAILABILITY_FLAG_IGNORE_DEFAULT_ROUTE = 1;
    static HashMap<Context, MediaRouter> sRouters;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final String $$robo$$android_media_MediaRouter$typesToString(int types) {
        StringBuilder result = new StringBuilder();
        if ((types & 1) != 0) {
            result.append("ROUTE_TYPE_LIVE_AUDIO ");
        }
        if ((types & 2) != 0) {
            result.append("ROUTE_TYPE_LIVE_VIDEO ");
        }
        if ((types & 4) != 0) {
            result.append("ROUTE_TYPE_REMOTE_DISPLAY ");
        }
        if ((types & 0x800000) != 0) {
            result.append("ROUTE_TYPE_USER ");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_media_MediaRouter$__constructor__(Context context) {
        Class<Static> clazz = Static.class;
        synchronized (Static.class) {
            if (sStatic == null) {
                Context appContext = context.getApplicationContext();
                sStatic = new Static(appContext);
                sStatic.startMonitoringRoutes(appContext);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final RouteInfo $$robo$$android_media_MediaRouter$getDefaultRoute() {
        return MediaRouter.sStatic.mDefaultAudioVideo;
    }

    private final RouteInfo $$robo$$android_media_MediaRouter$getFallbackRoute() {
        return MediaRouter.sStatic.mBluetoothA2dpRoute != null ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo;
    }

    private final RouteCategory $$robo$$android_media_MediaRouter$getSystemCategory() {
        return MediaRouter.sStatic.mSystemCategory;
    }

    private final RouteInfo $$robo$$android_media_MediaRouter$getSelectedRoute() {
        return this.getSelectedRoute(0x800007);
    }

    private final RouteInfo $$robo$$android_media_MediaRouter$getSelectedRoute(int type) {
        if (MediaRouter.sStatic.mSelectedRoute != null && (MediaRouter.sStatic.mSelectedRoute.mSupportedTypes & type) != 0) {
            return MediaRouter.sStatic.mSelectedRoute;
        }
        if (type == 0x800000) {
            return null;
        }
        return MediaRouter.sStatic.mDefaultAudioVideo;
    }

    private final boolean $$robo$$android_media_MediaRouter$isRouteAvailable(int types, int flags) {
        int count = MediaRouter.sStatic.mRoutes.size();
        for (int i = 0; i < count; ++i) {
            RouteInfo route = MediaRouter.sStatic.mRoutes.get(i);
            if (!route.matchesTypes(types) || (flags & 1) != 0 && route == MediaRouter.sStatic.mDefaultAudioVideo) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_media_MediaRouter$addCallback(int types, Callback cb) {
        this.addCallback(types, cb, 0);
    }

    private final void $$robo$$android_media_MediaRouter$addCallback(int types, Callback cb, int flags) {
        int index = this.findCallbackInfo(cb);
        if (index >= 0) {
            CallbackInfo info = MediaRouter.sStatic.mCallbacks.get(index);
            info.type |= types;
            info.flags |= flags;
        } else {
            CallbackInfo info = new CallbackInfo(cb, types, flags, this);
            MediaRouter.sStatic.mCallbacks.add(info);
        }
        sStatic.updateDiscoveryRequest();
    }

    private final void $$robo$$android_media_MediaRouter$removeCallback(Callback cb) {
        int index = this.findCallbackInfo(cb);
        if (index >= 0) {
            MediaRouter.sStatic.mCallbacks.remove(index);
            sStatic.updateDiscoveryRequest();
        } else {
            Log.w("MediaRouter", "removeCallback(" + cb + "): callback not registered");
        }
    }

    private final int $$robo$$android_media_MediaRouter$findCallbackInfo(Callback cb) {
        int count = MediaRouter.sStatic.mCallbacks.size();
        for (int i = 0; i < count; ++i) {
            CallbackInfo info = MediaRouter.sStatic.mCallbacks.get(i);
            if (info.cb != cb) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_media_MediaRouter$selectRoute(int types, RouteInfo route) {
        if (route == null) {
            throw new IllegalArgumentException("Route cannot be null.");
        }
        MediaRouter.selectRouteStatic(types, route, true);
    }

    private final void $$robo$$android_media_MediaRouter$selectRouteInt(int types, RouteInfo route, boolean explicit) {
        MediaRouter.selectRouteStatic(types, route, explicit);
    }

    private static final void $$robo$$android_media_MediaRouter$selectRouteStatic(int types, RouteInfo route, boolean explicit) {
        boolean newRouteHasAddress;
        boolean wasDefaultOrBluetoothRoute;
        Log.v("MediaRouter", "Selecting route: " + route);
        if (!$assertionsDisabled && route == null) {
            throw new AssertionError();
        }
        RouteInfo oldRoute = MediaRouter.sStatic.mSelectedRoute;
        RouteInfo currentSystemRoute = sStatic.isBluetoothA2dpOn() ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo;
        boolean bl = wasDefaultOrBluetoothRoute = oldRoute == MediaRouter.sStatic.mDefaultAudioVideo || oldRoute == MediaRouter.sStatic.mBluetoothA2dpRoute;
        if (!(oldRoute != route || wasDefaultOrBluetoothRoute && route != currentSystemRoute)) {
            return;
        }
        if (!route.matchesTypes(types)) {
            Log.w("MediaRouter", "selectRoute ignored; cannot select route with supported types " + MediaRouter.typesToString(route.getSupportedTypes()) + " into route types " + MediaRouter.typesToString(types));
            return;
        }
        RouteInfo btRoute = MediaRouter.sStatic.mBluetoothA2dpRoute;
        if (sStatic.isPlaybackActive() && btRoute != null && (types & 1) != 0 && (route == btRoute || route == MediaRouter.sStatic.mDefaultAudioVideo)) {
            try {
                MediaRouter.sStatic.mAudioService.setBluetoothA2dpOn(route == btRoute);
                if (route != btRoute) {
                    StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 3; i < callStack.length; ++i) {
                        StackTraceElement caller = callStack[i];
                        sb.append(caller.getClassName() + "." + caller.getMethodName() + ":" + caller.getLineNumber()).append("  ");
                    }
                    Log.w("MediaRouter", "Default route is selected while a BT route is available: pkgName=" + MediaRouter.sStatic.mPackageName + ", callers=" + sb.toString());
                }
            }
            catch (RemoteException e) {
                Log.e("MediaRouter", "Error changing Bluetooth A2DP state", e);
            }
        }
        WifiDisplay activeDisplay = MediaRouter.sStatic.mDisplayService.getWifiDisplayStatus().getActiveDisplay();
        boolean oldRouteHasAddress = oldRoute != null && oldRoute.mDeviceAddress != null;
        boolean bl2 = newRouteHasAddress = route.mDeviceAddress != null;
        if (activeDisplay != null || oldRouteHasAddress || newRouteHasAddress) {
            if (newRouteHasAddress && !MediaRouter.matchesDeviceAddress(activeDisplay, route)) {
                if (MediaRouter.sStatic.mCanConfigureWifiDisplays) {
                    MediaRouter.sStatic.mDisplayService.connectWifiDisplay(route.mDeviceAddress);
                } else {
                    Log.e("MediaRouter", "Cannot connect to wifi displays because this process is not allowed to do so.");
                }
            } else if (activeDisplay != null && !newRouteHasAddress) {
                MediaRouter.sStatic.mDisplayService.disconnectWifiDisplay();
            }
        }
        sStatic.setSelectedRoute(route, explicit);
        if (oldRoute != null) {
            MediaRouter.dispatchRouteUnselected(types & oldRoute.getSupportedTypes(), oldRoute);
            if (oldRoute.resolveStatusCode()) {
                MediaRouter.dispatchRouteChanged(oldRoute);
            }
        }
        if (route != null) {
            if (route.resolveStatusCode()) {
                MediaRouter.dispatchRouteChanged(route);
            }
            MediaRouter.dispatchRouteSelected(types & route.getSupportedTypes(), route);
        }
        sStatic.updateDiscoveryRequest();
    }

    private static final void $$robo$$android_media_MediaRouter$selectDefaultRouteStatic() {
        if (MediaRouter.sStatic.mSelectedRoute != MediaRouter.sStatic.mBluetoothA2dpRoute && sStatic.isBluetoothA2dpOn()) {
            MediaRouter.selectRouteStatic(0x800007, MediaRouter.sStatic.mBluetoothA2dpRoute, false);
        } else {
            MediaRouter.selectRouteStatic(0x800007, MediaRouter.sStatic.mDefaultAudioVideo, false);
        }
    }

    private static final boolean $$robo$$android_media_MediaRouter$matchesDeviceAddress(WifiDisplay display, RouteInfo info) {
        boolean routeHasAddress;
        boolean bl = routeHasAddress = info != null && info.mDeviceAddress != null;
        if (display == null && !routeHasAddress) {
            return true;
        }
        if (display != null && routeHasAddress) {
            return display.getDeviceAddress().equals(info.mDeviceAddress);
        }
        return false;
    }

    private final void $$robo$$android_media_MediaRouter$addUserRoute(UserRouteInfo info) {
        MediaRouter.addRouteStatic(info);
    }

    private final void $$robo$$android_media_MediaRouter$addRouteInt(RouteInfo info) {
        MediaRouter.addRouteStatic(info);
    }

    private static final void $$robo$$android_media_MediaRouter$addRouteStatic(RouteInfo info) {
        Log.v("MediaRouter", "Adding route: " + info);
        RouteCategory cat = info.getCategory();
        if (!MediaRouter.sStatic.mCategories.contains(cat)) {
            MediaRouter.sStatic.mCategories.add(cat);
        }
        if (cat.isGroupable() && !(info instanceof RouteGroup)) {
            RouteGroup group = new RouteGroup(info.getCategory());
            group.mSupportedTypes = info.mSupportedTypes;
            MediaRouter.sStatic.mRoutes.add(group);
            MediaRouter.dispatchRouteAdded(group);
            group.addRoute(info);
            info = group;
        } else {
            MediaRouter.sStatic.mRoutes.add(info);
            MediaRouter.dispatchRouteAdded(info);
        }
    }

    private final void $$robo$$android_media_MediaRouter$removeUserRoute(UserRouteInfo info) {
        MediaRouter.removeRouteStatic(info);
    }

    private final void $$robo$$android_media_MediaRouter$clearUserRoutes() {
        for (int i = 0; i < MediaRouter.sStatic.mRoutes.size(); ++i) {
            RouteInfo info = MediaRouter.sStatic.mRoutes.get(i);
            if (!(info instanceof UserRouteInfo) && !(info instanceof RouteGroup)) continue;
            MediaRouter.removeRouteStatic(info);
            --i;
        }
    }

    private final void $$robo$$android_media_MediaRouter$removeRouteInt(RouteInfo info) {
        MediaRouter.removeRouteStatic(info);
    }

    private static final void $$robo$$android_media_MediaRouter$removeRouteStatic(RouteInfo info) {
        Log.v("MediaRouter", "Removing route: " + info);
        if (MediaRouter.sStatic.mRoutes.remove(info)) {
            RouteCategory removingCat = info.getCategory();
            int count = MediaRouter.sStatic.mRoutes.size();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                RouteCategory cat = MediaRouter.sStatic.mRoutes.get(i).getCategory();
                if (removingCat != cat) continue;
                found = true;
                break;
            }
            if (info.isSelected()) {
                MediaRouter.selectDefaultRouteStatic();
            }
            if (!found) {
                MediaRouter.sStatic.mCategories.remove(removingCat);
            }
            MediaRouter.dispatchRouteRemoved(info);
        }
    }

    private final int $$robo$$android_media_MediaRouter$getCategoryCount() {
        return MediaRouter.sStatic.mCategories.size();
    }

    private final RouteCategory $$robo$$android_media_MediaRouter$getCategoryAt(int index) {
        return MediaRouter.sStatic.mCategories.get(index);
    }

    private final int $$robo$$android_media_MediaRouter$getRouteCount() {
        return MediaRouter.sStatic.mRoutes.size();
    }

    private final RouteInfo $$robo$$android_media_MediaRouter$getRouteAt(int index) {
        return MediaRouter.sStatic.mRoutes.get(index);
    }

    private static final int $$robo$$android_media_MediaRouter$getRouteCountStatic() {
        return MediaRouter.sStatic.mRoutes.size();
    }

    private static final RouteInfo $$robo$$android_media_MediaRouter$getRouteAtStatic(int index) {
        return MediaRouter.sStatic.mRoutes.get(index);
    }

    private final UserRouteInfo $$robo$$android_media_MediaRouter$createUserRoute(RouteCategory category) {
        return new UserRouteInfo(category);
    }

    private final RouteCategory $$robo$$android_media_MediaRouter$createRouteCategory(CharSequence name, boolean isGroupable) {
        return new RouteCategory(name, 0x800000, isGroupable);
    }

    private final RouteCategory $$robo$$android_media_MediaRouter$createRouteCategory(int nameResId, boolean isGroupable) {
        return new RouteCategory(nameResId, 0x800000, isGroupable);
    }

    private final void $$robo$$android_media_MediaRouter$rebindAsUser(int userId) {
        sStatic.rebindAsUser(userId);
    }

    private static final void $$robo$$android_media_MediaRouter$updateRoute(RouteInfo info) {
        MediaRouter.dispatchRouteChanged(info);
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteSelected(int type, RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteSelected(cbi.router, type, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteUnselected(int type, RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteUnselected(cbi.router, type, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteChanged(RouteInfo info) {
        MediaRouter.dispatchRouteChanged(info, info.mSupportedTypes);
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteChanged(RouteInfo info, int oldSupportedTypes) {
        if (DEBUG) {
            Log.d("MediaRouter", "Dispatching route change: " + info);
        }
        int newSupportedTypes = info.mSupportedTypes;
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            boolean oldVisibility = cbi.filterRouteEvent(oldSupportedTypes);
            boolean newVisibility = cbi.filterRouteEvent(newSupportedTypes);
            if (!oldVisibility && newVisibility) {
                cbi.cb.onRouteAdded(cbi.router, info);
                if (info.isSelected()) {
                    cbi.cb.onRouteSelected(cbi.router, newSupportedTypes, info);
                }
            }
            if (oldVisibility || newVisibility) {
                cbi.cb.onRouteChanged(cbi.router, info);
            }
            if (!oldVisibility || newVisibility) continue;
            if (info.isSelected()) {
                cbi.cb.onRouteUnselected(cbi.router, oldSupportedTypes, info);
            }
            cbi.cb.onRouteRemoved(cbi.router, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteAdded(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteAdded(cbi.router, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteRemoved(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteRemoved(cbi.router, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteGrouped(RouteInfo info, RouteGroup group, int index) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(group)) continue;
            cbi.cb.onRouteGrouped(cbi.router, info, group, index);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteUngrouped(RouteInfo info, RouteGroup group) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(group)) continue;
            cbi.cb.onRouteUngrouped(cbi.router, info, group);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRouteVolumeChanged(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRouteVolumeChanged(cbi.router, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$dispatchRoutePresentationDisplayChanged(RouteInfo info) {
        for (CallbackInfo cbi : MediaRouter.sStatic.mCallbacks) {
            if (!cbi.filterRouteEvent(info)) continue;
            cbi.cb.onRoutePresentationDisplayChanged(cbi.router, info);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$systemVolumeChanged(int newValue) {
        RouteInfo selectedRoute = MediaRouter.sStatic.mSelectedRoute;
        if (selectedRoute == null) {
            return;
        }
        if (selectedRoute == MediaRouter.sStatic.mBluetoothA2dpRoute || selectedRoute == MediaRouter.sStatic.mDefaultAudioVideo) {
            MediaRouter.dispatchRouteVolumeChanged(selectedRoute);
        } else if (MediaRouter.sStatic.mBluetoothA2dpRoute != null) {
            try {
                MediaRouter.dispatchRouteVolumeChanged(MediaRouter.sStatic.mAudioService.isBluetoothA2dpOn() ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo);
            }
            catch (RemoteException e) {
                Log.e("MediaRouter", "Error checking Bluetooth A2DP state to report volume change", e);
            }
        } else {
            MediaRouter.dispatchRouteVolumeChanged(MediaRouter.sStatic.mDefaultAudioVideo);
        }
    }

    private static final void $$robo$$android_media_MediaRouter$updateWifiDisplayStatus(WifiDisplayStatus status) {
        int i;
        WifiDisplay activeDisplay;
        WifiDisplay[] displays;
        if (status.getFeatureState() == 3) {
            displays = status.getDisplays();
            activeDisplay = status.getActiveDisplay();
            if (!MediaRouter.sStatic.mCanConfigureWifiDisplays) {
                displays = activeDisplay != null ? new WifiDisplay[]{activeDisplay} : WifiDisplay.EMPTY_ARRAY;
            }
        } else {
            displays = WifiDisplay.EMPTY_ARRAY;
            activeDisplay = null;
        }
        String activeDisplayAddress = activeDisplay != null ? activeDisplay.getDeviceAddress() : null;
        for (i = 0; i < displays.length; ++i) {
            WifiDisplay d = displays[i];
            if (!MediaRouter.shouldShowWifiDisplay(d, activeDisplay)) continue;
            RouteInfo route = MediaRouter.findWifiDisplayRoute(d);
            if (route == null) {
                route = MediaRouter.makeWifiDisplayRoute(d, status);
                MediaRouter.addRouteStatic(route);
            } else {
                String address = d.getDeviceAddress();
                boolean disconnected = !address.equals(activeDisplayAddress) && address.equals(MediaRouter.sStatic.mPreviousActiveWifiDisplayAddress);
                MediaRouter.updateWifiDisplayRoute(route, d, status, disconnected);
            }
            if (!d.equals(activeDisplay)) continue;
            MediaRouter.selectRouteStatic(route.getSupportedTypes(), route, false);
        }
        i = MediaRouter.sStatic.mRoutes.size();
        while (i-- > 0) {
            WifiDisplay d;
            RouteInfo route = MediaRouter.sStatic.mRoutes.get(i);
            if (route.mDeviceAddress == null || (d = MediaRouter.findWifiDisplay(displays, route.mDeviceAddress)) != null && MediaRouter.shouldShowWifiDisplay(d, activeDisplay)) continue;
            MediaRouter.removeRouteStatic(route);
        }
        MediaRouter.sStatic.mPreviousActiveWifiDisplayAddress = activeDisplayAddress;
    }

    private static final boolean $$robo$$android_media_MediaRouter$shouldShowWifiDisplay(WifiDisplay d, WifiDisplay activeDisplay) {
        return d.isRemembered() || d.equals(activeDisplay);
    }

    private static final int $$robo$$android_media_MediaRouter$getWifiDisplayStatusCode(WifiDisplay d, WifiDisplayStatus wfdStatus) {
        int newStatus = wfdStatus.getScanState() == 1 ? 1 : (d.isAvailable() ? (d.canConnect() ? 3 : 5) : 4);
        if (d.equals(wfdStatus.getActiveDisplay())) {
            int activeState = wfdStatus.getActiveDisplayState();
            switch (activeState) {
                case 2: {
                    newStatus = 6;
                    break;
                }
                case 1: {
                    newStatus = 2;
                    break;
                }
                case 0: {
                    Log.e("MediaRouter", "Active display is not connected!");
                }
            }
        }
        return newStatus;
    }

    private static final boolean $$robo$$android_media_MediaRouter$isWifiDisplayEnabled(WifiDisplay d, WifiDisplayStatus wfdStatus) {
        return d.isAvailable() && (d.canConnect() || d.equals(wfdStatus.getActiveDisplay()));
    }

    private static final RouteInfo $$robo$$android_media_MediaRouter$makeWifiDisplayRoute(WifiDisplay display, WifiDisplayStatus wfdStatus) {
        RouteInfo newRoute = new RouteInfo(MediaRouter.sStatic.mSystemCategory);
        newRoute.mDeviceAddress = display.getDeviceAddress();
        newRoute.mSupportedTypes = 7;
        newRoute.mVolumeHandling = 0;
        newRoute.mPlaybackType = 1;
        newRoute.setRealStatusCode(MediaRouter.getWifiDisplayStatusCode(display, wfdStatus));
        newRoute.mEnabled = MediaRouter.isWifiDisplayEnabled(display, wfdStatus);
        newRoute.mName = display.getFriendlyDisplayName();
        newRoute.mDescription = MediaRouter.sStatic.mResources.getText(17041129);
        newRoute.updatePresentationDisplay();
        newRoute.mDeviceType = 1;
        return newRoute;
    }

    private static final void $$robo$$android_media_MediaRouter$updateWifiDisplayRoute(RouteInfo route, WifiDisplay display, WifiDisplayStatus wfdStatus, boolean disconnected) {
        boolean enabled;
        boolean changed = false;
        String newName = display.getFriendlyDisplayName();
        if (!route.getName().equals(newName)) {
            route.mName = newName;
            changed = true;
        }
        changed |= route.mEnabled != (enabled = MediaRouter.isWifiDisplayEnabled(display, wfdStatus));
        route.mEnabled = enabled;
        if (changed |= route.setRealStatusCode(MediaRouter.getWifiDisplayStatusCode(display, wfdStatus))) {
            MediaRouter.dispatchRouteChanged(route);
        }
        if ((!enabled || disconnected) && route.isSelected()) {
            MediaRouter.selectDefaultRouteStatic();
        }
    }

    private static final WifiDisplay $$robo$$android_media_MediaRouter$findWifiDisplay(WifiDisplay[] displays, String deviceAddress) {
        for (int i = 0; i < displays.length; ++i) {
            WifiDisplay d = displays[i];
            if (!d.getDeviceAddress().equals(deviceAddress)) continue;
            return d;
        }
        return null;
    }

    private static final RouteInfo $$robo$$android_media_MediaRouter$findWifiDisplayRoute(WifiDisplay d) {
        int count = MediaRouter.sStatic.mRoutes.size();
        for (int i = 0; i < count; ++i) {
            RouteInfo info = MediaRouter.sStatic.mRoutes.get(i);
            if (!d.getDeviceAddress().equals(info.mDeviceAddress)) continue;
            return info;
        }
        return null;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !MediaRouter.class.desiredAssertionStatus();
        DEBUG = Log.isLoggable("MediaRouter", 3);
        sRouters = new HashMap();
    }

    static String typesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("typesToString", $$robo$$android_media_MediaRouter$typesToString(int ), (int)n);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_MediaRouter$__constructor__(context);
    }

    public MediaRouter(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter$__constructor__(android.content.Context ), this, context);
    }

    public RouteInfo getDefaultRoute() {
        return InvokeDynamicSupport.bootstrap("getDefaultRoute", $$robo$$android_media_MediaRouter$getDefaultRoute(), this);
    }

    public RouteInfo getFallbackRoute() {
        return InvokeDynamicSupport.bootstrap("getFallbackRoute", $$robo$$android_media_MediaRouter$getFallbackRoute(), this);
    }

    public RouteCategory getSystemCategory() {
        return InvokeDynamicSupport.bootstrap("getSystemCategory", $$robo$$android_media_MediaRouter$getSystemCategory(), this);
    }

    public RouteInfo getSelectedRoute() {
        return InvokeDynamicSupport.bootstrap("getSelectedRoute", $$robo$$android_media_MediaRouter$getSelectedRoute(), this);
    }

    public RouteInfo getSelectedRoute(int n) {
        return InvokeDynamicSupport.bootstrap("getSelectedRoute", $$robo$$android_media_MediaRouter$getSelectedRoute(int ), this, n);
    }

    public boolean isRouteAvailable(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRouteAvailable", $$robo$$android_media_MediaRouter$isRouteAvailable(int int ), this, n, n2);
    }

    public void addCallback(int n, Callback callback) {
        InvokeDynamicSupport.bootstrap("addCallback", $$robo$$android_media_MediaRouter$addCallback(int android.media.MediaRouter$Callback ), this, n, callback);
    }

    public void addCallback(int n, Callback callback, int n2) {
        InvokeDynamicSupport.bootstrap("addCallback", $$robo$$android_media_MediaRouter$addCallback(int android.media.MediaRouter$Callback int ), this, n, callback, n2);
    }

    public void removeCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_media_MediaRouter$removeCallback(android.media.MediaRouter$Callback ), this, callback);
    }

    private int findCallbackInfo(Callback callback) {
        return (int)InvokeDynamicSupport.bootstrap("findCallbackInfo", $$robo$$android_media_MediaRouter$findCallbackInfo(android.media.MediaRouter$Callback ), this, callback);
    }

    public void selectRoute(int n, RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrap("selectRoute", $$robo$$android_media_MediaRouter$selectRoute(int android.media.MediaRouter$RouteInfo ), this, n, routeInfo);
    }

    public void selectRouteInt(int n, RouteInfo routeInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("selectRouteInt", $$robo$$android_media_MediaRouter$selectRouteInt(int android.media.MediaRouter$RouteInfo boolean ), this, n, routeInfo, bl);
    }

    static void selectRouteStatic(int n, RouteInfo routeInfo, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("selectRouteStatic", $$robo$$android_media_MediaRouter$selectRouteStatic(int android.media.MediaRouter$RouteInfo boolean ), (int)n, (RouteInfo)routeInfo, (boolean)bl);
    }

    static void selectDefaultRouteStatic() {
        InvokeDynamicSupport.bootstrapStatic("selectDefaultRouteStatic", $$robo$$android_media_MediaRouter$selectDefaultRouteStatic());
    }

    static boolean matchesDeviceAddress(WifiDisplay wifiDisplay, RouteInfo routeInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchesDeviceAddress", $$robo$$android_media_MediaRouter$matchesDeviceAddress(android.hardware.display.WifiDisplay android.media.MediaRouter$RouteInfo ), (WifiDisplay)wifiDisplay, (RouteInfo)routeInfo);
    }

    public void addUserRoute(UserRouteInfo userRouteInfo) {
        InvokeDynamicSupport.bootstrap("addUserRoute", $$robo$$android_media_MediaRouter$addUserRoute(android.media.MediaRouter$UserRouteInfo ), this, userRouteInfo);
    }

    public void addRouteInt(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrap("addRouteInt", $$robo$$android_media_MediaRouter$addRouteInt(android.media.MediaRouter$RouteInfo ), this, routeInfo);
    }

    static void addRouteStatic(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("addRouteStatic", $$robo$$android_media_MediaRouter$addRouteStatic(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    public void removeUserRoute(UserRouteInfo userRouteInfo) {
        InvokeDynamicSupport.bootstrap("removeUserRoute", $$robo$$android_media_MediaRouter$removeUserRoute(android.media.MediaRouter$UserRouteInfo ), this, userRouteInfo);
    }

    public void clearUserRoutes() {
        InvokeDynamicSupport.bootstrap("clearUserRoutes", $$robo$$android_media_MediaRouter$clearUserRoutes(), this);
    }

    public void removeRouteInt(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrap("removeRouteInt", $$robo$$android_media_MediaRouter$removeRouteInt(android.media.MediaRouter$RouteInfo ), this, routeInfo);
    }

    static void removeRouteStatic(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("removeRouteStatic", $$robo$$android_media_MediaRouter$removeRouteStatic(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    public int getCategoryCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCategoryCount", $$robo$$android_media_MediaRouter$getCategoryCount(), this);
    }

    public RouteCategory getCategoryAt(int n) {
        return InvokeDynamicSupport.bootstrap("getCategoryAt", $$robo$$android_media_MediaRouter$getCategoryAt(int ), this, n);
    }

    public int getRouteCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRouteCount", $$robo$$android_media_MediaRouter$getRouteCount(), this);
    }

    public RouteInfo getRouteAt(int n) {
        return InvokeDynamicSupport.bootstrap("getRouteAt", $$robo$$android_media_MediaRouter$getRouteAt(int ), this, n);
    }

    static int getRouteCountStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRouteCountStatic", $$robo$$android_media_MediaRouter$getRouteCountStatic());
    }

    static RouteInfo getRouteAtStatic(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRouteAtStatic", $$robo$$android_media_MediaRouter$getRouteAtStatic(int ), (int)n);
    }

    public UserRouteInfo createUserRoute(RouteCategory routeCategory) {
        return InvokeDynamicSupport.bootstrap("createUserRoute", $$robo$$android_media_MediaRouter$createUserRoute(android.media.MediaRouter$RouteCategory ), this, routeCategory);
    }

    public RouteCategory createRouteCategory(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createRouteCategory", $$robo$$android_media_MediaRouter$createRouteCategory(java.lang.CharSequence boolean ), this, charSequence, bl);
    }

    public RouteCategory createRouteCategory(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createRouteCategory", $$robo$$android_media_MediaRouter$createRouteCategory(int boolean ), this, n, bl);
    }

    public void rebindAsUser(int n) {
        InvokeDynamicSupport.bootstrap("rebindAsUser", $$robo$$android_media_MediaRouter$rebindAsUser(int ), this, n);
    }

    static void updateRoute(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("updateRoute", $$robo$$android_media_MediaRouter$updateRoute(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    static void dispatchRouteSelected(int n, RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteSelected", $$robo$$android_media_MediaRouter$dispatchRouteSelected(int android.media.MediaRouter$RouteInfo ), (int)n, (RouteInfo)routeInfo);
    }

    static void dispatchRouteUnselected(int n, RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteUnselected", $$robo$$android_media_MediaRouter$dispatchRouteUnselected(int android.media.MediaRouter$RouteInfo ), (int)n, (RouteInfo)routeInfo);
    }

    static void dispatchRouteChanged(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteChanged", $$robo$$android_media_MediaRouter$dispatchRouteChanged(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    static void dispatchRouteChanged(RouteInfo routeInfo, int n) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteChanged", $$robo$$android_media_MediaRouter$dispatchRouteChanged(android.media.MediaRouter$RouteInfo int ), (RouteInfo)routeInfo, (int)n);
    }

    static void dispatchRouteAdded(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteAdded", $$robo$$android_media_MediaRouter$dispatchRouteAdded(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    static void dispatchRouteRemoved(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteRemoved", $$robo$$android_media_MediaRouter$dispatchRouteRemoved(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    static void dispatchRouteGrouped(RouteInfo routeInfo, RouteGroup routeGroup, int n) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteGrouped", $$robo$$android_media_MediaRouter$dispatchRouteGrouped(android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup int ), (RouteInfo)routeInfo, (RouteGroup)routeGroup, (int)n);
    }

    static void dispatchRouteUngrouped(RouteInfo routeInfo, RouteGroup routeGroup) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteUngrouped", $$robo$$android_media_MediaRouter$dispatchRouteUngrouped(android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup ), (RouteInfo)routeInfo, (RouteGroup)routeGroup);
    }

    static void dispatchRouteVolumeChanged(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRouteVolumeChanged", $$robo$$android_media_MediaRouter$dispatchRouteVolumeChanged(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    static void dispatchRoutePresentationDisplayChanged(RouteInfo routeInfo) {
        InvokeDynamicSupport.bootstrapStatic("dispatchRoutePresentationDisplayChanged", $$robo$$android_media_MediaRouter$dispatchRoutePresentationDisplayChanged(android.media.MediaRouter$RouteInfo ), (RouteInfo)routeInfo);
    }

    static void systemVolumeChanged(int n) {
        InvokeDynamicSupport.bootstrapStatic("systemVolumeChanged", $$robo$$android_media_MediaRouter$systemVolumeChanged(int ), (int)n);
    }

    static void updateWifiDisplayStatus(WifiDisplayStatus wifiDisplayStatus) {
        InvokeDynamicSupport.bootstrapStatic("updateWifiDisplayStatus", $$robo$$android_media_MediaRouter$updateWifiDisplayStatus(android.hardware.display.WifiDisplayStatus ), (WifiDisplayStatus)wifiDisplayStatus);
    }

    private static boolean shouldShowWifiDisplay(WifiDisplay wifiDisplay, WifiDisplay wifiDisplay2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldShowWifiDisplay", $$robo$$android_media_MediaRouter$shouldShowWifiDisplay(android.hardware.display.WifiDisplay android.hardware.display.WifiDisplay ), (WifiDisplay)wifiDisplay, (WifiDisplay)wifiDisplay2);
    }

    static int getWifiDisplayStatusCode(WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getWifiDisplayStatusCode", $$robo$$android_media_MediaRouter$getWifiDisplayStatusCode(android.hardware.display.WifiDisplay android.hardware.display.WifiDisplayStatus ), (WifiDisplay)wifiDisplay, (WifiDisplayStatus)wifiDisplayStatus);
    }

    static boolean isWifiDisplayEnabled(WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWifiDisplayEnabled", $$robo$$android_media_MediaRouter$isWifiDisplayEnabled(android.hardware.display.WifiDisplay android.hardware.display.WifiDisplayStatus ), (WifiDisplay)wifiDisplay, (WifiDisplayStatus)wifiDisplayStatus);
    }

    static RouteInfo makeWifiDisplayRoute(WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus) {
        return InvokeDynamicSupport.bootstrapStatic("makeWifiDisplayRoute", $$robo$$android_media_MediaRouter$makeWifiDisplayRoute(android.hardware.display.WifiDisplay android.hardware.display.WifiDisplayStatus ), (WifiDisplay)wifiDisplay, (WifiDisplayStatus)wifiDisplayStatus);
    }

    private static void updateWifiDisplayRoute(RouteInfo routeInfo, WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("updateWifiDisplayRoute", $$robo$$android_media_MediaRouter$updateWifiDisplayRoute(android.media.MediaRouter$RouteInfo android.hardware.display.WifiDisplay android.hardware.display.WifiDisplayStatus boolean ), (RouteInfo)routeInfo, (WifiDisplay)wifiDisplay, (WifiDisplayStatus)wifiDisplayStatus, (boolean)bl);
    }

    private static WifiDisplay findWifiDisplay(WifiDisplay[] wifiDisplayArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findWifiDisplay", $$robo$$android_media_MediaRouter$findWifiDisplay(android.hardware.display.WifiDisplay[] java.lang.String ), (WifiDisplay[])wifiDisplayArray, (String)string2);
    }

    private static RouteInfo findWifiDisplayRoute(WifiDisplay wifiDisplay) {
        return InvokeDynamicSupport.bootstrapStatic("findWifiDisplayRoute", $$robo$$android_media_MediaRouter$findWifiDisplayRoute(android.hardware.display.WifiDisplay ), (WifiDisplay)wifiDisplay);
    }

    static {
        RobolectricInternals.classInitializing(MediaRouter.class);
    }

    public /* synthetic */ MediaRouter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class WifiDisplayStatusChangedReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaRouter_WifiDisplayStatusChangedReceiver$__constructor__() {
        }

        private final void $$robo$$android_media_MediaRouter_WifiDisplayStatusChangedReceiver$onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED")) {
                MediaRouter.updateWifiDisplayStatus((WifiDisplayStatus)intent.getParcelableExtra("android.hardware.display.extra.WIFI_DISPLAY_STATUS"));
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaRouter_WifiDisplayStatusChangedReceiver$__constructor__();
        }

        public WifiDisplayStatusChangedReceiver() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_WifiDisplayStatusChangedReceiver$__constructor__(), this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_media_MediaRouter_WifiDisplayStatusChangedReceiver$onReceive(android.content.Context android.content.Intent ), this, context, intent);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiDisplayStatusChangedReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VolumeChangeReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaRouter_VolumeChangeReceiver$__constructor__() {
        }

        private final void $$robo$$android_media_MediaRouter_VolumeChangeReceiver$onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.VOLUME_CHANGED_ACTION")) {
                int oldVolume;
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                if (streamType != 3) {
                    return;
                }
                int newVolume = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0);
                if (newVolume != (oldVolume = intent.getIntExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", 0))) {
                    MediaRouter.systemVolumeChanged(newVolume);
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaRouter_VolumeChangeReceiver$__constructor__();
        }

        public VolumeChangeReceiver() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_VolumeChangeReceiver$__constructor__(), this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_media_MediaRouter_VolumeChangeReceiver$onReceive(android.content.Context android.content.Intent ), this, context, intent);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeChangeReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class VolumeCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaRouter_VolumeCallback$__constructor__() {
        }

        public abstract void onVolumeUpdateRequest(RouteInfo var1, int var2);

        public abstract void onVolumeSetRequest(RouteInfo var1, int var2);

        private void __constructor__() {
            this.$$robo$$android_media_MediaRouter_VolumeCallback$__constructor__();
        }

        public VolumeCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_VolumeCallback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VolumeCallbackInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public VolumeCallback vcb;
        public RouteInfo route;

        private void $$robo$$android_media_MediaRouter_VolumeCallbackInfo$__constructor__(VolumeCallback vcb, RouteInfo route) {
            this.vcb = vcb;
            this.route = route;
        }

        private void __constructor__(VolumeCallback volumeCallback, RouteInfo routeInfo) {
            this.$$robo$$android_media_MediaRouter_VolumeCallbackInfo$__constructor__(volumeCallback, routeInfo);
        }

        public VolumeCallbackInfo(VolumeCallback volumeCallback, RouteInfo routeInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_VolumeCallbackInfo$__constructor__(android.media.MediaRouter$VolumeCallback android.media.MediaRouter$RouteInfo ), this, volumeCallback, routeInfo);
        }

        public /* synthetic */ VolumeCallbackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeCallbackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleCallback
    extends Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaRouter_SimpleCallback$__constructor__() {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteSelected(MediaRouter router, int type, RouteInfo info) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteUnselected(MediaRouter router, int type, RouteInfo info) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteAdded(MediaRouter router, RouteInfo info) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteRemoved(MediaRouter router, RouteInfo info) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteChanged(MediaRouter router, RouteInfo info) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteGrouped(MediaRouter router, RouteInfo info, RouteGroup group, int index) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteUngrouped(MediaRouter router, RouteInfo info, RouteGroup group) {
        }

        private final void $$robo$$android_media_MediaRouter_SimpleCallback$onRouteVolumeChanged(MediaRouter router, RouteInfo info) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaRouter_SimpleCallback$__constructor__();
        }

        public SimpleCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_SimpleCallback$__constructor__(), this);
        }

        @Override
        public void onRouteSelected(MediaRouter mediaRouter, int n, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteSelected", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteSelected(android.media.MediaRouter int android.media.MediaRouter$RouteInfo ), this, mediaRouter, n, routeInfo);
        }

        @Override
        public void onRouteUnselected(MediaRouter mediaRouter, int n, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteUnselected", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteUnselected(android.media.MediaRouter int android.media.MediaRouter$RouteInfo ), this, mediaRouter, n, routeInfo);
        }

        @Override
        public void onRouteAdded(MediaRouter mediaRouter, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteAdded", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteAdded(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteRemoved", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteRemoved(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteChanged", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteGrouped(MediaRouter mediaRouter, RouteInfo routeInfo, RouteGroup routeGroup, int n) {
            InvokeDynamicSupport.bootstrap("onRouteGrouped", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteGrouped(android.media.MediaRouter android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup int ), this, mediaRouter, routeInfo, routeGroup, n);
        }

        @Override
        public void onRouteUngrouped(MediaRouter mediaRouter, RouteInfo routeInfo, RouteGroup routeGroup) {
            InvokeDynamicSupport.bootstrap("onRouteUngrouped", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteUngrouped(android.media.MediaRouter android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup ), this, mediaRouter, routeInfo, routeGroup);
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter mediaRouter, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteVolumeChanged", $$robo$$android_media_MediaRouter_SimpleCallback$onRouteVolumeChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaRouter_Callback$__constructor__() {
        }

        public abstract void onRouteSelected(MediaRouter var1, int var2, RouteInfo var3);

        public abstract void onRouteUnselected(MediaRouter var1, int var2, RouteInfo var3);

        public abstract void onRouteAdded(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteRemoved(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteChanged(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteGrouped(MediaRouter var1, RouteInfo var2, RouteGroup var3, int var4);

        public abstract void onRouteUngrouped(MediaRouter var1, RouteInfo var2, RouteGroup var3);

        public abstract void onRouteVolumeChanged(MediaRouter var1, RouteInfo var2);

        private final void $$robo$$android_media_MediaRouter_Callback$onRoutePresentationDisplayChanged(MediaRouter router, RouteInfo info) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaRouter_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Callback$__constructor__(), this);
        }

        public void onRoutePresentationDisplayChanged(MediaRouter mediaRouter, RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRoutePresentationDisplayChanged", $$robo$$android_media_MediaRouter_Callback$onRoutePresentationDisplayChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CallbackInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int type;
        public int flags;
        public Callback cb;
        public MediaRouter router;

        private void $$robo$$android_media_MediaRouter_CallbackInfo$__constructor__(Callback cb, int type, int flags, MediaRouter router) {
            this.cb = cb;
            this.type = type;
            this.flags = flags;
            this.router = router;
        }

        private final boolean $$robo$$android_media_MediaRouter_CallbackInfo$filterRouteEvent(RouteInfo route) {
            return this.filterRouteEvent(route.mSupportedTypes);
        }

        private final boolean $$robo$$android_media_MediaRouter_CallbackInfo$filterRouteEvent(int supportedTypes) {
            return (this.flags & 2) != 0 || (this.type & supportedTypes) != 0;
        }

        private void __constructor__(Callback callback, int n, int n2, MediaRouter mediaRouter) {
            this.$$robo$$android_media_MediaRouter_CallbackInfo$__constructor__(callback, n, n2, mediaRouter);
        }

        public CallbackInfo(Callback callback, int n, int n2, MediaRouter mediaRouter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_CallbackInfo$__constructor__(android.media.MediaRouter$Callback int int android.media.MediaRouter ), this, callback, n, n2, mediaRouter);
        }

        public boolean filterRouteEvent(RouteInfo routeInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("filterRouteEvent", $$robo$$android_media_MediaRouter_CallbackInfo$filterRouteEvent(android.media.MediaRouter$RouteInfo ), this, routeInfo);
        }

        public boolean filterRouteEvent(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("filterRouteEvent", $$robo$$android_media_MediaRouter_CallbackInfo$filterRouteEvent(int ), this, n);
        }

        public /* synthetic */ CallbackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RouteCategory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        CharSequence mName;
        int mNameResId;
        int mTypes;
        boolean mGroupable;
        boolean mIsSystem;

        private void $$robo$$android_media_MediaRouter_RouteCategory$__constructor__(CharSequence name, int types, boolean groupable) {
            this.mName = name;
            this.mTypes = types;
            this.mGroupable = groupable;
        }

        private void $$robo$$android_media_MediaRouter_RouteCategory$__constructor__(int nameResId, int types, boolean groupable) {
            this.mNameResId = nameResId;
            this.mTypes = types;
            this.mGroupable = groupable;
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteCategory$getName() {
            return this.getName(MediaRouter.sStatic.mResources);
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteCategory$getName(Context context) {
            return this.getName(context.getResources());
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteCategory$getName(Resources res) {
            if (this.mNameResId != 0) {
                return res.getText(this.mNameResId);
            }
            return this.mName;
        }

        private final List<RouteInfo> $$robo$$android_media_MediaRouter_RouteCategory$getRoutes(List<RouteInfo> out) {
            if (out == null) {
                out = new ArrayList<RouteInfo>();
            } else {
                out.clear();
            }
            int count = MediaRouter.getRouteCountStatic();
            for (int i = 0; i < count; ++i) {
                RouteInfo route = MediaRouter.getRouteAtStatic(i);
                if (route.mCategory != this) continue;
                out.add(route);
            }
            return out;
        }

        private final int $$robo$$android_media_MediaRouter_RouteCategory$getSupportedTypes() {
            return this.mTypes;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteCategory$isGroupable() {
            return this.mGroupable;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteCategory$isSystem() {
            return this.mIsSystem;
        }

        private final String $$robo$$android_media_MediaRouter_RouteCategory$toString() {
            return "RouteCategory{ name=" + this.getName() + " types=" + MediaRouter.typesToString(this.mTypes) + " groupable=" + this.mGroupable + " }";
        }

        private void __constructor__(CharSequence charSequence, int n, boolean bl) {
            this.$$robo$$android_media_MediaRouter_RouteCategory$__constructor__(charSequence, n, bl);
        }

        public RouteCategory(CharSequence charSequence, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_RouteCategory$__constructor__(java.lang.CharSequence int boolean ), this, charSequence, n, bl);
        }

        private void __constructor__(int n, int n2, boolean bl) {
            this.$$robo$$android_media_MediaRouter_RouteCategory$__constructor__(n, n2, bl);
        }

        public RouteCategory(int n, int n2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_RouteCategory$__constructor__(int int boolean ), this, n, n2, bl);
        }

        public CharSequence getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteCategory$getName(), this);
        }

        public CharSequence getName(Context context) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteCategory$getName(android.content.Context ), this, context);
        }

        CharSequence getName(Resources resources) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteCategory$getName(android.content.res.Resources ), this, resources);
        }

        public List<RouteInfo> getRoutes(List<RouteInfo> list) {
            return InvokeDynamicSupport.bootstrap("getRoutes", $$robo$$android_media_MediaRouter_RouteCategory$getRoutes(java.util.List<android.media.MediaRouter$RouteInfo> ), this, list);
        }

        public int getSupportedTypes() {
            return (int)InvokeDynamicSupport.bootstrap("getSupportedTypes", $$robo$$android_media_MediaRouter_RouteCategory$getSupportedTypes(), this);
        }

        public boolean isGroupable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isGroupable", $$robo$$android_media_MediaRouter_RouteCategory$isGroupable(), this);
        }

        public boolean isSystem() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSystem", $$robo$$android_media_MediaRouter_RouteCategory$isSystem(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaRouter_RouteCategory$toString(), this);
        }

        public /* synthetic */ RouteCategory() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteCategory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RouteGroup
    extends RouteInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ArrayList<RouteInfo> mRoutes;
        private boolean mUpdateName;

        private void $$robo$$android_media_MediaRouter_RouteGroup$__constructor__(RouteCategory category) {
            this.mRoutes = new ArrayList();
            this.mGroup = this;
            this.mVolumeHandling = 0;
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteGroup$getName(Resources res) {
            if (this.mUpdateName) {
                this.updateName();
            }
            return super.getName(res);
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$addRoute(RouteInfo route) {
            if (route.getGroup() != null) {
                throw new IllegalStateException("Route " + route + " is already part of a group.");
            }
            if (route.getCategory() != this.mCategory) {
                throw new IllegalArgumentException("Route cannot be added to a group with a different category. (Route category=" + route.getCategory() + " group category=" + this.mCategory + ")");
            }
            int at = this.mRoutes.size();
            this.mRoutes.add(route);
            route.mGroup = this;
            this.mUpdateName = true;
            this.updateVolume();
            this.routeUpdated();
            MediaRouter.dispatchRouteGrouped(route, this, at);
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$addRoute(RouteInfo route, int insertAt) {
            if (route.getGroup() != null) {
                throw new IllegalStateException("Route " + route + " is already part of a group.");
            }
            if (route.getCategory() != this.mCategory) {
                throw new IllegalArgumentException("Route cannot be added to a group with a different category. (Route category=" + route.getCategory() + " group category=" + this.mCategory + ")");
            }
            this.mRoutes.add(insertAt, route);
            route.mGroup = this;
            this.mUpdateName = true;
            this.updateVolume();
            this.routeUpdated();
            MediaRouter.dispatchRouteGrouped(route, this, insertAt);
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$removeRoute(RouteInfo route) {
            if (route.getGroup() != this) {
                throw new IllegalArgumentException("Route " + route + " is not a member of this group.");
            }
            this.mRoutes.remove(route);
            route.mGroup = null;
            this.mUpdateName = true;
            this.updateVolume();
            MediaRouter.dispatchRouteUngrouped(route, this);
            this.routeUpdated();
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$removeRoute(int index) {
            RouteInfo route = this.mRoutes.remove(index);
            route.mGroup = null;
            this.mUpdateName = true;
            this.updateVolume();
            MediaRouter.dispatchRouteUngrouped(route, this);
            this.routeUpdated();
        }

        private final int $$robo$$android_media_MediaRouter_RouteGroup$getRouteCount() {
            return this.mRoutes.size();
        }

        private final RouteInfo $$robo$$android_media_MediaRouter_RouteGroup$getRouteAt(int index) {
            return this.mRoutes.get(index);
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$setIconDrawable(Drawable icon) {
            this.mIcon = icon;
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$setIconResource(int resId) {
            this.setIconDrawable(MediaRouter.sStatic.mResources.getDrawable(resId));
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$requestSetVolume(int volume) {
            int maxVol = this.getVolumeMax();
            if (maxVol == 0) {
                return;
            }
            float scaledVolume = (float)volume / (float)maxVol;
            int routeCount = this.getRouteCount();
            for (int i = 0; i < routeCount; ++i) {
                RouteInfo route = this.getRouteAt(i);
                int routeVol = (int)(scaledVolume * (float)route.getVolumeMax());
                route.requestSetVolume(routeVol);
            }
            if (volume != this.mVolume) {
                this.mVolume = volume;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$requestUpdateVolume(int direction) {
            int maxVol = this.getVolumeMax();
            if (maxVol == 0) {
                return;
            }
            int routeCount = this.getRouteCount();
            int volume = 0;
            for (int i = 0; i < routeCount; ++i) {
                RouteInfo route = this.getRouteAt(i);
                route.requestUpdateVolume(direction);
                int routeVol = route.getVolume();
                if (routeVol <= volume) continue;
                volume = routeVol;
            }
            if (volume != this.mVolume) {
                this.mVolume = volume;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$memberNameChanged(RouteInfo info, CharSequence name) {
            this.mUpdateName = true;
            this.routeUpdated();
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$memberStatusChanged(RouteInfo info, CharSequence status) {
            this.setStatusInt(status);
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$memberVolumeChanged(RouteInfo info) {
            this.updateVolume();
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$updateVolume() {
            int routeCount = this.getRouteCount();
            int volume = 0;
            for (int i = 0; i < routeCount; ++i) {
                int routeVol = this.getRouteAt(i).getVolume();
                if (routeVol <= volume) continue;
                volume = routeVol;
            }
            if (volume != this.mVolume) {
                this.mVolume = volume;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$routeUpdated() {
            int types = 0;
            int count = this.mRoutes.size();
            if (count == 0) {
                MediaRouter.removeRouteStatic(this);
                return;
            }
            int maxVolume = 0;
            boolean isLocal = true;
            boolean isFixedVolume = true;
            for (int i = 0; i < count; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                types |= route.mSupportedTypes;
                int routeMaxVolume = route.getVolumeMax();
                if (routeMaxVolume > maxVolume) {
                    maxVolume = routeMaxVolume;
                }
                isLocal &= route.getPlaybackType() == 0;
                isFixedVolume &= route.getVolumeHandling() == 0;
            }
            this.mPlaybackType = isLocal ? 0 : 1;
            this.mVolumeHandling = isFixedVolume ? 0 : 1;
            this.mSupportedTypes = types;
            this.mVolumeMax = maxVolume;
            this.mIcon = count == 1 ? this.mRoutes.get(0).getIconDrawable() : null;
            super.routeUpdated();
        }

        private final void $$robo$$android_media_MediaRouter_RouteGroup$updateName() {
            StringBuilder sb = new StringBuilder();
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                RouteInfo info = this.mRoutes.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(info.getName());
            }
            this.mName = sb.toString();
            this.mUpdateName = false;
        }

        private final String $$robo$$android_media_MediaRouter_RouteGroup$toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append('[');
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.mRoutes.get(i));
            }
            sb.append(']');
            return sb.toString();
        }

        private void __constructor__(RouteCategory routeCategory) {
            this.$$robo$$android_media_MediaRouter_RouteGroup$__constructor__(routeCategory);
        }

        public RouteGroup(RouteCategory routeCategory) {
            super(routeCategory);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_RouteGroup$__constructor__(android.media.MediaRouter$RouteCategory ), this, routeCategory);
        }

        @Override
        CharSequence getName(Resources resources) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteGroup$getName(android.content.res.Resources ), this, resources);
        }

        public void addRoute(RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("addRoute", $$robo$$android_media_MediaRouter_RouteGroup$addRoute(android.media.MediaRouter$RouteInfo ), this, routeInfo);
        }

        public void addRoute(RouteInfo routeInfo, int n) {
            InvokeDynamicSupport.bootstrap("addRoute", $$robo$$android_media_MediaRouter_RouteGroup$addRoute(android.media.MediaRouter$RouteInfo int ), this, routeInfo, n);
        }

        public void removeRoute(RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("removeRoute", $$robo$$android_media_MediaRouter_RouteGroup$removeRoute(android.media.MediaRouter$RouteInfo ), this, routeInfo);
        }

        public void removeRoute(int n) {
            InvokeDynamicSupport.bootstrap("removeRoute", $$robo$$android_media_MediaRouter_RouteGroup$removeRoute(int ), this, n);
        }

        public int getRouteCount() {
            return (int)InvokeDynamicSupport.bootstrap("getRouteCount", $$robo$$android_media_MediaRouter_RouteGroup$getRouteCount(), this);
        }

        public RouteInfo getRouteAt(int n) {
            return InvokeDynamicSupport.bootstrap("getRouteAt", $$robo$$android_media_MediaRouter_RouteGroup$getRouteAt(int ), this, n);
        }

        public void setIconDrawable(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("setIconDrawable", $$robo$$android_media_MediaRouter_RouteGroup$setIconDrawable(android.graphics.drawable.Drawable ), this, drawable2);
        }

        public void setIconResource(int n) {
            InvokeDynamicSupport.bootstrap("setIconResource", $$robo$$android_media_MediaRouter_RouteGroup$setIconResource(int ), this, n);
        }

        @Override
        public void requestSetVolume(int n) {
            InvokeDynamicSupport.bootstrap("requestSetVolume", $$robo$$android_media_MediaRouter_RouteGroup$requestSetVolume(int ), this, n);
        }

        @Override
        public void requestUpdateVolume(int n) {
            InvokeDynamicSupport.bootstrap("requestUpdateVolume", $$robo$$android_media_MediaRouter_RouteGroup$requestUpdateVolume(int ), this, n);
        }

        void memberNameChanged(RouteInfo routeInfo, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("memberNameChanged", $$robo$$android_media_MediaRouter_RouteGroup$memberNameChanged(android.media.MediaRouter$RouteInfo java.lang.CharSequence ), this, routeInfo, charSequence);
        }

        void memberStatusChanged(RouteInfo routeInfo, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("memberStatusChanged", $$robo$$android_media_MediaRouter_RouteGroup$memberStatusChanged(android.media.MediaRouter$RouteInfo java.lang.CharSequence ), this, routeInfo, charSequence);
        }

        void memberVolumeChanged(RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("memberVolumeChanged", $$robo$$android_media_MediaRouter_RouteGroup$memberVolumeChanged(android.media.MediaRouter$RouteInfo ), this, routeInfo);
        }

        void updateVolume() {
            InvokeDynamicSupport.bootstrap("updateVolume", $$robo$$android_media_MediaRouter_RouteGroup$updateVolume(), this);
        }

        @Override
        void routeUpdated() {
            InvokeDynamicSupport.bootstrap("routeUpdated", $$robo$$android_media_MediaRouter_RouteGroup$routeUpdated(), this);
        }

        void updateName() {
            InvokeDynamicSupport.bootstrap("updateName", $$robo$$android_media_MediaRouter_RouteGroup$updateName(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaRouter_RouteGroup$toString(), this);
        }

        public /* synthetic */ RouteGroup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteGroup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UserRouteInfo
    extends RouteInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        RemoteControlClient mRcc;
        SessionVolumeProvider mSvp;

        private void $$robo$$android_media_MediaRouter_UserRouteInfo$__constructor__(RouteCategory category) {
            this.mSupportedTypes = 0x800000;
            this.mPlaybackType = 1;
            this.mVolumeHandling = 0;
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setName(CharSequence name) {
            this.mNameResId = 0;
            this.mName = name;
            this.routeUpdated();
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setName(int resId) {
            this.mNameResId = resId;
            this.mName = null;
            this.routeUpdated();
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setDescription(CharSequence description) {
            this.mDescription = description;
            this.routeUpdated();
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setStatus(CharSequence status) {
            this.setStatusInt(status);
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setRemoteControlClient(RemoteControlClient rcc) {
            this.mRcc = rcc;
            this.updatePlaybackInfoOnRcc();
        }

        private final RemoteControlClient $$robo$$android_media_MediaRouter_UserRouteInfo$getRemoteControlClient() {
            return this.mRcc;
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setIconDrawable(Drawable icon) {
            this.mIcon = icon;
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setIconResource(int resId) {
            this.setIconDrawable(MediaRouter.sStatic.mResources.getDrawable(resId));
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setVolumeCallback(VolumeCallback vcb) {
            this.mVcb = new VolumeCallbackInfo(vcb, this);
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setPlaybackType(int type) {
            if (this.mPlaybackType != type) {
                this.mPlaybackType = type;
                this.configureSessionVolume();
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setVolumeHandling(int volumeHandling) {
            if (this.mVolumeHandling != volumeHandling) {
                this.mVolumeHandling = volumeHandling;
                this.configureSessionVolume();
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setVolume(int volume) {
            if (this.mVolume != (volume = Math.max(0, Math.min(volume, this.getVolumeMax())))) {
                this.mVolume = volume;
                if (this.mSvp != null) {
                    this.mSvp.setCurrentVolume(this.mVolume);
                }
                MediaRouter.dispatchRouteVolumeChanged(this);
                if (this.mGroup != null) {
                    this.mGroup.memberVolumeChanged(this);
                }
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$requestSetVolume(int volume) {
            if (this.mVolumeHandling == 1) {
                if (this.mVcb == null) {
                    Log.e("MediaRouter", "Cannot requestSetVolume on user route - no volume callback set");
                    return;
                }
                this.mVcb.vcb.onVolumeSetRequest(this, volume);
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$requestUpdateVolume(int direction) {
            if (this.mVolumeHandling == 1) {
                if (this.mVcb == null) {
                    Log.e("MediaRouter", "Cannot requestChangeVolume on user route - no volumec callback set");
                    return;
                }
                this.mVcb.vcb.onVolumeUpdateRequest(this, direction);
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setVolumeMax(int volumeMax) {
            if (this.mVolumeMax != volumeMax) {
                this.mVolumeMax = volumeMax;
                this.configureSessionVolume();
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$setPlaybackStream(int stream) {
            if (this.mPlaybackStream != stream) {
                this.mPlaybackStream = stream;
                this.configureSessionVolume();
            }
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$updatePlaybackInfoOnRcc() {
            this.configureSessionVolume();
        }

        private final void $$robo$$android_media_MediaRouter_UserRouteInfo$configureSessionVolume() {
            if (this.mRcc == null) {
                if (DEBUG) {
                    Log.d("MediaRouter", "No Rcc to configure volume for route " + this.getName());
                }
                return;
            }
            MediaSession session = this.mRcc.getMediaSession();
            if (session == null) {
                if (DEBUG) {
                    Log.d("MediaRouter", "Rcc has no session to configure volume");
                }
                return;
            }
            if (this.mPlaybackType == 1) {
                int volumeControl = 0;
                switch (this.mVolumeHandling) {
                    case 1: {
                        volumeControl = 2;
                        break;
                    }
                }
                if (this.mSvp == null || this.mSvp.getVolumeControl() != volumeControl || this.mSvp.getMaxVolume() != this.mVolumeMax) {
                    this.mSvp = new SessionVolumeProvider(this, volumeControl, this.mVolumeMax, this.mVolume);
                    session.setPlaybackToRemote(this.mSvp);
                }
            } else {
                AudioAttributes.Builder bob = new AudioAttributes.Builder();
                bob.setLegacyStreamType(this.mPlaybackStream);
                session.setPlaybackToLocal(bob.build());
                this.mSvp = null;
            }
        }

        private void __constructor__(RouteCategory routeCategory) {
            this.$$robo$$android_media_MediaRouter_UserRouteInfo$__constructor__(routeCategory);
        }

        public UserRouteInfo(RouteCategory routeCategory) {
            super(routeCategory);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_UserRouteInfo$__constructor__(android.media.MediaRouter$RouteCategory ), this, routeCategory);
        }

        public void setName(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setName", $$robo$$android_media_MediaRouter_UserRouteInfo$setName(java.lang.CharSequence ), this, charSequence);
        }

        public void setName(int n) {
            InvokeDynamicSupport.bootstrap("setName", $$robo$$android_media_MediaRouter_UserRouteInfo$setName(int ), this, n);
        }

        public void setDescription(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_media_MediaRouter_UserRouteInfo$setDescription(java.lang.CharSequence ), this, charSequence);
        }

        public void setStatus(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setStatus", $$robo$$android_media_MediaRouter_UserRouteInfo$setStatus(java.lang.CharSequence ), this, charSequence);
        }

        public void setRemoteControlClient(RemoteControlClient remoteControlClient) {
            InvokeDynamicSupport.bootstrap("setRemoteControlClient", $$robo$$android_media_MediaRouter_UserRouteInfo$setRemoteControlClient(android.media.RemoteControlClient ), this, remoteControlClient);
        }

        public RemoteControlClient getRemoteControlClient() {
            return InvokeDynamicSupport.bootstrap("getRemoteControlClient", $$robo$$android_media_MediaRouter_UserRouteInfo$getRemoteControlClient(), this);
        }

        public void setIconDrawable(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("setIconDrawable", $$robo$$android_media_MediaRouter_UserRouteInfo$setIconDrawable(android.graphics.drawable.Drawable ), this, drawable2);
        }

        public void setIconResource(int n) {
            InvokeDynamicSupport.bootstrap("setIconResource", $$robo$$android_media_MediaRouter_UserRouteInfo$setIconResource(int ), this, n);
        }

        public void setVolumeCallback(VolumeCallback volumeCallback) {
            InvokeDynamicSupport.bootstrap("setVolumeCallback", $$robo$$android_media_MediaRouter_UserRouteInfo$setVolumeCallback(android.media.MediaRouter$VolumeCallback ), this, volumeCallback);
        }

        public void setPlaybackType(int n) {
            InvokeDynamicSupport.bootstrap("setPlaybackType", $$robo$$android_media_MediaRouter_UserRouteInfo$setPlaybackType(int ), this, n);
        }

        public void setVolumeHandling(int n) {
            InvokeDynamicSupport.bootstrap("setVolumeHandling", $$robo$$android_media_MediaRouter_UserRouteInfo$setVolumeHandling(int ), this, n);
        }

        public void setVolume(int n) {
            InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_MediaRouter_UserRouteInfo$setVolume(int ), this, n);
        }

        @Override
        public void requestSetVolume(int n) {
            InvokeDynamicSupport.bootstrap("requestSetVolume", $$robo$$android_media_MediaRouter_UserRouteInfo$requestSetVolume(int ), this, n);
        }

        @Override
        public void requestUpdateVolume(int n) {
            InvokeDynamicSupport.bootstrap("requestUpdateVolume", $$robo$$android_media_MediaRouter_UserRouteInfo$requestUpdateVolume(int ), this, n);
        }

        public void setVolumeMax(int n) {
            InvokeDynamicSupport.bootstrap("setVolumeMax", $$robo$$android_media_MediaRouter_UserRouteInfo$setVolumeMax(int ), this, n);
        }

        public void setPlaybackStream(int n) {
            InvokeDynamicSupport.bootstrap("setPlaybackStream", $$robo$$android_media_MediaRouter_UserRouteInfo$setPlaybackStream(int ), this, n);
        }

        private void updatePlaybackInfoOnRcc() {
            InvokeDynamicSupport.bootstrap("updatePlaybackInfoOnRcc", $$robo$$android_media_MediaRouter_UserRouteInfo$updatePlaybackInfoOnRcc(), this);
        }

        private void configureSessionVolume() {
            InvokeDynamicSupport.bootstrap("configureSessionVolume", $$robo$$android_media_MediaRouter_UserRouteInfo$configureSessionVolume(), this);
        }

        public /* synthetic */ UserRouteInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserRouteInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class SessionVolumeProvider
        extends VolumeProvider
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ UserRouteInfo this$0;

            private void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$__constructor__(UserRouteInfo this$0, int volumeControl, int maxVolume, int currentVolume) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$onSetVolumeTo(int volume) {
                MediaRouter.sStatic.mHandler.post(new Runnable(this, volume){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$volume;
                    /* synthetic */ SessionVolumeProvider this$1;

                    private void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_1$__constructor__(SessionVolumeProvider this$1, int n) {
                        this.this$1 = this$1;
                        this.val$volume = n;
                    }

                    private final void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_1$run() {
                        if (this.this$1.this$0.mVcb != null) {
                            this.this$1.this$0.mVcb.vcb.onVolumeSetRequest(this.this$1.this$0.mVcb.route, this.val$volume);
                        }
                    }

                    private void __constructor__(SessionVolumeProvider sessionVolumeProvider, int n) {
                        this.$$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_1$__constructor__(sessionVolumeProvider, n);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_1$__constructor__(android.media.MediaRouter$UserRouteInfo$SessionVolumeProvider int ), this, sessionVolumeProvider, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_1$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$onAdjustVolume(int direction) {
                MediaRouter.sStatic.mHandler.post(new Runnable(this, direction){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$direction;
                    /* synthetic */ SessionVolumeProvider this$1;

                    private void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_2$__constructor__(SessionVolumeProvider this$1, int n) {
                        this.this$1 = this$1;
                        this.val$direction = n;
                    }

                    private final void $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_2$run() {
                        if (this.this$1.this$0.mVcb != null) {
                            this.this$1.this$0.mVcb.vcb.onVolumeUpdateRequest(this.this$1.this$0.mVcb.route, this.val$direction);
                        }
                    }

                    private void __constructor__(SessionVolumeProvider sessionVolumeProvider, int n) {
                        this.$$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_2$__constructor__(sessionVolumeProvider, n);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_2$__constructor__(android.media.MediaRouter$UserRouteInfo$SessionVolumeProvider int ), this, sessionVolumeProvider, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider_2$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(UserRouteInfo userRouteInfo, int n, int n2, int n3) {
                this.$$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$__constructor__(userRouteInfo, n, n2, n3);
            }

            public SessionVolumeProvider(UserRouteInfo userRouteInfo, int n, int n2, int n3) {
                super(n, n2, n3);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$__constructor__(android.media.MediaRouter$UserRouteInfo int int int ), this, userRouteInfo, n, n2, n3);
            }

            @Override
            public void onSetVolumeTo(int n) {
                InvokeDynamicSupport.bootstrap("onSetVolumeTo", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$onSetVolumeTo(int ), this, n);
            }

            @Override
            public void onAdjustVolume(int n) {
                InvokeDynamicSupport.bootstrap("onAdjustVolume", $$robo$$android_media_MediaRouter_UserRouteInfo_SessionVolumeProvider$onAdjustVolume(int ), this, n);
            }

            public /* synthetic */ SessionVolumeProvider() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionVolumeProvider)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class RouteInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        CharSequence mName;
        int mNameResId;
        CharSequence mDescription;
        private CharSequence mStatus;
        int mSupportedTypes;
        int mDeviceType;
        RouteGroup mGroup;
        RouteCategory mCategory;
        Drawable mIcon;
        int mPlaybackType;
        int mVolumeMax;
        int mVolume;
        int mVolumeHandling;
        int mPlaybackStream;
        VolumeCallbackInfo mVcb;
        Display mPresentationDisplay;
        int mPresentationDisplayId;
        String mDeviceAddress;
        boolean mEnabled;
        String mGlobalRouteId;
        private int mRealStatusCode;
        private int mResolvedStatusCode;
        public static int STATUS_NONE = 0;
        public static int STATUS_SCANNING = 1;
        public static int STATUS_CONNECTING = 2;
        public static int STATUS_AVAILABLE = 3;
        public static int STATUS_NOT_AVAILABLE = 4;
        public static int STATUS_IN_USE = 5;
        public static int STATUS_CONNECTED = 6;
        public static int DEVICE_TYPE_UNKNOWN = 0;
        public static int DEVICE_TYPE_TV = 1;
        public static int DEVICE_TYPE_SPEAKER = 2;
        public static int DEVICE_TYPE_BLUETOOTH = 3;
        private Object mTag;
        public static int PLAYBACK_TYPE_LOCAL = 0;
        public static int PLAYBACK_TYPE_REMOTE = 1;
        public static int PLAYBACK_VOLUME_FIXED = 0;
        public static int PLAYBACK_VOLUME_VARIABLE = 1;
        IRemoteVolumeObserver.Stub mRemoteVolObserver;

        private void $$robo$$android_media_MediaRouter_RouteInfo$__constructor__(RouteCategory category) {
            this.mPlaybackType = 0;
            this.mVolumeMax = 15;
            this.mVolume = 15;
            this.mVolumeHandling = 1;
            this.mPlaybackStream = 3;
            this.mPresentationDisplayId = -1;
            this.mEnabled = true;
            this.mRemoteVolObserver = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ RouteInfo this$0;

                private void $$robo$$android_media_MediaRouter_RouteInfo_1$__constructor__(RouteInfo this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_MediaRouter_RouteInfo_1$dispatchRemoteVolumeUpdate(int direction, int value) {
                    MediaRouter.sStatic.mHandler.post(new Runnable(this, direction, value){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ int val$direction;
                        /* synthetic */ int val$value;
                        /* synthetic */ 1 this$1;

                        private void $$robo$$android_media_MediaRouter_RouteInfo_1_1$__constructor__(1 this$1, int n, int n2) {
                            this.this$1 = this$1;
                            this.val$direction = n;
                            this.val$value = n2;
                        }

                        private final void $$robo$$android_media_MediaRouter_RouteInfo_1_1$run() {
                            if (this.this$1.this$0.mVcb != null) {
                                if (this.val$direction != 0) {
                                    this.this$1.this$0.mVcb.vcb.onVolumeUpdateRequest(this.this$1.this$0.mVcb.route, this.val$direction);
                                } else {
                                    this.this$1.this$0.mVcb.vcb.onVolumeSetRequest(this.this$1.this$0.mVcb.route, this.val$value);
                                }
                            }
                        }

                        private void __constructor__(1 var1_1, int n, int n2) {
                            this.$$robo$$android_media_MediaRouter_RouteInfo_1_1$__constructor__(var1_1, n, n2);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_RouteInfo_1_1$__constructor__(android.media.MediaRouter$RouteInfo$1 int int ), this, var1_1, n, n2);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaRouter_RouteInfo_1_1$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }

                private void __constructor__(RouteInfo routeInfo) {
                    this.$$robo$$android_media_MediaRouter_RouteInfo_1$__constructor__(routeInfo);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_RouteInfo_1$__constructor__(android.media.MediaRouter$RouteInfo ), this, routeInfo);
                }

                @Override
                public void dispatchRemoteVolumeUpdate(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("dispatchRemoteVolumeUpdate", $$robo$$android_media_MediaRouter_RouteInfo_1$dispatchRemoteVolumeUpdate(int int ), this, n, n2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mCategory = category;
            this.mDeviceType = 0;
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteInfo$getName() {
            return this.getName(MediaRouter.sStatic.mResources);
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteInfo$getName(Context context) {
            return this.getName(context.getResources());
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteInfo$getName(Resources res) {
            if (this.mNameResId != 0) {
                return res.getText(this.mNameResId);
            }
            return this.mName;
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteInfo$getDescription() {
            return this.mDescription;
        }

        private final CharSequence $$robo$$android_media_MediaRouter_RouteInfo$getStatus() {
            return this.mStatus;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$setRealStatusCode(int statusCode) {
            if (this.mRealStatusCode != statusCode) {
                this.mRealStatusCode = statusCode;
                return this.resolveStatusCode();
            }
            return false;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$resolveStatusCode() {
            int resId;
            int statusCode = this.mRealStatusCode;
            if (this.isSelected()) {
                switch (statusCode) {
                    case 1: 
                    case 3: {
                        statusCode = 2;
                    }
                }
            }
            if (this.mResolvedStatusCode == statusCode) {
                return false;
            }
            this.mResolvedStatusCode = statusCode;
            switch (statusCode) {
                case 1: {
                    resId = 17040212;
                    break;
                }
                case 2: {
                    resId = 17040209;
                    break;
                }
                case 3: {
                    resId = 17040208;
                    break;
                }
                case 4: {
                    resId = 17040211;
                    break;
                }
                case 5: {
                    resId = 17040210;
                    break;
                }
                default: {
                    resId = 0;
                }
            }
            this.mStatus = resId != 0 ? MediaRouter.sStatic.mResources.getText(resId) : null;
            return true;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getStatusCode() {
            return this.mResolvedStatusCode;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getSupportedTypes() {
            return this.mSupportedTypes;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getDeviceType() {
            return this.mDeviceType;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$matchesTypes(int types) {
            return (this.mSupportedTypes & types) != 0;
        }

        private final RouteGroup $$robo$$android_media_MediaRouter_RouteInfo$getGroup() {
            return this.mGroup;
        }

        private final RouteCategory $$robo$$android_media_MediaRouter_RouteInfo$getCategory() {
            return this.mCategory;
        }

        private final Drawable $$robo$$android_media_MediaRouter_RouteInfo$getIconDrawable() {
            return this.mIcon;
        }

        private final void $$robo$$android_media_MediaRouter_RouteInfo$setTag(Object tag) {
            this.mTag = tag;
            this.routeUpdated();
        }

        private final Object $$robo$$android_media_MediaRouter_RouteInfo$getTag() {
            return this.mTag;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getPlaybackType() {
            return this.mPlaybackType;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getPlaybackStream() {
            return this.mPlaybackStream;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getVolume() {
            if (this.mPlaybackType == 0) {
                int vol = 0;
                try {
                    vol = MediaRouter.sStatic.mAudioService.getStreamVolume(this.mPlaybackStream);
                }
                catch (RemoteException e) {
                    Log.e("MediaRouter", "Error getting local stream volume", e);
                }
                return vol;
            }
            return this.mVolume;
        }

        private final void $$robo$$android_media_MediaRouter_RouteInfo$requestSetVolume(int volume) {
            if (this.mPlaybackType == 0) {
                try {
                    MediaRouter.sStatic.mAudioService.setStreamVolume(this.mPlaybackStream, volume, 0, ActivityThread.currentPackageName());
                }
                catch (RemoteException e) {
                    Log.e("MediaRouter", "Error setting local stream volume", e);
                }
            } else {
                sStatic.requestSetVolume(this, volume);
            }
        }

        private final void $$robo$$android_media_MediaRouter_RouteInfo$requestUpdateVolume(int direction) {
            if (this.mPlaybackType == 0) {
                try {
                    int volume = Math.max(0, Math.min(this.getVolume() + direction, this.getVolumeMax()));
                    MediaRouter.sStatic.mAudioService.setStreamVolume(this.mPlaybackStream, volume, 0, ActivityThread.currentPackageName());
                }
                catch (RemoteException e) {
                    Log.e("MediaRouter", "Error setting local stream volume", e);
                }
            } else {
                sStatic.requestUpdateVolume(this, direction);
            }
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getVolumeMax() {
            if (this.mPlaybackType == 0) {
                int volMax = 0;
                try {
                    volMax = MediaRouter.sStatic.mAudioService.getStreamMaxVolume(this.mPlaybackStream);
                }
                catch (RemoteException e) {
                    Log.e("MediaRouter", "Error getting local stream volume", e);
                }
                return volMax;
            }
            return this.mVolumeMax;
        }

        private final int $$robo$$android_media_MediaRouter_RouteInfo$getVolumeHandling() {
            return this.mVolumeHandling;
        }

        private final Display $$robo$$android_media_MediaRouter_RouteInfo$getPresentationDisplay() {
            return this.mPresentationDisplay;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$updatePresentationDisplay() {
            Display display = this.choosePresentationDisplay();
            if (this.mPresentationDisplay != display) {
                this.mPresentationDisplay = display;
                return true;
            }
            return false;
        }

        private final Display $$robo$$android_media_MediaRouter_RouteInfo$choosePresentationDisplay() {
            if ((this.mSupportedTypes & 2) != 0) {
                Display[] displays = sStatic.getAllPresentationDisplays();
                if (this.mPresentationDisplayId >= 0) {
                    for (Display display : displays) {
                        if (display.getDisplayId() != this.mPresentationDisplayId) continue;
                        return display;
                    }
                    return null;
                }
                if (this.mDeviceAddress != null) {
                    for (Display display : displays) {
                        if (display.getType() != 3 || !this.mDeviceAddress.equals(display.getAddress())) continue;
                        return display;
                    }
                    return null;
                }
                if (this == MediaRouter.sStatic.mDefaultAudioVideo && displays.length > 0) {
                    return displays[0];
                }
            }
            return null;
        }

        private final String $$robo$$android_media_MediaRouter_RouteInfo$getDeviceAddress() {
            return this.mDeviceAddress;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$isEnabled() {
            return this.mEnabled;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$isConnecting() {
            return this.mResolvedStatusCode == 2;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$isSelected() {
            return this == MediaRouter.sStatic.mSelectedRoute;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$isDefault() {
            return this == MediaRouter.sStatic.mDefaultAudioVideo;
        }

        private final boolean $$robo$$android_media_MediaRouter_RouteInfo$isBluetooth() {
            return this == MediaRouter.sStatic.mBluetoothA2dpRoute;
        }

        private final void $$robo$$android_media_MediaRouter_RouteInfo$select() {
            MediaRouter.selectRouteStatic(this.mSupportedTypes, this, true);
        }

        private final void $$robo$$android_media_MediaRouter_RouteInfo$setStatusInt(CharSequence status) {
            if (!status.equals(this.mStatus)) {
                this.mStatus = status;
                if (this.mGroup != null) {
                    this.mGroup.memberStatusChanged(this, status);
                }
                this.routeUpdated();
            }
        }

        private final void $$robo$$android_media_MediaRouter_RouteInfo$routeUpdated() {
            MediaRouter.updateRoute(this);
        }

        private final String $$robo$$android_media_MediaRouter_RouteInfo$toString() {
            String supportedTypes = MediaRouter.typesToString(this.getSupportedTypes());
            return this.getClass().getSimpleName() + "{ name=" + this.getName() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", category=" + this.getCategory() + ", supportedTypes=" + supportedTypes + ", presentationDisplay=" + this.mPresentationDisplay + " }";
        }

        private void __constructor__(RouteCategory routeCategory) {
            this.$$robo$$android_media_MediaRouter_RouteInfo$__constructor__(routeCategory);
        }

        public RouteInfo(RouteCategory routeCategory) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_RouteInfo$__constructor__(android.media.MediaRouter$RouteCategory ), this, routeCategory);
        }

        public CharSequence getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteInfo$getName(), this);
        }

        public CharSequence getName(Context context) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteInfo$getName(android.content.Context ), this, context);
        }

        CharSequence getName(Resources resources) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaRouter_RouteInfo$getName(android.content.res.Resources ), this, resources);
        }

        public CharSequence getDescription() {
            return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_media_MediaRouter_RouteInfo$getDescription(), this);
        }

        public CharSequence getStatus() {
            return InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_media_MediaRouter_RouteInfo$getStatus(), this);
        }

        boolean setRealStatusCode(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("setRealStatusCode", $$robo$$android_media_MediaRouter_RouteInfo$setRealStatusCode(int ), this, n);
        }

        boolean resolveStatusCode() {
            return (boolean)InvokeDynamicSupport.bootstrap("resolveStatusCode", $$robo$$android_media_MediaRouter_RouteInfo$resolveStatusCode(), this);
        }

        public int getStatusCode() {
            return (int)InvokeDynamicSupport.bootstrap("getStatusCode", $$robo$$android_media_MediaRouter_RouteInfo$getStatusCode(), this);
        }

        public int getSupportedTypes() {
            return (int)InvokeDynamicSupport.bootstrap("getSupportedTypes", $$robo$$android_media_MediaRouter_RouteInfo$getSupportedTypes(), this);
        }

        public int getDeviceType() {
            return (int)InvokeDynamicSupport.bootstrap("getDeviceType", $$robo$$android_media_MediaRouter_RouteInfo$getDeviceType(), this);
        }

        public boolean matchesTypes(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("matchesTypes", $$robo$$android_media_MediaRouter_RouteInfo$matchesTypes(int ), this, n);
        }

        public RouteGroup getGroup() {
            return InvokeDynamicSupport.bootstrap("getGroup", $$robo$$android_media_MediaRouter_RouteInfo$getGroup(), this);
        }

        public RouteCategory getCategory() {
            return InvokeDynamicSupport.bootstrap("getCategory", $$robo$$android_media_MediaRouter_RouteInfo$getCategory(), this);
        }

        public Drawable getIconDrawable() {
            return InvokeDynamicSupport.bootstrap("getIconDrawable", $$robo$$android_media_MediaRouter_RouteInfo$getIconDrawable(), this);
        }

        public void setTag(Object object) {
            InvokeDynamicSupport.bootstrap("setTag", $$robo$$android_media_MediaRouter_RouteInfo$setTag(java.lang.Object ), this, object);
        }

        public Object getTag() {
            return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_media_MediaRouter_RouteInfo$getTag(), this);
        }

        public int getPlaybackType() {
            return (int)InvokeDynamicSupport.bootstrap("getPlaybackType", $$robo$$android_media_MediaRouter_RouteInfo$getPlaybackType(), this);
        }

        public int getPlaybackStream() {
            return (int)InvokeDynamicSupport.bootstrap("getPlaybackStream", $$robo$$android_media_MediaRouter_RouteInfo$getPlaybackStream(), this);
        }

        public int getVolume() {
            return (int)InvokeDynamicSupport.bootstrap("getVolume", $$robo$$android_media_MediaRouter_RouteInfo$getVolume(), this);
        }

        public void requestSetVolume(int n) {
            InvokeDynamicSupport.bootstrap("requestSetVolume", $$robo$$android_media_MediaRouter_RouteInfo$requestSetVolume(int ), this, n);
        }

        public void requestUpdateVolume(int n) {
            InvokeDynamicSupport.bootstrap("requestUpdateVolume", $$robo$$android_media_MediaRouter_RouteInfo$requestUpdateVolume(int ), this, n);
        }

        public int getVolumeMax() {
            return (int)InvokeDynamicSupport.bootstrap("getVolumeMax", $$robo$$android_media_MediaRouter_RouteInfo$getVolumeMax(), this);
        }

        public int getVolumeHandling() {
            return (int)InvokeDynamicSupport.bootstrap("getVolumeHandling", $$robo$$android_media_MediaRouter_RouteInfo$getVolumeHandling(), this);
        }

        public Display getPresentationDisplay() {
            return InvokeDynamicSupport.bootstrap("getPresentationDisplay", $$robo$$android_media_MediaRouter_RouteInfo$getPresentationDisplay(), this);
        }

        boolean updatePresentationDisplay() {
            return (boolean)InvokeDynamicSupport.bootstrap("updatePresentationDisplay", $$robo$$android_media_MediaRouter_RouteInfo$updatePresentationDisplay(), this);
        }

        private Display choosePresentationDisplay() {
            return InvokeDynamicSupport.bootstrap("choosePresentationDisplay", $$robo$$android_media_MediaRouter_RouteInfo$choosePresentationDisplay(), this);
        }

        public String getDeviceAddress() {
            return InvokeDynamicSupport.bootstrap("getDeviceAddress", $$robo$$android_media_MediaRouter_RouteInfo$getDeviceAddress(), this);
        }

        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_media_MediaRouter_RouteInfo$isEnabled(), this);
        }

        public boolean isConnecting() {
            return (boolean)InvokeDynamicSupport.bootstrap("isConnecting", $$robo$$android_media_MediaRouter_RouteInfo$isConnecting(), this);
        }

        public boolean isSelected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSelected", $$robo$$android_media_MediaRouter_RouteInfo$isSelected(), this);
        }

        public boolean isDefault() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDefault", $$robo$$android_media_MediaRouter_RouteInfo$isDefault(), this);
        }

        public boolean isBluetooth() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBluetooth", $$robo$$android_media_MediaRouter_RouteInfo$isBluetooth(), this);
        }

        public void select() {
            InvokeDynamicSupport.bootstrap("select", $$robo$$android_media_MediaRouter_RouteInfo$select(), this);
        }

        void setStatusInt(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setStatusInt", $$robo$$android_media_MediaRouter_RouteInfo$setStatusInt(java.lang.CharSequence ), this, charSequence);
        }

        void routeUpdated() {
            InvokeDynamicSupport.bootstrap("routeUpdated", $$robo$$android_media_MediaRouter_RouteInfo$routeUpdated(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaRouter_RouteInfo$toString(), this);
        }

        public /* synthetic */ RouteInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface PlaybackVolume {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PlaybackType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DeviceType {
        }
    }

    public static class Static
    implements DisplayManager.DisplayListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String mPackageName;
        Resources mResources;
        IAudioService mAudioService;
        DisplayManager mDisplayService;
        IMediaRouterService mMediaRouterService;
        Handler mHandler;
        CopyOnWriteArrayList<CallbackInfo> mCallbacks;
        ArrayList<RouteInfo> mRoutes;
        ArrayList<RouteCategory> mCategories;
        RouteCategory mSystemCategory;
        AudioRoutesInfo mCurAudioRoutesInfo;
        RouteInfo mDefaultAudioVideo;
        RouteInfo mBluetoothA2dpRoute;
        RouteInfo mSelectedRoute;
        boolean mCanConfigureWifiDisplays;
        boolean mActivelyScanningWifiDisplays;
        String mPreviousActiveWifiDisplayAddress;
        int mDiscoveryRequestRouteTypes;
        boolean mDiscoverRequestActiveScan;
        int mCurrentUserId;
        IMediaRouterClient mClient;
        MediaRouterClientState mClientState;
        IAudioRoutesObserver.Stub mAudioRoutesObserver;

        private void $$robo$$android_media_MediaRouter_Static$__constructor__(Context appContext) {
            this.mCallbacks = new CopyOnWriteArrayList();
            this.mRoutes = new ArrayList();
            this.mCategories = new ArrayList();
            this.mCurAudioRoutesInfo = new AudioRoutesInfo();
            this.mCurrentUserId = -1;
            this.mAudioRoutesObserver = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Static this$0;

                private void $$robo$$android_media_MediaRouter_Static_1$__constructor__(Static this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_MediaRouter_Static_1$dispatchAudioRoutesChanged(AudioRoutesInfo newRoutes) {
                    this.this$0.mHandler.post(new Runnable(this, newRoutes){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ AudioRoutesInfo val$newRoutes;
                        /* synthetic */ 1 this$1;

                        private void $$robo$$android_media_MediaRouter_Static_1_1$__constructor__(1 this$1, AudioRoutesInfo audioRoutesInfo) {
                            this.this$1 = this$1;
                            this.val$newRoutes = audioRoutesInfo;
                        }

                        private final void $$robo$$android_media_MediaRouter_Static_1_1$run() {
                            this.this$1.this$0.updateAudioRoutes(this.val$newRoutes);
                        }

                        private void __constructor__(1 var1_1, AudioRoutesInfo audioRoutesInfo) {
                            this.$$robo$$android_media_MediaRouter_Static_1_1$__constructor__(var1_1, audioRoutesInfo);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Static_1_1$__constructor__(android.media.MediaRouter$Static$1 android.media.AudioRoutesInfo ), this, var1_1, audioRoutesInfo);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaRouter_Static_1_1$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }

                private void __constructor__(Static static_) {
                    this.$$robo$$android_media_MediaRouter_Static_1$__constructor__(static_);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Static_1$__constructor__(android.media.MediaRouter$Static ), this, static_);
                }

                @Override
                public void dispatchAudioRoutesChanged(AudioRoutesInfo audioRoutesInfo) {
                    InvokeDynamicSupport.bootstrap("dispatchAudioRoutesChanged", $$robo$$android_media_MediaRouter_Static_1$dispatchAudioRoutesChanged(android.media.AudioRoutesInfo ), this, audioRoutesInfo);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mPackageName = appContext.getPackageName();
            this.mResources = appContext.getResources();
            this.mHandler = new Handler(appContext.getMainLooper());
            IBinder b = ServiceManager.getService("audio");
            this.mAudioService = IAudioService.Stub.asInterface(b);
            this.mDisplayService = (DisplayManager)appContext.getSystemService("display");
            this.mMediaRouterService = IMediaRouterService.Stub.asInterface(ServiceManager.getService("media_router"));
            this.mSystemCategory = new RouteCategory(17039776, 3, false);
            this.mSystemCategory.mIsSystem = true;
            this.mCanConfigureWifiDisplays = appContext.checkPermission("android.permission.CONFIGURE_WIFI_DISPLAY", Process.myPid(), Process.myUid()) == 0;
        }

        private final void $$robo$$android_media_MediaRouter_Static$startMonitoringRoutes(Context appContext) {
            this.mDefaultAudioVideo = new RouteInfo(this.mSystemCategory);
            this.mDefaultAudioVideo.mNameResId = 17039777;
            this.mDefaultAudioVideo.mSupportedTypes = 3;
            this.mDefaultAudioVideo.updatePresentationDisplay();
            if (((AudioManager)appContext.getSystemService("audio")).isVolumeFixed()) {
                this.mDefaultAudioVideo.mVolumeHandling = 0;
            }
            MediaRouter.addRouteStatic(this.mDefaultAudioVideo);
            MediaRouter.updateWifiDisplayStatus(this.mDisplayService.getWifiDisplayStatus());
            appContext.registerReceiver(new WifiDisplayStatusChangedReceiver(), new IntentFilter("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED"));
            appContext.registerReceiver(new VolumeChangeReceiver(), new IntentFilter("android.media.VOLUME_CHANGED_ACTION"));
            this.mDisplayService.registerDisplayListener(this, this.mHandler);
            AudioRoutesInfo newAudioRoutes = null;
            try {
                newAudioRoutes = this.mAudioService.startWatchingRoutes(this.mAudioRoutesObserver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (newAudioRoutes != null) {
                this.updateAudioRoutes(newAudioRoutes);
            }
            this.rebindAsUser(UserHandle.myUserId());
            if (this.mSelectedRoute == null) {
                MediaRouter.selectDefaultRouteStatic();
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$updateAudioRoutes(AudioRoutesInfo newRoutes) {
            boolean audioRoutesChanged = false;
            boolean forceUseDefaultRoute = false;
            if (newRoutes.mainType != this.mCurAudioRoutesInfo.mainType) {
                this.mCurAudioRoutesInfo.mainType = newRoutes.mainType;
                int name = (newRoutes.mainType & 2) != 0 || (newRoutes.mainType & 1) != 0 ? 17039780 : ((newRoutes.mainType & 4) != 0 ? 17039778 : ((newRoutes.mainType & 8) != 0 ? 17039779 : ((newRoutes.mainType & 0x10) != 0 ? 17039781 : 17039777)));
                this.mDefaultAudioVideo.mNameResId = name;
                MediaRouter.dispatchRouteChanged(this.mDefaultAudioVideo);
                if ((newRoutes.mainType & 0x13) != 0) {
                    forceUseDefaultRoute = true;
                }
                audioRoutesChanged = true;
            }
            if (!TextUtils.equals(newRoutes.bluetoothName, this.mCurAudioRoutesInfo.bluetoothName)) {
                forceUseDefaultRoute = false;
                this.mCurAudioRoutesInfo.bluetoothName = newRoutes.bluetoothName;
                if (this.mCurAudioRoutesInfo.bluetoothName != null) {
                    if (this.mBluetoothA2dpRoute == null) {
                        RouteInfo info = new RouteInfo(this.mSystemCategory);
                        info.mName = this.mCurAudioRoutesInfo.bluetoothName;
                        info.mDescription = this.mResources.getText(17039581);
                        info.mSupportedTypes = 1;
                        info.mDeviceType = 3;
                        this.mBluetoothA2dpRoute = info;
                        MediaRouter.addRouteStatic(this.mBluetoothA2dpRoute);
                    } else {
                        this.mBluetoothA2dpRoute.mName = this.mCurAudioRoutesInfo.bluetoothName;
                        MediaRouter.dispatchRouteChanged(this.mBluetoothA2dpRoute);
                    }
                } else if (this.mBluetoothA2dpRoute != null) {
                    MediaRouter.removeRouteStatic(this.mBluetoothA2dpRoute);
                    this.mBluetoothA2dpRoute = null;
                }
                audioRoutesChanged = true;
            }
            if (audioRoutesChanged) {
                Log.v("MediaRouter", "Audio routes updated: " + newRoutes + ", a2dp=" + this.isBluetoothA2dpOn());
                if (this.mSelectedRoute == null || this.mSelectedRoute == this.mDefaultAudioVideo || this.mSelectedRoute == this.mBluetoothA2dpRoute) {
                    if (forceUseDefaultRoute || this.mBluetoothA2dpRoute == null) {
                        MediaRouter.selectRouteStatic(1, this.mDefaultAudioVideo, false);
                    } else {
                        MediaRouter.selectRouteStatic(1, this.mBluetoothA2dpRoute, false);
                    }
                }
            }
        }

        private final boolean $$robo$$android_media_MediaRouter_Static$isBluetoothA2dpOn() {
            try {
                return this.mBluetoothA2dpRoute != null && this.mAudioService.isBluetoothA2dpOn();
            }
            catch (RemoteException e) {
                Log.e("MediaRouter", "Error querying Bluetooth A2DP state", e);
                return false;
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$updateDiscoveryRequest() {
            int routeTypes = 0;
            int passiveRouteTypes = 0;
            boolean activeScan = false;
            boolean activeScanWifiDisplay = false;
            int count = this.mCallbacks.size();
            for (int i = 0; i < count; ++i) {
                CallbackInfo cbi = this.mCallbacks.get(i);
                if ((cbi.flags & 5) != 0) {
                    routeTypes |= cbi.type;
                } else if ((cbi.flags & 8) != 0) {
                    passiveRouteTypes |= cbi.type;
                } else {
                    routeTypes |= cbi.type;
                }
                if ((cbi.flags & 1) == 0) continue;
                activeScan = true;
                if ((cbi.type & 4) == 0) continue;
                activeScanWifiDisplay = true;
            }
            if (routeTypes != 0 || activeScan) {
                routeTypes |= passiveRouteTypes;
            }
            if (this.mCanConfigureWifiDisplays) {
                if (this.mSelectedRoute != null && this.mSelectedRoute.matchesTypes(4)) {
                    activeScanWifiDisplay = false;
                }
                if (activeScanWifiDisplay) {
                    if (!this.mActivelyScanningWifiDisplays) {
                        this.mActivelyScanningWifiDisplays = true;
                        this.mDisplayService.startWifiDisplayScan();
                    }
                } else if (this.mActivelyScanningWifiDisplays) {
                    this.mActivelyScanningWifiDisplays = false;
                    this.mDisplayService.stopWifiDisplayScan();
                }
            }
            if (routeTypes != this.mDiscoveryRequestRouteTypes || activeScan != this.mDiscoverRequestActiveScan) {
                this.mDiscoveryRequestRouteTypes = routeTypes;
                this.mDiscoverRequestActiveScan = activeScan;
                this.publishClientDiscoveryRequest();
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$onDisplayAdded(int displayId) {
            this.updatePresentationDisplays(displayId);
        }

        private final void $$robo$$android_media_MediaRouter_Static$onDisplayChanged(int displayId) {
            this.updatePresentationDisplays(displayId);
        }

        private final void $$robo$$android_media_MediaRouter_Static$onDisplayRemoved(int displayId) {
            this.updatePresentationDisplays(displayId);
        }

        private final Display[] $$robo$$android_media_MediaRouter_Static$getAllPresentationDisplays() {
            return this.mDisplayService.getDisplays("android.hardware.display.category.PRESENTATION");
        }

        private final void $$robo$$android_media_MediaRouter_Static$updatePresentationDisplays(int changedDisplayId) {
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                if (!route.updatePresentationDisplay() && (route.mPresentationDisplay == null || route.mPresentationDisplay.getDisplayId() != changedDisplayId)) continue;
                MediaRouter.dispatchRoutePresentationDisplayChanged(route);
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$setSelectedRoute(RouteInfo info, boolean explicit) {
            this.mSelectedRoute = info;
            this.publishClientSelectedRoute(explicit);
        }

        private final void $$robo$$android_media_MediaRouter_Static$rebindAsUser(int userId) {
            if (this.mCurrentUserId != userId || userId < 0 || this.mClient == null) {
                if (this.mClient != null) {
                    try {
                        this.mMediaRouterService.unregisterClient(this.mClient);
                    }
                    catch (RemoteException ex) {
                        Log.e("MediaRouter", "Unable to unregister media router client.", ex);
                    }
                    this.mClient = null;
                }
                this.mCurrentUserId = userId;
                try {
                    Client client = new Client(this);
                    this.mMediaRouterService.registerClientAsUser(client, this.mPackageName, userId);
                    this.mClient = client;
                }
                catch (RemoteException ex) {
                    Log.e("MediaRouter", "Unable to register media router client.", ex);
                }
                this.publishClientDiscoveryRequest();
                this.publishClientSelectedRoute(false);
                this.updateClientState();
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$publishClientDiscoveryRequest() {
            if (this.mClient != null) {
                try {
                    this.mMediaRouterService.setDiscoveryRequest(this.mClient, this.mDiscoveryRequestRouteTypes, this.mDiscoverRequestActiveScan);
                }
                catch (RemoteException ex) {
                    Log.e("MediaRouter", "Unable to publish media router client discovery request.", ex);
                }
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$publishClientSelectedRoute(boolean explicit) {
            if (this.mClient != null) {
                try {
                    this.mMediaRouterService.setSelectedRoute(this.mClient, this.mSelectedRoute != null ? this.mSelectedRoute.mGlobalRouteId : null, explicit);
                }
                catch (RemoteException ex) {
                    Log.e("MediaRouter", "Unable to publish media router client selected route.", ex);
                }
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$updateClientState() {
            int i;
            this.mClientState = null;
            if (this.mClient != null) {
                try {
                    this.mClientState = this.mMediaRouterService.getState(this.mClient);
                }
                catch (RemoteException ex) {
                    Log.e("MediaRouter", "Unable to retrieve media router client state.", ex);
                }
            }
            ArrayList<MediaRouterClientState.RouteInfo> globalRoutes = this.mClientState != null ? this.mClientState.routes : null;
            int globalRouteCount = globalRoutes != null ? globalRoutes.size() : 0;
            for (i = 0; i < globalRouteCount; ++i) {
                MediaRouterClientState.RouteInfo globalRoute = globalRoutes.get(i);
                RouteInfo route = this.findGlobalRoute(globalRoute.id);
                if (route == null) {
                    route = this.makeGlobalRoute(globalRoute);
                    MediaRouter.addRouteStatic(route);
                    continue;
                }
                this.updateGlobalRoute(route, globalRoute);
            }
            i = this.mRoutes.size();
            block3: while (i-- > 0) {
                RouteInfo route = this.mRoutes.get(i);
                String globalRouteId = route.mGlobalRouteId;
                if (globalRouteId == null) continue;
                for (int j = 0; j < globalRouteCount; ++j) {
                    MediaRouterClientState.RouteInfo globalRoute = globalRoutes.get(j);
                    if (globalRouteId.equals(globalRoute.id)) continue block3;
                }
                MediaRouter.removeRouteStatic(route);
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$requestSetVolume(RouteInfo route, int volume) {
            if (route.mGlobalRouteId != null && this.mClient != null) {
                try {
                    this.mMediaRouterService.requestSetVolume(this.mClient, route.mGlobalRouteId, volume);
                }
                catch (RemoteException ex) {
                    Log.w("MediaRouter", "Unable to request volume change.", ex);
                }
            }
        }

        private final void $$robo$$android_media_MediaRouter_Static$requestUpdateVolume(RouteInfo route, int direction) {
            if (route.mGlobalRouteId != null && this.mClient != null) {
                try {
                    this.mMediaRouterService.requestUpdateVolume(this.mClient, route.mGlobalRouteId, direction);
                }
                catch (RemoteException ex) {
                    Log.w("MediaRouter", "Unable to request volume change.", ex);
                }
            }
        }

        private final RouteInfo $$robo$$android_media_MediaRouter_Static$makeGlobalRoute(MediaRouterClientState.RouteInfo globalRoute) {
            RouteInfo route = new RouteInfo(this.mSystemCategory);
            route.mGlobalRouteId = globalRoute.id;
            route.mName = globalRoute.name;
            route.mDescription = globalRoute.description;
            route.mSupportedTypes = globalRoute.supportedTypes;
            route.mDeviceType = globalRoute.deviceType;
            route.mEnabled = globalRoute.enabled;
            route.setRealStatusCode(globalRoute.statusCode);
            route.mPlaybackType = globalRoute.playbackType;
            route.mPlaybackStream = globalRoute.playbackStream;
            route.mVolume = globalRoute.volume;
            route.mVolumeMax = globalRoute.volumeMax;
            route.mVolumeHandling = globalRoute.volumeHandling;
            route.mPresentationDisplayId = globalRoute.presentationDisplayId;
            route.updatePresentationDisplay();
            return route;
        }

        private final void $$robo$$android_media_MediaRouter_Static$updateGlobalRoute(RouteInfo route, MediaRouterClientState.RouteInfo globalRoute) {
            int oldSupportedTypes;
            boolean changed = false;
            boolean volumeChanged = false;
            boolean presentationDisplayChanged = false;
            if (!Objects.equals(route.mName, globalRoute.name)) {
                route.mName = globalRoute.name;
                changed = true;
            }
            if (!Objects.equals(route.mDescription, globalRoute.description)) {
                route.mDescription = globalRoute.description;
                changed = true;
            }
            if ((oldSupportedTypes = route.mSupportedTypes) != globalRoute.supportedTypes) {
                route.mSupportedTypes = globalRoute.supportedTypes;
                changed = true;
            }
            if (route.mEnabled != globalRoute.enabled) {
                route.mEnabled = globalRoute.enabled;
                changed = true;
            }
            if (route.mRealStatusCode != globalRoute.statusCode) {
                route.setRealStatusCode(globalRoute.statusCode);
                changed = true;
            }
            if (route.mPlaybackType != globalRoute.playbackType) {
                route.mPlaybackType = globalRoute.playbackType;
                changed = true;
            }
            if (route.mPlaybackStream != globalRoute.playbackStream) {
                route.mPlaybackStream = globalRoute.playbackStream;
                changed = true;
            }
            if (route.mVolume != globalRoute.volume) {
                route.mVolume = globalRoute.volume;
                changed = true;
                volumeChanged = true;
            }
            if (route.mVolumeMax != globalRoute.volumeMax) {
                route.mVolumeMax = globalRoute.volumeMax;
                changed = true;
                volumeChanged = true;
            }
            if (route.mVolumeHandling != globalRoute.volumeHandling) {
                route.mVolumeHandling = globalRoute.volumeHandling;
                changed = true;
                volumeChanged = true;
            }
            if (route.mPresentationDisplayId != globalRoute.presentationDisplayId) {
                route.mPresentationDisplayId = globalRoute.presentationDisplayId;
                route.updatePresentationDisplay();
                changed = true;
                presentationDisplayChanged = true;
            }
            if (changed) {
                MediaRouter.dispatchRouteChanged(route, oldSupportedTypes);
            }
            if (volumeChanged) {
                MediaRouter.dispatchRouteVolumeChanged(route);
            }
            if (presentationDisplayChanged) {
                MediaRouter.dispatchRoutePresentationDisplayChanged(route);
            }
        }

        private final RouteInfo $$robo$$android_media_MediaRouter_Static$findGlobalRoute(String globalRouteId) {
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                if (!globalRouteId.equals(route.mGlobalRouteId)) continue;
                return route;
            }
            return null;
        }

        private final boolean $$robo$$android_media_MediaRouter_Static$isPlaybackActive() {
            if (this.mClient != null) {
                try {
                    return this.mMediaRouterService.isPlaybackActive(this.mClient);
                }
                catch (RemoteException ex) {
                    Log.e("MediaRouter", "Unable to retrieve playback active state.", ex);
                }
            }
            return false;
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_media_MediaRouter_Static$__constructor__(context);
        }

        public Static(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Static$__constructor__(android.content.Context ), this, context);
        }

        void startMonitoringRoutes(Context context) {
            InvokeDynamicSupport.bootstrap("startMonitoringRoutes", $$robo$$android_media_MediaRouter_Static$startMonitoringRoutes(android.content.Context ), this, context);
        }

        void updateAudioRoutes(AudioRoutesInfo audioRoutesInfo) {
            InvokeDynamicSupport.bootstrap("updateAudioRoutes", $$robo$$android_media_MediaRouter_Static$updateAudioRoutes(android.media.AudioRoutesInfo ), this, audioRoutesInfo);
        }

        boolean isBluetoothA2dpOn() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothA2dpOn", $$robo$$android_media_MediaRouter_Static$isBluetoothA2dpOn(), this);
        }

        void updateDiscoveryRequest() {
            InvokeDynamicSupport.bootstrap("updateDiscoveryRequest", $$robo$$android_media_MediaRouter_Static$updateDiscoveryRequest(), this);
        }

        @Override
        public void onDisplayAdded(int n) {
            InvokeDynamicSupport.bootstrap("onDisplayAdded", $$robo$$android_media_MediaRouter_Static$onDisplayAdded(int ), this, n);
        }

        @Override
        public void onDisplayChanged(int n) {
            InvokeDynamicSupport.bootstrap("onDisplayChanged", $$robo$$android_media_MediaRouter_Static$onDisplayChanged(int ), this, n);
        }

        @Override
        public void onDisplayRemoved(int n) {
            InvokeDynamicSupport.bootstrap("onDisplayRemoved", $$robo$$android_media_MediaRouter_Static$onDisplayRemoved(int ), this, n);
        }

        public Display[] getAllPresentationDisplays() {
            return InvokeDynamicSupport.bootstrap("getAllPresentationDisplays", $$robo$$android_media_MediaRouter_Static$getAllPresentationDisplays(), this);
        }

        private void updatePresentationDisplays(int n) {
            InvokeDynamicSupport.bootstrap("updatePresentationDisplays", $$robo$$android_media_MediaRouter_Static$updatePresentationDisplays(int ), this, n);
        }

        void setSelectedRoute(RouteInfo routeInfo, boolean bl) {
            InvokeDynamicSupport.bootstrap("setSelectedRoute", $$robo$$android_media_MediaRouter_Static$setSelectedRoute(android.media.MediaRouter$RouteInfo boolean ), this, routeInfo, bl);
        }

        void rebindAsUser(int n) {
            InvokeDynamicSupport.bootstrap("rebindAsUser", $$robo$$android_media_MediaRouter_Static$rebindAsUser(int ), this, n);
        }

        void publishClientDiscoveryRequest() {
            InvokeDynamicSupport.bootstrap("publishClientDiscoveryRequest", $$robo$$android_media_MediaRouter_Static$publishClientDiscoveryRequest(), this);
        }

        void publishClientSelectedRoute(boolean bl) {
            InvokeDynamicSupport.bootstrap("publishClientSelectedRoute", $$robo$$android_media_MediaRouter_Static$publishClientSelectedRoute(boolean ), this, bl);
        }

        void updateClientState() {
            InvokeDynamicSupport.bootstrap("updateClientState", $$robo$$android_media_MediaRouter_Static$updateClientState(), this);
        }

        void requestSetVolume(RouteInfo routeInfo, int n) {
            InvokeDynamicSupport.bootstrap("requestSetVolume", $$robo$$android_media_MediaRouter_Static$requestSetVolume(android.media.MediaRouter$RouteInfo int ), this, routeInfo, n);
        }

        void requestUpdateVolume(RouteInfo routeInfo, int n) {
            InvokeDynamicSupport.bootstrap("requestUpdateVolume", $$robo$$android_media_MediaRouter_Static$requestUpdateVolume(android.media.MediaRouter$RouteInfo int ), this, routeInfo, n);
        }

        RouteInfo makeGlobalRoute(MediaRouterClientState.RouteInfo routeInfo) {
            return InvokeDynamicSupport.bootstrap("makeGlobalRoute", $$robo$$android_media_MediaRouter_Static$makeGlobalRoute(android.media.MediaRouterClientState$RouteInfo ), this, routeInfo);
        }

        void updateGlobalRoute(RouteInfo routeInfo, MediaRouterClientState.RouteInfo routeInfo2) {
            InvokeDynamicSupport.bootstrap("updateGlobalRoute", $$robo$$android_media_MediaRouter_Static$updateGlobalRoute(android.media.MediaRouter$RouteInfo android.media.MediaRouterClientState$RouteInfo ), this, routeInfo, routeInfo2);
        }

        RouteInfo findGlobalRoute(String string2) {
            return InvokeDynamicSupport.bootstrap("findGlobalRoute", $$robo$$android_media_MediaRouter_Static$findGlobalRoute(java.lang.String ), this, string2);
        }

        boolean isPlaybackActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPlaybackActive", $$robo$$android_media_MediaRouter_Static$isPlaybackActive(), this);
        }

        public /* synthetic */ Static() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Static)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public final class Client
        extends IMediaRouterClient.Stub
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Static this$0;

            private void $$robo$$android_media_MediaRouter_Static_Client$__constructor__(Static this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaRouter_Static_Client$onStateChanged() {
                this.this$0.mHandler.post(new Runnable(this){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ Client this$1;

                    private void $$robo$$android_media_MediaRouter_Static_Client_1$__constructor__(Client this$1) {
                        this.this$1 = this$1;
                    }

                    private final void $$robo$$android_media_MediaRouter_Static_Client_1$run() {
                        if (this.this$1 == this.this$1.this$0.mClient) {
                            this.this$1.this$0.updateClientState();
                        }
                    }

                    private void __constructor__(Client client) {
                        this.$$robo$$android_media_MediaRouter_Static_Client_1$__constructor__(client);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Static_Client_1$__constructor__(android.media.MediaRouter$Static$Client ), this, client);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaRouter_Static_Client_1$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_media_MediaRouter_Static_Client$onRestoreRoute() {
                this.this$0.mHandler.post(new Runnable(this){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ Client this$1;

                    private void $$robo$$android_media_MediaRouter_Static_Client_2$__constructor__(Client this$1) {
                        this.this$1 = this$1;
                    }

                    private final void $$robo$$android_media_MediaRouter_Static_Client_2$run() {
                        if (this.this$1 != this.this$1.this$0.mClient || this.this$1.this$0.mSelectedRoute == null || this.this$1.this$0.mSelectedRoute != this.this$1.this$0.mDefaultAudioVideo && this.this$1.this$0.mSelectedRoute != this.this$1.this$0.mBluetoothA2dpRoute) {
                            return;
                        }
                        Log.v("MediaRouter", "onRestoreRoute() : route=" + this.this$1.this$0.mSelectedRoute);
                        this.this$1.this$0.mSelectedRoute.select();
                    }

                    private void __constructor__(Client client) {
                        this.$$robo$$android_media_MediaRouter_Static_Client_2$__constructor__(client);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Static_Client_2$__constructor__(android.media.MediaRouter$Static$Client ), this, client);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaRouter_Static_Client_2$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(Static static_) {
                this.$$robo$$android_media_MediaRouter_Static_Client$__constructor__(static_);
            }

            public Client(Static static_) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRouter_Static_Client$__constructor__(android.media.MediaRouter$Static ), this, static_);
            }

            @Override
            public void onStateChanged() {
                InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_media_MediaRouter_Static_Client$onStateChanged(), this);
            }

            @Override
            public void onRestoreRoute() {
                InvokeDynamicSupport.bootstrap("onRestoreRoute", $$robo$$android_media_MediaRouter_Static_Client$onRestoreRoute(), this);
            }

            public /* synthetic */ Client() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Client)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

