/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.AudioTrack;
import android.media.BufferingParams;
import android.media.DataSourceDesc;
import android.media.DeniedByServerException;
import android.media.Media2DataSource;
import android.media.Media2HTTPService;
import android.media.MediaDrm;
import android.media.MediaFormat;
import android.media.MediaPlayer2;
import android.media.MediaPlayerBase;
import android.media.MediaTimeProvider;
import android.media.MediaTimestamp;
import android.media.Metadata;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.NotProvisionedException;
import android.media.PlaybackParams;
import android.media.ResourceBusyException;
import android.media.RingtoneManager;
import android.media.SRTRenderer;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.media.UnsupportedSchemeException;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoBridge;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaPlayer2Impl
extends MediaPlayer2
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaPlayer2Impl";
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mStreamType;
    private CloseGuard mGuard;
    private Object mSrcLock;
    private long mSrcIdGenerator;
    private DataSourceDesc mCurrentDSD;
    private long mCurrentSrcId;
    private List<DataSourceDesc> mNextDSDs;
    private long mNextSrcId;
    private int mNextSourceState;
    private boolean mNextSourcePlayPending;
    private AtomicInteger mBufferedPercentageCurrent;
    private AtomicInteger mBufferedPercentageNext;
    private volatile float mVolume;
    private Object mDrmLock;
    private UUID mDrmUUID;
    private DrmInfoImpl mDrmInfoImpl;
    private MediaDrm mDrmObj;
    private byte[] mDrmSessionId;
    private boolean mDrmInfoResolved;
    private boolean mActiveDrmScheme;
    private boolean mDrmConfigAllowed;
    private boolean mDrmProvisioningInProgress;
    private boolean mPrepareDrmInProgress;
    private ProvisioningThread mDrmProvisioningThread;
    private HandlerThread mHandlerThread;
    private Handler mTaskHandler;
    private Object mTaskLock;
    @GuardedBy(value="mTaskLock")
    private List<Task> mPendingTasks;
    @GuardedBy(value="mTaskLock")
    private Task mCurrentTask;
    private static int NEXT_SOURCE_STATE_ERROR = -1;
    private static int NEXT_SOURCE_STATE_INIT = 0;
    private static int NEXT_SOURCE_STATE_PREPARING = 1;
    private static int NEXT_SOURCE_STATE_PREPARED = 2;
    private static int INVOKE_ID_GET_TRACK_INFO = 1;
    private static int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static int INVOKE_ID_SELECT_TRACK = 4;
    private static int INVOKE_ID_DESELECT_TRACK = 5;
    private static int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    private static int INVOKE_ID_GET_SELECTED_TRACK = 7;
    private AudioDeviceInfo mPreferredDevice;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners;
    private static int KEY_PARAMETER_AUDIO_ATTRIBUTES = 1400;
    private Vector<Pair<Integer, SubtitleTrack>> mIndexTrackPairs;
    private BitSet mInbandTrackIndices;
    private SubtitleController mSubtitleController;
    private int mSelectedSubtitleTrackIndex;
    private Vector<InputStream> mOpenSubtitleSources;
    private MediaPlayer2.OnSubtitleDataListener mSubtitleDataListener;
    private static int MEDIA_NOP = 0;
    private static int MEDIA_PREPARED = 1;
    private static int MEDIA_PLAYBACK_COMPLETE = 2;
    private static int MEDIA_BUFFERING_UPDATE = 3;
    private static int MEDIA_SEEK_COMPLETE = 4;
    private static int MEDIA_SET_VIDEO_SIZE = 5;
    private static int MEDIA_STARTED = 6;
    private static int MEDIA_PAUSED = 7;
    private static int MEDIA_STOPPED = 8;
    private static int MEDIA_SKIPPED = 9;
    private static int MEDIA_NOTIFY_TIME = 98;
    private static int MEDIA_TIMED_TEXT = 99;
    private static int MEDIA_ERROR = 100;
    private static int MEDIA_INFO = 200;
    private static int MEDIA_SUBTITLE_DATA = 201;
    private static int MEDIA_META_DATA = 202;
    private static int MEDIA_DRM_INFO = 210;
    private static int MEDIA_AUDIO_ROUTING_CHANGED = 10000;
    private TimeProvider mTimeProvider;
    private Object mEventCbLock;
    private ArrayList<Pair<Executor, MediaPlayer2.MediaPlayer2EventCallback>> mEventCallbackRecords;
    private MediaPlayer2.OnSubtitleDataListener mOnSubtitleDataListener;
    private MediaPlayer2.OnDrmConfigHelper mOnDrmConfigHelper;
    private Object mDrmEventCbLock;
    private ArrayList<Pair<Executor, MediaPlayer2.DrmEventCallback>> mDrmEventCallbackRecords;

    private void $$robo$$android_media_MediaPlayer2Impl$__constructor__() {
        this.mWakeLock = null;
        this.mStreamType = Integer.MIN_VALUE;
        this.mGuard = CloseGuard.get();
        this.mSrcLock = new Object();
        this.mSrcIdGenerator = 0L;
        this.mCurrentSrcId = this.mSrcIdGenerator++;
        this.mNextSrcId = this.mSrcIdGenerator++;
        this.mNextSourceState = 0;
        this.mNextSourcePlayPending = false;
        this.mBufferedPercentageCurrent = new AtomicInteger(0);
        this.mBufferedPercentageNext = new AtomicInteger(0);
        this.mVolume = 1.0f;
        this.mDrmLock = new Object();
        this.mTaskLock = new Object();
        this.mPendingTasks = new LinkedList<Task>();
        this.mPreferredDevice = null;
        this.mRoutingChangeListeners = new ArrayMap();
        this.mIndexTrackPairs = new Vector();
        this.mInbandTrackIndices = new BitSet();
        this.mSelectedSubtitleTrackIndex = -1;
        this.mSubtitleDataListener = new MediaPlayer2.OnSubtitleDataListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_25$__constructor__(MediaPlayer2Impl this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_25$onSubtitleData(MediaPlayer2 mp, SubtitleData data) {
                int index = data.getTrackIndex();
                Vector vector = this.this$0.mIndexTrackPairs;
                synchronized (vector) {
                    for (Pair p : this.this$0.mIndexTrackPairs) {
                        if (p.first == null || (Integer)p.first != index || p.second == null) continue;
                        SubtitleTrack track = (SubtitleTrack)p.second;
                        track.onData(data);
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl) {
                this.$$robo$$android_media_MediaPlayer2Impl_25$__constructor__(mediaPlayer2Impl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_25$__constructor__(android.media.MediaPlayer2Impl ), this, mediaPlayer2Impl);
            }

            @Override
            public void onSubtitleData(MediaPlayer2 mediaPlayer2, SubtitleData subtitleData) {
                InvokeDynamicSupport.bootstrap("onSubtitleData", $$robo$$android_media_MediaPlayer2Impl_25$onSubtitleData(android.media.MediaPlayer2 android.media.SubtitleData ), this, mediaPlayer2, subtitleData);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mEventCbLock = new Object();
        this.mEventCallbackRecords = new ArrayList();
        this.mDrmEventCbLock = new Object();
        this.mDrmEventCallbackRecords = new ArrayList();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        this.mHandlerThread = new HandlerThread("MediaPlayer2TaskThread");
        this.mHandlerThread.start();
        looper = this.mHandlerThread.getLooper();
        this.mTaskHandler = new Handler(looper);
        this.mTimeProvider = new TimeProvider(this);
        this.mOpenSubtitleSources = new Vector();
        this.mGuard.open("close");
        this.native_setup(new WeakReference<MediaPlayer2Impl>(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$close() {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            this.release();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$play() {
        this.addTask((Task)new ShadowedObject(this, 5, false){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_1$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_1$process() {
                this.this$0.stayAwake(true);
                this.this$0._start();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
                this.$$robo$$android_media_MediaPlayer2Impl_1$__constructor__(mediaPlayer2Impl, n, bl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_1$__constructor__(android.media.MediaPlayer2Impl int boolean ), this, mediaPlayer2Impl, n, bl);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_1$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_start() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$prepare() {
        this.addTask((Task)new ShadowedObject(this, 6, true){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_2$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_2$process() {
                this.this$0._prepare();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
                this.$$robo$$android_media_MediaPlayer2Impl_2$__constructor__(mediaPlayer2Impl, n, bl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_2$__constructor__(android.media.MediaPlayer2Impl int boolean ), this, mediaPlayer2Impl, n, bl);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_2$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_prepare() {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$pause() {
        this.addTask((Task)new ShadowedObject(this, 4, false){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_3$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_3$process() {
                this.this$0.stayAwake(false);
                this.this$0._pause();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
                this.$$robo$$android_media_MediaPlayer2Impl_3$__constructor__(mediaPlayer2Impl, n, bl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_3$__constructor__(android.media.MediaPlayer2Impl int boolean ), this, mediaPlayer2Impl, n, bl);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_3$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_pause() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$skipToNext() {
        this.addTask((Task)new ShadowedObject(this, 29, false){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_4$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_4$process() {
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
                this.$$robo$$android_media_MediaPlayer2Impl_4$__constructor__(mediaPlayer2Impl, n, bl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_4$__constructor__(android.media.MediaPlayer2Impl int boolean ), this, mediaPlayer2Impl, n, bl);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_4$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final long $$robo$$android_media_MediaPlayer2Impl$getCurrentPosition() {
        return 0L;
    }

    private final long $$robo$$android_media_MediaPlayer2Impl$getDuration() {
        return 0L;
    }

    private final long $$robo$$android_media_MediaPlayer2Impl$getBufferedPosition() {
        return this.getDuration() * (long)this.mBufferedPercentageCurrent.get() / 100L;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getPlayerState() {
        int playerState;
        int mediaplayer2State = this.getMediaPlayer2State();
        switch (mediaplayer2State) {
            case 1: {
                playerState = 0;
                break;
            }
            case 2: 
            case 3: {
                playerState = 1;
                break;
            }
            case 4: {
                playerState = 2;
                break;
            }
            default: {
                playerState = 3;
            }
        }
        return playerState;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getBufferingState() {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setAudioAttributes(AudioAttributes attributes) {
        this.addTask((Task)new ShadowedObject(this, 16, false, attributes){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioAttributes val$attributes;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_5$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, AudioAttributes audioAttributes) {
                this.this$0 = this$0;
                this.val$attributes = audioAttributes;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_5$process() {
                if (this.val$attributes == null) {
                    String msg = "Cannot set AudioAttributes to null";
                    throw new IllegalArgumentException("Cannot set AudioAttributes to null");
                }
                Parcel pattributes = Parcel.obtain();
                this.val$attributes.writeToParcel(pattributes, 1);
                this.this$0.setParameter(1400, pattributes);
                pattributes.recycle();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, AudioAttributes audioAttributes) {
                this.$$robo$$android_media_MediaPlayer2Impl_5$__constructor__(mediaPlayer2Impl, n, bl, audioAttributes);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_5$__constructor__(android.media.MediaPlayer2Impl int boolean android.media.AudioAttributes ), this, mediaPlayer2Impl, n, bl, audioAttributes);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_5$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final AudioAttributes $$robo$$android_media_MediaPlayer2Impl$getAudioAttributes() {
        Parcel pattributes = this.getParameter(1400);
        AudioAttributes attributes = AudioAttributes.CREATOR.createFromParcel(pattributes);
        pattributes.recycle();
        return attributes;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setDataSource(DataSourceDesc dsd) {
        this.addTask((Task)new ShadowedObject(this, 19, false, dsd){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DataSourceDesc val$dsd;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_6$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, DataSourceDesc dataSourceDesc) {
                this.this$0 = this$0;
                this.val$dsd = dataSourceDesc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_6$process() {
                Preconditions.checkNotNull(this.val$dsd, "the DataSourceDesc cannot be null");
                Object object = this.this$0.mSrcLock;
                synchronized (object) {
                    this.this$0.mCurrentDSD = this.val$dsd;
                    this.this$0.mCurrentSrcId = this.this$0.mSrcIdGenerator++;
                    try {
                        this.this$0.handleDataSource(true, this.val$dsd, this.this$0.mCurrentSrcId);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, DataSourceDesc dataSourceDesc) {
                this.$$robo$$android_media_MediaPlayer2Impl_6$__constructor__(mediaPlayer2Impl, n, bl, dataSourceDesc);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_6$__constructor__(android.media.MediaPlayer2Impl int boolean android.media.DataSourceDesc ), this, mediaPlayer2Impl, n, bl, dataSourceDesc);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_6$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setNextDataSource(DataSourceDesc dsd) {
        this.addTask((Task)new ShadowedObject(this, 22, false, dsd){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DataSourceDesc val$dsd;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_7$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, DataSourceDesc dataSourceDesc) {
                this.this$0 = this$0;
                this.val$dsd = dataSourceDesc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_7$process() {
                Preconditions.checkNotNull(this.val$dsd, "the DataSourceDesc cannot be null");
                Object object = this.this$0.mSrcLock;
                synchronized (object) {
                    this.this$0.mNextDSDs = new ArrayList(1);
                    this.this$0.mNextDSDs.add(this.val$dsd);
                    this.this$0.mNextSrcId = this.this$0.mSrcIdGenerator++;
                    this.this$0.mNextSourceState = 0;
                    this.this$0.mNextSourcePlayPending = false;
                }
                int state = this.this$0.getMediaPlayer2State();
                if (state != 1) {
                    Object object2 = this.this$0.mSrcLock;
                    synchronized (object2) {
                        this.this$0.prepareNextDataSource_l();
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, DataSourceDesc dataSourceDesc) {
                this.$$robo$$android_media_MediaPlayer2Impl_7$__constructor__(mediaPlayer2Impl, n, bl, dataSourceDesc);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_7$__constructor__(android.media.MediaPlayer2Impl int boolean android.media.DataSourceDesc ), this, mediaPlayer2Impl, n, bl, dataSourceDesc);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_7$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setNextDataSources(List<DataSourceDesc> dsds) {
        this.addTask((Task)new ShadowedObject(this, 23, false, dsds){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ List val$dsds;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_8$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, List list) {
                this.this$0 = this$0;
                this.val$dsds = list;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_8$process() {
                if (this.val$dsds == null || this.val$dsds.size() == 0) {
                    throw new IllegalArgumentException("data source list cannot be null or empty.");
                }
                for (DataSourceDesc dsd : this.val$dsds) {
                    if (dsd != null) continue;
                    throw new IllegalArgumentException("DataSourceDesc in the source list cannot be null.");
                }
                Object object = this.this$0.mSrcLock;
                synchronized (object) {
                    this.this$0.mNextDSDs = new ArrayList(this.val$dsds);
                    this.this$0.mNextSrcId = this.this$0.mSrcIdGenerator++;
                    this.this$0.mNextSourceState = 0;
                    this.this$0.mNextSourcePlayPending = false;
                }
                int state = this.this$0.getMediaPlayer2State();
                if (state != 1) {
                    Object object2 = this.this$0.mSrcLock;
                    synchronized (object2) {
                        this.this$0.prepareNextDataSource_l();
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, List list) {
                this.$$robo$$android_media_MediaPlayer2Impl_8$__constructor__(mediaPlayer2Impl, n, bl, list);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_8$__constructor__(android.media.MediaPlayer2Impl int boolean java.util.List ), this, mediaPlayer2Impl, n, bl, list);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_8$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceDesc $$robo$$android_media_MediaPlayer2Impl$getCurrentDataSource() {
        Object object = this.mSrcLock;
        synchronized (object) {
            return this.mCurrentDSD;
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$loopCurrent(boolean loop) {
        this.addTask((Task)new ShadowedObject(this, 3, false, loop){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ boolean val$loop;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_9$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, boolean bl) {
                this.this$0 = this$0;
                this.val$loop = bl;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_9$process() {
                this.this$0.setLooping(this.val$loop);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, boolean bl2) {
                this.$$robo$$android_media_MediaPlayer2Impl_9$__constructor__(mediaPlayer2Impl, n, bl, bl2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_9$__constructor__(android.media.MediaPlayer2Impl int boolean boolean ), this, mediaPlayer2Impl, n, bl, bl2);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_9$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setLooping(boolean bl) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setPlaybackSpeed(float speed) {
        this.addTask((Task)new ShadowedObject(this, 25, false, speed){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ float val$speed;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_10$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, float f) {
                this.this$0 = this$0;
                this.val$speed = f;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_10$process() {
                this.this$0._setPlaybackParams(this.this$0.getPlaybackParams().setSpeed(this.val$speed));
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, float f) {
                this.$$robo$$android_media_MediaPlayer2Impl_10$__constructor__(mediaPlayer2Impl, n, bl, f);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_10$__constructor__(android.media.MediaPlayer2Impl int boolean float ), this, mediaPlayer2Impl, n, bl, f);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_10$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final float $$robo$$android_media_MediaPlayer2Impl$getPlaybackSpeed() {
        return this.getPlaybackParams().getSpeed();
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$isReversePlaybackSupported() {
        return false;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setPlayerVolume(float volume) {
        this.addTask((Task)new ShadowedObject(this, 26, false, volume){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ float val$volume;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_11$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, float f) {
                this.this$0 = this$0;
                this.val$volume = f;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_11$process() {
                this.this$0.mVolume = this.val$volume;
                this.this$0._setVolume(this.val$volume, this.val$volume);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, float f) {
                this.$$robo$$android_media_MediaPlayer2Impl_11$__constructor__(mediaPlayer2Impl, n, bl, f);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_11$__constructor__(android.media.MediaPlayer2Impl int boolean float ), this, mediaPlayer2Impl, n, bl, f);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_11$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setVolume(float f, float f2) {
    }

    private final float $$robo$$android_media_MediaPlayer2Impl$getPlayerVolume() {
        return this.mVolume;
    }

    private final float $$robo$$android_media_MediaPlayer2Impl$getMaxPlayerVolume() {
        return 1.0f;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$registerPlayerEventCallback(Executor e, MediaPlayerBase.PlayerEventCallback cb) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$unregisterPlayerEventCallback(MediaPlayerBase.PlayerEventCallback cb) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setVideoSurface(Surface surface) {
    }

    private final Parcel $$robo$$android_media_MediaPlayer2Impl$newRequest() {
        Parcel parcel = Parcel.obtain();
        return parcel;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        if (retcode != 0) {
            throw new RuntimeException("failure code: " + retcode);
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$notifyWhenCommandLabelReached(Object label) {
        this.addTask((Task)new ShadowedObject(this, 1003, false, label){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Object val$label;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_12$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, Object object) {
                this.this$0 = this$0;
                this.val$label = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_12$process() {
                Object object = this.this$0.mEventCbLock;
                synchronized (object) {
                    for (Pair cb : this.this$0.mEventCallbackRecords) {
                        ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onCommandLabelReached(this.this$0, this.val$label));
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, Object object) {
                this.$$robo$$android_media_MediaPlayer2Impl_12$__constructor__(mediaPlayer2Impl, n, bl, object);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_12$__constructor__(android.media.MediaPlayer2Impl int boolean java.lang.Object ), this, mediaPlayer2Impl, n, bl, object);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_12$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setSurface(Surface surface) {
        this.addTask((Task)new ShadowedObject(this, 27, false, surface){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Surface val$surface;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_13$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, Surface surface) {
                this.this$0 = this$0;
                this.val$surface = surface;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_13$process() {
                if (this.this$0.mScreenOnWhilePlaying && this.val$surface != null) {
                    Log.w("MediaPlayer2Impl", "setScreenOnWhilePlaying(true) is ineffective for Surface");
                }
                this.this$0.mSurfaceHolder = null;
                this.this$0._setVideoSurface(this.val$surface);
                this.this$0.updateSurfaceScreenOn();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, Surface surface) {
                this.$$robo$$android_media_MediaPlayer2Impl_13$__constructor__(mediaPlayer2Impl, n, bl, surface);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_13$__constructor__(android.media.MediaPlayer2Impl int boolean android.view.Surface ), this, mediaPlayer2Impl, n, bl, surface);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_13$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setVideoScalingMode(int mode) {
        this.addTask((Task)new ShadowedObject(this, 1002, false, mode){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$mode;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_14$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, int n) {
                this.this$0 = this$0;
                this.val$mode = n;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_14$process() {
                if (!this.this$0.isVideoScalingModeSupported(this.val$mode)) {
                    String msg = "Scaling mode " + this.val$mode + " is not supported";
                    throw new IllegalArgumentException(msg);
                }
                Parcel request = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    request.writeInt(6);
                    request.writeInt(this.val$mode);
                    this.this$0.invoke(request, reply);
                }
                finally {
                    request.recycle();
                    reply.recycle();
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, int n2) {
                this.$$robo$$android_media_MediaPlayer2Impl_14$__constructor__(mediaPlayer2Impl, n, bl, n2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_14$__constructor__(android.media.MediaPlayer2Impl int boolean int ), this, mediaPlayer2Impl, n, bl, n2);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_14$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$clearPendingCommands() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$addTask(Task task) {
        Object object = this.mTaskLock;
        synchronized (object) {
            this.mPendingTasks.add(task);
            this.processPendingTask_l();
        }
    }

    @GuardedBy(value="mTaskLock")
    private final void $$robo$$android_media_MediaPlayer2Impl$processPendingTask_l() {
        if (this.mCurrentTask != null) {
            return;
        }
        if (!this.mPendingTasks.isEmpty()) {
            Task task;
            this.mCurrentTask = task = this.mPendingTasks.remove(0);
            this.mTaskHandler.post(task);
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean isCurrent, DataSourceDesc dsd, long srcId) throws IOException {
        Preconditions.checkNotNull(dsd, "the DataSourceDesc cannot be null");
        switch (dsd.getType()) {
            case 1: {
                this.handleDataSource(isCurrent, srcId, dsd.getMedia2DataSource());
                break;
            }
            case 2: {
                this.handleDataSource(isCurrent, srcId, dsd.getFileDescriptor(), dsd.getFileDescriptorOffset(), dsd.getFileDescriptorLength());
                break;
            }
            case 3: {
                this.handleDataSource(isCurrent, srcId, dsd.getUriContext(), dsd.getUri(), dsd.getUriHeaders(), dsd.getUriCookies());
                break;
            }
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean isCurrent, long srcId, Context context, Uri uri, Map<String, String> headers, List<HttpCookie> cookies) throws IOException {
        ContentResolver resolver = context.getContentResolver();
        String scheme = uri.getScheme();
        String authority = ContentProvider.getAuthorityWithoutUserId(uri.getAuthority());
        if ("file".equals(scheme)) {
            this.handleDataSource(isCurrent, srcId, uri.getPath(), null, null);
            return;
        }
        if ("content".equals(scheme) && "settings".equals(authority)) {
            int type = RingtoneManager.getDefaultType(uri);
            Uri cacheUri = RingtoneManager.getCacheForType(type, context.getUserId());
            Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, type);
            if (this.attemptDataSource(isCurrent, srcId, resolver, cacheUri)) {
                return;
            }
            if (this.attemptDataSource(isCurrent, srcId, resolver, actualUri)) {
                return;
            }
            this.handleDataSource(isCurrent, srcId, uri.toString(), headers, cookies);
        } else {
            if (this.attemptDataSource(isCurrent, srcId, resolver, uri)) {
                return;
            }
            this.handleDataSource(isCurrent, srcId, uri.toString(), headers, cookies);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean $$robo$$android_media_MediaPlayer2Impl$attemptDataSource(boolean isCurrent, long srcId, ContentResolver resolver, Uri uri) {
        try (AssetFileDescriptor afd = resolver.openAssetFileDescriptor(uri, "r");){
            if (afd.getDeclaredLength() < 0L) {
                this.handleDataSource(isCurrent, srcId, afd.getFileDescriptor(), 0L, 0x7FFFFFFFFFFFFFFL);
            } else {
                this.handleDataSource(isCurrent, srcId, afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | NullPointerException | SecurityException ex) {
            Log.w("MediaPlayer2Impl", "Couldn't open " + uri + ": " + ex);
            return false;
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean isCurrent, long srcId, String path, Map<String, String> headers, List<HttpCookie> cookies) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.handleDataSource(isCurrent, srcId, path, keys, values, cookies);
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean isCurrent, long srcId, String path, String[] keys, String[] values, List<HttpCookie> cookies) throws IOException {
        Uri uri = Uri.parse(path);
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if (scheme != null) {
            this.nativeHandleDataSourceUrl(isCurrent, srcId, Media2HTTPService.createHTTPService(path, cookies), path, keys, values);
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("handleDataSource failed.");
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.handleDataSource(isCurrent, srcId, fd, 0L, 0x7FFFFFFFFFFFFFFL);
        is.close();
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$nativeHandleDataSourceUrl(boolean bl, long l, Media2HTTPService media2HTTPService, String string2, String[] stringArray, String[] stringArray2) throws IOException {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean isCurrent, long srcId, FileDescriptor fd, long offset, long length) throws IOException {
        this.nativeHandleDataSourceFD(isCurrent, srcId, fd, offset, length);
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$nativeHandleDataSourceFD(boolean bl, long l, FileDescriptor fileDescriptor, long l2, long l3) throws IOException {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean isCurrent, long srcId, Media2DataSource dataSource) {
        this.nativeHandleDataSourceCallback(isCurrent, srcId, dataSource);
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$nativeHandleDataSourceCallback(boolean bl, long l, Media2DataSource media2DataSource) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$prepareNextDataSource_l() {
        if (this.mNextDSDs == null || this.mNextDSDs.isEmpty() || this.mNextSourceState != 0) {
            return;
        }
        try {
            this.mNextSourceState = 1;
            this.handleDataSource(false, this.mNextDSDs.get(0), this.mNextSrcId);
        }
        catch (Exception e) {
            Message msg2 = this.mEventHandler.obtainMessage(100, 1, -1010, null);
            long nextSrcId = this.mNextSrcId;
            this.mEventHandler.post(new Runnable(this, msg2, nextSrcId){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Message val$msg2;
                /* synthetic */ long val$nextSrcId;
                /* synthetic */ MediaPlayer2Impl this$0;

                private void $$robo$$android_media_MediaPlayer2Impl_15$__constructor__(MediaPlayer2Impl this$0, Message message, long l) {
                    this.this$0 = this$0;
                    this.val$msg2 = message;
                    this.val$nextSrcId = l;
                }

                private final void $$robo$$android_media_MediaPlayer2Impl_15$run() {
                    this.this$0.mEventHandler.handleMessage(this.val$msg2, this.val$nextSrcId);
                }

                private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, Message message, long l) {
                    this.$$robo$$android_media_MediaPlayer2Impl_15$__constructor__(mediaPlayer2Impl, message, l);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_15$__constructor__(android.media.MediaPlayer2Impl android.os.Message long ), this, mediaPlayer2Impl, message, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_15$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$playNextDataSource_l() {
        if (this.mNextDSDs == null || this.mNextDSDs.isEmpty()) {
            return;
        }
        if (this.mNextSourceState == 2) {
            this.mCurrentDSD = this.mNextDSDs.get(0);
            this.mCurrentSrcId = this.mNextSrcId;
            this.mBufferedPercentageCurrent.set(this.mBufferedPercentageNext.get());
            this.mNextDSDs.remove(0);
            this.mNextSrcId = this.mSrcIdGenerator++;
            this.mBufferedPercentageNext.set(0);
            this.mNextSourceState = 0;
            this.mNextSourcePlayPending = false;
            long srcId = this.mCurrentSrcId;
            try {
                this.nativePlayNextDataSource(srcId);
            }
            catch (Exception e) {
                Message msg2 = this.mEventHandler.obtainMessage(100, 1, -1010, null);
                this.mEventHandler.post(new Runnable(this, msg2, srcId){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ Message val$msg2;
                    /* synthetic */ long val$srcId;
                    /* synthetic */ MediaPlayer2Impl this$0;

                    private void $$robo$$android_media_MediaPlayer2Impl_16$__constructor__(MediaPlayer2Impl this$0, Message message, long l) {
                        this.this$0 = this$0;
                        this.val$msg2 = message;
                        this.val$srcId = l;
                    }

                    private final void $$robo$$android_media_MediaPlayer2Impl_16$run() {
                        this.this$0.mEventHandler.handleMessage(this.val$msg2, this.val$srcId);
                    }

                    private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, Message message, long l) {
                        this.$$robo$$android_media_MediaPlayer2Impl_16$__constructor__(mediaPlayer2Impl, message, l);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_16$__constructor__(android.media.MediaPlayer2Impl android.os.Message long ), this, mediaPlayer2Impl, message, l);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_16$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        } else {
            if (this.mNextSourceState == 0) {
                this.prepareNextDataSource_l();
            }
            this.mNextSourcePlayPending = true;
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$nativePlayNextDataSource(long l) {
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getAudioStreamType() {
        if (this.mStreamType == Integer.MIN_VALUE) {
            this.mStreamType = this._getAudioStreamType();
        }
        return this.mStreamType;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$_getAudioStreamType() throws IllegalStateException {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$stop() {
        this.stayAwake(false);
        this._stop();
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_stop() throws IllegalStateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_MediaPlayer2Impl$setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            MediaPlayer2Impl mediaPlayer2Impl = this;
            synchronized (mediaPlayer2Impl) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AudioDeviceInfo $$robo$$android_media_MediaPlayer2Impl$getPreferredDevice() {
        MediaPlayer2Impl mediaPlayer2Impl = this;
        synchronized (mediaPlayer2Impl) {
            return this.mPreferredDevice;
        }
    }

    private final AudioDeviceInfo $$robo$$android_media_MediaPlayer2Impl$getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(2);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private final void $$robo$$android_media_MediaPlayer2Impl$enableNativeRoutingCallbacksLocked(boolean enabled) {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.enableNativeRoutingCallbacksLocked(true);
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : this.mEventHandler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
                this.enableNativeRoutingCallbacksLocked(false);
            }
        }
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$native_setOutputDevice(int n) {
        return false;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$native_getRoutedDeviceId() {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$native_enableDeviceCallback(boolean bl) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (SystemProperties.getBoolean("audio.offload.ignore_setawake", false)) {
            Log.w("MediaPlayer2Impl", "IGNORING setWakeMode " + mode);
            return;
        }
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer2Impl.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w("MediaPlayer2Impl", "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getVideoWidth() {
        return 0;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getVideoHeight() {
        return 0;
    }

    private final PersistableBundle $$robo$$android_media_MediaPlayer2Impl$getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_MediaPlayer2Impl$native_getMetrics() {
        return null;
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$isPlaying() {
        return false;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getMediaPlayer2State() {
        return this.native_getMediaPlayer2State();
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$native_getMediaPlayer2State() {
        return 0;
    }

    private final BufferingParams $$robo$$android_media_MediaPlayer2Impl$getBufferingParams() {
        return null;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setBufferingParams(BufferingParams params) {
        this.addTask((Task)new ShadowedObject(this, 1001, false, params){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BufferingParams val$params;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_17$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, BufferingParams bufferingParams) {
                this.this$0 = this$0;
                this.val$params = bufferingParams;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_17$process() {
                Preconditions.checkNotNull(this.val$params, "the BufferingParams cannot be null");
                this.this$0._setBufferingParams(this.val$params);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, BufferingParams bufferingParams) {
                this.$$robo$$android_media_MediaPlayer2Impl_17$__constructor__(mediaPlayer2Impl, n, bl, bufferingParams);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_17$__constructor__(android.media.MediaPlayer2Impl int boolean android.media.BufferingParams ), this, mediaPlayer2Impl, n, bl, bufferingParams);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_17$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setBufferingParams(BufferingParams bufferingParams) {
    }

    private final PlaybackParams $$robo$$android_media_MediaPlayer2Impl$easyPlaybackParams(float rate, int audioMode) {
        PlaybackParams params = new PlaybackParams();
        params.allowDefaults();
        switch (audioMode) {
            case 0: {
                params.setSpeed(rate).setPitch(1.0f);
                break;
            }
            case 1: {
                params.setSpeed(rate).setPitch(1.0f).setAudioFallbackMode(2);
                break;
            }
            case 2: {
                params.setSpeed(rate).setPitch(rate);
                break;
            }
            default: {
                String msg = "Audio playback mode " + audioMode + " is not supported";
                throw new IllegalArgumentException(msg);
            }
        }
        return params;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setPlaybackParams(PlaybackParams params) {
        this.addTask((Task)new ShadowedObject(this, 24, false, params){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PlaybackParams val$params;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_18$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, PlaybackParams playbackParams) {
                this.this$0 = this$0;
                this.val$params = playbackParams;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_18$process() {
                Preconditions.checkNotNull(this.val$params, "the PlaybackParams cannot be null");
                this.this$0._setPlaybackParams(this.val$params);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, PlaybackParams playbackParams) {
                this.$$robo$$android_media_MediaPlayer2Impl_18$__constructor__(mediaPlayer2Impl, n, bl, playbackParams);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_18$__constructor__(android.media.MediaPlayer2Impl int boolean android.media.PlaybackParams ), this, mediaPlayer2Impl, n, bl, playbackParams);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_18$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setPlaybackParams(PlaybackParams playbackParams) {
    }

    private final PlaybackParams $$robo$$android_media_MediaPlayer2Impl$getPlaybackParams() {
        return null;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setSyncParams(SyncParams params) {
        this.addTask((Task)new ShadowedObject(this, 28, false, params){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ SyncParams val$params;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_19$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, SyncParams syncParams) {
                this.this$0 = this$0;
                this.val$params = syncParams;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_19$process() {
                Preconditions.checkNotNull(this.val$params, "the SyncParams cannot be null");
                this.this$0._setSyncParams(this.val$params);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, SyncParams syncParams) {
                this.$$robo$$android_media_MediaPlayer2Impl_19$__constructor__(mediaPlayer2Impl, n, bl, syncParams);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_19$__constructor__(android.media.MediaPlayer2Impl int boolean android.media.SyncParams ), this, mediaPlayer2Impl, n, bl, syncParams);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_19$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setSyncParams(SyncParams syncParams) {
    }

    private final SyncParams $$robo$$android_media_MediaPlayer2Impl$getSyncParams() {
        return null;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$seekTo(long msec, int mode) {
        this.addTask((Task)new ShadowedObject(this, 14, true, mode, msec){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$mode;
            /* synthetic */ long val$msec;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_20$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, int n, long l) {
                this.this$0 = this$0;
                this.val$mode = n;
                this.val$msec = l;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_20$process() {
                if (this.val$mode < 0 || this.val$mode > 3) {
                    String msg = "Illegal seek mode: " + this.val$mode;
                    throw new IllegalArgumentException(msg);
                }
                long posMs = this.val$msec;
                if (posMs > Integer.MAX_VALUE) {
                    Log.w("MediaPlayer2Impl", "seekTo offset " + posMs + " is too large, cap to " + Integer.MAX_VALUE);
                    posMs = Integer.MAX_VALUE;
                } else if (posMs < Integer.MIN_VALUE) {
                    Log.w("MediaPlayer2Impl", "seekTo offset " + posMs + " is too small, cap to " + Integer.MIN_VALUE);
                    posMs = Integer.MIN_VALUE;
                }
                this.this$0._seekTo(posMs, this.val$mode);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, int n2, long l) {
                this.$$robo$$android_media_MediaPlayer2Impl_20$__constructor__(mediaPlayer2Impl, n, bl, n2, l);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_20$__constructor__(android.media.MediaPlayer2Impl int boolean int long ), this, mediaPlayer2Impl, n, bl, n2, l);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_20$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_seekTo(long l, int n) {
    }

    private final MediaTimestamp $$robo$$android_media_MediaPlayer2Impl$getTimestamp() {
        try {
            return new MediaTimestamp(this.getCurrentPosition() * 1000L, (long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System"), this.isPlaying() ? this.getPlaybackParams().getSpeed() : 0.0f);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private final Metadata $$robo$$android_media_MediaPlayer2Impl$getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream is : this.mOpenSubtitleSources) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        vector = this.mEventCbLock;
        synchronized (vector) {
            this.mEventCallbackRecords.clear();
        }
        vector = this.mDrmEventCbLock;
        synchronized (vector) {
            this.mDrmEventCallbackRecords.clear();
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.clear();
            this.mInbandTrackIndices.clear();
        }
        this.resetDrmState();
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_reset() {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$notifyAt(long mediaTimeUs) {
        this._notifyAt(mediaTimeUs);
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_notifyAt(long l) {
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$setParameter(int n, Parcel parcel) {
        return false;
    }

    private final Parcel $$robo$$android_media_MediaPlayer2Impl$getParameter(int n) {
        return null;
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$isLooping() {
        return false;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setAudioSessionId(int sessionId) {
        this.addTask((Task)new ShadowedObject(this, 17, false, sessionId){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$sessionId;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_21$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, int n) {
                this.this$0 = this$0;
                this.val$sessionId = n;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_21$process() {
                this.this$0._setAudioSessionId(this.val$sessionId);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, int n2) {
                this.$$robo$$android_media_MediaPlayer2Impl_21$__constructor__(mediaPlayer2Impl, n, bl, n2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_21$__constructor__(android.media.MediaPlayer2Impl int boolean int ), this, mediaPlayer2Impl, n, bl, n2);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_21$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setAudioSessionId(int n) {
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$getAudioSessionId() {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$attachAuxEffect(int effectId) {
        this.addTask((Task)new ShadowedObject(this, 1, false, effectId){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$effectId;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_22$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, int n) {
                this.this$0 = this$0;
                this.val$effectId = n;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_22$process() {
                this.this$0._attachAuxEffect(this.val$effectId);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, int n2) {
                this.$$robo$$android_media_MediaPlayer2Impl_22$__constructor__(mediaPlayer2Impl, n, bl, n2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_22$__constructor__(android.media.MediaPlayer2Impl int boolean int ), this, mediaPlayer2Impl, n, bl, n2);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_22$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_attachAuxEffect(int n) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setAuxEffectSendLevel(float level) {
        this.addTask((Task)new ShadowedObject(this, 18, false, level){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ float val$level;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_23$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, float f) {
                this.this$0 = this$0;
                this.val$level = f;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_23$process() {
                this.this$0._setAuxEffectSendLevel(this.val$level);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, float f) {
                this.$$robo$$android_media_MediaPlayer2Impl_23$__constructor__(mediaPlayer2Impl, n, bl, f);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_23$__constructor__(android.media.MediaPlayer2Impl int boolean float ), this, mediaPlayer2Impl, n, bl, f);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_23$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_setAuxEffectSendLevel(float f) {
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$native_invoke(Parcel parcel, Parcel parcel2) {
        return 0;
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return false;
    }

    private final int $$robo$$android_media_MediaPlayer2Impl$native_setMetadataFilter(Parcel parcel) {
        return 0;
    }

    private static final void $$robo$$android_media_MediaPlayer2Impl$native_init() {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$native_setup(Object object) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$native_finalize() {
    }

    private static final void $$robo$$android_media_MediaPlayer2Impl$native_stream_event_onTearDown(long l, long l2) {
    }

    private static final void $$robo$$android_media_MediaPlayer2Impl$native_stream_event_onStreamPresentationEnd(long l, long l2) {
    }

    private static final void $$robo$$android_media_MediaPlayer2Impl$native_stream_event_onStreamDataRequest(long l, long l2, long l3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<MediaPlayer2.TrackInfo> $$robo$$android_media_MediaPlayer2Impl$getTrackInfo() {
        TrackInfoImpl[] trackInfo = this.getInbandTrackInfoImpl();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            TrackInfoImpl[] allTrackInfo = new TrackInfoImpl[this.mIndexTrackPairs.size()];
            for (int i = 0; i < allTrackInfo.length; ++i) {
                Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                if (p.first != null) {
                    allTrackInfo[i] = trackInfo[(Integer)p.first];
                    continue;
                }
                SubtitleTrack track = (SubtitleTrack)p.second;
                allTrackInfo[i] = new TrackInfoImpl(track.getTrackType(), track.getFormat());
            }
            return Arrays.asList(allTrackInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrackInfoImpl[] $$robo$$android_media_MediaPlayer2Impl$getInbandTrackInfoImpl() throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            TrackInfoImpl[] trackInfo;
            request.writeInt(1);
            this.invoke(request, reply);
            TrackInfoImpl[] trackInfoImplArray = trackInfo = reply.createTypedArray(TrackInfoImpl.CREATOR);
            return trackInfoImplArray;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static final boolean $$robo$$android_media_MediaPlayer2Impl$availableMimeTypeForExternalSource(String mimeType) {
        return "application/x-subrip".equals(mimeType);
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
        this.mSubtitleController = controller;
        this.mSubtitleController.setAnchor(anchor);
    }

    private final synchronized void $$robo$$android_media_MediaPlayer2Impl$setSubtitleAnchor() {
        if (this.mSubtitleController == null && ActivityThread.currentApplication() != null) {
            HandlerThread thread = new HandlerThread("SetSubtitleAnchorThread");
            thread.start();
            Handler handler = new Handler(thread.getLooper());
            handler.post(new Runnable(this, thread){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ HandlerThread val$thread;
                /* synthetic */ MediaPlayer2Impl this$0;

                private void $$robo$$android_media_MediaPlayer2Impl_24$__constructor__(MediaPlayer2Impl this$0, HandlerThread handlerThread) {
                    this.this$0 = this$0;
                    this.val$thread = handlerThread;
                }

                private final void $$robo$$android_media_MediaPlayer2Impl_24$run() {
                    Application context = ActivityThread.currentApplication();
                    this.this$0.mSubtitleController = new SubtitleController(context, this.this$0.mTimeProvider, this.this$0);
                    this.this$0.mSubtitleController.setAnchor(new SubtitleController.Anchor(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ 24 this$1;

                        private void $$robo$$android_media_MediaPlayer2Impl_24_1$__constructor__(24 this$1) {
                            this.this$1 = this$1;
                        }

                        private final void $$robo$$android_media_MediaPlayer2Impl_24_1$setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
                        }

                        private final Looper $$robo$$android_media_MediaPlayer2Impl_24_1$getSubtitleLooper() {
                            return Looper.getMainLooper();
                        }

                        private void __constructor__(24 var1_1) {
                            this.$$robo$$android_media_MediaPlayer2Impl_24_1$__constructor__(var1_1);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_24_1$__constructor__(android.media.MediaPlayer2Impl$24 ), this, var1_1);
                        }

                        @Override
                        public void setSubtitleWidget(SubtitleTrack.RenderingWidget renderingWidget) {
                            InvokeDynamicSupport.bootstrap("setSubtitleWidget", $$robo$$android_media_MediaPlayer2Impl_24_1$setSubtitleWidget(android.media.SubtitleTrack$RenderingWidget ), this, renderingWidget);
                        }

                        @Override
                        public Looper getSubtitleLooper() {
                            return InvokeDynamicSupport.bootstrap("getSubtitleLooper", $$robo$$android_media_MediaPlayer2Impl_24_1$getSubtitleLooper(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    this.val$thread.getLooper().quitSafely();
                }

                private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, HandlerThread handlerThread) {
                    this.$$robo$$android_media_MediaPlayer2Impl_24$__constructor__(mediaPlayer2Impl, handlerThread);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_24$__constructor__(android.media.MediaPlayer2Impl android.os.HandlerThread ), this, mediaPlayer2Impl, handlerThread);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_24$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.w("MediaPlayer2Impl", "failed to join SetSubtitleAnchorThread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$onSubtitleTrackSelected(SubtitleTrack track) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.mSelectedSubtitleTrackIndex = -1;
        }
        this.setOnSubtitleDataListener(null);
        if (track == null) {
            return;
        }
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (Pair<Integer, SubtitleTrack> p : this.mIndexTrackPairs) {
                if (p.first == null || p.second != track) continue;
                this.mSelectedSubtitleTrackIndex = (Integer)p.first;
                break;
            }
        }
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.setOnSubtitleDataListener(this.mSubtitleDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$addSubtitleSource(InputStream is, MediaFormat format) throws IllegalStateException {
        InputStream fIs = is;
        MediaFormat fFormat = format;
        if (is != null) {
            Vector<InputStream> vector = this.mOpenSubtitleSources;
            synchronized (vector) {
                this.mOpenSubtitleSources.add(is);
            }
        } else {
            Log.w("MediaPlayer2Impl", "addSubtitleSource called with null InputStream");
        }
        this.getMediaTimeProvider();
        HandlerThread thread = new HandlerThread("SubtitleReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(this, fIs, fFormat, thread){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ InputStream val$fIs;
            /* synthetic */ MediaFormat val$fFormat;
            /* synthetic */ HandlerThread val$thread;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_26$__constructor__(MediaPlayer2Impl this$0, InputStream inputStream, MediaFormat mediaFormat, HandlerThread handlerThread) {
                this.this$0 = this$0;
                this.val$fIs = inputStream;
                this.val$fFormat = mediaFormat;
                this.val$thread = handlerThread;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_media_MediaPlayer2Impl_26$addTrack() {
                if (this.val$fIs == null || this.this$0.mSubtitleController == null) {
                    return 901;
                }
                SubtitleTrack track = this.this$0.mSubtitleController.addTrack(this.val$fFormat);
                if (track == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(this.val$fIs, "UTF-8");
                String contents = scanner.useDelimiter("\\A").next();
                Vector vector = this.this$0.mOpenSubtitleSources;
                synchronized (vector) {
                    this.this$0.mOpenSubtitleSources.remove(this.val$fIs);
                }
                scanner.close();
                vector = this.this$0.mIndexTrackPairs;
                synchronized (vector) {
                    this.this$0.mIndexTrackPairs.add(Pair.create(null, track));
                }
                TimeProvider.EventHandler h = this.this$0.mTimeProvider.mEventHandler;
                int what = 1;
                int arg1 = 4;
                Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, contents.getBytes());
                Message m = h.obtainMessage(what, arg1, 0, trackData);
                h.sendMessage(m);
                return 803;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_26$run() {
                int res = this.addTrack();
                if (this.this$0.mEventHandler != null) {
                    Message m = this.this$0.mEventHandler.obtainMessage(200, res, 0, null);
                    this.this$0.mEventHandler.sendMessage(m);
                }
                this.val$thread.getLooper().quitSafely();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, InputStream inputStream, MediaFormat mediaFormat, HandlerThread handlerThread) {
                this.$$robo$$android_media_MediaPlayer2Impl_26$__constructor__(mediaPlayer2Impl, inputStream, mediaFormat, handlerThread);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_26$__constructor__(android.media.MediaPlayer2Impl java.io.InputStream android.media.MediaFormat android.os.HandlerThread ), this, mediaPlayer2Impl, inputStream, mediaFormat, handlerThread);
            }

            private int addTrack() {
                return (int)InvokeDynamicSupport.bootstrap("addTrack", $$robo$$android_media_MediaPlayer2Impl_26$addTrack(), this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_26$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$scanInternalSubtitleTracks() {
        this.setSubtitleAnchor();
        this.populateInbandTracks();
        if (this.mSubtitleController != null) {
            this.mSubtitleController.selectDefaultTrack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$populateInbandTracks() {
        TrackInfoImpl[] tracks = this.getInbandTrackInfoImpl();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (int i = 0; i < tracks.length; ++i) {
                if (this.mInbandTrackIndices.get(i)) continue;
                this.mInbandTrackIndices.set(i);
                if (tracks[i].getTrackType() == 4) {
                    SubtitleTrack track = this.mSubtitleController.addTrack(tracks[i].getFormat());
                    this.mIndexTrackPairs.add(Pair.create(i, track));
                    continue;
                }
                this.mIndexTrackPairs.add(Pair.create(i, null));
            }
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(String path, String mimeType) throws IOException {
        if (!MediaPlayer2Impl.availableMimeTypeForExternalSource(mimeType)) {
            String msg = "Illegal mimeType for timed text source: " + mimeType;
            throw new IllegalArgumentException(msg);
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException(path);
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.addTimedTextSource(fd, mimeType);
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.addTimedTextSource(uri.getPath(), mimeType);
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.addTimedTextSource(fd.getFileDescriptor(), mimeType);
            return;
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(FileDescriptor fd, String mimeType) {
        this.addTimedTextSource(fd, 0L, 0x7FFFFFFFFFFFFFFL, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(FileDescriptor fd, long offset, long length, String mime) {
        FileDescriptor dupedFd;
        if (!MediaPlayer2Impl.availableMimeTypeForExternalSource(mime)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + mime);
        }
        try {
            dupedFd = Os.dup(fd);
        }
        catch (ErrnoException ex) {
            Log.e("MediaPlayer2Impl", ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        MediaFormat fFormat = new MediaFormat();
        fFormat.setString("mime", mime);
        fFormat.setInteger("is-timed-text", 1);
        if (this.mSubtitleController == null) {
            this.setSubtitleAnchor();
        }
        if (!this.mSubtitleController.hasRendererFor(fFormat)) {
            Application context = ActivityThread.currentApplication();
            this.mSubtitleController.registerRenderer(new SRTRenderer(context, this.mEventHandler));
        }
        SubtitleTrack track = this.mSubtitleController.addTrack(fFormat);
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.add(Pair.create(null, track));
        }
        this.getMediaTimeProvider();
        long offset2 = offset;
        long length2 = length;
        HandlerThread thread = new HandlerThread("TimedTextReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(this, dupedFd, offset2, length2, track, thread){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ FileDescriptor val$dupedFd;
            /* synthetic */ long val$offset2;
            /* synthetic */ long val$length2;
            /* synthetic */ SubtitleTrack val$track;
            /* synthetic */ HandlerThread val$thread;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_27$__constructor__(MediaPlayer2Impl this$0, FileDescriptor fileDescriptor, long l, long l2, SubtitleTrack subtitleTrack, HandlerThread handlerThread) {
                this.this$0 = this$0;
                this.val$dupedFd = fileDescriptor;
                this.val$offset2 = l;
                this.val$length2 = l2;
                this.val$track = subtitleTrack;
                this.val$thread = handlerThread;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_media_MediaPlayer2Impl_27$addTrack() {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int bytesToRead;
                    int bytes;
                    Os.lseek(this.val$dupedFd, this.val$offset2, OsConstants.SEEK_SET);
                    byte[] buffer = new byte[4096];
                    for (long total = 0L; total < this.val$length2 && (bytes = IoBridge.read(this.val$dupedFd, buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, this.val$length2 - total))) >= 0; total += (long)bytes) {
                        bos.write(buffer, 0, bytes);
                    }
                    TimeProvider.EventHandler h = this.this$0.mTimeProvider.mEventHandler;
                    int what = 1;
                    int arg1 = 4;
                    Pair<SubtitleTrack, byte[]> trackData = Pair.create(this.val$track, bos.toByteArray());
                    Message m = h.obtainMessage(what, arg1, 0, trackData);
                    h.sendMessage(m);
                    int n = 803;
                    return n;
                }
                catch (Exception e) {
                    Log.e("MediaPlayer2Impl", e.getMessage(), e);
                    int n = 900;
                    return n;
                }
                finally {
                    try {
                        Os.close(this.val$dupedFd);
                    }
                    catch (ErrnoException e) {
                        Log.e("MediaPlayer2Impl", e.getMessage(), e);
                    }
                }
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_27$run() {
                int res = this.addTrack();
                if (this.this$0.mEventHandler != null) {
                    Message m = this.this$0.mEventHandler.obtainMessage(200, res, 0, null);
                    this.this$0.mEventHandler.sendMessage(m);
                }
                this.val$thread.getLooper().quitSafely();
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, FileDescriptor fileDescriptor, long l, long l2, SubtitleTrack subtitleTrack, HandlerThread handlerThread) {
                this.$$robo$$android_media_MediaPlayer2Impl_27$__constructor__(mediaPlayer2Impl, fileDescriptor, l, l2, subtitleTrack, handlerThread);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_27$__constructor__(android.media.MediaPlayer2Impl java.io.FileDescriptor long long android.media.SubtitleTrack android.os.HandlerThread ), this, mediaPlayer2Impl, fileDescriptor, l, l2, subtitleTrack, handlerThread);
            }

            private int addTrack() {
                return (int)InvokeDynamicSupport.bootstrap("addTrack", $$robo$$android_media_MediaPlayer2Impl_27$addTrack(), this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_27$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int $$robo$$android_media_MediaPlayer2Impl$getSelectedTrack(int trackType) {
        SubtitleTrack subtitleTrack;
        if (this.mSubtitleController != null && (trackType == 4 || trackType == 3) && (subtitleTrack = this.mSubtitleController.getSelectedTrack()) != null) {
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.second != subtitleTrack || subtitleTrack.getTrackType() != trackType) continue;
                    return i;
                }
            }
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInt(7);
            request.writeInt(trackType);
            this.invoke(request, reply);
            int inbandTrackIndex = reply.readInt();
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.first == null || (Integer)p.first != inbandTrackIndex) continue;
                    int n = i;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$selectTrack(int index) {
        this.addTask((Task)new ShadowedObject(this, 15, false, index){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$index;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_28$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, int n) {
                this.this$0 = this$0;
                this.val$index = n;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_28$process() {
                this.this$0.selectOrDeselectTrack(this.val$index, true);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, int n2) {
                this.$$robo$$android_media_MediaPlayer2Impl_28$__constructor__(mediaPlayer2Impl, n, bl, n2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_28$__constructor__(android.media.MediaPlayer2Impl int boolean int ), this, mediaPlayer2Impl, n, bl, n2);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_28$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$deselectTrack(int index) {
        this.addTask((Task)new ShadowedObject(this, 2, false, index){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$index;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_29$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, int n) {
                this.this$0 = this$0;
                this.val$index = n;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_29$process() {
                this.this$0.selectOrDeselectTrack(this.val$index, false);
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, int n2) {
                this.$$robo$$android_media_MediaPlayer2Impl_29$__constructor__(mediaPlayer2Impl, n, bl, n2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_29$__constructor__(android.media.MediaPlayer2Impl int boolean int ), this, mediaPlayer2Impl, n, bl, n2);
            }

            @Override
            void process() {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_29$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$selectOrDeselectTrack(int index, boolean select) throws IllegalStateException {
        this.populateInbandTracks();
        Pair<Integer, SubtitleTrack> p = null;
        try {
            p = this.mIndexTrackPairs.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        SubtitleTrack track = (SubtitleTrack)p.second;
        if (track == null) {
            this.selectOrDeselectInbandTrack((Integer)p.first, select);
            return;
        }
        if (this.mSubtitleController == null) {
            return;
        }
        if (!select) {
            if (this.mSubtitleController.getSelectedTrack() == track) {
                this.mSubtitleController.selectTrack(null);
            } else {
                Log.w("MediaPlayer2Impl", "trying to deselect track that was not selected");
            }
            return;
        }
        if (track.getTrackType() == 3) {
            int ttIndex = this.getSelectedTrack(3);
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                if (ttIndex >= 0 && ttIndex < this.mIndexTrackPairs.size()) {
                    Pair<Integer, SubtitleTrack> p2 = this.mIndexTrackPairs.get(ttIndex);
                    if (p2.first != null && p2.second == null) {
                        this.selectOrDeselectInbandTrack((Integer)p2.first, false);
                    }
                }
            }
        }
        this.mSubtitleController.selectTrack(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$selectOrDeselectInbandTrack(int index, boolean select) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInt(select ? 4 : 5);
            request.writeInt(index);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$finalize() throws Throwable {
        if (this.mGuard != null) {
            this.mGuard.warnIfOpen();
        }
        this.close();
        this.native_finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        Object object = this.mEventCbLock;
        synchronized (object) {
            this.mEventCallbackRecords.clear();
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread = null;
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.mOnSubtitleDataListener = null;
        this.mOnDrmConfigHelper = null;
        object = this.mDrmEventCbLock;
        synchronized (object) {
            this.mDrmEventCallbackRecords.clear();
        }
        this.resetDrmState();
        this._release();
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_release() {
    }

    private final MediaTimeProvider $$robo$$android_media_MediaPlayer2Impl$getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new TimeProvider(this);
        }
        return this.mTimeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_MediaPlayer2Impl$postEventFromNative(Object mediaplayer2_ref, long srcId, int what, int arg1, int arg2, Object obj) {
        MediaPlayer2Impl mp = (MediaPlayer2Impl)((WeakReference)mediaplayer2_ref).get();
        if (mp == null) {
            return;
        }
        switch (what) {
            case 200: {
                if (arg1 != 2) break;
                new Thread(new Runnable(mp){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ MediaPlayer2Impl val$mp;

                    private void $$robo$$android_media_MediaPlayer2Impl_30$__constructor__(MediaPlayer2Impl mediaPlayer2Impl) {
                        this.val$mp = mediaPlayer2Impl;
                    }

                    private final void $$robo$$android_media_MediaPlayer2Impl_30$run() {
                        this.val$mp.play();
                    }

                    private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl) {
                        this.$$robo$$android_media_MediaPlayer2Impl_30$__constructor__(mediaPlayer2Impl);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_30$__constructor__(android.media.MediaPlayer2Impl ), this, mediaPlayer2Impl);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_30$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                }).start();
                Thread.yield();
                break;
            }
            case 210: {
                Object parcel;
                Log.v("MediaPlayer2Impl", "postEventFromNative MEDIA_DRM_INFO");
                if (obj instanceof Parcel) {
                    parcel = (Parcel)obj;
                    DrmInfoImpl drmInfo = new DrmInfoImpl((Parcel)parcel, null);
                    Object object = mp.mDrmLock;
                    synchronized (object) {
                        mp.mDrmInfoImpl = drmInfo;
                        break;
                    }
                }
                Log.w("MediaPlayer2Impl", "MEDIA_DRM_INFO msg.obj of unexpected type " + obj);
                break;
            }
            case 1: {
                Object parcel = mp.mDrmLock;
                synchronized (parcel) {
                    mp.mDrmInfoResolved = true;
                    break;
                }
            }
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.post(new Runnable(mp, m, srcId){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MediaPlayer2Impl val$mp;
                /* synthetic */ Message val$m;
                /* synthetic */ long val$srcId;

                private void $$robo$$android_media_MediaPlayer2Impl_31$__constructor__(MediaPlayer2Impl mediaPlayer2Impl, Message message, long l) {
                    this.val$mp = mediaPlayer2Impl;
                    this.val$m = message;
                    this.val$srcId = l;
                }

                private final void $$robo$$android_media_MediaPlayer2Impl_31$run() {
                    this.val$mp.mEventHandler.handleMessage(this.val$m, this.val$srcId);
                }

                private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, Message message, long l) {
                    this.$$robo$$android_media_MediaPlayer2Impl_31$__constructor__(mediaPlayer2Impl, message, l);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_31$__constructor__(android.media.MediaPlayer2Impl android.os.Message long ), this, mediaPlayer2Impl, message, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_31$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$setMediaPlayer2EventCallback(Executor executor, MediaPlayer2.MediaPlayer2EventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null MediaPlayer2EventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the MediaPlayer2EventCallback");
        }
        Object object = this.mEventCbLock;
        synchronized (object) {
            this.mEventCallbackRecords.add(new Pair<Executor, MediaPlayer2.MediaPlayer2EventCallback>(executor, eventCallback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$clearMediaPlayer2EventCallback() {
        Object object = this.mEventCbLock;
        synchronized (object) {
            this.mEventCallbackRecords.clear();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$setOnSubtitleDataListener(MediaPlayer2.OnSubtitleDataListener listener) {
        this.mOnSubtitleDataListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$setOnDrmConfigHelper(MediaPlayer2.OnDrmConfigHelper listener) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmConfigHelper = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$setDrmEventCallback(Executor executor, MediaPlayer2.DrmEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null MediaPlayer2EventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the MediaPlayer2EventCallback");
        }
        Object object = this.mDrmEventCbLock;
        synchronized (object) {
            this.mDrmEventCallbackRecords.add(new Pair<Executor, MediaPlayer2.DrmEventCallback>(executor, eventCallback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$clearDrmEventCallback() {
        Object object = this.mDrmEventCbLock;
        synchronized (object) {
            this.mDrmEventCallbackRecords.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MediaPlayer2.DrmInfo $$robo$$android_media_MediaPlayer2Impl$getDrmInfo() {
        DrmInfoImpl drmInfo = null;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mDrmInfoResolved && this.mDrmInfoImpl == null) {
                String msg = "The Player has not been prepared yet";
                Log.v("MediaPlayer2Impl", "The Player has not been prepared yet");
                throw new IllegalStateException("The Player has not been prepared yet");
            }
            if (this.mDrmInfoImpl != null) {
                drmInfo = this.mDrmInfoImpl.makeCopy();
            }
        }
        return drmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$prepareDrm(UUID uuid) throws UnsupportedSchemeException, ResourceBusyException, MediaPlayer2.ProvisioningNetworkErrorException, MediaPlayer2.ProvisioningServerErrorException {
        Log.v("MediaPlayer2Impl", "prepareDrm: uuid: " + uuid + " mOnDrmConfigHelper: " + this.mOnDrmConfigHelper);
        boolean allDoneWithoutProvisioning = false;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (this.mDrmInfoImpl == null) {
                String msg = "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.";
                Log.e("MediaPlayer2Impl", "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
            }
            if (this.mActiveDrmScheme) {
                String msg = "prepareDrm(): Wrong usage: There is already an active DRM scheme with " + this.mDrmUUID;
                Log.e("MediaPlayer2Impl", msg);
                throw new IllegalStateException(msg);
            }
            if (this.mPrepareDrmInProgress) {
                String msg = "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.";
                Log.e("MediaPlayer2Impl", "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
            }
            if (this.mDrmProvisioningInProgress) {
                String msg = "prepareDrm(): Unexpectd: Provisioning is already in progress.";
                Log.e("MediaPlayer2Impl", "prepareDrm(): Unexpectd: Provisioning is already in progress.");
                throw new IllegalStateException("prepareDrm(): Unexpectd: Provisioning is already in progress.");
            }
            this.cleanDrmObj();
            this.mPrepareDrmInProgress = true;
            try {
                this.prepareDrm_createDrmStep(uuid);
            }
            catch (Exception e) {
                Log.w("MediaPlayer2Impl", "prepareDrm(): Exception ", e);
                this.mPrepareDrmInProgress = false;
                throw e;
            }
            this.mDrmConfigAllowed = true;
        }
        if (this.mOnDrmConfigHelper != null) {
            this.mOnDrmConfigHelper.onDrmConfig(this, this.mCurrentDSD);
        }
        object = this.mDrmLock;
        synchronized (object) {
            this.mDrmConfigAllowed = false;
            boolean earlyExit = false;
            try {
                this.prepareDrm_openSessionStep(uuid);
                this.mDrmUUID = uuid;
                this.mActiveDrmScheme = true;
                allDoneWithoutProvisioning = true;
            }
            catch (IllegalStateException e) {
                String msg = "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().";
                Log.e("MediaPlayer2Impl", "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
                earlyExit = true;
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
            }
            catch (NotProvisionedException e) {
                Log.w("MediaPlayer2Impl", "prepareDrm: NotProvisionedException");
                int result = this.HandleProvisioninig(uuid);
                if (result != 0) {
                    earlyExit = true;
                    switch (result) {
                        case 1: {
                            String msg = "prepareDrm: Provisioning was required but failed due to a network error.";
                            Log.e("MediaPlayer2Impl", msg);
                            throw new ProvisioningNetworkErrorExceptionImpl(msg);
                        }
                        case 2: {
                            String msg = "prepareDrm: Provisioning was required but the request was denied by the server.";
                            Log.e("MediaPlayer2Impl", msg);
                            throw new ProvisioningServerErrorExceptionImpl(msg);
                        }
                    }
                    String msg = "prepareDrm: Post-provisioning preparation failed.";
                    Log.e("MediaPlayer2Impl", msg);
                    throw new IllegalStateException(msg);
                }
            }
            catch (Exception e) {
                Log.e("MediaPlayer2Impl", "prepareDrm: Exception " + e);
                earlyExit = true;
                throw e;
            }
            finally {
                if (!this.mDrmProvisioningInProgress) {
                    this.mPrepareDrmInProgress = false;
                }
                if (earlyExit) {
                    this.cleanDrmObj();
                }
            }
        }
        if (allDoneWithoutProvisioning) {
            object = this.mDrmEventCbLock;
            synchronized (object) {
                for (Pair<Executor, MediaPlayer2.DrmEventCallback> cb : this.mDrmEventCallbackRecords) {
                    ((Executor)cb.first).execute(() -> ((MediaPlayer2.DrmEventCallback)cb.second).onDrmPrepared(this, this.mCurrentDSD, 0));
                }
            }
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_releaseDrm() {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$releaseDrm() throws MediaPlayer2.NoDrmSchemeException {
        this.addTask((Task)new ShadowedObject(this, 12, false){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_32$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_32$process() throws MediaPlayer2.NoDrmSchemeException {
                Object object = this.this$0.mDrmLock;
                synchronized (object) {
                    Log.v("MediaPlayer2Impl", "releaseDrm:");
                    if (!this.this$0.mActiveDrmScheme) {
                        Log.e("MediaPlayer2Impl", "releaseDrm(): No active DRM scheme to release.");
                        throw new NoDrmSchemeExceptionImpl("releaseDrm: No active DRM scheme to release.");
                    }
                    try {
                        this.this$0._releaseDrm();
                        this.this$0.cleanDrmObj();
                        this.this$0.mActiveDrmScheme = false;
                    }
                    catch (IllegalStateException e) {
                        Log.w("MediaPlayer2Impl", "releaseDrm: Exception ", e);
                        throw new IllegalStateException("releaseDrm: The player is not in a valid state.");
                    }
                    catch (Exception e) {
                        Log.e("MediaPlayer2Impl", "releaseDrm: Exception ", e);
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
                this.$$robo$$android_media_MediaPlayer2Impl_32$__constructor__(mediaPlayer2Impl, n, bl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_32$__constructor__(android.media.MediaPlayer2Impl int boolean ), this, mediaPlayer2Impl, n, bl);
            }

            @Override
            void process() throws MediaPlayer2.NoDrmSchemeException {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_32$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final MediaDrm.KeyRequest $$robo$$android_media_MediaPlayer2Impl$getDrmKeyRequest(byte[] keySetId, byte[] initData, String mimeType, int keyType, Map<String, String> optionalParameters) throws MediaPlayer2.NoDrmSchemeException {
        Log.v("MediaPlayer2Impl", "getDrmKeyRequest:  keySetId: " + keySetId + " initData:" + initData + " mimeType: " + mimeType + " keyType: " + keyType + " optionalParameters: " + optionalParameters);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e("MediaPlayer2Impl", "getDrmKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("getDrmKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keyType != 3 ? this.mDrmSessionId : keySetId;
                HashMap<String, String> hmapOptionalParameters = optionalParameters != null ? new HashMap<String, String>(optionalParameters) : null;
                MediaDrm.KeyRequest request = this.mDrmObj.getKeyRequest(scope, initData, mimeType, keyType, hmapOptionalParameters);
                Log.v("MediaPlayer2Impl", "getDrmKeyRequest:   --> request: " + request);
                return request;
            }
            catch (NotProvisionedException e) {
                Log.w("MediaPlayer2Impl", "getDrmKeyRequest NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("getDrmKeyRequest: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w("MediaPlayer2Impl", "getDrmKeyRequest Exception " + e);
                throw e;
            }
        }
    }

    private final byte[] $$robo$$android_media_MediaPlayer2Impl$provideDrmKeyResponse(byte[] keySetId, byte[] response) throws MediaPlayer2.NoDrmSchemeException, DeniedByServerException {
        Log.v("MediaPlayer2Impl", "provideDrmKeyResponse: keySetId: " + keySetId + " response: " + response);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e("MediaPlayer2Impl", "getDrmKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("getDrmKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keySetId == null ? this.mDrmSessionId : keySetId;
                byte[] keySetResult = this.mDrmObj.provideKeyResponse(scope, response);
                Log.v("MediaPlayer2Impl", "provideDrmKeyResponse: keySetId: " + keySetId + " response: " + response + " --> " + keySetResult);
                return keySetResult;
            }
            catch (NotProvisionedException e) {
                Log.w("MediaPlayer2Impl", "provideDrmKeyResponse NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("provideDrmKeyResponse: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w("MediaPlayer2Impl", "provideDrmKeyResponse Exception " + e);
                throw e;
            }
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$restoreDrmKeys(byte[] keySetId) throws MediaPlayer2.NoDrmSchemeException {
        this.addTask((Task)new ShadowedObject(this, 13, false, keySetId){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ byte[] val$keySetId;
            /* synthetic */ MediaPlayer2Impl this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_33$__constructor__(MediaPlayer2Impl this$0, int mediaCallType, boolean needToWaitForEventToComplete, byte[] byArray) {
                this.this$0 = this$0;
                this.val$keySetId = byArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer2Impl_33$process() throws MediaPlayer2.NoDrmSchemeException {
                Log.v("MediaPlayer2Impl", "restoreDrmKeys: keySetId: " + this.val$keySetId);
                Object object = this.this$0.mDrmLock;
                synchronized (object) {
                    if (!this.this$0.mActiveDrmScheme) {
                        Log.w("MediaPlayer2Impl", "restoreDrmKeys NoDrmSchemeException");
                        throw new NoDrmSchemeExceptionImpl("restoreDrmKeys: Has to set a DRM scheme first.");
                    }
                    try {
                        this.this$0.mDrmObj.restoreKeys(this.this$0.mDrmSessionId, this.val$keySetId);
                    }
                    catch (Exception e) {
                        Log.w("MediaPlayer2Impl", "restoreKeys Exception " + e);
                        throw e;
                    }
                }
            }

            private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl, byte[] byArray) {
                this.$$robo$$android_media_MediaPlayer2Impl_33$__constructor__(mediaPlayer2Impl, n, bl, byArray);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_33$__constructor__(android.media.MediaPlayer2Impl int boolean byte[] ), this, mediaPlayer2Impl, n, bl, byArray);
            }

            @Override
            void process() throws MediaPlayer2.NoDrmSchemeException {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_media_MediaPlayer2Impl_33$process(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_media_MediaPlayer2Impl$getDrmPropertyString(String propertyName) throws MediaPlayer2.NoDrmSchemeException {
        String value;
        Log.v("MediaPlayer2Impl", "getDrmPropertyString: propertyName: " + propertyName);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w("MediaPlayer2Impl", "getDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("getDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                value = this.mDrmObj.getPropertyString(propertyName);
            }
            catch (Exception e) {
                Log.w("MediaPlayer2Impl", "getDrmPropertyString Exception " + e);
                throw e;
            }
        }
        Log.v("MediaPlayer2Impl", "getDrmPropertyString: propertyName: " + propertyName + " --> value: " + value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$setDrmPropertyString(String propertyName, String value) throws MediaPlayer2.NoDrmSchemeException {
        Log.v("MediaPlayer2Impl", "setDrmPropertyString: propertyName: " + propertyName + " value: " + value);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w("MediaPlayer2Impl", "setDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("setDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                this.mDrmObj.setPropertyString(propertyName, value);
            }
            catch (Exception e) {
                Log.w("MediaPlayer2Impl", "setDrmPropertyString Exception " + e);
                throw e;
            }
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$_prepareDrm(byte[] byArray, byte[] byArray2) {
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$prepareDrm_createDrmStep(UUID uuid) throws UnsupportedSchemeException {
        Log.v("MediaPlayer2Impl", "prepareDrm_createDrmStep: UUID: " + uuid);
        try {
            this.mDrmObj = new MediaDrm(uuid);
            Log.v("MediaPlayer2Impl", "prepareDrm_createDrmStep: Created mDrmObj=" + this.mDrmObj);
        }
        catch (Exception e) {
            Log.e("MediaPlayer2Impl", "prepareDrm_createDrmStep: MediaDrm failed with " + e);
            throw e;
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$prepareDrm_openSessionStep(UUID uuid) throws NotProvisionedException, ResourceBusyException {
        Log.v("MediaPlayer2Impl", "prepareDrm_openSessionStep: uuid: " + uuid);
        try {
            this.mDrmSessionId = this.mDrmObj.openSession();
            Log.v("MediaPlayer2Impl", "prepareDrm_openSessionStep: mDrmSessionId=" + this.mDrmSessionId);
            this._prepareDrm(MediaPlayer2Impl.getByteArrayFromUUID(uuid), this.mDrmSessionId);
            Log.v("MediaPlayer2Impl", "prepareDrm_openSessionStep: _prepareDrm/Crypto succeeded");
        }
        catch (Exception e) {
            Log.e("MediaPlayer2Impl", "prepareDrm_openSessionStep: open/crypto failed with " + e);
            throw e;
        }
    }

    private static final boolean $$robo$$android_media_MediaPlayer2Impl$setAudioOutputDeviceById(AudioTrack track, int deviceId) {
        if (track == null) {
            return false;
        }
        if (deviceId == 0) {
            track.setPreferredDevice(null);
            return true;
        }
        AudioDeviceInfo[] outputDevices = AudioManager.getDevicesStatic(2);
        boolean success = false;
        for (AudioDeviceInfo device : outputDevices) {
            if (device.getId() != deviceId) continue;
            track.setPreferredDevice(device);
            success = true;
            break;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaPlayer2Impl$HandleProvisioninig(UUID uuid) {
        int result;
        if (this.mDrmProvisioningInProgress) {
            Log.e("MediaPlayer2Impl", "HandleProvisioninig: Unexpected mDrmProvisioningInProgress");
            return 3;
        }
        MediaDrm.ProvisionRequest provReq = this.mDrmObj.getProvisionRequest();
        if (provReq == null) {
            Log.e("MediaPlayer2Impl", "HandleProvisioninig: getProvisionRequest returned null.");
            return 3;
        }
        Log.v("MediaPlayer2Impl", "HandleProvisioninig provReq  data: " + provReq.getData() + " url: " + provReq.getDefaultUrl());
        this.mDrmProvisioningInProgress = true;
        this.mDrmProvisioningThread = new ProvisioningThread(this, null).initialize(provReq, uuid, this);
        this.mDrmProvisioningThread.start();
        boolean hasCallback = false;
        Object object = this.mDrmEventCbLock;
        synchronized (object) {
            hasCallback = !this.mDrmEventCallbackRecords.isEmpty();
        }
        if (hasCallback) {
            result = 0;
        } else {
            try {
                this.mDrmProvisioningThread.join();
            }
            catch (Exception e) {
                Log.w("MediaPlayer2Impl", "HandleProvisioninig: Thread.join Exception " + e);
            }
            result = this.mDrmProvisioningThread.status();
            this.mDrmProvisioningThread = null;
        }
        return result;
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$resumePrepareDrm(UUID uuid) {
        Log.v("MediaPlayer2Impl", "resumePrepareDrm: uuid: " + uuid);
        boolean success = false;
        try {
            this.prepareDrm_openSessionStep(uuid);
            this.mDrmUUID = uuid;
            this.mActiveDrmScheme = true;
            success = true;
        }
        catch (Exception e) {
            Log.w("MediaPlayer2Impl", "HandleProvisioninig: Thread run _prepareDrm resume failed with " + e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer2Impl$resetDrmState() {
        Object object = this.mDrmLock;
        synchronized (object) {
            Log.v("MediaPlayer2Impl", "resetDrmState:  mDrmInfoImpl=" + this.mDrmInfoImpl + " mDrmProvisioningThread=" + this.mDrmProvisioningThread + " mPrepareDrmInProgress=" + this.mPrepareDrmInProgress + " mActiveDrmScheme=" + this.mActiveDrmScheme);
            this.mDrmInfoResolved = false;
            this.mDrmInfoImpl = null;
            if (this.mDrmProvisioningThread != null) {
                try {
                    this.mDrmProvisioningThread.join();
                }
                catch (InterruptedException e) {
                    Log.w("MediaPlayer2Impl", "resetDrmState: ProvThread.join Exception " + e);
                }
                this.mDrmProvisioningThread = null;
            }
            this.mPrepareDrmInProgress = false;
            this.mActiveDrmScheme = false;
            this.cleanDrmObj();
        }
    }

    private final void $$robo$$android_media_MediaPlayer2Impl$cleanDrmObj() {
        Log.v("MediaPlayer2Impl", "cleanDrmObj: mDrmObj=" + this.mDrmObj + " mDrmSessionId=" + this.mDrmSessionId);
        if (this.mDrmSessionId != null) {
            this.mDrmObj.closeSession(this.mDrmSessionId);
            this.mDrmSessionId = null;
        }
        if (this.mDrmObj != null) {
            this.mDrmObj.release();
            this.mDrmObj = null;
        }
    }

    private static final byte[] $$robo$$android_media_MediaPlayer2Impl$getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private final boolean $$robo$$android_media_MediaPlayer2Impl$isVideoScalingModeSupported(int mode) {
        return mode == 1 || mode == 2;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media2_jni");
        MediaPlayer2Impl.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaPlayer2Impl$__constructor__();
    }

    public MediaPlayer2Impl() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl$__constructor__(), this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaPlayer2Impl$close(), this);
    }

    @Override
    public void play() {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_MediaPlayer2Impl$play(), this);
    }

    private void _start() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("_start", $$robo$$android_media_MediaPlayer2Impl$_start(), this);
    }

    @Override
    public void prepare() {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_media_MediaPlayer2Impl$prepare(), this);
    }

    public void _prepare() {
        InvokeDynamicSupport.bootstrap("_prepare", $$robo$$android_media_MediaPlayer2Impl$_prepare(), this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_MediaPlayer2Impl$pause(), this);
    }

    private void _pause() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("_pause", $$robo$$android_media_MediaPlayer2Impl$_pause(), this);
    }

    @Override
    public void skipToNext() {
        InvokeDynamicSupport.bootstrap("skipToNext", $$robo$$android_media_MediaPlayer2Impl$skipToNext(), this);
    }

    @Override
    public long getCurrentPosition() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentPosition", $$robo$$android_media_MediaPlayer2Impl$getCurrentPosition(), this);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_media_MediaPlayer2Impl$getDuration(), this);
    }

    @Override
    public long getBufferedPosition() {
        return (long)InvokeDynamicSupport.bootstrap("getBufferedPosition", $$robo$$android_media_MediaPlayer2Impl$getBufferedPosition(), this);
    }

    @Override
    public int getPlayerState() {
        return (int)InvokeDynamicSupport.bootstrap("getPlayerState", $$robo$$android_media_MediaPlayer2Impl$getPlayerState(), this);
    }

    @Override
    public int getBufferingState() {
        return (int)InvokeDynamicSupport.bootstrap("getBufferingState", $$robo$$android_media_MediaPlayer2Impl$getBufferingState(), this);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_MediaPlayer2Impl$setAudioAttributes(android.media.AudioAttributes ), this, audioAttributes);
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_media_MediaPlayer2Impl$getAudioAttributes(), this);
    }

    @Override
    public void setDataSource(DataSourceDesc dataSourceDesc) {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer2Impl$setDataSource(android.media.DataSourceDesc ), this, dataSourceDesc);
    }

    @Override
    public void setNextDataSource(DataSourceDesc dataSourceDesc) {
        InvokeDynamicSupport.bootstrap("setNextDataSource", $$robo$$android_media_MediaPlayer2Impl$setNextDataSource(android.media.DataSourceDesc ), this, dataSourceDesc);
    }

    @Override
    public void setNextDataSources(List<DataSourceDesc> list) {
        InvokeDynamicSupport.bootstrap("setNextDataSources", $$robo$$android_media_MediaPlayer2Impl$setNextDataSources(java.util.List<android.media.DataSourceDesc> ), this, list);
    }

    @Override
    public DataSourceDesc getCurrentDataSource() {
        return InvokeDynamicSupport.bootstrap("getCurrentDataSource", $$robo$$android_media_MediaPlayer2Impl$getCurrentDataSource(), this);
    }

    @Override
    public void loopCurrent(boolean bl) {
        InvokeDynamicSupport.bootstrap("loopCurrent", $$robo$$android_media_MediaPlayer2Impl$loopCurrent(boolean ), this, bl);
    }

    private void setLooping(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLooping", $$robo$$android_media_MediaPlayer2Impl$setLooping(boolean ), this, bl);
    }

    @Override
    public void setPlaybackSpeed(float f) {
        InvokeDynamicSupport.bootstrap("setPlaybackSpeed", $$robo$$android_media_MediaPlayer2Impl$setPlaybackSpeed(float ), this, f);
    }

    @Override
    public float getPlaybackSpeed() {
        return (float)InvokeDynamicSupport.bootstrap("getPlaybackSpeed", $$robo$$android_media_MediaPlayer2Impl$getPlaybackSpeed(), this);
    }

    @Override
    public boolean isReversePlaybackSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReversePlaybackSupported", $$robo$$android_media_MediaPlayer2Impl$isReversePlaybackSupported(), this);
    }

    @Override
    public void setPlayerVolume(float f) {
        InvokeDynamicSupport.bootstrap("setPlayerVolume", $$robo$$android_media_MediaPlayer2Impl$setPlayerVolume(float ), this, f);
    }

    private void _setVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("_setVolume", $$robo$$android_media_MediaPlayer2Impl$_setVolume(float float ), this, f, f2);
    }

    @Override
    public float getPlayerVolume() {
        return (float)InvokeDynamicSupport.bootstrap("getPlayerVolume", $$robo$$android_media_MediaPlayer2Impl$getPlayerVolume(), this);
    }

    @Override
    public float getMaxPlayerVolume() {
        return (float)InvokeDynamicSupport.bootstrap("getMaxPlayerVolume", $$robo$$android_media_MediaPlayer2Impl$getMaxPlayerVolume(), this);
    }

    @Override
    public void registerPlayerEventCallback(Executor executor, MediaPlayerBase.PlayerEventCallback playerEventCallback) {
        InvokeDynamicSupport.bootstrap("registerPlayerEventCallback", $$robo$$android_media_MediaPlayer2Impl$registerPlayerEventCallback(java.util.concurrent.Executor android.media.MediaPlayerBase$PlayerEventCallback ), this, executor, playerEventCallback);
    }

    @Override
    public void unregisterPlayerEventCallback(MediaPlayerBase.PlayerEventCallback playerEventCallback) {
        InvokeDynamicSupport.bootstrap("unregisterPlayerEventCallback", $$robo$$android_media_MediaPlayer2Impl$unregisterPlayerEventCallback(android.media.MediaPlayerBase$PlayerEventCallback ), this, playerEventCallback);
    }

    private void _setVideoSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("_setVideoSurface", $$robo$$android_media_MediaPlayer2Impl$_setVideoSurface(android.view.Surface ), this, surface);
    }

    @Override
    public Parcel newRequest() {
        return InvokeDynamicSupport.bootstrap("newRequest", $$robo$$android_media_MediaPlayer2Impl$newRequest(), this);
    }

    @Override
    public void invoke(Parcel parcel, Parcel parcel2) {
        InvokeDynamicSupport.bootstrap("invoke", $$robo$$android_media_MediaPlayer2Impl$invoke(android.os.Parcel android.os.Parcel ), this, parcel, parcel2);
    }

    @Override
    public void notifyWhenCommandLabelReached(Object object) {
        InvokeDynamicSupport.bootstrap("notifyWhenCommandLabelReached", $$robo$$android_media_MediaPlayer2Impl$notifyWhenCommandLabelReached(java.lang.Object ), this, object);
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        InvokeDynamicSupport.bootstrap("setDisplay", $$robo$$android_media_MediaPlayer2Impl$setDisplay(android.view.SurfaceHolder ), this, surfaceHolder);
    }

    @Override
    public void setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_MediaPlayer2Impl$setSurface(android.view.Surface ), this, surface);
    }

    @Override
    public void setVideoScalingMode(int n) {
        InvokeDynamicSupport.bootstrap("setVideoScalingMode", $$robo$$android_media_MediaPlayer2Impl$setVideoScalingMode(int ), this, n);
    }

    @Override
    public void clearPendingCommands() {
        InvokeDynamicSupport.bootstrap("clearPendingCommands", $$robo$$android_media_MediaPlayer2Impl$clearPendingCommands(), this);
    }

    private void addTask(Task task) {
        InvokeDynamicSupport.bootstrap("addTask", $$robo$$android_media_MediaPlayer2Impl$addTask(android.media.MediaPlayer2Impl$Task ), this, task);
    }

    private void processPendingTask_l() {
        InvokeDynamicSupport.bootstrap("processPendingTask_l", $$robo$$android_media_MediaPlayer2Impl$processPendingTask_l(), this);
    }

    private void handleDataSource(boolean bl, DataSourceDesc dataSourceDesc, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("handleDataSource", $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean android.media.DataSourceDesc long ), this, bl, dataSourceDesc, l);
    }

    private void handleDataSource(boolean bl, long l, Context context, Uri uri, Map<String, String> map, List<HttpCookie> list) throws IOException {
        InvokeDynamicSupport.bootstrap("handleDataSource", $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean long android.content.Context android.net.Uri java.util.Map<java.lang.String, java.lang.String> java.util.List<java.net.HttpCookie> ), this, bl, l, context, uri, map, list);
    }

    private boolean attemptDataSource(boolean bl, long l, ContentResolver contentResolver, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("attemptDataSource", $$robo$$android_media_MediaPlayer2Impl$attemptDataSource(boolean long android.content.ContentResolver android.net.Uri ), this, bl, l, contentResolver, uri);
    }

    private void handleDataSource(boolean bl, long l, String string2, Map<String, String> map, List<HttpCookie> list) throws IOException {
        InvokeDynamicSupport.bootstrap("handleDataSource", $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean long java.lang.String java.util.Map<java.lang.String, java.lang.String> java.util.List<java.net.HttpCookie> ), this, bl, l, string2, map, list);
    }

    private void handleDataSource(boolean bl, long l, String string2, String[] stringArray, String[] stringArray2, List<HttpCookie> list) throws IOException {
        InvokeDynamicSupport.bootstrap("handleDataSource", $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean long java.lang.String java.lang.String[] java.lang.String[] java.util.List<java.net.HttpCookie> ), this, bl, l, string2, stringArray, stringArray2, list);
    }

    private void nativeHandleDataSourceUrl(boolean bl, long l, Media2HTTPService media2HTTPService, String string2, String[] stringArray, String[] stringArray2) throws IOException {
        InvokeDynamicSupport.bootstrap("nativeHandleDataSourceUrl", $$robo$$android_media_MediaPlayer2Impl$nativeHandleDataSourceUrl(boolean long android.media.Media2HTTPService java.lang.String java.lang.String[] java.lang.String[] ), this, bl, l, media2HTTPService, string2, stringArray, stringArray2);
    }

    private void handleDataSource(boolean bl, long l, FileDescriptor fileDescriptor, long l2, long l3) throws IOException {
        InvokeDynamicSupport.bootstrap("handleDataSource", $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean long java.io.FileDescriptor long long ), this, bl, l, fileDescriptor, l2, l3);
    }

    private void nativeHandleDataSourceFD(boolean bl, long l, FileDescriptor fileDescriptor, long l2, long l3) throws IOException {
        InvokeDynamicSupport.bootstrap("nativeHandleDataSourceFD", $$robo$$android_media_MediaPlayer2Impl$nativeHandleDataSourceFD(boolean long java.io.FileDescriptor long long ), this, bl, l, fileDescriptor, l2, l3);
    }

    private void handleDataSource(boolean bl, long l, Media2DataSource media2DataSource) {
        InvokeDynamicSupport.bootstrap("handleDataSource", $$robo$$android_media_MediaPlayer2Impl$handleDataSource(boolean long android.media.Media2DataSource ), this, bl, l, media2DataSource);
    }

    private void nativeHandleDataSourceCallback(boolean bl, long l, Media2DataSource media2DataSource) {
        InvokeDynamicSupport.bootstrap("nativeHandleDataSourceCallback", $$robo$$android_media_MediaPlayer2Impl$nativeHandleDataSourceCallback(boolean long android.media.Media2DataSource ), this, bl, l, media2DataSource);
    }

    private void prepareNextDataSource_l() {
        InvokeDynamicSupport.bootstrap("prepareNextDataSource_l", $$robo$$android_media_MediaPlayer2Impl$prepareNextDataSource_l(), this);
    }

    private void playNextDataSource_l() {
        InvokeDynamicSupport.bootstrap("playNextDataSource_l", $$robo$$android_media_MediaPlayer2Impl$playNextDataSource_l(), this);
    }

    private void nativePlayNextDataSource(long l) {
        InvokeDynamicSupport.bootstrap("nativePlayNextDataSource", $$robo$$android_media_MediaPlayer2Impl$nativePlayNextDataSource(long ), this, l);
    }

    private int getAudioStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioStreamType", $$robo$$android_media_MediaPlayer2Impl$getAudioStreamType(), this);
    }

    private int _getAudioStreamType() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("_getAudioStreamType", $$robo$$android_media_MediaPlayer2Impl$_getAudioStreamType(), this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_MediaPlayer2Impl$stop(), this);
    }

    private void _stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("_stop", $$robo$$android_media_MediaPlayer2Impl$_stop(), this);
    }

    @Override
    public boolean setPreferredDevice(AudioDeviceInfo audioDeviceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredDevice", $$robo$$android_media_MediaPlayer2Impl$setPreferredDevice(android.media.AudioDeviceInfo ), this, audioDeviceInfo);
    }

    @Override
    public AudioDeviceInfo getPreferredDevice() {
        return InvokeDynamicSupport.bootstrap("getPreferredDevice", $$robo$$android_media_MediaPlayer2Impl$getPreferredDevice(), this);
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        return InvokeDynamicSupport.bootstrap("getRoutedDevice", $$robo$$android_media_MediaPlayer2Impl$getRoutedDevice(), this);
    }

    private void enableNativeRoutingCallbacksLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableNativeRoutingCallbacksLocked", $$robo$$android_media_MediaPlayer2Impl$enableNativeRoutingCallbacksLocked(boolean ), this, bl);
    }

    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnRoutingChangedListener", $$robo$$android_media_MediaPlayer2Impl$addOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener android.os.Handler ), this, onRoutingChangedListener, handler);
    }

    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnRoutingChangedListener", $$robo$$android_media_MediaPlayer2Impl$removeOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener ), this, onRoutingChangedListener);
    }

    private boolean native_setOutputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_setOutputDevice", $$robo$$android_media_MediaPlayer2Impl$native_setOutputDevice(int ), this, n);
    }

    private int native_getRoutedDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("native_getRoutedDeviceId", $$robo$$android_media_MediaPlayer2Impl$native_getRoutedDeviceId(), this);
    }

    private void native_enableDeviceCallback(boolean bl) {
        InvokeDynamicSupport.bootstrap("native_enableDeviceCallback", $$robo$$android_media_MediaPlayer2Impl$native_enableDeviceCallback(boolean ), this, bl);
    }

    @Override
    public void setWakeMode(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setWakeMode", $$robo$$android_media_MediaPlayer2Impl$setWakeMode(android.content.Context int ), this, context, n);
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScreenOnWhilePlaying", $$robo$$android_media_MediaPlayer2Impl$setScreenOnWhilePlaying(boolean ), this, bl);
    }

    private void stayAwake(boolean bl) {
        InvokeDynamicSupport.bootstrap("stayAwake", $$robo$$android_media_MediaPlayer2Impl$stayAwake(boolean ), this, bl);
    }

    private void updateSurfaceScreenOn() {
        InvokeDynamicSupport.bootstrap("updateSurfaceScreenOn", $$robo$$android_media_MediaPlayer2Impl$updateSurfaceScreenOn(), this);
    }

    @Override
    public int getVideoWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoWidth", $$robo$$android_media_MediaPlayer2Impl$getVideoWidth(), this);
    }

    @Override
    public int getVideoHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoHeight", $$robo$$android_media_MediaPlayer2Impl$getVideoHeight(), this);
    }

    @Override
    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_MediaPlayer2Impl$getMetrics(), this);
    }

    private PersistableBundle native_getMetrics() {
        return InvokeDynamicSupport.bootstrap("native_getMetrics", $$robo$$android_media_MediaPlayer2Impl$native_getMetrics(), this);
    }

    @Override
    public boolean isPlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlaying", $$robo$$android_media_MediaPlayer2Impl$isPlaying(), this);
    }

    @Override
    public int getMediaPlayer2State() {
        return (int)InvokeDynamicSupport.bootstrap("getMediaPlayer2State", $$robo$$android_media_MediaPlayer2Impl$getMediaPlayer2State(), this);
    }

    private int native_getMediaPlayer2State() {
        return (int)InvokeDynamicSupport.bootstrap("native_getMediaPlayer2State", $$robo$$android_media_MediaPlayer2Impl$native_getMediaPlayer2State(), this);
    }

    @Override
    public BufferingParams getBufferingParams() {
        return InvokeDynamicSupport.bootstrap("getBufferingParams", $$robo$$android_media_MediaPlayer2Impl$getBufferingParams(), this);
    }

    @Override
    public void setBufferingParams(BufferingParams bufferingParams) {
        InvokeDynamicSupport.bootstrap("setBufferingParams", $$robo$$android_media_MediaPlayer2Impl$setBufferingParams(android.media.BufferingParams ), this, bufferingParams);
    }

    private void _setBufferingParams(BufferingParams bufferingParams) {
        InvokeDynamicSupport.bootstrap("_setBufferingParams", $$robo$$android_media_MediaPlayer2Impl$_setBufferingParams(android.media.BufferingParams ), this, bufferingParams);
    }

    @Override
    public PlaybackParams easyPlaybackParams(float f, int n) {
        return InvokeDynamicSupport.bootstrap("easyPlaybackParams", $$robo$$android_media_MediaPlayer2Impl$easyPlaybackParams(float int ), this, f, n);
    }

    @Override
    public void setPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("setPlaybackParams", $$robo$$android_media_MediaPlayer2Impl$setPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
    }

    private void _setPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("_setPlaybackParams", $$robo$$android_media_MediaPlayer2Impl$_setPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
    }

    @Override
    public PlaybackParams getPlaybackParams() {
        return InvokeDynamicSupport.bootstrap("getPlaybackParams", $$robo$$android_media_MediaPlayer2Impl$getPlaybackParams(), this);
    }

    @Override
    public void setSyncParams(SyncParams syncParams) {
        InvokeDynamicSupport.bootstrap("setSyncParams", $$robo$$android_media_MediaPlayer2Impl$setSyncParams(android.media.SyncParams ), this, syncParams);
    }

    private void _setSyncParams(SyncParams syncParams) {
        InvokeDynamicSupport.bootstrap("_setSyncParams", $$robo$$android_media_MediaPlayer2Impl$_setSyncParams(android.media.SyncParams ), this, syncParams);
    }

    @Override
    public SyncParams getSyncParams() {
        return InvokeDynamicSupport.bootstrap("getSyncParams", $$robo$$android_media_MediaPlayer2Impl$getSyncParams(), this);
    }

    @Override
    public void seekTo(long l, int n) {
        InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_MediaPlayer2Impl$seekTo(long int ), this, l, n);
    }

    private void _seekTo(long l, int n) {
        InvokeDynamicSupport.bootstrap("_seekTo", $$robo$$android_media_MediaPlayer2Impl$_seekTo(long int ), this, l, n);
    }

    @Override
    public MediaTimestamp getTimestamp() {
        return InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_MediaPlayer2Impl$getTimestamp(), this);
    }

    @Override
    public Metadata getMetadata(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_media_MediaPlayer2Impl$getMetadata(boolean boolean ), this, bl, bl2);
    }

    @Override
    public int setMetadataFilter(Set<Integer> set, Set<Integer> set2) {
        return (int)InvokeDynamicSupport.bootstrap("setMetadataFilter", $$robo$$android_media_MediaPlayer2Impl$setMetadataFilter(java.util.Set<java.lang.Integer> java.util.Set<java.lang.Integer> ), this, set, set2);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_MediaPlayer2Impl$reset(), this);
    }

    private void _reset() {
        InvokeDynamicSupport.bootstrap("_reset", $$robo$$android_media_MediaPlayer2Impl$_reset(), this);
    }

    @Override
    public void notifyAt(long l) {
        InvokeDynamicSupport.bootstrap("notifyAt", $$robo$$android_media_MediaPlayer2Impl$notifyAt(long ), this, l);
    }

    private void _notifyAt(long l) {
        InvokeDynamicSupport.bootstrap("_notifyAt", $$robo$$android_media_MediaPlayer2Impl$_notifyAt(long ), this, l);
    }

    private boolean setParameter(int n, Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_MediaPlayer2Impl$setParameter(int android.os.Parcel ), this, n, parcel);
    }

    private Parcel getParameter(int n) {
        return InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_MediaPlayer2Impl$getParameter(int ), this, n);
    }

    @Override
    public boolean isLooping() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLooping", $$robo$$android_media_MediaPlayer2Impl$isLooping(), this);
    }

    @Override
    public void setAudioSessionId(int n) {
        InvokeDynamicSupport.bootstrap("setAudioSessionId", $$robo$$android_media_MediaPlayer2Impl$setAudioSessionId(int ), this, n);
    }

    private void _setAudioSessionId(int n) {
        InvokeDynamicSupport.bootstrap("_setAudioSessionId", $$robo$$android_media_MediaPlayer2Impl$_setAudioSessionId(int ), this, n);
    }

    @Override
    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_media_MediaPlayer2Impl$getAudioSessionId(), this);
    }

    @Override
    public void attachAuxEffect(int n) {
        InvokeDynamicSupport.bootstrap("attachAuxEffect", $$robo$$android_media_MediaPlayer2Impl$attachAuxEffect(int ), this, n);
    }

    private void _attachAuxEffect(int n) {
        InvokeDynamicSupport.bootstrap("_attachAuxEffect", $$robo$$android_media_MediaPlayer2Impl$_attachAuxEffect(int ), this, n);
    }

    @Override
    public void setAuxEffectSendLevel(float f) {
        InvokeDynamicSupport.bootstrap("setAuxEffectSendLevel", $$robo$$android_media_MediaPlayer2Impl$setAuxEffectSendLevel(float ), this, f);
    }

    private void _setAuxEffectSendLevel(float f) {
        InvokeDynamicSupport.bootstrap("_setAuxEffectSendLevel", $$robo$$android_media_MediaPlayer2Impl$_setAuxEffectSendLevel(float ), this, f);
    }

    private int native_invoke(Parcel parcel, Parcel parcel2) {
        return (int)InvokeDynamicSupport.bootstrap("native_invoke", $$robo$$android_media_MediaPlayer2Impl$native_invoke(android.os.Parcel android.os.Parcel ), this, parcel, parcel2);
    }

    private boolean native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_getMetadata", $$robo$$android_media_MediaPlayer2Impl$native_getMetadata(boolean boolean android.os.Parcel ), this, bl, bl2, parcel);
    }

    private int native_setMetadataFilter(Parcel parcel) {
        return (int)InvokeDynamicSupport.bootstrap("native_setMetadataFilter", $$robo$$android_media_MediaPlayer2Impl$native_setMetadataFilter(android.os.Parcel ), this, parcel);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaPlayer2Impl$native_init());
    }

    private void native_setup(Object object) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaPlayer2Impl$native_setup(java.lang.Object ), this, object);
    }

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaPlayer2Impl$native_finalize(), this);
    }

    private static void native_stream_event_onTearDown(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_stream_event_onTearDown", $$robo$$android_media_MediaPlayer2Impl$native_stream_event_onTearDown(long long ), (long)l, (long)l2);
    }

    private static void native_stream_event_onStreamPresentationEnd(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_stream_event_onStreamPresentationEnd", $$robo$$android_media_MediaPlayer2Impl$native_stream_event_onStreamPresentationEnd(long long ), (long)l, (long)l2);
    }

    private static void native_stream_event_onStreamDataRequest(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_stream_event_onStreamDataRequest", $$robo$$android_media_MediaPlayer2Impl$native_stream_event_onStreamDataRequest(long long long ), (long)l, (long)l2, (long)l3);
    }

    @Override
    public List<MediaPlayer2.TrackInfo> getTrackInfo() {
        return InvokeDynamicSupport.bootstrap("getTrackInfo", $$robo$$android_media_MediaPlayer2Impl$getTrackInfo(), this);
    }

    private TrackInfoImpl[] getInbandTrackInfoImpl() throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getInbandTrackInfoImpl", $$robo$$android_media_MediaPlayer2Impl$getInbandTrackInfoImpl(), this);
    }

    private static boolean availableMimeTypeForExternalSource(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("availableMimeTypeForExternalSource", $$robo$$android_media_MediaPlayer2Impl$availableMimeTypeForExternalSource(java.lang.String ), (String)string2);
    }

    @Override
    public void setSubtitleAnchor(SubtitleController subtitleController, SubtitleController.Anchor anchor) {
        InvokeDynamicSupport.bootstrap("setSubtitleAnchor", $$robo$$android_media_MediaPlayer2Impl$setSubtitleAnchor(android.media.SubtitleController android.media.SubtitleController$Anchor ), this, subtitleController, anchor);
    }

    private synchronized void setSubtitleAnchor() {
        InvokeDynamicSupport.bootstrap("setSubtitleAnchor", $$robo$$android_media_MediaPlayer2Impl$setSubtitleAnchor(), this);
    }

    @Override
    public void onSubtitleTrackSelected(SubtitleTrack subtitleTrack) {
        InvokeDynamicSupport.bootstrap("onSubtitleTrackSelected", $$robo$$android_media_MediaPlayer2Impl$onSubtitleTrackSelected(android.media.SubtitleTrack ), this, subtitleTrack);
    }

    @Override
    public void addSubtitleSource(InputStream inputStream, MediaFormat mediaFormat) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("addSubtitleSource", $$robo$$android_media_MediaPlayer2Impl$addSubtitleSource(java.io.InputStream android.media.MediaFormat ), this, inputStream, mediaFormat);
    }

    private void scanInternalSubtitleTracks() {
        InvokeDynamicSupport.bootstrap("scanInternalSubtitleTracks", $$robo$$android_media_MediaPlayer2Impl$scanInternalSubtitleTracks(), this);
    }

    private void populateInbandTracks() {
        InvokeDynamicSupport.bootstrap("populateInbandTracks", $$robo$$android_media_MediaPlayer2Impl$populateInbandTracks(), this);
    }

    @Override
    public void addTimedTextSource(String string2, String string3) throws IOException {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void addTimedTextSource(Context context, Uri uri, String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(android.content.Context android.net.Uri java.lang.String ), this, context, uri, string2);
    }

    @Override
    public void addTimedTextSource(FileDescriptor fileDescriptor, String string2) {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(java.io.FileDescriptor java.lang.String ), this, fileDescriptor, string2);
    }

    @Override
    public void addTimedTextSource(FileDescriptor fileDescriptor, long l, long l2, String string2) {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer2Impl$addTimedTextSource(java.io.FileDescriptor long long java.lang.String ), this, fileDescriptor, l, l2, string2);
    }

    @Override
    public int getSelectedTrack(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedTrack", $$robo$$android_media_MediaPlayer2Impl$getSelectedTrack(int ), this, n);
    }

    @Override
    public void selectTrack(int n) {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_MediaPlayer2Impl$selectTrack(int ), this, n);
    }

    @Override
    public void deselectTrack(int n) {
        InvokeDynamicSupport.bootstrap("deselectTrack", $$robo$$android_media_MediaPlayer2Impl$deselectTrack(int ), this, n);
    }

    private void selectOrDeselectTrack(int n, boolean bl) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("selectOrDeselectTrack", $$robo$$android_media_MediaPlayer2Impl$selectOrDeselectTrack(int boolean ), this, n, bl);
    }

    private void selectOrDeselectInbandTrack(int n, boolean bl) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("selectOrDeselectInbandTrack", $$robo$$android_media_MediaPlayer2Impl$selectOrDeselectInbandTrack(int boolean ), this, n, bl);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaPlayer2Impl$finalize(), this);
    }

    private void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaPlayer2Impl$release(), this);
    }

    private void _release() {
        InvokeDynamicSupport.bootstrap("_release", $$robo$$android_media_MediaPlayer2Impl$_release(), this);
    }

    @Override
    public MediaTimeProvider getMediaTimeProvider() {
        return InvokeDynamicSupport.bootstrap("getMediaTimeProvider", $$robo$$android_media_MediaPlayer2Impl$getMediaTimeProvider(), this);
    }

    private static void postEventFromNative(Object object, long l, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_MediaPlayer2Impl$postEventFromNative(java.lang.Object long int int int java.lang.Object ), (Object)object, (long)l, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    @Override
    public void setMediaPlayer2EventCallback(Executor executor, MediaPlayer2.MediaPlayer2EventCallback mediaPlayer2EventCallback) {
        InvokeDynamicSupport.bootstrap("setMediaPlayer2EventCallback", $$robo$$android_media_MediaPlayer2Impl$setMediaPlayer2EventCallback(java.util.concurrent.Executor android.media.MediaPlayer2$MediaPlayer2EventCallback ), this, executor, mediaPlayer2EventCallback);
    }

    @Override
    public void clearMediaPlayer2EventCallback() {
        InvokeDynamicSupport.bootstrap("clearMediaPlayer2EventCallback", $$robo$$android_media_MediaPlayer2Impl$clearMediaPlayer2EventCallback(), this);
    }

    @Override
    public void setOnSubtitleDataListener(MediaPlayer2.OnSubtitleDataListener onSubtitleDataListener) {
        InvokeDynamicSupport.bootstrap("setOnSubtitleDataListener", $$robo$$android_media_MediaPlayer2Impl$setOnSubtitleDataListener(android.media.MediaPlayer2$OnSubtitleDataListener ), this, onSubtitleDataListener);
    }

    @Override
    public void setOnDrmConfigHelper(MediaPlayer2.OnDrmConfigHelper onDrmConfigHelper) {
        InvokeDynamicSupport.bootstrap("setOnDrmConfigHelper", $$robo$$android_media_MediaPlayer2Impl$setOnDrmConfigHelper(android.media.MediaPlayer2$OnDrmConfigHelper ), this, onDrmConfigHelper);
    }

    @Override
    public void setDrmEventCallback(Executor executor, MediaPlayer2.DrmEventCallback drmEventCallback) {
        InvokeDynamicSupport.bootstrap("setDrmEventCallback", $$robo$$android_media_MediaPlayer2Impl$setDrmEventCallback(java.util.concurrent.Executor android.media.MediaPlayer2$DrmEventCallback ), this, executor, drmEventCallback);
    }

    @Override
    public void clearDrmEventCallback() {
        InvokeDynamicSupport.bootstrap("clearDrmEventCallback", $$robo$$android_media_MediaPlayer2Impl$clearDrmEventCallback(), this);
    }

    @Override
    public MediaPlayer2.DrmInfo getDrmInfo() {
        return InvokeDynamicSupport.bootstrap("getDrmInfo", $$robo$$android_media_MediaPlayer2Impl$getDrmInfo(), this);
    }

    @Override
    public void prepareDrm(UUID uUID) throws UnsupportedSchemeException, ResourceBusyException, MediaPlayer2.ProvisioningNetworkErrorException, MediaPlayer2.ProvisioningServerErrorException {
        InvokeDynamicSupport.bootstrap("prepareDrm", $$robo$$android_media_MediaPlayer2Impl$prepareDrm(java.util.UUID ), this, uUID);
    }

    private void _releaseDrm() {
        InvokeDynamicSupport.bootstrap("_releaseDrm", $$robo$$android_media_MediaPlayer2Impl$_releaseDrm(), this);
    }

    @Override
    public void releaseDrm() throws MediaPlayer2.NoDrmSchemeException {
        InvokeDynamicSupport.bootstrap("releaseDrm", $$robo$$android_media_MediaPlayer2Impl$releaseDrm(), this);
    }

    @Override
    public MediaDrm.KeyRequest getDrmKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, Map<String, String> map) throws MediaPlayer2.NoDrmSchemeException {
        return InvokeDynamicSupport.bootstrap("getDrmKeyRequest", $$robo$$android_media_MediaPlayer2Impl$getDrmKeyRequest(byte[] byte[] java.lang.String int java.util.Map<java.lang.String, java.lang.String> ), this, byArray, byArray2, string2, n, map);
    }

    @Override
    public byte[] provideDrmKeyResponse(byte[] byArray, byte[] byArray2) throws MediaPlayer2.NoDrmSchemeException, DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideDrmKeyResponse", $$robo$$android_media_MediaPlayer2Impl$provideDrmKeyResponse(byte[] byte[] ), this, byArray, byArray2);
    }

    @Override
    public void restoreDrmKeys(byte[] byArray) throws MediaPlayer2.NoDrmSchemeException {
        InvokeDynamicSupport.bootstrap("restoreDrmKeys", $$robo$$android_media_MediaPlayer2Impl$restoreDrmKeys(byte[] ), this, byArray);
    }

    @Override
    public String getDrmPropertyString(String string2) throws MediaPlayer2.NoDrmSchemeException {
        return InvokeDynamicSupport.bootstrap("getDrmPropertyString", $$robo$$android_media_MediaPlayer2Impl$getDrmPropertyString(java.lang.String ), this, string2);
    }

    @Override
    public void setDrmPropertyString(String string2, String string3) throws MediaPlayer2.NoDrmSchemeException {
        InvokeDynamicSupport.bootstrap("setDrmPropertyString", $$robo$$android_media_MediaPlayer2Impl$setDrmPropertyString(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void _prepareDrm(byte[] byArray, byte[] byArray2) {
        InvokeDynamicSupport.bootstrap("_prepareDrm", $$robo$$android_media_MediaPlayer2Impl$_prepareDrm(byte[] byte[] ), this, byArray, byArray2);
    }

    private void prepareDrm_createDrmStep(UUID uUID) throws UnsupportedSchemeException {
        InvokeDynamicSupport.bootstrap("prepareDrm_createDrmStep", $$robo$$android_media_MediaPlayer2Impl$prepareDrm_createDrmStep(java.util.UUID ), this, uUID);
    }

    private void prepareDrm_openSessionStep(UUID uUID) throws NotProvisionedException, ResourceBusyException {
        InvokeDynamicSupport.bootstrap("prepareDrm_openSessionStep", $$robo$$android_media_MediaPlayer2Impl$prepareDrm_openSessionStep(java.util.UUID ), this, uUID);
    }

    private static boolean setAudioOutputDeviceById(AudioTrack audioTrack, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setAudioOutputDeviceById", $$robo$$android_media_MediaPlayer2Impl$setAudioOutputDeviceById(android.media.AudioTrack int ), (AudioTrack)audioTrack, (int)n);
    }

    private int HandleProvisioninig(UUID uUID) {
        return (int)InvokeDynamicSupport.bootstrap("HandleProvisioninig", $$robo$$android_media_MediaPlayer2Impl$HandleProvisioninig(java.util.UUID ), this, uUID);
    }

    private boolean resumePrepareDrm(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrap("resumePrepareDrm", $$robo$$android_media_MediaPlayer2Impl$resumePrepareDrm(java.util.UUID ), this, uUID);
    }

    private void resetDrmState() {
        InvokeDynamicSupport.bootstrap("resetDrmState", $$robo$$android_media_MediaPlayer2Impl$resetDrmState(), this);
    }

    private void cleanDrmObj() {
        InvokeDynamicSupport.bootstrap("cleanDrmObj", $$robo$$android_media_MediaPlayer2Impl$cleanDrmObj(), this);
    }

    private static byte[] getByteArrayFromUUID(UUID uUID) {
        return InvokeDynamicSupport.bootstrapStatic("getByteArrayFromUUID", $$robo$$android_media_MediaPlayer2Impl$getByteArrayFromUUID(java.util.UUID ), (UUID)uUID);
    }

    private boolean isVideoScalingModeSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoScalingModeSupported", $$robo$$android_media_MediaPlayer2Impl$isVideoScalingModeSupported(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(MediaPlayer2Impl.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaPlayer2Impl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private abstract class Task
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mMediaCallType;
        private boolean mNeedToWaitForEventToComplete;
        private DataSourceDesc mDSD;
        /* synthetic */ MediaPlayer2Impl this$0;

        private void $$robo$$android_media_MediaPlayer2Impl_Task$__constructor__(MediaPlayer2Impl mediaPlayer2Impl, int mediaCallType, boolean needToWaitForEventToComplete) {
            this.this$0 = mediaPlayer2Impl;
            this.mMediaCallType = mediaCallType;
            this.mNeedToWaitForEventToComplete = needToWaitForEventToComplete;
        }

        abstract void process() throws IOException, MediaPlayer2.NoDrmSchemeException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_Task$run() {
            int status = 0;
            try {
                this.process();
            }
            catch (IllegalStateException e) {
                status = 1;
            }
            catch (IllegalArgumentException e) {
                status = 2;
            }
            catch (SecurityException e) {
                status = 3;
            }
            catch (IOException e) {
                status = 4;
            }
            catch (MediaPlayer2.NoDrmSchemeException e) {
                status = 5;
            }
            catch (Exception e) {
                status = Integer.MIN_VALUE;
            }
            Object object = this.this$0.mSrcLock;
            synchronized (object) {
                this.mDSD = this.this$0.mCurrentDSD;
            }
            if (!this.mNeedToWaitForEventToComplete || status != 0) {
                this.sendCompleteNotification(status);
                object = this.this$0.mTaskLock;
                synchronized (object) {
                    this.this$0.mCurrentTask = null;
                    this.this$0.processPendingTask_l();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_Task$sendCompleteNotification(int status) {
            if (this.mMediaCallType == 1003) {
                return;
            }
            Object object = this.this$0.mEventCbLock;
            synchronized (object) {
                for (Pair cb : this.this$0.mEventCallbackRecords) {
                    ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onCallCompleted(this.this$0, this.mDSD, this.mMediaCallType, status));
                }
            }
        }

        private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
            this.$$robo$$android_media_MediaPlayer2Impl_Task$__constructor__(mediaPlayer2Impl, n, bl);
        }

        public Task(MediaPlayer2Impl mediaPlayer2Impl, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_Task$__constructor__(android.media.MediaPlayer2Impl int boolean ), this, mediaPlayer2Impl, n, bl);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_Task$run(), this);
        }

        private void sendCompleteNotification(int n) {
            InvokeDynamicSupport.bootstrap("sendCompleteNotification", $$robo$$android_media_MediaPlayer2Impl_Task$sendCompleteNotification(int ), this, n);
        }

        public /* synthetic */ Task() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Task)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TimeProvider
    implements MediaTimeProvider,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String TAG = "MTP";
        private static long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static long MAX_EARLY_CALLBACK_US = 1000L;
        private static long TIME_ADJUSTMENT_RATE = 2L;
        private long mLastTimeUs;
        private MediaPlayer2Impl mPlayer;
        private boolean mPaused;
        private boolean mStopped;
        private boolean mBuffering;
        private long mLastReportedTime;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private long[] mTimes;
        private EventHandler mEventHandler;
        private boolean mRefresh;
        private boolean mPausing;
        private boolean mSeeking;
        private static int NOTIFY = 1;
        private static int NOTIFY_TIME = 0;
        private static int NOTIFY_STOP = 2;
        private static int NOTIFY_SEEK = 3;
        private static int NOTIFY_TRACK_DATA = 4;
        private HandlerThread mHandlerThread;
        public boolean DEBUG;

        private void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$__constructor__(MediaPlayer2Impl mp) {
            this.mLastTimeUs = 0L;
            this.mPaused = true;
            this.mStopped = true;
            this.mRefresh = false;
            this.mPausing = false;
            this.mSeeking = false;
            this.DEBUG = false;
            this.mPlayer = mp;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
            }
            Looper looper = Looper.myLooper();
            if (looper == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayer2MTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(this, looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$scheduleNotification(int type, long delayUs) {
            if (this.mSeeking && type == 0) {
                return;
            }
            if (this.DEBUG) {
                Log.v("MTP", "scheduleNotification " + type + " in " + delayUs);
            }
            this.mEventHandler.removeMessages(1);
            Message msg = this.mEventHandler.obtainMessage(1, type, 0);
            this.mEventHandler.sendMessageDelayed(msg, (int)(delayUs / 1000L));
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onNotifyTime() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onNotifyTime: ");
                }
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onPaused(boolean paused) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onPaused: " + paused);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = paused;
                    this.mSeeking = false;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onBuffering(boolean buffering) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onBuffering: " + buffering);
                }
                this.mBuffering = buffering;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onStopped() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.mBuffering = false;
                this.scheduleNotification(2, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onSeekComplete(MediaPlayer2Impl mp) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onNewPlayer() {
            if (this.mRefresh) {
                TimeProvider timeProvider = this;
                synchronized (timeProvider) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.mBuffering = false;
                    this.scheduleNotification(3, 0L);
                }
            }
        }

        private final synchronized void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifySeek() {
            this.mSeeking = false;
            try {
                long timeUs = this.getCurrentTimeUs(true, false);
                if (this.DEBUG) {
                    Log.d("MTP", "onSeekComplete at " + timeUs);
                }
                for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                    if (listener == null) break;
                    listener.onSeek(timeUs);
                }
            }
            catch (IllegalStateException e) {
                if (this.DEBUG) {
                    Log.d("MTP", "onSeekComplete but no player");
                }
                this.mPausing = true;
                this.notifyTimedEvent(false);
            }
        }

        private final synchronized void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyTrackData(Pair<SubtitleTrack, byte[]> trackData) {
            SubtitleTrack track = (SubtitleTrack)trackData.first;
            byte[] data = (byte[])trackData.second;
            track.onData(data, true, -1L);
        }

        private final synchronized void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyStop() {
            for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                if (listener == null) break;
                listener.onStop();
            }
        }

        private final int $$robo$$android_media_MediaPlayer2Impl_TimeProvider$registerListener(MediaTimeProvider.OnMediaTimeListener listener) {
            int i;
            for (i = 0; i < this.mListeners.length && this.mListeners[i] != listener && this.mListeners[i] != null; ++i) {
            }
            if (i >= this.mListeners.length) {
                MediaTimeProvider.OnMediaTimeListener[] newListeners = new MediaTimeProvider.OnMediaTimeListener[i + 1];
                long[] newTimes = new long[i + 1];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mListeners, (int)0, (Object)newListeners, (int)0, (int)this.mListeners.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mTimes, (int)0, (Object)newTimes, (int)0, (int)this.mTimes.length);
                this.mListeners = newListeners;
                this.mTimes = newTimes;
            }
            if (this.mListeners[i] == null) {
                this.mListeners[i] = listener;
                this.mTimes[i] = -1L;
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyAt(long timeUs, MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "notifyAt " + timeUs);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)listener)] = timeUs;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$scheduleUpdate(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "scheduleUpdate");
                }
                int i = this.registerListener(listener);
                if (!this.mStopped) {
                    this.mTimes[i] = 0L;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$cancelNotifications(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == listener) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mListeners, (int)(i + 1), (Object)this.mListeners, (int)i, (int)(this.mListeners.length - i - 1));
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mTimes, (int)(i + 1), (Object)this.mTimes, (int)i, (int)(this.mTimes.length - i - 1));
                        this.mListeners[this.mListeners.length - 1] = null;
                        this.mTimes[this.mTimes.length - 1] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
            }
        }

        private final synchronized void $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyTimedEvent(boolean refreshTime) {
            long nowUs;
            try {
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
                this.mPausing = true;
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            long nextTimeUs = nowUs;
            if (this.mSeeking) {
                return;
            }
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(nowUs).append(") from {");
                boolean first = true;
                for (long time : this.mTimes) {
                    if (time == -1L) continue;
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(time);
                    first = false;
                }
                sb.append("}");
                Log.d("MTP", sb.toString());
            }
            Vector<MediaTimeProvider.OnMediaTimeListener> activatedListeners = new Vector<MediaTimeProvider.OnMediaTimeListener>();
            for (int ix = 0; ix < this.mTimes.length && this.mListeners[ix] != null; ++ix) {
                if (this.mTimes[ix] <= -1L) continue;
                if (this.mTimes[ix] <= nowUs + 1000L) {
                    activatedListeners.add(this.mListeners[ix]);
                    if (this.DEBUG) {
                        Log.d("MTP", "removed");
                    }
                    this.mTimes[ix] = -1L;
                    continue;
                }
                if (nextTimeUs != nowUs && this.mTimes[ix] >= nextTimeUs) continue;
                nextTimeUs = this.mTimes[ix];
            }
            if (nextTimeUs > nowUs && !this.mPaused) {
                if (this.DEBUG) {
                    Log.d("MTP", "scheduling for " + nextTimeUs + " and " + nowUs);
                }
                this.mPlayer.notifyAt(nextTimeUs);
            } else {
                this.mEventHandler.removeMessages(1);
            }
            for (MediaTimeProvider.OnMediaTimeListener listener : activatedListeners) {
                listener.onTimedEvent(nowUs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long $$robo$$android_media_MediaPlayer2Impl_TimeProvider$getCurrentTimeUs(boolean refreshTime, boolean monotonic) throws IllegalStateException {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.mPaused && !refreshTime) {
                    return this.mLastReportedTime;
                }
                try {
                    this.mLastTimeUs = this.mPlayer.getCurrentPosition() * 1000L;
                    boolean bl = this.mPaused = !this.mPlayer.isPlaying() || this.mBuffering;
                    if (this.DEBUG) {
                        Log.v("MTP", (this.mPaused ? "paused" : "playing") + " at " + this.mLastTimeUs);
                    }
                }
                catch (IllegalStateException e) {
                    if (this.mPausing) {
                        this.mPausing = false;
                        if (!monotonic || this.mLastReportedTime < this.mLastTimeUs) {
                            this.mLastReportedTime = this.mLastTimeUs;
                        }
                        this.mPaused = true;
                        if (this.DEBUG) {
                            Log.d("MTP", "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                        }
                        return this.mLastReportedTime;
                    }
                    throw e;
                }
                if (monotonic && this.mLastTimeUs < this.mLastReportedTime) {
                    if (this.mLastReportedTime - this.mLastTimeUs > 1000000L) {
                        this.mStopped = false;
                        this.mSeeking = true;
                        this.scheduleNotification(3, 0L);
                    }
                } else {
                    this.mLastReportedTime = this.mLastTimeUs;
                }
                return this.mLastReportedTime;
            }
        }

        private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl) {
            this.$$robo$$android_media_MediaPlayer2Impl_TimeProvider$__constructor__(mediaPlayer2Impl);
        }

        public TimeProvider(MediaPlayer2Impl mediaPlayer2Impl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$__constructor__(android.media.MediaPlayer2Impl ), this, mediaPlayer2Impl);
        }

        private void scheduleNotification(int n, long l) {
            InvokeDynamicSupport.bootstrap("scheduleNotification", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$scheduleNotification(int long ), this, n, l);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$close(), this);
        }

        protected void finalize() {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$finalize(), this);
        }

        public void onNotifyTime() {
            InvokeDynamicSupport.bootstrap("onNotifyTime", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onNotifyTime(), this);
        }

        public void onPaused(boolean bl) {
            InvokeDynamicSupport.bootstrap("onPaused", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onPaused(boolean ), this, bl);
        }

        public void onBuffering(boolean bl) {
            InvokeDynamicSupport.bootstrap("onBuffering", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onBuffering(boolean ), this, bl);
        }

        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onStopped(), this);
        }

        public void onSeekComplete(MediaPlayer2Impl mediaPlayer2Impl) {
            InvokeDynamicSupport.bootstrap("onSeekComplete", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onSeekComplete(android.media.MediaPlayer2Impl ), this, mediaPlayer2Impl);
        }

        public void onNewPlayer() {
            InvokeDynamicSupport.bootstrap("onNewPlayer", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$onNewPlayer(), this);
        }

        private synchronized void notifySeek() {
            InvokeDynamicSupport.bootstrap("notifySeek", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifySeek(), this);
        }

        private synchronized void notifyTrackData(Pair<SubtitleTrack, byte[]> pair) {
            InvokeDynamicSupport.bootstrap("notifyTrackData", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyTrackData(android.util.Pair<android.media.SubtitleTrack, byte[]> ), this, pair);
        }

        private synchronized void notifyStop() {
            InvokeDynamicSupport.bootstrap("notifyStop", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyStop(), this);
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            return (int)InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$registerListener(android.media.MediaTimeProvider$OnMediaTimeListener ), this, onMediaTimeListener);
        }

        @Override
        public void notifyAt(long l, MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            InvokeDynamicSupport.bootstrap("notifyAt", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyAt(long android.media.MediaTimeProvider$OnMediaTimeListener ), this, l, onMediaTimeListener);
        }

        @Override
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            InvokeDynamicSupport.bootstrap("scheduleUpdate", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$scheduleUpdate(android.media.MediaTimeProvider$OnMediaTimeListener ), this, onMediaTimeListener);
        }

        @Override
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            InvokeDynamicSupport.bootstrap("cancelNotifications", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$cancelNotifications(android.media.MediaTimeProvider$OnMediaTimeListener ), this, onMediaTimeListener);
        }

        private synchronized void notifyTimedEvent(boolean bl) {
            InvokeDynamicSupport.bootstrap("notifyTimedEvent", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$notifyTimedEvent(boolean ), this, bl);
        }

        @Override
        public long getCurrentTimeUs(boolean bl, boolean bl2) throws IllegalStateException {
            return (long)InvokeDynamicSupport.bootstrap("getCurrentTimeUs", $$robo$$android_media_MediaPlayer2Impl_TimeProvider$getCurrentTimeUs(boolean boolean ), this, bl, bl2);
        }

        public /* synthetic */ TimeProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class EventHandler
        extends Handler
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TimeProvider this$0;

            private void $$robo$$android_media_MediaPlayer2Impl_TimeProvider_EventHandler$__constructor__(TimeProvider timeProvider, Looper looper) {
                this.this$0 = timeProvider;
            }

            private final void $$robo$$android_media_MediaPlayer2Impl_TimeProvider_EventHandler$handleMessage(Message msg) {
                if (msg.what == 1) {
                    switch (msg.arg1) {
                        case 0: {
                            this.this$0.notifyTimedEvent(true);
                            break;
                        }
                        case 2: {
                            this.this$0.notifyStop();
                            break;
                        }
                        case 3: {
                            this.this$0.notifySeek();
                            break;
                        }
                        case 4: {
                            this.this$0.notifyTrackData((Pair)msg.obj);
                        }
                    }
                }
            }

            private void __constructor__(TimeProvider timeProvider, Looper looper) {
                this.$$robo$$android_media_MediaPlayer2Impl_TimeProvider_EventHandler$__constructor__(timeProvider, looper);
            }

            public EventHandler(TimeProvider timeProvider, Looper looper) {
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_TimeProvider_EventHandler$__constructor__(android.media.MediaPlayer2Impl$TimeProvider android.os.Looper ), this, timeProvider, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaPlayer2Impl_TimeProvider_EventHandler$handleMessage(android.os.Message ), this, message);
            }

            public /* synthetic */ EventHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class ProvisioningThread
    extends Thread
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int TIMEOUT_MS = 60000;
        private UUID uuid;
        private String urlStr;
        private Object drmLock;
        private MediaPlayer2Impl mediaPlayer;
        private int status;
        private boolean finished;
        /* synthetic */ MediaPlayer2Impl this$0;

        private void $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$__constructor__(MediaPlayer2Impl mediaPlayer2Impl) {
            this.this$0 = mediaPlayer2Impl;
        }

        private final int $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$status() {
            return this.status;
        }

        private final ProvisioningThread $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$initialize(MediaDrm.ProvisionRequest request, UUID uuid, MediaPlayer2Impl mediaPlayer) {
            this.drmLock = mediaPlayer.mDrmLock;
            this.mediaPlayer = mediaPlayer;
            this.urlStr = request.getDefaultUrl() + "&signedRequest=" + new String(request.getData());
            this.uuid = uuid;
            this.status = 3;
            Log.v("MediaPlayer2Impl", "HandleProvisioninig: Thread is initialised url: " + this.urlStr);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$run() {
            byte[] response = null;
            boolean provisioningSucceeded = false;
            try {
                URL url = new URL(this.urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(false);
                    connection.setDoInput(true);
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(60000);
                    connection.connect();
                    response = Streams.readFully(connection.getInputStream());
                    Log.v("MediaPlayer2Impl", "HandleProvisioninig: Thread run: response " + response.length + " " + response);
                }
                catch (Exception e) {
                    this.status = 1;
                    Log.w("MediaPlayer2Impl", "HandleProvisioninig: Thread run: connect " + e + " url: " + url);
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                this.status = 1;
                Log.w("MediaPlayer2Impl", "HandleProvisioninig: Thread run: openConnection " + e);
            }
            if (response != null) {
                try {
                    this.this$0.mDrmObj.provideProvisionResponse(response);
                    Log.v("MediaPlayer2Impl", "HandleProvisioninig: Thread run: provideProvisionResponse SUCCEEDED!");
                    provisioningSucceeded = true;
                }
                catch (Exception e) {
                    this.status = 2;
                    Log.w("MediaPlayer2Impl", "HandleProvisioninig: Thread run: provideProvisionResponse " + e);
                }
            }
            boolean succeeded = false;
            boolean hasCallback = false;
            Object object = this.this$0.mDrmEventCbLock;
            synchronized (object) {
                hasCallback = !this.this$0.mDrmEventCallbackRecords.isEmpty();
            }
            if (hasCallback) {
                object = this.drmLock;
                synchronized (object) {
                    if (provisioningSucceeded) {
                        succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                        this.status = succeeded ? 0 : 3;
                    }
                    this.mediaPlayer.mDrmProvisioningInProgress = false;
                    this.mediaPlayer.mPrepareDrmInProgress = false;
                    if (!succeeded) {
                        this.this$0.cleanDrmObj();
                    }
                }
                object = this.this$0.mDrmEventCbLock;
                synchronized (object) {
                    for (Pair cb : this.this$0.mDrmEventCallbackRecords) {
                        ((Executor)cb.first).execute(() -> ((MediaPlayer2.DrmEventCallback)cb.second).onDrmPrepared(this.mediaPlayer, this.this$0.mCurrentDSD, this.status));
                    }
                }
            }
            if (provisioningSucceeded) {
                succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                this.status = succeeded ? 0 : 3;
            }
            this.mediaPlayer.mDrmProvisioningInProgress = false;
            this.mediaPlayer.mPrepareDrmInProgress = false;
            if (!succeeded) {
                this.this$0.cleanDrmObj();
            }
            this.finished = true;
        }

        private /* synthetic */ void $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$__constructor__(MediaPlayer2Impl x0, 1 x1) {
        }

        private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl) {
            this.$$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$__constructor__(mediaPlayer2Impl);
        }

        public ProvisioningThread(MediaPlayer2Impl mediaPlayer2Impl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$__constructor__(android.media.MediaPlayer2Impl ), this, mediaPlayer2Impl);
        }

        public int status() {
            return (int)InvokeDynamicSupport.bootstrap("status", $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$status(), this);
        }

        public ProvisioningThread initialize(MediaDrm.ProvisionRequest provisionRequest, UUID uUID, MediaPlayer2Impl mediaPlayer2Impl) {
            return InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$initialize(android.media.MediaDrm$ProvisionRequest java.util.UUID android.media.MediaPlayer2Impl ), this, provisionRequest, uUID, mediaPlayer2Impl);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$run(), this);
        }

        private /* synthetic */ void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, 1 var2_2) {
            this.$$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$__constructor__(mediaPlayer2Impl, var2_2);
        }

        public /* synthetic */ ProvisioningThread(MediaPlayer2Impl mediaPlayer2Impl, 1 var2_2) {
            this(mediaPlayer2Impl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_ProvisioningThread$__constructor__(android.media.MediaPlayer2Impl android.media.MediaPlayer2Impl$1 ), this, mediaPlayer2Impl, var2_2);
        }

        public /* synthetic */ ProvisioningThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisioningThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StreamEventCallback
    extends AudioTrack.StreamEventCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public long mJAudioTrackPtr;
        public long mNativeCallbackPtr;
        public long mUserDataPtr;

        private void $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$__constructor__(long jAudioTrackPtr, long nativeCallbackPtr, long userDataPtr) {
            this.mJAudioTrackPtr = jAudioTrackPtr;
            this.mNativeCallbackPtr = nativeCallbackPtr;
            this.mUserDataPtr = userDataPtr;
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$onTearDown(AudioTrack track) {
            MediaPlayer2Impl.native_stream_event_onTearDown(this.mNativeCallbackPtr, this.mUserDataPtr);
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$onStreamPresentationEnd(AudioTrack track) {
            MediaPlayer2Impl.native_stream_event_onStreamPresentationEnd(this.mNativeCallbackPtr, this.mUserDataPtr);
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$onStreamDataRequest(AudioTrack track) {
            MediaPlayer2Impl.native_stream_event_onStreamDataRequest(this.mJAudioTrackPtr, this.mNativeCallbackPtr, this.mUserDataPtr);
        }

        private void __constructor__(long l, long l2, long l3) {
            this.$$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$__constructor__(l, l2, l3);
        }

        public StreamEventCallback(long l, long l2, long l3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$__constructor__(long long long ), this, l, l2, l3);
        }

        @Override
        public void onTearDown(AudioTrack audioTrack) {
            InvokeDynamicSupport.bootstrap("onTearDown", $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$onTearDown(android.media.AudioTrack ), this, audioTrack);
        }

        @Override
        public void onStreamPresentationEnd(AudioTrack audioTrack) {
            InvokeDynamicSupport.bootstrap("onStreamPresentationEnd", $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$onStreamPresentationEnd(android.media.AudioTrack ), this, audioTrack);
        }

        @Override
        public void onStreamDataRequest(AudioTrack audioTrack) {
            InvokeDynamicSupport.bootstrap("onStreamDataRequest", $$robo$$android_media_MediaPlayer2Impl_StreamEventCallback$onStreamDataRequest(android.media.AudioTrack ), this, audioTrack);
        }

        public /* synthetic */ StreamEventCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamEventCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProvisioningServerErrorExceptionImpl
    extends MediaPlayer2.ProvisioningServerErrorException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaPlayer2Impl_ProvisioningServerErrorExceptionImpl$__constructor__(String detailMessage) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_MediaPlayer2Impl_ProvisioningServerErrorExceptionImpl$__constructor__(string2);
        }

        public ProvisioningServerErrorExceptionImpl(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_ProvisioningServerErrorExceptionImpl$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ ProvisioningServerErrorExceptionImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisioningServerErrorExceptionImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProvisioningNetworkErrorExceptionImpl
    extends MediaPlayer2.ProvisioningNetworkErrorException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaPlayer2Impl_ProvisioningNetworkErrorExceptionImpl$__constructor__(String detailMessage) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_MediaPlayer2Impl_ProvisioningNetworkErrorExceptionImpl$__constructor__(string2);
        }

        public ProvisioningNetworkErrorExceptionImpl(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_ProvisioningNetworkErrorExceptionImpl$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ ProvisioningNetworkErrorExceptionImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisioningNetworkErrorExceptionImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class NoDrmSchemeExceptionImpl
    extends MediaPlayer2.NoDrmSchemeException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaPlayer2Impl_NoDrmSchemeExceptionImpl$__constructor__(String detailMessage) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_MediaPlayer2Impl_NoDrmSchemeExceptionImpl$__constructor__(string2);
        }

        public NoDrmSchemeExceptionImpl(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_NoDrmSchemeExceptionImpl$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ NoDrmSchemeExceptionImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoDrmSchemeExceptionImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DrmInfoImpl
    extends MediaPlayer2.DrmInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Map<UUID, byte[]> mapPssh;
        private UUID[] supportedSchemes;

        private final Map<UUID, byte[]> $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$getPssh() {
            return this.mapPssh;
        }

        private final List<UUID> $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$getSupportedSchemes() {
            return Arrays.asList(this.supportedSchemes);
        }

        private void $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(Map<UUID, byte[]> Pssh, UUID[] SupportedSchemes) {
            this.mapPssh = Pssh;
            this.supportedSchemes = SupportedSchemes;
        }

        private void $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(Parcel parcel) {
            Log.v("MediaPlayer2Impl", "DrmInfoImpl(" + parcel + ") size " + parcel.dataSize());
            int psshsize = parcel.readInt();
            byte[] pssh = new byte[psshsize];
            parcel.readByteArray(pssh);
            Log.v("MediaPlayer2Impl", "DrmInfoImpl() PSSH: " + this.arrToHex(pssh));
            this.mapPssh = this.parsePSSH(pssh, psshsize);
            Log.v("MediaPlayer2Impl", "DrmInfoImpl() PSSH: " + this.mapPssh);
            int supportedDRMsCount = parcel.readInt();
            this.supportedSchemes = new UUID[supportedDRMsCount];
            for (int i = 0; i < supportedDRMsCount; ++i) {
                byte[] uuid = new byte[16];
                parcel.readByteArray(uuid);
                this.supportedSchemes[i] = this.bytesToUUID(uuid);
                Log.v("MediaPlayer2Impl", "DrmInfoImpl() supportedScheme[" + i + "]: " + this.supportedSchemes[i]);
            }
            Log.v("MediaPlayer2Impl", "DrmInfoImpl() Parcel psshsize: " + psshsize + " supportedDRMsCount: " + supportedDRMsCount);
        }

        private final DrmInfoImpl $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$makeCopy() {
            return new DrmInfoImpl(this.mapPssh, this.supportedSchemes);
        }

        private final String $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$arrToHex(byte[] bytes) {
            String out = "0x";
            for (int i = 0; i < bytes.length; ++i) {
                out = out + String.format("%02x", bytes[i]);
            }
            return out;
        }

        private final UUID $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$bytesToUUID(byte[] uuid) {
            long msb = 0L;
            long lsb = 0L;
            for (int i = 0; i < 8; ++i) {
                msb |= ((long)uuid[i] & 0xFFL) << 8 * (7 - i);
                lsb |= ((long)uuid[i + 8] & 0xFFL) << 8 * (7 - i);
            }
            return new UUID(msb, lsb);
        }

        private final Map<UUID, byte[]> $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$parsePSSH(byte[] pssh, int psshsize) {
            HashMap<UUID, byte[]> result = new HashMap<UUID, byte[]>();
            int UUID_SIZE = 16;
            int DATALEN_SIZE = 4;
            int len = psshsize;
            int numentries = 0;
            int i = 0;
            while (len > 0) {
                if (len < 16) {
                    Log.w("MediaPlayer2Impl", String.format("parsePSSH: len is too short to parse UUID: (%d < 16) pssh: %d", len, psshsize));
                    return null;
                }
                byte[] subset = Arrays.copyOfRange(pssh, i, i + 16);
                UUID uuid = this.bytesToUUID(subset);
                i += 16;
                if ((len -= 16) < 4) {
                    Log.w("MediaPlayer2Impl", String.format("parsePSSH: len is too short to parse datalen: (%d < 4) pssh: %d", len, psshsize));
                    return null;
                }
                subset = Arrays.copyOfRange(pssh, i, i + 4);
                int datalen = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (subset[3] & 0xFF) << 24 | (subset[2] & 0xFF) << 16 | (subset[1] & 0xFF) << 8 | subset[0] & 0xFF : (subset[0] & 0xFF) << 24 | (subset[1] & 0xFF) << 16 | (subset[2] & 0xFF) << 8 | subset[3] & 0xFF;
                i += 4;
                if ((len -= 4) < datalen) {
                    Log.w("MediaPlayer2Impl", String.format("parsePSSH: len is too short to parse data: (%d < %d) pssh: %d", len, datalen, psshsize));
                    return null;
                }
                byte[] data = Arrays.copyOfRange(pssh, i, i + datalen);
                i += datalen;
                len -= datalen;
                Log.v("MediaPlayer2Impl", String.format("parsePSSH[%d]: <%s, %s> pssh: %d", numentries, uuid, this.arrToHex(data), psshsize));
                ++numentries;
                result.put(uuid, data);
            }
            return result;
        }

        private /* synthetic */ void $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(Parcel x0, 1 x1) {
        }

        @Override
        public Map<UUID, byte[]> getPssh() {
            return InvokeDynamicSupport.bootstrap("getPssh", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$getPssh(), this);
        }

        @Override
        public List<UUID> getSupportedSchemes() {
            return InvokeDynamicSupport.bootstrap("getSupportedSchemes", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$getSupportedSchemes(), this);
        }

        private void __constructor__(Map<UUID, byte[]> map, UUID[] uUIDArray) {
            this.$$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(map, uUIDArray);
        }

        public DrmInfoImpl(Map<UUID, byte[]> map, UUID[] uUIDArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(java.util.Map<java.util.UUID, byte[]> java.util.UUID[] ), this, map, uUIDArray);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(parcel);
        }

        public DrmInfoImpl(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(android.os.Parcel ), this, parcel);
        }

        private DrmInfoImpl makeCopy() {
            return InvokeDynamicSupport.bootstrap("makeCopy", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$makeCopy(), this);
        }

        private String arrToHex(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("arrToHex", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$arrToHex(byte[] ), this, byArray);
        }

        private UUID bytesToUUID(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("bytesToUUID", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$bytesToUUID(byte[] ), this, byArray);
        }

        private Map<UUID, byte[]> parsePSSH(byte[] byArray, int n) {
            return InvokeDynamicSupport.bootstrap("parsePSSH", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$parsePSSH(byte[] int ), this, byArray, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ DrmInfoImpl(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_DrmInfoImpl$__constructor__(android.os.Parcel android.media.MediaPlayer2Impl$1 ), this, parcel, var2_2);
        }

        public /* synthetic */ DrmInfoImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrmInfoImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private MediaPlayer2Impl mMediaPlayer;
        /* synthetic */ MediaPlayer2Impl this$0;

        private void $$robo$$android_media_MediaPlayer2Impl_EventHandler$__constructor__(MediaPlayer2Impl mediaPlayer2Impl, MediaPlayer2Impl mp, Looper looper) {
            this.this$0 = mediaPlayer2Impl;
            this.mMediaPlayer = mp;
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_EventHandler$handleMessage(Message msg) {
            this.handleMessage(msg, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer2Impl_EventHandler$handleMessage(Message msg, long srcId) {
            if (this.mMediaPlayer.mNativeContext == 0L) {
                Log.w("MediaPlayer2Impl", "mediaplayer2 went away with unhandled events");
                return;
            }
            int what = msg.arg1;
            int extra = msg.arg2;
            switch (msg.what) {
                case 1: {
                    DataSourceDesc dsd;
                    Object msg2;
                    try {
                        this.this$0.scanInternalSubtitleTracks();
                    }
                    catch (RuntimeException e) {
                        msg2 = this.obtainMessage(100, 1, -1010, null);
                        this.sendMessage((Message)msg2);
                    }
                    msg2 = this.this$0.mSrcLock;
                    synchronized (msg2) {
                        Log.i("MediaPlayer2Impl", "MEDIA_PREPARED: srcId=" + srcId + ", currentSrcId=" + this.this$0.mCurrentSrcId + ", nextSrcId=" + this.this$0.mNextSrcId);
                        if (srcId == this.this$0.mCurrentSrcId) {
                            dsd = this.this$0.mCurrentDSD;
                            this.this$0.prepareNextDataSource_l();
                        } else if (this.this$0.mNextDSDs != null && !this.this$0.mNextDSDs.isEmpty() && srcId == this.this$0.mNextSrcId) {
                            dsd = (DataSourceDesc)this.this$0.mNextDSDs.get(0);
                            this.this$0.mNextSourceState = 2;
                            if (this.this$0.mNextSourcePlayPending) {
                                this.this$0.playNextDataSource_l();
                            }
                        } else {
                            dsd = null;
                        }
                    }
                    if (dsd != null) {
                        msg2 = this.this$0.mEventCbLock;
                        synchronized (msg2) {
                            for (Pair cb : this.this$0.mEventCallbackRecords) {
                                ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onInfo(this.mMediaPlayer, dsd, 100, 0));
                            }
                        }
                    }
                    msg2 = this.this$0.mTaskLock;
                    synchronized (msg2) {
                        if (this.this$0.mCurrentTask != null && this.this$0.mCurrentTask.mMediaCallType == 6 && this.this$0.mCurrentTask.mDSD == dsd && this.this$0.mCurrentTask.mNeedToWaitForEventToComplete) {
                            this.this$0.mCurrentTask.sendCompleteNotification(0);
                            this.this$0.mCurrentTask = null;
                            this.this$0.processPendingTask_l();
                        }
                    }
                    return;
                }
                case 210: {
                    if (msg.obj == null) {
                        Log.w("MediaPlayer2Impl", "MEDIA_DRM_INFO msg.obj=NULL");
                    } else if (msg.obj instanceof Parcel) {
                        DrmInfoImpl drmInfo;
                        Object msg2 = this.this$0.mDrmLock;
                        synchronized (msg2) {
                            drmInfo = this.this$0.mDrmInfoImpl != null ? this.this$0.mDrmInfoImpl.makeCopy() : null;
                        }
                        if (drmInfo != null) {
                            msg2 = this.this$0.mEventCbLock;
                            synchronized (msg2) {
                                for (Pair cb : this.this$0.mDrmEventCallbackRecords) {
                                    ((Executor)cb.first).execute(() -> ((MediaPlayer2.DrmEventCallback)cb.second).onDrmInfo(this.mMediaPlayer, this.this$0.mCurrentDSD, drmInfo));
                                }
                            }
                        }
                    } else {
                        Log.w("MediaPlayer2Impl", "MEDIA_DRM_INFO msg.obj of unexpected type " + msg.obj);
                    }
                    return;
                }
                case 2: {
                    DataSourceDesc dsd = this.this$0.mCurrentDSD;
                    Object msg2 = this.this$0.mSrcLock;
                    synchronized (msg2) {
                        if (srcId == this.this$0.mCurrentSrcId) {
                            Log.i("MediaPlayer2Impl", "MEDIA_PLAYBACK_COMPLETE: srcId=" + srcId + ", currentSrcId=" + this.this$0.mCurrentSrcId + ", nextSrcId=" + this.this$0.mNextSrcId);
                            this.this$0.playNextDataSource_l();
                        }
                    }
                    msg2 = this.this$0.mEventCbLock;
                    synchronized (msg2) {
                        for (Pair cb : this.this$0.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onInfo(this.mMediaPlayer, dsd, 5, 0));
                        }
                    }
                    this.this$0.stayAwake(false);
                    return;
                }
                case 8: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onStopped();
                    break;
                }
                case 6: 
                case 7: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onPaused(msg.what == 7);
                    break;
                }
                case 3: {
                    int percent = msg.arg1;
                    Object msg2 = this.this$0.mEventCbLock;
                    synchronized (msg2) {
                        if (srcId == this.this$0.mCurrentSrcId) {
                            this.this$0.mBufferedPercentageCurrent.set(percent);
                            for (Pair cb : this.this$0.mEventCallbackRecords) {
                                ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onInfo(this.mMediaPlayer, this.this$0.mCurrentDSD, 704, percent));
                            }
                        } else if (srcId == this.this$0.mNextSrcId && !this.this$0.mNextDSDs.isEmpty()) {
                            this.this$0.mBufferedPercentageNext.set(percent);
                            DataSourceDesc nextDSD = (DataSourceDesc)this.this$0.mNextDSDs.get(0);
                            for (Pair cb : this.this$0.mEventCallbackRecords) {
                                ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onInfo(this.mMediaPlayer, nextDSD, 704, percent));
                            }
                        }
                    }
                    return;
                }
                case 4: {
                    Object percent = this.this$0.mTaskLock;
                    synchronized (percent) {
                        if (this.this$0.mCurrentTask != null && this.this$0.mCurrentTask.mMediaCallType == 14 && this.this$0.mCurrentTask.mNeedToWaitForEventToComplete) {
                            this.this$0.mCurrentTask.sendCompleteNotification(0);
                            this.this$0.mCurrentTask = null;
                            this.this$0.processPendingTask_l();
                        }
                    }
                }
                case 9: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider != null) {
                        timeProvider.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    int width = msg.arg1;
                    int height = msg.arg2;
                    Object nextDSD = this.this$0.mEventCbLock;
                    synchronized (nextDSD) {
                        for (Pair cb : this.this$0.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onVideoSizeChanged(this.mMediaPlayer, this.this$0.mCurrentDSD, width, height));
                        }
                    }
                    return;
                }
                case 100: {
                    Log.e("MediaPlayer2Impl", "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    Object width = this.this$0.mEventCbLock;
                    synchronized (width) {
                        for (Pair cb : this.this$0.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onError(this.mMediaPlayer, this.this$0.mCurrentDSD, what, extra));
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onInfo(this.mMediaPlayer, this.this$0.mCurrentDSD, 5, 0));
                        }
                    }
                    this.this$0.stayAwake(false);
                    return;
                }
                case 200: {
                    Object timeProvider;
                    switch (msg.arg1) {
                        case 2: {
                            if (srcId != this.this$0.mCurrentSrcId) break;
                            this.this$0.prepareNextDataSource_l();
                            break;
                        }
                        case 700: {
                            Log.i("MediaPlayer2Impl", "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                            break;
                        }
                        case 802: {
                            try {
                                this.this$0.scanInternalSubtitleTracks();
                            }
                            catch (RuntimeException e) {
                                Message msg2 = this.obtainMessage(100, 1, -1010, null);
                                this.sendMessage(msg2);
                            }
                        }
                        case 803: {
                            msg.arg1 = 802;
                            if (this.this$0.mSubtitleController == null) break;
                            this.this$0.mSubtitleController.selectDefaultTrack();
                            break;
                        }
                        case 701: 
                        case 702: {
                            timeProvider = this.this$0.mTimeProvider;
                            if (timeProvider == null) break;
                            ((TimeProvider)timeProvider).onBuffering(msg.arg1 == 701);
                        }
                    }
                    timeProvider = this.this$0.mEventCbLock;
                    synchronized (timeProvider) {
                        for (Pair cb : this.this$0.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onInfo(this.mMediaPlayer, this.this$0.mCurrentDSD, what, extra));
                        }
                    }
                    return;
                }
                case 98: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider != null) {
                        timeProvider.onNotifyTime();
                    }
                    return;
                }
                case 99: {
                    TimedText text;
                    Object parcel;
                    if (msg.obj instanceof Parcel) {
                        parcel = (Parcel)msg.obj;
                        text = new TimedText((Parcel)parcel);
                        ((Parcel)parcel).recycle();
                    } else {
                        text = null;
                    }
                    parcel = this.this$0.mEventCbLock;
                    synchronized (parcel) {
                        for (Pair cb : this.this$0.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onTimedText(this.mMediaPlayer, this.this$0.mCurrentDSD, text));
                        }
                    }
                    return;
                }
                case 201: {
                    MediaPlayer2.OnSubtitleDataListener onSubtitleDataListener = this.this$0.mOnSubtitleDataListener;
                    if (onSubtitleDataListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        SubtitleData data = new SubtitleData(parcel);
                        parcel.recycle();
                        onSubtitleDataListener.onSubtitleData(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 202: {
                    TimedMetaData data;
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        data = TimedMetaData.createTimedMetaDataFromParcel(parcel);
                        parcel.recycle();
                    } else {
                        data = null;
                    }
                    Object object = this.this$0.mEventCbLock;
                    synchronized (object) {
                        for (Pair cb : this.this$0.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.MediaPlayer2EventCallback)cb.second).onTimedMetaDataAvailable(this.mMediaPlayer, this.this$0.mCurrentDSD, data));
                        }
                    }
                    return;
                }
                case 0: {
                    break;
                }
                case 10000: {
                    AudioManager.resetAudioPortGeneration();
                    ArrayMap arrayMap = this.this$0.mRoutingChangeListeners;
                    synchronized (arrayMap) {
                        for (NativeRoutingEventHandlerDelegate delegate : this.this$0.mRoutingChangeListeners.values()) {
                            delegate.notifyClient();
                        }
                    }
                    return;
                }
                default: {
                    Log.e("MediaPlayer2Impl", "Unknown message type " + msg.what);
                    return;
                }
            }
        }

        private void __constructor__(MediaPlayer2Impl mediaPlayer2Impl, MediaPlayer2Impl mediaPlayer2Impl2, Looper looper) {
            this.$$robo$$android_media_MediaPlayer2Impl_EventHandler$__constructor__(mediaPlayer2Impl, mediaPlayer2Impl2, looper);
        }

        public EventHandler(MediaPlayer2Impl mediaPlayer2Impl, MediaPlayer2Impl mediaPlayer2Impl2, Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_EventHandler$__constructor__(android.media.MediaPlayer2Impl android.media.MediaPlayer2Impl android.os.Looper ), this, mediaPlayer2Impl, mediaPlayer2Impl2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaPlayer2Impl_EventHandler$handleMessage(android.os.Message ), this, message);
        }

        public void handleMessage(Message message, long l) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaPlayer2Impl_EventHandler$handleMessage(android.os.Message long ), this, message, l);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TrackInfoImpl
    extends MediaPlayer2.TrackInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mTrackType;
        MediaFormat mFormat;
        static Parcelable.Creator<TrackInfoImpl> CREATOR;

        private final int $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$getTrackType() {
            return this.mTrackType;
        }

        private final String $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        private final MediaFormat $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        private void $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$__constructor__(Parcel in) {
            this.mTrackType = in.readInt();
            String mime = in.readString();
            String language = in.readString();
            this.mFormat = MediaFormat.createSubtitleFormat(mime, language);
            if (this.mTrackType == 4) {
                this.mFormat.setInteger("is-autoselect", in.readInt());
                this.mFormat.setInteger("is-default", in.readInt());
                this.mFormat.setInteger("is-forced-subtitle", in.readInt());
            }
        }

        private void $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$__constructor__(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        private final void $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTrackType);
            dest.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                dest.writeString(this.mFormat.getString("mime"));
                dest.writeInt(this.mFormat.getInteger("is-autoselect"));
                dest.writeInt(this.mFormat.getInteger("is-default"));
                dest.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            }
        }

        private final String $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$toString() {
            StringBuilder out = new StringBuilder(128);
            out.append(this.getClass().getName());
            out.append('{');
            switch (this.mTrackType) {
                case 1: {
                    out.append("VIDEO");
                    break;
                }
                case 2: {
                    out.append("AUDIO");
                    break;
                }
                case 3: {
                    out.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    out.append("SUBTITLE");
                    break;
                }
                default: {
                    out.append("UNKNOWN");
                }
            }
            out.append(", " + this.mFormat.toString());
            out.append("}");
            return out.toString();
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TrackInfoImpl>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$__constructor__() {
                }

                private final TrackInfoImpl $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$createFromParcel(Parcel in) {
                    return new TrackInfoImpl(in);
                }

                private final TrackInfoImpl[] $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$newArray(int size) {
                    return new TrackInfoImpl[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$__constructor__(), this);
                }

                @Override
                public TrackInfoImpl createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public TrackInfoImpl[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        @Override
        public int getTrackType() {
            return (int)InvokeDynamicSupport.bootstrap("getTrackType", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$getTrackType(), this);
        }

        @Override
        public String getLanguage() {
            return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$getLanguage(), this);
        }

        @Override
        public MediaFormat getFormat() {
            return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$getFormat(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$__constructor__(parcel);
        }

        public TrackInfoImpl(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(int n, MediaFormat mediaFormat) {
            this.$$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$__constructor__(n, mediaFormat);
        }

        public TrackInfoImpl(int n, MediaFormat mediaFormat) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$__constructor__(int android.media.MediaFormat ), this, n, mediaFormat);
        }

        void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaPlayer2Impl_TrackInfoImpl$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(TrackInfoImpl.class);
        }

        public /* synthetic */ TrackInfoImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrackInfoImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

