/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaHTTPConnection;
import android.net.NetworkUtils;
import android.os.IBinder;
import android.os.StrictMode;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaHTTPConnection
extends IMediaHTTPConnection.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaHTTPConnection";
    private static boolean VERBOSE = false;
    private static int CONNECT_TIMEOUT_MS = 30000;
    private long mCurrentOffset;
    private URL mURL;
    private Map<String, String> mHeaders;
    private HttpURLConnection mConnection;
    private long mTotalSize;
    private InputStream mInputStream;
    private boolean mAllowCrossDomainRedirect;
    private boolean mAllowCrossProtocolRedirect;
    private static int HTTP_TEMP_REDIRECT = 307;
    private static int MAX_REDIRECTS = 20;
    private long mNativeContext;

    private void $$robo$$android_media_MediaHTTPConnection$__constructor__() {
        this.mCurrentOffset = -1L;
        this.mURL = null;
        this.mHeaders = null;
        this.mConnection = null;
        this.mTotalSize = -1L;
        this.mInputStream = null;
        this.mAllowCrossDomainRedirect = true;
        this.mAllowCrossProtocolRedirect = true;
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler == null) {
            Log.w("MediaHTTPConnection", "MediaHTTPConnection: Unexpected. No CookieHandler found.");
        }
        this.native_setup();
    }

    private final IBinder $$robo$$android_media_MediaHTTPConnection$connect(String uri, String headers) {
        try {
            this.disconnect();
            this.mAllowCrossDomainRedirect = true;
            this.mURL = new URL(uri);
            this.mHeaders = this.convertHeaderStringToMap(headers);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.native_getIMemory();
    }

    private final boolean $$robo$$android_media_MediaHTTPConnection$parseBoolean(String val) {
        try {
            return Long.parseLong(val) != 0L;
        }
        catch (NumberFormatException e) {
            return "true".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val);
        }
    }

    private final boolean $$robo$$android_media_MediaHTTPConnection$filterOutInternalHeaders(String key, String val) {
        if (!"android-allow-cross-domain-redirect".equalsIgnoreCase(key)) {
            return false;
        }
        this.mAllowCrossProtocolRedirect = this.mAllowCrossDomainRedirect = this.parseBoolean(val);
        return true;
    }

    private final Map<String, String> $$robo$$android_media_MediaHTTPConnection$convertHeaderStringToMap(String headers) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs = headers.split("\r\n")) {
            String val;
            String key;
            int colonPos = pair.indexOf(":");
            if (colonPos < 0 || this.filterOutInternalHeaders(key = pair.substring(0, colonPos), val = pair.substring(colonPos + 1))) continue;
            map.put(key, val);
        }
        return map;
    }

    private final void $$robo$$android_media_MediaHTTPConnection$disconnect() {
        this.teardownConnection();
        this.mHeaders = null;
        this.mURL = null;
    }

    private final void $$robo$$android_media_MediaHTTPConnection$teardownConnection() {
        if (this.mConnection != null) {
            if (this.mInputStream != null) {
                try {
                    this.mInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mInputStream = null;
            }
            this.mConnection.disconnect();
            this.mConnection = null;
            this.mCurrentOffset = -1L;
        }
    }

    private static final boolean $$robo$$android_media_MediaHTTPConnection$isLocalHost(URL url) {
        if (url == null) {
            return false;
        }
        String host = url.getHost();
        if (host == null) {
            return false;
        }
        try {
            if (host.equalsIgnoreCase("localhost")) {
                return true;
            }
            if (NetworkUtils.numericToInetAddress(host).isLoopbackAddress()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private final void $$robo$$android_media_MediaHTTPConnection$seekTo(long offset) throws IOException {
        this.teardownConnection();
        try {
            int response;
            int redirectCount = 0;
            URL url = this.mURL;
            boolean noProxy = MediaHTTPConnection.isLocalHost(url);
            while (true) {
                this.mConnection = noProxy ? (HttpURLConnection)url.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)url.openConnection();
                this.mConnection.setConnectTimeout(30000);
                this.mConnection.setInstanceFollowRedirects(this.mAllowCrossDomainRedirect);
                if (this.mHeaders != null) {
                    for (Map.Entry<String, String> entry : this.mHeaders.entrySet()) {
                        this.mConnection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if (offset > 0L) {
                    this.mConnection.setRequestProperty("Range", "bytes=" + offset + "-");
                }
                if ((response = this.mConnection.getResponseCode()) != 300 && response != 301 && response != 302 && response != 303 && response != 307) break;
                if (++redirectCount > 20) {
                    throw new NoRouteToHostException("Too many redirects: " + redirectCount);
                }
                String method = this.mConnection.getRequestMethod();
                if (response == 307 && !method.equals("GET") && !method.equals("HEAD")) {
                    throw new NoRouteToHostException("Invalid redirect");
                }
                String location = this.mConnection.getHeaderField("Location");
                if (location == null) {
                    throw new NoRouteToHostException("Invalid redirect");
                }
                url = new URL(this.mURL, location);
                if (!url.getProtocol().equals("https") && !url.getProtocol().equals("http")) {
                    throw new NoRouteToHostException("Unsupported protocol redirect");
                }
                boolean sameProtocol = this.mURL.getProtocol().equals(url.getProtocol());
                if (!this.mAllowCrossProtocolRedirect && !sameProtocol) {
                    throw new NoRouteToHostException("Cross-protocol redirects are disallowed");
                }
                boolean sameHost = this.mURL.getHost().equals(url.getHost());
                if (!this.mAllowCrossDomainRedirect && !sameHost) {
                    throw new NoRouteToHostException("Cross-domain redirects are disallowed");
                }
                if (response == 307) continue;
                this.mURL = url;
            }
            if (this.mAllowCrossDomainRedirect) {
                this.mURL = this.mConnection.getURL();
            }
            if (response == 206) {
                int lastSlashPos;
                String contentRange = this.mConnection.getHeaderField("Content-Range");
                this.mTotalSize = -1L;
                if (contentRange != null && (lastSlashPos = contentRange.lastIndexOf(47)) >= 0) {
                    String total = contentRange.substring(lastSlashPos + 1);
                    try {
                        this.mTotalSize = Long.parseLong(total);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                if (response != 200) {
                    throw new IOException();
                }
                this.mTotalSize = this.mConnection.getContentLength();
            }
            if (offset > 0L && response != 206) {
                throw new ProtocolException();
            }
            this.mInputStream = new BufferedInputStream(this.mConnection.getInputStream());
            this.mCurrentOffset = offset;
        }
        catch (IOException e) {
            this.mTotalSize = -1L;
            this.teardownConnection();
            this.mCurrentOffset = -1L;
            throw e;
        }
    }

    private final int $$robo$$android_media_MediaHTTPConnection$readAt(long offset, int size) {
        return this.native_readAt(offset, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaHTTPConnection$readAt(long offset, byte[] data, int size) {
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy(policy);
        try {
            MediaHTTPConnection mediaHTTPConnection = this;
            synchronized (mediaHTTPConnection) {
                if (offset != this.mCurrentOffset) {
                    this.seekTo(offset);
                }
            }
            int n = this.mInputStream.read(data, 0, size);
            if (n == -1) {
                n = 0;
            }
            this.mCurrentOffset += (long)n;
            return n;
        }
        catch (ProtocolException e) {
            Log.w("MediaHTTPConnection", "readAt " + offset + " / " + size + " => " + e);
            return -1010;
        }
        catch (NoRouteToHostException e) {
            Log.w("MediaHTTPConnection", "readAt " + offset + " / " + size + " => " + e);
            return -1010;
        }
        catch (UnknownServiceException e) {
            Log.w("MediaHTTPConnection", "readAt " + offset + " / " + size + " => " + e);
            return -1010;
        }
        catch (IOException e) {
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private final synchronized long $$robo$$android_media_MediaHTTPConnection$getSize() {
        if (this.mConnection == null) {
            try {
                this.seekTo(0L);
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return this.mTotalSize;
    }

    private final synchronized String $$robo$$android_media_MediaHTTPConnection$getMIMEType() {
        if (this.mConnection == null) {
            try {
                this.seekTo(0L);
            }
            catch (IOException e) {
                return "application/octet-stream";
            }
        }
        return this.mConnection.getContentType();
    }

    private final String $$robo$$android_media_MediaHTTPConnection$getUri() {
        return this.mURL.toString();
    }

    private final void $$robo$$android_media_MediaHTTPConnection$finalize() {
        this.native_finalize();
    }

    private static final void $$robo$$android_media_MediaHTTPConnection$native_init() {
    }

    private final void $$robo$$android_media_MediaHTTPConnection$native_setup() {
    }

    private final void $$robo$$android_media_MediaHTTPConnection$native_finalize() {
    }

    private final IBinder $$robo$$android_media_MediaHTTPConnection$native_getIMemory() {
        return null;
    }

    private final int $$robo$$android_media_MediaHTTPConnection$native_readAt(long l, int n) {
        return 0;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaHTTPConnection.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaHTTPConnection$__constructor__();
    }

    public MediaHTTPConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaHTTPConnection$__constructor__(), this);
    }

    @Override
    public IBinder connect(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("connect", $$robo$$android_media_MediaHTTPConnection$connect(java.lang.String java.lang.String ), this, string2, string3);
    }

    private boolean parseBoolean(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseBoolean", $$robo$$android_media_MediaHTTPConnection$parseBoolean(java.lang.String ), this, string2);
    }

    private boolean filterOutInternalHeaders(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterOutInternalHeaders", $$robo$$android_media_MediaHTTPConnection$filterOutInternalHeaders(java.lang.String java.lang.String ), this, string2, string3);
    }

    private Map<String, String> convertHeaderStringToMap(String string2) {
        return InvokeDynamicSupport.bootstrap("convertHeaderStringToMap", $$robo$$android_media_MediaHTTPConnection$convertHeaderStringToMap(java.lang.String ), this, string2);
    }

    @Override
    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_media_MediaHTTPConnection$disconnect(), this);
    }

    private void teardownConnection() {
        InvokeDynamicSupport.bootstrap("teardownConnection", $$robo$$android_media_MediaHTTPConnection$teardownConnection(), this);
    }

    private static boolean isLocalHost(URL uRL) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalHost", $$robo$$android_media_MediaHTTPConnection$isLocalHost(java.net.URL ), (URL)uRL);
    }

    private void seekTo(long l) throws IOException {
        InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_MediaHTTPConnection$seekTo(long ), this, l);
    }

    @Override
    public int readAt(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrap("readAt", $$robo$$android_media_MediaHTTPConnection$readAt(long int ), this, l, n);
    }

    private int readAt(long l, byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("readAt", $$robo$$android_media_MediaHTTPConnection$readAt(long byte[] int ), this, l, byArray, n);
    }

    @Override
    public synchronized long getSize() {
        return (long)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_media_MediaHTTPConnection$getSize(), this);
    }

    @Override
    public synchronized String getMIMEType() {
        return InvokeDynamicSupport.bootstrap("getMIMEType", $$robo$$android_media_MediaHTTPConnection$getMIMEType(), this);
    }

    @Override
    public String getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_media_MediaHTTPConnection$getUri(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaHTTPConnection$finalize(), this);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaHTTPConnection$native_init());
    }

    private void native_setup() {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaHTTPConnection$native_setup(), this);
    }

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaHTTPConnection$native_finalize(), this);
    }

    private IBinder native_getIMemory() {
        return InvokeDynamicSupport.bootstrap("native_getIMemory", $$robo$$android_media_MediaHTTPConnection$native_getIMemory(), this);
    }

    private int native_readAt(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_readAt", $$robo$$android_media_MediaHTTPConnection$native_readAt(long int ), this, l, n);
    }

    static {
        RobolectricInternals.classInitializing(MediaHTTPConnection.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaHTTPConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

