/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.cas.V1_0.IDescramblerBase;
import android.media.MediaCas;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.media.MediaCodec;
import android.os.IHwBinder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaDescrambler
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaDescrambler";
    private IDescramblerBase mIDescrambler;
    public static byte SCRAMBLE_CONTROL_UNSCRAMBLED = 0;
    public static byte SCRAMBLE_CONTROL_RESERVED = 1;
    public static byte SCRAMBLE_CONTROL_EVEN_KEY = 2;
    public static byte SCRAMBLE_CONTROL_ODD_KEY = 3;
    public static byte SCRAMBLE_FLAG_PES_HEADER = 1;
    private long mNativeContext;

    private final void $$robo$$android_media_MediaDescrambler$validateInternalStates() {
        if (this.mIDescrambler == null) {
            throw new IllegalStateException();
        }
    }

    private final void $$robo$$android_media_MediaDescrambler$cleanupAndRethrowIllegalState() {
        this.mIDescrambler = null;
        throw new IllegalStateException();
    }

    private void $$robo$$android_media_MediaDescrambler$__constructor__(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block5: {
            try {
                this.mIDescrambler = MediaCas.getService().createDescrambler(CA_system_id);
            }
            catch (Exception e) {
                Log.e("MediaDescrambler", "Failed to create descrambler: " + e);
                this.mIDescrambler = null;
            }
            finally {
                if (this.mIDescrambler != null) break block5;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
        this.native_setup(this.mIDescrambler.asBinder());
    }

    private final IHwBinder $$robo$$android_media_MediaDescrambler$getBinder() {
        this.validateInternalStates();
        return this.mIDescrambler.asBinder();
    }

    private final boolean $$robo$$android_media_MediaDescrambler$requiresSecureDecoderComponent(String mime) {
        this.validateInternalStates();
        try {
            return this.mIDescrambler.requiresSecureDecoderComponent(mime);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            return true;
        }
    }

    private final void $$robo$$android_media_MediaDescrambler$setMediaCasSession(MediaCas.Session session) {
        this.validateInternalStates();
        try {
            MediaCasStateException.throwExceptionIfNeeded(this.mIDescrambler.setMediaCasSession(session.mSessionId));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final int $$robo$$android_media_MediaDescrambler$descramble(ByteBuffer srcBuf, ByteBuffer dstBuf, MediaCodec.CryptoInfo cryptoInfo) {
        this.validateInternalStates();
        if (cryptoInfo.numSubSamples <= 0) {
            throw new IllegalArgumentException("Invalid CryptoInfo: invalid numSubSamples=" + cryptoInfo.numSubSamples);
        }
        if (cryptoInfo.numBytesOfClearData == null && cryptoInfo.numBytesOfEncryptedData == null) {
            throw new IllegalArgumentException("Invalid CryptoInfo: clearData and encryptedData size arrays are both null!");
        }
        if (cryptoInfo.numBytesOfClearData != null && cryptoInfo.numBytesOfClearData.length < cryptoInfo.numSubSamples) {
            throw new IllegalArgumentException("Invalid CryptoInfo: numBytesOfClearData is too small!");
        }
        if (cryptoInfo.numBytesOfEncryptedData != null && cryptoInfo.numBytesOfEncryptedData.length < cryptoInfo.numSubSamples) {
            throw new IllegalArgumentException("Invalid CryptoInfo: numBytesOfEncryptedData is too small!");
        }
        if (cryptoInfo.key == null || cryptoInfo.key.length != 16) {
            throw new IllegalArgumentException("Invalid CryptoInfo: key array is invalid!");
        }
        try {
            return this.native_descramble(cryptoInfo.key[0], cryptoInfo.key[1], cryptoInfo.numSubSamples, cryptoInfo.numBytesOfClearData, cryptoInfo.numBytesOfEncryptedData, srcBuf, srcBuf.position(), srcBuf.limit(), dstBuf, dstBuf.position(), dstBuf.limit());
        }
        catch (ServiceSpecificException e) {
            MediaCasStateException.throwExceptionIfNeeded(e.errorCode, e.getMessage());
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
        return -1;
    }

    private final void $$robo$$android_media_MediaDescrambler$close() {
        if (this.mIDescrambler != null) {
            try {
                this.mIDescrambler.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mIDescrambler = null;
            }
        }
        this.native_release();
    }

    private final void $$robo$$android_media_MediaDescrambler$finalize() {
        this.close();
    }

    private static final void $$robo$$android_media_MediaDescrambler$native_init() {
    }

    private final void $$robo$$android_media_MediaDescrambler$native_setup(IHwBinder iHwBinder) {
    }

    private final void $$robo$$android_media_MediaDescrambler$native_release() {
    }

    private final int $$robo$$android_media_MediaDescrambler$native_descramble(byte by, byte by2, int n, int[] nArray, int[] nArray2, ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) throws RemoteException {
        return 0;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaDescrambler.native_init();
    }

    private void validateInternalStates() {
        InvokeDynamicSupport.bootstrap("validateInternalStates", $$robo$$android_media_MediaDescrambler$validateInternalStates(), this);
    }

    private void cleanupAndRethrowIllegalState() {
        InvokeDynamicSupport.bootstrap("cleanupAndRethrowIllegalState", $$robo$$android_media_MediaDescrambler$cleanupAndRethrowIllegalState(), this);
    }

    private void __constructor__(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$$android_media_MediaDescrambler$__constructor__(n);
    }

    public MediaDescrambler(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDescrambler$__constructor__(int ), this, n);
    }

    IHwBinder getBinder() {
        return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_MediaDescrambler$getBinder(), this);
    }

    public boolean requiresSecureDecoderComponent(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresSecureDecoderComponent", $$robo$$android_media_MediaDescrambler$requiresSecureDecoderComponent(java.lang.String ), this, string2);
    }

    public void setMediaCasSession(MediaCas.Session session) {
        InvokeDynamicSupport.bootstrap("setMediaCasSession", $$robo$$android_media_MediaDescrambler$setMediaCasSession(android.media.MediaCas$Session ), this, session);
    }

    public int descramble(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, MediaCodec.CryptoInfo cryptoInfo) {
        return (int)InvokeDynamicSupport.bootstrap("descramble", $$robo$$android_media_MediaDescrambler$descramble(java.nio.ByteBuffer java.nio.ByteBuffer android.media.MediaCodec$CryptoInfo ), this, byteBuffer, byteBuffer2, cryptoInfo);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaDescrambler$close(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaDescrambler$finalize(), this);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaDescrambler$native_init());
    }

    private void native_setup(IHwBinder iHwBinder) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaDescrambler$native_setup(android.os.IHwBinder ), this, iHwBinder);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_MediaDescrambler$native_release(), this);
    }

    private int native_descramble(byte by, byte by2, int n, int[] nArray, int[] nArray2, ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("native_descramble", $$robo$$android_media_MediaDescrambler$native_descramble(byte byte int int[] int[] java.nio.ByteBuffer int int java.nio.ByteBuffer int int ), this, by, by2, n, nArray, nArray2, byteBuffer, n2, n3, byteBuffer2, n4, n5);
    }

    static {
        RobolectricInternals.classInitializing(MediaDescrambler.class);
    }

    public /* synthetic */ MediaDescrambler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaDescrambler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

