/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.cas.V1_0.HidlCasPluginDescriptor;
import android.hardware.cas.V1_0.ICas;
import android.hardware.cas.V1_0.ICasListener;
import android.hardware.cas.V1_0.IMediaCasService;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Singleton;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaCas
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaCas";
    private ICas mICas;
    private EventListener mListener;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private static Singleton<IMediaCasService> gDefault;
    private ICasListener.Stub mBinder;

    private static final IMediaCasService $$robo$$android_media_MediaCas$getService() {
        return gDefault.get();
    }

    private final void $$robo$$android_media_MediaCas$validateInternalStates() {
        if (this.mICas == null) {
            throw new IllegalStateException();
        }
    }

    private final void $$robo$$android_media_MediaCas$cleanupAndRethrowIllegalState() {
        this.mICas = null;
        throw new IllegalStateException();
    }

    private final ArrayList<Byte> $$robo$$android_media_MediaCas$toByteArray(byte[] data, int offset, int length) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>(length);
        for (int i = 0; i < length; ++i) {
            byteArray.add(data[offset + i]);
        }
        return byteArray;
    }

    private final ArrayList<Byte> $$robo$$android_media_MediaCas$toByteArray(byte[] data) {
        if (data == null) {
            return new ArrayList<Byte>();
        }
        return this.toByteArray(data, 0, data.length);
    }

    private final byte[] $$robo$$android_media_MediaCas$toBytes(ArrayList<Byte> byteArray) {
        byte[] data = null;
        if (byteArray != null) {
            data = new byte[byteArray.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = byteArray.get(i);
            }
        }
        return data;
    }

    private final Session $$robo$$android_media_MediaCas$createFromSessionId(ArrayList<Byte> sessionId) {
        if (sessionId == null || sessionId.size() == 0) {
            return null;
        }
        return new Session(this, sessionId);
    }

    private static final boolean $$robo$$android_media_MediaCas$isSystemIdSupported(int CA_system_id) {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                return service.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private static final PluginDescriptor[] $$robo$$android_media_MediaCas$enumeratePlugins() {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                ArrayList<HidlCasPluginDescriptor> descriptors = service.enumeratePlugins();
                if (descriptors.size() == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.size()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = new PluginDescriptor(descriptors.get(i));
                }
                return results;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    private void $$robo$$android_media_MediaCas$__constructor__(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block5: {
            this.mBinder = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MediaCas this$0;

                private void $$robo$$android_media_MediaCas_2$__constructor__(MediaCas this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$android_media_MediaCas_2$onEvent(int event, int arg, ArrayList<Byte> data) throws RemoteException {
                    this.this$0.mEventHandler.sendMessage(this.this$0.mEventHandler.obtainMessage(0, event, arg, data));
                }

                private void __constructor__(MediaCas mediaCas) {
                    this.$$robo$$android_media_MediaCas_2$__constructor__(mediaCas);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_2$__constructor__(android.media.MediaCas ), this, mediaCas);
                }

                @Override
                public void onEvent(int n, int n2, ArrayList<Byte> arrayList) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_media_MediaCas_2$onEvent(int int java.util.ArrayList<java.lang.Byte> ), this, n, n2, arrayList);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            try {
                this.mICas = MediaCas.getService().createPlugin(CA_system_id, this.mBinder);
            }
            catch (Exception e) {
                Log.e("MediaCas", "Failed to create plugin: " + e);
                this.mICas = null;
            }
            finally {
                if (this.mICas != null) break block5;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
    }

    private final IHwBinder $$robo$$android_media_MediaCas$getBinder() {
        this.validateInternalStates();
        return this.mICas.asBinder();
    }

    private final void $$robo$$android_media_MediaCas$setEventListener(EventListener listener, Handler handler) {
        Looper looper;
        this.mListener = listener;
        if (this.mListener == null) {
            this.mEventHandler = null;
            return;
        }
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null && (looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
                this.mHandlerThread = new HandlerThread("MediaCasEventThread", -2);
                this.mHandlerThread.start();
            }
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(this, looper);
    }

    private final void $$robo$$android_media_MediaCas$setPrivateData(byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.setPrivateData(this.toByteArray(data, 0, data.length)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final Session $$robo$$android_media_MediaCas$openSession() throws MediaCasException {
        this.validateInternalStates();
        try {
            OpenSessionCallback cb = new OpenSessionCallback(this, null);
            this.mICas.openSession(cb);
            MediaCasException.throwExceptionIfNeeded(cb.mStatus);
            return cb.mSession;
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            return null;
        }
    }

    private final void $$robo$$android_media_MediaCas$processEmm(byte[] data, int offset, int length) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.processEmm(this.toByteArray(data, offset, length)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$processEmm(byte[] data) throws MediaCasException {
        this.processEmm(data, 0, data.length);
    }

    private final void $$robo$$android_media_MediaCas$sendEvent(int event, int arg, byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.sendEvent(event, arg, this.toByteArray(data)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$provision(String provisionString) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.provision(provisionString));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$refreshEntitlements(int refreshType, byte[] refreshData) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.refreshEntitlements(refreshType, this.toByteArray(refreshData)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final void $$robo$$android_media_MediaCas$close() {
        if (this.mICas != null) {
            try {
                this.mICas.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICas = null;
            }
        }
    }

    private final void $$robo$$android_media_MediaCas$finalize() {
        this.close();
    }

    static void __staticInitializer__() {
        gDefault = new Singleton<IMediaCasService>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_MediaCas_1$__constructor__() {
            }

            private final IMediaCasService $$robo$$android_media_MediaCas_1$create() {
                try {
                    return IMediaCasService.getService();
                }
                catch (RemoteException remoteException) {
                    return null;
                }
            }

            private void __constructor__() {
                this.$$robo$$android_media_MediaCas_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_1$__constructor__(), this);
            }

            @Override
            protected IMediaCasService create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_media_MediaCas_1$create(), this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    static IMediaCasService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_MediaCas$getService());
    }

    private void validateInternalStates() {
        InvokeDynamicSupport.bootstrap("validateInternalStates", $$robo$$android_media_MediaCas$validateInternalStates(), this);
    }

    private void cleanupAndRethrowIllegalState() {
        InvokeDynamicSupport.bootstrap("cleanupAndRethrowIllegalState", $$robo$$android_media_MediaCas$cleanupAndRethrowIllegalState(), this);
    }

    private ArrayList<Byte> toByteArray(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_media_MediaCas$toByteArray(byte[] int int ), this, byArray, n, n2);
    }

    private ArrayList<Byte> toByteArray(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_media_MediaCas$toByteArray(byte[] ), this, byArray);
    }

    private byte[] toBytes(ArrayList<Byte> arrayList) {
        return InvokeDynamicSupport.bootstrap("toBytes", $$robo$$android_media_MediaCas$toBytes(java.util.ArrayList<java.lang.Byte> ), this, arrayList);
    }

    Session createFromSessionId(ArrayList<Byte> arrayList) {
        return InvokeDynamicSupport.bootstrap("createFromSessionId", $$robo$$android_media_MediaCas$createFromSessionId(java.util.ArrayList<java.lang.Byte> ), this, arrayList);
    }

    public static boolean isSystemIdSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemIdSupported", $$robo$$android_media_MediaCas$isSystemIdSupported(int ), (int)n);
    }

    public static PluginDescriptor[] enumeratePlugins() {
        return InvokeDynamicSupport.bootstrapStatic("enumeratePlugins", $$robo$$android_media_MediaCas$enumeratePlugins());
    }

    private void __constructor__(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$$android_media_MediaCas$__constructor__(n);
    }

    public MediaCas(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas$__constructor__(int ), this, n);
    }

    IHwBinder getBinder() {
        return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_MediaCas$getBinder(), this);
    }

    public void setEventListener(EventListener eventListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setEventListener", $$robo$$android_media_MediaCas$setEventListener(android.media.MediaCas$EventListener android.os.Handler ), this, eventListener, handler);
    }

    public void setPrivateData(byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("setPrivateData", $$robo$$android_media_MediaCas$setPrivateData(byte[] ), this, byArray);
    }

    public Session openSession() throws MediaCasException {
        return InvokeDynamicSupport.bootstrap("openSession", $$robo$$android_media_MediaCas$openSession(), this);
    }

    public void processEmm(byte[] byArray, int n, int n2) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("processEmm", $$robo$$android_media_MediaCas$processEmm(byte[] int int ), this, byArray, n, n2);
    }

    public void processEmm(byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("processEmm", $$robo$$android_media_MediaCas$processEmm(byte[] ), this, byArray);
    }

    public void sendEvent(int n, int n2, byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("sendEvent", $$robo$$android_media_MediaCas$sendEvent(int int byte[] ), this, n, n2, byArray);
    }

    public void provision(String string2) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("provision", $$robo$$android_media_MediaCas$provision(java.lang.String ), this, string2);
    }

    public void refreshEntitlements(int n, byte[] byArray) throws MediaCasException {
        InvokeDynamicSupport.bootstrap("refreshEntitlements", $$robo$$android_media_MediaCas$refreshEntitlements(int byte[] ), this, n, byArray);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaCas$close(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaCas$finalize(), this);
    }

    static {
        RobolectricInternals.classInitializing(MediaCas.class);
    }

    public /* synthetic */ MediaCas() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaCas)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class OpenSessionCallback
    implements ICas.openSessionCallback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Session mSession;
        public int mStatus;
        /* synthetic */ MediaCas this$0;

        private void $$robo$$android_media_MediaCas_OpenSessionCallback$__constructor__(MediaCas mediaCas) {
            this.this$0 = mediaCas;
        }

        private final void $$robo$$android_media_MediaCas_OpenSessionCallback$onValues(int status, ArrayList<Byte> sessionId) {
            this.mStatus = status;
            this.mSession = this.this$0.createFromSessionId(sessionId);
        }

        private /* synthetic */ void $$robo$$android_media_MediaCas_OpenSessionCallback$__constructor__(MediaCas x0, 1 x1) {
        }

        private void __constructor__(MediaCas mediaCas) {
            this.$$robo$$android_media_MediaCas_OpenSessionCallback$__constructor__(mediaCas);
        }

        public OpenSessionCallback(MediaCas mediaCas) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_OpenSessionCallback$__constructor__(android.media.MediaCas ), this, mediaCas);
        }

        @Override
        public void onValues(int n, ArrayList<Byte> arrayList) {
            InvokeDynamicSupport.bootstrap("onValues", $$robo$$android_media_MediaCas_OpenSessionCallback$onValues(int java.util.ArrayList<java.lang.Byte> ), this, n, arrayList);
        }

        private /* synthetic */ void __constructor__(MediaCas mediaCas, 1 var2_2) {
            this.$$robo$$android_media_MediaCas_OpenSessionCallback$__constructor__(mediaCas, var2_2);
        }

        public /* synthetic */ OpenSessionCallback(MediaCas mediaCas, 1 var2_2) {
            this(mediaCas);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_OpenSessionCallback$__constructor__(android.media.MediaCas android.media.MediaCas$1 ), this, mediaCas, var2_2);
        }

        public /* synthetic */ OpenSessionCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpenSessionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface EventListener {
        public void onEvent(MediaCas var1, int var2, int var3, byte[] var4);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Session
    implements AutoCloseable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ArrayList<Byte> mSessionId;
        /* synthetic */ MediaCas this$0;

        private void $$robo$$android_media_MediaCas_Session$__constructor__(MediaCas this$0, ArrayList<Byte> sessionId) {
            this.this$0 = this$0;
            this.mSessionId = sessionId;
        }

        private final void $$robo$$android_media_MediaCas_Session$setPrivateData(byte[] data) throws MediaCasException {
            this.this$0.validateInternalStates();
            try {
                MediaCasException.throwExceptionIfNeeded(this.this$0.mICas.setSessionPrivateData(this.mSessionId, this.this$0.toByteArray(data, 0, data.length)));
            }
            catch (RemoteException e) {
                this.this$0.cleanupAndRethrowIllegalState();
            }
        }

        private final void $$robo$$android_media_MediaCas_Session$processEcm(byte[] data, int offset, int length) throws MediaCasException {
            this.this$0.validateInternalStates();
            try {
                MediaCasException.throwExceptionIfNeeded(this.this$0.mICas.processEcm(this.mSessionId, this.this$0.toByteArray(data, offset, length)));
            }
            catch (RemoteException e) {
                this.this$0.cleanupAndRethrowIllegalState();
            }
        }

        private final void $$robo$$android_media_MediaCas_Session$processEcm(byte[] data) throws MediaCasException {
            this.processEcm(data, 0, data.length);
        }

        private final void $$robo$$android_media_MediaCas_Session$close() {
            this.this$0.validateInternalStates();
            try {
                MediaCasStateException.throwExceptionIfNeeded(this.this$0.mICas.closeSession(this.mSessionId));
            }
            catch (RemoteException e) {
                this.this$0.cleanupAndRethrowIllegalState();
            }
        }

        private void __constructor__(MediaCas mediaCas, ArrayList<Byte> arrayList) {
            this.$$robo$$android_media_MediaCas_Session$__constructor__(mediaCas, arrayList);
        }

        public Session(MediaCas mediaCas, ArrayList<Byte> arrayList) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_Session$__constructor__(android.media.MediaCas java.util.ArrayList<java.lang.Byte> ), this, mediaCas, arrayList);
        }

        public void setPrivateData(byte[] byArray) throws MediaCasException {
            InvokeDynamicSupport.bootstrap("setPrivateData", $$robo$$android_media_MediaCas_Session$setPrivateData(byte[] ), this, byArray);
        }

        public void processEcm(byte[] byArray, int n, int n2) throws MediaCasException {
            InvokeDynamicSupport.bootstrap("processEcm", $$robo$$android_media_MediaCas_Session$processEcm(byte[] int int ), this, byArray, n, n2);
        }

        public void processEcm(byte[] byArray) throws MediaCasException {
            InvokeDynamicSupport.bootstrap("processEcm", $$robo$$android_media_MediaCas_Session$processEcm(byte[] ), this, byArray);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaCas_Session$close(), this);
        }

        public /* synthetic */ Session() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PluginDescriptor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mCASystemId;
        private String mName;

        private void $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__() {
            this.mCASystemId = 65535;
            this.mName = null;
        }

        private void $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(HidlCasPluginDescriptor descriptor) {
            this.mCASystemId = descriptor.caSystemId;
            this.mName = descriptor.name;
        }

        private final int $$robo$$android_media_MediaCas_PluginDescriptor$getSystemId() {
            return this.mCASystemId;
        }

        private final String $$robo$$android_media_MediaCas_PluginDescriptor$getName() {
            return this.mName;
        }

        private final String $$robo$$android_media_MediaCas_PluginDescriptor$toString() {
            return "PluginDescriptor {" + this.mCASystemId + ", " + this.mName + "}";
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCas_PluginDescriptor$__constructor__();
        }

        public PluginDescriptor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(), this);
        }

        private void __constructor__(HidlCasPluginDescriptor hidlCasPluginDescriptor) {
            this.$$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(hidlCasPluginDescriptor);
        }

        public PluginDescriptor(HidlCasPluginDescriptor hidlCasPluginDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_PluginDescriptor$__constructor__(android.hardware.cas.V1_0.HidlCasPluginDescriptor ), this, hidlCasPluginDescriptor);
        }

        public int getSystemId() {
            return (int)InvokeDynamicSupport.bootstrap("getSystemId", $$robo$$android_media_MediaCas_PluginDescriptor$getSystemId(), this);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaCas_PluginDescriptor$getName(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaCas_PluginDescriptor$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluginDescriptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_CAS_EVENT = 0;
        /* synthetic */ MediaCas this$0;

        private void $$robo$$android_media_MediaCas_EventHandler$__constructor__(MediaCas mediaCas, Looper looper) {
            this.this$0 = mediaCas;
        }

        private final void $$robo$$android_media_MediaCas_EventHandler$handleMessage(Message msg) {
            if (msg.what == 0) {
                this.this$0.mListener.onEvent(this.this$0, msg.arg1, msg.arg2, this.this$0.toBytes((ArrayList)msg.obj));
            }
        }

        private void __constructor__(MediaCas mediaCas, Looper looper) {
            this.$$robo$$android_media_MediaCas_EventHandler$__constructor__(mediaCas, looper);
        }

        public EventHandler(MediaCas mediaCas, Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCas_EventHandler$__constructor__(android.media.MediaCas android.os.Looper ), this, mediaCas, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaCas_EventHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

