/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FaceDetector
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean sInitialized;
    private long mFD;
    private long mSDK;
    private long mDCR;
    private int mWidth;
    private int mHeight;
    private int mMaxFaces;
    private byte[] mBWBuffer;

    private void $$robo$$android_media_FaceDetector$__constructor__(int width, int height, int maxFaces) {
        if (!sInitialized) {
            return;
        }
        this.fft_initialize(width, height, maxFaces);
        this.mWidth = width;
        this.mHeight = height;
        this.mMaxFaces = maxFaces;
        this.mBWBuffer = new byte[width * height];
    }

    private final int $$robo$$android_media_FaceDetector$findFaces(Bitmap bitmap, Face[] faces) {
        if (!sInitialized) {
            return 0;
        }
        if (bitmap.getWidth() != this.mWidth || bitmap.getHeight() != this.mHeight) {
            throw new IllegalArgumentException("bitmap size doesn't match initialization");
        }
        if (faces.length < this.mMaxFaces) {
            throw new IllegalArgumentException("faces[] smaller than maxFaces");
        }
        int numFaces = this.fft_detect(bitmap);
        if (numFaces >= this.mMaxFaces) {
            numFaces = this.mMaxFaces;
        }
        for (int i = 0; i < numFaces; ++i) {
            if (faces[i] == null) {
                faces[i] = new Face(this, null);
            }
            this.fft_get_face(faces[i], i);
        }
        return numFaces;
    }

    private final void $$robo$$android_media_FaceDetector$finalize() throws Throwable {
        this.fft_destroy();
    }

    private static final void $$robo$$android_media_FaceDetector$nativeClassInit() {
    }

    private final int $$robo$$android_media_FaceDetector$fft_initialize(int n, int n2, int n3) {
        return 0;
    }

    private final int $$robo$$android_media_FaceDetector$fft_detect(Bitmap bitmap) {
        return 0;
    }

    private final void $$robo$$android_media_FaceDetector$fft_get_face(Face face, int n) {
    }

    private final void $$robo$$android_media_FaceDetector$fft_destroy() {
    }

    static void __staticInitializer__() {
        sInitialized = false;
        try {
            InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"FFTEm");
            FaceDetector.nativeClassInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.d("FFTEm", "face detection library not found!");
        }
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_media_FaceDetector$__constructor__(n, n2, n3);
    }

    public FaceDetector(int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_FaceDetector$__constructor__(int int int ), this, n, n2, n3);
    }

    public int findFaces(Bitmap bitmap, Face[] faceArray) {
        return (int)InvokeDynamicSupport.bootstrap("findFaces", $$robo$$android_media_FaceDetector$findFaces(android.graphics.Bitmap android.media.FaceDetector$Face[] ), this, bitmap, faceArray);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_FaceDetector$finalize(), this);
    }

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_media_FaceDetector$nativeClassInit());
    }

    private int fft_initialize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("fft_initialize", $$robo$$android_media_FaceDetector$fft_initialize(int int int ), this, n, n2, n3);
    }

    private int fft_detect(Bitmap bitmap) {
        return (int)InvokeDynamicSupport.bootstrap("fft_detect", $$robo$$android_media_FaceDetector$fft_detect(android.graphics.Bitmap ), this, bitmap);
    }

    private void fft_get_face(Face face, int n) {
        InvokeDynamicSupport.bootstrap("fft_get_face", $$robo$$android_media_FaceDetector$fft_get_face(android.media.FaceDetector$Face int ), this, face, n);
    }

    private void fft_destroy() {
        InvokeDynamicSupport.bootstrap("fft_destroy", $$robo$$android_media_FaceDetector$fft_destroy(), this);
    }

    static {
        RobolectricInternals.classInitializing(FaceDetector.class);
    }

    public /* synthetic */ FaceDetector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FaceDetector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Face
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static float CONFIDENCE_THRESHOLD = 0.4f;
        public static int EULER_X = 0;
        public static int EULER_Y = 1;
        public static int EULER_Z = 2;
        private float mConfidence;
        private float mMidPointX;
        private float mMidPointY;
        private float mEyesDist;
        private float mPoseEulerX;
        private float mPoseEulerY;
        private float mPoseEulerZ;
        /* synthetic */ FaceDetector this$0;

        private final float $$robo$$android_media_FaceDetector_Face$confidence() {
            return this.mConfidence;
        }

        private final void $$robo$$android_media_FaceDetector_Face$getMidPoint(PointF point) {
            point.set(this.mMidPointX, this.mMidPointY);
        }

        private final float $$robo$$android_media_FaceDetector_Face$eyesDistance() {
            return this.mEyesDist;
        }

        private final float $$robo$$android_media_FaceDetector_Face$pose(int euler) {
            if (euler == 0) {
                return this.mPoseEulerX;
            }
            if (euler == 1) {
                return this.mPoseEulerY;
            }
            if (euler == 2) {
                return this.mPoseEulerZ;
            }
            throw new IllegalArgumentException();
        }

        private void $$robo$$android_media_FaceDetector_Face$__constructor__(FaceDetector this$0) {
            this.this$0 = this$0;
        }

        private /* synthetic */ void $$robo$$android_media_FaceDetector_Face$__constructor__(FaceDetector x0, 1 x1) {
        }

        public float confidence() {
            return (float)InvokeDynamicSupport.bootstrap("confidence", $$robo$$android_media_FaceDetector_Face$confidence(), this);
        }

        public void getMidPoint(PointF pointF) {
            InvokeDynamicSupport.bootstrap("getMidPoint", $$robo$$android_media_FaceDetector_Face$getMidPoint(android.graphics.PointF ), this, pointF);
        }

        public float eyesDistance() {
            return (float)InvokeDynamicSupport.bootstrap("eyesDistance", $$robo$$android_media_FaceDetector_Face$eyesDistance(), this);
        }

        public float pose(int n) {
            return (float)InvokeDynamicSupport.bootstrap("pose", $$robo$$android_media_FaceDetector_Face$pose(int ), this, n);
        }

        private void __constructor__(FaceDetector faceDetector) {
            this.$$robo$$android_media_FaceDetector_Face$__constructor__(faceDetector);
        }

        public Face(FaceDetector faceDetector) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_FaceDetector_Face$__constructor__(android.media.FaceDetector ), this, faceDetector);
        }

        private /* synthetic */ void __constructor__(FaceDetector faceDetector, 1 var2_2) {
            this.$$robo$$android_media_FaceDetector_Face$__constructor__(faceDetector, var2_2);
        }

        public /* synthetic */ Face(FaceDetector faceDetector, 1 var2_2) {
            this(faceDetector);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_FaceDetector_Face$__constructor__(android.media.FaceDetector android.media.FaceDetector$1 ), this, faceDetector, var2_2);
        }

        public /* synthetic */ Face() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Face)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

