/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Color;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Cea708CCParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Cea708CCParser";
    private static boolean DEBUG = false;
    private static String MUSIC_NOTE_CHAR;
    private StringBuffer mBuffer;
    private int mCommand;
    private DisplayListener mListener;
    public static int CAPTION_EMIT_TYPE_BUFFER = 1;
    public static int CAPTION_EMIT_TYPE_CONTROL = 2;
    public static int CAPTION_EMIT_TYPE_COMMAND_CWX = 3;
    public static int CAPTION_EMIT_TYPE_COMMAND_CLW = 4;
    public static int CAPTION_EMIT_TYPE_COMMAND_DSW = 5;
    public static int CAPTION_EMIT_TYPE_COMMAND_HDW = 6;
    public static int CAPTION_EMIT_TYPE_COMMAND_TGW = 7;
    public static int CAPTION_EMIT_TYPE_COMMAND_DLW = 8;
    public static int CAPTION_EMIT_TYPE_COMMAND_DLY = 9;
    public static int CAPTION_EMIT_TYPE_COMMAND_DLC = 10;
    public static int CAPTION_EMIT_TYPE_COMMAND_RST = 11;
    public static int CAPTION_EMIT_TYPE_COMMAND_SPA = 12;
    public static int CAPTION_EMIT_TYPE_COMMAND_SPC = 13;
    public static int CAPTION_EMIT_TYPE_COMMAND_SPL = 14;
    public static int CAPTION_EMIT_TYPE_COMMAND_SWA = 15;
    public static int CAPTION_EMIT_TYPE_COMMAND_DFX = 16;

    private void $$robo$$android_media_Cea708CCParser$__constructor__(DisplayListener listener) {
        this.mBuffer = new StringBuffer();
        this.mCommand = 0;
        this.mListener = new DisplayListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Cea708CCParser this$0;

            private void $$robo$$android_media_Cea708CCParser_1$__constructor__(Cea708CCParser this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_Cea708CCParser_1$emitEvent(CaptionEvent event) {
            }

            private void __constructor__(Cea708CCParser cea708CCParser) {
                this.$$robo$$android_media_Cea708CCParser_1$__constructor__(cea708CCParser);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_1$__constructor__(android.media.Cea708CCParser ), this, cea708CCParser);
            }

            @Override
            public void emitEvent(CaptionEvent captionEvent) {
                InvokeDynamicSupport.bootstrap("emitEvent", $$robo$$android_media_Cea708CCParser_1$emitEvent(android.media.Cea708CCParser$CaptionEvent ), this, captionEvent);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (listener != null) {
            this.mListener = listener;
        }
    }

    private final void $$robo$$android_media_Cea708CCParser$emitCaptionEvent(CaptionEvent captionEvent) {
        this.emitCaptionBuffer();
        this.mListener.emitEvent(captionEvent);
    }

    private final void $$robo$$android_media_Cea708CCParser$emitCaptionBuffer() {
        if (this.mBuffer.length() > 0) {
            this.mListener.emitEvent(new CaptionEvent(1, this.mBuffer.toString()));
            this.mBuffer.setLength(0);
        }
    }

    private final void $$robo$$android_media_Cea708CCParser$parse(byte[] data) {
        int pos = 0;
        while (pos < data.length) {
            pos = this.parseServiceBlockData(data, pos);
        }
        this.emitCaptionBuffer();
    }

    private final int $$robo$$android_media_Cea708CCParser$parseServiceBlockData(byte[] data, int pos) {
        this.mCommand = data[pos] & 0xFF;
        ++pos;
        if (this.mCommand == 16) {
            pos = this.parseExt1(data, pos);
        } else if (this.mCommand >= 0 && this.mCommand <= 31) {
            pos = this.parseC0(data, pos);
        } else if (this.mCommand >= 128 && this.mCommand <= 159) {
            pos = this.parseC1(data, pos);
        } else if (this.mCommand >= 32 && this.mCommand <= 127) {
            pos = this.parseG0(data, pos);
        } else if (this.mCommand >= 160 && this.mCommand <= 255) {
            pos = this.parseG1(data, pos);
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseC0(byte[] data, int pos) {
        if (this.mCommand >= 24 && this.mCommand <= 31) {
            if (this.mCommand == 24) {
                try {
                    if (data[pos] == 0) {
                        this.mBuffer.append((char)data[pos + 1]);
                    } else {
                        String value = new String(Arrays.copyOfRange(data, pos, pos + 2), "EUC-KR");
                        this.mBuffer.append(value);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Log.e("Cea708CCParser", "P16 Code - Could not find supported encoding", e);
                }
            }
            pos += 2;
        } else if (this.mCommand >= 16 && this.mCommand <= 23) {
            ++pos;
        } else {
            switch (this.mCommand) {
                case 0: {
                    break;
                }
                case 3: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
                case 8: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
                case 12: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
                case 13: {
                    this.mBuffer.append('\n');
                    break;
                }
                case 14: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
            }
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseC1(byte[] data, int pos) {
        switch (this.mCommand) {
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                int windowId = this.mCommand - 128;
                this.emitCaptionEvent(new CaptionEvent(3, windowId));
                break;
            }
            case 136: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(4, windowBitmap));
                break;
            }
            case 137: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(5, windowBitmap));
                break;
            }
            case 138: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(6, windowBitmap));
                break;
            }
            case 139: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(7, windowBitmap));
                break;
            }
            case 140: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(8, windowBitmap));
                break;
            }
            case 141: {
                int tenthsOfSeconds = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(9, tenthsOfSeconds));
                break;
            }
            case 142: {
                this.emitCaptionEvent(new CaptionEvent(10, null));
                break;
            }
            case 143: {
                this.emitCaptionEvent(new CaptionEvent(11, null));
                break;
            }
            case 144: {
                int textTag = (data[pos] & 0xF0) >> 4;
                int penSize = data[pos] & 3;
                int penOffset = (data[pos] & 0xC) >> 2;
                boolean italic = (data[pos + 1] & 0x80) != 0;
                boolean underline = (data[pos + 1] & 0x40) != 0;
                int edgeType = (data[pos + 1] & 0x38) >> 3;
                int fontTag = data[pos + 1] & 7;
                pos += 2;
                this.emitCaptionEvent(new CaptionEvent(12, new CaptionPenAttr(penSize, penOffset, textTag, fontTag, edgeType, underline, italic)));
                break;
            }
            case 145: {
                int opacity = (data[pos] & 0xC0) >> 6;
                int red = (data[pos] & 0x30) >> 4;
                int green = (data[pos] & 0xC) >> 2;
                int blue = data[pos] & 3;
                CaptionColor foregroundColor = new CaptionColor(opacity, red, green, blue);
                opacity = (data[++pos] & 0xC0) >> 6;
                red = (data[pos] & 0x30) >> 4;
                green = (data[pos] & 0xC) >> 2;
                blue = data[pos] & 3;
                CaptionColor backgroundColor = new CaptionColor(opacity, red, green, blue);
                red = (data[++pos] & 0x30) >> 4;
                green = (data[pos] & 0xC) >> 2;
                blue = data[pos] & 3;
                CaptionColor edgeColor = new CaptionColor(0, red, green, blue);
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(13, new CaptionPenColor(foregroundColor, backgroundColor, edgeColor)));
                break;
            }
            case 146: {
                int row = data[pos] & 0xF;
                int column = data[pos + 1] & 0x3F;
                pos += 2;
                this.emitCaptionEvent(new CaptionEvent(14, new CaptionPenLocation(row, column)));
                break;
            }
            case 151: {
                int opacity = (data[pos] & 0xC0) >> 6;
                int red = (data[pos] & 0x30) >> 4;
                int green = (data[pos] & 0xC) >> 2;
                int blue = data[pos] & 3;
                CaptionColor fillColor = new CaptionColor(opacity, red, green, blue);
                int borderType = (data[pos + 1] & 0xC0) >> 6 | (data[pos + 2] & 0x80) >> 5;
                red = (data[pos + 1] & 0x30) >> 4;
                green = (data[pos + 1] & 0xC) >> 2;
                blue = data[pos + 1] & 3;
                CaptionColor borderColor = new CaptionColor(0, red, green, blue);
                boolean wordWrap = (data[pos + 2] & 0x40) != 0;
                int printDirection = (data[pos + 2] & 0x30) >> 4;
                int scrollDirection = (data[pos + 2] & 0xC) >> 2;
                int justify = data[pos + 2] & 3;
                int effectSpeed = (data[pos + 3] & 0xF0) >> 4;
                int effectDirection = (data[pos + 3] & 0xC) >> 2;
                int displayEffect = data[pos + 3] & 3;
                pos += 4;
                this.emitCaptionEvent(new CaptionEvent(15, new CaptionWindowAttr(fillColor, borderColor, borderType, wordWrap, printDirection, scrollDirection, justify, effectDirection, effectSpeed, displayEffect)));
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                int windowId = this.mCommand - 152;
                boolean visible = (data[pos] & 0x20) != 0;
                boolean rowLock = (data[pos] & 0x10) != 0;
                boolean columnLock = (data[pos] & 8) != 0;
                int priority = data[pos] & 7;
                boolean relativePositioning = (data[pos + 1] & 0x80) != 0;
                int anchorVertical = data[pos + 1] & 0x7F;
                int anchorHorizontal = data[pos + 2] & 0xFF;
                int anchorId = (data[pos + 3] & 0xF0) >> 4;
                int rowCount = data[pos + 3] & 0xF;
                int columnCount = data[pos + 4] & 0x3F;
                int windowStyle = (data[pos + 5] & 0x38) >> 3;
                int penStyle = data[pos + 5] & 7;
                pos += 6;
                this.emitCaptionEvent(new CaptionEvent(16, new CaptionWindow(windowId, visible, rowLock, columnLock, priority, relativePositioning, anchorVertical, anchorHorizontal, anchorId, rowCount, columnCount, penStyle, windowStyle)));
                break;
            }
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseG0(byte[] data, int pos) {
        if (this.mCommand == 127) {
            this.mBuffer.append(MUSIC_NOTE_CHAR);
        } else {
            this.mBuffer.append((char)this.mCommand);
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseG1(byte[] data, int pos) {
        this.mBuffer.append((char)this.mCommand);
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseExt1(byte[] data, int pos) {
        this.mCommand = data[pos] & 0xFF;
        ++pos;
        if (this.mCommand >= 0 && this.mCommand <= 31) {
            pos = this.parseC2(data, pos);
        } else if (this.mCommand >= 128 && this.mCommand <= 159) {
            pos = this.parseC3(data, pos);
        } else if (this.mCommand >= 32 && this.mCommand <= 127) {
            pos = this.parseG2(data, pos);
        } else if (this.mCommand >= 160 && this.mCommand <= 255) {
            pos = this.parseG3(data, pos);
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseC2(byte[] data, int pos) {
        if (this.mCommand < 0 || this.mCommand > 7) {
            if (this.mCommand >= 8 && this.mCommand <= 15) {
                ++pos;
            } else if (this.mCommand >= 16 && this.mCommand <= 23) {
                pos += 2;
            } else if (this.mCommand >= 24 && this.mCommand <= 31) {
                pos += 3;
            }
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseC3(byte[] data, int pos) {
        if (this.mCommand >= 128 && this.mCommand <= 135) {
            pos += 4;
        } else if (this.mCommand >= 136 && this.mCommand <= 143) {
            pos += 5;
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseG2(byte[] data, int pos) {
        switch (this.mCommand) {
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 48: {
                break;
            }
        }
        return pos;
    }

    private final int $$robo$$android_media_Cea708CCParser$parseG3(byte[] data, int pos) {
        if (this.mCommand == 160) {
            // empty if block
        }
        return pos;
    }

    static void __staticInitializer__() {
        MUSIC_NOTE_CHAR = new String("\u266b".getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    private void __constructor__(DisplayListener displayListener) {
        this.$$robo$$android_media_Cea708CCParser$__constructor__(displayListener);
    }

    public Cea708CCParser(DisplayListener displayListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser$__constructor__(android.media.Cea708CCParser$DisplayListener ), this, displayListener);
    }

    private void emitCaptionEvent(CaptionEvent captionEvent) {
        InvokeDynamicSupport.bootstrap("emitCaptionEvent", $$robo$$android_media_Cea708CCParser$emitCaptionEvent(android.media.Cea708CCParser$CaptionEvent ), this, captionEvent);
    }

    private void emitCaptionBuffer() {
        InvokeDynamicSupport.bootstrap("emitCaptionBuffer", $$robo$$android_media_Cea708CCParser$emitCaptionBuffer(), this);
    }

    public void parse(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_Cea708CCParser$parse(byte[] ), this, byArray);
    }

    private int parseServiceBlockData(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseServiceBlockData", $$robo$$android_media_Cea708CCParser$parseServiceBlockData(byte[] int ), this, byArray, n);
    }

    private int parseC0(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseC0", $$robo$$android_media_Cea708CCParser$parseC0(byte[] int ), this, byArray, n);
    }

    private int parseC1(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseC1", $$robo$$android_media_Cea708CCParser$parseC1(byte[] int ), this, byArray, n);
    }

    private int parseG0(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseG0", $$robo$$android_media_Cea708CCParser$parseG0(byte[] int ), this, byArray, n);
    }

    private int parseG1(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseG1", $$robo$$android_media_Cea708CCParser$parseG1(byte[] int ), this, byArray, n);
    }

    private int parseExt1(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseExt1", $$robo$$android_media_Cea708CCParser$parseExt1(byte[] int ), this, byArray, n);
    }

    private int parseC2(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseC2", $$robo$$android_media_Cea708CCParser$parseC2(byte[] int ), this, byArray, n);
    }

    private int parseC3(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseC3", $$robo$$android_media_Cea708CCParser$parseC3(byte[] int ), this, byArray, n);
    }

    private int parseG2(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseG2", $$robo$$android_media_Cea708CCParser$parseG2(byte[] int ), this, byArray, n);
    }

    private int parseG3(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseG3", $$robo$$android_media_Cea708CCParser$parseG3(byte[] int ), this, byArray, n);
    }

    static {
        RobolectricInternals.classInitializing(Cea708CCParser.class);
    }

    public /* synthetic */ Cea708CCParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cea708CCParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class CaptionWindow
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int id;
        public boolean visible;
        public boolean rowLock;
        public boolean columnLock;
        public int priority;
        public boolean relativePositioning;
        public int anchorVertical;
        public int anchorHorizontal;
        public int anchorId;
        public int rowCount;
        public int columnCount;
        public int penStyle;
        public int windowStyle;

        private void $$robo$$android_media_Cea708CCParser_CaptionWindow$__constructor__(int id2, boolean visible, boolean rowLock, boolean columnLock, int priority, boolean relativePositioning, int anchorVertical, int anchorHorizontal, int anchorId, int rowCount, int columnCount, int penStyle, int windowStyle) {
            this.id = id2;
            this.visible = visible;
            this.rowLock = rowLock;
            this.columnLock = columnLock;
            this.priority = priority;
            this.relativePositioning = relativePositioning;
            this.anchorVertical = anchorVertical;
            this.anchorHorizontal = anchorHorizontal;
            this.anchorId = anchorId;
            this.rowCount = rowCount;
            this.columnCount = columnCount;
            this.penStyle = penStyle;
            this.windowStyle = windowStyle;
        }

        private void __constructor__(int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.$$robo$$android_media_Cea708CCParser_CaptionWindow$__constructor__(n, bl, bl2, bl3, n2, bl4, n3, n4, n5, n6, n7, n8, n9);
        }

        public CaptionWindow(int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionWindow$__constructor__(int boolean boolean boolean int boolean int int int int int int int ), this, n, bl, bl2, bl3, n2, bl4, n3, n4, n5, n6, n7, n8, n9);
        }

        public /* synthetic */ CaptionWindow() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionWindow)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptionWindowAttr
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public CaptionColor fillColor;
        public CaptionColor borderColor;
        public int borderType;
        public boolean wordWrap;
        public int printDirection;
        public int scrollDirection;
        public int justify;
        public int effectDirection;
        public int effectSpeed;
        public int displayEffect;

        private void $$robo$$android_media_Cea708CCParser_CaptionWindowAttr$__constructor__(CaptionColor fillColor, CaptionColor borderColor, int borderType, boolean wordWrap, int printDirection, int scrollDirection, int justify, int effectDirection, int effectSpeed, int displayEffect) {
            this.fillColor = fillColor;
            this.borderColor = borderColor;
            this.borderType = borderType;
            this.wordWrap = wordWrap;
            this.printDirection = printDirection;
            this.scrollDirection = scrollDirection;
            this.justify = justify;
            this.effectDirection = effectDirection;
            this.effectSpeed = effectSpeed;
            this.displayEffect = displayEffect;
        }

        private void __constructor__(CaptionColor captionColor, CaptionColor captionColor2, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.$$robo$$android_media_Cea708CCParser_CaptionWindowAttr$__constructor__(captionColor, captionColor2, n, bl, n2, n3, n4, n5, n6, n7);
        }

        public CaptionWindowAttr(CaptionColor captionColor, CaptionColor captionColor2, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionWindowAttr$__constructor__(android.media.Cea708CCParser$CaptionColor android.media.Cea708CCParser$CaptionColor int boolean int int int int int int ), this, captionColor, captionColor2, n, bl, n2, n3, n4, n5, n6, n7);
        }

        public /* synthetic */ CaptionWindowAttr() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionWindowAttr)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptionPenLocation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int row;
        public int column;

        private void $$robo$$android_media_Cea708CCParser_CaptionPenLocation$__constructor__(int row, int column) {
            this.row = row;
            this.column = column;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_media_Cea708CCParser_CaptionPenLocation$__constructor__(n, n2);
        }

        public CaptionPenLocation(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionPenLocation$__constructor__(int int ), this, n, n2);
        }

        public /* synthetic */ CaptionPenLocation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionPenLocation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptionPenColor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public CaptionColor foregroundColor;
        public CaptionColor backgroundColor;
        public CaptionColor edgeColor;

        private void $$robo$$android_media_Cea708CCParser_CaptionPenColor$__constructor__(CaptionColor foregroundColor, CaptionColor backgroundColor, CaptionColor edgeColor) {
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.edgeColor = edgeColor;
        }

        private void __constructor__(CaptionColor captionColor, CaptionColor captionColor2, CaptionColor captionColor3) {
            this.$$robo$$android_media_Cea708CCParser_CaptionPenColor$__constructor__(captionColor, captionColor2, captionColor3);
        }

        public CaptionPenColor(CaptionColor captionColor, CaptionColor captionColor2, CaptionColor captionColor3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionPenColor$__constructor__(android.media.Cea708CCParser$CaptionColor android.media.Cea708CCParser$CaptionColor android.media.Cea708CCParser$CaptionColor ), this, captionColor, captionColor2, captionColor3);
        }

        public /* synthetic */ CaptionPenColor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionPenColor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptionPenAttr
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int PEN_SIZE_SMALL = 0;
        public static int PEN_SIZE_STANDARD = 1;
        public static int PEN_SIZE_LARGE = 2;
        public static int OFFSET_SUBSCRIPT = 0;
        public static int OFFSET_NORMAL = 1;
        public static int OFFSET_SUPERSCRIPT = 2;
        public int penSize;
        public int penOffset;
        public int textTag;
        public int fontTag;
        public int edgeType;
        public boolean underline;
        public boolean italic;

        private void $$robo$$android_media_Cea708CCParser_CaptionPenAttr$__constructor__(int penSize, int penOffset, int textTag, int fontTag, int edgeType, boolean underline, boolean italic) {
            this.penSize = penSize;
            this.penOffset = penOffset;
            this.textTag = textTag;
            this.fontTag = fontTag;
            this.edgeType = edgeType;
            this.underline = underline;
            this.italic = italic;
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
            this.$$robo$$android_media_Cea708CCParser_CaptionPenAttr$__constructor__(n, n2, n3, n4, n5, bl, bl2);
        }

        public CaptionPenAttr(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionPenAttr$__constructor__(int int int int int boolean boolean ), this, n, n2, n3, n4, n5, bl, bl2);
        }

        public /* synthetic */ CaptionPenAttr() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionPenAttr)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptionEvent
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int type;
        public Object obj;

        private void $$robo$$android_media_Cea708CCParser_CaptionEvent$__constructor__(int type, Object obj) {
            this.type = type;
            this.obj = obj;
        }

        private void __constructor__(int n, Object object) {
            this.$$robo$$android_media_Cea708CCParser_CaptionEvent$__constructor__(n, object);
        }

        public CaptionEvent(int n, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionEvent$__constructor__(int java.lang.Object ), this, n, object);
        }

        public /* synthetic */ CaptionEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptionColor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int OPACITY_SOLID = 0;
        public static int OPACITY_FLASH = 1;
        public static int OPACITY_TRANSLUCENT = 2;
        public static int OPACITY_TRANSPARENT = 3;
        private static int[] COLOR_MAP;
        private static int[] OPACITY_MAP;
        public int opacity;
        public int red;
        public int green;
        public int blue;

        private void $$robo$$android_media_Cea708CCParser_CaptionColor$__constructor__(int opacity, int red, int green, int blue) {
            this.opacity = opacity;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        private final int $$robo$$android_media_Cea708CCParser_CaptionColor$getArgbValue() {
            return Color.argb(OPACITY_MAP[this.opacity], COLOR_MAP[this.red], COLOR_MAP[this.green], COLOR_MAP[this.blue]);
        }

        static void __staticInitializer__() {
            COLOR_MAP = new int[]{0, 15, 240, 255};
            OPACITY_MAP = new int[]{255, 254, 128, 0};
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_media_Cea708CCParser_CaptionColor$__constructor__(n, n2, n3, n4);
        }

        public CaptionColor(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_CaptionColor$__constructor__(int int int int ), this, n, n2, n3, n4);
        }

        public int getArgbValue() {
            return (int)InvokeDynamicSupport.bootstrap("getArgbValue", $$robo$$android_media_Cea708CCParser_CaptionColor$getArgbValue(), this);
        }

        static {
            RobolectricInternals.classInitializing(CaptionColor.class);
        }

        public /* synthetic */ CaptionColor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionColor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Const
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int CODE_C0_RANGE_START = 0;
        public static int CODE_C0_RANGE_END = 31;
        public static int CODE_C1_RANGE_START = 128;
        public static int CODE_C1_RANGE_END = 159;
        public static int CODE_G0_RANGE_START = 32;
        public static int CODE_G0_RANGE_END = 127;
        public static int CODE_G1_RANGE_START = 160;
        public static int CODE_G1_RANGE_END = 255;
        public static int CODE_C2_RANGE_START = 0;
        public static int CODE_C2_RANGE_END = 31;
        public static int CODE_C3_RANGE_START = 128;
        public static int CODE_C3_RANGE_END = 159;
        public static int CODE_G2_RANGE_START = 32;
        public static int CODE_G2_RANGE_END = 127;
        public static int CODE_G3_RANGE_START = 160;
        public static int CODE_G3_RANGE_END = 255;
        public static int CODE_C0_SKIP2_RANGE_START = 24;
        public static int CODE_C0_SKIP2_RANGE_END = 31;
        public static int CODE_C0_SKIP1_RANGE_START = 16;
        public static int CODE_C0_SKIP1_RANGE_END = 23;
        public static int CODE_C2_SKIP0_RANGE_START = 0;
        public static int CODE_C2_SKIP0_RANGE_END = 7;
        public static int CODE_C2_SKIP1_RANGE_START = 8;
        public static int CODE_C2_SKIP1_RANGE_END = 15;
        public static int CODE_C2_SKIP2_RANGE_START = 16;
        public static int CODE_C2_SKIP2_RANGE_END = 23;
        public static int CODE_C2_SKIP3_RANGE_START = 24;
        public static int CODE_C2_SKIP3_RANGE_END = 31;
        public static int CODE_C3_SKIP4_RANGE_START = 128;
        public static int CODE_C3_SKIP4_RANGE_END = 135;
        public static int CODE_C3_SKIP5_RANGE_START = 136;
        public static int CODE_C3_SKIP5_RANGE_END = 143;
        public static int CODE_C0_NUL = 0;
        public static int CODE_C0_ETX = 3;
        public static int CODE_C0_BS = 8;
        public static int CODE_C0_FF = 12;
        public static int CODE_C0_CR = 13;
        public static int CODE_C0_HCR = 14;
        public static int CODE_C0_EXT1 = 16;
        public static int CODE_C0_P16 = 24;
        public static int CODE_G0_MUSICNOTE = 127;
        public static int CODE_G2_TSP = 32;
        public static int CODE_G2_NBTSP = 33;
        public static int CODE_G2_BLK = 48;
        public static int CODE_G3_CC = 160;
        public static int CODE_C1_CW0 = 128;
        public static int CODE_C1_CW1 = 129;
        public static int CODE_C1_CW2 = 130;
        public static int CODE_C1_CW3 = 131;
        public static int CODE_C1_CW4 = 132;
        public static int CODE_C1_CW5 = 133;
        public static int CODE_C1_CW6 = 134;
        public static int CODE_C1_CW7 = 135;
        public static int CODE_C1_CLW = 136;
        public static int CODE_C1_DSW = 137;
        public static int CODE_C1_HDW = 138;
        public static int CODE_C1_TGW = 139;
        public static int CODE_C1_DLW = 140;
        public static int CODE_C1_DLY = 141;
        public static int CODE_C1_DLC = 142;
        public static int CODE_C1_RST = 143;
        public static int CODE_C1_SPA = 144;
        public static int CODE_C1_SPC = 145;
        public static int CODE_C1_SPL = 146;
        public static int CODE_C1_SWA = 151;
        public static int CODE_C1_DF0 = 152;
        public static int CODE_C1_DF1 = 153;
        public static int CODE_C1_DF2 = 154;
        public static int CODE_C1_DF3 = 155;
        public static int CODE_C1_DF4 = 156;
        public static int CODE_C1_DF5 = 157;
        public static int CODE_C1_DF6 = 158;
        public static int CODE_C1_DF7 = 159;

        private void $$robo$$android_media_Cea708CCParser_Const$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_Cea708CCParser_Const$__constructor__();
        }

        public Const() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea708CCParser_Const$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Const)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface DisplayListener {
        public void emitEvent(CaptionEvent var1);
    }
}

