/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.Camera;
import java.util.Arrays;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraProfile
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int QUALITY_LOW = 0;
    public static int QUALITY_MEDIUM = 1;
    public static int QUALITY_HIGH = 2;
    private static HashMap<Integer, int[]> sCache;

    private void $$robo$$android_media_CameraProfile$__constructor__() {
    }

    private static final int $$robo$$android_media_CameraProfile$getJpegEncodingQualityParameter(int quality) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CameraProfile.getJpegEncodingQualityParameter(i, quality);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_media_CameraProfile$getJpegEncodingQualityParameter(int cameraId, int quality) {
        if (quality < 0 || quality > 2) {
            throw new IllegalArgumentException("Unsupported quality level: " + quality);
        }
        HashMap<Integer, int[]> hashMap = sCache;
        synchronized (hashMap) {
            int[] levels = sCache.get(cameraId);
            if (levels == null) {
                levels = CameraProfile.getImageEncodingQualityLevels(cameraId);
                sCache.put(cameraId, levels);
            }
            return levels[quality];
        }
    }

    private static final int[] $$robo$$android_media_CameraProfile$getImageEncodingQualityLevels(int cameraId) {
        int nLevels = CameraProfile.native_get_num_image_encoding_quality_levels(cameraId);
        if (nLevels != 3) {
            throw new RuntimeException("Unexpected Jpeg encoding quality levels " + nLevels);
        }
        int[] levels = new int[nLevels];
        for (int i = 0; i < nLevels; ++i) {
            levels[i] = CameraProfile.native_get_image_encoding_quality_level(cameraId, i);
        }
        Arrays.sort(levels);
        return levels;
    }

    private static final void $$robo$$android_media_CameraProfile$native_init() {
    }

    private static final int $$robo$$android_media_CameraProfile$native_get_num_image_encoding_quality_levels(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_CameraProfile$native_get_image_encoding_quality_level(int n, int n2) {
        return 0;
    }

    static void __staticInitializer__() {
        sCache = new HashMap();
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        CameraProfile.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_CameraProfile$__constructor__();
    }

    public CameraProfile() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_CameraProfile$__constructor__(), this);
    }

    public static int getJpegEncodingQualityParameter(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getJpegEncodingQualityParameter", $$robo$$android_media_CameraProfile$getJpegEncodingQualityParameter(int ), (int)n);
    }

    public static int getJpegEncodingQualityParameter(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getJpegEncodingQualityParameter", $$robo$$android_media_CameraProfile$getJpegEncodingQualityParameter(int int ), (int)n, (int)n2);
    }

    private static int[] getImageEncodingQualityLevels(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getImageEncodingQualityLevels", $$robo$$android_media_CameraProfile$getImageEncodingQualityLevels(int ), (int)n);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_CameraProfile$native_init());
    }

    private static int native_get_num_image_encoding_quality_levels(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_num_image_encoding_quality_levels", $$robo$$android_media_CameraProfile$native_get_num_image_encoding_quality_levels(int ), (int)n);
    }

    private static int native_get_image_encoding_quality_level(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_image_encoding_quality_level", $$robo$$android_media_CameraProfile$native_get_image_encoding_quality_level(int int ), (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(CameraProfile.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraProfile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

