/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPresentation;
import android.media.AudioRouting;
import android.media.AudioSystem;
import android.media.AudioTimestamp;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.PlaybackParams;
import android.media.PlayerBase;
import android.media.VolumeAutomation;
import android.media.VolumeShaper;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioTrack
extends PlayerBase
implements AudioRouting,
VolumeAutomation,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static float GAIN_MIN = 0.0f;
    private static float GAIN_MAX = 1.0f;
    public static int CHANNEL_COUNT_MAX;
    public static int PLAYSTATE_STOPPED = 1;
    public static int PLAYSTATE_PAUSED = 2;
    public static int PLAYSTATE_PLAYING = 3;
    public static int MODE_STATIC = 0;
    public static int MODE_STREAM = 1;
    public static int STATE_UNINITIALIZED = 0;
    public static int STATE_INITIALIZED = 1;
    public static int STATE_NO_STATIC_DATA = 2;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ERROR_BAD_VALUE = -2;
    public static int ERROR_INVALID_OPERATION = -3;
    public static int ERROR_DEAD_OBJECT = -6;
    public static int ERROR_WOULD_BLOCK = -7;
    private static int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static int NATIVE_EVENT_MARKER = 3;
    private static int NATIVE_EVENT_NEW_POS = 4;
    private static int NATIVE_EVENT_MORE_DATA = 0;
    private static int NATIVE_EVENT_NEW_IAUDIOTRACK = 6;
    private static int NATIVE_EVENT_STREAM_END = 7;
    private static String TAG = "android.media.AudioTrack";
    public static int WRITE_BLOCKING = 0;
    public static int WRITE_NON_BLOCKING = 1;
    public static int PERFORMANCE_MODE_NONE = 0;
    public static int PERFORMANCE_MODE_LOW_LATENCY = 1;
    public static int PERFORMANCE_MODE_POWER_SAVING = 2;
    private static int AUDIO_OUTPUT_FLAG_FAST = 4;
    private static int AUDIO_OUTPUT_FLAG_DEEP_BUFFER = 8;
    private static float HEADER_V2_SIZE_BYTES = 20.0f;
    private int mState;
    private int mPlayState;
    private Object mPlayStateLock;
    private int mNativeBufferSizeInBytes;
    private int mNativeBufferSizeInFrames;
    private NativePositionEventHandlerDelegate mEventHandlerDelegate;
    private Looper mInitializationLooper;
    private int mSampleRate;
    private int mChannelCount;
    private int mChannelMask;
    private int mStreamType;
    private int mDataLoadMode;
    private int mChannelConfiguration;
    private int mChannelIndexMask;
    private int mAudioFormat;
    private int mSessionId;
    private ByteBuffer mAvSyncHeader;
    private int mAvSyncBytesRemaining;
    private int mOffset;
    protected long mNativeTrackInJavaObj;
    private long mJniData;
    private static int SUPPORTED_OUT_CHANNELS = 7420;
    private AudioDeviceInfo mPreferredDevice;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners;
    private Executor mStreamEventExec;
    private StreamEventCallback mStreamEventCb;
    private Object mStreamEventCbLock;

    private void $$robo$$android_media_AudioTrack$__constructor__(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
    }

    private void $$robo$$android_media_AudioTrack$__constructor__(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        AudioTrack.deprecateStreamTypeForPlayback(streamType, "AudioTrack", "AudioTrack()");
    }

    private void $$robo$$android_media_AudioTrack$__constructor__(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
    }

    private void $$robo$$android_media_AudioTrack$__constructor__(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId, boolean offload) throws IllegalArgumentException {
        int rate;
        Looper looper;
        this.mState = 0;
        this.mPlayState = 1;
        this.mPlayStateLock = new Object();
        this.mNativeBufferSizeInBytes = 0;
        this.mNativeBufferSizeInFrames = 0;
        this.mChannelCount = 1;
        this.mChannelMask = 4;
        this.mStreamType = 3;
        this.mDataLoadMode = 1;
        this.mChannelConfiguration = 4;
        this.mChannelIndexMask = 0;
        this.mSessionId = 0;
        this.mAvSyncHeader = null;
        this.mAvSyncBytesRemaining = 0;
        this.mOffset = 0;
        this.mPreferredDevice = null;
        this.mRoutingChangeListeners = new ArrayMap();
        this.mStreamEventCbLock = new Object();
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        if (AudioTrack.shouldEnablePowerSaving(this.mAttributes, format, bufferSizeInBytes, mode)) {
            this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x200) & 0xFFFFFEFF).build();
        }
        if ((looper = Looper.myLooper()) == null) {
            looper = Looper.getMainLooper();
        }
        if ((rate = format.getSampleRate()) == 0) {
            rate = 0;
        }
        int channelIndexMask = 0;
        if ((format.getPropertySetMask() & 8) != 0) {
            channelIndexMask = format.getChannelIndexMask();
        }
        int channelMask = 0;
        if ((format.getPropertySetMask() & 4) != 0) {
            channelMask = format.getChannelMask();
        } else if (channelIndexMask == 0) {
            channelMask = 12;
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(rate, channelMask, channelIndexMask, encoding, mode);
        this.mStreamType = -1;
        this.audioBuffSizeCheck(bufferSizeInBytes);
        this.mInitializationLooper = looper;
        if (sessionId < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + sessionId);
        }
        int[] sampleRate = new int[]{this.mSampleRate};
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioTrack>(this), this.mAttributes, sampleRate, this.mChannelMask, this.mChannelIndexMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, session, 0L, offload);
        if (initResult != 0) {
            AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
            return;
        }
        this.mSampleRate = sampleRate[0];
        this.mSessionId = session[0];
        if ((this.mAttributes.getFlags() & 0x10) != 0) {
            int frameSizeInBytes = AudioFormat.isEncodingLinearFrames(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
            this.mOffset = (int)Math.ceil(20.0f / (float)frameSizeInBytes) * frameSizeInBytes;
        }
        this.mState = this.mDataLoadMode == 0 ? 2 : 1;
        this.baseRegisterPlayer();
    }

    private void $$robo$$android_media_AudioTrack$__constructor__(long nativeTrackInJavaObj) {
        this.mState = 0;
        this.mPlayState = 1;
        this.mPlayStateLock = new Object();
        this.mNativeBufferSizeInBytes = 0;
        this.mNativeBufferSizeInFrames = 0;
        this.mChannelCount = 1;
        this.mChannelMask = 4;
        this.mStreamType = 3;
        this.mDataLoadMode = 1;
        this.mChannelConfiguration = 4;
        this.mChannelIndexMask = 0;
        this.mSessionId = 0;
        this.mAvSyncHeader = null;
        this.mAvSyncBytesRemaining = 0;
        this.mOffset = 0;
        this.mPreferredDevice = null;
        this.mRoutingChangeListeners = new ArrayMap();
        this.mStreamEventCbLock = new Object();
        this.mNativeTrackInJavaObj = 0L;
        this.mJniData = 0L;
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        this.mInitializationLooper = looper;
        if (nativeTrackInJavaObj != 0L) {
            this.baseRegisterPlayer();
            this.deferred_connect(nativeTrackInJavaObj);
        } else {
            this.mState = 0;
        }
    }

    private final void $$robo$$android_media_AudioTrack$deferred_connect(long nativeTrackInJavaObj) {
        if (this.mState != 1) {
            int[] session = new int[]{0};
            int[] rates = new int[]{0};
            int initResult = this.native_setup(new WeakReference<AudioTrack>(this), null, rates, 0, 0, 0, 0, 0, session, nativeTrackInJavaObj, false);
            if (initResult != 0) {
                AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
                return;
            }
            this.mSessionId = session[0];
            this.mState = 1;
        }
    }

    private static final boolean $$robo$$android_media_AudioTrack$shouldEnablePowerSaving(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode) {
        if (attributes != null && (attributes.getAllFlags() != 0 || attributes.getUsage() != 1 || attributes.getContentType() != 0 && attributes.getContentType() != 2 && attributes.getContentType() != 3)) {
            return false;
        }
        if (format == null || format.getSampleRate() == 0 || !AudioFormat.isEncodingLinearPcm(format.getEncoding()) || !AudioFormat.isValidEncoding(format.getEncoding()) || format.getChannelCount() < 1) {
            return false;
        }
        if (mode != 1) {
            return false;
        }
        if (bufferSizeInBytes != 0) {
            long BUFFER_TARGET_MODE_STREAM_MS = 100L;
            int MILLIS_PER_SECOND = 1000;
            long bufferTargetSize = 100L * (long)format.getChannelCount() * (long)AudioFormat.getBytesPerSample(format.getEncoding()) * (long)format.getSampleRate() / 1000L;
            if ((long)bufferSizeInBytes < bufferTargetSize) {
                return false;
            }
        }
        return true;
    }

    private final void $$robo$$android_media_AudioTrack$audioParamCheck(int sampleRateInHz, int channelConfig, int channelIndexMask, int audioFormat, int mode) {
        if ((sampleRateInHz < 4000 || sampleRateInHz > 192000) && sampleRateInHz != 0) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        if (audioFormat == 13 && channelConfig != 12) {
            throw new IllegalArgumentException("ENCODING_IEC61937 must be configured as CHANNEL_OUT_STEREO");
        }
        this.mChannelConfiguration = channelConfig;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannelMask = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannelMask = 12;
                break;
            }
            default: {
                if (channelConfig == 0 && channelIndexMask != 0) {
                    this.mChannelCount = 0;
                    break;
                }
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                this.mChannelMask = channelConfig;
                this.mChannelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        this.mChannelIndexMask = channelIndexMask;
        if (this.mChannelIndexMask != 0) {
            int indexMask = (1 << CHANNEL_COUNT_MAX) - 1;
            if ((channelIndexMask & ~indexMask) != 0) {
                throw new IllegalArgumentException("Unsupported channel index configuration " + channelIndexMask);
            }
            int channelIndexCount = Integer.bitCount(channelIndexMask);
            if (this.mChannelCount == 0) {
                this.mChannelCount = channelIndexCount;
            } else if (this.mChannelCount != channelIndexCount) {
                throw new IllegalArgumentException("Channel count must match");
            }
        }
        if (audioFormat == 1) {
            audioFormat = 2;
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            throw new IllegalArgumentException("Unsupported audio encoding.");
        }
        this.mAudioFormat = audioFormat;
        if (mode != 1 && mode != 0 || mode != 1 && !AudioFormat.isEncodingLinearPcm(this.mAudioFormat)) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = mode;
    }

    private static final boolean $$robo$$android_media_AudioTrack$isMultichannelConfigSupported(int channelConfig) {
        if ((channelConfig & 0x1CFC) != channelConfig) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
        if (channelCount > CHANNEL_COUNT_MAX) {
            AudioTrack.loge("Channel configuration contains too many channels " + channelCount + ">" + CHANNEL_COUNT_MAX);
            return false;
        }
        int frontPair = 12;
        if ((channelConfig & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        int backPair = 192;
        if ((channelConfig & 0xC0) != 0 && (channelConfig & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        int sidePair = 6144;
        if ((channelConfig & 0x1800) != 0 && (channelConfig & 0x1800) != 6144) {
            AudioTrack.loge("Side channels can't be used independently");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_media_AudioTrack$audioBuffSizeCheck(int audioBufferSize) {
        int frameSizeInBytes = AudioFormat.isEncodingLinearFrames(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
        this.mNativeBufferSizeInFrames = audioBufferSize / frameSizeInBytes;
    }

    private final void $$robo$$android_media_AudioTrack$release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.baseRelease();
        this.native_release();
        this.mState = 0;
    }

    private final void $$robo$$android_media_AudioTrack$finalize() {
        this.baseRelease();
        this.native_finalize();
    }

    private static final float $$robo$$android_media_AudioTrack$getMinVolume() {
        return 0.0f;
    }

    private static final float $$robo$$android_media_AudioTrack$getMaxVolume() {
        return 1.0f;
    }

    private final int $$robo$$android_media_AudioTrack$getSampleRate() {
        return this.mSampleRate;
    }

    private final int $$robo$$android_media_AudioTrack$getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    private final PlaybackParams $$robo$$android_media_AudioTrack$getPlaybackParams() {
        return this.native_get_playback_params();
    }

    private final int $$robo$$android_media_AudioTrack$getAudioFormat() {
        return this.mAudioFormat;
    }

    private final int $$robo$$android_media_AudioTrack$getStreamType() {
        return this.mStreamType;
    }

    private final int $$robo$$android_media_AudioTrack$getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    private final AudioFormat $$robo$$android_media_AudioTrack$getFormat() {
        AudioFormat.Builder builder = new AudioFormat.Builder().setSampleRate(this.mSampleRate).setEncoding(this.mAudioFormat);
        if (this.mChannelConfiguration != 0) {
            builder.setChannelMask(this.mChannelConfiguration);
        }
        if (this.mChannelIndexMask != 0) {
            builder.setChannelIndexMask(this.mChannelIndexMask);
        }
        return builder.build();
    }

    private final int $$robo$$android_media_AudioTrack$getChannelCount() {
        return this.mChannelCount;
    }

    private final int $$robo$$android_media_AudioTrack$getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioTrack$getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }

    private final int $$robo$$android_media_AudioTrack$getBufferSizeInFrames() {
        return this.native_get_buffer_size_frames();
    }

    private final int $$robo$$android_media_AudioTrack$setBufferSizeInFrames(int bufferSizeInFrames) {
        if (this.mDataLoadMode == 0 || this.mState == 0) {
            return -3;
        }
        if (bufferSizeInFrames < 0) {
            return -2;
        }
        return this.native_set_buffer_size_frames(bufferSizeInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$getBufferCapacityInFrames() {
        return this.native_get_buffer_capacity_frames();
    }

    @Deprecated
    private final int $$robo$$android_media_AudioTrack$getNativeFrameCount() {
        return this.native_get_buffer_capacity_frames();
    }

    private final int $$robo$$android_media_AudioTrack$getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    private final int $$robo$$android_media_AudioTrack$getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    private final int $$robo$$android_media_AudioTrack$getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    private final int $$robo$$android_media_AudioTrack$getLatency() {
        return this.native_get_latency();
    }

    private final int $$robo$$android_media_AudioTrack$getUnderrunCount() {
        return this.native_get_underrun_count();
    }

    private final int $$robo$$android_media_AudioTrack$getPerformanceMode() {
        int flags = this.native_get_flags();
        if ((flags & 4) != 0) {
            return 1;
        }
        if ((flags & 8) != 0) {
            return 2;
        }
        return 0;
    }

    private static final int $$robo$$android_media_AudioTrack$getNativeOutputSampleRate(int streamType) {
        return AudioTrack.native_get_output_sample_rate(streamType);
    }

    private static final int $$robo$$android_media_AudioTrack$getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 2: 
            case 4: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: {
                channelCount = 2;
                break;
            }
            default: {
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return -2;
                }
                channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        if (sampleRateInHz < 4000 || sampleRateInHz > 192000) {
            AudioTrack.loge("getMinBufferSize(): " + sampleRateInHz + " Hz is not a supported sample rate.");
            return -2;
        }
        int size = AudioTrack.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size <= 0) {
            AudioTrack.loge("getMinBufferSize(): error querying hardware");
            return -1;
        }
        return size;
    }

    private final int $$robo$$android_media_AudioTrack$getAudioSessionId() {
        return this.mSessionId;
    }

    private final boolean $$robo$$android_media_AudioTrack$getTimestamp(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        if (ret != 0) {
            return false;
        }
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return true;
    }

    private final int $$robo$$android_media_AudioTrack$getTimestampWithStatus(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return ret;
    }

    private final PersistableBundle $$robo$$android_media_AudioTrack$getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_AudioTrack$native_getMetrics() {
        return null;
    }

    private final void $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener) {
        this.setPlaybackPositionUpdateListener(listener, null);
    }

    private final void $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener, Handler handler) {
        this.mEventHandlerDelegate = listener != null ? new NativePositionEventHandlerDelegate(this, this, listener, handler) : null;
    }

    private static final float $$robo$$android_media_AudioTrack$clampGainOrLevel(float gainOrLevel) {
        if (Float.isNaN(gainOrLevel)) {
            throw new IllegalArgumentException();
        }
        if (gainOrLevel < 0.0f) {
            gainOrLevel = 0.0f;
        } else if (gainOrLevel > 1.0f) {
            gainOrLevel = 1.0f;
        }
        return gainOrLevel;
    }

    @Deprecated
    private final int $$robo$$android_media_AudioTrack$setStereoVolume(float leftGain, float rightGain) {
        if (this.mState == 0) {
            return -3;
        }
        this.baseSetVolume(leftGain, rightGain);
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        leftVolume = AudioTrack.clampGainOrLevel(muting ? 0.0f : leftVolume);
        rightVolume = AudioTrack.clampGainOrLevel(muting ? 0.0f : rightVolume);
        this.native_setVolume(leftVolume, rightVolume);
    }

    private final int $$robo$$android_media_AudioTrack$setVolume(float gain) {
        return this.setStereoVolume(gain, gain);
    }

    private final int $$robo$$android_media_AudioTrack$playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return this.native_applyVolumeShaper(configuration, operation);
    }

    private final VolumeShaper.State $$robo$$android_media_AudioTrack$playerGetVolumeShaperState(int id2) {
        return this.native_getVolumeShaperState(id2);
    }

    private final VolumeShaper $$robo$$android_media_AudioTrack$createVolumeShaper(VolumeShaper.Configuration configuration) {
        return new VolumeShaper(configuration, this);
    }

    private final int $$robo$$android_media_AudioTrack$setPlaybackRate(int sampleRateInHz) {
        if (this.mState != 1) {
            return -3;
        }
        if (sampleRateInHz <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(sampleRateInHz);
    }

    private final void $$robo$$android_media_AudioTrack$setPlaybackParams(PlaybackParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.native_set_playback_params(params);
    }

    private final int $$robo$$android_media_AudioTrack$setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$setPlaybackHeadPosition(int positionInFrames) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (0 > positionInFrames || positionInFrames > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(positionInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$setLoopPoints(int startInFrames, int endInFrames, int loopCount) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (loopCount != 0 && (0 > startInFrames || startInFrames >= this.mNativeBufferSizeInFrames || startInFrames >= endInFrames || endInFrames > this.mNativeBufferSizeInFrames)) {
            return -2;
        }
        return this.native_set_loop(startInFrames, endInFrames, loopCount);
    }

    private final int $$robo$$android_media_AudioTrack$setPresentation(AudioPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException("audio presentation is null");
        }
        return this.native_setPresentation(presentation.getPresentationId(), presentation.getProgramId());
    }

    @Deprecated
    private final void $$robo$$android_media_AudioTrack$setState(int state) {
        this.mState = state;
    }

    private final void $$robo$$android_media_AudioTrack$play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        int delay = this.getStartDelayMs();
        if (delay == 0) {
            this.startImpl();
        } else {
            new ShadowedObject(this, delay){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$delay;
                /* synthetic */ AudioTrack this$0;

                private void $$robo$$android_media_AudioTrack_1$__constructor__(AudioTrack this$0, int n) {
                    this.this$0 = this$0;
                    this.val$delay = n;
                }

                private final void $$robo$$android_media_AudioTrack_1$run() {
                    try {
                        Thread.sleep(this.val$delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.this$0.baseSetStartDelayMs(0);
                    try {
                        this.this$0.startImpl();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }

                private void __constructor__(AudioTrack audioTrack, int n) {
                    this.$$robo$$android_media_AudioTrack_1$__constructor__(audioTrack, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_1$__constructor__(android.media.AudioTrack int ), this, audioTrack, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_AudioTrack_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$startImpl() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.baseStart();
            this.native_start();
            this.mPlayState = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.baseStop();
            this.mPlayState = 1;
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.basePause();
            this.mPlayState = 2;
        }
    }

    private final void $$robo$$android_media_AudioTrack$flush() {
        if (this.mState == 1) {
            this.native_flush();
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    private final int $$robo$$android_media_AudioTrack$write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.write(audioData, offsetInBytes, sizeInBytes, 0);
    }

    private final int $$robo$$android_media_AudioTrack$write(byte[] audioData, int offsetInBytes, int sizeInBytes, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        int ret = this.native_write_byte(audioData, offsetInBytes, sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.write(audioData, offsetInShorts, sizeInShorts, 0);
    }

    private final int $$robo$$android_media_AudioTrack$write(short[] audioData, int offsetInShorts, int sizeInShorts, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        int ret = this.native_write_short(audioData, offsetInShorts, sizeInShorts, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        if (this.mState == 0) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e("android.media.AudioTrack", "AudioTrack.write(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid array, offset, or size");
            return -2;
        }
        int ret = this.native_write_float(audioData, offsetInFloats, sizeInFloats, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (this.mState == 0) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        int ret = 0;
        ret = audioData.isDirect() ? this.native_write_native_bytes(audioData, audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0) : this.native_write_byte(NioUtils.unsafeArray(audioData), NioUtils.unsafeArrayOffset(audioData) + audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        if (ret > 0) {
            audioData.position(audioData.position() + ret);
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(ByteBuffer audioData, int sizeInBytes, int writeMode, long timestamp) {
        int sizeToWrite;
        if (this.mState == 0) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (this.mDataLoadMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() with timestamp called for non-streaming mode track");
            return -3;
        }
        if ((this.mAttributes.getFlags() & 0x10) == 0) {
            Log.d("android.media.AudioTrack", "AudioTrack.write() called on a regular AudioTrack. Ignoring pts...");
            return this.write(audioData, sizeInBytes, writeMode);
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        if (this.mAvSyncHeader == null) {
            this.mAvSyncHeader = ByteBuffer.allocate(this.mOffset);
            this.mAvSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.mAvSyncHeader.putInt(0x55550002);
        }
        if (this.mAvSyncBytesRemaining == 0) {
            this.mAvSyncHeader.putInt(4, sizeInBytes);
            this.mAvSyncHeader.putLong(8, timestamp);
            this.mAvSyncHeader.putInt(16, this.mOffset);
            this.mAvSyncHeader.position(0);
            this.mAvSyncBytesRemaining = sizeInBytes;
        }
        int ret = 0;
        if (this.mAvSyncHeader.remaining() != 0) {
            ret = this.write(this.mAvSyncHeader, this.mAvSyncHeader.remaining(), writeMode);
            if (ret < 0) {
                Log.e("android.media.AudioTrack", "AudioTrack.write() could not write timestamp header!");
                this.mAvSyncHeader = null;
                this.mAvSyncBytesRemaining = 0;
                return ret;
            }
            if (this.mAvSyncHeader.remaining() > 0) {
                Log.v("android.media.AudioTrack", "AudioTrack.write() partial timestamp header written.");
                return 0;
            }
        }
        if ((ret = this.write(audioData, sizeToWrite = Math.min(this.mAvSyncBytesRemaining, sizeInBytes), writeMode)) < 0) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() could not write audio data!");
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
            return ret;
        }
        this.mAvSyncBytesRemaining -= ret;
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    private final int $$robo$$android_media_AudioTrack$attachAuxEffect(int effectId) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(effectId);
    }

    private final int $$robo$$android_media_AudioTrack$setAuxEffectSendLevel(float level) {
        if (this.mState == 0) {
            return -3;
        }
        return this.baseSetAuxEffectSendLevel(level);
    }

    private final int $$robo$$android_media_AudioTrack$playerSetAuxEffectSendLevel(boolean muting, float level) {
        level = AudioTrack.clampGainOrLevel(muting ? 0.0f : level);
        int err = this.native_setAuxEffectSendLevel(level);
        return err == 0 ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioTrack$setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            AudioTrack audioTrack = this;
            synchronized (audioTrack) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AudioDeviceInfo $$robo$$android_media_AudioTrack$getPreferredDevice() {
        AudioTrack audioTrack = this;
        synchronized (audioTrack) {
            return this.mPreferredDevice;
        }
    }

    private final AudioDeviceInfo $$robo$$android_media_AudioTrack$getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(2);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private final void $$robo$$android_media_AudioTrack$testEnableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback();
        }
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private final void $$robo$$android_media_AudioTrack$testDisableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_disableDeviceCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.testEnableNativeRoutingCallbacksLocked();
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : new Handler(this.mInitializationLooper)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
            }
            this.testDisableNativeRoutingCallbacksLocked();
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioTrack$addOnRoutingChangedListener(OnRoutingChangedListener listener, Handler handler) {
        this.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener, handler);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioTrack$removeOnRoutingChangedListener(OnRoutingChangedListener listener) {
        this.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$broadcastRoutingChange() {
        AudioManager.resetAudioPortGeneration();
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            for (NativeRoutingEventHandlerDelegate delegate : this.mRoutingChangeListeners.values()) {
                delegate.notifyClient();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$setStreamEventCallback(Executor executor, StreamEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null StreamEventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the StreamEventCallback");
        }
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            this.mStreamEventExec = executor;
            this.mStreamEventCb = eventCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$removeStreamEventCallback() {
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            this.mStreamEventExec = null;
            this.mStreamEventCb = null;
        }
    }

    private final void $$robo$$android_media_AudioTrack$playerStart() {
        this.play();
    }

    private final void $$robo$$android_media_AudioTrack$playerPause() {
        this.pause();
    }

    private final void $$robo$$android_media_AudioTrack$playerStop() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioTrack$postEventFromNative(Object audiotrack_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        NativePositionEventHandlerDelegate delegate;
        AudioTrack track = (AudioTrack)((WeakReference)audiotrack_ref).get();
        if (track == null) {
            return;
        }
        if (what == 1000) {
            track.broadcastRoutingChange();
            return;
        }
        if (what == 0 || what == 6 || what == 7) {
            StreamEventCallback cb;
            Executor exec;
            Object object = track.mStreamEventCbLock;
            synchronized (object) {
                exec = track.mStreamEventExec;
                cb = track.mStreamEventCb;
            }
            if (exec == null || cb == null) {
                return;
            }
            switch (what) {
                case 0: {
                    exec.execute(() -> cb.onStreamDataRequest(track));
                    return;
                }
                case 6: {
                    exec.execute(() -> cb.onTearDown(track));
                    return;
                }
                case 7: {
                    exec.execute(() -> cb.onStreamPresentationEnd(track));
                    return;
                }
            }
        }
        if ((delegate = track.mEventHandlerDelegate) != null && (handler = delegate.getHandler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private final int $$robo$$android_media_AudioTrack$native_setup(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, int n5, int[] nArray2, long l, boolean bl) {
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$native_finalize() {
    }

    private final void $$robo$$android_media_AudioTrack$native_release() {
    }

    private final void $$robo$$android_media_AudioTrack$native_start() {
    }

    private final void $$robo$$android_media_AudioTrack$native_stop() {
    }

    private final void $$robo$$android_media_AudioTrack$native_pause() {
    }

    private final void $$robo$$android_media_AudioTrack$native_flush() {
    }

    private final int $$robo$$android_media_AudioTrack$native_write_byte(byte[] byArray, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_write_short(short[] sArray, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_write_float(float[] fArray, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_write_native_bytes(Object object, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_reload_static() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_buffer_size_frames() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_buffer_size_frames(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_buffer_capacity_frames() {
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$native_setVolume(float f, float f2) {
    }

    private final int $$robo$$android_media_AudioTrack$native_set_playback_rate(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_playback_rate() {
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$native_set_playback_params(PlaybackParams playbackParams) {
    }

    private final PlaybackParams $$robo$$android_media_AudioTrack$native_get_playback_params() {
        return null;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_marker_pos(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_marker_pos() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_pos_update_period(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_pos_update_period() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_position(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_position() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_latency() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_underrun_count() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_flags() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_timestamp(long[] lArray) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_loop(int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioTrack$native_get_output_sample_rate(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioTrack$native_get_min_buff_size(int n, int n2, int n3) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_attachAuxEffect(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_setAuxEffectSendLevel(float f) {
        return 0;
    }

    private final boolean $$robo$$android_media_AudioTrack$native_setOutputDevice(int n) {
        return false;
    }

    private final int $$robo$$android_media_AudioTrack$native_getRoutedDeviceId() {
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$native_enableDeviceCallback() {
    }

    private final void $$robo$$android_media_AudioTrack$native_disableDeviceCallback() {
    }

    private static final int $$robo$$android_media_AudioTrack$native_get_FCC_8() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_applyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return 0;
    }

    private final VolumeShaper.State $$robo$$android_media_AudioTrack$native_getVolumeShaperState(int n) {
        return null;
    }

    private final int $$robo$$android_media_AudioTrack$native_setPresentation(int n, int n2) {
        return 0;
    }

    private static final void $$robo$$android_media_AudioTrack$logd(String msg) {
        Log.d("android.media.AudioTrack", msg);
    }

    private static final void $$robo$$android_media_AudioTrack$loge(String msg) {
        Log.e("android.media.AudioTrack", msg);
    }

    private /* synthetic */ void $$robo$$android_media_AudioTrack$__constructor__(AudioAttributes x0, AudioFormat x1, int x2, int x3, int x4, boolean x5, 1 x6) throws IllegalArgumentException {
    }

    static void __staticInitializer__() {
        CHANNEL_COUNT_MAX = AudioTrack.native_get_FCC_8();
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(n, n2, n3, n4, n5, n6);
    }

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this(n, n2, n3, n4, n5, n6, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(int int int int int int ), this, n, n2, n3, n4, n5, n6);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(n, n2, n3, n4, n5, n6, n7);
    }

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setLegacyStreamType(n).build(), new AudioFormat.Builder().setChannelMask(n3).setEncoding(n4).setSampleRate(n2).build(), n5, n6, n7);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7);
    }

    private void __constructor__(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(audioAttributes, audioFormat, n, n2, n3);
    }

    public AudioTrack(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3) throws IllegalArgumentException {
        this(audioAttributes, audioFormat, n, n2, n3, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(android.media.AudioAttributes android.media.AudioFormat int int int ), this, audioAttributes, audioFormat, n, n2, n3);
    }

    private void __constructor__(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3, boolean bl) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(audioAttributes, audioFormat, n, n2, n3, bl);
    }

    public AudioTrack(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3, boolean bl) throws IllegalArgumentException {
        super(audioAttributes, 1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(android.media.AudioAttributes android.media.AudioFormat int int int boolean ), this, audioAttributes, audioFormat, n, n2, n3, bl);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_media_AudioTrack$__constructor__(l);
    }

    public AudioTrack(long l) {
        super(new AudioAttributes.Builder().build(), 1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(long ), this, l);
    }

    void deferred_connect(long l) {
        InvokeDynamicSupport.bootstrap("deferred_connect", $$robo$$android_media_AudioTrack$deferred_connect(long ), this, l);
    }

    private static boolean shouldEnablePowerSaving(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldEnablePowerSaving", $$robo$$android_media_AudioTrack$shouldEnablePowerSaving(android.media.AudioAttributes android.media.AudioFormat int int ), (AudioAttributes)audioAttributes, (AudioFormat)audioFormat, (int)n, (int)n2);
    }

    private void audioParamCheck(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("audioParamCheck", $$robo$$android_media_AudioTrack$audioParamCheck(int int int int int ), this, n, n2, n3, n4, n5);
    }

    private static boolean isMultichannelConfigSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMultichannelConfigSupported", $$robo$$android_media_AudioTrack$isMultichannelConfigSupported(int ), (int)n);
    }

    private void audioBuffSizeCheck(int n) {
        InvokeDynamicSupport.bootstrap("audioBuffSizeCheck", $$robo$$android_media_AudioTrack$audioBuffSizeCheck(int ), this, n);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_AudioTrack$release(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_AudioTrack$finalize(), this);
    }

    public static float getMinVolume() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getMinVolume", $$robo$$android_media_AudioTrack$getMinVolume());
    }

    public static float getMaxVolume() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getMaxVolume", $$robo$$android_media_AudioTrack$getMaxVolume());
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_media_AudioTrack$getSampleRate(), this);
    }

    public int getPlaybackRate() {
        return (int)InvokeDynamicSupport.bootstrap("getPlaybackRate", $$robo$$android_media_AudioTrack$getPlaybackRate(), this);
    }

    public PlaybackParams getPlaybackParams() {
        return InvokeDynamicSupport.bootstrap("getPlaybackParams", $$robo$$android_media_AudioTrack$getPlaybackParams(), this);
    }

    public int getAudioFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioFormat", $$robo$$android_media_AudioTrack$getAudioFormat(), this);
    }

    public int getStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getStreamType", $$robo$$android_media_AudioTrack$getStreamType(), this);
    }

    public int getChannelConfiguration() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelConfiguration", $$robo$$android_media_AudioTrack$getChannelConfiguration(), this);
    }

    public AudioFormat getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_AudioTrack$getFormat(), this);
    }

    public int getChannelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelCount", $$robo$$android_media_AudioTrack$getChannelCount(), this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_media_AudioTrack$getState(), this);
    }

    public int getPlayState() {
        return (int)InvokeDynamicSupport.bootstrap("getPlayState", $$robo$$android_media_AudioTrack$getPlayState(), this);
    }

    public int getBufferSizeInFrames() {
        return (int)InvokeDynamicSupport.bootstrap("getBufferSizeInFrames", $$robo$$android_media_AudioTrack$getBufferSizeInFrames(), this);
    }

    public int setBufferSizeInFrames(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setBufferSizeInFrames", $$robo$$android_media_AudioTrack$setBufferSizeInFrames(int ), this, n);
    }

    public int getBufferCapacityInFrames() {
        return (int)InvokeDynamicSupport.bootstrap("getBufferCapacityInFrames", $$robo$$android_media_AudioTrack$getBufferCapacityInFrames(), this);
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeFrameCount", $$robo$$android_media_AudioTrack$getNativeFrameCount(), this);
    }

    public int getNotificationMarkerPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getNotificationMarkerPosition", $$robo$$android_media_AudioTrack$getNotificationMarkerPosition(), this);
    }

    public int getPositionNotificationPeriod() {
        return (int)InvokeDynamicSupport.bootstrap("getPositionNotificationPeriod", $$robo$$android_media_AudioTrack$getPositionNotificationPeriod(), this);
    }

    public int getPlaybackHeadPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPlaybackHeadPosition", $$robo$$android_media_AudioTrack$getPlaybackHeadPosition(), this);
    }

    public int getLatency() {
        return (int)InvokeDynamicSupport.bootstrap("getLatency", $$robo$$android_media_AudioTrack$getLatency(), this);
    }

    public int getUnderrunCount() {
        return (int)InvokeDynamicSupport.bootstrap("getUnderrunCount", $$robo$$android_media_AudioTrack$getUnderrunCount(), this);
    }

    public int getPerformanceMode() {
        return (int)InvokeDynamicSupport.bootstrap("getPerformanceMode", $$robo$$android_media_AudioTrack$getPerformanceMode(), this);
    }

    public static int getNativeOutputSampleRate(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNativeOutputSampleRate", $$robo$$android_media_AudioTrack$getNativeOutputSampleRate(int ), (int)n);
    }

    public static int getMinBufferSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMinBufferSize", $$robo$$android_media_AudioTrack$getMinBufferSize(int int int ), (int)n, (int)n2, (int)n3);
    }

    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_media_AudioTrack$getAudioSessionId(), this);
    }

    public boolean getTimestamp(AudioTimestamp audioTimestamp) {
        return (boolean)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_AudioTrack$getTimestamp(android.media.AudioTimestamp ), this, audioTimestamp);
    }

    public int getTimestampWithStatus(AudioTimestamp audioTimestamp) {
        return (int)InvokeDynamicSupport.bootstrap("getTimestampWithStatus", $$robo$$android_media_AudioTrack$getTimestampWithStatus(android.media.AudioTimestamp ), this, audioTimestamp);
    }

    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_AudioTrack$getMetrics(), this);
    }

    private PersistableBundle native_getMetrics() {
        return InvokeDynamicSupport.bootstrap("native_getMetrics", $$robo$$android_media_AudioTrack$native_getMetrics(), this);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
        InvokeDynamicSupport.bootstrap("setPlaybackPositionUpdateListener", $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(android.media.AudioTrack$OnPlaybackPositionUpdateListener ), this, onPlaybackPositionUpdateListener);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setPlaybackPositionUpdateListener", $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(android.media.AudioTrack$OnPlaybackPositionUpdateListener android.os.Handler ), this, onPlaybackPositionUpdateListener, handler);
    }

    private static float clampGainOrLevel(float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("clampGainOrLevel", $$robo$$android_media_AudioTrack$clampGainOrLevel(float ), (float)f);
    }

    @Deprecated
    public int setStereoVolume(float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("setStereoVolume", $$robo$$android_media_AudioTrack$setStereoVolume(float float ), this, f, f2);
    }

    @Override
    void playerSetVolume(boolean bl, float f, float f2) {
        InvokeDynamicSupport.bootstrap("playerSetVolume", $$robo$$android_media_AudioTrack$playerSetVolume(boolean float float ), this, bl, f, f2);
    }

    public int setVolume(float f) {
        return (int)InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_AudioTrack$setVolume(float ), this, f);
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return (int)InvokeDynamicSupport.bootstrap("playerApplyVolumeShaper", $$robo$$android_media_AudioTrack$playerApplyVolumeShaper(android.media.VolumeShaper$Configuration android.media.VolumeShaper$Operation ), this, configuration, operation);
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int n) {
        return InvokeDynamicSupport.bootstrap("playerGetVolumeShaperState", $$robo$$android_media_AudioTrack$playerGetVolumeShaperState(int ), this, n);
    }

    @Override
    public VolumeShaper createVolumeShaper(VolumeShaper.Configuration configuration) {
        return InvokeDynamicSupport.bootstrap("createVolumeShaper", $$robo$$android_media_AudioTrack$createVolumeShaper(android.media.VolumeShaper$Configuration ), this, configuration);
    }

    public int setPlaybackRate(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPlaybackRate", $$robo$$android_media_AudioTrack$setPlaybackRate(int ), this, n);
    }

    public void setPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("setPlaybackParams", $$robo$$android_media_AudioTrack$setPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
    }

    public int setNotificationMarkerPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setNotificationMarkerPosition", $$robo$$android_media_AudioTrack$setNotificationMarkerPosition(int ), this, n);
    }

    public int setPositionNotificationPeriod(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPositionNotificationPeriod", $$robo$$android_media_AudioTrack$setPositionNotificationPeriod(int ), this, n);
    }

    public int setPlaybackHeadPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPlaybackHeadPosition", $$robo$$android_media_AudioTrack$setPlaybackHeadPosition(int ), this, n);
    }

    public int setLoopPoints(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("setLoopPoints", $$robo$$android_media_AudioTrack$setLoopPoints(int int int ), this, n, n2, n3);
    }

    public int setPresentation(AudioPresentation audioPresentation) {
        return (int)InvokeDynamicSupport.bootstrap("setPresentation", $$robo$$android_media_AudioTrack$setPresentation(android.media.AudioPresentation ), this, audioPresentation);
    }

    @Deprecated
    protected void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_media_AudioTrack$setState(int ), this, n);
    }

    public void play() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_AudioTrack$play(), this);
    }

    private void startImpl() {
        InvokeDynamicSupport.bootstrap("startImpl", $$robo$$android_media_AudioTrack$startImpl(), this);
    }

    public void stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_AudioTrack$stop(), this);
    }

    public void pause() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_AudioTrack$pause(), this);
    }

    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_media_AudioTrack$flush(), this);
    }

    public int write(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(byte[] int int ), this, byArray, n, n2);
    }

    public int write(byte[] byArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(byte[] int int int ), this, byArray, n, n2, n3);
    }

    public int write(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(short[] int int ), this, sArray, n, n2);
    }

    public int write(short[] sArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(short[] int int int ), this, sArray, n, n2, n3);
    }

    public int write(float[] fArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(float[] int int int ), this, fArray, n, n2, n3);
    }

    public int write(ByteBuffer byteBuffer, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(java.nio.ByteBuffer int int ), this, byteBuffer, n, n2);
    }

    public int write(ByteBuffer byteBuffer, int n, int n2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(java.nio.ByteBuffer int int long ), this, byteBuffer, n, n2, l);
    }

    public int reloadStaticData() {
        return (int)InvokeDynamicSupport.bootstrap("reloadStaticData", $$robo$$android_media_AudioTrack$reloadStaticData(), this);
    }

    public int attachAuxEffect(int n) {
        return (int)InvokeDynamicSupport.bootstrap("attachAuxEffect", $$robo$$android_media_AudioTrack$attachAuxEffect(int ), this, n);
    }

    public int setAuxEffectSendLevel(float f) {
        return (int)InvokeDynamicSupport.bootstrap("setAuxEffectSendLevel", $$robo$$android_media_AudioTrack$setAuxEffectSendLevel(float ), this, f);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean bl, float f) {
        return (int)InvokeDynamicSupport.bootstrap("playerSetAuxEffectSendLevel", $$robo$$android_media_AudioTrack$playerSetAuxEffectSendLevel(boolean float ), this, bl, f);
    }

    @Override
    public boolean setPreferredDevice(AudioDeviceInfo audioDeviceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredDevice", $$robo$$android_media_AudioTrack$setPreferredDevice(android.media.AudioDeviceInfo ), this, audioDeviceInfo);
    }

    @Override
    public AudioDeviceInfo getPreferredDevice() {
        return InvokeDynamicSupport.bootstrap("getPreferredDevice", $$robo$$android_media_AudioTrack$getPreferredDevice(), this);
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        return InvokeDynamicSupport.bootstrap("getRoutedDevice", $$robo$$android_media_AudioTrack$getRoutedDevice(), this);
    }

    private void testEnableNativeRoutingCallbacksLocked() {
        InvokeDynamicSupport.bootstrap("testEnableNativeRoutingCallbacksLocked", $$robo$$android_media_AudioTrack$testEnableNativeRoutingCallbacksLocked(), this);
    }

    private void testDisableNativeRoutingCallbacksLocked() {
        InvokeDynamicSupport.bootstrap("testDisableNativeRoutingCallbacksLocked", $$robo$$android_media_AudioTrack$testDisableNativeRoutingCallbacksLocked(), this);
    }

    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnRoutingChangedListener", $$robo$$android_media_AudioTrack$addOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener android.os.Handler ), this, onRoutingChangedListener, handler);
    }

    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnRoutingChangedListener", $$robo$$android_media_AudioTrack$removeOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener ), this, onRoutingChangedListener);
    }

    @Deprecated
    public void addOnRoutingChangedListener(OnRoutingChangedListener onRoutingChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnRoutingChangedListener", $$robo$$android_media_AudioTrack$addOnRoutingChangedListener(android.media.AudioTrack$OnRoutingChangedListener android.os.Handler ), this, onRoutingChangedListener, handler);
    }

    @Deprecated
    public void removeOnRoutingChangedListener(OnRoutingChangedListener onRoutingChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnRoutingChangedListener", $$robo$$android_media_AudioTrack$removeOnRoutingChangedListener(android.media.AudioTrack$OnRoutingChangedListener ), this, onRoutingChangedListener);
    }

    private void broadcastRoutingChange() {
        InvokeDynamicSupport.bootstrap("broadcastRoutingChange", $$robo$$android_media_AudioTrack$broadcastRoutingChange(), this);
    }

    public void setStreamEventCallback(Executor executor, StreamEventCallback streamEventCallback) {
        InvokeDynamicSupport.bootstrap("setStreamEventCallback", $$robo$$android_media_AudioTrack$setStreamEventCallback(java.util.concurrent.Executor android.media.AudioTrack$StreamEventCallback ), this, executor, streamEventCallback);
    }

    public void removeStreamEventCallback() {
        InvokeDynamicSupport.bootstrap("removeStreamEventCallback", $$robo$$android_media_AudioTrack$removeStreamEventCallback(), this);
    }

    @Override
    void playerStart() {
        InvokeDynamicSupport.bootstrap("playerStart", $$robo$$android_media_AudioTrack$playerStart(), this);
    }

    @Override
    void playerPause() {
        InvokeDynamicSupport.bootstrap("playerPause", $$robo$$android_media_AudioTrack$playerPause(), this);
    }

    @Override
    void playerStop() {
        InvokeDynamicSupport.bootstrap("playerStop", $$robo$$android_media_AudioTrack$playerStop(), this);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_AudioTrack$postEventFromNative(java.lang.Object int int int java.lang.Object ), (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private int native_setup(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, int n5, int[] nArray2, long l, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_AudioTrack$native_setup(java.lang.Object java.lang.Object int[] int int int int int int[] long boolean ), this, object, object2, nArray, n, n2, n3, n4, n5, nArray2, l, bl);
    }

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_AudioTrack$native_finalize(), this);
    }

    public void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_AudioTrack$native_release(), this);
    }

    private void native_start() {
        InvokeDynamicSupport.bootstrap("native_start", $$robo$$android_media_AudioTrack$native_start(), this);
    }

    private void native_stop() {
        InvokeDynamicSupport.bootstrap("native_stop", $$robo$$android_media_AudioTrack$native_stop(), this);
    }

    private void native_pause() {
        InvokeDynamicSupport.bootstrap("native_pause", $$robo$$android_media_AudioTrack$native_pause(), this);
    }

    private void native_flush() {
        InvokeDynamicSupport.bootstrap("native_flush", $$robo$$android_media_AudioTrack$native_flush(), this);
    }

    private int native_write_byte(byte[] byArray, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_byte", $$robo$$android_media_AudioTrack$native_write_byte(byte[] int int int boolean ), this, byArray, n, n2, n3, bl);
    }

    private int native_write_short(short[] sArray, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_short", $$robo$$android_media_AudioTrack$native_write_short(short[] int int int boolean ), this, sArray, n, n2, n3, bl);
    }

    private int native_write_float(float[] fArray, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_float", $$robo$$android_media_AudioTrack$native_write_float(float[] int int int boolean ), this, fArray, n, n2, n3, bl);
    }

    private int native_write_native_bytes(Object object, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_native_bytes", $$robo$$android_media_AudioTrack$native_write_native_bytes(java.lang.Object int int int boolean ), this, object, n, n2, n3, bl);
    }

    private int native_reload_static() {
        return (int)InvokeDynamicSupport.bootstrap("native_reload_static", $$robo$$android_media_AudioTrack$native_reload_static(), this);
    }

    private int native_get_buffer_size_frames() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_buffer_size_frames", $$robo$$android_media_AudioTrack$native_get_buffer_size_frames(), this);
    }

    private int native_set_buffer_size_frames(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_buffer_size_frames", $$robo$$android_media_AudioTrack$native_set_buffer_size_frames(int ), this, n);
    }

    private int native_get_buffer_capacity_frames() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_buffer_capacity_frames", $$robo$$android_media_AudioTrack$native_get_buffer_capacity_frames(), this);
    }

    private void native_setVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("native_setVolume", $$robo$$android_media_AudioTrack$native_setVolume(float float ), this, f, f2);
    }

    private int native_set_playback_rate(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_playback_rate", $$robo$$android_media_AudioTrack$native_set_playback_rate(int ), this, n);
    }

    private int native_get_playback_rate() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_playback_rate", $$robo$$android_media_AudioTrack$native_get_playback_rate(), this);
    }

    private void native_set_playback_params(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("native_set_playback_params", $$robo$$android_media_AudioTrack$native_set_playback_params(android.media.PlaybackParams ), this, playbackParams);
    }

    private PlaybackParams native_get_playback_params() {
        return InvokeDynamicSupport.bootstrap("native_get_playback_params", $$robo$$android_media_AudioTrack$native_get_playback_params(), this);
    }

    private int native_set_marker_pos(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_marker_pos", $$robo$$android_media_AudioTrack$native_set_marker_pos(int ), this, n);
    }

    private int native_get_marker_pos() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_marker_pos", $$robo$$android_media_AudioTrack$native_get_marker_pos(), this);
    }

    private int native_set_pos_update_period(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_pos_update_period", $$robo$$android_media_AudioTrack$native_set_pos_update_period(int ), this, n);
    }

    private int native_get_pos_update_period() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_pos_update_period", $$robo$$android_media_AudioTrack$native_get_pos_update_period(), this);
    }

    private int native_set_position(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_position", $$robo$$android_media_AudioTrack$native_set_position(int ), this, n);
    }

    private int native_get_position() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_position", $$robo$$android_media_AudioTrack$native_get_position(), this);
    }

    private int native_get_latency() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_latency", $$robo$$android_media_AudioTrack$native_get_latency(), this);
    }

    private int native_get_underrun_count() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_underrun_count", $$robo$$android_media_AudioTrack$native_get_underrun_count(), this);
    }

    private int native_get_flags() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_flags", $$robo$$android_media_AudioTrack$native_get_flags(), this);
    }

    private int native_get_timestamp(long[] lArray) {
        return (int)InvokeDynamicSupport.bootstrap("native_get_timestamp", $$robo$$android_media_AudioTrack$native_get_timestamp(long[] ), this, lArray);
    }

    private int native_set_loop(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_loop", $$robo$$android_media_AudioTrack$native_set_loop(int int int ), this, n, n2, n3);
    }

    private static int native_get_output_sample_rate(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_output_sample_rate", $$robo$$android_media_AudioTrack$native_get_output_sample_rate(int ), (int)n);
    }

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_min_buff_size", $$robo$$android_media_AudioTrack$native_get_min_buff_size(int int int ), (int)n, (int)n2, (int)n3);
    }

    private int native_attachAuxEffect(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_attachAuxEffect", $$robo$$android_media_AudioTrack$native_attachAuxEffect(int ), this, n);
    }

    private int native_setAuxEffectSendLevel(float f) {
        return (int)InvokeDynamicSupport.bootstrap("native_setAuxEffectSendLevel", $$robo$$android_media_AudioTrack$native_setAuxEffectSendLevel(float ), this, f);
    }

    private boolean native_setOutputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_setOutputDevice", $$robo$$android_media_AudioTrack$native_setOutputDevice(int ), this, n);
    }

    private int native_getRoutedDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("native_getRoutedDeviceId", $$robo$$android_media_AudioTrack$native_getRoutedDeviceId(), this);
    }

    private void native_enableDeviceCallback() {
        InvokeDynamicSupport.bootstrap("native_enableDeviceCallback", $$robo$$android_media_AudioTrack$native_enableDeviceCallback(), this);
    }

    private void native_disableDeviceCallback() {
        InvokeDynamicSupport.bootstrap("native_disableDeviceCallback", $$robo$$android_media_AudioTrack$native_disableDeviceCallback(), this);
    }

    private static int native_get_FCC_8() {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_FCC_8", $$robo$$android_media_AudioTrack$native_get_FCC_8());
    }

    private int native_applyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return (int)InvokeDynamicSupport.bootstrap("native_applyVolumeShaper", $$robo$$android_media_AudioTrack$native_applyVolumeShaper(android.media.VolumeShaper$Configuration android.media.VolumeShaper$Operation ), this, configuration, operation);
    }

    private VolumeShaper.State native_getVolumeShaperState(int n) {
        return InvokeDynamicSupport.bootstrap("native_getVolumeShaperState", $$robo$$android_media_AudioTrack$native_getVolumeShaperState(int ), this, n);
    }

    private int native_setPresentation(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setPresentation", $$robo$$android_media_AudioTrack$native_setPresentation(int int ), this, n, n2);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_media_AudioTrack$logd(java.lang.String ), (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$android_media_AudioTrack$loge(java.lang.String ), (String)string2);
    }

    private /* synthetic */ void __constructor__(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3, boolean bl, 1 var7_7) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(audioAttributes, audioFormat, n, n2, n3, bl, var7_7);
    }

    public /* synthetic */ AudioTrack(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3, boolean bl, 1 var7_7) throws IllegalArgumentException {
        this(audioAttributes, audioFormat, n, n2, n3, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(android.media.AudioAttributes android.media.AudioFormat int int int boolean android.media.AudioTrack$1 ), this, audioAttributes, audioFormat, n, n2, n3, bl, var7_7);
    }

    static {
        RobolectricInternals.classInitializing(AudioTrack.class);
    }

    public /* synthetic */ AudioTrack() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioTrack)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MetricsConstants
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static String STREAMTYPE = "android.media.audiotrack.streamtype";
        public static String CONTENTTYPE = "android.media.audiotrack.type";
        public static String USAGE = "android.media.audiotrack.usage";
        public static String SAMPLERATE = "android.media.audiorecord.samplerate";
        public static String CHANNELMASK = "android.media.audiorecord.channelmask";

        private void $$robo$$android_media_AudioTrack_MetricsConstants$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioTrack_MetricsConstants$__constructor__();
        }

        public MetricsConstants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_MetricsConstants$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsConstants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NativePositionEventHandlerDelegate
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        /* synthetic */ AudioTrack this$0;

        private void $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate$__constructor__(AudioTrack audioTrack, AudioTrack track, OnPlaybackPositionUpdateListener listener, Handler handler) {
            this.this$0 = audioTrack;
            Looper looper = handler != null ? handler.getLooper() : audioTrack.mInitializationLooper;
            this.mHandler = looper != null ? new ShadowedObject(this, looper, audioTrack, track, listener){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioTrack val$this$0;
                /* synthetic */ AudioTrack val$track;
                /* synthetic */ OnPlaybackPositionUpdateListener val$listener;
                /* synthetic */ NativePositionEventHandlerDelegate this$1;

                private void $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate_1$__constructor__(NativePositionEventHandlerDelegate this$1, Looper x0, AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
                    this.this$1 = this$1;
                    this.val$this$0 = audioTrack;
                    this.val$track = audioTrack2;
                    this.val$listener = onPlaybackPositionUpdateListener;
                }

                private final void $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate_1$handleMessage(Message msg) {
                    if (this.val$track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            if (this.val$listener == null) break;
                            this.val$listener.onMarkerReached(this.val$track);
                            break;
                        }
                        case 4: {
                            if (this.val$listener == null) break;
                            this.val$listener.onPeriodicNotification(this.val$track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }

                private void __constructor__(NativePositionEventHandlerDelegate nativePositionEventHandlerDelegate, Looper looper, AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
                    this.$$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate_1$__constructor__(nativePositionEventHandlerDelegate, looper, audioTrack, audioTrack2, onPlaybackPositionUpdateListener);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate_1$__constructor__(android.media.AudioTrack$NativePositionEventHandlerDelegate android.os.Looper android.media.AudioTrack android.media.AudioTrack android.media.AudioTrack$OnPlaybackPositionUpdateListener ), this, nativePositionEventHandlerDelegate, looper, audioTrack, audioTrack2, onPlaybackPositionUpdateListener);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate_1$handleMessage(android.os.Message ), this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
        }

        private final Handler $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
            this.$$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate$__constructor__(audioTrack, audioTrack2, onPlaybackPositionUpdateListener, handler);
        }

        public NativePositionEventHandlerDelegate(AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate$__constructor__(android.media.AudioTrack android.media.AudioTrack android.media.AudioTrack$OnPlaybackPositionUpdateListener android.os.Handler ), this, audioTrack, audioTrack2, onPlaybackPositionUpdateListener, handler);
        }

        Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_media_AudioTrack_NativePositionEventHandlerDelegate$getHandler(), this);
        }

        public /* synthetic */ NativePositionEventHandlerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativePositionEventHandlerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class StreamEventCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_AudioTrack_StreamEventCallback$__constructor__() {
        }

        private final void $$robo$$android_media_AudioTrack_StreamEventCallback$onTearDown(AudioTrack track) {
        }

        private final void $$robo$$android_media_AudioTrack_StreamEventCallback$onStreamPresentationEnd(AudioTrack track) {
        }

        private final void $$robo$$android_media_AudioTrack_StreamEventCallback$onStreamDataRequest(AudioTrack track) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioTrack_StreamEventCallback$__constructor__();
        }

        public StreamEventCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_StreamEventCallback$__constructor__(), this);
        }

        public void onTearDown(AudioTrack audioTrack) {
            InvokeDynamicSupport.bootstrap("onTearDown", $$robo$$android_media_AudioTrack_StreamEventCallback$onTearDown(android.media.AudioTrack ), this, audioTrack);
        }

        public void onStreamPresentationEnd(AudioTrack audioTrack) {
            InvokeDynamicSupport.bootstrap("onStreamPresentationEnd", $$robo$$android_media_AudioTrack_StreamEventCallback$onStreamPresentationEnd(android.media.AudioTrack ), this, audioTrack);
        }

        public void onStreamDataRequest(AudioTrack audioTrack) {
            InvokeDynamicSupport.bootstrap("onStreamDataRequest", $$robo$$android_media_AudioTrack_StreamEventCallback$onStreamDataRequest(android.media.AudioTrack ), this, audioTrack);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamEventCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }

    @Deprecated
    public static interface OnRoutingChangedListener
    extends AudioRouting.OnRoutingChangedListener {
        public void onRoutingChanged(AudioTrack var1);

        @Override
        default public void onRoutingChanged(AudioRouting router) {
            if (router instanceof AudioTrack) {
                this.onRoutingChanged((AudioTrack)router);
            }
        }
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AudioAttributes mAttributes;
        private AudioFormat mFormat;
        private int mBufferSizeInBytes;
        private int mSessionId;
        private int mMode;
        private int mPerformanceMode;
        private boolean mOffload;

        private void $$robo$$android_media_AudioTrack_Builder$__constructor__() {
            this.mSessionId = 0;
            this.mMode = 1;
            this.mPerformanceMode = 0;
            this.mOffload = false;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            this.mAttributes = attributes;
            return this;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setAudioFormat(AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            if (bufferSizeInBytes <= 0) {
                throw new IllegalArgumentException("Invalid buffer size " + bufferSizeInBytes);
            }
            this.mBufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setTransferMode(int mode) throws IllegalArgumentException {
            switch (mode) {
                case 0: 
                case 1: {
                    this.mMode = mode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transfer mode " + mode);
                }
            }
            return this;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setSessionId(int sessionId) throws IllegalArgumentException {
            if (sessionId != 0 && sessionId < 1) {
                throw new IllegalArgumentException("Invalid audio session ID " + sessionId);
            }
            this.mSessionId = sessionId;
            return this;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setPerformanceMode(int performanceMode) {
            switch (performanceMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.mPerformanceMode = performanceMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid performance mode " + performanceMode);
                }
            }
            return this;
        }

        private final Builder $$robo$$android_media_AudioTrack_Builder$setOffloadedPlayback(boolean offload) {
            this.mOffload = offload;
            return this;
        }

        private final AudioTrack $$robo$$android_media_AudioTrack_Builder$build() throws UnsupportedOperationException {
            if (this.mAttributes == null) {
                this.mAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            switch (this.mPerformanceMode) {
                case 1: {
                    this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x100) & 0xFFFFFDFF).build();
                    break;
                }
                case 0: {
                    if (!AudioTrack.shouldEnablePowerSaving(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode)) break;
                }
                case 2: {
                    this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x200) & 0xFFFFFEFF).build();
                }
            }
            if (this.mFormat == null) {
                this.mFormat = new AudioFormat.Builder().setChannelMask(12).setEncoding(1).build();
            }
            if (this.mOffload) {
                if (this.mAttributes.getUsage() != 1) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack, offload requires USAGE_MEDIA");
                }
                if (!AudioSystem.isOffloadSupported(this.mFormat)) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack, offload format not supported");
                }
            }
            try {
                AudioTrack track;
                if (this.mMode == 1 && this.mBufferSizeInBytes == 0) {
                    this.mBufferSizeInBytes = this.mFormat.getChannelCount() * AudioFormat.getBytesPerSample(this.mFormat.getEncoding());
                }
                if ((track = new AudioTrack(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode, this.mSessionId, this.mOffload, null)).getState() == 0) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack");
                }
                return track;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioTrack_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_Builder$__constructor__(), this);
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_AudioTrack_Builder$setAudioAttributes(android.media.AudioAttributes ), this, audioAttributes);
        }

        public Builder setAudioFormat(AudioFormat audioFormat) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioFormat", $$robo$$android_media_AudioTrack_Builder$setAudioFormat(android.media.AudioFormat ), this, audioFormat);
        }

        public Builder setBufferSizeInBytes(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setBufferSizeInBytes", $$robo$$android_media_AudioTrack_Builder$setBufferSizeInBytes(int ), this, n);
        }

        public Builder setTransferMode(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setTransferMode", $$robo$$android_media_AudioTrack_Builder$setTransferMode(int ), this, n);
        }

        public Builder setSessionId(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setSessionId", $$robo$$android_media_AudioTrack_Builder$setSessionId(int ), this, n);
        }

        public Builder setPerformanceMode(int n) {
            return InvokeDynamicSupport.bootstrap("setPerformanceMode", $$robo$$android_media_AudioTrack_Builder$setPerformanceMode(int ), this, n);
        }

        public Builder setOffloadedPlayback(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setOffloadedPlayback", $$robo$$android_media_AudioTrack_Builder$setOffloadedPlayback(boolean ), this, bl);
        }

        public AudioTrack build() throws UnsupportedOperationException {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_AudioTrack_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PerformanceMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WriteMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransferMode {
    }
}

