/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.location.Address;
import android.location.GeocoderParams;
import android.location.ILocationManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Geocoder
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Geocoder";
    private GeocoderParams mParams;
    private ILocationManager mService;

    private static final boolean $$robo$$android_location_Geocoder$isPresent() {
        IBinder b = ServiceManager.getService("location");
        ILocationManager lm = ILocationManager.Stub.asInterface(b);
        try {
            return lm.geocoderIsPresent();
        }
        catch (RemoteException e) {
            Log.e("Geocoder", "isPresent: got RemoteException", e);
            return false;
        }
    }

    private void $$robo$$android_location_Geocoder$__constructor__(Context context, Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        this.mParams = new GeocoderParams(context, locale);
        IBinder b = ServiceManager.getService("location");
        this.mService = ILocationManager.Stub.asInterface(b);
    }

    private void $$robo$$android_location_Geocoder$__constructor__(Context context) {
    }

    private final List<Address> $$robo$$android_location_Geocoder$getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("latitude == " + latitude);
        }
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("longitude == " + longitude);
        }
        try {
            ArrayList<Address> results = new ArrayList<Address>();
            String ex = this.mService.getFromLocation(latitude, longitude, maxResults, this.mParams, results);
            if (ex != null) {
                throw new IOException(ex);
            }
            return results;
        }
        catch (RemoteException e) {
            Log.e("Geocoder", "getFromLocation: got RemoteException", e);
            return null;
        }
    }

    private final List<Address> $$robo$$android_location_Geocoder$getFromLocationName(String locationName, int maxResults) throws IOException {
        if (locationName == null) {
            throw new IllegalArgumentException("locationName == null");
        }
        try {
            ArrayList<Address> results = new ArrayList<Address>();
            String ex = this.mService.getFromLocationName(locationName, 0.0, 0.0, 0.0, 0.0, maxResults, this.mParams, results);
            if (ex != null) {
                throw new IOException(ex);
            }
            return results;
        }
        catch (RemoteException e) {
            Log.e("Geocoder", "getFromLocationName: got RemoteException", e);
            return null;
        }
    }

    private final List<Address> $$robo$$android_location_Geocoder$getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws IOException {
        if (locationName == null) {
            throw new IllegalArgumentException("locationName == null");
        }
        if (lowerLeftLatitude < -90.0 || lowerLeftLatitude > 90.0) {
            throw new IllegalArgumentException("lowerLeftLatitude == " + lowerLeftLatitude);
        }
        if (lowerLeftLongitude < -180.0 || lowerLeftLongitude > 180.0) {
            throw new IllegalArgumentException("lowerLeftLongitude == " + lowerLeftLongitude);
        }
        if (upperRightLatitude < -90.0 || upperRightLatitude > 90.0) {
            throw new IllegalArgumentException("upperRightLatitude == " + upperRightLatitude);
        }
        if (upperRightLongitude < -180.0 || upperRightLongitude > 180.0) {
            throw new IllegalArgumentException("upperRightLongitude == " + upperRightLongitude);
        }
        try {
            ArrayList<Address> result = new ArrayList<Address>();
            String ex = this.mService.getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, this.mParams, result);
            if (ex != null) {
                throw new IOException(ex);
            }
            return result;
        }
        catch (RemoteException e) {
            Log.e("Geocoder", "getFromLocationName: got RemoteException", e);
            return null;
        }
    }

    public static boolean isPresent() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPresent", $$robo$$android_location_Geocoder$isPresent());
    }

    private void __constructor__(Context context, Locale locale) {
        this.$$robo$$android_location_Geocoder$__constructor__(context, locale);
    }

    public Geocoder(Context context, Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Geocoder$__constructor__(android.content.Context java.util.Locale ), this, context, locale);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_location_Geocoder$__constructor__(context);
    }

    public Geocoder(Context context) {
        this(context, Locale.getDefault());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Geocoder$__constructor__(android.content.Context ), this, context);
    }

    public List<Address> getFromLocation(double d, double d2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("getFromLocation", $$robo$$android_location_Geocoder$getFromLocation(double double int ), this, d, d2, n);
    }

    public List<Address> getFromLocationName(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("getFromLocationName", $$robo$$android_location_Geocoder$getFromLocationName(java.lang.String int ), this, string2, n);
    }

    public List<Address> getFromLocationName(String string2, int n, double d, double d2, double d3, double d4) throws IOException {
        return InvokeDynamicSupport.bootstrap("getFromLocationName", $$robo$$android_location_Geocoder$getFromLocationName(java.lang.String int double double double double ), this, string2, n, d, d2, d3, d4);
    }

    public /* synthetic */ Geocoder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Geocoder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

