/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.IInputMethodSessionWrapper;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.InputChannel;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InputConnectionWrapper;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IInputMethodWrapper
extends IInputMethod.Stub
implements HandlerCaller.Callback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "InputMethodWrapper";
    private static int DO_DUMP = 1;
    private static int DO_ATTACH_TOKEN = 10;
    private static int DO_SET_INPUT_CONTEXT = 20;
    private static int DO_UNSET_INPUT_CONTEXT = 30;
    private static int DO_START_INPUT = 32;
    private static int DO_CREATE_SESSION = 40;
    private static int DO_SET_SESSION_ENABLED = 45;
    private static int DO_REVOKE_SESSION = 50;
    private static int DO_SHOW_SOFT_INPUT = 60;
    private static int DO_HIDE_SOFT_INPUT = 70;
    private static int DO_CHANGE_INPUTMETHOD_SUBTYPE = 80;
    WeakReference<AbstractInputMethodService> mTarget;
    Context mContext;
    HandlerCaller mCaller;
    WeakReference<InputMethod> mInputMethod;
    int mTargetSdkVersion;
    AtomicBoolean mIsUnbindIssued;

    private void $$robo$$android_inputmethodservice_IInputMethodWrapper$__constructor__(AbstractInputMethodService context, InputMethod inputMethod) {
        this.mIsUnbindIssued = null;
        this.mTarget = new WeakReference<AbstractInputMethodService>(context);
        this.mContext = context.getApplicationContext();
        this.mCaller = new HandlerCaller(this.mContext, null, this, true);
        this.mInputMethod = new WeakReference<InputMethod>(inputMethod);
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$executeMessage(Message msg) {
        InputMethod inputMethod = (InputMethod)this.mInputMethod.get();
        if (inputMethod == null && msg.what != 1) {
            Log.w("InputMethodWrapper", "Input method reference was null, ignoring message: " + msg.what);
            return;
        }
        switch (msg.what) {
            case 1: {
                AbstractInputMethodService target = (AbstractInputMethodService)this.mTarget.get();
                if (target == null) {
                    return;
                }
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    target.dump((FileDescriptor)args.arg1, (PrintWriter)args.arg2, (String[])args.arg3);
                }
                catch (RuntimeException e) {
                    ((PrintWriter)args.arg2).println("Exception: " + e);
                }
                Object e = args.arg4;
                synchronized (e) {
                    ((CountDownLatch)args.arg4).countDown();
                }
                args.recycle();
                return;
            }
            case 10: {
                inputMethod.attachToken((IBinder)msg.obj);
                return;
            }
            case 20: {
                inputMethod.bindInput((InputBinding)msg.obj);
                return;
            }
            case 30: {
                inputMethod.unbindInput();
                return;
            }
            case 32: {
                SomeArgs args = (SomeArgs)msg.obj;
                int missingMethods = msg.arg1;
                boolean restarting = msg.arg2 != 0;
                IBinder startInputToken = (IBinder)args.arg1;
                IInputContext inputContext = (IInputContext)args.arg2;
                EditorInfo info = (EditorInfo)args.arg3;
                AtomicBoolean isUnbindIssued = (AtomicBoolean)args.arg4;
                InputConnectionWrapper ic = inputContext != null ? new InputConnectionWrapper(this.mTarget, inputContext, missingMethods, isUnbindIssued) : null;
                info.makeCompatible(this.mTargetSdkVersion);
                inputMethod.dispatchStartInputWithToken(ic, info, restarting, startInputToken);
                args.recycle();
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                inputMethod.createSession(new InputMethodSessionCallbackWrapper(this.mContext, (InputChannel)args.arg1, (IInputSessionCallback)args.arg2));
                args.recycle();
                return;
            }
            case 45: {
                inputMethod.setSessionEnabled((InputMethodSession)msg.obj, msg.arg1 != 0);
                return;
            }
            case 50: {
                inputMethod.revokeSession((InputMethodSession)msg.obj);
                return;
            }
            case 60: {
                inputMethod.showSoftInput(msg.arg1, (ResultReceiver)msg.obj);
                return;
            }
            case 70: {
                inputMethod.hideSoftInput(msg.arg1, (ResultReceiver)msg.obj);
                return;
            }
            case 80: {
                inputMethod.changeInputMethodSubtype((InputMethodSubtype)msg.obj);
                return;
            }
        }
        Log.w("InputMethodWrapper", "Unhandled message code: " + msg.what);
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        AbstractInputMethodService target = (AbstractInputMethodService)this.mTarget.get();
        if (target == null) {
            return;
        }
        if (target.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            fout.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOOOO(1, fd, fout, args, latch));
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                fout.println("Timeout waiting for dump");
            }
        }
        catch (InterruptedException e) {
            fout.println("Interrupted waiting for dump");
        }
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$attachToken(IBinder token) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(10, token));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$bindInput(InputBinding binding) {
        if (this.mIsUnbindIssued != null) {
            Log.e("InputMethodWrapper", "bindInput must be paired with unbindInput.");
        }
        this.mIsUnbindIssued = new AtomicBoolean();
        boolean missingMethodFlags = false;
        InputConnectionWrapper ic = new InputConnectionWrapper(this.mTarget, IInputContext.Stub.asInterface(binding.getConnectionToken()), 0, this.mIsUnbindIssued);
        InputBinding nu = new InputBinding(ic, binding);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(20, nu));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$unbindInput() {
        if (this.mIsUnbindIssued != null) {
            this.mIsUnbindIssued.set(true);
            this.mIsUnbindIssued = null;
        } else {
            Log.e("InputMethodWrapper", "unbindInput must be paired with bindInput.");
        }
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(30));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$startInput(IBinder startInputToken, IInputContext inputContext, int missingMethods, EditorInfo attribute, boolean restarting) {
        if (this.mIsUnbindIssued == null) {
            Log.e("InputMethodWrapper", "startInput must be called after bindInput.");
            this.mIsUnbindIssued = new AtomicBoolean();
        }
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIOOOO(32, missingMethods, restarting ? 1 : 0, startInputToken, inputContext, attribute, this.mIsUnbindIssued));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$createSession(InputChannel channel, IInputSessionCallback callback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(40, channel, callback));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$setSessionEnabled(IInputMethodSession session, boolean enabled) {
        try {
            InputMethodSession ls = ((IInputMethodSessionWrapper)session).getInternalInputMethodSession();
            if (ls == null) {
                Log.w("InputMethodWrapper", "Session is already finished: " + session);
                return;
            }
            this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(45, enabled ? 1 : 0, ls));
        }
        catch (ClassCastException e) {
            Log.w("InputMethodWrapper", "Incoming session not of correct type: " + session, e);
        }
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$revokeSession(IInputMethodSession session) {
        try {
            InputMethodSession ls = ((IInputMethodSessionWrapper)session).getInternalInputMethodSession();
            if (ls == null) {
                Log.w("InputMethodWrapper", "Session is already finished: " + session);
                return;
            }
            this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(50, ls));
        }
        catch (ClassCastException e) {
            Log.w("InputMethodWrapper", "Incoming session not of correct type: " + session, e);
        }
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$showSoftInput(int flags, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(60, flags, resultReceiver));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$hideSoftInput(int flags, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(70, flags, resultReceiver));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodWrapper$changeInputMethodSubtype(InputMethodSubtype subtype) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(80, subtype));
    }

    private void __constructor__(AbstractInputMethodService abstractInputMethodService, InputMethod inputMethod) {
        this.$$robo$$android_inputmethodservice_IInputMethodWrapper$__constructor__(abstractInputMethodService, inputMethod);
    }

    public IInputMethodWrapper(AbstractInputMethodService abstractInputMethodService, InputMethod inputMethod) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_IInputMethodWrapper$__constructor__(android.inputmethodservice.AbstractInputMethodService android.view.inputmethod.InputMethod ), this, abstractInputMethodService, inputMethod);
    }

    @Override
    public void executeMessage(Message message) {
        InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_inputmethodservice_IInputMethodWrapper$executeMessage(android.os.Message ), this, message);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_inputmethodservice_IInputMethodWrapper$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public void attachToken(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("attachToken", $$robo$$android_inputmethodservice_IInputMethodWrapper$attachToken(android.os.IBinder ), this, iBinder);
    }

    @Override
    public void bindInput(InputBinding inputBinding) {
        InvokeDynamicSupport.bootstrap("bindInput", $$robo$$android_inputmethodservice_IInputMethodWrapper$bindInput(android.view.inputmethod.InputBinding ), this, inputBinding);
    }

    @Override
    public void unbindInput() {
        InvokeDynamicSupport.bootstrap("unbindInput", $$robo$$android_inputmethodservice_IInputMethodWrapper$unbindInput(), this);
    }

    @Override
    public void startInput(IBinder iBinder, IInputContext iInputContext, int n, EditorInfo editorInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("startInput", $$robo$$android_inputmethodservice_IInputMethodWrapper$startInput(android.os.IBinder com.android.internal.view.IInputContext int android.view.inputmethod.EditorInfo boolean ), this, iBinder, iInputContext, n, editorInfo, bl);
    }

    @Override
    public void createSession(InputChannel inputChannel, IInputSessionCallback iInputSessionCallback) {
        InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_inputmethodservice_IInputMethodWrapper$createSession(android.view.InputChannel com.android.internal.view.IInputSessionCallback ), this, inputChannel, iInputSessionCallback);
    }

    @Override
    public void setSessionEnabled(IInputMethodSession iInputMethodSession, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSessionEnabled", $$robo$$android_inputmethodservice_IInputMethodWrapper$setSessionEnabled(com.android.internal.view.IInputMethodSession boolean ), this, iInputMethodSession, bl);
    }

    @Override
    public void revokeSession(IInputMethodSession iInputMethodSession) {
        InvokeDynamicSupport.bootstrap("revokeSession", $$robo$$android_inputmethodservice_IInputMethodWrapper$revokeSession(com.android.internal.view.IInputMethodSession ), this, iInputMethodSession);
    }

    @Override
    public void showSoftInput(int n, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("showSoftInput", $$robo$$android_inputmethodservice_IInputMethodWrapper$showSoftInput(int android.os.ResultReceiver ), this, n, resultReceiver);
    }

    @Override
    public void hideSoftInput(int n, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("hideSoftInput", $$robo$$android_inputmethodservice_IInputMethodWrapper$hideSoftInput(int android.os.ResultReceiver ), this, n, resultReceiver);
    }

    @Override
    public void changeInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
        InvokeDynamicSupport.bootstrap("changeInputMethodSubtype", $$robo$$android_inputmethodservice_IInputMethodWrapper$changeInputMethodSubtype(android.view.inputmethod.InputMethodSubtype ), this, inputMethodSubtype);
    }

    public /* synthetic */ IInputMethodWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IInputMethodWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class InputMethodSessionCallbackWrapper
    implements InputMethod.SessionCallback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Context mContext;
        InputChannel mChannel;
        IInputSessionCallback mCb;

        private void $$robo$$android_inputmethodservice_IInputMethodWrapper_InputMethodSessionCallbackWrapper$__constructor__(Context context, InputChannel channel, IInputSessionCallback cb) {
            this.mContext = context;
            this.mChannel = channel;
            this.mCb = cb;
        }

        private final void $$robo$$android_inputmethodservice_IInputMethodWrapper_InputMethodSessionCallbackWrapper$sessionCreated(InputMethodSession session) {
            try {
                if (session != null) {
                    IInputMethodSessionWrapper wrap = new IInputMethodSessionWrapper(this.mContext, session, this.mChannel);
                    this.mCb.sessionCreated(wrap);
                } else {
                    if (this.mChannel != null) {
                        this.mChannel.dispose();
                    }
                    this.mCb.sessionCreated(null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private void __constructor__(Context context, InputChannel inputChannel, IInputSessionCallback iInputSessionCallback) {
            this.$$robo$$android_inputmethodservice_IInputMethodWrapper_InputMethodSessionCallbackWrapper$__constructor__(context, inputChannel, iInputSessionCallback);
        }

        public InputMethodSessionCallbackWrapper(Context context, InputChannel inputChannel, IInputSessionCallback iInputSessionCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_IInputMethodWrapper_InputMethodSessionCallbackWrapper$__constructor__(android.content.Context android.view.InputChannel com.android.internal.view.IInputSessionCallback ), this, context, inputChannel, iInputSessionCallback);
        }

        @Override
        public void sessionCreated(InputMethodSession inputMethodSession) {
            InvokeDynamicSupport.bootstrap("sessionCreated", $$robo$$android_inputmethodservice_IInputMethodWrapper_InputMethodSessionCallbackWrapper$sessionCreated(android.view.inputmethod.InputMethodSession ), this, inputMethodSession);
        }

        public /* synthetic */ InputMethodSessionCallbackWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodSessionCallbackWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

